---
title: Scheduling issue creation
shortTitle: Schedule issue creation
intro: 'You can use {% data variables.product.prodname_actions %} to create an issue on a regular basis for things like daily meetings or quarterly reviews.'
redirect_from:
  - /actions/guides/scheduling-issue-creation
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
type: tutorial
topics:
  - Workflows
  - Project management
---

{% data reusables.actions.enterprise-beta %}
{% data reusables.actions.enterprise-github-hosted-runners %}

## Introduction

This tutorial demonstrates how to use the [`imjohnbo/issue-bot` action](https://github.com/marketplace/actions/issue-bot-action) to create an issue on a regular basis. For example, you can create an issue each week to use as the agenda for a team meeting.

In the tutorial, you will first make a workflow file that uses the [`imjohnbo/issue-bot` action](https://github.com/marketplace/actions/issue-bot-action). Then, you will customize the workflow to suit your needs.

## Creating the workflow

1. {% data reusables.actions.choose-repo %}
2. {% data reusables.actions.make-workflow-file %}
3. Copy the following YAML contents into your workflow file.

    ```yaml{:copy}
{% indented_data_reference reusables.actions.actions-not-certified-by-github-comment spaces=4 %}

{% indented_data_reference reusables.actions.actions-use-sha-pinning-comment spaces=4 %}
    
    name: Weekly Team Sync
    on:
      schedule:
        - cron: 20 07 * * 1

    jobs:
      create_issue:
        name: Create team sync issue
        runs-on: ubuntu-latest
        permissions:
          issues: write
        steps:
          - name: Create team sync issue
            uses: imjohnbo/issue-bot@3daae12aa54d38685d7ff8459fc8a2aee8cea98b
            with:
              assignees: "monalisa, doctocat, hubot"
              labels: "weekly sync, docs-team"
              title: "Team sync"
              body: |
                ### Agenda

                - [ ] Start the recording
                - [ ] Check-ins
                - [ ] Discussion points
                - [ ] Post the recording
                        
                ### Discussion Points
                Add things to discuss below

                - [Work this week](https://github.com/orgs/github/projects/3)
              pinned: false
              close-previous: false
            env:
              GITHUB_TOKEN: {% raw %}${{ secrets.GITHUB_TOKEN }}{% endraw %}
    ```

4. Customize the parameters in your workflow file:
   - Change the value for `on.schedule` to dictate when you want this workflow to run. In the example above, the workflow will run every Monday at 7:20 UTC. For more information about scheduled workflows, see "[Scheduled events](/actions/reference/events-that-trigger-workflows#scheduled-events)."
   - Change the value for `assignees` to the list of {% data variables.product.prodname_dotcom %} usernames that you want to assign to the issue.
   - Change the value for `labels` to the list of labels that you want to apply to the issue.
   - Change the value for `title` to the title that you want the issue to have.
   - Change the value for `body` to the text that you want in the issue body. The `|` character allows you to use a multi-line value for this parameter.
   - If you want to pin this issue in your repository, set `pinned` to `true`. For more information about pinned issues, see "[Pinning an issue to your repository](/articles/pinning-an-issue-to-your-repository)."
   - If you want to close the previous issue generated by this workflow each time a new issue is created, set `close-previous` to `true`. The workflow will close the most recent issue that has the labels defined in the `labels` field. To avoid closing the wrong issue, use a unique label or combination of labels.
5. {% data reusables.actions.commit-workflow %}

## Expected results

Based on the `schedule` parameter (for example, every Monday at 7:20 UTC), your workflow will create a new issue with the assignees, labels, title, and body that you specified. If you set `pinned` to `true`, the workflow will pin the issue to your repository. If you set `close-previous` to true, the workflow will close the most recent issue with matching labels.

{% data reusables.actions.schedule-delay %}

You can view the history of your workflow runs to see this workflow run periodically. For more information, see "[Viewing workflow run history](/actions/managing-workflow-runs/viewing-workflow-run-history)."

## Next steps

- To learn more about additional things you can do with the `imjohnbo/issue-bot` action, like rotating assignees or using an issue template, see the [`imjohnbo/issue-bot` action documentation](https://github.com/marketplace/actions/issue-bot-action).
- [Search GitHub](https://github.com/search?q=%22uses%3A+imjohnbo%2Fissue-bot%22&type=code) for examples of workflows using this action.
