---
title: GitHub Actions Documentation
shortTitle: GitHub Actions
intro: 'Automate, customize, and execute your software development workflows right in your repository with {% data variables.product.prodname_actions %}. You can discover, create, and share actions to perform any job you''d like, including CI/CD, and combine actions in a completely customized workflow.'
introLinks:
  overview: /actions/learn-github-actions/understanding-github-actions
  quickstart: /actions/quickstart
featuredLinks:
  startHere:
    - /actions/learn-github-actions
    - /actions/examples
    - /actions/automating-builds-and-tests/about-continuous-integration
    - /actions/deployment/about-deployments/deploying-with-github-actions
    - /actions/publishing-packages/about-packaging-with-github-actions
    - /actions/monitoring-and-troubleshooting-workflows/about-monitoring-and-troubleshooting
  guideCards:
    - /actions/using-workflows/using-starter-workflows
    - /actions/publishing-packages/publishing-nodejs-packages
    - /actions/automating-builds-and-tests/building-and-testing-powershell
  popular:
    - /actions/using-workflows/workflow-syntax-for-github-actions
    - /actions/learn-github-actions
    - /actions/examples
    - /actions/using-workflows/events-that-trigger-workflows
    - /actions/learn-github-actions/contexts
    - /actions/learn-github-actions/expressions
    - /actions/learn-github-actions/variables
    - /actions/security-guides/encrypted-secrets
changelog:
  label: actions
product_video: 'https://www.youtube-nocookie.com/embed/cP0I9w2coGU'
redirect_from:
  - /articles/automating-your-workflow-with-github-actions
  - /articles/customizing-your-project-with-github-actions
  - /github/automating-your-workflow-with-github-actions
  - /actions/automating-your-workflow-with-github-actions
  - /categories/automating-your-workflow-with-github-actions
  - /marketplace/actions
  - /actions/reference
layout: product-landing
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
children:
  - /quickstart
  - /learn-github-actions
  - /examples
  - /using-workflows
  - /using-jobs
  - /managing-workflow-runs
  - /automating-builds-and-tests
  - /deployment
  - /using-containerized-services
  - /publishing-packages
  - /managing-issues-and-pull-requests
  - /migrating-to-github-actions
  - /monitoring-and-troubleshooting-workflows
  - /using-github-hosted-runners
  - /hosting-your-own-runners
  - /security-guides
  - /creating-actions
  - /guides
---

