---
title: Guides for GitHub Actions
intro: 'These guides for {% data variables.product.prodname_actions %} include specific use cases and examples to help you configure workflows.'
allowTitleToDifferFromFilename: true
layout: product-guides
versions:
  fpt: '*'
  ghes: '*'
  ghae: '*'
  ghec: '*'
learningTracks:
  - getting_started
  - adopting_github_actions_for_your_enterprise_ghec
  - adopting_github_actions_for_your_enterprise_ghes_and_ghae
  - hosting_your_own_runners
  - create_actions
includeGuides:
  - /actions/quickstart
  - /actions/learn-github-actions/introduction-to-github-actions
  - /actions/creating-actions/creating-a-docker-container-action
  - /actions/learn-github-actions/using-starter-workflows
  - /actions/automating-builds-and-tests/building-and-testing-python
  - /actions/automating-builds-and-tests/building-and-testing-nodejs
  - /actions/publishing-packages/about-packaging-with-github-actions
  - /actions/publishing-packages/publishing-docker-images
  - /actions/advanced-guides/caching-dependencies-to-speed-up-workflows
  - /actions/automating-builds-and-tests/about-continuous-integration
  - /actions/automating-builds-and-tests/building-and-testing-powershell
  - /actions/automating-builds-and-tests/building-and-testing-ruby
  - /actions/automating-builds-and-tests/building-and-testing-java-with-maven
  - /actions/automating-builds-and-tests/building-and-testing-java-with-gradle
  - /actions/automating-builds-and-tests/building-and-testing-java-with-ant
  - /actions/automating-builds-and-tests/building-and-testing-swift
  - /actions/deployment/installing-an-apple-certificate-on-macos-runners-for-xcode-development
  - /actions/automating-builds-and-tests/building-and-testing-xamarin-applications
  - /actions/publishing-packages/publishing-nodejs-packages
  - /actions/publishing-packages/publishing-java-packages-with-maven
  - /actions/publishing-packages/publishing-java-packages-with-gradle
  - /actions/advanced-guides/storing-workflow-data-as-artifacts
  - /actions/using-containerized-services/about-service-containers
  - /actions/using-containerized-services/creating-redis-service-containers
  - /actions/using-containerized-services/creating-postgresql-service-containers
  - /actions/deployment/deploying-to-amazon-elastic-container-service
  - /actions/deployment/deploying-to-google-kubernetes-engine
  - /actions/learn-github-actions/essential-features-of-github-actions
  - /actions/security-guides/security-hardening-for-github-actions
  - /actions/creating-actions/about-custom-actions
  - /actions/creating-actions/creating-a-javascript-action
  - /actions/creating-actions/creating-a-composite-action
  - /actions/migrating-to-github-actions/migrating-from-azure-pipelines-to-github-actions
  - /actions/migrating-to-github-actions/migrating-from-circleci-to-github-actions
  - /actions/migrating-to-github-actions/migrating-from-gitlab-cicd-to-github-actions
  - /actions/migrating-to-github-actions/migrating-from-jenkins-to-github-actions
  - /actions/migrating-to-github-actions/migrating-from-travis-ci-to-github-actions
  - /actions/managing-issues-and-pull-requests/using-github-actions-for-project-management
  - /actions/managing-issues-and-pull-requests/closing-inactive-issues
  - /actions/managing-issues-and-pull-requests/scheduling-issue-creation
  - /actions/managing-issues-and-pull-requests/adding-labels-to-issues
  - /actions/managing-issues-and-pull-requests/commenting-on-an-issue-when-a-label-is-added
  - /actions/managing-issues-and-pull-requests/moving-assigned-issues-on-project-boards
  - /actions/managing-issues-and-pull-requests/removing-a-label-when-a-card-is-added-to-a-project-board-column
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/automating-dependabot-with-github-actions
  - /code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/keeping-your-actions-up-to-date-with-dependabot
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-docker-to-azure-app-service
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-java-to-azure-app-service
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-net-to-azure-app-service
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-nodejs-to-azure-app-service
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-php-to-azure-app-service
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-python-to-azure-app-service
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-to-azure-static-web-app
  - /actions/deployment/deploying-to-your-cloud-provider/deploying-to-azure/deploying-to-azure-kubernetes-service
---

