## Author self-review

- [ ] The changes in this PR meet the user experience and goals outlined in the content design plan.
- [ ] I've compared my PR's source changes to staging and reviewed for versioning issues, redirects, the [style guide](https://github.com/github/docs/blob/main/contributing/content-style-guide.md), [content model](https://github.com/github/docs/blob/main/contributing/content-model.md), or [translations guide for writers](https://github.com/github/docs/blob/main/contributing/translations/for-writers.md) rendering problems, typos, and wonky screenshots.
- [ ] I've worked through build failures and tests are passing.
- [ ] For REST API content, I've verified that endpoints, parameters, and responses are correct and work as expected and provided curl samples below.
  
For more information, check out our [full review guidelines and checklist](https://github.com/github/docs-content/blob/main/docs-content-docs/docs-content-workflows/reviews-and-feedback/review-process.md).

## Review request

### Summary

_Help reviewers understand this project and its context by writing a paragraph summarizing its goals and intended user experience and explaining how the PR meets those goals._
[Content design plan](LINK HERE)

### Docs Content review

_Give Docs Content any extra context, highlight areas for them to consider in their review, and ask them questions you need answered to ship the PR._

### Technical review

_Ping in technical reviewers, asking them to review whether content is technically accurate and right for the audience._
_Highlight areas for them to consider in their review and ask them questions you need answered to ship the PR._

### Content changes

[PR on staging](LINK HERE)

_Give a high-level overview of the changes in your PR and how they support the overall goals of the PR. Share links to important articles or changes in source and on staging. If your PR is large or complex, use a table to highlight changes with high user impact._

### Notes

_Discuss test failures, versioning issues, or anything else reviewers should know to consider the overall user experience of the PR._
