/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1beta1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_v1 "k8s.io/client-go/pkg/api/v1"
	pkg2_v1 "k8s.io/client-go/pkg/apis/meta/v1"
	pkg4_types "k8s.io/client-go/pkg/types"
	pkg1_intstr "k8s.io/client-go/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_v1.ObjectMeta
		var v1 pkg2_v1.LabelSelector
		var v2 pkg4_types.UID
		var v3 pkg1_intstr.IntOrString
		var v4 time.Time
		_, _, _, _, _ = v0, v1, v2, v3, v4
	}
}

func (x *PodDisruptionBudgetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = true
			yyq2[1] = x.Selector != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yy4 := &x.MinAvailable
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else if z.HasExtensions() && z.EncExt(yy4) {
					} else if !yym5 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy4)
					} else {
						z.EncFallback(yy4)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minAvailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy6 := &x.MinAvailable
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else if z.HasExtensions() && z.EncExt(yy6) {
					} else if !yym7 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy6)
					} else {
						z.EncFallback(yy6)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym9 := z.EncBinary()
						_ = yym9
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodDisruptionBudgetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym11 := z.DecBinary()
	_ = yym11
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct12 := r.ContainerType()
		if yyct12 == codecSelferValueTypeMap1234 {
			yyl12 := r.ReadMapStart()
			if yyl12 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl12, d)
			}
		} else if yyct12 == codecSelferValueTypeArray1234 {
			yyl12 := r.ReadArrayStart()
			if yyl12 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl12, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodDisruptionBudgetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys13Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys13Slc
	var yyhl13 bool = l >= 0
	for yyj13 := 0; ; yyj13++ {
		if yyhl13 {
			if yyj13 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys13Slc = r.DecodeBytes(yys13Slc, true, true)
		yys13 := string(yys13Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys13 {
		case "minAvailable":
			if r.TryDecodeAsNil() {
				x.MinAvailable = pkg1_intstr.IntOrString{}
			} else {
				yyv14 := &x.MinAvailable
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv14) {
				} else if !yym15 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv14)
				} else {
					z.DecFallback(yyv14, false)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg2_v1.LabelSelector)
				}
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys13)
		} // end switch yys13
	} // end for yyj13
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodDisruptionBudgetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj18 int
	var yyb18 bool
	var yyhl18 bool = l >= 0
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinAvailable = pkg1_intstr.IntOrString{}
	} else {
		yyv19 := &x.MinAvailable
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv19) {
		} else if !yym20 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv19)
		} else {
			z.DecFallback(yyv19, false)
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg2_v1.LabelSelector)
		}
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	for {
		yyj18++
		if yyhl18 {
			yyb18 = yyj18 > l
		} else {
			yyb18 = r.CheckBreak()
		}
		if yyb18 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj18-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodDisruptionBudgetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym23 := z.EncBinary()
		_ = yym23
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep24 := !z.EncBinary()
			yy2arr24 := z.EncBasicHandle().StructToArray
			var yyq24 [6]bool
			_, _, _ = yysep24, yyq24, yy2arr24
			const yyr24 bool = false
			yyq24[0] = x.ObservedGeneration != 0
			var yynn24 int
			if yyr24 || yy2arr24 {
				r.EncodeArrayStart(6)
			} else {
				yynn24 = 5
				for _, b := range yyq24 {
					if b {
						yynn24++
					}
				}
				r.EncodeMapStart(yynn24)
				yynn24 = 0
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq24[0] {
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq24[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym27 := z.EncBinary()
					_ = yym27
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.DisruptedPods == nil {
					r.EncodeNil()
				} else {
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						h.encMapstringv1_Time((map[string]pkg2_v1.Time)(x.DisruptedPods), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("disruptedPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.DisruptedPods == nil {
					r.EncodeNil()
				} else {
					yym30 := z.EncBinary()
					_ = yym30
					if false {
					} else {
						h.encMapstringv1_Time((map[string]pkg2_v1.Time)(x.DisruptedPods), e)
					}
				}
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym32 := z.EncBinary()
				_ = yym32
				if false {
				} else {
					r.EncodeInt(int64(x.PodDisruptionsAllowed))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("disruptionsAllowed"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else {
					r.EncodeInt(int64(x.PodDisruptionsAllowed))
				}
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentHealthy))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentHealthy"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentHealthy))
				}
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredHealthy))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredHealthy"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym39 := z.EncBinary()
				_ = yym39
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredHealthy))
				}
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeInt(int64(x.ExpectedPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("expectedPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym42 := z.EncBinary()
				_ = yym42
				if false {
				} else {
					r.EncodeInt(int64(x.ExpectedPods))
				}
			}
			if yyr24 || yy2arr24 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodDisruptionBudgetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym43 := z.DecBinary()
	_ = yym43
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct44 := r.ContainerType()
		if yyct44 == codecSelferValueTypeMap1234 {
			yyl44 := r.ReadMapStart()
			if yyl44 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl44, d)
			}
		} else if yyct44 == codecSelferValueTypeArray1234 {
			yyl44 := r.ReadArrayStart()
			if yyl44 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl44, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodDisruptionBudgetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys45Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys45Slc
	var yyhl45 bool = l >= 0
	for yyj45 := 0; ; yyj45++ {
		if yyhl45 {
			if yyj45 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys45Slc = r.DecodeBytes(yys45Slc, true, true)
		yys45 := string(yys45Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys45 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "disruptedPods":
			if r.TryDecodeAsNil() {
				x.DisruptedPods = nil
			} else {
				yyv47 := &x.DisruptedPods
				yym48 := z.DecBinary()
				_ = yym48
				if false {
				} else {
					h.decMapstringv1_Time((*map[string]pkg2_v1.Time)(yyv47), d)
				}
			}
		case "disruptionsAllowed":
			if r.TryDecodeAsNil() {
				x.PodDisruptionsAllowed = 0
			} else {
				x.PodDisruptionsAllowed = int32(r.DecodeInt(32))
			}
		case "currentHealthy":
			if r.TryDecodeAsNil() {
				x.CurrentHealthy = 0
			} else {
				x.CurrentHealthy = int32(r.DecodeInt(32))
			}
		case "desiredHealthy":
			if r.TryDecodeAsNil() {
				x.DesiredHealthy = 0
			} else {
				x.DesiredHealthy = int32(r.DecodeInt(32))
			}
		case "expectedPods":
			if r.TryDecodeAsNil() {
				x.ExpectedPods = 0
			} else {
				x.ExpectedPods = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys45)
		} // end switch yys45
	} // end for yyj45
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodDisruptionBudgetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj53 int
	var yyb53 bool
	var yyhl53 bool = l >= 0
	yyj53++
	if yyhl53 {
		yyb53 = yyj53 > l
	} else {
		yyb53 = r.CheckBreak()
	}
	if yyb53 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj53++
	if yyhl53 {
		yyb53 = yyj53 > l
	} else {
		yyb53 = r.CheckBreak()
	}
	if yyb53 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DisruptedPods = nil
	} else {
		yyv55 := &x.DisruptedPods
		yym56 := z.DecBinary()
		_ = yym56
		if false {
		} else {
			h.decMapstringv1_Time((*map[string]pkg2_v1.Time)(yyv55), d)
		}
	}
	yyj53++
	if yyhl53 {
		yyb53 = yyj53 > l
	} else {
		yyb53 = r.CheckBreak()
	}
	if yyb53 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodDisruptionsAllowed = 0
	} else {
		x.PodDisruptionsAllowed = int32(r.DecodeInt(32))
	}
	yyj53++
	if yyhl53 {
		yyb53 = yyj53 > l
	} else {
		yyb53 = r.CheckBreak()
	}
	if yyb53 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentHealthy = 0
	} else {
		x.CurrentHealthy = int32(r.DecodeInt(32))
	}
	yyj53++
	if yyhl53 {
		yyb53 = yyj53 > l
	} else {
		yyb53 = r.CheckBreak()
	}
	if yyb53 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredHealthy = 0
	} else {
		x.DesiredHealthy = int32(r.DecodeInt(32))
	}
	yyj53++
	if yyhl53 {
		yyb53 = yyj53 > l
	} else {
		yyb53 = r.CheckBreak()
	}
	if yyb53 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExpectedPods = 0
	} else {
		x.ExpectedPods = int32(r.DecodeInt(32))
	}
	for {
		yyj53++
		if yyhl53 {
			yyb53 = yyj53 > l
		} else {
			yyb53 = r.CheckBreak()
		}
		if yyb53 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj53-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodDisruptionBudget) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym61 := z.EncBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep62 := !z.EncBinary()
			yy2arr62 := z.EncBasicHandle().StructToArray
			var yyq62 [5]bool
			_, _, _ = yysep62, yyq62, yy2arr62
			const yyr62 bool = false
			yyq62[0] = x.Kind != ""
			yyq62[1] = x.APIVersion != ""
			yyq62[2] = true
			yyq62[3] = true
			yyq62[4] = true
			var yynn62 int
			if yyr62 || yy2arr62 {
				r.EncodeArrayStart(5)
			} else {
				yynn62 = 0
				for _, b := range yyq62 {
					if b {
						yynn62++
					}
				}
				r.EncodeMapStart(yynn62)
				yynn62 = 0
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[0] {
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[1] {
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[2] {
					yy70 := &x.ObjectMeta
					yy70.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq62[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy71 := &x.ObjectMeta
					yy71.CodecEncodeSelf(e)
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[3] {
					yy73 := &x.Spec
					yy73.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq62[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy74 := &x.Spec
					yy74.CodecEncodeSelf(e)
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[4] {
					yy76 := &x.Status
					yy76.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq62[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy77 := &x.Status
					yy77.CodecEncodeSelf(e)
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodDisruptionBudget) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym78 := z.DecBinary()
	_ = yym78
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct79 := r.ContainerType()
		if yyct79 == codecSelferValueTypeMap1234 {
			yyl79 := r.ReadMapStart()
			if yyl79 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl79, d)
			}
		} else if yyct79 == codecSelferValueTypeArray1234 {
			yyl79 := r.ReadArrayStart()
			if yyl79 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl79, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodDisruptionBudget) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys80Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys80Slc
	var yyhl80 bool = l >= 0
	for yyj80 := 0; ; yyj80++ {
		if yyhl80 {
			if yyj80 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys80Slc = r.DecodeBytes(yys80Slc, true, true)
		yys80 := string(yys80Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys80 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv83 := &x.ObjectMeta
				yyv83.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodDisruptionBudgetSpec{}
			} else {
				yyv84 := &x.Spec
				yyv84.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodDisruptionBudgetStatus{}
			} else {
				yyv85 := &x.Status
				yyv85.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys80)
		} // end switch yys80
	} // end for yyj80
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodDisruptionBudget) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj86 int
	var yyb86 bool
	var yyhl86 bool = l >= 0
	yyj86++
	if yyhl86 {
		yyb86 = yyj86 > l
	} else {
		yyb86 = r.CheckBreak()
	}
	if yyb86 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj86++
	if yyhl86 {
		yyb86 = yyj86 > l
	} else {
		yyb86 = r.CheckBreak()
	}
	if yyb86 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj86++
	if yyhl86 {
		yyb86 = yyj86 > l
	} else {
		yyb86 = r.CheckBreak()
	}
	if yyb86 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv89 := &x.ObjectMeta
		yyv89.CodecDecodeSelf(d)
	}
	yyj86++
	if yyhl86 {
		yyb86 = yyj86 > l
	} else {
		yyb86 = r.CheckBreak()
	}
	if yyb86 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodDisruptionBudgetSpec{}
	} else {
		yyv90 := &x.Spec
		yyv90.CodecDecodeSelf(d)
	}
	yyj86++
	if yyhl86 {
		yyb86 = yyj86 > l
	} else {
		yyb86 = r.CheckBreak()
	}
	if yyb86 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodDisruptionBudgetStatus{}
	} else {
		yyv91 := &x.Status
		yyv91.CodecDecodeSelf(d)
	}
	for {
		yyj86++
		if yyhl86 {
			yyb86 = yyj86 > l
		} else {
			yyb86 = r.CheckBreak()
		}
		if yyb86 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj86-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodDisruptionBudgetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym92 := z.EncBinary()
		_ = yym92
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep93 := !z.EncBinary()
			yy2arr93 := z.EncBasicHandle().StructToArray
			var yyq93 [4]bool
			_, _, _ = yysep93, yyq93, yy2arr93
			const yyr93 bool = false
			yyq93[0] = x.Kind != ""
			yyq93[1] = x.APIVersion != ""
			yyq93[2] = true
			var yynn93 int
			if yyr93 || yy2arr93 {
				r.EncodeArrayStart(4)
			} else {
				yynn93 = 1
				for _, b := range yyq93 {
					if b {
						yynn93++
					}
				}
				r.EncodeMapStart(yynn93)
				yynn93 = 0
			}
			if yyr93 || yy2arr93 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq93[0] {
					yym95 := z.EncBinary()
					_ = yym95
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq93[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym96 := z.EncBinary()
					_ = yym96
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr93 || yy2arr93 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq93[1] {
					yym98 := z.EncBinary()
					_ = yym98
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq93[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym99 := z.EncBinary()
					_ = yym99
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr93 || yy2arr93 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq93[2] {
					yy101 := &x.ListMeta
					yym102 := z.EncBinary()
					_ = yym102
					if false {
					} else if z.HasExtensions() && z.EncExt(yy101) {
					} else {
						z.EncFallback(yy101)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq93[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy103 := &x.ListMeta
					yym104 := z.EncBinary()
					_ = yym104
					if false {
					} else if z.HasExtensions() && z.EncExt(yy103) {
					} else {
						z.EncFallback(yy103)
					}
				}
			}
			if yyr93 || yy2arr93 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym106 := z.EncBinary()
					_ = yym106
					if false {
					} else {
						h.encSlicePodDisruptionBudget(([]PodDisruptionBudget)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym107 := z.EncBinary()
					_ = yym107
					if false {
					} else {
						h.encSlicePodDisruptionBudget(([]PodDisruptionBudget)(x.Items), e)
					}
				}
			}
			if yyr93 || yy2arr93 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodDisruptionBudgetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym108 := z.DecBinary()
	_ = yym108
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct109 := r.ContainerType()
		if yyct109 == codecSelferValueTypeMap1234 {
			yyl109 := r.ReadMapStart()
			if yyl109 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl109, d)
			}
		} else if yyct109 == codecSelferValueTypeArray1234 {
			yyl109 := r.ReadArrayStart()
			if yyl109 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl109, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodDisruptionBudgetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys110Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys110Slc
	var yyhl110 bool = l >= 0
	for yyj110 := 0; ; yyj110++ {
		if yyhl110 {
			if yyj110 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys110Slc = r.DecodeBytes(yys110Slc, true, true)
		yys110 := string(yys110Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys110 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv113 := &x.ListMeta
				yym114 := z.DecBinary()
				_ = yym114
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv113) {
				} else {
					z.DecFallback(yyv113, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv115 := &x.Items
				yym116 := z.DecBinary()
				_ = yym116
				if false {
				} else {
					h.decSlicePodDisruptionBudget((*[]PodDisruptionBudget)(yyv115), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys110)
		} // end switch yys110
	} // end for yyj110
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodDisruptionBudgetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj117 int
	var yyb117 bool
	var yyhl117 bool = l >= 0
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv120 := &x.ListMeta
		yym121 := z.DecBinary()
		_ = yym121
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv120) {
		} else {
			z.DecFallback(yyv120, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv122 := &x.Items
		yym123 := z.DecBinary()
		_ = yym123
		if false {
		} else {
			h.decSlicePodDisruptionBudget((*[]PodDisruptionBudget)(yyv122), d)
		}
	}
	for {
		yyj117++
		if yyhl117 {
			yyb117 = yyj117 > l
		} else {
			yyb117 = r.CheckBreak()
		}
		if yyb117 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj117-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Eviction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym124 := z.EncBinary()
		_ = yym124
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep125 := !z.EncBinary()
			yy2arr125 := z.EncBasicHandle().StructToArray
			var yyq125 [4]bool
			_, _, _ = yysep125, yyq125, yy2arr125
			const yyr125 bool = false
			yyq125[0] = x.Kind != ""
			yyq125[1] = x.APIVersion != ""
			yyq125[2] = true
			yyq125[3] = x.DeleteOptions != nil
			var yynn125 int
			if yyr125 || yy2arr125 {
				r.EncodeArrayStart(4)
			} else {
				yynn125 = 0
				for _, b := range yyq125 {
					if b {
						yynn125++
					}
				}
				r.EncodeMapStart(yynn125)
				yynn125 = 0
			}
			if yyr125 || yy2arr125 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq125[0] {
					yym127 := z.EncBinary()
					_ = yym127
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq125[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym128 := z.EncBinary()
					_ = yym128
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr125 || yy2arr125 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq125[1] {
					yym130 := z.EncBinary()
					_ = yym130
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq125[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym131 := z.EncBinary()
					_ = yym131
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr125 || yy2arr125 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq125[2] {
					yy133 := &x.ObjectMeta
					yy133.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq125[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy134 := &x.ObjectMeta
					yy134.CodecEncodeSelf(e)
				}
			}
			if yyr125 || yy2arr125 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq125[3] {
					if x.DeleteOptions == nil {
						r.EncodeNil()
					} else {
						x.DeleteOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq125[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deleteOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeleteOptions == nil {
						r.EncodeNil()
					} else {
						x.DeleteOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr125 || yy2arr125 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Eviction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym136 := z.DecBinary()
	_ = yym136
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct137 := r.ContainerType()
		if yyct137 == codecSelferValueTypeMap1234 {
			yyl137 := r.ReadMapStart()
			if yyl137 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl137, d)
			}
		} else if yyct137 == codecSelferValueTypeArray1234 {
			yyl137 := r.ReadArrayStart()
			if yyl137 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl137, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Eviction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys138Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys138Slc
	var yyhl138 bool = l >= 0
	for yyj138 := 0; ; yyj138++ {
		if yyhl138 {
			if yyj138 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys138Slc = r.DecodeBytes(yys138Slc, true, true)
		yys138 := string(yys138Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys138 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv141 := &x.ObjectMeta
				yyv141.CodecDecodeSelf(d)
			}
		case "deleteOptions":
			if r.TryDecodeAsNil() {
				if x.DeleteOptions != nil {
					x.DeleteOptions = nil
				}
			} else {
				if x.DeleteOptions == nil {
					x.DeleteOptions = new(pkg3_v1.DeleteOptions)
				}
				x.DeleteOptions.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys138)
		} // end switch yys138
	} // end for yyj138
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Eviction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj143 int
	var yyb143 bool
	var yyhl143 bool = l >= 0
	yyj143++
	if yyhl143 {
		yyb143 = yyj143 > l
	} else {
		yyb143 = r.CheckBreak()
	}
	if yyb143 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj143++
	if yyhl143 {
		yyb143 = yyj143 > l
	} else {
		yyb143 = r.CheckBreak()
	}
	if yyb143 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj143++
	if yyhl143 {
		yyb143 = yyj143 > l
	} else {
		yyb143 = r.CheckBreak()
	}
	if yyb143 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv146 := &x.ObjectMeta
		yyv146.CodecDecodeSelf(d)
	}
	yyj143++
	if yyhl143 {
		yyb143 = yyj143 > l
	} else {
		yyb143 = r.CheckBreak()
	}
	if yyb143 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeleteOptions != nil {
			x.DeleteOptions = nil
		}
	} else {
		if x.DeleteOptions == nil {
			x.DeleteOptions = new(pkg3_v1.DeleteOptions)
		}
		x.DeleteOptions.CodecDecodeSelf(d)
	}
	for {
		yyj143++
		if yyhl143 {
			yyb143 = yyj143 > l
		} else {
			yyb143 = r.CheckBreak()
		}
		if yyb143 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj143-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encMapstringv1_Time(v map[string]pkg2_v1.Time, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk148, yyv148 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym149 := z.EncBinary()
		_ = yym149
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk148))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yy150 := &yyv148
		yym151 := z.EncBinary()
		_ = yym151
		if false {
		} else if z.HasExtensions() && z.EncExt(yy150) {
		} else if yym151 {
			z.EncBinaryMarshal(yy150)
		} else if !yym151 && z.IsJSONHandle() {
			z.EncJSONMarshal(yy150)
		} else {
			z.EncFallback(yy150)
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decMapstringv1_Time(v *map[string]pkg2_v1.Time, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv152 := *v
	yyl152 := r.ReadMapStart()
	yybh152 := z.DecBasicHandle()
	if yyv152 == nil {
		yyrl152, _ := z.DecInferLen(yyl152, yybh152.MaxInitLen, 40)
		yyv152 = make(map[string]pkg2_v1.Time, yyrl152)
		*v = yyv152
	}
	var yymk152 string
	var yymv152 pkg2_v1.Time
	var yymg152 bool
	if yybh152.MapValueReset {
		yymg152 = true
	}
	if yyl152 > 0 {
		for yyj152 := 0; yyj152 < yyl152; yyj152++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk152 = ""
			} else {
				yymk152 = string(r.DecodeString())
			}

			if yymg152 {
				yymv152 = yyv152[yymk152]
			} else {
				yymv152 = pkg2_v1.Time{}
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv152 = pkg2_v1.Time{}
			} else {
				yyv154 := &yymv152
				yym155 := z.DecBinary()
				_ = yym155
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv154) {
				} else if yym155 {
					z.DecBinaryUnmarshal(yyv154)
				} else if !yym155 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv154)
				} else {
					z.DecFallback(yyv154, false)
				}
			}

			if yyv152 != nil {
				yyv152[yymk152] = yymv152
			}
		}
	} else if yyl152 < 0 {
		for yyj152 := 0; !r.CheckBreak(); yyj152++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk152 = ""
			} else {
				yymk152 = string(r.DecodeString())
			}

			if yymg152 {
				yymv152 = yyv152[yymk152]
			} else {
				yymv152 = pkg2_v1.Time{}
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv152 = pkg2_v1.Time{}
			} else {
				yyv157 := &yymv152
				yym158 := z.DecBinary()
				_ = yym158
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv157) {
				} else if yym158 {
					z.DecBinaryUnmarshal(yyv157)
				} else if !yym158 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv157)
				} else {
					z.DecFallback(yyv157, false)
				}
			}

			if yyv152 != nil {
				yyv152[yymk152] = yymv152
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) encSlicePodDisruptionBudget(v []PodDisruptionBudget, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv159 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy160 := &yyv159
		yy160.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePodDisruptionBudget(v *[]PodDisruptionBudget, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv161 := *v
	yyh161, yyl161 := z.DecSliceHelperStart()
	var yyc161 bool
	if yyl161 == 0 {
		if yyv161 == nil {
			yyv161 = []PodDisruptionBudget{}
			yyc161 = true
		} else if len(yyv161) != 0 {
			yyv161 = yyv161[:0]
			yyc161 = true
		}
	} else if yyl161 > 0 {
		var yyrr161, yyrl161 int
		var yyrt161 bool
		if yyl161 > cap(yyv161) {

			yyrg161 := len(yyv161) > 0
			yyv2161 := yyv161
			yyrl161, yyrt161 = z.DecInferLen(yyl161, z.DecBasicHandle().MaxInitLen, 328)
			if yyrt161 {
				if yyrl161 <= cap(yyv161) {
					yyv161 = yyv161[:yyrl161]
				} else {
					yyv161 = make([]PodDisruptionBudget, yyrl161)
				}
			} else {
				yyv161 = make([]PodDisruptionBudget, yyrl161)
			}
			yyc161 = true
			yyrr161 = len(yyv161)
			if yyrg161 {
				copy(yyv161, yyv2161)
			}
		} else if yyl161 != len(yyv161) {
			yyv161 = yyv161[:yyl161]
			yyc161 = true
		}
		yyj161 := 0
		for ; yyj161 < yyrr161; yyj161++ {
			yyh161.ElemContainerState(yyj161)
			if r.TryDecodeAsNil() {
				yyv161[yyj161] = PodDisruptionBudget{}
			} else {
				yyv162 := &yyv161[yyj161]
				yyv162.CodecDecodeSelf(d)
			}

		}
		if yyrt161 {
			for ; yyj161 < yyl161; yyj161++ {
				yyv161 = append(yyv161, PodDisruptionBudget{})
				yyh161.ElemContainerState(yyj161)
				if r.TryDecodeAsNil() {
					yyv161[yyj161] = PodDisruptionBudget{}
				} else {
					yyv163 := &yyv161[yyj161]
					yyv163.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj161 := 0
		for ; !r.CheckBreak(); yyj161++ {

			if yyj161 >= len(yyv161) {
				yyv161 = append(yyv161, PodDisruptionBudget{}) // var yyz161 PodDisruptionBudget
				yyc161 = true
			}
			yyh161.ElemContainerState(yyj161)
			if yyj161 < len(yyv161) {
				if r.TryDecodeAsNil() {
					yyv161[yyj161] = PodDisruptionBudget{}
				} else {
					yyv164 := &yyv161[yyj161]
					yyv164.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj161 < len(yyv161) {
			yyv161 = yyv161[:yyj161]
			yyc161 = true
		} else if yyj161 == 0 && yyv161 == nil {
			yyv161 = []PodDisruptionBudget{}
			yyc161 = true
		}
	}
	yyh161.End()
	if yyc161 {
		*v = yyv161
	}
}
