/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/client-go/pkg/api"
	pkg1_v1 "k8s.io/client-go/pkg/apis/meta/v1"
	pkg3_config "k8s.io/client-go/pkg/util/config"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.Taint
		var v1 pkg1_v1.TypeMeta
		var v2 pkg3_config.ConfigurationMap
		var v3 time.Duration
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [23]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(23)
			} else {
				yynn2 = 21
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy25 := *x.IPTablesMasqueradeBit
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(yy25))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy27 := *x.IPTablesMasqueradeBit
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(yy27))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy30 := &x.IPTablesSyncPeriod
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else if z.HasExtensions() && z.EncExt(yy30) {
				} else if !yym31 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy30)
				} else {
					z.EncFallback(yy30)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy32 := &x.IPTablesSyncPeriod
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else if z.HasExtensions() && z.EncExt(yy32) {
				} else if !yym33 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy32)
				} else {
					z.EncFallback(yy32)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy35 := &x.IPTablesMinSyncPeriod
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else if z.HasExtensions() && z.EncExt(yy35) {
				} else if !yym36 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy35)
				} else {
					z.EncFallback(yy35)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMinSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy37 := &x.IPTablesMinSyncPeriod
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else if z.HasExtensions() && z.EncExt(yy37) {
				} else if !yym38 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy37)
				} else {
					z.EncFallback(yy37)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym40 := z.EncBinary()
				_ = yym40
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym43 := z.EncBinary()
				_ = yym43
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym44 := z.EncBinary()
				_ = yym44
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym47 := z.EncBinary()
				_ = yym47
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy49 := *x.OOMScoreAdj
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeInt(int64(yy49))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy51 := *x.OOMScoreAdj
					yym52 := z.EncBinary()
					_ = yym52
					if false {
					} else {
						r.EncodeInt(int64(yy51))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym56 := z.EncBinary()
				_ = yym56
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym58 := z.EncBinary()
				_ = yym58
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy61 := &x.UDPIdleTimeout
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else if z.HasExtensions() && z.EncExt(yy61) {
				} else if !yym62 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy61)
				} else {
					z.EncFallback(yy61)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy63 := &x.UDPIdleTimeout
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else if z.HasExtensions() && z.EncExt(yy63) {
				} else if !yym64 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy63)
				} else {
					z.EncFallback(yy63)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym66 := z.EncBinary()
				_ = yym66
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym67 := z.EncBinary()
				_ = yym67
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym69 := z.EncBinary()
				_ = yym69
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMaxPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym72 := z.EncBinary()
				_ = yym72
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMin"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym73 := z.EncBinary()
				_ = yym73
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy75 := &x.ConntrackTCPEstablishedTimeout
				yym76 := z.EncBinary()
				_ = yym76
				if false {
				} else if z.HasExtensions() && z.EncExt(yy75) {
				} else if !yym76 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy75)
				} else {
					z.EncFallback(yy75)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy77 := &x.ConntrackTCPEstablishedTimeout
				yym78 := z.EncBinary()
				_ = yym78
				if false {
				} else if z.HasExtensions() && z.EncExt(yy77) {
				} else if !yym78 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy77)
				} else {
					z.EncFallback(yy77)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy80 := &x.ConntrackTCPCloseWaitTimeout
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else if z.HasExtensions() && z.EncExt(yy80) {
				} else if !yym81 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy80)
				} else {
					z.EncFallback(yy80)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPCloseWaitTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy82 := &x.ConntrackTCPCloseWaitTimeout
				yym83 := z.EncBinary()
				_ = yym83
				if false {
				} else if z.HasExtensions() && z.EncExt(yy82) {
				} else if !yym83 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy82)
				} else {
					z.EncFallback(yy82)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym84 := z.DecBinary()
	_ = yym84
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct85 := r.ContainerType()
		if yyct85 == codecSelferValueTypeMap1234 {
			yyl85 := r.ReadMapStart()
			if yyl85 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl85, d)
			}
		} else if yyct85 == codecSelferValueTypeArray1234 {
			yyl85 := r.ReadArrayStart()
			if yyl85 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl85, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys86Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys86Slc
	var yyhl86 bool = l >= 0
	for yyj86 := 0; ; yyj86++ {
		if yyhl86 {
			if yyj86 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys86Slc = r.DecodeBytes(yys86Slc, true, true)
		yys86 := string(yys86Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys86 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int32)
				}
				yym95 := z.DecBinary()
				_ = yym95
				if false {
				} else {
					*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv96 := &x.IPTablesSyncPeriod
				yym97 := z.DecBinary()
				_ = yym97
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv96) {
				} else if !yym97 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv96)
				} else {
					z.DecFallback(yyv96, false)
				}
			}
		case "iptablesMinSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesMinSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv98 := &x.IPTablesMinSyncPeriod
				yym99 := z.DecBinary()
				_ = yym99
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv98) {
				} else if !yym99 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv98)
				} else {
					z.DecFallback(yyv98, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int32)
				}
				yym104 := z.DecBinary()
				_ = yym104
				if false {
				} else {
					*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_v1.Duration{}
			} else {
				yyv108 := &x.UDPIdleTimeout
				yym109 := z.DecBinary()
				_ = yym109
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv108) {
				} else if !yym109 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv108)
				} else {
					z.DecFallback(yyv108, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int32(r.DecodeInt(32))
			}
		case "conntrackMaxPerCore":
			if r.TryDecodeAsNil() {
				x.ConntrackMaxPerCore = 0
			} else {
				x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
			}
		case "conntrackMin":
			if r.TryDecodeAsNil() {
				x.ConntrackMin = 0
			} else {
				x.ConntrackMin = int32(r.DecodeInt(32))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_v1.Duration{}
			} else {
				yyv113 := &x.ConntrackTCPEstablishedTimeout
				yym114 := z.DecBinary()
				_ = yym114
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv113) {
				} else if !yym114 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv113)
				} else {
					z.DecFallback(yyv113, false)
				}
			}
		case "conntrackTCPCloseWaitTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPCloseWaitTimeout = pkg1_v1.Duration{}
			} else {
				yyv115 := &x.ConntrackTCPCloseWaitTimeout
				yym116 := z.DecBinary()
				_ = yym116
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv115) {
				} else if !yym116 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv115)
				} else {
					z.DecFallback(yyv115, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys86)
		} // end switch yys86
	} // end for yyj86
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj117 int
	var yyb117 bool
	var yyhl117 bool = l >= 0
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int32)
		}
		yym126 := z.DecBinary()
		_ = yym126
		if false {
		} else {
			*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv127 := &x.IPTablesSyncPeriod
		yym128 := z.DecBinary()
		_ = yym128
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv127) {
		} else if !yym128 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv127)
		} else {
			z.DecFallback(yyv127, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMinSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv129 := &x.IPTablesMinSyncPeriod
		yym130 := z.DecBinary()
		_ = yym130
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv129) {
		} else if !yym130 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv129)
		} else {
			z.DecFallback(yyv129, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int32)
		}
		yym135 := z.DecBinary()
		_ = yym135
		if false {
		} else {
			*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_v1.Duration{}
	} else {
		yyv139 := &x.UDPIdleTimeout
		yym140 := z.DecBinary()
		_ = yym140
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv139) {
		} else if !yym140 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv139)
		} else {
			z.DecFallback(yyv139, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMaxPerCore = 0
	} else {
		x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMin = 0
	} else {
		x.ConntrackMin = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_v1.Duration{}
	} else {
		yyv144 := &x.ConntrackTCPEstablishedTimeout
		yym145 := z.DecBinary()
		_ = yym145
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv144) {
		} else if !yym145 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv144)
		} else {
			z.DecFallback(yyv144, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPCloseWaitTimeout = pkg1_v1.Duration{}
	} else {
		yyv146 := &x.ConntrackTCPCloseWaitTimeout
		yym147 := z.DecBinary()
		_ = yym147
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv146) {
		} else if !yym147 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv146)
		} else {
			z.DecFallback(yyv146, false)
		}
	}
	for {
		yyj117++
		if yyhl117 {
			yyb117 = yyj117 > l
		} else {
			yyb117 = r.CheckBreak()
		}
		if yyb117 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj117-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym148 := z.EncBinary()
	_ = yym148
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym149 := z.DecBinary()
	_ = yym149
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym150 := z.EncBinary()
	_ = yym150
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym151 := z.DecBinary()
	_ = yym151
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym152 := z.EncBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep153 := !z.EncBinary()
			yy2arr153 := z.EncBasicHandle().StructToArray
			var yyq153 [116]bool
			_, _, _ = yysep153, yyq153, yy2arr153
			const yyr153 bool = false
			yyq153[0] = x.Kind != ""
			yyq153[1] = x.APIVersion != ""
			yyq153[55] = x.CloudProvider != ""
			yyq153[56] = x.CloudConfigFile != ""
			yyq153[57] = x.KubeletCgroups != ""
			yyq153[58] = x.ExperimentalCgroupsPerQOS != false
			yyq153[59] = x.CgroupDriver != ""
			yyq153[60] = x.RuntimeCgroups != ""
			yyq153[61] = x.SystemCgroups != ""
			yyq153[62] = x.CgroupRoot != ""
			yyq153[66] = true
			yyq153[67] = true
			yyq153[68] = x.RktPath != ""
			yyq153[69] = x.ExperimentalMounterPath != ""
			yyq153[70] = x.RktAPIEndpoint != ""
			yyq153[71] = x.RktStage1Image != ""
			yyq153[91] = true
			yyq153[92] = x.NodeIP != ""
			yyq153[96] = x.EvictionHard != ""
			yyq153[97] = x.EvictionSoft != ""
			yyq153[98] = x.EvictionSoftGracePeriod != ""
			yyq153[99] = true
			yyq153[100] = x.EvictionMaxPodGracePeriod != 0
			yyq153[101] = x.EvictionMinimumReclaim != ""
			yyq153[111] = len(x.AllowedUnsafeSysctls) != 0
			yyq153[113] = x.EnableCRI != false
			yyq153[114] = x.ExperimentalFailSwapOn != false
			yyq153[115] = x.ExperimentalCheckNodeCapabilitiesBeforeMount != false
			var yynn153 int
			if yyr153 || yy2arr153 {
				r.EncodeArrayStart(116)
			} else {
				yynn153 = 88
				for _, b := range yyq153 {
					if b {
						yynn153++
					}
				}
				r.EncodeMapStart(yynn153)
				yynn153 = 0
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[0] {
					yym155 := z.EncBinary()
					_ = yym155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym156 := z.EncBinary()
					_ = yym156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[1] {
					yym158 := z.EncBinary()
					_ = yym158
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym159 := z.EncBinary()
					_ = yym159
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym161 := z.EncBinary()
				_ = yym161
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podManifestPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy164 := &x.SyncFrequency
				yym165 := z.EncBinary()
				_ = yym165
				if false {
				} else if z.HasExtensions() && z.EncExt(yy164) {
				} else if !yym165 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy164)
				} else {
					z.EncFallback(yy164)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy166 := &x.SyncFrequency
				yym167 := z.EncBinary()
				_ = yym167
				if false {
				} else if z.HasExtensions() && z.EncExt(yy166) {
				} else if !yym167 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy166)
				} else {
					z.EncFallback(yy166)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy169 := &x.FileCheckFrequency
				yym170 := z.EncBinary()
				_ = yym170
				if false {
				} else if z.HasExtensions() && z.EncExt(yy169) {
				} else if !yym170 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy169)
				} else {
					z.EncFallback(yy169)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy171 := &x.FileCheckFrequency
				yym172 := z.EncBinary()
				_ = yym172
				if false {
				} else if z.HasExtensions() && z.EncExt(yy171) {
				} else if !yym172 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy171)
				} else {
					z.EncFallback(yy171)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy174 := &x.HTTPCheckFrequency
				yym175 := z.EncBinary()
				_ = yym175
				if false {
				} else if z.HasExtensions() && z.EncExt(yy174) {
				} else if !yym175 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy174)
				} else {
					z.EncFallback(yy174)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy176 := &x.HTTPCheckFrequency
				yym177 := z.EncBinary()
				_ = yym177
				if false {
				} else if z.HasExtensions() && z.EncExt(yy176) {
				} else if !yym177 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy176)
				} else {
					z.EncFallback(yy176)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym179 := z.EncBinary()
				_ = yym179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym182 := z.EncBinary()
				_ = yym182
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym183 := z.EncBinary()
				_ = yym183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym185 := z.EncBinary()
				_ = yym185
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym188 := z.EncBinary()
				_ = yym188
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym189 := z.EncBinary()
				_ = yym189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym191 := z.EncBinary()
				_ = yym191
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym194 := z.EncBinary()
				_ = yym194
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym200 := z.EncBinary()
				_ = yym200
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym201 := z.EncBinary()
				_ = yym201
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym203 := z.EncBinary()
				_ = yym203
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy206 := &x.Authentication
				yy206.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("authentication"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy207 := &x.Authentication
				yy207.CodecEncodeSelf(e)
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy209 := &x.Authorization
				yy209.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("authorization"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy210 := &x.Authorization
				yy210.CodecEncodeSelf(e)
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym212 := z.EncBinary()
				_ = yym212
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym213 := z.EncBinary()
				_ = yym213
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym215 := z.EncBinary()
				_ = yym215
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym218 := z.EncBinary()
				_ = yym218
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym221 := z.EncBinary()
				_ = yym221
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seccompProfileRoot"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym230 := z.EncBinary()
					_ = yym230
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym231 := z.EncBinary()
					_ = yym231
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym233 := z.EncBinary()
					_ = yym233
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym234 := z.EncBinary()
					_ = yym234
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym236 := z.EncBinary()
					_ = yym236
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym237 := z.EncBinary()
					_ = yym237
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym239 := z.EncBinary()
				_ = yym239
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym240 := z.EncBinary()
				_ = yym240
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym242 := z.EncBinary()
				_ = yym242
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym243 := z.EncBinary()
				_ = yym243
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym246 := z.EncBinary()
				_ = yym246
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym249 := z.EncBinary()
				_ = yym249
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym252 := z.EncBinary()
				_ = yym252
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy254 := &x.MinimumGCAge
				yym255 := z.EncBinary()
				_ = yym255
				if false {
				} else if z.HasExtensions() && z.EncExt(yy254) {
				} else if !yym255 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy254)
				} else {
					z.EncFallback(yy254)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy256 := &x.MinimumGCAge
				yym257 := z.EncBinary()
				_ = yym257
				if false {
				} else if z.HasExtensions() && z.EncExt(yy256) {
				} else if !yym257 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy256)
				} else {
					z.EncFallback(yy256)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym259 := z.EncBinary()
				_ = yym259
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym260 := z.EncBinary()
				_ = yym260
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym262 := z.EncBinary()
				_ = yym262
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym263 := z.EncBinary()
				_ = yym263
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym265 := z.EncBinary()
				_ = yym265
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym266 := z.EncBinary()
				_ = yym266
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym268 := z.EncBinary()
				_ = yym268
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym269 := z.EncBinary()
				_ = yym269
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym271 := z.EncBinary()
				_ = yym271
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym272 := z.EncBinary()
				_ = yym272
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym274 := z.EncBinary()
				_ = yym274
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym275 := z.EncBinary()
				_ = yym275
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym277 := z.EncBinary()
				_ = yym277
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym278 := z.EncBinary()
				_ = yym278
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym280 := z.EncBinary()
				_ = yym280
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym281 := z.EncBinary()
				_ = yym281
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym283 := z.EncBinary()
				_ = yym283
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym284 := z.EncBinary()
				_ = yym284
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym286 := z.EncBinary()
				_ = yym286
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym287 := z.EncBinary()
				_ = yym287
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy289 := &x.StreamingConnectionIdleTimeout
				yym290 := z.EncBinary()
				_ = yym290
				if false {
				} else if z.HasExtensions() && z.EncExt(yy289) {
				} else if !yym290 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy289)
				} else {
					z.EncFallback(yy289)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy291 := &x.StreamingConnectionIdleTimeout
				yym292 := z.EncBinary()
				_ = yym292
				if false {
				} else if z.HasExtensions() && z.EncExt(yy291) {
				} else if !yym292 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy291)
				} else {
					z.EncFallback(yy291)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy294 := &x.NodeStatusUpdateFrequency
				yym295 := z.EncBinary()
				_ = yym295
				if false {
				} else if z.HasExtensions() && z.EncExt(yy294) {
				} else if !yym295 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy294)
				} else {
					z.EncFallback(yy294)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy296 := &x.NodeStatusUpdateFrequency
				yym297 := z.EncBinary()
				_ = yym297
				if false {
				} else if z.HasExtensions() && z.EncExt(yy296) {
				} else if !yym297 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy296)
				} else {
					z.EncFallback(yy296)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy299 := &x.ImageMinimumGCAge
				yym300 := z.EncBinary()
				_ = yym300
				if false {
				} else if z.HasExtensions() && z.EncExt(yy299) {
				} else if !yym300 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy299)
				} else {
					z.EncFallback(yy299)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy301 := &x.ImageMinimumGCAge
				yym302 := z.EncBinary()
				_ = yym302
				if false {
				} else if z.HasExtensions() && z.EncExt(yy301) {
				} else if !yym302 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy301)
				} else {
					z.EncFallback(yy301)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym304 := z.EncBinary()
				_ = yym304
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym305 := z.EncBinary()
				_ = yym305
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym307 := z.EncBinary()
				_ = yym307
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym308 := z.EncBinary()
				_ = yym308
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym310 := z.EncBinary()
				_ = yym310
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym311 := z.EncBinary()
				_ = yym311
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy313 := &x.VolumeStatsAggPeriod
				yym314 := z.EncBinary()
				_ = yym314
				if false {
				} else if z.HasExtensions() && z.EncExt(yy313) {
				} else if !yym314 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy313)
				} else {
					z.EncFallback(yy313)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy315 := &x.VolumeStatsAggPeriod
				yym316 := z.EncBinary()
				_ = yym316
				if false {
				} else if z.HasExtensions() && z.EncExt(yy315) {
				} else if !yym316 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy315)
				} else {
					z.EncFallback(yy315)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym318 := z.EncBinary()
				_ = yym318
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym319 := z.EncBinary()
				_ = yym319
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym321 := z.EncBinary()
				_ = yym321
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginMTU"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym322 := z.EncBinary()
				_ = yym322
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym324 := z.EncBinary()
				_ = yym324
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym325 := z.EncBinary()
				_ = yym325
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym327 := z.EncBinary()
				_ = yym327
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniConfDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym328 := z.EncBinary()
				_ = yym328
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym330 := z.EncBinary()
				_ = yym330
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniBinDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym331 := z.EncBinary()
				_ = yym331
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym333 := z.EncBinary()
				_ = yym333
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym334 := z.EncBinary()
				_ = yym334
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[55] {
					yym336 := z.EncBinary()
					_ = yym336
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[55] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym337 := z.EncBinary()
					_ = yym337
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[56] {
					yym339 := z.EncBinary()
					_ = yym339
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym340 := z.EncBinary()
					_ = yym340
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[57] {
					yym342 := z.EncBinary()
					_ = yym342
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[57] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[58] {
					yym345 := z.EncBinary()
					_ = yym345
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCgroupsPerQOS))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[58] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalCgroupsPerQOS"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym346 := z.EncBinary()
					_ = yym346
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCgroupsPerQOS))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[59] {
					yym348 := z.EncBinary()
					_ = yym348
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupDriver))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[59] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupDriver"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym349 := z.EncBinary()
					_ = yym349
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupDriver))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[60] {
					yym351 := z.EncBinary()
					_ = yym351
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[60] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym352 := z.EncBinary()
					_ = yym352
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[61] {
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[61] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym355 := z.EncBinary()
					_ = yym355
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[62] {
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[62] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym358 := z.EncBinary()
					_ = yym358
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym360 := z.EncBinary()
				_ = yym360
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym361 := z.EncBinary()
				_ = yym361
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym363 := z.EncBinary()
				_ = yym363
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteRuntimeEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym364 := z.EncBinary()
				_ = yym364
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym366 := z.EncBinary()
				_ = yym366
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteImageEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym367 := z.EncBinary()
				_ = yym367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[66] {
					yy369 := &x.RuntimeRequestTimeout
					yym370 := z.EncBinary()
					_ = yym370
					if false {
					} else if z.HasExtensions() && z.EncExt(yy369) {
					} else if !yym370 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy369)
					} else {
						z.EncFallback(yy369)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[66] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeRequestTimeout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy371 := &x.RuntimeRequestTimeout
					yym372 := z.EncBinary()
					_ = yym372
					if false {
					} else if z.HasExtensions() && z.EncExt(yy371) {
					} else if !yym372 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy371)
					} else {
						z.EncFallback(yy371)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[67] {
					yy374 := &x.ImagePullProgressDeadline
					yym375 := z.EncBinary()
					_ = yym375
					if false {
					} else if z.HasExtensions() && z.EncExt(yy374) {
					} else if !yym375 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy374)
					} else {
						z.EncFallback(yy374)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[67] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullProgressDeadline"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy376 := &x.ImagePullProgressDeadline
					yym377 := z.EncBinary()
					_ = yym377
					if false {
					} else if z.HasExtensions() && z.EncExt(yy376) {
					} else if !yym377 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy376)
					} else {
						z.EncFallback(yy376)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[68] {
					yym379 := z.EncBinary()
					_ = yym379
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[68] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym380 := z.EncBinary()
					_ = yym380
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[69] {
					yym382 := z.EncBinary()
					_ = yym382
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalMounterPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[69] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalMounterPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym383 := z.EncBinary()
					_ = yym383
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalMounterPath))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[70] {
					yym385 := z.EncBinary()
					_ = yym385
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[70] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktAPIEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym386 := z.EncBinary()
					_ = yym386
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[71] {
					yym388 := z.EncBinary()
					_ = yym388
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[71] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym389 := z.EncBinary()
					_ = yym389
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym391 := z.EncBinary()
				_ = yym391
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym392 := z.EncBinary()
				_ = yym392
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym394 := z.EncBinary()
				_ = yym394
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitOnLockContention"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym395 := z.EncBinary()
				_ = yym395
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym397 := z.EncBinary()
				_ = yym397
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym398 := z.EncBinary()
				_ = yym398
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym400 := z.EncBinary()
				_ = yym400
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("babysitDaemons"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym401 := z.EncBinary()
				_ = yym401
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym403 := z.EncBinary()
				_ = yym403
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym404 := z.EncBinary()
				_ = yym404
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym406 := z.EncBinary()
				_ = yym406
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nvidiaGPUs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym407 := z.EncBinary()
				_ = yym407
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym409 := z.EncBinary()
				_ = yym409
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym410 := z.EncBinary()
				_ = yym410
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym412 := z.EncBinary()
				_ = yym412
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym413 := z.EncBinary()
				_ = yym413
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym415 := z.EncBinary()
				_ = yym415
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym416 := z.EncBinary()
				_ = yym416
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym418 := z.EncBinary()
				_ = yym418
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym419 := z.EncBinary()
				_ = yym419
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym421 := z.EncBinary()
				_ = yym421
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym422 := z.EncBinary()
				_ = yym422
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym424 := z.EncBinary()
				_ = yym424
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym425 := z.EncBinary()
				_ = yym425
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym427 := z.EncBinary()
				_ = yym427
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym428 := z.EncBinary()
				_ = yym428
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym430 := z.EncBinary()
				_ = yym430
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym431 := z.EncBinary()
				_ = yym431
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.RegisterWithTaints == nil {
					r.EncodeNil()
				} else {
					yym433 := z.EncBinary()
					_ = yym433
					if false {
					} else {
						h.encSliceapi_Taint(([]pkg2_api.Taint)(x.RegisterWithTaints), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerWithTaints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.RegisterWithTaints == nil {
					r.EncodeNil()
				} else {
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else {
						h.encSliceapi_Taint(([]pkg2_api.Taint)(x.RegisterWithTaints), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym436 := z.EncBinary()
				_ = yym436
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym437 := z.EncBinary()
				_ = yym437
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym439 := z.EncBinary()
				_ = yym439
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym440 := z.EncBinary()
				_ = yym440
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym442 := z.EncBinary()
				_ = yym442
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym443 := z.EncBinary()
				_ = yym443
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym445 := z.EncBinary()
				_ = yym445
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym446 := z.EncBinary()
				_ = yym446
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[91] {
					yy448 := &x.OutOfDiskTransitionFrequency
					yym449 := z.EncBinary()
					_ = yym449
					if false {
					} else if z.HasExtensions() && z.EncExt(yy448) {
					} else if !yym449 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy448)
					} else {
						z.EncFallback(yy448)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[91] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy450 := &x.OutOfDiskTransitionFrequency
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else if z.HasExtensions() && z.EncExt(yy450) {
					} else if !yym451 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy450)
					} else {
						z.EncFallback(yy450)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[92] {
					yym453 := z.EncBinary()
					_ = yym453
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[92] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym454 := z.EncBinary()
					_ = yym454
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym456 := z.EncBinary()
					_ = yym456
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym457 := z.EncBinary()
					_ = yym457
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym459 := z.EncBinary()
				_ = yym459
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym460 := z.EncBinary()
				_ = yym460
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym462 := z.EncBinary()
				_ = yym462
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym463 := z.EncBinary()
				_ = yym463
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[96] {
					yym465 := z.EncBinary()
					_ = yym465
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[96] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionHard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym466 := z.EncBinary()
					_ = yym466
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[97] {
					yym468 := z.EncBinary()
					_ = yym468
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[97] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoft"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[98] {
					yym471 := z.EncBinary()
					_ = yym471
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[98] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoftGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[99] {
					yy474 := &x.EvictionPressureTransitionPeriod
					yym475 := z.EncBinary()
					_ = yym475
					if false {
					} else if z.HasExtensions() && z.EncExt(yy474) {
					} else if !yym475 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy474)
					} else {
						z.EncFallback(yy474)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[99] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionPressureTransitionPeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy476 := &x.EvictionPressureTransitionPeriod
					yym477 := z.EncBinary()
					_ = yym477
					if false {
					} else if z.HasExtensions() && z.EncExt(yy476) {
					} else if !yym477 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy476)
					} else {
						z.EncFallback(yy476)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[100] {
					yym479 := z.EncBinary()
					_ = yym479
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq153[100] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMaxPodGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym480 := z.EncBinary()
					_ = yym480
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[101] {
					yym482 := z.EncBinary()
					_ = yym482
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[101] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMinimumReclaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym483 := z.EncBinary()
					_ = yym483
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym485 := z.EncBinary()
				_ = yym485
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalKernelMemcgNotification))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("experimentalKernelMemcgNotification"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym486 := z.EncBinary()
				_ = yym486
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalKernelMemcgNotification))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym488 := z.EncBinary()
				_ = yym488
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podsPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym489 := z.EncBinary()
				_ = yym489
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym491 := z.EncBinary()
				_ = yym491
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableControllerAttachDetach"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym492 := z.EncBinary()
				_ = yym492
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym494 := z.EncBinary()
					_ = yym494
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg3_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym495 := z.EncBinary()
					_ = yym495
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg3_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym497 := z.EncBinary()
					_ = yym497
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg3_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym498 := z.EncBinary()
					_ = yym498
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg3_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym500 := z.EncBinary()
				_ = yym500
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protectKernelDefaults"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym501 := z.EncBinary()
				_ = yym501
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym503 := z.EncBinary()
				_ = yym503
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("makeIPTablesUtilChains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym504 := z.EncBinary()
				_ = yym504
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym506 := z.EncBinary()
				_ = yym506
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym507 := z.EncBinary()
				_ = yym507
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym509 := z.EncBinary()
				_ = yym509
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesDropBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym510 := z.EncBinary()
				_ = yym510
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[111] {
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym512 := z.EncBinary()
						_ = yym512
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[111] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalAllowedUnsafeSysctls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym513 := z.EncBinary()
						_ = yym513
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym515 := z.EncBinary()
				_ = yym515
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FeatureGates))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("featureGates"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym516 := z.EncBinary()
				_ = yym516
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FeatureGates))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[113] {
					yym518 := z.EncBinary()
					_ = yym518
					if false {
					} else {
						r.EncodeBool(bool(x.EnableCRI))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[113] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("enableCRI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						r.EncodeBool(bool(x.EnableCRI))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[114] {
					yym521 := z.EncBinary()
					_ = yym521
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalFailSwapOn))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[114] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalFailSwapOn"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym522 := z.EncBinary()
					_ = yym522
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalFailSwapOn))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[115] {
					yym524 := z.EncBinary()
					_ = yym524
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCheckNodeCapabilitiesBeforeMount))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[115] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ExperimentalCheckNodeCapabilitiesBeforeMount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym525 := z.EncBinary()
					_ = yym525
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCheckNodeCapabilitiesBeforeMount))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym526 := z.DecBinary()
	_ = yym526
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct527 := r.ContainerType()
		if yyct527 == codecSelferValueTypeMap1234 {
			yyl527 := r.ReadMapStart()
			if yyl527 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl527, d)
			}
		} else if yyct527 == codecSelferValueTypeArray1234 {
			yyl527 := r.ReadArrayStart()
			if yyl527 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl527, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys528Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys528Slc
	var yyhl528 bool = l >= 0
	for yyj528 := 0; ; yyj528++ {
		if yyhl528 {
			if yyj528 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys528Slc = r.DecodeBytes(yys528Slc, true, true)
		yys528 := string(yys528Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys528 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "podManifestPath":
			if r.TryDecodeAsNil() {
				x.PodManifestPath = ""
			} else {
				x.PodManifestPath = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_v1.Duration{}
			} else {
				yyv532 := &x.SyncFrequency
				yym533 := z.DecBinary()
				_ = yym533
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv532) {
				} else if !yym533 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv532)
				} else {
					z.DecFallback(yyv532, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_v1.Duration{}
			} else {
				yyv534 := &x.FileCheckFrequency
				yym535 := z.DecBinary()
				_ = yym535
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv534) {
				} else if !yym535 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv534)
				} else {
					z.DecFallback(yyv534, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_v1.Duration{}
			} else {
				yyv536 := &x.HTTPCheckFrequency
				yym537 := z.DecBinary()
				_ = yym537
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv536) {
				} else if !yym537 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv536)
				} else {
					z.DecFallback(yyv536, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = int32(r.DecodeInt(32))
			}
		case "tlsCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tlsPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "authentication":
			if r.TryDecodeAsNil() {
				x.Authentication = KubeletAuthentication{}
			} else {
				yyv547 := &x.Authentication
				yyv547.CodecDecodeSelf(d)
			}
		case "authorization":
			if r.TryDecodeAsNil() {
				x.Authorization = KubeletAuthorization{}
			} else {
				yyv548 := &x.Authorization
				yyv548.CodecDecodeSelf(d)
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "seccompProfileRoot":
			if r.TryDecodeAsNil() {
				x.SeccompProfileRoot = ""
			} else {
				x.SeccompProfileRoot = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = nil
			} else {
				yyv555 := &x.HostNetworkSources
				yym556 := z.DecBinary()
				_ = yym556
				if false {
				} else {
					z.F.DecSliceStringX(yyv555, false, d)
				}
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = nil
			} else {
				yyv557 := &x.HostPIDSources
				yym558 := z.DecBinary()
				_ = yym558
				if false {
				} else {
					z.F.DecSliceStringX(yyv557, false, d)
				}
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = nil
			} else {
				yyv559 := &x.HostIPCSources
				yym560 := z.DecBinary()
				_ = yym560
				if false {
				} else {
					z.F.DecSliceStringX(yyv559, false, d)
				}
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = int32(r.DecodeInt(32))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int32(r.DecodeInt(32))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = int32(r.DecodeInt(32))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int32(r.DecodeInt(32))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_v1.Duration{}
			} else {
				yyv566 := &x.MinimumGCAge
				yym567 := z.DecBinary()
				_ = yym567
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv566) {
				} else if !yym567 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv566)
				} else {
					z.DecFallback(yyv566, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int32(r.DecodeInt(32))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = int32(r.DecodeInt(32))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int32(r.DecodeInt(32))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_v1.Duration{}
			} else {
				yyv578 := &x.StreamingConnectionIdleTimeout
				yym579 := z.DecBinary()
				_ = yym579
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv578) {
				} else if !yym579 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv578)
				} else {
					z.DecFallback(yyv578, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_v1.Duration{}
			} else {
				yyv580 := &x.NodeStatusUpdateFrequency
				yym581 := z.DecBinary()
				_ = yym581
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv580) {
				} else if !yym581 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv580)
				} else {
					z.DecFallback(yyv580, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_v1.Duration{}
			} else {
				yyv582 := &x.ImageMinimumGCAge
				yym583 := z.DecBinary()
				_ = yym583
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv582) {
				} else if !yym583 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv582)
				} else {
					z.DecFallback(yyv582, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
			}
		case "volumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_v1.Duration{}
			} else {
				yyv587 := &x.VolumeStatsAggPeriod
				yym588 := z.DecBinary()
				_ = yym588
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv587) {
				} else if !yym588 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv587)
				} else {
					z.DecFallback(yyv587, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginMTU":
			if r.TryDecodeAsNil() {
				x.NetworkPluginMTU = 0
			} else {
				x.NetworkPluginMTU = int32(r.DecodeInt(32))
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "cniConfDir":
			if r.TryDecodeAsNil() {
				x.CNIConfDir = ""
			} else {
				x.CNIConfDir = string(r.DecodeString())
			}
		case "cniBinDir":
			if r.TryDecodeAsNil() {
				x.CNIBinDir = ""
			} else {
				x.CNIBinDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "experimentalCgroupsPerQOS":
			if r.TryDecodeAsNil() {
				x.ExperimentalCgroupsPerQOS = false
			} else {
				x.ExperimentalCgroupsPerQOS = bool(r.DecodeBool())
			}
		case "cgroupDriver":
			if r.TryDecodeAsNil() {
				x.CgroupDriver = ""
			} else {
				x.CgroupDriver = string(r.DecodeString())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemCgroups":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "remoteRuntimeEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteRuntimeEndpoint = ""
			} else {
				x.RemoteRuntimeEndpoint = string(r.DecodeString())
			}
		case "remoteImageEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteImageEndpoint = ""
			} else {
				x.RemoteImageEndpoint = string(r.DecodeString())
			}
		case "runtimeRequestTimeout":
			if r.TryDecodeAsNil() {
				x.RuntimeRequestTimeout = pkg1_v1.Duration{}
			} else {
				yyv606 := &x.RuntimeRequestTimeout
				yym607 := z.DecBinary()
				_ = yym607
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv606) {
				} else if !yym607 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv606)
				} else {
					z.DecFallback(yyv606, false)
				}
			}
		case "imagePullProgressDeadline":
			if r.TryDecodeAsNil() {
				x.ImagePullProgressDeadline = pkg1_v1.Duration{}
			} else {
				yyv608 := &x.ImagePullProgressDeadline
				yym609 := z.DecBinary()
				_ = yym609
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv608) {
				} else if !yym609 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv608)
				} else {
					z.DecFallback(yyv608, false)
				}
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "experimentalMounterPath":
			if r.TryDecodeAsNil() {
				x.ExperimentalMounterPath = ""
			} else {
				x.ExperimentalMounterPath = string(r.DecodeString())
			}
		case "rktAPIEndpoint":
			if r.TryDecodeAsNil() {
				x.RktAPIEndpoint = ""
			} else {
				x.RktAPIEndpoint = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "exitOnLockContention":
			if r.TryDecodeAsNil() {
				x.ExitOnLockContention = false
			} else {
				x.ExitOnLockContention = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "babysitDaemons":
			if r.TryDecodeAsNil() {
				x.BabysitDaemons = false
			} else {
				x.BabysitDaemons = bool(r.DecodeBool())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int32(r.DecodeInt(32))
			}
		case "nvidiaGPUs":
			if r.TryDecodeAsNil() {
				x.NvidiaGPUs = 0
			} else {
				x.NvidiaGPUs = int32(r.DecodeInt(32))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = int64(r.DecodeInt(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "registerWithTaints":
			if r.TryDecodeAsNil() {
				x.RegisterWithTaints = nil
			} else {
				yyv628 := &x.RegisterWithTaints
				yym629 := z.DecBinary()
				_ = yym629
				if false {
				} else {
					h.decSliceapi_Taint((*[]pkg2_api.Taint)(yyv628), d)
				}
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int32(r.DecodeInt(32))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_v1.Duration{}
			} else {
				yyv634 := &x.OutOfDiskTransitionFrequency
				yym635 := z.DecBinary()
				_ = yym635
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv634) {
				} else if !yym635 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv634)
				} else {
					z.DecFallback(yyv634, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv637 := &x.NodeLabels
				yym638 := z.DecBinary()
				_ = yym638
				if false {
				} else {
					z.F.DecMapStringStringX(yyv637, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		case "evictionHard":
			if r.TryDecodeAsNil() {
				x.EvictionHard = ""
			} else {
				x.EvictionHard = string(r.DecodeString())
			}
		case "evictionSoft":
			if r.TryDecodeAsNil() {
				x.EvictionSoft = ""
			} else {
				x.EvictionSoft = string(r.DecodeString())
			}
		case "evictionSoftGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionSoftGracePeriod = ""
			} else {
				x.EvictionSoftGracePeriod = string(r.DecodeString())
			}
		case "evictionPressureTransitionPeriod":
			if r.TryDecodeAsNil() {
				x.EvictionPressureTransitionPeriod = pkg1_v1.Duration{}
			} else {
				yyv644 := &x.EvictionPressureTransitionPeriod
				yym645 := z.DecBinary()
				_ = yym645
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv644) {
				} else if !yym645 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv644)
				} else {
					z.DecFallback(yyv644, false)
				}
			}
		case "evictionMaxPodGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionMaxPodGracePeriod = 0
			} else {
				x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
			}
		case "evictionMinimumReclaim":
			if r.TryDecodeAsNil() {
				x.EvictionMinimumReclaim = ""
			} else {
				x.EvictionMinimumReclaim = string(r.DecodeString())
			}
		case "experimentalKernelMemcgNotification":
			if r.TryDecodeAsNil() {
				x.ExperimentalKernelMemcgNotification = false
			} else {
				x.ExperimentalKernelMemcgNotification = bool(r.DecodeBool())
			}
		case "podsPerCore":
			if r.TryDecodeAsNil() {
				x.PodsPerCore = 0
			} else {
				x.PodsPerCore = int32(r.DecodeInt(32))
			}
		case "enableControllerAttachDetach":
			if r.TryDecodeAsNil() {
				x.EnableControllerAttachDetach = false
			} else {
				x.EnableControllerAttachDetach = bool(r.DecodeBool())
			}
		case "systemReserved":
			if r.TryDecodeAsNil() {
				x.SystemReserved = nil
			} else {
				yyv651 := &x.SystemReserved
				yym652 := z.DecBinary()
				_ = yym652
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv651) {
				} else {
					h.decconfig_ConfigurationMap((*pkg3_config.ConfigurationMap)(yyv651), d)
				}
			}
		case "kubeReserved":
			if r.TryDecodeAsNil() {
				x.KubeReserved = nil
			} else {
				yyv653 := &x.KubeReserved
				yym654 := z.DecBinary()
				_ = yym654
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv653) {
				} else {
					h.decconfig_ConfigurationMap((*pkg3_config.ConfigurationMap)(yyv653), d)
				}
			}
		case "protectKernelDefaults":
			if r.TryDecodeAsNil() {
				x.ProtectKernelDefaults = false
			} else {
				x.ProtectKernelDefaults = bool(r.DecodeBool())
			}
		case "makeIPTablesUtilChains":
			if r.TryDecodeAsNil() {
				x.MakeIPTablesUtilChains = false
			} else {
				x.MakeIPTablesUtilChains = bool(r.DecodeBool())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				x.IPTablesMasqueradeBit = 0
			} else {
				x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
			}
		case "iptablesDropBit":
			if r.TryDecodeAsNil() {
				x.IPTablesDropBit = 0
			} else {
				x.IPTablesDropBit = int32(r.DecodeInt(32))
			}
		case "experimentalAllowedUnsafeSysctls":
			if r.TryDecodeAsNil() {
				x.AllowedUnsafeSysctls = nil
			} else {
				yyv659 := &x.AllowedUnsafeSysctls
				yym660 := z.DecBinary()
				_ = yym660
				if false {
				} else {
					z.F.DecSliceStringX(yyv659, false, d)
				}
			}
		case "featureGates":
			if r.TryDecodeAsNil() {
				x.FeatureGates = ""
			} else {
				x.FeatureGates = string(r.DecodeString())
			}
		case "enableCRI":
			if r.TryDecodeAsNil() {
				x.EnableCRI = false
			} else {
				x.EnableCRI = bool(r.DecodeBool())
			}
		case "experimentalFailSwapOn":
			if r.TryDecodeAsNil() {
				x.ExperimentalFailSwapOn = false
			} else {
				x.ExperimentalFailSwapOn = bool(r.DecodeBool())
			}
		case "ExperimentalCheckNodeCapabilitiesBeforeMount":
			if r.TryDecodeAsNil() {
				x.ExperimentalCheckNodeCapabilitiesBeforeMount = false
			} else {
				x.ExperimentalCheckNodeCapabilitiesBeforeMount = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys528)
		} // end switch yys528
	} // end for yyj528
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj665 int
	var yyb665 bool
	var yyhl665 bool = l >= 0
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodManifestPath = ""
	} else {
		x.PodManifestPath = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_v1.Duration{}
	} else {
		yyv669 := &x.SyncFrequency
		yym670 := z.DecBinary()
		_ = yym670
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv669) {
		} else if !yym670 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv669)
		} else {
			z.DecFallback(yyv669, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_v1.Duration{}
	} else {
		yyv671 := &x.FileCheckFrequency
		yym672 := z.DecBinary()
		_ = yym672
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv671) {
		} else if !yym672 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv671)
		} else {
			z.DecFallback(yyv671, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_v1.Duration{}
	} else {
		yyv673 := &x.HTTPCheckFrequency
		yym674 := z.DecBinary()
		_ = yym674
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv673) {
		} else if !yym674 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv673)
		} else {
			z.DecFallback(yyv673, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authentication = KubeletAuthentication{}
	} else {
		yyv684 := &x.Authentication
		yyv684.CodecDecodeSelf(d)
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authorization = KubeletAuthorization{}
	} else {
		yyv685 := &x.Authorization
		yyv685.CodecDecodeSelf(d)
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SeccompProfileRoot = ""
	} else {
		x.SeccompProfileRoot = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = nil
	} else {
		yyv692 := &x.HostNetworkSources
		yym693 := z.DecBinary()
		_ = yym693
		if false {
		} else {
			z.F.DecSliceStringX(yyv692, false, d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = nil
	} else {
		yyv694 := &x.HostPIDSources
		yym695 := z.DecBinary()
		_ = yym695
		if false {
		} else {
			z.F.DecSliceStringX(yyv694, false, d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = nil
	} else {
		yyv696 := &x.HostIPCSources
		yym697 := z.DecBinary()
		_ = yym697
		if false {
		} else {
			z.F.DecSliceStringX(yyv696, false, d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_v1.Duration{}
	} else {
		yyv703 := &x.MinimumGCAge
		yym704 := z.DecBinary()
		_ = yym704
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv703) {
		} else if !yym704 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv703)
		} else {
			z.DecFallback(yyv703, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_v1.Duration{}
	} else {
		yyv715 := &x.StreamingConnectionIdleTimeout
		yym716 := z.DecBinary()
		_ = yym716
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv715) {
		} else if !yym716 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv715)
		} else {
			z.DecFallback(yyv715, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_v1.Duration{}
	} else {
		yyv717 := &x.NodeStatusUpdateFrequency
		yym718 := z.DecBinary()
		_ = yym718
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv717) {
		} else if !yym718 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv717)
		} else {
			z.DecFallback(yyv717, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_v1.Duration{}
	} else {
		yyv719 := &x.ImageMinimumGCAge
		yym720 := z.DecBinary()
		_ = yym720
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv719) {
		} else if !yym720 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv719)
		} else {
			z.DecFallback(yyv719, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_v1.Duration{}
	} else {
		yyv724 := &x.VolumeStatsAggPeriod
		yym725 := z.DecBinary()
		_ = yym725
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv724) {
		} else if !yym725 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv724)
		} else {
			z.DecFallback(yyv724, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginMTU = 0
	} else {
		x.NetworkPluginMTU = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIConfDir = ""
	} else {
		x.CNIConfDir = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIBinDir = ""
	} else {
		x.CNIBinDir = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalCgroupsPerQOS = false
	} else {
		x.ExperimentalCgroupsPerQOS = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupDriver = ""
	} else {
		x.CgroupDriver = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteRuntimeEndpoint = ""
	} else {
		x.RemoteRuntimeEndpoint = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteImageEndpoint = ""
	} else {
		x.RemoteImageEndpoint = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeRequestTimeout = pkg1_v1.Duration{}
	} else {
		yyv743 := &x.RuntimeRequestTimeout
		yym744 := z.DecBinary()
		_ = yym744
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv743) {
		} else if !yym744 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv743)
		} else {
			z.DecFallback(yyv743, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullProgressDeadline = pkg1_v1.Duration{}
	} else {
		yyv745 := &x.ImagePullProgressDeadline
		yym746 := z.DecBinary()
		_ = yym746
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv745) {
		} else if !yym746 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv745)
		} else {
			z.DecFallback(yyv745, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalMounterPath = ""
	} else {
		x.ExperimentalMounterPath = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktAPIEndpoint = ""
	} else {
		x.RktAPIEndpoint = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitOnLockContention = false
	} else {
		x.ExitOnLockContention = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BabysitDaemons = false
	} else {
		x.BabysitDaemons = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NvidiaGPUs = 0
	} else {
		x.NvidiaGPUs = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = int64(r.DecodeInt(64))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterWithTaints = nil
	} else {
		yyv765 := &x.RegisterWithTaints
		yym766 := z.DecBinary()
		_ = yym766
		if false {
		} else {
			h.decSliceapi_Taint((*[]pkg2_api.Taint)(yyv765), d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_v1.Duration{}
	} else {
		yyv771 := &x.OutOfDiskTransitionFrequency
		yym772 := z.DecBinary()
		_ = yym772
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv771) {
		} else if !yym772 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv771)
		} else {
			z.DecFallback(yyv771, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv774 := &x.NodeLabels
		yym775 := z.DecBinary()
		_ = yym775
		if false {
		} else {
			z.F.DecMapStringStringX(yyv774, false, d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionHard = ""
	} else {
		x.EvictionHard = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoft = ""
	} else {
		x.EvictionSoft = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoftGracePeriod = ""
	} else {
		x.EvictionSoftGracePeriod = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionPressureTransitionPeriod = pkg1_v1.Duration{}
	} else {
		yyv781 := &x.EvictionPressureTransitionPeriod
		yym782 := z.DecBinary()
		_ = yym782
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv781) {
		} else if !yym782 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv781)
		} else {
			z.DecFallback(yyv781, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMaxPodGracePeriod = 0
	} else {
		x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMinimumReclaim = ""
	} else {
		x.EvictionMinimumReclaim = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalKernelMemcgNotification = false
	} else {
		x.ExperimentalKernelMemcgNotification = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodsPerCore = 0
	} else {
		x.PodsPerCore = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableControllerAttachDetach = false
	} else {
		x.EnableControllerAttachDetach = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemReserved = nil
	} else {
		yyv788 := &x.SystemReserved
		yym789 := z.DecBinary()
		_ = yym789
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv788) {
		} else {
			h.decconfig_ConfigurationMap((*pkg3_config.ConfigurationMap)(yyv788), d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeReserved = nil
	} else {
		yyv790 := &x.KubeReserved
		yym791 := z.DecBinary()
		_ = yym791
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv790) {
		} else {
			h.decconfig_ConfigurationMap((*pkg3_config.ConfigurationMap)(yyv790), d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectKernelDefaults = false
	} else {
		x.ProtectKernelDefaults = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MakeIPTablesUtilChains = false
	} else {
		x.MakeIPTablesUtilChains = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMasqueradeBit = 0
	} else {
		x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesDropBit = 0
	} else {
		x.IPTablesDropBit = int32(r.DecodeInt(32))
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedUnsafeSysctls = nil
	} else {
		yyv796 := &x.AllowedUnsafeSysctls
		yym797 := z.DecBinary()
		_ = yym797
		if false {
		} else {
			z.F.DecSliceStringX(yyv796, false, d)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FeatureGates = ""
	} else {
		x.FeatureGates = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCRI = false
	} else {
		x.EnableCRI = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFailSwapOn = false
	} else {
		x.ExperimentalFailSwapOn = bool(r.DecodeBool())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalCheckNodeCapabilitiesBeforeMount = false
	} else {
		x.ExperimentalCheckNodeCapabilitiesBeforeMount = bool(r.DecodeBool())
	}
	for {
		yyj665++
		if yyhl665 {
			yyb665 = yyj665 > l
		} else {
			yyb665 = r.CheckBreak()
		}
		if yyb665 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj665-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x KubeletAuthorizationMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym802 := z.EncBinary()
	_ = yym802
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *KubeletAuthorizationMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym803 := z.DecBinary()
	_ = yym803
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletAuthorization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym804 := z.EncBinary()
		_ = yym804
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep805 := !z.EncBinary()
			yy2arr805 := z.EncBasicHandle().StructToArray
			var yyq805 [2]bool
			_, _, _ = yysep805, yyq805, yy2arr805
			const yyr805 bool = false
			var yynn805 int
			if yyr805 || yy2arr805 {
				r.EncodeArrayStart(2)
			} else {
				yynn805 = 2
				for _, b := range yyq805 {
					if b {
						yynn805++
					}
				}
				r.EncodeMapStart(yynn805)
				yynn805 = 0
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy808 := &x.Webhook
				yy808.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("webhook"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy809 := &x.Webhook
				yy809.CodecEncodeSelf(e)
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAuthorization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym810 := z.DecBinary()
	_ = yym810
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct811 := r.ContainerType()
		if yyct811 == codecSelferValueTypeMap1234 {
			yyl811 := r.ReadMapStart()
			if yyl811 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl811, d)
			}
		} else if yyct811 == codecSelferValueTypeArray1234 {
			yyl811 := r.ReadArrayStart()
			if yyl811 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl811, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAuthorization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys812Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys812Slc
	var yyhl812 bool = l >= 0
	for yyj812 := 0; ; yyj812++ {
		if yyhl812 {
			if yyj812 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys812Slc = r.DecodeBytes(yys812Slc, true, true)
		yys812 := string(yys812Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys812 {
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = KubeletAuthorizationMode(r.DecodeString())
			}
		case "webhook":
			if r.TryDecodeAsNil() {
				x.Webhook = KubeletWebhookAuthorization{}
			} else {
				yyv814 := &x.Webhook
				yyv814.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys812)
		} // end switch yys812
	} // end for yyj812
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAuthorization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj815 int
	var yyb815 bool
	var yyhl815 bool = l >= 0
	yyj815++
	if yyhl815 {
		yyb815 = yyj815 > l
	} else {
		yyb815 = r.CheckBreak()
	}
	if yyb815 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = KubeletAuthorizationMode(r.DecodeString())
	}
	yyj815++
	if yyhl815 {
		yyb815 = yyj815 > l
	} else {
		yyb815 = r.CheckBreak()
	}
	if yyb815 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Webhook = KubeletWebhookAuthorization{}
	} else {
		yyv817 := &x.Webhook
		yyv817.CodecDecodeSelf(d)
	}
	for {
		yyj815++
		if yyhl815 {
			yyb815 = yyj815 > l
		} else {
			yyb815 = r.CheckBreak()
		}
		if yyb815 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj815-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletWebhookAuthorization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym818 := z.EncBinary()
		_ = yym818
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep819 := !z.EncBinary()
			yy2arr819 := z.EncBasicHandle().StructToArray
			var yyq819 [2]bool
			_, _, _ = yysep819, yyq819, yy2arr819
			const yyr819 bool = false
			var yynn819 int
			if yyr819 || yy2arr819 {
				r.EncodeArrayStart(2)
			} else {
				yynn819 = 2
				for _, b := range yyq819 {
					if b {
						yynn819++
					}
				}
				r.EncodeMapStart(yynn819)
				yynn819 = 0
			}
			if yyr819 || yy2arr819 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy821 := &x.CacheAuthorizedTTL
				yym822 := z.EncBinary()
				_ = yym822
				if false {
				} else if z.HasExtensions() && z.EncExt(yy821) {
				} else if !yym822 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy821)
				} else {
					z.EncFallback(yy821)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheAuthorizedTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy823 := &x.CacheAuthorizedTTL
				yym824 := z.EncBinary()
				_ = yym824
				if false {
				} else if z.HasExtensions() && z.EncExt(yy823) {
				} else if !yym824 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy823)
				} else {
					z.EncFallback(yy823)
				}
			}
			if yyr819 || yy2arr819 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy826 := &x.CacheUnauthorizedTTL
				yym827 := z.EncBinary()
				_ = yym827
				if false {
				} else if z.HasExtensions() && z.EncExt(yy826) {
				} else if !yym827 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy826)
				} else {
					z.EncFallback(yy826)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheUnauthorizedTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy828 := &x.CacheUnauthorizedTTL
				yym829 := z.EncBinary()
				_ = yym829
				if false {
				} else if z.HasExtensions() && z.EncExt(yy828) {
				} else if !yym829 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy828)
				} else {
					z.EncFallback(yy828)
				}
			}
			if yyr819 || yy2arr819 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletWebhookAuthorization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym830 := z.DecBinary()
	_ = yym830
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct831 := r.ContainerType()
		if yyct831 == codecSelferValueTypeMap1234 {
			yyl831 := r.ReadMapStart()
			if yyl831 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl831, d)
			}
		} else if yyct831 == codecSelferValueTypeArray1234 {
			yyl831 := r.ReadArrayStart()
			if yyl831 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl831, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletWebhookAuthorization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys832Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys832Slc
	var yyhl832 bool = l >= 0
	for yyj832 := 0; ; yyj832++ {
		if yyhl832 {
			if yyj832 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys832Slc = r.DecodeBytes(yys832Slc, true, true)
		yys832 := string(yys832Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys832 {
		case "cacheAuthorizedTTL":
			if r.TryDecodeAsNil() {
				x.CacheAuthorizedTTL = pkg1_v1.Duration{}
			} else {
				yyv833 := &x.CacheAuthorizedTTL
				yym834 := z.DecBinary()
				_ = yym834
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv833) {
				} else if !yym834 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv833)
				} else {
					z.DecFallback(yyv833, false)
				}
			}
		case "cacheUnauthorizedTTL":
			if r.TryDecodeAsNil() {
				x.CacheUnauthorizedTTL = pkg1_v1.Duration{}
			} else {
				yyv835 := &x.CacheUnauthorizedTTL
				yym836 := z.DecBinary()
				_ = yym836
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv835) {
				} else if !yym836 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv835)
				} else {
					z.DecFallback(yyv835, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys832)
		} // end switch yys832
	} // end for yyj832
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletWebhookAuthorization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj837 int
	var yyb837 bool
	var yyhl837 bool = l >= 0
	yyj837++
	if yyhl837 {
		yyb837 = yyj837 > l
	} else {
		yyb837 = r.CheckBreak()
	}
	if yyb837 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheAuthorizedTTL = pkg1_v1.Duration{}
	} else {
		yyv838 := &x.CacheAuthorizedTTL
		yym839 := z.DecBinary()
		_ = yym839
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv838) {
		} else if !yym839 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv838)
		} else {
			z.DecFallback(yyv838, false)
		}
	}
	yyj837++
	if yyhl837 {
		yyb837 = yyj837 > l
	} else {
		yyb837 = r.CheckBreak()
	}
	if yyb837 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheUnauthorizedTTL = pkg1_v1.Duration{}
	} else {
		yyv840 := &x.CacheUnauthorizedTTL
		yym841 := z.DecBinary()
		_ = yym841
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv840) {
		} else if !yym841 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv840)
		} else {
			z.DecFallback(yyv840, false)
		}
	}
	for {
		yyj837++
		if yyhl837 {
			yyb837 = yyj837 > l
		} else {
			yyb837 = r.CheckBreak()
		}
		if yyb837 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj837-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym842 := z.EncBinary()
		_ = yym842
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep843 := !z.EncBinary()
			yy2arr843 := z.EncBasicHandle().StructToArray
			var yyq843 [3]bool
			_, _, _ = yysep843, yyq843, yy2arr843
			const yyr843 bool = false
			var yynn843 int
			if yyr843 || yy2arr843 {
				r.EncodeArrayStart(3)
			} else {
				yynn843 = 3
				for _, b := range yyq843 {
					if b {
						yynn843++
					}
				}
				r.EncodeMapStart(yynn843)
				yynn843 = 0
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy845 := &x.X509
				yy845.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("x509"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy846 := &x.X509
				yy846.CodecEncodeSelf(e)
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy848 := &x.Webhook
				yy848.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("webhook"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy849 := &x.Webhook
				yy849.CodecEncodeSelf(e)
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy851 := &x.Anonymous
				yy851.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("anonymous"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy852 := &x.Anonymous
				yy852.CodecEncodeSelf(e)
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym853 := z.DecBinary()
	_ = yym853
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct854 := r.ContainerType()
		if yyct854 == codecSelferValueTypeMap1234 {
			yyl854 := r.ReadMapStart()
			if yyl854 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl854, d)
			}
		} else if yyct854 == codecSelferValueTypeArray1234 {
			yyl854 := r.ReadArrayStart()
			if yyl854 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl854, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys855Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys855Slc
	var yyhl855 bool = l >= 0
	for yyj855 := 0; ; yyj855++ {
		if yyhl855 {
			if yyj855 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys855Slc = r.DecodeBytes(yys855Slc, true, true)
		yys855 := string(yys855Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys855 {
		case "x509":
			if r.TryDecodeAsNil() {
				x.X509 = KubeletX509Authentication{}
			} else {
				yyv856 := &x.X509
				yyv856.CodecDecodeSelf(d)
			}
		case "webhook":
			if r.TryDecodeAsNil() {
				x.Webhook = KubeletWebhookAuthentication{}
			} else {
				yyv857 := &x.Webhook
				yyv857.CodecDecodeSelf(d)
			}
		case "anonymous":
			if r.TryDecodeAsNil() {
				x.Anonymous = KubeletAnonymousAuthentication{}
			} else {
				yyv858 := &x.Anonymous
				yyv858.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys855)
		} // end switch yys855
	} // end for yyj855
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj859 int
	var yyb859 bool
	var yyhl859 bool = l >= 0
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.X509 = KubeletX509Authentication{}
	} else {
		yyv860 := &x.X509
		yyv860.CodecDecodeSelf(d)
	}
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Webhook = KubeletWebhookAuthentication{}
	} else {
		yyv861 := &x.Webhook
		yyv861.CodecDecodeSelf(d)
	}
	yyj859++
	if yyhl859 {
		yyb859 = yyj859 > l
	} else {
		yyb859 = r.CheckBreak()
	}
	if yyb859 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Anonymous = KubeletAnonymousAuthentication{}
	} else {
		yyv862 := &x.Anonymous
		yyv862.CodecDecodeSelf(d)
	}
	for {
		yyj859++
		if yyhl859 {
			yyb859 = yyj859 > l
		} else {
			yyb859 = r.CheckBreak()
		}
		if yyb859 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj859-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletX509Authentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym863 := z.EncBinary()
		_ = yym863
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep864 := !z.EncBinary()
			yy2arr864 := z.EncBasicHandle().StructToArray
			var yyq864 [1]bool
			_, _, _ = yysep864, yyq864, yy2arr864
			const yyr864 bool = false
			var yynn864 int
			if yyr864 || yy2arr864 {
				r.EncodeArrayStart(1)
			} else {
				yynn864 = 1
				for _, b := range yyq864 {
					if b {
						yynn864++
					}
				}
				r.EncodeMapStart(yynn864)
				yynn864 = 0
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym866 := z.EncBinary()
				_ = yym866
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClientCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clientCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym867 := z.EncBinary()
				_ = yym867
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClientCAFile))
				}
			}
			if yyr864 || yy2arr864 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletX509Authentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym868 := z.DecBinary()
	_ = yym868
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct869 := r.ContainerType()
		if yyct869 == codecSelferValueTypeMap1234 {
			yyl869 := r.ReadMapStart()
			if yyl869 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl869, d)
			}
		} else if yyct869 == codecSelferValueTypeArray1234 {
			yyl869 := r.ReadArrayStart()
			if yyl869 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl869, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletX509Authentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys870Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys870Slc
	var yyhl870 bool = l >= 0
	for yyj870 := 0; ; yyj870++ {
		if yyhl870 {
			if yyj870 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys870Slc = r.DecodeBytes(yys870Slc, true, true)
		yys870 := string(yys870Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys870 {
		case "clientCAFile":
			if r.TryDecodeAsNil() {
				x.ClientCAFile = ""
			} else {
				x.ClientCAFile = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys870)
		} // end switch yys870
	} // end for yyj870
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletX509Authentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj872 int
	var yyb872 bool
	var yyhl872 bool = l >= 0
	yyj872++
	if yyhl872 {
		yyb872 = yyj872 > l
	} else {
		yyb872 = r.CheckBreak()
	}
	if yyb872 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClientCAFile = ""
	} else {
		x.ClientCAFile = string(r.DecodeString())
	}
	for {
		yyj872++
		if yyhl872 {
			yyb872 = yyj872 > l
		} else {
			yyb872 = r.CheckBreak()
		}
		if yyb872 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj872-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletWebhookAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym874 := z.EncBinary()
		_ = yym874
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep875 := !z.EncBinary()
			yy2arr875 := z.EncBasicHandle().StructToArray
			var yyq875 [2]bool
			_, _, _ = yysep875, yyq875, yy2arr875
			const yyr875 bool = false
			var yynn875 int
			if yyr875 || yy2arr875 {
				r.EncodeArrayStart(2)
			} else {
				yynn875 = 2
				for _, b := range yyq875 {
					if b {
						yynn875++
					}
				}
				r.EncodeMapStart(yynn875)
				yynn875 = 0
			}
			if yyr875 || yy2arr875 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym877 := z.EncBinary()
				_ = yym877
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enabled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym878 := z.EncBinary()
				_ = yym878
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			}
			if yyr875 || yy2arr875 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy880 := &x.CacheTTL
				yym881 := z.EncBinary()
				_ = yym881
				if false {
				} else if z.HasExtensions() && z.EncExt(yy880) {
				} else if !yym881 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy880)
				} else {
					z.EncFallback(yy880)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy882 := &x.CacheTTL
				yym883 := z.EncBinary()
				_ = yym883
				if false {
				} else if z.HasExtensions() && z.EncExt(yy882) {
				} else if !yym883 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy882)
				} else {
					z.EncFallback(yy882)
				}
			}
			if yyr875 || yy2arr875 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletWebhookAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym884 := z.DecBinary()
	_ = yym884
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct885 := r.ContainerType()
		if yyct885 == codecSelferValueTypeMap1234 {
			yyl885 := r.ReadMapStart()
			if yyl885 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl885, d)
			}
		} else if yyct885 == codecSelferValueTypeArray1234 {
			yyl885 := r.ReadArrayStart()
			if yyl885 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl885, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletWebhookAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys886Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys886Slc
	var yyhl886 bool = l >= 0
	for yyj886 := 0; ; yyj886++ {
		if yyhl886 {
			if yyj886 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys886Slc = r.DecodeBytes(yys886Slc, true, true)
		yys886 := string(yys886Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys886 {
		case "enabled":
			if r.TryDecodeAsNil() {
				x.Enabled = false
			} else {
				x.Enabled = bool(r.DecodeBool())
			}
		case "cacheTTL":
			if r.TryDecodeAsNil() {
				x.CacheTTL = pkg1_v1.Duration{}
			} else {
				yyv888 := &x.CacheTTL
				yym889 := z.DecBinary()
				_ = yym889
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv888) {
				} else if !yym889 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv888)
				} else {
					z.DecFallback(yyv888, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys886)
		} // end switch yys886
	} // end for yyj886
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletWebhookAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj890 int
	var yyb890 bool
	var yyhl890 bool = l >= 0
	yyj890++
	if yyhl890 {
		yyb890 = yyj890 > l
	} else {
		yyb890 = r.CheckBreak()
	}
	if yyb890 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Enabled = false
	} else {
		x.Enabled = bool(r.DecodeBool())
	}
	yyj890++
	if yyhl890 {
		yyb890 = yyj890 > l
	} else {
		yyb890 = r.CheckBreak()
	}
	if yyb890 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheTTL = pkg1_v1.Duration{}
	} else {
		yyv892 := &x.CacheTTL
		yym893 := z.DecBinary()
		_ = yym893
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv892) {
		} else if !yym893 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv892)
		} else {
			z.DecFallback(yyv892, false)
		}
	}
	for {
		yyj890++
		if yyhl890 {
			yyb890 = yyj890 > l
		} else {
			yyb890 = r.CheckBreak()
		}
		if yyb890 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj890-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletAnonymousAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym894 := z.EncBinary()
		_ = yym894
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep895 := !z.EncBinary()
			yy2arr895 := z.EncBasicHandle().StructToArray
			var yyq895 [1]bool
			_, _, _ = yysep895, yyq895, yy2arr895
			const yyr895 bool = false
			var yynn895 int
			if yyr895 || yy2arr895 {
				r.EncodeArrayStart(1)
			} else {
				yynn895 = 1
				for _, b := range yyq895 {
					if b {
						yynn895++
					}
				}
				r.EncodeMapStart(yynn895)
				yynn895 = 0
			}
			if yyr895 || yy2arr895 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym897 := z.EncBinary()
				_ = yym897
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enabled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym898 := z.EncBinary()
				_ = yym898
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			}
			if yyr895 || yy2arr895 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAnonymousAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym899 := z.DecBinary()
	_ = yym899
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct900 := r.ContainerType()
		if yyct900 == codecSelferValueTypeMap1234 {
			yyl900 := r.ReadMapStart()
			if yyl900 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl900, d)
			}
		} else if yyct900 == codecSelferValueTypeArray1234 {
			yyl900 := r.ReadArrayStart()
			if yyl900 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl900, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAnonymousAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys901Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys901Slc
	var yyhl901 bool = l >= 0
	for yyj901 := 0; ; yyj901++ {
		if yyhl901 {
			if yyj901 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys901Slc = r.DecodeBytes(yys901Slc, true, true)
		yys901 := string(yys901Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys901 {
		case "enabled":
			if r.TryDecodeAsNil() {
				x.Enabled = false
			} else {
				x.Enabled = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys901)
		} // end switch yys901
	} // end for yyj901
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAnonymousAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj903 int
	var yyb903 bool
	var yyhl903 bool = l >= 0
	yyj903++
	if yyhl903 {
		yyb903 = yyj903 > l
	} else {
		yyb903 = r.CheckBreak()
	}
	if yyb903 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Enabled = false
	} else {
		x.Enabled = bool(r.DecodeBool())
	}
	for {
		yyj903++
		if yyhl903 {
			yyb903 = yyj903 > l
		} else {
			yyb903 = r.CheckBreak()
		}
		if yyb903 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj903-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym905 := z.EncBinary()
		_ = yym905
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep906 := !z.EncBinary()
			yy2arr906 := z.EncBasicHandle().StructToArray
			var yyq906 [15]bool
			_, _, _ = yysep906, yyq906, yy2arr906
			const yyr906 bool = false
			yyq906[0] = x.Kind != ""
			yyq906[1] = x.APIVersion != ""
			var yynn906 int
			if yyr906 || yy2arr906 {
				r.EncodeArrayStart(15)
			} else {
				yynn906 = 13
				for _, b := range yyq906 {
					if b {
						yynn906++
					}
				}
				r.EncodeMapStart(yynn906)
				yynn906 = 0
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq906[0] {
					yym908 := z.EncBinary()
					_ = yym908
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq906[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym909 := z.EncBinary()
					_ = yym909
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq906[1] {
					yym911 := z.EncBinary()
					_ = yym911
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq906[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym912 := z.EncBinary()
					_ = yym912
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym914 := z.EncBinary()
				_ = yym914
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym915 := z.EncBinary()
				_ = yym915
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym917 := z.EncBinary()
				_ = yym917
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym918 := z.EncBinary()
				_ = yym918
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym920 := z.EncBinary()
				_ = yym920
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym921 := z.EncBinary()
				_ = yym921
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym924 := z.EncBinary()
				_ = yym924
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym926 := z.EncBinary()
				_ = yym926
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym927 := z.EncBinary()
				_ = yym927
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym929 := z.EncBinary()
				_ = yym929
				if false {
				} else {
					r.EncodeBool(bool(x.EnableContentionProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableContentionProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym930 := z.EncBinary()
				_ = yym930
				if false {
				} else {
					r.EncodeBool(bool(x.EnableContentionProfiling))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym932 := z.EncBinary()
				_ = yym932
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym933 := z.EncBinary()
				_ = yym933
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym935 := z.EncBinary()
				_ = yym935
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym938 := z.EncBinary()
				_ = yym938
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym939 := z.EncBinary()
				_ = yym939
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym941 := z.EncBinary()
				_ = yym941
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym942 := z.EncBinary()
				_ = yym942
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym944 := z.EncBinary()
				_ = yym944
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hardPodAffinitySymmetricWeight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym945 := z.EncBinary()
				_ = yym945
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym947 := z.EncBinary()
				_ = yym947
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("failureDomains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym948 := z.EncBinary()
				_ = yym948
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy950 := &x.LeaderElection
				yy950.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy951 := &x.LeaderElection
				yy951.CodecEncodeSelf(e)
			}
			if yyr906 || yy2arr906 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym952 := z.DecBinary()
	_ = yym952
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct953 := r.ContainerType()
		if yyct953 == codecSelferValueTypeMap1234 {
			yyl953 := r.ReadMapStart()
			if yyl953 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl953, d)
			}
		} else if yyct953 == codecSelferValueTypeArray1234 {
			yyl953 := r.ReadArrayStart()
			if yyl953 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl953, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys954Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys954Slc
	var yyhl954 bool = l >= 0
	for yyj954 := 0; ; yyj954++ {
		if yyhl954 {
			if yyj954 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys954Slc = r.DecodeBytes(yys954Slc, true, true)
		yys954 := string(yys954Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys954 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "enableContentionProfiling":
			if r.TryDecodeAsNil() {
				x.EnableContentionProfiling = false
			} else {
				x.EnableContentionProfiling = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "hardPodAffinitySymmetricWeight":
			if r.TryDecodeAsNil() {
				x.HardPodAffinitySymmetricWeight = 0
			} else {
				x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureDomains":
			if r.TryDecodeAsNil() {
				x.FailureDomains = ""
			} else {
				x.FailureDomains = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv969 := &x.LeaderElection
				yyv969.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys954)
		} // end switch yys954
	} // end for yyj954
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj970 int
	var yyb970 bool
	var yyhl970 bool = l >= 0
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableContentionProfiling = false
	} else {
		x.EnableContentionProfiling = bool(r.DecodeBool())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HardPodAffinitySymmetricWeight = 0
	} else {
		x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureDomains = ""
	} else {
		x.FailureDomains = string(r.DecodeString())
	}
	yyj970++
	if yyhl970 {
		yyb970 = yyj970 > l
	} else {
		yyb970 = r.CheckBreak()
	}
	if yyb970 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv985 := &x.LeaderElection
		yyv985.CodecDecodeSelf(d)
	}
	for {
		yyj970++
		if yyhl970 {
			yyb970 = yyj970 > l
		} else {
			yyb970 = r.CheckBreak()
		}
		if yyb970 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj970-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym986 := z.EncBinary()
		_ = yym986
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep987 := !z.EncBinary()
			yy2arr987 := z.EncBasicHandle().StructToArray
			var yyq987 [4]bool
			_, _, _ = yysep987, yyq987, yy2arr987
			const yyr987 bool = false
			var yynn987 int
			if yyr987 || yy2arr987 {
				r.EncodeArrayStart(4)
			} else {
				yynn987 = 4
				for _, b := range yyq987 {
					if b {
						yynn987++
					}
				}
				r.EncodeMapStart(yynn987)
				yynn987 = 0
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym989 := z.EncBinary()
				_ = yym989
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym990 := z.EncBinary()
				_ = yym990
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy992 := &x.LeaseDuration
				yym993 := z.EncBinary()
				_ = yym993
				if false {
				} else if z.HasExtensions() && z.EncExt(yy992) {
				} else if !yym993 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy992)
				} else {
					z.EncFallback(yy992)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy994 := &x.LeaseDuration
				yym995 := z.EncBinary()
				_ = yym995
				if false {
				} else if z.HasExtensions() && z.EncExt(yy994) {
				} else if !yym995 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy994)
				} else {
					z.EncFallback(yy994)
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy997 := &x.RenewDeadline
				yym998 := z.EncBinary()
				_ = yym998
				if false {
				} else if z.HasExtensions() && z.EncExt(yy997) {
				} else if !yym998 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy997)
				} else {
					z.EncFallback(yy997)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy999 := &x.RenewDeadline
				yym1000 := z.EncBinary()
				_ = yym1000
				if false {
				} else if z.HasExtensions() && z.EncExt(yy999) {
				} else if !yym1000 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy999)
				} else {
					z.EncFallback(yy999)
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1002 := &x.RetryPeriod
				yym1003 := z.EncBinary()
				_ = yym1003
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1002) {
				} else if !yym1003 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1002)
				} else {
					z.EncFallback(yy1002)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1004 := &x.RetryPeriod
				yym1005 := z.EncBinary()
				_ = yym1005
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1004) {
				} else if !yym1005 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1004)
				} else {
					z.EncFallback(yy1004)
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1006 := z.DecBinary()
	_ = yym1006
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1007 := r.ContainerType()
		if yyct1007 == codecSelferValueTypeMap1234 {
			yyl1007 := r.ReadMapStart()
			if yyl1007 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1007, d)
			}
		} else if yyct1007 == codecSelferValueTypeArray1234 {
			yyl1007 := r.ReadArrayStart()
			if yyl1007 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1007, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1008Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1008Slc
	var yyhl1008 bool = l >= 0
	for yyj1008 := 0; ; yyj1008++ {
		if yyhl1008 {
			if yyj1008 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1008Slc = r.DecodeBytes(yys1008Slc, true, true)
		yys1008 := string(yys1008Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1008 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_v1.Duration{}
			} else {
				yyv1010 := &x.LeaseDuration
				yym1011 := z.DecBinary()
				_ = yym1011
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1010) {
				} else if !yym1011 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1010)
				} else {
					z.DecFallback(yyv1010, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_v1.Duration{}
			} else {
				yyv1012 := &x.RenewDeadline
				yym1013 := z.DecBinary()
				_ = yym1013
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1012) {
				} else if !yym1013 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1012)
				} else {
					z.DecFallback(yyv1012, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_v1.Duration{}
			} else {
				yyv1014 := &x.RetryPeriod
				yym1015 := z.DecBinary()
				_ = yym1015
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1014) {
				} else if !yym1015 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1014)
				} else {
					z.DecFallback(yyv1014, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1008)
		} // end switch yys1008
	} // end for yyj1008
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1016 int
	var yyb1016 bool
	var yyhl1016 bool = l >= 0
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_v1.Duration{}
	} else {
		yyv1018 := &x.LeaseDuration
		yym1019 := z.DecBinary()
		_ = yym1019
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1018) {
		} else if !yym1019 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1018)
		} else {
			z.DecFallback(yyv1018, false)
		}
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_v1.Duration{}
	} else {
		yyv1020 := &x.RenewDeadline
		yym1021 := z.DecBinary()
		_ = yym1021
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1020) {
		} else if !yym1021 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1020)
		} else {
			z.DecFallback(yyv1020, false)
		}
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_v1.Duration{}
	} else {
		yyv1022 := &x.RetryPeriod
		yym1023 := z.DecBinary()
		_ = yym1023
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1022) {
		} else if !yym1023 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1022)
		} else {
			z.DecFallback(yyv1022, false)
		}
	}
	for {
		yyj1016++
		if yyhl1016 {
			yyb1016 = yyj1016 > l
		} else {
			yyb1016 = r.CheckBreak()
		}
		if yyb1016 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1016-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1024 := z.EncBinary()
		_ = yym1024
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1025 := !z.EncBinary()
			yy2arr1025 := z.EncBasicHandle().StructToArray
			var yyq1025 [61]bool
			_, _, _ = yysep1025, yyq1025, yy2arr1025
			const yyr1025 bool = false
			yyq1025[0] = x.Kind != ""
			yyq1025[1] = x.APIVersion != ""
			var yynn1025 int
			if yyr1025 || yy2arr1025 {
				r.EncodeArrayStart(61)
			} else {
				yynn1025 = 59
				for _, b := range yyq1025 {
					if b {
						yynn1025++
					}
				}
				r.EncodeMapStart(yynn1025)
				yynn1025 = 0
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1025[0] {
					yym1027 := z.EncBinary()
					_ = yym1027
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1025[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1028 := z.EncBinary()
					_ = yym1028
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1025[1] {
					yym1030 := z.EncBinary()
					_ = yym1030
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1025[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1031 := z.EncBinary()
					_ = yym1031
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1033 := z.EncBinary()
				_ = yym1033
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1034 := z.EncBinary()
				_ = yym1034
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1036 := z.EncBinary()
				_ = yym1036
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1037 := z.EncBinary()
				_ = yym1037
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1039 := z.EncBinary()
				_ = yym1039
				if false {
				} else {
					r.EncodeBool(bool(x.UseServiceAccountCredentials))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("useServiceAccountCredentials"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1040 := z.EncBinary()
				_ = yym1040
				if false {
				} else {
					r.EncodeBool(bool(x.UseServiceAccountCredentials))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1042 := z.EncBinary()
				_ = yym1042
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1045 := z.EncBinary()
				_ = yym1045
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1046 := z.EncBinary()
				_ = yym1046
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1048 := z.EncBinary()
				_ = yym1048
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1049 := z.EncBinary()
				_ = yym1049
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1051 := z.EncBinary()
				_ = yym1051
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1052 := z.EncBinary()
				_ = yym1052
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1054 := z.EncBinary()
				_ = yym1054
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1055 := z.EncBinary()
				_ = yym1055
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1057 := z.EncBinary()
				_ = yym1057
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentServiceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1058 := z.EncBinary()
				_ = yym1058
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1060 := z.EncBinary()
				_ = yym1060
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1061 := z.EncBinary()
				_ = yym1061
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1063 := z.EncBinary()
				_ = yym1063
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1064 := z.EncBinary()
				_ = yym1064
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1066 := z.EncBinary()
				_ = yym1066
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1067 := z.EncBinary()
				_ = yym1067
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1069 := z.EncBinary()
				_ = yym1069
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1070 := z.EncBinary()
				_ = yym1070
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1072 := z.EncBinary()
				_ = yym1072
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1073 := z.EncBinary()
				_ = yym1073
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1075 := z.EncBinary()
				_ = yym1075
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentSATokenSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1076 := z.EncBinary()
				_ = yym1076
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1078 := z.EncBinary()
				_ = yym1078
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRC"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1079 := z.EncBinary()
				_ = yym1079
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1081 := z.EncBinary()
				_ = yym1081
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1082 := z.EncBinary()
				_ = yym1082
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1084 := z.EncBinary()
				_ = yym1084
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForDaemonSet"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1085 := z.EncBinary()
				_ = yym1085
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1087 := &x.ServiceSyncPeriod
				yym1088 := z.EncBinary()
				_ = yym1088
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1087) {
				} else if !yym1088 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1087)
				} else {
					z.EncFallback(yy1087)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1089 := &x.ServiceSyncPeriod
				yym1090 := z.EncBinary()
				_ = yym1090
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1089) {
				} else if !yym1090 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1089)
				} else {
					z.EncFallback(yy1089)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1092 := &x.NodeSyncPeriod
				yym1093 := z.EncBinary()
				_ = yym1093
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1092) {
				} else if !yym1093 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1092)
				} else {
					z.EncFallback(yy1092)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1094 := &x.NodeSyncPeriod
				yym1095 := z.EncBinary()
				_ = yym1095
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1094) {
				} else if !yym1095 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1094)
				} else {
					z.EncFallback(yy1094)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1097 := &x.RouteReconciliationPeriod
				yym1098 := z.EncBinary()
				_ = yym1098
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1097) {
				} else if !yym1098 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1097)
				} else {
					z.EncFallback(yy1097)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("routeReconciliationPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1099 := &x.RouteReconciliationPeriod
				yym1100 := z.EncBinary()
				_ = yym1100
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1099) {
				} else if !yym1100 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1099)
				} else {
					z.EncFallback(yy1099)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1102 := &x.ResourceQuotaSyncPeriod
				yym1103 := z.EncBinary()
				_ = yym1103
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1102) {
				} else if !yym1103 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1102)
				} else {
					z.EncFallback(yy1102)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1104 := &x.ResourceQuotaSyncPeriod
				yym1105 := z.EncBinary()
				_ = yym1105
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1104) {
				} else if !yym1105 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1104)
				} else {
					z.EncFallback(yy1104)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1107 := &x.NamespaceSyncPeriod
				yym1108 := z.EncBinary()
				_ = yym1108
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1107) {
				} else if !yym1108 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1107)
				} else {
					z.EncFallback(yy1107)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1109 := &x.NamespaceSyncPeriod
				yym1110 := z.EncBinary()
				_ = yym1110
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1109) {
				} else if !yym1110 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1109)
				} else {
					z.EncFallback(yy1109)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1112 := &x.PVClaimBinderSyncPeriod
				yym1113 := z.EncBinary()
				_ = yym1113
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1112) {
				} else if !yym1113 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1112)
				} else {
					z.EncFallback(yy1112)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1114 := &x.PVClaimBinderSyncPeriod
				yym1115 := z.EncBinary()
				_ = yym1115
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1114) {
				} else if !yym1115 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1114)
				} else {
					z.EncFallback(yy1114)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1117 := &x.MinResyncPeriod
				yym1118 := z.EncBinary()
				_ = yym1118
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1117) {
				} else if !yym1118 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1117)
				} else {
					z.EncFallback(yy1117)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1119 := &x.MinResyncPeriod
				yym1120 := z.EncBinary()
				_ = yym1120
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1119) {
				} else if !yym1120 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1119)
				} else {
					z.EncFallback(yy1119)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1122 := z.EncBinary()
				_ = yym1122
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1123 := z.EncBinary()
				_ = yym1123
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1125 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1126 := z.EncBinary()
				_ = yym1126
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1125) {
				} else if !yym1126 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1125)
				} else {
					z.EncFallback(yy1125)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1127 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1128 := z.EncBinary()
				_ = yym1128
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1127) {
				} else if !yym1128 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1127)
				} else {
					z.EncFallback(yy1127)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1130 := &x.DeploymentControllerSyncPeriod
				yym1131 := z.EncBinary()
				_ = yym1131
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1130) {
				} else if !yym1131 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1130)
				} else {
					z.EncFallback(yy1130)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1132 := &x.DeploymentControllerSyncPeriod
				yym1133 := z.EncBinary()
				_ = yym1133
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1132) {
				} else if !yym1133 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1132)
				} else {
					z.EncFallback(yy1132)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1135 := &x.PodEvictionTimeout
				yym1136 := z.EncBinary()
				_ = yym1136
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1135) {
				} else if !yym1136 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1135)
				} else {
					z.EncFallback(yy1135)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1137 := &x.PodEvictionTimeout
				yym1138 := z.EncBinary()
				_ = yym1138
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1137) {
				} else if !yym1138 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1137)
				} else {
					z.EncFallback(yy1137)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1140 := z.EncBinary()
				_ = yym1140
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1141 := z.EncBinary()
				_ = yym1141
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1143 := z.EncBinary()
				_ = yym1143
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1144 := z.EncBinary()
				_ = yym1144
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1146 := &x.NodeMonitorGracePeriod
				yym1147 := z.EncBinary()
				_ = yym1147
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1146) {
				} else if !yym1147 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1146)
				} else {
					z.EncFallback(yy1146)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1148 := &x.NodeMonitorGracePeriod
				yym1149 := z.EncBinary()
				_ = yym1149
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1148) {
				} else if !yym1149 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1148)
				} else {
					z.EncFallback(yy1148)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1151 := z.EncBinary()
				_ = yym1151
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1152 := z.EncBinary()
				_ = yym1152
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1154 := &x.NodeStartupGracePeriod
				yym1155 := z.EncBinary()
				_ = yym1155
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1154) {
				} else if !yym1155 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1154)
				} else {
					z.EncFallback(yy1154)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1156 := &x.NodeStartupGracePeriod
				yym1157 := z.EncBinary()
				_ = yym1157
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1156) {
				} else if !yym1157 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1156)
				} else {
					z.EncFallback(yy1156)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1159 := &x.NodeMonitorPeriod
				yym1160 := z.EncBinary()
				_ = yym1160
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1159) {
				} else if !yym1160 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1159)
				} else {
					z.EncFallback(yy1159)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1161 := &x.NodeMonitorPeriod
				yym1162 := z.EncBinary()
				_ = yym1162
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1161) {
				} else if !yym1162 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1161)
				} else {
					z.EncFallback(yy1161)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1164 := z.EncBinary()
				_ = yym1164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1165 := z.EncBinary()
				_ = yym1165
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1167 := z.EncBinary()
				_ = yym1167
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1168 := z.EncBinary()
				_ = yym1168
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1170 := z.EncBinary()
				_ = yym1170
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1171 := z.EncBinary()
				_ = yym1171
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1173 := z.EncBinary()
				_ = yym1173
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("approveAllKubeletCSRsForGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1174 := z.EncBinary()
				_ = yym1174
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1176 := z.EncBinary()
				_ = yym1176
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1177 := z.EncBinary()
				_ = yym1177
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1179 := z.EncBinary()
				_ = yym1179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1180 := z.EncBinary()
				_ = yym1180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1182 := z.EncBinary()
				_ = yym1182
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1183 := z.EncBinary()
				_ = yym1183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1185 := z.EncBinary()
				_ = yym1185
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1186 := z.EncBinary()
				_ = yym1186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1188 := z.EncBinary()
				_ = yym1188
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeCIDRMaskSize"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1189 := z.EncBinary()
				_ = yym1189
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1191 := z.EncBinary()
				_ = yym1191
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1192 := z.EncBinary()
				_ = yym1192
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1194 := z.EncBinary()
				_ = yym1194
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCloudRoutes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1195 := z.EncBinary()
				_ = yym1195
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1197 := z.EncBinary()
				_ = yym1197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1198 := z.EncBinary()
				_ = yym1198
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1200 := z.EncBinary()
				_ = yym1200
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1201 := z.EncBinary()
				_ = yym1201
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1203 := z.EncBinary()
				_ = yym1203
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1204 := z.EncBinary()
				_ = yym1204
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1206 := z.EncBinary()
				_ = yym1206
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1207 := z.EncBinary()
				_ = yym1207
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1209 := &x.LeaderElection
				yy1209.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1210 := &x.LeaderElection
				yy1210.CodecEncodeSelf(e)
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1212 := &x.VolumeConfiguration
				yy1212.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1213 := &x.VolumeConfiguration
				yy1213.CodecEncodeSelf(e)
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1215 := &x.ControllerStartInterval
				yym1216 := z.EncBinary()
				_ = yym1216
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1215) {
				} else if !yym1216 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1215)
				} else {
					z.EncFallback(yy1215)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("controllerStartInterval"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1217 := &x.ControllerStartInterval
				yym1218 := z.EncBinary()
				_ = yym1218
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1217) {
				} else if !yym1218 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1217)
				} else {
					z.EncFallback(yy1217)
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1220 := z.EncBinary()
				_ = yym1220
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableGarbageCollector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1221 := z.EncBinary()
				_ = yym1221
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1223 := z.EncBinary()
				_ = yym1223
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentGCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1224 := z.EncBinary()
				_ = yym1224
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1226 := z.EncBinary()
				_ = yym1226
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1227 := z.EncBinary()
				_ = yym1227
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1229 := z.EncBinary()
				_ = yym1229
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secondaryNodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1230 := z.EncBinary()
				_ = yym1230
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1232 := z.EncBinary()
				_ = yym1232
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("largeClusterSizeThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1233 := z.EncBinary()
				_ = yym1233
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1235 := z.EncBinary()
				_ = yym1235
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("unhealthyZoneThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1236 := z.EncBinary()
				_ = yym1236
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			}
			if yyr1025 || yy2arr1025 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1237 := z.DecBinary()
	_ = yym1237
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1238 := r.ContainerType()
		if yyct1238 == codecSelferValueTypeMap1234 {
			yyl1238 := r.ReadMapStart()
			if yyl1238 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1238, d)
			}
		} else if yyct1238 == codecSelferValueTypeArray1234 {
			yyl1238 := r.ReadArrayStart()
			if yyl1238 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1238, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1239Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1239Slc
	var yyhl1239 bool = l >= 0
	for yyj1239 := 0; ; yyj1239++ {
		if yyhl1239 {
			if yyj1239 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1239Slc = r.DecodeBytes(yys1239Slc, true, true)
		yys1239 := string(yys1239Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1239 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "useServiceAccountCredentials":
			if r.TryDecodeAsNil() {
				x.UseServiceAccountCredentials = false
			} else {
				x.UseServiceAccountCredentials = bool(r.DecodeBool())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentServiceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentServiceSyncs = 0
			} else {
				x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentSATokenSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentSATokenSyncs = 0
			} else {
				x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRC":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRC = 0
			} else {
				x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRS":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRS = 0
			} else {
				x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForDaemonSet":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForDaemonSet = 0
			} else {
				x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1260 := &x.ServiceSyncPeriod
				yym1261 := z.DecBinary()
				_ = yym1261
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1260) {
				} else if !yym1261 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1260)
				} else {
					z.DecFallback(yyv1260, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1262 := &x.NodeSyncPeriod
				yym1263 := z.DecBinary()
				_ = yym1263
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1262) {
				} else if !yym1263 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1262)
				} else {
					z.DecFallback(yyv1262, false)
				}
			}
		case "routeReconciliationPeriod":
			if r.TryDecodeAsNil() {
				x.RouteReconciliationPeriod = pkg1_v1.Duration{}
			} else {
				yyv1264 := &x.RouteReconciliationPeriod
				yym1265 := z.DecBinary()
				_ = yym1265
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1264) {
				} else if !yym1265 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1264)
				} else {
					z.DecFallback(yyv1264, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1266 := &x.ResourceQuotaSyncPeriod
				yym1267 := z.DecBinary()
				_ = yym1267
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1266) {
				} else if !yym1267 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1266)
				} else {
					z.DecFallback(yyv1266, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1268 := &x.NamespaceSyncPeriod
				yym1269 := z.DecBinary()
				_ = yym1269
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1268) {
				} else if !yym1269 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1268)
				} else {
					z.DecFallback(yyv1268, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1270 := &x.PVClaimBinderSyncPeriod
				yym1271 := z.DecBinary()
				_ = yym1271
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1270) {
				} else if !yym1271 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1270)
				} else {
					z.DecFallback(yyv1270, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1272 := &x.MinResyncPeriod
				yym1273 := z.DecBinary()
				_ = yym1273
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1272) {
				} else if !yym1273 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1272)
				} else {
					z.DecFallback(yyv1272, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1275 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1276 := z.DecBinary()
				_ = yym1276
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1275) {
				} else if !yym1276 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1275)
				} else {
					z.DecFallback(yyv1275, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_v1.Duration{}
			} else {
				yyv1277 := &x.DeploymentControllerSyncPeriod
				yym1278 := z.DecBinary()
				_ = yym1278
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1277) {
				} else if !yym1278 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1277)
				} else {
					z.DecFallback(yyv1277, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_v1.Duration{}
			} else {
				yyv1279 := &x.PodEvictionTimeout
				yym1280 := z.DecBinary()
				_ = yym1280
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1279) {
				} else if !yym1280 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1279)
				} else {
					z.DecFallback(yyv1279, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int32(r.DecodeInt(32))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_v1.Duration{}
			} else {
				yyv1283 := &x.NodeMonitorGracePeriod
				yym1284 := z.DecBinary()
				_ = yym1284
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1283) {
				} else if !yym1284 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1283)
				} else {
					z.DecFallback(yyv1283, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int32(r.DecodeInt(32))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_v1.Duration{}
			} else {
				yyv1286 := &x.NodeStartupGracePeriod
				yym1287 := z.DecBinary()
				_ = yym1287
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1286) {
				} else if !yym1287 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1286)
				} else {
					z.DecFallback(yyv1286, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_v1.Duration{}
			} else {
				yyv1288 := &x.NodeMonitorPeriod
				yym1289 := z.DecBinary()
				_ = yym1289
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1288) {
				} else if !yym1289 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1288)
				} else {
					z.DecFallback(yyv1288, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "clusterSigningCertFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningCertFile = ""
			} else {
				x.ClusterSigningCertFile = string(r.DecodeString())
			}
		case "clusterSigningKeyFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningKeyFile = ""
			} else {
				x.ClusterSigningKeyFile = string(r.DecodeString())
			}
		case "approveAllKubeletCSRsForGroup":
			if r.TryDecodeAsNil() {
				x.ApproveAllKubeletCSRsForGroup = ""
			} else {
				x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "serviceCIDR":
			if r.TryDecodeAsNil() {
				x.ServiceCIDR = ""
			} else {
				x.ServiceCIDR = string(r.DecodeString())
			}
		case "nodeCIDRMaskSize":
			if r.TryDecodeAsNil() {
				x.NodeCIDRMaskSize = 0
			} else {
				x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "configureCloudRoutes":
			if r.TryDecodeAsNil() {
				x.ConfigureCloudRoutes = false
			} else {
				x.ConfigureCloudRoutes = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv1305 := &x.LeaderElection
				yyv1305.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv1306 := &x.VolumeConfiguration
				yyv1306.CodecDecodeSelf(d)
			}
		case "controllerStartInterval":
			if r.TryDecodeAsNil() {
				x.ControllerStartInterval = pkg1_v1.Duration{}
			} else {
				yyv1307 := &x.ControllerStartInterval
				yym1308 := z.DecBinary()
				_ = yym1308
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1307) {
				} else if !yym1308 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1307)
				} else {
					z.DecFallback(yyv1307, false)
				}
			}
		case "enableGarbageCollector":
			if r.TryDecodeAsNil() {
				x.EnableGarbageCollector = false
			} else {
				x.EnableGarbageCollector = bool(r.DecodeBool())
			}
		case "concurrentGCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentGCSyncs = 0
			} else {
				x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
			}
		case "nodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.NodeEvictionRate = 0
			} else {
				x.NodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "secondaryNodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.SecondaryNodeEvictionRate = 0
			} else {
				x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "largeClusterSizeThreshold":
			if r.TryDecodeAsNil() {
				x.LargeClusterSizeThreshold = 0
			} else {
				x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
			}
		case "unhealthyZoneThreshold":
			if r.TryDecodeAsNil() {
				x.UnhealthyZoneThreshold = 0
			} else {
				x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1239)
		} // end switch yys1239
	} // end for yyj1239
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1315 int
	var yyb1315 bool
	var yyhl1315 bool = l >= 0
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UseServiceAccountCredentials = false
	} else {
		x.UseServiceAccountCredentials = bool(r.DecodeBool())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentServiceSyncs = 0
	} else {
		x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentSATokenSyncs = 0
	} else {
		x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRC = 0
	} else {
		x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRS = 0
	} else {
		x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForDaemonSet = 0
	} else {
		x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1336 := &x.ServiceSyncPeriod
		yym1337 := z.DecBinary()
		_ = yym1337
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1336) {
		} else if !yym1337 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1336)
		} else {
			z.DecFallback(yyv1336, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1338 := &x.NodeSyncPeriod
		yym1339 := z.DecBinary()
		_ = yym1339
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1338) {
		} else if !yym1339 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1338)
		} else {
			z.DecFallback(yyv1338, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RouteReconciliationPeriod = pkg1_v1.Duration{}
	} else {
		yyv1340 := &x.RouteReconciliationPeriod
		yym1341 := z.DecBinary()
		_ = yym1341
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1340) {
		} else if !yym1341 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1340)
		} else {
			z.DecFallback(yyv1340, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1342 := &x.ResourceQuotaSyncPeriod
		yym1343 := z.DecBinary()
		_ = yym1343
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1342) {
		} else if !yym1343 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1342)
		} else {
			z.DecFallback(yyv1342, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1344 := &x.NamespaceSyncPeriod
		yym1345 := z.DecBinary()
		_ = yym1345
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1344) {
		} else if !yym1345 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1344)
		} else {
			z.DecFallback(yyv1344, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1346 := &x.PVClaimBinderSyncPeriod
		yym1347 := z.DecBinary()
		_ = yym1347
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1346) {
		} else if !yym1347 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1346)
		} else {
			z.DecFallback(yyv1346, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1348 := &x.MinResyncPeriod
		yym1349 := z.DecBinary()
		_ = yym1349
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1348) {
		} else if !yym1349 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1348)
		} else {
			z.DecFallback(yyv1348, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1351 := &x.HorizontalPodAutoscalerSyncPeriod
		yym1352 := z.DecBinary()
		_ = yym1352
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1351) {
		} else if !yym1352 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1351)
		} else {
			z.DecFallback(yyv1351, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_v1.Duration{}
	} else {
		yyv1353 := &x.DeploymentControllerSyncPeriod
		yym1354 := z.DecBinary()
		_ = yym1354
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1353) {
		} else if !yym1354 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1353)
		} else {
			z.DecFallback(yyv1353, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_v1.Duration{}
	} else {
		yyv1355 := &x.PodEvictionTimeout
		yym1356 := z.DecBinary()
		_ = yym1356
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1355) {
		} else if !yym1356 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1355)
		} else {
			z.DecFallback(yyv1355, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_v1.Duration{}
	} else {
		yyv1359 := &x.NodeMonitorGracePeriod
		yym1360 := z.DecBinary()
		_ = yym1360
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1359) {
		} else if !yym1360 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1359)
		} else {
			z.DecFallback(yyv1359, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_v1.Duration{}
	} else {
		yyv1362 := &x.NodeStartupGracePeriod
		yym1363 := z.DecBinary()
		_ = yym1363
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1362) {
		} else if !yym1363 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1362)
		} else {
			z.DecFallback(yyv1362, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_v1.Duration{}
	} else {
		yyv1364 := &x.NodeMonitorPeriod
		yym1365 := z.DecBinary()
		_ = yym1365
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1364) {
		} else if !yym1365 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1364)
		} else {
			z.DecFallback(yyv1364, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningCertFile = ""
	} else {
		x.ClusterSigningCertFile = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningKeyFile = ""
	} else {
		x.ClusterSigningKeyFile = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ApproveAllKubeletCSRsForGroup = ""
	} else {
		x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceCIDR = ""
	} else {
		x.ServiceCIDR = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeCIDRMaskSize = 0
	} else {
		x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCloudRoutes = false
	} else {
		x.ConfigureCloudRoutes = bool(r.DecodeBool())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv1381 := &x.LeaderElection
		yyv1381.CodecDecodeSelf(d)
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv1382 := &x.VolumeConfiguration
		yyv1382.CodecDecodeSelf(d)
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ControllerStartInterval = pkg1_v1.Duration{}
	} else {
		yyv1383 := &x.ControllerStartInterval
		yym1384 := z.DecBinary()
		_ = yym1384
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1383) {
		} else if !yym1384 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1383)
		} else {
			z.DecFallback(yyv1383, false)
		}
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableGarbageCollector = false
	} else {
		x.EnableGarbageCollector = bool(r.DecodeBool())
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentGCSyncs = 0
	} else {
		x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeEvictionRate = 0
	} else {
		x.NodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecondaryNodeEvictionRate = 0
	} else {
		x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LargeClusterSizeThreshold = 0
	} else {
		x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
	}
	yyj1315++
	if yyhl1315 {
		yyb1315 = yyj1315 > l
	} else {
		yyb1315 = r.CheckBreak()
	}
	if yyb1315 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnhealthyZoneThreshold = 0
	} else {
		x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
	}
	for {
		yyj1315++
		if yyhl1315 {
			yyb1315 = yyj1315 > l
		} else {
			yyb1315 = r.CheckBreak()
		}
		if yyb1315 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1315-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1391 := z.EncBinary()
		_ = yym1391
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1392 := !z.EncBinary()
			yy2arr1392 := z.EncBasicHandle().StructToArray
			var yyq1392 [4]bool
			_, _, _ = yysep1392, yyq1392, yy2arr1392
			const yyr1392 bool = false
			var yynn1392 int
			if yyr1392 || yy2arr1392 {
				r.EncodeArrayStart(4)
			} else {
				yynn1392 = 4
				for _, b := range yyq1392 {
					if b {
						yynn1392++
					}
				}
				r.EncodeMapStart(yynn1392)
				yynn1392 = 0
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1394 := z.EncBinary()
				_ = yym1394
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1395 := z.EncBinary()
				_ = yym1395
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1397 := z.EncBinary()
				_ = yym1397
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDynamicProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1398 := z.EncBinary()
				_ = yym1398
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1400 := &x.PersistentVolumeRecyclerConfiguration
				yy1400.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1401 := &x.PersistentVolumeRecyclerConfiguration
				yy1401.CodecEncodeSelf(e)
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1403 := z.EncBinary()
				_ = yym1403
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("flexVolumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1404 := z.EncBinary()
				_ = yym1404
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1405 := z.DecBinary()
	_ = yym1405
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1406 := r.ContainerType()
		if yyct1406 == codecSelferValueTypeMap1234 {
			yyl1406 := r.ReadMapStart()
			if yyl1406 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1406, d)
			}
		} else if yyct1406 == codecSelferValueTypeArray1234 {
			yyl1406 := r.ReadArrayStart()
			if yyl1406 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1406, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1407Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1407Slc
	var yyhl1407 bool = l >= 0
	for yyj1407 := 0; ; yyj1407++ {
		if yyhl1407 {
			if yyj1407 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1407Slc = r.DecodeBytes(yys1407Slc, true, true)
		yys1407 := string(yys1407Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1407 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "enableDynamicProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableDynamicProvisioning = false
			} else {
				x.EnableDynamicProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv1410 := &x.PersistentVolumeRecyclerConfiguration
				yyv1410.CodecDecodeSelf(d)
			}
		case "flexVolumePluginDir":
			if r.TryDecodeAsNil() {
				x.FlexVolumePluginDir = ""
			} else {
				x.FlexVolumePluginDir = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1407)
		} // end switch yys1407
	} // end for yyj1407
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1412 int
	var yyb1412 bool
	var yyhl1412 bool = l >= 0
	yyj1412++
	if yyhl1412 {
		yyb1412 = yyj1412 > l
	} else {
		yyb1412 = r.CheckBreak()
	}
	if yyb1412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj1412++
	if yyhl1412 {
		yyb1412 = yyj1412 > l
	} else {
		yyb1412 = r.CheckBreak()
	}
	if yyb1412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDynamicProvisioning = false
	} else {
		x.EnableDynamicProvisioning = bool(r.DecodeBool())
	}
	yyj1412++
	if yyhl1412 {
		yyb1412 = yyj1412 > l
	} else {
		yyb1412 = r.CheckBreak()
	}
	if yyb1412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv1415 := &x.PersistentVolumeRecyclerConfiguration
		yyv1415.CodecDecodeSelf(d)
	}
	yyj1412++
	if yyhl1412 {
		yyb1412 = yyj1412 > l
	} else {
		yyb1412 = r.CheckBreak()
	}
	if yyb1412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FlexVolumePluginDir = ""
	} else {
		x.FlexVolumePluginDir = string(r.DecodeString())
	}
	for {
		yyj1412++
		if yyhl1412 {
			yyb1412 = yyj1412 > l
		} else {
			yyb1412 = r.CheckBreak()
		}
		if yyb1412 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1412-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1417 := z.EncBinary()
		_ = yym1417
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1418 := !z.EncBinary()
			yy2arr1418 := z.EncBasicHandle().StructToArray
			var yyq1418 [7]bool
			_, _, _ = yysep1418, yyq1418, yy2arr1418
			const yyr1418 bool = false
			var yynn1418 int
			if yyr1418 || yy2arr1418 {
				r.EncodeArrayStart(7)
			} else {
				yynn1418 = 7
				for _, b := range yyq1418 {
					if b {
						yynn1418++
					}
				}
				r.EncodeMapStart(yynn1418)
				yynn1418 = 0
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1420 := z.EncBinary()
				_ = yym1420
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1421 := z.EncBinary()
				_ = yym1421
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1423 := z.EncBinary()
				_ = yym1423
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1424 := z.EncBinary()
				_ = yym1424
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1426 := z.EncBinary()
				_ = yym1426
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1427 := z.EncBinary()
				_ = yym1427
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1429 := z.EncBinary()
				_ = yym1429
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1430 := z.EncBinary()
				_ = yym1430
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1432 := z.EncBinary()
				_ = yym1432
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1433 := z.EncBinary()
				_ = yym1433
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1435 := z.EncBinary()
				_ = yym1435
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1436 := z.EncBinary()
				_ = yym1436
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1438 := z.EncBinary()
				_ = yym1438
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1439 := z.EncBinary()
				_ = yym1439
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr1418 || yy2arr1418 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1440 := z.DecBinary()
	_ = yym1440
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1441 := r.ContainerType()
		if yyct1441 == codecSelferValueTypeMap1234 {
			yyl1441 := r.ReadMapStart()
			if yyl1441 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1441, d)
			}
		} else if yyct1441 == codecSelferValueTypeArray1234 {
			yyl1441 := r.ReadArrayStart()
			if yyl1441 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1441, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1442Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1442Slc
	var yyhl1442 bool = l >= 0
	for yyj1442 := 0; ; yyj1442++ {
		if yyhl1442 {
			if yyj1442 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1442Slc = r.DecodeBytes(yys1442Slc, true, true)
		yys1442 := string(yys1442Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1442 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int32(r.DecodeInt(32))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1442)
		} // end switch yys1442
	} // end for yyj1442
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1450 int
	var yyb1450 bool
	var yyhl1450 bool = l >= 0
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int32(r.DecodeInt(32))
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
	}
	yyj1450++
	if yyhl1450 {
		yyb1450 = yyj1450 > l
	} else {
		yyb1450 = r.CheckBreak()
	}
	if yyb1450 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
	}
	for {
		yyj1450++
		if yyhl1450 {
			yyb1450 = yyj1450 > l
		} else {
			yyb1450 = r.CheckBreak()
		}
		if yyb1450 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1450-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceapi_Taint(v []pkg2_api.Taint, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1458 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1459 := &yyv1458
		yy1459.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceapi_Taint(v *[]pkg2_api.Taint, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1460 := *v
	yyh1460, yyl1460 := z.DecSliceHelperStart()
	var yyc1460 bool
	if yyl1460 == 0 {
		if yyv1460 == nil {
			yyv1460 = []pkg2_api.Taint{}
			yyc1460 = true
		} else if len(yyv1460) != 0 {
			yyv1460 = yyv1460[:0]
			yyc1460 = true
		}
	} else if yyl1460 > 0 {
		var yyrr1460, yyrl1460 int
		var yyrt1460 bool
		if yyl1460 > cap(yyv1460) {

			yyrg1460 := len(yyv1460) > 0
			yyv21460 := yyv1460
			yyrl1460, yyrt1460 = z.DecInferLen(yyl1460, z.DecBasicHandle().MaxInitLen, 48)
			if yyrt1460 {
				if yyrl1460 <= cap(yyv1460) {
					yyv1460 = yyv1460[:yyrl1460]
				} else {
					yyv1460 = make([]pkg2_api.Taint, yyrl1460)
				}
			} else {
				yyv1460 = make([]pkg2_api.Taint, yyrl1460)
			}
			yyc1460 = true
			yyrr1460 = len(yyv1460)
			if yyrg1460 {
				copy(yyv1460, yyv21460)
			}
		} else if yyl1460 != len(yyv1460) {
			yyv1460 = yyv1460[:yyl1460]
			yyc1460 = true
		}
		yyj1460 := 0
		for ; yyj1460 < yyrr1460; yyj1460++ {
			yyh1460.ElemContainerState(yyj1460)
			if r.TryDecodeAsNil() {
				yyv1460[yyj1460] = pkg2_api.Taint{}
			} else {
				yyv1461 := &yyv1460[yyj1460]
				yyv1461.CodecDecodeSelf(d)
			}

		}
		if yyrt1460 {
			for ; yyj1460 < yyl1460; yyj1460++ {
				yyv1460 = append(yyv1460, pkg2_api.Taint{})
				yyh1460.ElemContainerState(yyj1460)
				if r.TryDecodeAsNil() {
					yyv1460[yyj1460] = pkg2_api.Taint{}
				} else {
					yyv1462 := &yyv1460[yyj1460]
					yyv1462.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1460 := 0
		for ; !r.CheckBreak(); yyj1460++ {

			if yyj1460 >= len(yyv1460) {
				yyv1460 = append(yyv1460, pkg2_api.Taint{}) // var yyz1460 pkg2_api.Taint
				yyc1460 = true
			}
			yyh1460.ElemContainerState(yyj1460)
			if yyj1460 < len(yyv1460) {
				if r.TryDecodeAsNil() {
					yyv1460[yyj1460] = pkg2_api.Taint{}
				} else {
					yyv1463 := &yyv1460[yyj1460]
					yyv1463.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1460 < len(yyv1460) {
			yyv1460 = yyv1460[:yyj1460]
			yyc1460 = true
		} else if yyj1460 == 0 && yyv1460 == nil {
			yyv1460 = []pkg2_api.Taint{}
			yyc1460 = true
		}
	}
	yyh1460.End()
	if yyc1460 {
		*v = yyv1460
	}
}

func (x codecSelfer1234) encconfig_ConfigurationMap(v pkg3_config.ConfigurationMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1464, yyv1464 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym1465 := z.EncBinary()
		_ = yym1465
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk1464))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yym1466 := z.EncBinary()
		_ = yym1466
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1464))
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decconfig_ConfigurationMap(v *pkg3_config.ConfigurationMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1467 := *v
	yyl1467 := r.ReadMapStart()
	yybh1467 := z.DecBasicHandle()
	if yyv1467 == nil {
		yyrl1467, _ := z.DecInferLen(yyl1467, yybh1467.MaxInitLen, 32)
		yyv1467 = make(map[string]string, yyrl1467)
		*v = yyv1467
	}
	var yymk1467 string
	var yymv1467 string
	var yymg1467 bool
	if yybh1467.MapValueReset {
	}
	if yyl1467 > 0 {
		for yyj1467 := 0; yyj1467 < yyl1467; yyj1467++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1467 = ""
			} else {
				yymk1467 = string(r.DecodeString())
			}

			if yymg1467 {
				yymv1467 = yyv1467[yymk1467]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1467 = ""
			} else {
				yymv1467 = string(r.DecodeString())
			}

			if yyv1467 != nil {
				yyv1467[yymk1467] = yymv1467
			}
		}
	} else if yyl1467 < 0 {
		for yyj1467 := 0; !r.CheckBreak(); yyj1467++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1467 = ""
			} else {
				yymk1467 = string(r.DecodeString())
			}

			if yymg1467 {
				yymv1467 = yyv1467[yymk1467]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1467 = ""
			} else {
				yymv1467 = string(r.DecodeString())
			}

			if yyv1467 != nil {
				yyv1467[yymk1467] = yymv1467
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
