/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg4_resource "k8s.io/client-go/pkg/api/resource"
	pkg2_v1 "k8s.io/client-go/pkg/api/v1"
	pkg1_v1 "k8s.io/client-go/pkg/apis/meta/v1"
	pkg3_types "k8s.io/client-go/pkg/types"
	pkg5_intstr "k8s.io/client-go/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg4_resource.Quantity
		var v1 pkg2_v1.ObjectMeta
		var v2 pkg1_v1.TypeMeta
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.ObjectMeta
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.Spec
					yy13.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy14 := &x.Spec
					yy14.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.Status
					yy16.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym18 := z.DecBinary()
	_ = yym18
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct19 := r.ContainerType()
		if yyct19 == codecSelferValueTypeMap1234 {
			yyl19 := r.ReadMapStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl19, d)
			}
		} else if yyct19 == codecSelferValueTypeArray1234 {
			yyl19 := r.ReadArrayStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl19, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys20Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys20Slc
	var yyhl20 bool = l >= 0
	for yyj20 := 0; ; yyj20++ {
		if yyhl20 {
			if yyj20 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys20Slc = r.DecodeBytes(yys20Slc, true, true)
		yys20 := string(yys20Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys20 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv23 := &x.ObjectMeta
				yyv23.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv24 := &x.Spec
				yyv24.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv25 := &x.Status
				yyv25.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys20)
		} // end switch yys20
	} // end for yyj20
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv29 := &x.ObjectMeta
		yyv29.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv30 := &x.Spec
		yyv30.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv31 := &x.Status
		yyv31.CodecDecodeSelf(d)
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym32 := z.EncBinary()
		_ = yym32
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep33 := !z.EncBinary()
			yy2arr33 := z.EncBasicHandle().StructToArray
			var yyq33 [4]bool
			_, _, _ = yysep33, yyq33, yy2arr33
			const yyr33 bool = false
			yyq33[0] = x.Kind != ""
			yyq33[1] = x.APIVersion != ""
			yyq33[2] = true
			var yynn33 int
			if yyr33 || yy2arr33 {
				r.EncodeArrayStart(4)
			} else {
				yynn33 = 1
				for _, b := range yyq33 {
					if b {
						yynn33++
					}
				}
				r.EncodeMapStart(yynn33)
				yynn33 = 0
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[0] {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[1] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq33[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[2] {
					yy41 := &x.ListMeta
					yym42 := z.EncBinary()
					_ = yym42
					if false {
					} else if z.HasExtensions() && z.EncExt(yy41) {
					} else {
						z.EncFallback(yy41)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq33[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.ListMeta
					yym44 := z.EncBinary()
					_ = yym44
					if false {
					} else if z.HasExtensions() && z.EncExt(yy43) {
					} else {
						z.EncFallback(yy43)
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym46 := z.EncBinary()
					_ = yym46
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym48 := z.DecBinary()
	_ = yym48
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct49 := r.ContainerType()
		if yyct49 == codecSelferValueTypeMap1234 {
			yyl49 := r.ReadMapStart()
			if yyl49 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl49, d)
			}
		} else if yyct49 == codecSelferValueTypeArray1234 {
			yyl49 := r.ReadArrayStart()
			if yyl49 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl49, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys50Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys50Slc
	var yyhl50 bool = l >= 0
	for yyj50 := 0; ; yyj50++ {
		if yyhl50 {
			if yyj50 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys50Slc = r.DecodeBytes(yys50Slc, true, true)
		yys50 := string(yys50Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys50 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_v1.ListMeta{}
			} else {
				yyv53 := &x.ListMeta
				yym54 := z.DecBinary()
				_ = yym54
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv53) {
				} else {
					z.DecFallback(yyv53, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv55 := &x.Items
				yym56 := z.DecBinary()
				_ = yym56
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv55), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys50)
		} // end switch yys50
	} // end for yyj50
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj57 int
	var yyb57 bool
	var yyhl57 bool = l >= 0
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_v1.ListMeta{}
	} else {
		yyv60 := &x.ListMeta
		yym61 := z.DecBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv60) {
		} else {
			z.DecFallback(yyv60, false)
		}
	}
	yyj57++
	if yyhl57 {
		yyb57 = yyj57 > l
	} else {
		yyb57 = r.CheckBreak()
	}
	if yyb57 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv62 := &x.Items
		yym63 := z.DecBinary()
		_ = yym63
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv62), d)
		}
	}
	for {
		yyj57++
		if yyhl57 {
			yyb57 = yyj57 > l
		} else {
			yyb57 = r.CheckBreak()
		}
		if yyb57 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj57-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym64 := z.EncBinary()
		_ = yym64
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep65 := !z.EncBinary()
			yy2arr65 := z.EncBasicHandle().StructToArray
			var yyq65 [6]bool
			_, _, _ = yysep65, yyq65, yy2arr65
			const yyr65 bool = false
			yyq65[0] = x.Parallelism != nil
			yyq65[1] = x.Completions != nil
			yyq65[2] = x.ActiveDeadlineSeconds != nil
			yyq65[3] = x.Selector != nil
			yyq65[4] = x.ManualSelector != nil
			var yynn65 int
			if yyr65 || yy2arr65 {
				r.EncodeArrayStart(6)
			} else {
				yynn65 = 1
				for _, b := range yyq65 {
					if b {
						yynn65++
					}
				}
				r.EncodeMapStart(yynn65)
				yynn65 = 0
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy67 := *x.Parallelism
						yym68 := z.EncBinary()
						_ = yym68
						if false {
						} else {
							r.EncodeInt(int64(yy67))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy69 := *x.Parallelism
						yym70 := z.EncBinary()
						_ = yym70
						if false {
						} else {
							r.EncodeInt(int64(yy69))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy72 := *x.Completions
						yym73 := z.EncBinary()
						_ = yym73
						if false {
						} else {
							r.EncodeInt(int64(yy72))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy74 := *x.Completions
						yym75 := z.EncBinary()
						_ = yym75
						if false {
						} else {
							r.EncodeInt(int64(yy74))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy77 := *x.ActiveDeadlineSeconds
						yym78 := z.EncBinary()
						_ = yym78
						if false {
						} else {
							r.EncodeInt(int64(yy77))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy79 := *x.ActiveDeadlineSeconds
						yym80 := z.EncBinary()
						_ = yym80
						if false {
						} else {
							r.EncodeInt(int64(yy79))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym82 := z.EncBinary()
						_ = yym82
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym83 := z.EncBinary()
						_ = yym83
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq65[4] {
					if x.ManualSelector == nil {
						r.EncodeNil()
					} else {
						yy85 := *x.ManualSelector
						yym86 := z.EncBinary()
						_ = yym86
						if false {
						} else {
							r.EncodeBool(bool(yy85))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq65[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("manualSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ManualSelector == nil {
						r.EncodeNil()
					} else {
						yy87 := *x.ManualSelector
						yym88 := z.EncBinary()
						_ = yym88
						if false {
						} else {
							r.EncodeBool(bool(yy87))
						}
					}
				}
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy90 := &x.Template
				yy90.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy91 := &x.Template
				yy91.CodecEncodeSelf(e)
			}
			if yyr65 || yy2arr65 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym92 := z.DecBinary()
	_ = yym92
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct93 := r.ContainerType()
		if yyct93 == codecSelferValueTypeMap1234 {
			yyl93 := r.ReadMapStart()
			if yyl93 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl93, d)
			}
		} else if yyct93 == codecSelferValueTypeArray1234 {
			yyl93 := r.ReadArrayStart()
			if yyl93 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl93, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys94Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys94Slc
	var yyhl94 bool = l >= 0
	for yyj94 := 0; ; yyj94++ {
		if yyhl94 {
			if yyj94 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys94Slc = r.DecodeBytes(yys94Slc, true, true)
		yys94 := string(yys94Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys94 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int32)
				}
				yym96 := z.DecBinary()
				_ = yym96
				if false {
				} else {
					*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int32)
				}
				yym98 := z.DecBinary()
				_ = yym98
				if false {
				} else {
					*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym100 := z.DecBinary()
				_ = yym100
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_v1.LabelSelector)
				}
				yym102 := z.DecBinary()
				_ = yym102
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "manualSelector":
			if r.TryDecodeAsNil() {
				if x.ManualSelector != nil {
					x.ManualSelector = nil
				}
			} else {
				if x.ManualSelector == nil {
					x.ManualSelector = new(bool)
				}
				yym104 := z.DecBinary()
				_ = yym104
				if false {
				} else {
					*((*bool)(x.ManualSelector)) = r.DecodeBool()
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv105 := &x.Template
				yyv105.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys94)
		} // end switch yys94
	} // end for yyj94
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj106 int
	var yyb106 bool
	var yyhl106 bool = l >= 0
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int32)
		}
		yym108 := z.DecBinary()
		_ = yym108
		if false {
		} else {
			*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
		}
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int32)
		}
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else {
			*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
		}
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym112 := z.DecBinary()
		_ = yym112
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_v1.LabelSelector)
		}
		yym114 := z.DecBinary()
		_ = yym114
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ManualSelector != nil {
			x.ManualSelector = nil
		}
	} else {
		if x.ManualSelector == nil {
			x.ManualSelector = new(bool)
		}
		yym116 := z.DecBinary()
		_ = yym116
		if false {
		} else {
			*((*bool)(x.ManualSelector)) = r.DecodeBool()
		}
	}
	yyj106++
	if yyhl106 {
		yyb106 = yyj106 > l
	} else {
		yyb106 = r.CheckBreak()
	}
	if yyb106 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv117 := &x.Template
		yyv117.CodecDecodeSelf(d)
	}
	for {
		yyj106++
		if yyhl106 {
			yyb106 = yyj106 > l
		} else {
			yyb106 = r.CheckBreak()
		}
		if yyb106 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj106-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym118 := z.EncBinary()
		_ = yym118
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep119 := !z.EncBinary()
			yy2arr119 := z.EncBasicHandle().StructToArray
			var yyq119 [6]bool
			_, _, _ = yysep119, yyq119, yy2arr119
			const yyr119 bool = false
			yyq119[0] = len(x.Conditions) != 0
			yyq119[1] = x.StartTime != nil
			yyq119[2] = x.CompletionTime != nil
			yyq119[3] = x.Active != 0
			yyq119[4] = x.Succeeded != 0
			yyq119[5] = x.Failed != 0
			var yynn119 int
			if yyr119 || yy2arr119 {
				r.EncodeArrayStart(6)
			} else {
				yynn119 = 0
				for _, b := range yyq119 {
					if b {
						yynn119++
					}
				}
				r.EncodeMapStart(yynn119)
				yynn119 = 0
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq119[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym121 := z.EncBinary()
						_ = yym121
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq119[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym122 := z.EncBinary()
						_ = yym122
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq119[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym124 := z.EncBinary()
						_ = yym124
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym124 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym124 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq119[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym125 := z.EncBinary()
						_ = yym125
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym125 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym125 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq119[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym127 := z.EncBinary()
						_ = yym127
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym127 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym127 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq119[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym128 := z.EncBinary()
						_ = yym128
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym128 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym128 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq119[3] {
					yym130 := z.EncBinary()
					_ = yym130
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq119[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym131 := z.EncBinary()
					_ = yym131
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq119[4] {
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq119[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym134 := z.EncBinary()
					_ = yym134
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq119[5] {
					yym136 := z.EncBinary()
					_ = yym136
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq119[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym137 := z.EncBinary()
					_ = yym137
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr119 || yy2arr119 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym138 := z.DecBinary()
	_ = yym138
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct139 := r.ContainerType()
		if yyct139 == codecSelferValueTypeMap1234 {
			yyl139 := r.ReadMapStart()
			if yyl139 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl139, d)
			}
		} else if yyct139 == codecSelferValueTypeArray1234 {
			yyl139 := r.ReadArrayStart()
			if yyl139 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl139, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys140Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys140Slc
	var yyhl140 bool = l >= 0
	for yyj140 := 0; ; yyj140++ {
		if yyhl140 {
			if yyj140 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys140Slc = r.DecodeBytes(yys140Slc, true, true)
		yys140 := string(yys140Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys140 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv141 := &x.Conditions
				yym142 := z.DecBinary()
				_ = yym142
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv141), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_v1.Time)
				}
				yym144 := z.DecBinary()
				_ = yym144
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym144 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym144 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_v1.Time)
				}
				yym146 := z.DecBinary()
				_ = yym146
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym146 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym146 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int32(r.DecodeInt(32))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int32(r.DecodeInt(32))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys140)
		} // end switch yys140
	} // end for yyj140
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj150 int
	var yyb150 bool
	var yyhl150 bool = l >= 0
	yyj150++
	if yyhl150 {
		yyb150 = yyj150 > l
	} else {
		yyb150 = r.CheckBreak()
	}
	if yyb150 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv151 := &x.Conditions
		yym152 := z.DecBinary()
		_ = yym152
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv151), d)
		}
	}
	yyj150++
	if yyhl150 {
		yyb150 = yyj150 > l
	} else {
		yyb150 = r.CheckBreak()
	}
	if yyb150 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_v1.Time)
		}
		yym154 := z.DecBinary()
		_ = yym154
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym154 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym154 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj150++
	if yyhl150 {
		yyb150 = yyj150 > l
	} else {
		yyb150 = r.CheckBreak()
	}
	if yyb150 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_v1.Time)
		}
		yym156 := z.DecBinary()
		_ = yym156
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym156 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym156 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj150++
	if yyhl150 {
		yyb150 = yyj150 > l
	} else {
		yyb150 = r.CheckBreak()
	}
	if yyb150 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int32(r.DecodeInt(32))
	}
	yyj150++
	if yyhl150 {
		yyb150 = yyj150 > l
	} else {
		yyb150 = r.CheckBreak()
	}
	if yyb150 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int32(r.DecodeInt(32))
	}
	yyj150++
	if yyhl150 {
		yyb150 = yyj150 > l
	} else {
		yyb150 = r.CheckBreak()
	}
	if yyb150 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int32(r.DecodeInt(32))
	}
	for {
		yyj150++
		if yyhl150 {
			yyb150 = yyj150 > l
		} else {
			yyb150 = r.CheckBreak()
		}
		if yyb150 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj150-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym160 := z.EncBinary()
	_ = yym160
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym161 := z.DecBinary()
	_ = yym161
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym162 := z.EncBinary()
		_ = yym162
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep163 := !z.EncBinary()
			yy2arr163 := z.EncBasicHandle().StructToArray
			var yyq163 [6]bool
			_, _, _ = yysep163, yyq163, yy2arr163
			const yyr163 bool = false
			yyq163[2] = true
			yyq163[3] = true
			yyq163[4] = x.Reason != ""
			yyq163[5] = x.Message != ""
			var yynn163 int
			if yyr163 || yy2arr163 {
				r.EncodeArrayStart(6)
			} else {
				yynn163 = 2
				for _, b := range yyq163 {
					if b {
						yynn163++
					}
				}
				r.EncodeMapStart(yynn163)
				yynn163 = 0
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym166 := z.EncBinary()
				_ = yym166
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym167 := z.EncBinary()
				_ = yym167
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq163[2] {
					yy169 := &x.LastProbeTime
					yym170 := z.EncBinary()
					_ = yym170
					if false {
					} else if z.HasExtensions() && z.EncExt(yy169) {
					} else if yym170 {
						z.EncBinaryMarshal(yy169)
					} else if !yym170 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy169)
					} else {
						z.EncFallback(yy169)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq163[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy171 := &x.LastProbeTime
					yym172 := z.EncBinary()
					_ = yym172
					if false {
					} else if z.HasExtensions() && z.EncExt(yy171) {
					} else if yym172 {
						z.EncBinaryMarshal(yy171)
					} else if !yym172 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy171)
					} else {
						z.EncFallback(yy171)
					}
				}
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq163[3] {
					yy174 := &x.LastTransitionTime
					yym175 := z.EncBinary()
					_ = yym175
					if false {
					} else if z.HasExtensions() && z.EncExt(yy174) {
					} else if yym175 {
						z.EncBinaryMarshal(yy174)
					} else if !yym175 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy174)
					} else {
						z.EncFallback(yy174)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq163[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy176 := &x.LastTransitionTime
					yym177 := z.EncBinary()
					_ = yym177
					if false {
					} else if z.HasExtensions() && z.EncExt(yy176) {
					} else if yym177 {
						z.EncBinaryMarshal(yy176)
					} else if !yym177 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy176)
					} else {
						z.EncFallback(yy176)
					}
				}
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq163[4] {
					yym179 := z.EncBinary()
					_ = yym179
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq163[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym180 := z.EncBinary()
					_ = yym180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq163[5] {
					yym182 := z.EncBinary()
					_ = yym182
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq163[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym183 := z.EncBinary()
					_ = yym183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr163 || yy2arr163 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym184 := z.DecBinary()
	_ = yym184
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct185 := r.ContainerType()
		if yyct185 == codecSelferValueTypeMap1234 {
			yyl185 := r.ReadMapStart()
			if yyl185 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl185, d)
			}
		} else if yyct185 == codecSelferValueTypeArray1234 {
			yyl185 := r.ReadArrayStart()
			if yyl185 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl185, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys186Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys186Slc
	var yyhl186 bool = l >= 0
	for yyj186 := 0; ; yyj186++ {
		if yyhl186 {
			if yyj186 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys186Slc = r.DecodeBytes(yys186Slc, true, true)
		yys186 := string(yys186Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys186 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_v1.Time{}
			} else {
				yyv189 := &x.LastProbeTime
				yym190 := z.DecBinary()
				_ = yym190
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv189) {
				} else if yym190 {
					z.DecBinaryUnmarshal(yyv189)
				} else if !yym190 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv189)
				} else {
					z.DecFallback(yyv189, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_v1.Time{}
			} else {
				yyv191 := &x.LastTransitionTime
				yym192 := z.DecBinary()
				_ = yym192
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv191) {
				} else if yym192 {
					z.DecBinaryUnmarshal(yyv191)
				} else if !yym192 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv191)
				} else {
					z.DecFallback(yyv191, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys186)
		} // end switch yys186
	} // end for yyj186
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj195 int
	var yyb195 bool
	var yyhl195 bool = l >= 0
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_v1.Time{}
	} else {
		yyv198 := &x.LastProbeTime
		yym199 := z.DecBinary()
		_ = yym199
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv198) {
		} else if yym199 {
			z.DecBinaryUnmarshal(yyv198)
		} else if !yym199 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv198)
		} else {
			z.DecFallback(yyv198, false)
		}
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_v1.Time{}
	} else {
		yyv200 := &x.LastTransitionTime
		yym201 := z.DecBinary()
		_ = yym201
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv200) {
		} else if yym201 {
			z.DecBinaryUnmarshal(yyv200)
		} else if !yym201 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv200)
		} else {
			z.DecFallback(yyv200, false)
		}
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj195++
		if yyhl195 {
			yyb195 = yyj195 > l
		} else {
			yyb195 = r.CheckBreak()
		}
		if yyb195 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj195-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv204 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy205 := &yyv204
		yy205.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv206 := *v
	yyh206, yyl206 := z.DecSliceHelperStart()
	var yyc206 bool
	if yyl206 == 0 {
		if yyv206 == nil {
			yyv206 = []Job{}
			yyc206 = true
		} else if len(yyv206) != 0 {
			yyv206 = yyv206[:0]
			yyc206 = true
		}
	} else if yyl206 > 0 {
		var yyrr206, yyrl206 int
		var yyrt206 bool
		if yyl206 > cap(yyv206) {

			yyrg206 := len(yyv206) > 0
			yyv2206 := yyv206
			yyrl206, yyrt206 = z.DecInferLen(yyl206, z.DecBasicHandle().MaxInitLen, 824)
			if yyrt206 {
				if yyrl206 <= cap(yyv206) {
					yyv206 = yyv206[:yyrl206]
				} else {
					yyv206 = make([]Job, yyrl206)
				}
			} else {
				yyv206 = make([]Job, yyrl206)
			}
			yyc206 = true
			yyrr206 = len(yyv206)
			if yyrg206 {
				copy(yyv206, yyv2206)
			}
		} else if yyl206 != len(yyv206) {
			yyv206 = yyv206[:yyl206]
			yyc206 = true
		}
		yyj206 := 0
		for ; yyj206 < yyrr206; yyj206++ {
			yyh206.ElemContainerState(yyj206)
			if r.TryDecodeAsNil() {
				yyv206[yyj206] = Job{}
			} else {
				yyv207 := &yyv206[yyj206]
				yyv207.CodecDecodeSelf(d)
			}

		}
		if yyrt206 {
			for ; yyj206 < yyl206; yyj206++ {
				yyv206 = append(yyv206, Job{})
				yyh206.ElemContainerState(yyj206)
				if r.TryDecodeAsNil() {
					yyv206[yyj206] = Job{}
				} else {
					yyv208 := &yyv206[yyj206]
					yyv208.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj206 := 0
		for ; !r.CheckBreak(); yyj206++ {

			if yyj206 >= len(yyv206) {
				yyv206 = append(yyv206, Job{}) // var yyz206 Job
				yyc206 = true
			}
			yyh206.ElemContainerState(yyj206)
			if yyj206 < len(yyv206) {
				if r.TryDecodeAsNil() {
					yyv206[yyj206] = Job{}
				} else {
					yyv209 := &yyv206[yyj206]
					yyv209.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj206 < len(yyv206) {
			yyv206 = yyv206[:yyj206]
			yyc206 = true
		} else if yyj206 == 0 && yyv206 == nil {
			yyv206 = []Job{}
			yyc206 = true
		}
	}
	yyh206.End()
	if yyc206 {
		*v = yyv206
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv210 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy211 := &yyv210
		yy211.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv212 := *v
	yyh212, yyl212 := z.DecSliceHelperStart()
	var yyc212 bool
	if yyl212 == 0 {
		if yyv212 == nil {
			yyv212 = []JobCondition{}
			yyc212 = true
		} else if len(yyv212) != 0 {
			yyv212 = yyv212[:0]
			yyc212 = true
		}
	} else if yyl212 > 0 {
		var yyrr212, yyrl212 int
		var yyrt212 bool
		if yyl212 > cap(yyv212) {

			yyrg212 := len(yyv212) > 0
			yyv2212 := yyv212
			yyrl212, yyrt212 = z.DecInferLen(yyl212, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt212 {
				if yyrl212 <= cap(yyv212) {
					yyv212 = yyv212[:yyrl212]
				} else {
					yyv212 = make([]JobCondition, yyrl212)
				}
			} else {
				yyv212 = make([]JobCondition, yyrl212)
			}
			yyc212 = true
			yyrr212 = len(yyv212)
			if yyrg212 {
				copy(yyv212, yyv2212)
			}
		} else if yyl212 != len(yyv212) {
			yyv212 = yyv212[:yyl212]
			yyc212 = true
		}
		yyj212 := 0
		for ; yyj212 < yyrr212; yyj212++ {
			yyh212.ElemContainerState(yyj212)
			if r.TryDecodeAsNil() {
				yyv212[yyj212] = JobCondition{}
			} else {
				yyv213 := &yyv212[yyj212]
				yyv213.CodecDecodeSelf(d)
			}

		}
		if yyrt212 {
			for ; yyj212 < yyl212; yyj212++ {
				yyv212 = append(yyv212, JobCondition{})
				yyh212.ElemContainerState(yyj212)
				if r.TryDecodeAsNil() {
					yyv212[yyj212] = JobCondition{}
				} else {
					yyv214 := &yyv212[yyj212]
					yyv214.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj212 := 0
		for ; !r.CheckBreak(); yyj212++ {

			if yyj212 >= len(yyv212) {
				yyv212 = append(yyv212, JobCondition{}) // var yyz212 JobCondition
				yyc212 = true
			}
			yyh212.ElemContainerState(yyj212)
			if yyj212 < len(yyv212) {
				if r.TryDecodeAsNil() {
					yyv212[yyj212] = JobCondition{}
				} else {
					yyv215 := &yyv212[yyj212]
					yyv215.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj212 < len(yyv212) {
			yyv212 = yyv212[:yyj212]
			yyc212 = true
		} else if yyj212 == 0 && yyv212 == nil {
			yyv212 = []JobCondition{}
			yyc212 = true
		}
	}
	yyh212.End()
	if yyc212 {
		*v = yyv212
	}
}
