/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package authorization

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/client-go/pkg/api"
	pkg1_v1 "k8s.io/client-go/pkg/apis/meta/v1"
	pkg3_types "k8s.io/client-go/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg1_v1.TypeMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *SubjectAccessReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [19]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.Name != ""
			yyq2[3] = x.GenerateName != ""
			yyq2[4] = x.Namespace != ""
			yyq2[5] = x.SelfLink != ""
			yyq2[6] = x.UID != ""
			yyq2[7] = x.ResourceVersion != ""
			yyq2[8] = x.Generation != 0
			yyq2[9] = true
			yyq2[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq2[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq2[12] = len(x.Labels) != 0
			yyq2[13] = len(x.Annotations) != 0
			yyq2[14] = len(x.OwnerReferences) != 0
			yyq2[15] = len(x.Finalizers) != 0
			yyq2[16] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(19)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yy31 := &x.CreationTimestamp
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else if z.HasExtensions() && z.EncExt(yy31) {
					} else if yym32 {
						z.EncBinaryMarshal(yy31)
					} else if !yym32 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy31)
					} else {
						z.EncFallback(yy31)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy33 := &x.CreationTimestamp
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else if z.HasExtensions() && z.EncExt(yy33) {
					} else if yym34 {
						z.EncBinaryMarshal(yy33)
					} else if !yym34 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy33)
					} else {
						z.EncFallback(yy33)
					}
				}
			}
			var yyn35 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn35 = true
				goto LABEL35
			}
		LABEL35:
			if yyr2 || yy2arr2 {
				if yyn35 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym36 := z.EncBinary()
							_ = yym36
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym36 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym36 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn35 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym37 := z.EncBinary()
							_ = yym37
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym37 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym37 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn38 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn38 = true
				goto LABEL38
			}
		LABEL38:
			if yyr2 || yy2arr2 {
				if yyn38 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy39 := *x.DeletionGracePeriodSeconds
							yym40 := z.EncBinary()
							_ = yym40
							if false {
							} else {
								r.EncodeInt(int64(yy39))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn38 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy41 := *x.DeletionGracePeriodSeconds
							yym42 := z.EncBinary()
							_ = yym42
							if false {
							} else {
								r.EncodeInt(int64(yy41))
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym50 := z.EncBinary()
						_ = yym50
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym51 := z.EncBinary()
						_ = yym51
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym53 := z.EncBinary()
						_ = yym53
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym54 := z.EncBinary()
						_ = yym54
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					yym56 := z.EncBinary()
					_ = yym56
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym57 := z.EncBinary()
					_ = yym57
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy59 := &x.Spec
				yy59.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy60 := &x.Spec
				yy60.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy62 := &x.Status
				yy62.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy63 := &x.Status
				yy63.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubjectAccessReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym64 := z.DecBinary()
	_ = yym64
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct65 := r.ContainerType()
		if yyct65 == codecSelferValueTypeMap1234 {
			yyl65 := r.ReadMapStart()
			if yyl65 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl65, d)
			}
		} else if yyct65 == codecSelferValueTypeArray1234 {
			yyl65 := r.ReadArrayStart()
			if yyl65 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl65, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubjectAccessReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys66Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys66Slc
	var yyhl66 bool = l >= 0
	for yyj66 := 0; ; yyj66++ {
		if yyhl66 {
			if yyj66 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys66Slc = r.DecodeBytes(yys66Slc, true, true)
		yys66 := string(yys66Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys66 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg3_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_v1.Time{}
			} else {
				yyv76 := &x.CreationTimestamp
				yym77 := z.DecBinary()
				_ = yym77
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv76) {
				} else if yym77 {
					z.DecBinaryUnmarshal(yyv76)
				} else if !yym77 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv76)
				} else {
					z.DecFallback(yyv76, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_v1.Time)
				}
				yym79 := z.DecBinary()
				_ = yym79
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym79 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym79 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym81 := z.DecBinary()
				_ = yym81
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv82 := &x.Labels
				yym83 := z.DecBinary()
				_ = yym83
				if false {
				} else {
					z.F.DecMapStringStringX(yyv82, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv84 := &x.Annotations
				yym85 := z.DecBinary()
				_ = yym85
				if false {
				} else {
					z.F.DecMapStringStringX(yyv84, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv86 := &x.OwnerReferences
				yym87 := z.DecBinary()
				_ = yym87
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv86), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv88 := &x.Finalizers
				yym89 := z.DecBinary()
				_ = yym89
				if false {
				} else {
					z.F.DecSliceStringX(yyv88, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "Spec":
			if r.TryDecodeAsNil() {
				x.Spec = SubjectAccessReviewSpec{}
			} else {
				yyv91 := &x.Spec
				yyv91.CodecDecodeSelf(d)
			}
		case "Status":
			if r.TryDecodeAsNil() {
				x.Status = SubjectAccessReviewStatus{}
			} else {
				yyv92 := &x.Status
				yyv92.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys66)
		} // end switch yys66
	} // end for yyj66
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubjectAccessReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj93 int
	var yyb93 bool
	var yyhl93 bool = l >= 0
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg3_types.UID(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_v1.Time{}
	} else {
		yyv103 := &x.CreationTimestamp
		yym104 := z.DecBinary()
		_ = yym104
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv103) {
		} else if yym104 {
			z.DecBinaryUnmarshal(yyv103)
		} else if !yym104 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv103)
		} else {
			z.DecFallback(yyv103, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_v1.Time)
		}
		yym106 := z.DecBinary()
		_ = yym106
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym106 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym106 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym108 := z.DecBinary()
		_ = yym108
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv109 := &x.Labels
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else {
			z.F.DecMapStringStringX(yyv109, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv111 := &x.Annotations
		yym112 := z.DecBinary()
		_ = yym112
		if false {
		} else {
			z.F.DecMapStringStringX(yyv111, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv113 := &x.OwnerReferences
		yym114 := z.DecBinary()
		_ = yym114
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv113), d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv115 := &x.Finalizers
		yym116 := z.DecBinary()
		_ = yym116
		if false {
		} else {
			z.F.DecSliceStringX(yyv115, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = SubjectAccessReviewSpec{}
	} else {
		yyv118 := &x.Spec
		yyv118.CodecDecodeSelf(d)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = SubjectAccessReviewStatus{}
	} else {
		yyv119 := &x.Status
		yyv119.CodecDecodeSelf(d)
	}
	for {
		yyj93++
		if yyhl93 {
			yyb93 = yyj93 > l
		} else {
			yyb93 = r.CheckBreak()
		}
		if yyb93 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj93-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SelfSubjectAccessReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym120 := z.EncBinary()
		_ = yym120
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep121 := !z.EncBinary()
			yy2arr121 := z.EncBasicHandle().StructToArray
			var yyq121 [19]bool
			_, _, _ = yysep121, yyq121, yy2arr121
			const yyr121 bool = false
			yyq121[0] = x.Kind != ""
			yyq121[1] = x.APIVersion != ""
			yyq121[2] = x.Name != ""
			yyq121[3] = x.GenerateName != ""
			yyq121[4] = x.Namespace != ""
			yyq121[5] = x.SelfLink != ""
			yyq121[6] = x.UID != ""
			yyq121[7] = x.ResourceVersion != ""
			yyq121[8] = x.Generation != 0
			yyq121[9] = true
			yyq121[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq121[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq121[12] = len(x.Labels) != 0
			yyq121[13] = len(x.Annotations) != 0
			yyq121[14] = len(x.OwnerReferences) != 0
			yyq121[15] = len(x.Finalizers) != 0
			yyq121[16] = x.ClusterName != ""
			var yynn121 int
			if yyr121 || yy2arr121 {
				r.EncodeArrayStart(19)
			} else {
				yynn121 = 2
				for _, b := range yyq121 {
					if b {
						yynn121++
					}
				}
				r.EncodeMapStart(yynn121)
				yynn121 = 0
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[0] {
					yym123 := z.EncBinary()
					_ = yym123
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym124 := z.EncBinary()
					_ = yym124
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[1] {
					yym126 := z.EncBinary()
					_ = yym126
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym127 := z.EncBinary()
					_ = yym127
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[2] {
					yym129 := z.EncBinary()
					_ = yym129
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym130 := z.EncBinary()
					_ = yym130
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[3] {
					yym132 := z.EncBinary()
					_ = yym132
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[4] {
					yym135 := z.EncBinary()
					_ = yym135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym136 := z.EncBinary()
					_ = yym136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[5] {
					yym138 := z.EncBinary()
					_ = yym138
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym139 := z.EncBinary()
					_ = yym139
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[6] {
					yym141 := z.EncBinary()
					_ = yym141
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym142 := z.EncBinary()
					_ = yym142
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[7] {
					yym144 := z.EncBinary()
					_ = yym144
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym145 := z.EncBinary()
					_ = yym145
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[8] {
					yym147 := z.EncBinary()
					_ = yym147
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq121[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym148 := z.EncBinary()
					_ = yym148
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[9] {
					yy150 := &x.CreationTimestamp
					yym151 := z.EncBinary()
					_ = yym151
					if false {
					} else if z.HasExtensions() && z.EncExt(yy150) {
					} else if yym151 {
						z.EncBinaryMarshal(yy150)
					} else if !yym151 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy150)
					} else {
						z.EncFallback(yy150)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq121[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy152 := &x.CreationTimestamp
					yym153 := z.EncBinary()
					_ = yym153
					if false {
					} else if z.HasExtensions() && z.EncExt(yy152) {
					} else if yym153 {
						z.EncBinaryMarshal(yy152)
					} else if !yym153 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy152)
					} else {
						z.EncFallback(yy152)
					}
				}
			}
			var yyn154 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn154 = true
				goto LABEL154
			}
		LABEL154:
			if yyr121 || yy2arr121 {
				if yyn154 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq121[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym155 := z.EncBinary()
							_ = yym155
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym155 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym155 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq121[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn154 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym156 := z.EncBinary()
							_ = yym156
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym156 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym156 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn157 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn157 = true
				goto LABEL157
			}
		LABEL157:
			if yyr121 || yy2arr121 {
				if yyn157 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq121[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy158 := *x.DeletionGracePeriodSeconds
							yym159 := z.EncBinary()
							_ = yym159
							if false {
							} else {
								r.EncodeInt(int64(yy158))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq121[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn157 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy160 := *x.DeletionGracePeriodSeconds
							yym161 := z.EncBinary()
							_ = yym161
							if false {
							} else {
								r.EncodeInt(int64(yy160))
							}
						}
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym163 := z.EncBinary()
						_ = yym163
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq121[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym164 := z.EncBinary()
						_ = yym164
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym166 := z.EncBinary()
						_ = yym166
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq121[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym167 := z.EncBinary()
						_ = yym167
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym169 := z.EncBinary()
						_ = yym169
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq121[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym170 := z.EncBinary()
						_ = yym170
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[15] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym172 := z.EncBinary()
						_ = yym172
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq121[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym173 := z.EncBinary()
						_ = yym173
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq121[16] {
					yym175 := z.EncBinary()
					_ = yym175
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq121[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym176 := z.EncBinary()
					_ = yym176
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy178 := &x.Spec
				yy178.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy179 := &x.Spec
				yy179.CodecEncodeSelf(e)
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy181 := &x.Status
				yy181.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy182 := &x.Status
				yy182.CodecEncodeSelf(e)
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SelfSubjectAccessReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym183 := z.DecBinary()
	_ = yym183
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct184 := r.ContainerType()
		if yyct184 == codecSelferValueTypeMap1234 {
			yyl184 := r.ReadMapStart()
			if yyl184 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl184, d)
			}
		} else if yyct184 == codecSelferValueTypeArray1234 {
			yyl184 := r.ReadArrayStart()
			if yyl184 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl184, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SelfSubjectAccessReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys185Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys185Slc
	var yyhl185 bool = l >= 0
	for yyj185 := 0; ; yyj185++ {
		if yyhl185 {
			if yyj185 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys185Slc = r.DecodeBytes(yys185Slc, true, true)
		yys185 := string(yys185Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys185 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg3_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_v1.Time{}
			} else {
				yyv195 := &x.CreationTimestamp
				yym196 := z.DecBinary()
				_ = yym196
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv195) {
				} else if yym196 {
					z.DecBinaryUnmarshal(yyv195)
				} else if !yym196 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv195)
				} else {
					z.DecFallback(yyv195, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_v1.Time)
				}
				yym198 := z.DecBinary()
				_ = yym198
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym198 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym198 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym200 := z.DecBinary()
				_ = yym200
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv201 := &x.Labels
				yym202 := z.DecBinary()
				_ = yym202
				if false {
				} else {
					z.F.DecMapStringStringX(yyv201, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv203 := &x.Annotations
				yym204 := z.DecBinary()
				_ = yym204
				if false {
				} else {
					z.F.DecMapStringStringX(yyv203, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv205 := &x.OwnerReferences
				yym206 := z.DecBinary()
				_ = yym206
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv205), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv207 := &x.Finalizers
				yym208 := z.DecBinary()
				_ = yym208
				if false {
				} else {
					z.F.DecSliceStringX(yyv207, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "Spec":
			if r.TryDecodeAsNil() {
				x.Spec = SelfSubjectAccessReviewSpec{}
			} else {
				yyv210 := &x.Spec
				yyv210.CodecDecodeSelf(d)
			}
		case "Status":
			if r.TryDecodeAsNil() {
				x.Status = SubjectAccessReviewStatus{}
			} else {
				yyv211 := &x.Status
				yyv211.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys185)
		} // end switch yys185
	} // end for yyj185
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SelfSubjectAccessReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj212 int
	var yyb212 bool
	var yyhl212 bool = l >= 0
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg3_types.UID(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_v1.Time{}
	} else {
		yyv222 := &x.CreationTimestamp
		yym223 := z.DecBinary()
		_ = yym223
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv222) {
		} else if yym223 {
			z.DecBinaryUnmarshal(yyv222)
		} else if !yym223 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv222)
		} else {
			z.DecFallback(yyv222, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_v1.Time)
		}
		yym225 := z.DecBinary()
		_ = yym225
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym225 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym225 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym227 := z.DecBinary()
		_ = yym227
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv228 := &x.Labels
		yym229 := z.DecBinary()
		_ = yym229
		if false {
		} else {
			z.F.DecMapStringStringX(yyv228, false, d)
		}
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv230 := &x.Annotations
		yym231 := z.DecBinary()
		_ = yym231
		if false {
		} else {
			z.F.DecMapStringStringX(yyv230, false, d)
		}
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv232 := &x.OwnerReferences
		yym233 := z.DecBinary()
		_ = yym233
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv232), d)
		}
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv234 := &x.Finalizers
		yym235 := z.DecBinary()
		_ = yym235
		if false {
		} else {
			z.F.DecSliceStringX(yyv234, false, d)
		}
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = SelfSubjectAccessReviewSpec{}
	} else {
		yyv237 := &x.Spec
		yyv237.CodecDecodeSelf(d)
	}
	yyj212++
	if yyhl212 {
		yyb212 = yyj212 > l
	} else {
		yyb212 = r.CheckBreak()
	}
	if yyb212 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = SubjectAccessReviewStatus{}
	} else {
		yyv238 := &x.Status
		yyv238.CodecDecodeSelf(d)
	}
	for {
		yyj212++
		if yyhl212 {
			yyb212 = yyj212 > l
		} else {
			yyb212 = r.CheckBreak()
		}
		if yyb212 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj212-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LocalSubjectAccessReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym239 := z.EncBinary()
		_ = yym239
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep240 := !z.EncBinary()
			yy2arr240 := z.EncBasicHandle().StructToArray
			var yyq240 [19]bool
			_, _, _ = yysep240, yyq240, yy2arr240
			const yyr240 bool = false
			yyq240[0] = x.Kind != ""
			yyq240[1] = x.APIVersion != ""
			yyq240[2] = x.Name != ""
			yyq240[3] = x.GenerateName != ""
			yyq240[4] = x.Namespace != ""
			yyq240[5] = x.SelfLink != ""
			yyq240[6] = x.UID != ""
			yyq240[7] = x.ResourceVersion != ""
			yyq240[8] = x.Generation != 0
			yyq240[9] = true
			yyq240[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq240[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq240[12] = len(x.Labels) != 0
			yyq240[13] = len(x.Annotations) != 0
			yyq240[14] = len(x.OwnerReferences) != 0
			yyq240[15] = len(x.Finalizers) != 0
			yyq240[16] = x.ClusterName != ""
			var yynn240 int
			if yyr240 || yy2arr240 {
				r.EncodeArrayStart(19)
			} else {
				yynn240 = 2
				for _, b := range yyq240 {
					if b {
						yynn240++
					}
				}
				r.EncodeMapStart(yynn240)
				yynn240 = 0
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[0] {
					yym242 := z.EncBinary()
					_ = yym242
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym243 := z.EncBinary()
					_ = yym243
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[1] {
					yym245 := z.EncBinary()
					_ = yym245
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym246 := z.EncBinary()
					_ = yym246
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[2] {
					yym248 := z.EncBinary()
					_ = yym248
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym249 := z.EncBinary()
					_ = yym249
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[3] {
					yym251 := z.EncBinary()
					_ = yym251
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym252 := z.EncBinary()
					_ = yym252
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[4] {
					yym254 := z.EncBinary()
					_ = yym254
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym255 := z.EncBinary()
					_ = yym255
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[5] {
					yym257 := z.EncBinary()
					_ = yym257
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym258 := z.EncBinary()
					_ = yym258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[6] {
					yym260 := z.EncBinary()
					_ = yym260
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym261 := z.EncBinary()
					_ = yym261
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[7] {
					yym263 := z.EncBinary()
					_ = yym263
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym264 := z.EncBinary()
					_ = yym264
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[8] {
					yym266 := z.EncBinary()
					_ = yym266
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq240[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym267 := z.EncBinary()
					_ = yym267
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[9] {
					yy269 := &x.CreationTimestamp
					yym270 := z.EncBinary()
					_ = yym270
					if false {
					} else if z.HasExtensions() && z.EncExt(yy269) {
					} else if yym270 {
						z.EncBinaryMarshal(yy269)
					} else if !yym270 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy269)
					} else {
						z.EncFallback(yy269)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq240[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy271 := &x.CreationTimestamp
					yym272 := z.EncBinary()
					_ = yym272
					if false {
					} else if z.HasExtensions() && z.EncExt(yy271) {
					} else if yym272 {
						z.EncBinaryMarshal(yy271)
					} else if !yym272 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy271)
					} else {
						z.EncFallback(yy271)
					}
				}
			}
			var yyn273 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn273 = true
				goto LABEL273
			}
		LABEL273:
			if yyr240 || yy2arr240 {
				if yyn273 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq240[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym274 := z.EncBinary()
							_ = yym274
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym274 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym274 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq240[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn273 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym275 := z.EncBinary()
							_ = yym275
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym275 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym275 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn276 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn276 = true
				goto LABEL276
			}
		LABEL276:
			if yyr240 || yy2arr240 {
				if yyn276 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq240[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy277 := *x.DeletionGracePeriodSeconds
							yym278 := z.EncBinary()
							_ = yym278
							if false {
							} else {
								r.EncodeInt(int64(yy277))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq240[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn276 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy279 := *x.DeletionGracePeriodSeconds
							yym280 := z.EncBinary()
							_ = yym280
							if false {
							} else {
								r.EncodeInt(int64(yy279))
							}
						}
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym282 := z.EncBinary()
						_ = yym282
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq240[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym283 := z.EncBinary()
						_ = yym283
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym285 := z.EncBinary()
						_ = yym285
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq240[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym286 := z.EncBinary()
						_ = yym286
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym288 := z.EncBinary()
						_ = yym288
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq240[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym289 := z.EncBinary()
						_ = yym289
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[15] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym291 := z.EncBinary()
						_ = yym291
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq240[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym292 := z.EncBinary()
						_ = yym292
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq240[16] {
					yym294 := z.EncBinary()
					_ = yym294
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq240[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym295 := z.EncBinary()
					_ = yym295
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy297 := &x.Spec
				yy297.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy298 := &x.Spec
				yy298.CodecEncodeSelf(e)
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy300 := &x.Status
				yy300.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy301 := &x.Status
				yy301.CodecEncodeSelf(e)
			}
			if yyr240 || yy2arr240 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LocalSubjectAccessReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym302 := z.DecBinary()
	_ = yym302
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct303 := r.ContainerType()
		if yyct303 == codecSelferValueTypeMap1234 {
			yyl303 := r.ReadMapStart()
			if yyl303 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl303, d)
			}
		} else if yyct303 == codecSelferValueTypeArray1234 {
			yyl303 := r.ReadArrayStart()
			if yyl303 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl303, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LocalSubjectAccessReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys304Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys304Slc
	var yyhl304 bool = l >= 0
	for yyj304 := 0; ; yyj304++ {
		if yyhl304 {
			if yyj304 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys304Slc = r.DecodeBytes(yys304Slc, true, true)
		yys304 := string(yys304Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys304 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg3_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_v1.Time{}
			} else {
				yyv314 := &x.CreationTimestamp
				yym315 := z.DecBinary()
				_ = yym315
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv314) {
				} else if yym315 {
					z.DecBinaryUnmarshal(yyv314)
				} else if !yym315 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv314)
				} else {
					z.DecFallback(yyv314, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_v1.Time)
				}
				yym317 := z.DecBinary()
				_ = yym317
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym317 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym317 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym319 := z.DecBinary()
				_ = yym319
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv320 := &x.Labels
				yym321 := z.DecBinary()
				_ = yym321
				if false {
				} else {
					z.F.DecMapStringStringX(yyv320, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv322 := &x.Annotations
				yym323 := z.DecBinary()
				_ = yym323
				if false {
				} else {
					z.F.DecMapStringStringX(yyv322, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv324 := &x.OwnerReferences
				yym325 := z.DecBinary()
				_ = yym325
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv324), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv326 := &x.Finalizers
				yym327 := z.DecBinary()
				_ = yym327
				if false {
				} else {
					z.F.DecSliceStringX(yyv326, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "Spec":
			if r.TryDecodeAsNil() {
				x.Spec = SubjectAccessReviewSpec{}
			} else {
				yyv329 := &x.Spec
				yyv329.CodecDecodeSelf(d)
			}
		case "Status":
			if r.TryDecodeAsNil() {
				x.Status = SubjectAccessReviewStatus{}
			} else {
				yyv330 := &x.Status
				yyv330.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys304)
		} // end switch yys304
	} // end for yyj304
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LocalSubjectAccessReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj331 int
	var yyb331 bool
	var yyhl331 bool = l >= 0
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg3_types.UID(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_v1.Time{}
	} else {
		yyv341 := &x.CreationTimestamp
		yym342 := z.DecBinary()
		_ = yym342
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv341) {
		} else if yym342 {
			z.DecBinaryUnmarshal(yyv341)
		} else if !yym342 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv341)
		} else {
			z.DecFallback(yyv341, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_v1.Time)
		}
		yym344 := z.DecBinary()
		_ = yym344
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym344 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym344 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym346 := z.DecBinary()
		_ = yym346
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv347 := &x.Labels
		yym348 := z.DecBinary()
		_ = yym348
		if false {
		} else {
			z.F.DecMapStringStringX(yyv347, false, d)
		}
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv349 := &x.Annotations
		yym350 := z.DecBinary()
		_ = yym350
		if false {
		} else {
			z.F.DecMapStringStringX(yyv349, false, d)
		}
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv351 := &x.OwnerReferences
		yym352 := z.DecBinary()
		_ = yym352
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv351), d)
		}
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv353 := &x.Finalizers
		yym354 := z.DecBinary()
		_ = yym354
		if false {
		} else {
			z.F.DecSliceStringX(yyv353, false, d)
		}
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = SubjectAccessReviewSpec{}
	} else {
		yyv356 := &x.Spec
		yyv356.CodecDecodeSelf(d)
	}
	yyj331++
	if yyhl331 {
		yyb331 = yyj331 > l
	} else {
		yyb331 = r.CheckBreak()
	}
	if yyb331 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = SubjectAccessReviewStatus{}
	} else {
		yyv357 := &x.Status
		yyv357.CodecDecodeSelf(d)
	}
	for {
		yyj331++
		if yyhl331 {
			yyb331 = yyj331 > l
		} else {
			yyb331 = r.CheckBreak()
		}
		if yyb331 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj331-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceAttributes) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym358 := z.EncBinary()
		_ = yym358
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep359 := !z.EncBinary()
			yy2arr359 := z.EncBasicHandle().StructToArray
			var yyq359 [7]bool
			_, _, _ = yysep359, yyq359, yy2arr359
			const yyr359 bool = false
			var yynn359 int
			if yyr359 || yy2arr359 {
				r.EncodeArrayStart(7)
			} else {
				yynn359 = 7
				for _, b := range yyq359 {
					if b {
						yynn359++
					}
				}
				r.EncodeMapStart(yynn359)
				yynn359 = 0
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym361 := z.EncBinary()
				_ = yym361
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Namespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym362 := z.EncBinary()
				_ = yym362
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym364 := z.EncBinary()
				_ = yym364
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Verb"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym365 := z.EncBinary()
				_ = yym365
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym367 := z.EncBinary()
				_ = yym367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Group))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Group"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym368 := z.EncBinary()
				_ = yym368
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Group))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym370 := z.EncBinary()
				_ = yym370
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Version))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Version"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym371 := z.EncBinary()
				_ = yym371
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Version))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym373 := z.EncBinary()
				_ = yym373
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym374 := z.EncBinary()
				_ = yym374
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym376 := z.EncBinary()
				_ = yym376
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Subresource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym377 := z.EncBinary()
				_ = yym377
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym379 := z.EncBinary()
				_ = yym379
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym380 := z.EncBinary()
				_ = yym380
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr359 || yy2arr359 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceAttributes) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym381 := z.DecBinary()
	_ = yym381
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct382 := r.ContainerType()
		if yyct382 == codecSelferValueTypeMap1234 {
			yyl382 := r.ReadMapStart()
			if yyl382 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl382, d)
			}
		} else if yyct382 == codecSelferValueTypeArray1234 {
			yyl382 := r.ReadArrayStart()
			if yyl382 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl382, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceAttributes) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys383Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys383Slc
	var yyhl383 bool = l >= 0
	for yyj383 := 0; ; yyj383++ {
		if yyhl383 {
			if yyj383 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys383Slc = r.DecodeBytes(yys383Slc, true, true)
		yys383 := string(yys383Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys383 {
		case "Namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "Verb":
			if r.TryDecodeAsNil() {
				x.Verb = ""
			} else {
				x.Verb = string(r.DecodeString())
			}
		case "Group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				x.Group = string(r.DecodeString())
			}
		case "Version":
			if r.TryDecodeAsNil() {
				x.Version = ""
			} else {
				x.Version = string(r.DecodeString())
			}
		case "Resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = string(r.DecodeString())
			}
		case "Subresource":
			if r.TryDecodeAsNil() {
				x.Subresource = ""
			} else {
				x.Subresource = string(r.DecodeString())
			}
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys383)
		} // end switch yys383
	} // end for yyj383
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceAttributes) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj391 int
	var yyb391 bool
	var yyhl391 bool = l >= 0
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Verb = ""
	} else {
		x.Verb = string(r.DecodeString())
	}
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		x.Group = string(r.DecodeString())
	}
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Version = ""
	} else {
		x.Version = string(r.DecodeString())
	}
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = string(r.DecodeString())
	}
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subresource = ""
	} else {
		x.Subresource = string(r.DecodeString())
	}
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj391++
		if yyhl391 {
			yyb391 = yyj391 > l
		} else {
			yyb391 = r.CheckBreak()
		}
		if yyb391 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj391-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NonResourceAttributes) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym399 := z.EncBinary()
		_ = yym399
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep400 := !z.EncBinary()
			yy2arr400 := z.EncBasicHandle().StructToArray
			var yyq400 [2]bool
			_, _, _ = yysep400, yyq400, yy2arr400
			const yyr400 bool = false
			var yynn400 int
			if yyr400 || yy2arr400 {
				r.EncodeArrayStart(2)
			} else {
				yynn400 = 2
				for _, b := range yyq400 {
					if b {
						yynn400++
					}
				}
				r.EncodeMapStart(yynn400)
				yynn400 = 0
			}
			if yyr400 || yy2arr400 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym402 := z.EncBinary()
				_ = yym402
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym403 := z.EncBinary()
				_ = yym403
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr400 || yy2arr400 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym405 := z.EncBinary()
				_ = yym405
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Verb"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym406 := z.EncBinary()
				_ = yym406
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Verb))
				}
			}
			if yyr400 || yy2arr400 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NonResourceAttributes) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym407 := z.DecBinary()
	_ = yym407
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct408 := r.ContainerType()
		if yyct408 == codecSelferValueTypeMap1234 {
			yyl408 := r.ReadMapStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl408, d)
			}
		} else if yyct408 == codecSelferValueTypeArray1234 {
			yyl408 := r.ReadArrayStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl408, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NonResourceAttributes) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys409Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys409Slc
	var yyhl409 bool = l >= 0
	for yyj409 := 0; ; yyj409++ {
		if yyhl409 {
			if yyj409 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys409Slc = r.DecodeBytes(yys409Slc, true, true)
		yys409 := string(yys409Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys409 {
		case "Path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "Verb":
			if r.TryDecodeAsNil() {
				x.Verb = ""
			} else {
				x.Verb = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys409)
		} // end switch yys409
	} // end for yyj409
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NonResourceAttributes) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj412 int
	var yyb412 bool
	var yyhl412 bool = l >= 0
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj412++
	if yyhl412 {
		yyb412 = yyj412 > l
	} else {
		yyb412 = r.CheckBreak()
	}
	if yyb412 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Verb = ""
	} else {
		x.Verb = string(r.DecodeString())
	}
	for {
		yyj412++
		if yyhl412 {
			yyb412 = yyj412 > l
		} else {
			yyb412 = r.CheckBreak()
		}
		if yyb412 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj412-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubjectAccessReviewSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym415 := z.EncBinary()
		_ = yym415
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep416 := !z.EncBinary()
			yy2arr416 := z.EncBasicHandle().StructToArray
			var yyq416 [5]bool
			_, _, _ = yysep416, yyq416, yy2arr416
			const yyr416 bool = false
			var yynn416 int
			if yyr416 || yy2arr416 {
				r.EncodeArrayStart(5)
			} else {
				yynn416 = 5
				for _, b := range yyq416 {
					if b {
						yynn416++
					}
				}
				r.EncodeMapStart(yynn416)
				yynn416 = 0
			}
			if yyr416 || yy2arr416 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.ResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.ResourceAttributes.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ResourceAttributes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.ResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.ResourceAttributes.CodecEncodeSelf(e)
				}
			}
			if yyr416 || yy2arr416 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NonResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.NonResourceAttributes.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("NonResourceAttributes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NonResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.NonResourceAttributes.CodecEncodeSelf(e)
				}
			}
			if yyr416 || yy2arr416 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym420 := z.EncBinary()
				_ = yym420
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.User))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("User"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym421 := z.EncBinary()
				_ = yym421
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.User))
				}
			}
			if yyr416 || yy2arr416 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Groups == nil {
					r.EncodeNil()
				} else {
					yym423 := z.EncBinary()
					_ = yym423
					if false {
					} else {
						z.F.EncSliceStringV(x.Groups, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Groups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Groups == nil {
					r.EncodeNil()
				} else {
					yym424 := z.EncBinary()
					_ = yym424
					if false {
					} else {
						z.F.EncSliceStringV(x.Groups, false, e)
					}
				}
			}
			if yyr416 || yy2arr416 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Extra == nil {
					r.EncodeNil()
				} else {
					yym426 := z.EncBinary()
					_ = yym426
					if false {
					} else {
						h.encMapstringExtraValue((map[string]ExtraValue)(x.Extra), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Extra"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Extra == nil {
					r.EncodeNil()
				} else {
					yym427 := z.EncBinary()
					_ = yym427
					if false {
					} else {
						h.encMapstringExtraValue((map[string]ExtraValue)(x.Extra), e)
					}
				}
			}
			if yyr416 || yy2arr416 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubjectAccessReviewSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym428 := z.DecBinary()
	_ = yym428
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct429 := r.ContainerType()
		if yyct429 == codecSelferValueTypeMap1234 {
			yyl429 := r.ReadMapStart()
			if yyl429 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl429, d)
			}
		} else if yyct429 == codecSelferValueTypeArray1234 {
			yyl429 := r.ReadArrayStart()
			if yyl429 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl429, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubjectAccessReviewSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys430Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys430Slc
	var yyhl430 bool = l >= 0
	for yyj430 := 0; ; yyj430++ {
		if yyhl430 {
			if yyj430 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys430Slc = r.DecodeBytes(yys430Slc, true, true)
		yys430 := string(yys430Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys430 {
		case "ResourceAttributes":
			if r.TryDecodeAsNil() {
				if x.ResourceAttributes != nil {
					x.ResourceAttributes = nil
				}
			} else {
				if x.ResourceAttributes == nil {
					x.ResourceAttributes = new(ResourceAttributes)
				}
				x.ResourceAttributes.CodecDecodeSelf(d)
			}
		case "NonResourceAttributes":
			if r.TryDecodeAsNil() {
				if x.NonResourceAttributes != nil {
					x.NonResourceAttributes = nil
				}
			} else {
				if x.NonResourceAttributes == nil {
					x.NonResourceAttributes = new(NonResourceAttributes)
				}
				x.NonResourceAttributes.CodecDecodeSelf(d)
			}
		case "User":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "Groups":
			if r.TryDecodeAsNil() {
				x.Groups = nil
			} else {
				yyv434 := &x.Groups
				yym435 := z.DecBinary()
				_ = yym435
				if false {
				} else {
					z.F.DecSliceStringX(yyv434, false, d)
				}
			}
		case "Extra":
			if r.TryDecodeAsNil() {
				x.Extra = nil
			} else {
				yyv436 := &x.Extra
				yym437 := z.DecBinary()
				_ = yym437
				if false {
				} else {
					h.decMapstringExtraValue((*map[string]ExtraValue)(yyv436), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys430)
		} // end switch yys430
	} // end for yyj430
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubjectAccessReviewSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj438 int
	var yyb438 bool
	var yyhl438 bool = l >= 0
	yyj438++
	if yyhl438 {
		yyb438 = yyj438 > l
	} else {
		yyb438 = r.CheckBreak()
	}
	if yyb438 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceAttributes != nil {
			x.ResourceAttributes = nil
		}
	} else {
		if x.ResourceAttributes == nil {
			x.ResourceAttributes = new(ResourceAttributes)
		}
		x.ResourceAttributes.CodecDecodeSelf(d)
	}
	yyj438++
	if yyhl438 {
		yyb438 = yyj438 > l
	} else {
		yyb438 = r.CheckBreak()
	}
	if yyb438 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NonResourceAttributes != nil {
			x.NonResourceAttributes = nil
		}
	} else {
		if x.NonResourceAttributes == nil {
			x.NonResourceAttributes = new(NonResourceAttributes)
		}
		x.NonResourceAttributes.CodecDecodeSelf(d)
	}
	yyj438++
	if yyhl438 {
		yyb438 = yyj438 > l
	} else {
		yyb438 = r.CheckBreak()
	}
	if yyb438 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj438++
	if yyhl438 {
		yyb438 = yyj438 > l
	} else {
		yyb438 = r.CheckBreak()
	}
	if yyb438 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Groups = nil
	} else {
		yyv442 := &x.Groups
		yym443 := z.DecBinary()
		_ = yym443
		if false {
		} else {
			z.F.DecSliceStringX(yyv442, false, d)
		}
	}
	yyj438++
	if yyhl438 {
		yyb438 = yyj438 > l
	} else {
		yyb438 = r.CheckBreak()
	}
	if yyb438 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Extra = nil
	} else {
		yyv444 := &x.Extra
		yym445 := z.DecBinary()
		_ = yym445
		if false {
		} else {
			h.decMapstringExtraValue((*map[string]ExtraValue)(yyv444), d)
		}
	}
	for {
		yyj438++
		if yyhl438 {
			yyb438 = yyj438 > l
		} else {
			yyb438 = r.CheckBreak()
		}
		if yyb438 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj438-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ExtraValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym446 := z.EncBinary()
		_ = yym446
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encExtraValue((ExtraValue)(x), e)
		}
	}
}

func (x *ExtraValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym447 := z.DecBinary()
	_ = yym447
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decExtraValue((*ExtraValue)(x), d)
	}
}

func (x *SelfSubjectAccessReviewSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym448 := z.EncBinary()
		_ = yym448
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep449 := !z.EncBinary()
			yy2arr449 := z.EncBasicHandle().StructToArray
			var yyq449 [2]bool
			_, _, _ = yysep449, yyq449, yy2arr449
			const yyr449 bool = false
			var yynn449 int
			if yyr449 || yy2arr449 {
				r.EncodeArrayStart(2)
			} else {
				yynn449 = 2
				for _, b := range yyq449 {
					if b {
						yynn449++
					}
				}
				r.EncodeMapStart(yynn449)
				yynn449 = 0
			}
			if yyr449 || yy2arr449 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.ResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.ResourceAttributes.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ResourceAttributes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.ResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.ResourceAttributes.CodecEncodeSelf(e)
				}
			}
			if yyr449 || yy2arr449 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NonResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.NonResourceAttributes.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("NonResourceAttributes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NonResourceAttributes == nil {
					r.EncodeNil()
				} else {
					x.NonResourceAttributes.CodecEncodeSelf(e)
				}
			}
			if yyr449 || yy2arr449 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SelfSubjectAccessReviewSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym452 := z.DecBinary()
	_ = yym452
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct453 := r.ContainerType()
		if yyct453 == codecSelferValueTypeMap1234 {
			yyl453 := r.ReadMapStart()
			if yyl453 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl453, d)
			}
		} else if yyct453 == codecSelferValueTypeArray1234 {
			yyl453 := r.ReadArrayStart()
			if yyl453 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl453, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SelfSubjectAccessReviewSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys454Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys454Slc
	var yyhl454 bool = l >= 0
	for yyj454 := 0; ; yyj454++ {
		if yyhl454 {
			if yyj454 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys454Slc = r.DecodeBytes(yys454Slc, true, true)
		yys454 := string(yys454Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys454 {
		case "ResourceAttributes":
			if r.TryDecodeAsNil() {
				if x.ResourceAttributes != nil {
					x.ResourceAttributes = nil
				}
			} else {
				if x.ResourceAttributes == nil {
					x.ResourceAttributes = new(ResourceAttributes)
				}
				x.ResourceAttributes.CodecDecodeSelf(d)
			}
		case "NonResourceAttributes":
			if r.TryDecodeAsNil() {
				if x.NonResourceAttributes != nil {
					x.NonResourceAttributes = nil
				}
			} else {
				if x.NonResourceAttributes == nil {
					x.NonResourceAttributes = new(NonResourceAttributes)
				}
				x.NonResourceAttributes.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys454)
		} // end switch yys454
	} // end for yyj454
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SelfSubjectAccessReviewSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj457 int
	var yyb457 bool
	var yyhl457 bool = l >= 0
	yyj457++
	if yyhl457 {
		yyb457 = yyj457 > l
	} else {
		yyb457 = r.CheckBreak()
	}
	if yyb457 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceAttributes != nil {
			x.ResourceAttributes = nil
		}
	} else {
		if x.ResourceAttributes == nil {
			x.ResourceAttributes = new(ResourceAttributes)
		}
		x.ResourceAttributes.CodecDecodeSelf(d)
	}
	yyj457++
	if yyhl457 {
		yyb457 = yyj457 > l
	} else {
		yyb457 = r.CheckBreak()
	}
	if yyb457 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NonResourceAttributes != nil {
			x.NonResourceAttributes = nil
		}
	} else {
		if x.NonResourceAttributes == nil {
			x.NonResourceAttributes = new(NonResourceAttributes)
		}
		x.NonResourceAttributes.CodecDecodeSelf(d)
	}
	for {
		yyj457++
		if yyhl457 {
			yyb457 = yyj457 > l
		} else {
			yyb457 = r.CheckBreak()
		}
		if yyb457 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj457-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubjectAccessReviewStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym460 := z.EncBinary()
		_ = yym460
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep461 := !z.EncBinary()
			yy2arr461 := z.EncBasicHandle().StructToArray
			var yyq461 [3]bool
			_, _, _ = yysep461, yyq461, yy2arr461
			const yyr461 bool = false
			var yynn461 int
			if yyr461 || yy2arr461 {
				r.EncodeArrayStart(3)
			} else {
				yynn461 = 3
				for _, b := range yyq461 {
					if b {
						yynn461++
					}
				}
				r.EncodeMapStart(yynn461)
				yynn461 = 0
			}
			if yyr461 || yy2arr461 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym463 := z.EncBinary()
				_ = yym463
				if false {
				} else {
					r.EncodeBool(bool(x.Allowed))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Allowed"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym464 := z.EncBinary()
				_ = yym464
				if false {
				} else {
					r.EncodeBool(bool(x.Allowed))
				}
			}
			if yyr461 || yy2arr461 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym466 := z.EncBinary()
				_ = yym466
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Reason"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym467 := z.EncBinary()
				_ = yym467
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
				}
			}
			if yyr461 || yy2arr461 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym469 := z.EncBinary()
				_ = yym469
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EvaluationError))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("EvaluationError"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym470 := z.EncBinary()
				_ = yym470
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EvaluationError))
				}
			}
			if yyr461 || yy2arr461 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubjectAccessReviewStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym471 := z.DecBinary()
	_ = yym471
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct472 := r.ContainerType()
		if yyct472 == codecSelferValueTypeMap1234 {
			yyl472 := r.ReadMapStart()
			if yyl472 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl472, d)
			}
		} else if yyct472 == codecSelferValueTypeArray1234 {
			yyl472 := r.ReadArrayStart()
			if yyl472 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl472, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubjectAccessReviewStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys473Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys473Slc
	var yyhl473 bool = l >= 0
	for yyj473 := 0; ; yyj473++ {
		if yyhl473 {
			if yyj473 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys473Slc = r.DecodeBytes(yys473Slc, true, true)
		yys473 := string(yys473Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys473 {
		case "Allowed":
			if r.TryDecodeAsNil() {
				x.Allowed = false
			} else {
				x.Allowed = bool(r.DecodeBool())
			}
		case "Reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "EvaluationError":
			if r.TryDecodeAsNil() {
				x.EvaluationError = ""
			} else {
				x.EvaluationError = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys473)
		} // end switch yys473
	} // end for yyj473
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubjectAccessReviewStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj477 int
	var yyb477 bool
	var yyhl477 bool = l >= 0
	yyj477++
	if yyhl477 {
		yyb477 = yyj477 > l
	} else {
		yyb477 = r.CheckBreak()
	}
	if yyb477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allowed = false
	} else {
		x.Allowed = bool(r.DecodeBool())
	}
	yyj477++
	if yyhl477 {
		yyb477 = yyj477 > l
	} else {
		yyb477 = r.CheckBreak()
	}
	if yyb477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj477++
	if yyhl477 {
		yyb477 = yyj477 > l
	} else {
		yyb477 = r.CheckBreak()
	}
	if yyb477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvaluationError = ""
	} else {
		x.EvaluationError = string(r.DecodeString())
	}
	for {
		yyj477++
		if yyhl477 {
			yyb477 = yyj477 > l
		} else {
			yyb477 = r.CheckBreak()
		}
		if yyb477 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj477-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSlicev1_OwnerReference(v []pkg1_v1.OwnerReference, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv481 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy482 := &yyv481
		yym483 := z.EncBinary()
		_ = yym483
		if false {
		} else if z.HasExtensions() && z.EncExt(yy482) {
		} else {
			z.EncFallback(yy482)
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicev1_OwnerReference(v *[]pkg1_v1.OwnerReference, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv484 := *v
	yyh484, yyl484 := z.DecSliceHelperStart()
	var yyc484 bool
	if yyl484 == 0 {
		if yyv484 == nil {
			yyv484 = []pkg1_v1.OwnerReference{}
			yyc484 = true
		} else if len(yyv484) != 0 {
			yyv484 = yyv484[:0]
			yyc484 = true
		}
	} else if yyl484 > 0 {
		var yyrr484, yyrl484 int
		var yyrt484 bool
		if yyl484 > cap(yyv484) {

			yyrg484 := len(yyv484) > 0
			yyv2484 := yyv484
			yyrl484, yyrt484 = z.DecInferLen(yyl484, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt484 {
				if yyrl484 <= cap(yyv484) {
					yyv484 = yyv484[:yyrl484]
				} else {
					yyv484 = make([]pkg1_v1.OwnerReference, yyrl484)
				}
			} else {
				yyv484 = make([]pkg1_v1.OwnerReference, yyrl484)
			}
			yyc484 = true
			yyrr484 = len(yyv484)
			if yyrg484 {
				copy(yyv484, yyv2484)
			}
		} else if yyl484 != len(yyv484) {
			yyv484 = yyv484[:yyl484]
			yyc484 = true
		}
		yyj484 := 0
		for ; yyj484 < yyrr484; yyj484++ {
			yyh484.ElemContainerState(yyj484)
			if r.TryDecodeAsNil() {
				yyv484[yyj484] = pkg1_v1.OwnerReference{}
			} else {
				yyv485 := &yyv484[yyj484]
				yym486 := z.DecBinary()
				_ = yym486
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv485) {
				} else {
					z.DecFallback(yyv485, false)
				}
			}

		}
		if yyrt484 {
			for ; yyj484 < yyl484; yyj484++ {
				yyv484 = append(yyv484, pkg1_v1.OwnerReference{})
				yyh484.ElemContainerState(yyj484)
				if r.TryDecodeAsNil() {
					yyv484[yyj484] = pkg1_v1.OwnerReference{}
				} else {
					yyv487 := &yyv484[yyj484]
					yym488 := z.DecBinary()
					_ = yym488
					if false {
					} else if z.HasExtensions() && z.DecExt(yyv487) {
					} else {
						z.DecFallback(yyv487, false)
					}
				}

			}
		}

	} else {
		yyj484 := 0
		for ; !r.CheckBreak(); yyj484++ {

			if yyj484 >= len(yyv484) {
				yyv484 = append(yyv484, pkg1_v1.OwnerReference{}) // var yyz484 pkg1_v1.OwnerReference
				yyc484 = true
			}
			yyh484.ElemContainerState(yyj484)
			if yyj484 < len(yyv484) {
				if r.TryDecodeAsNil() {
					yyv484[yyj484] = pkg1_v1.OwnerReference{}
				} else {
					yyv489 := &yyv484[yyj484]
					yym490 := z.DecBinary()
					_ = yym490
					if false {
					} else if z.HasExtensions() && z.DecExt(yyv489) {
					} else {
						z.DecFallback(yyv489, false)
					}
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj484 < len(yyv484) {
			yyv484 = yyv484[:yyj484]
			yyc484 = true
		} else if yyj484 == 0 && yyv484 == nil {
			yyv484 = []pkg1_v1.OwnerReference{}
			yyc484 = true
		}
	}
	yyh484.End()
	if yyc484 {
		*v = yyv484
	}
}

func (x codecSelfer1234) encMapstringExtraValue(v map[string]ExtraValue, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk491, yyv491 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym492 := z.EncBinary()
		_ = yym492
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk491))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		if yyv491 == nil {
			r.EncodeNil()
		} else {
			yyv491.CodecEncodeSelf(e)
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decMapstringExtraValue(v *map[string]ExtraValue, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv493 := *v
	yyl493 := r.ReadMapStart()
	yybh493 := z.DecBasicHandle()
	if yyv493 == nil {
		yyrl493, _ := z.DecInferLen(yyl493, yybh493.MaxInitLen, 40)
		yyv493 = make(map[string]ExtraValue, yyrl493)
		*v = yyv493
	}
	var yymk493 string
	var yymv493 ExtraValue
	var yymg493 bool
	if yybh493.MapValueReset {
		yymg493 = true
	}
	if yyl493 > 0 {
		for yyj493 := 0; yyj493 < yyl493; yyj493++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk493 = ""
			} else {
				yymk493 = string(r.DecodeString())
			}

			if yymg493 {
				yymv493 = yyv493[yymk493]
			} else {
				yymv493 = nil
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv493 = nil
			} else {
				yyv495 := &yymv493
				yyv495.CodecDecodeSelf(d)
			}

			if yyv493 != nil {
				yyv493[yymk493] = yymv493
			}
		}
	} else if yyl493 < 0 {
		for yyj493 := 0; !r.CheckBreak(); yyj493++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk493 = ""
			} else {
				yymk493 = string(r.DecodeString())
			}

			if yymg493 {
				yymv493 = yyv493[yymk493]
			} else {
				yymv493 = nil
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv493 = nil
			} else {
				yyv497 := &yymv493
				yyv497.CodecDecodeSelf(d)
			}

			if yyv493 != nil {
				yyv493[yymk493] = yymv493
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) encExtraValue(v ExtraValue, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv498 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym499 := z.EncBinary()
		_ = yym499
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv498))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decExtraValue(v *ExtraValue, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv500 := *v
	yyh500, yyl500 := z.DecSliceHelperStart()
	var yyc500 bool
	if yyl500 == 0 {
		if yyv500 == nil {
			yyv500 = []string{}
			yyc500 = true
		} else if len(yyv500) != 0 {
			yyv500 = yyv500[:0]
			yyc500 = true
		}
	} else if yyl500 > 0 {
		var yyrr500, yyrl500 int
		var yyrt500 bool
		if yyl500 > cap(yyv500) {

			yyrl500, yyrt500 = z.DecInferLen(yyl500, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt500 {
				if yyrl500 <= cap(yyv500) {
					yyv500 = yyv500[:yyrl500]
				} else {
					yyv500 = make([]string, yyrl500)
				}
			} else {
				yyv500 = make([]string, yyrl500)
			}
			yyc500 = true
			yyrr500 = len(yyv500)
		} else if yyl500 != len(yyv500) {
			yyv500 = yyv500[:yyl500]
			yyc500 = true
		}
		yyj500 := 0
		for ; yyj500 < yyrr500; yyj500++ {
			yyh500.ElemContainerState(yyj500)
			if r.TryDecodeAsNil() {
				yyv500[yyj500] = ""
			} else {
				yyv500[yyj500] = string(r.DecodeString())
			}

		}
		if yyrt500 {
			for ; yyj500 < yyl500; yyj500++ {
				yyv500 = append(yyv500, "")
				yyh500.ElemContainerState(yyj500)
				if r.TryDecodeAsNil() {
					yyv500[yyj500] = ""
				} else {
					yyv500[yyj500] = string(r.DecodeString())
				}

			}
		}

	} else {
		yyj500 := 0
		for ; !r.CheckBreak(); yyj500++ {

			if yyj500 >= len(yyv500) {
				yyv500 = append(yyv500, "") // var yyz500 string
				yyc500 = true
			}
			yyh500.ElemContainerState(yyj500)
			if yyj500 < len(yyv500) {
				if r.TryDecodeAsNil() {
					yyv500[yyj500] = ""
				} else {
					yyv500[yyj500] = string(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj500 < len(yyv500) {
			yyv500 = yyv500[:yyj500]
			yyc500 = true
		} else if yyj500 == 0 && yyv500 == nil {
			yyv500 = []string{}
			yyc500 = true
		}
	}
	yyh500.End()
	if yyc500 {
		*v = yyv500
	}
}
