/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package authentication

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/client-go/pkg/api"
	pkg1_v1 "k8s.io/client-go/pkg/apis/meta/v1"
	pkg3_types "k8s.io/client-go/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg1_v1.TypeMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *TokenReview) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [19]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = x.Name != ""
			yyq2[3] = x.GenerateName != ""
			yyq2[4] = x.Namespace != ""
			yyq2[5] = x.SelfLink != ""
			yyq2[6] = x.UID != ""
			yyq2[7] = x.ResourceVersion != ""
			yyq2[8] = x.Generation != 0
			yyq2[9] = true
			yyq2[10] = x.ObjectMeta.DeletionTimestamp != nil && x.DeletionTimestamp != nil
			yyq2[11] = x.ObjectMeta.DeletionGracePeriodSeconds != nil && x.DeletionGracePeriodSeconds != nil
			yyq2[12] = len(x.Labels) != 0
			yyq2[13] = len(x.Annotations) != 0
			yyq2[14] = len(x.OwnerReferences) != 0
			yyq2[15] = len(x.Finalizers) != 0
			yyq2[16] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(19)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yy31 := &x.CreationTimestamp
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else if z.HasExtensions() && z.EncExt(yy31) {
					} else if yym32 {
						z.EncBinaryMarshal(yy31)
					} else if !yym32 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy31)
					} else {
						z.EncFallback(yy31)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy33 := &x.CreationTimestamp
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else if z.HasExtensions() && z.EncExt(yy33) {
					} else if yym34 {
						z.EncBinaryMarshal(yy33)
					} else if !yym34 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy33)
					} else {
						z.EncFallback(yy33)
					}
				}
			}
			var yyn35 bool
			if x.ObjectMeta.DeletionTimestamp == nil {
				yyn35 = true
				goto LABEL35
			}
		LABEL35:
			if yyr2 || yy2arr2 {
				if yyn35 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym36 := z.EncBinary()
							_ = yym36
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym36 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym36 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn35 {
						r.EncodeNil()
					} else {
						if x.DeletionTimestamp == nil {
							r.EncodeNil()
						} else {
							yym37 := z.EncBinary()
							_ = yym37
							if false {
							} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
							} else if yym37 {
								z.EncBinaryMarshal(x.DeletionTimestamp)
							} else if !yym37 && z.IsJSONHandle() {
								z.EncJSONMarshal(x.DeletionTimestamp)
							} else {
								z.EncFallback(x.DeletionTimestamp)
							}
						}
					}
				}
			}
			var yyn38 bool
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				yyn38 = true
				goto LABEL38
			}
		LABEL38:
			if yyr2 || yy2arr2 {
				if yyn38 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy39 := *x.DeletionGracePeriodSeconds
							yym40 := z.EncBinary()
							_ = yym40
							if false {
							} else {
								r.EncodeInt(int64(yy39))
							}
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn38 {
						r.EncodeNil()
					} else {
						if x.DeletionGracePeriodSeconds == nil {
							r.EncodeNil()
						} else {
							yy41 := *x.DeletionGracePeriodSeconds
							yym42 := z.EncBinary()
							_ = yym42
							if false {
							} else {
								r.EncodeInt(int64(yy41))
							}
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym50 := z.EncBinary()
						_ = yym50
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym51 := z.EncBinary()
						_ = yym51
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg1_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym53 := z.EncBinary()
						_ = yym53
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym54 := z.EncBinary()
						_ = yym54
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					yym56 := z.EncBinary()
					_ = yym56
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym57 := z.EncBinary()
					_ = yym57
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy59 := &x.Spec
				yy59.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Spec"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy60 := &x.Spec
				yy60.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy62 := &x.Status
				yy62.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy63 := &x.Status
				yy63.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TokenReview) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym64 := z.DecBinary()
	_ = yym64
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct65 := r.ContainerType()
		if yyct65 == codecSelferValueTypeMap1234 {
			yyl65 := r.ReadMapStart()
			if yyl65 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl65, d)
			}
		} else if yyct65 == codecSelferValueTypeArray1234 {
			yyl65 := r.ReadArrayStart()
			if yyl65 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl65, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TokenReview) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys66Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys66Slc
	var yyhl66 bool = l >= 0
	for yyj66 := 0; ; yyj66++ {
		if yyhl66 {
			if yyj66 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys66Slc = r.DecodeBytes(yys66Slc, true, true)
		yys66 := string(yys66Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys66 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg3_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg1_v1.Time{}
			} else {
				yyv76 := &x.CreationTimestamp
				yym77 := z.DecBinary()
				_ = yym77
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv76) {
				} else if yym77 {
					z.DecBinaryUnmarshal(yyv76)
				} else if !yym77 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv76)
				} else {
					z.DecFallback(yyv76, false)
				}
			}
		case "deletionTimestamp":
			if x.ObjectMeta.DeletionTimestamp == nil {
				x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg1_v1.Time)
				}
				yym79 := z.DecBinary()
				_ = yym79
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym79 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym79 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
				x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
			}
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym81 := z.DecBinary()
				_ = yym81
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv82 := &x.Labels
				yym83 := z.DecBinary()
				_ = yym83
				if false {
				} else {
					z.F.DecMapStringStringX(yyv82, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv84 := &x.Annotations
				yym85 := z.DecBinary()
				_ = yym85
				if false {
				} else {
					z.F.DecMapStringStringX(yyv84, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv86 := &x.OwnerReferences
				yym87 := z.DecBinary()
				_ = yym87
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv86), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv88 := &x.Finalizers
				yym89 := z.DecBinary()
				_ = yym89
				if false {
				} else {
					z.F.DecSliceStringX(yyv88, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "Spec":
			if r.TryDecodeAsNil() {
				x.Spec = TokenReviewSpec{}
			} else {
				yyv91 := &x.Spec
				yyv91.CodecDecodeSelf(d)
			}
		case "Status":
			if r.TryDecodeAsNil() {
				x.Status = TokenReviewStatus{}
			} else {
				yyv92 := &x.Status
				yyv92.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys66)
		} // end switch yys66
	} // end for yyj66
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TokenReview) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj93 int
	var yyb93 bool
	var yyhl93 bool = l >= 0
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg3_types.UID(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg1_v1.Time{}
	} else {
		yyv103 := &x.CreationTimestamp
		yym104 := z.DecBinary()
		_ = yym104
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv103) {
		} else if yym104 {
			z.DecBinaryUnmarshal(yyv103)
		} else if !yym104 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv103)
		} else {
			z.DecFallback(yyv103, false)
		}
	}
	if x.ObjectMeta.DeletionTimestamp == nil {
		x.ObjectMeta.DeletionTimestamp = new(pkg1_v1.Time)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg1_v1.Time)
		}
		yym106 := z.DecBinary()
		_ = yym106
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym106 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym106 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	if x.ObjectMeta.DeletionGracePeriodSeconds == nil {
		x.ObjectMeta.DeletionGracePeriodSeconds = new(int64)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym108 := z.DecBinary()
		_ = yym108
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv109 := &x.Labels
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else {
			z.F.DecMapStringStringX(yyv109, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv111 := &x.Annotations
		yym112 := z.DecBinary()
		_ = yym112
		if false {
		} else {
			z.F.DecMapStringStringX(yyv111, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv113 := &x.OwnerReferences
		yym114 := z.DecBinary()
		_ = yym114
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg1_v1.OwnerReference)(yyv113), d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv115 := &x.Finalizers
		yym116 := z.DecBinary()
		_ = yym116
		if false {
		} else {
			z.F.DecSliceStringX(yyv115, false, d)
		}
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = TokenReviewSpec{}
	} else {
		yyv118 := &x.Spec
		yyv118.CodecDecodeSelf(d)
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = TokenReviewStatus{}
	} else {
		yyv119 := &x.Status
		yyv119.CodecDecodeSelf(d)
	}
	for {
		yyj93++
		if yyhl93 {
			yyb93 = yyj93 > l
		} else {
			yyb93 = r.CheckBreak()
		}
		if yyb93 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj93-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *TokenReviewSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym120 := z.EncBinary()
		_ = yym120
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep121 := !z.EncBinary()
			yy2arr121 := z.EncBasicHandle().StructToArray
			var yyq121 [1]bool
			_, _, _ = yysep121, yyq121, yy2arr121
			const yyr121 bool = false
			var yynn121 int
			if yyr121 || yy2arr121 {
				r.EncodeArrayStart(1)
			} else {
				yynn121 = 1
				for _, b := range yyq121 {
					if b {
						yynn121++
					}
				}
				r.EncodeMapStart(yynn121)
				yynn121 = 0
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym123 := z.EncBinary()
				_ = yym123
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Token))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Token"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym124 := z.EncBinary()
				_ = yym124
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Token))
				}
			}
			if yyr121 || yy2arr121 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TokenReviewSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym125 := z.DecBinary()
	_ = yym125
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct126 := r.ContainerType()
		if yyct126 == codecSelferValueTypeMap1234 {
			yyl126 := r.ReadMapStart()
			if yyl126 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl126, d)
			}
		} else if yyct126 == codecSelferValueTypeArray1234 {
			yyl126 := r.ReadArrayStart()
			if yyl126 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl126, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TokenReviewSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys127Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys127Slc
	var yyhl127 bool = l >= 0
	for yyj127 := 0; ; yyj127++ {
		if yyhl127 {
			if yyj127 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys127Slc = r.DecodeBytes(yys127Slc, true, true)
		yys127 := string(yys127Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys127 {
		case "Token":
			if r.TryDecodeAsNil() {
				x.Token = ""
			} else {
				x.Token = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys127)
		} // end switch yys127
	} // end for yyj127
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TokenReviewSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj129 int
	var yyb129 bool
	var yyhl129 bool = l >= 0
	yyj129++
	if yyhl129 {
		yyb129 = yyj129 > l
	} else {
		yyb129 = r.CheckBreak()
	}
	if yyb129 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Token = ""
	} else {
		x.Token = string(r.DecodeString())
	}
	for {
		yyj129++
		if yyhl129 {
			yyb129 = yyj129 > l
		} else {
			yyb129 = r.CheckBreak()
		}
		if yyb129 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj129-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *TokenReviewStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym131 := z.EncBinary()
		_ = yym131
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep132 := !z.EncBinary()
			yy2arr132 := z.EncBasicHandle().StructToArray
			var yyq132 [3]bool
			_, _, _ = yysep132, yyq132, yy2arr132
			const yyr132 bool = false
			var yynn132 int
			if yyr132 || yy2arr132 {
				r.EncodeArrayStart(3)
			} else {
				yynn132 = 3
				for _, b := range yyq132 {
					if b {
						yynn132++
					}
				}
				r.EncodeMapStart(yynn132)
				yynn132 = 0
			}
			if yyr132 || yy2arr132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym134 := z.EncBinary()
				_ = yym134
				if false {
				} else {
					r.EncodeBool(bool(x.Authenticated))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Authenticated"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym135 := z.EncBinary()
				_ = yym135
				if false {
				} else {
					r.EncodeBool(bool(x.Authenticated))
				}
			}
			if yyr132 || yy2arr132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy137 := &x.User
				yy137.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("User"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy138 := &x.User
				yy138.CodecEncodeSelf(e)
			}
			if yyr132 || yy2arr132 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym140 := z.EncBinary()
				_ = yym140
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Error))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Error"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym141 := z.EncBinary()
				_ = yym141
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Error))
				}
			}
			if yyr132 || yy2arr132 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TokenReviewStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym142 := z.DecBinary()
	_ = yym142
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct143 := r.ContainerType()
		if yyct143 == codecSelferValueTypeMap1234 {
			yyl143 := r.ReadMapStart()
			if yyl143 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl143, d)
			}
		} else if yyct143 == codecSelferValueTypeArray1234 {
			yyl143 := r.ReadArrayStart()
			if yyl143 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl143, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TokenReviewStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys144Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys144Slc
	var yyhl144 bool = l >= 0
	for yyj144 := 0; ; yyj144++ {
		if yyhl144 {
			if yyj144 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys144Slc = r.DecodeBytes(yys144Slc, true, true)
		yys144 := string(yys144Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys144 {
		case "Authenticated":
			if r.TryDecodeAsNil() {
				x.Authenticated = false
			} else {
				x.Authenticated = bool(r.DecodeBool())
			}
		case "User":
			if r.TryDecodeAsNil() {
				x.User = UserInfo{}
			} else {
				yyv146 := &x.User
				yyv146.CodecDecodeSelf(d)
			}
		case "Error":
			if r.TryDecodeAsNil() {
				x.Error = ""
			} else {
				x.Error = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys144)
		} // end switch yys144
	} // end for yyj144
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TokenReviewStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj148 int
	var yyb148 bool
	var yyhl148 bool = l >= 0
	yyj148++
	if yyhl148 {
		yyb148 = yyj148 > l
	} else {
		yyb148 = r.CheckBreak()
	}
	if yyb148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authenticated = false
	} else {
		x.Authenticated = bool(r.DecodeBool())
	}
	yyj148++
	if yyhl148 {
		yyb148 = yyj148 > l
	} else {
		yyb148 = r.CheckBreak()
	}
	if yyb148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = UserInfo{}
	} else {
		yyv150 := &x.User
		yyv150.CodecDecodeSelf(d)
	}
	yyj148++
	if yyhl148 {
		yyb148 = yyj148 > l
	} else {
		yyb148 = r.CheckBreak()
	}
	if yyb148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Error = ""
	} else {
		x.Error = string(r.DecodeString())
	}
	for {
		yyj148++
		if yyhl148 {
			yyb148 = yyj148 > l
		} else {
			yyb148 = r.CheckBreak()
		}
		if yyb148 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj148-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *UserInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym152 := z.EncBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep153 := !z.EncBinary()
			yy2arr153 := z.EncBasicHandle().StructToArray
			var yyq153 [4]bool
			_, _, _ = yysep153, yyq153, yy2arr153
			const yyr153 bool = false
			var yynn153 int
			if yyr153 || yy2arr153 {
				r.EncodeArrayStart(4)
			} else {
				yynn153 = 4
				for _, b := range yyq153 {
					if b {
						yynn153++
					}
				}
				r.EncodeMapStart(yynn153)
				yynn153 = 0
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym155 := z.EncBinary()
				_ = yym155
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Username))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Username"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Username))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym158 := z.EncBinary()
				_ = yym158
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.UID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("UID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.UID))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Groups == nil {
					r.EncodeNil()
				} else {
					yym161 := z.EncBinary()
					_ = yym161
					if false {
					} else {
						z.F.EncSliceStringV(x.Groups, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Groups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Groups == nil {
					r.EncodeNil()
				} else {
					yym162 := z.EncBinary()
					_ = yym162
					if false {
					} else {
						z.F.EncSliceStringV(x.Groups, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Extra == nil {
					r.EncodeNil()
				} else {
					yym164 := z.EncBinary()
					_ = yym164
					if false {
					} else {
						h.encMapstringExtraValue((map[string]ExtraValue)(x.Extra), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Extra"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Extra == nil {
					r.EncodeNil()
				} else {
					yym165 := z.EncBinary()
					_ = yym165
					if false {
					} else {
						h.encMapstringExtraValue((map[string]ExtraValue)(x.Extra), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *UserInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym166 := z.DecBinary()
	_ = yym166
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct167 := r.ContainerType()
		if yyct167 == codecSelferValueTypeMap1234 {
			yyl167 := r.ReadMapStart()
			if yyl167 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl167, d)
			}
		} else if yyct167 == codecSelferValueTypeArray1234 {
			yyl167 := r.ReadArrayStart()
			if yyl167 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl167, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *UserInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys168Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys168Slc
	var yyhl168 bool = l >= 0
	for yyj168 := 0; ; yyj168++ {
		if yyhl168 {
			if yyj168 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys168Slc = r.DecodeBytes(yys168Slc, true, true)
		yys168 := string(yys168Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys168 {
		case "Username":
			if r.TryDecodeAsNil() {
				x.Username = ""
			} else {
				x.Username = string(r.DecodeString())
			}
		case "UID":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = string(r.DecodeString())
			}
		case "Groups":
			if r.TryDecodeAsNil() {
				x.Groups = nil
			} else {
				yyv171 := &x.Groups
				yym172 := z.DecBinary()
				_ = yym172
				if false {
				} else {
					z.F.DecSliceStringX(yyv171, false, d)
				}
			}
		case "Extra":
			if r.TryDecodeAsNil() {
				x.Extra = nil
			} else {
				yyv173 := &x.Extra
				yym174 := z.DecBinary()
				_ = yym174
				if false {
				} else {
					h.decMapstringExtraValue((*map[string]ExtraValue)(yyv173), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys168)
		} // end switch yys168
	} // end for yyj168
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *UserInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj175 int
	var yyb175 bool
	var yyhl175 bool = l >= 0
	yyj175++
	if yyhl175 {
		yyb175 = yyj175 > l
	} else {
		yyb175 = r.CheckBreak()
	}
	if yyb175 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Username = ""
	} else {
		x.Username = string(r.DecodeString())
	}
	yyj175++
	if yyhl175 {
		yyb175 = yyj175 > l
	} else {
		yyb175 = r.CheckBreak()
	}
	if yyb175 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = string(r.DecodeString())
	}
	yyj175++
	if yyhl175 {
		yyb175 = yyj175 > l
	} else {
		yyb175 = r.CheckBreak()
	}
	if yyb175 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Groups = nil
	} else {
		yyv178 := &x.Groups
		yym179 := z.DecBinary()
		_ = yym179
		if false {
		} else {
			z.F.DecSliceStringX(yyv178, false, d)
		}
	}
	yyj175++
	if yyhl175 {
		yyb175 = yyj175 > l
	} else {
		yyb175 = r.CheckBreak()
	}
	if yyb175 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Extra = nil
	} else {
		yyv180 := &x.Extra
		yym181 := z.DecBinary()
		_ = yym181
		if false {
		} else {
			h.decMapstringExtraValue((*map[string]ExtraValue)(yyv180), d)
		}
	}
	for {
		yyj175++
		if yyhl175 {
			yyb175 = yyj175 > l
		} else {
			yyb175 = r.CheckBreak()
		}
		if yyb175 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj175-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ExtraValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym182 := z.EncBinary()
		_ = yym182
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			h.encExtraValue((ExtraValue)(x), e)
		}
	}
}

func (x *ExtraValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym183 := z.DecBinary()
	_ = yym183
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		h.decExtraValue((*ExtraValue)(x), d)
	}
}

func (x codecSelfer1234) encSlicev1_OwnerReference(v []pkg1_v1.OwnerReference, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv184 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy185 := &yyv184
		yym186 := z.EncBinary()
		_ = yym186
		if false {
		} else if z.HasExtensions() && z.EncExt(yy185) {
		} else {
			z.EncFallback(yy185)
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicev1_OwnerReference(v *[]pkg1_v1.OwnerReference, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv187 := *v
	yyh187, yyl187 := z.DecSliceHelperStart()
	var yyc187 bool
	if yyl187 == 0 {
		if yyv187 == nil {
			yyv187 = []pkg1_v1.OwnerReference{}
			yyc187 = true
		} else if len(yyv187) != 0 {
			yyv187 = yyv187[:0]
			yyc187 = true
		}
	} else if yyl187 > 0 {
		var yyrr187, yyrl187 int
		var yyrt187 bool
		if yyl187 > cap(yyv187) {

			yyrg187 := len(yyv187) > 0
			yyv2187 := yyv187
			yyrl187, yyrt187 = z.DecInferLen(yyl187, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt187 {
				if yyrl187 <= cap(yyv187) {
					yyv187 = yyv187[:yyrl187]
				} else {
					yyv187 = make([]pkg1_v1.OwnerReference, yyrl187)
				}
			} else {
				yyv187 = make([]pkg1_v1.OwnerReference, yyrl187)
			}
			yyc187 = true
			yyrr187 = len(yyv187)
			if yyrg187 {
				copy(yyv187, yyv2187)
			}
		} else if yyl187 != len(yyv187) {
			yyv187 = yyv187[:yyl187]
			yyc187 = true
		}
		yyj187 := 0
		for ; yyj187 < yyrr187; yyj187++ {
			yyh187.ElemContainerState(yyj187)
			if r.TryDecodeAsNil() {
				yyv187[yyj187] = pkg1_v1.OwnerReference{}
			} else {
				yyv188 := &yyv187[yyj187]
				yym189 := z.DecBinary()
				_ = yym189
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv188) {
				} else {
					z.DecFallback(yyv188, false)
				}
			}

		}
		if yyrt187 {
			for ; yyj187 < yyl187; yyj187++ {
				yyv187 = append(yyv187, pkg1_v1.OwnerReference{})
				yyh187.ElemContainerState(yyj187)
				if r.TryDecodeAsNil() {
					yyv187[yyj187] = pkg1_v1.OwnerReference{}
				} else {
					yyv190 := &yyv187[yyj187]
					yym191 := z.DecBinary()
					_ = yym191
					if false {
					} else if z.HasExtensions() && z.DecExt(yyv190) {
					} else {
						z.DecFallback(yyv190, false)
					}
				}

			}
		}

	} else {
		yyj187 := 0
		for ; !r.CheckBreak(); yyj187++ {

			if yyj187 >= len(yyv187) {
				yyv187 = append(yyv187, pkg1_v1.OwnerReference{}) // var yyz187 pkg1_v1.OwnerReference
				yyc187 = true
			}
			yyh187.ElemContainerState(yyj187)
			if yyj187 < len(yyv187) {
				if r.TryDecodeAsNil() {
					yyv187[yyj187] = pkg1_v1.OwnerReference{}
				} else {
					yyv192 := &yyv187[yyj187]
					yym193 := z.DecBinary()
					_ = yym193
					if false {
					} else if z.HasExtensions() && z.DecExt(yyv192) {
					} else {
						z.DecFallback(yyv192, false)
					}
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj187 < len(yyv187) {
			yyv187 = yyv187[:yyj187]
			yyc187 = true
		} else if yyj187 == 0 && yyv187 == nil {
			yyv187 = []pkg1_v1.OwnerReference{}
			yyc187 = true
		}
	}
	yyh187.End()
	if yyc187 {
		*v = yyv187
	}
}

func (x codecSelfer1234) encMapstringExtraValue(v map[string]ExtraValue, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk194, yyv194 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym195 := z.EncBinary()
		_ = yym195
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk194))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		if yyv194 == nil {
			r.EncodeNil()
		} else {
			yyv194.CodecEncodeSelf(e)
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decMapstringExtraValue(v *map[string]ExtraValue, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv196 := *v
	yyl196 := r.ReadMapStart()
	yybh196 := z.DecBasicHandle()
	if yyv196 == nil {
		yyrl196, _ := z.DecInferLen(yyl196, yybh196.MaxInitLen, 40)
		yyv196 = make(map[string]ExtraValue, yyrl196)
		*v = yyv196
	}
	var yymk196 string
	var yymv196 ExtraValue
	var yymg196 bool
	if yybh196.MapValueReset {
		yymg196 = true
	}
	if yyl196 > 0 {
		for yyj196 := 0; yyj196 < yyl196; yyj196++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk196 = ""
			} else {
				yymk196 = string(r.DecodeString())
			}

			if yymg196 {
				yymv196 = yyv196[yymk196]
			} else {
				yymv196 = nil
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv196 = nil
			} else {
				yyv198 := &yymv196
				yyv198.CodecDecodeSelf(d)
			}

			if yyv196 != nil {
				yyv196[yymk196] = yymv196
			}
		}
	} else if yyl196 < 0 {
		for yyj196 := 0; !r.CheckBreak(); yyj196++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk196 = ""
			} else {
				yymk196 = string(r.DecodeString())
			}

			if yymg196 {
				yymv196 = yyv196[yymk196]
			} else {
				yymv196 = nil
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv196 = nil
			} else {
				yyv200 := &yymv196
				yyv200.CodecDecodeSelf(d)
			}

			if yyv196 != nil {
				yyv196[yymk196] = yymv196
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) encExtraValue(v ExtraValue, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv201 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym202 := z.EncBinary()
		_ = yym202
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv201))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decExtraValue(v *ExtraValue, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv203 := *v
	yyh203, yyl203 := z.DecSliceHelperStart()
	var yyc203 bool
	if yyl203 == 0 {
		if yyv203 == nil {
			yyv203 = []string{}
			yyc203 = true
		} else if len(yyv203) != 0 {
			yyv203 = yyv203[:0]
			yyc203 = true
		}
	} else if yyl203 > 0 {
		var yyrr203, yyrl203 int
		var yyrt203 bool
		if yyl203 > cap(yyv203) {

			yyrl203, yyrt203 = z.DecInferLen(yyl203, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt203 {
				if yyrl203 <= cap(yyv203) {
					yyv203 = yyv203[:yyrl203]
				} else {
					yyv203 = make([]string, yyrl203)
				}
			} else {
				yyv203 = make([]string, yyrl203)
			}
			yyc203 = true
			yyrr203 = len(yyv203)
		} else if yyl203 != len(yyv203) {
			yyv203 = yyv203[:yyl203]
			yyc203 = true
		}
		yyj203 := 0
		for ; yyj203 < yyrr203; yyj203++ {
			yyh203.ElemContainerState(yyj203)
			if r.TryDecodeAsNil() {
				yyv203[yyj203] = ""
			} else {
				yyv203[yyj203] = string(r.DecodeString())
			}

		}
		if yyrt203 {
			for ; yyj203 < yyl203; yyj203++ {
				yyv203 = append(yyv203, "")
				yyh203.ElemContainerState(yyj203)
				if r.TryDecodeAsNil() {
					yyv203[yyj203] = ""
				} else {
					yyv203[yyj203] = string(r.DecodeString())
				}

			}
		}

	} else {
		yyj203 := 0
		for ; !r.CheckBreak(); yyj203++ {

			if yyj203 >= len(yyv203) {
				yyv203 = append(yyv203, "") // var yyz203 string
				yyc203 = true
			}
			yyh203.ElemContainerState(yyj203)
			if yyj203 < len(yyv203) {
				if r.TryDecodeAsNil() {
					yyv203[yyj203] = ""
				} else {
					yyv203[yyj203] = string(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj203 < len(yyv203) {
			yyv203 = yyv203[:yyj203]
			yyc203 = true
		} else if yyj203 == 0 && yyv203 == nil {
			yyv203 = []string{}
			yyc203 = true
		}
	}
	yyh203.End()
	if yyc203 {
		*v = yyv203
	}
}
