# Change log
<!-- Template:
## [version] — YYYY-MM-DD

### Added
### Changed
### Deprecated
### Removed
### Fixed
### Security
-->

## [Unreleased]

## [v0.15.0] — 2017-07-05
This release adds additional `Time` units; `Frequency`, `Force`, and `Volume` quantities; and
numerous floating point methods such as `min`, `max`, and `powi`.

### Added
 * [#4](https://github.com/iliekturtles/uom/issues/4) Additional `Time` units added.
 * Add missing `giga` units. e.g. `gigameter`.
 * [#11](https://github.com/iliekturtles/uom/issues/11) Add floating point classification methods
   `classify`, `is_finite`, `is_infinte`, `is_nan`,  and `is_normal` for `Quantity`.
 * [#11](https://github.com/iliekturtles/uom/issues/11) Add floating point fractional methods
   `floor`, `ceil`, `round`, `trunc`, and `fract` for `Quantity`.
 * [#11](https://github.com/iliekturtles/uom/issues/11) Add floating point comparison methods
   `max` and `min` for `Quantity`.
 * [#11](https://github.com/iliekturtles/uom/issues/11) Add floating point `mul_add` method for
   `Quantity`.
 * [#11](https://github.com/iliekturtles/uom/issues/11) Add floating point `powi` method for
   `Quantity`.
 * [#7](https://github.com/iliekturtles/uom/issues/7) `Volume` quantity added. Additional units
   still need to be added.
 * [#8](https://github.com/iliekturtles/uom/issues/8) `Force` quantity added. Additional units
   still need to be added.
 * [#30](https://github.com/iliekturtles/uom/issues/30) `Frequency` quantity added. Additional units
   still need to be added.

## [v0.14.0] — 2017-05-30

### Added
 * [Breaking] A new feature, `std`, is now available and is enabled by default. `uom` can still be
   compiled with `no_std` by using `--no-default-features` when compiling the crate or
   `default-features = false` in the `dependencies` section of `Cargo.toml`
 * [#11](https://github.com/iliekturtles/uom/issues/11) `cbrt`, `recip`, and `sqrt` are implemented
   for `Quantity`.

### Changed
 * [#28](https://github.com/iliekturtles/uom/issues/28) `Quantity` fields made public in order to
   allow library users to create `const` values and instances of non-named quantities. e.g.
   `const TIME_STEP: Time = Quantity { dimension: PhantomData, units: PhantomData, value: 0.1 };`
   This functionality will be deprecated and subsequently removed once the
   [`const fn`](https://github.com/rust-lang/rust/issues/24111) feature is stabilized.
 * Tests now run for all enabled underlying storage types (`f32`, `f64`).

### Fixed
 * Fixed incorrect conversion factor when multiplying or dividing `Quantity`s with different base
   units.

## [v0.13.0] — 2017-04-20
This release adds numerous tests both for code generated by the `quantity!`, `system!`, and
`$quantities!` macros as well as derived quantities. Fixes for issues found during testing noted
below. Quantity implementations for `Area` and `Acceleration` also added.

### Added
 * [#6](https://github.com/iliekturtles/uom/issues/6) `Area` quantity added. Additional units still
   need to be added.
 * [#9](https://github.com/iliekturtles/uom/issues/9) `Acceleration` quantity added. Additional
   units still need to be added.

### Changed
 * [Breaking] Remove the unused `_unit` parameter from `Quantity::new` and so summon the turbofish.
   e.g. `Length::new(1.0, meter)` becomes `Length::new::<meter>(1.0)`.
 * [#22](https://github.com/iliekturtles/uom/issues/22) Change `impl Debug` for `Quantity` to use
   precision information. Previously the implementation checked the `alternate` flag which has no
   affect on printing raw floats.
 * [#27](https://github.com/iliekturtles/uom/issues/27) Change superscripts in documentation to the
   format supported by `pulldown` in anticipation of upcomming `rustdoc` changes.

### Fixed
 * [#22](https://github.com/iliekturtles/uom/issues/6) Fix `impl Sub` for `Quantity` to be
   implemented in terms of `-` instead of `+`.

## [v0.12.0] — 2017-04-01
Continuous integration was setup to ensure that `uom` builds on stable, beta, nightly, and 1.15.0
(the minimum `rustc` version). Quantity descriptions, unit abbreviations, and unit descriptions
added. Additional length units
[added](https://github.com/iliekturtles/uom/commit/d1b969b810a4b3298d4cf93d0a795d922261735b) to
demonstrate the simplicity of the process.

### Added
 * [#1](https://github.com/iliekturtles/uom/issues/1) Additional `Length` units added.
 * [Breaking] The `quantity!` macro accepts comments on units. To resolve macro parsing ambiguities
   each unit must be prefixed with an `@`.
 * [#19](https://github.com/iliekturtles/uom/issues/19) [Breaking] The `quantity!` macro includes
   the quantity description. The description can be accessed using the `description()` method in
   quantity submodules.
 * [#19](https://github.com/iliekturtles/uom/issues/19) [Breaking] The `quantity!` macro includes
   unit abbreviations as well as singular and plural descriptions. These values can be accessed from
   new `abbreviation()`, `singular()`, and `plural()` methods on the `Unit` trait. The original
   `Unit<V>` trait has been renamed `Conversion<V>`.
 * [#12](https://github.com/iliekturtles/uom/issues/12) `Debug` manually implemented for
   `Quantity<D, U, V>` to show the underlying value and associated units.
 * Test and compile-fail test modules setup. compile-fail tests for mismatched quantities and units
   added.

## v0.11.0 — 2017-02-26
Proof-of-concept functionality for type-safe zero-cost dimensional analysis. `uom` [0.11.0] allows
for the creation of custom systems or the use of the pre-built SI. Basic mathematical operations
are implemented and a minimal set of quantities (length, mass, time...) and units (meter, kilometer,
foot, mile, ...) are included.

[Unreleased]: https://github.com/iliekturtles/uom/compare/v0.15.0...master
[v0.15.0]: https://github.com/iliekturtles/uom/compare/v0.14.0...v0.15.0
[v0.14.0]: https://github.com/iliekturtles/uom/compare/v0.13.0...v0.14.0
[v0.13.0]: https://github.com/iliekturtles/uom/compare/v0.12.0...v0.13.0
[v0.12.0]: https://github.com/iliekturtles/uom/compare/v0.11.0...v0.12.0
