/* Copyright (c) 2014, Intel Corporation.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

#ifndef OPENSSL_HEADER_EC_ECP_NISTZ384_H
#define OPENSSL_HEADER_EC_ECP_NISTZ384_H

#include "../../limbs/limbs.h"

#define P384_LIMBS (384u / LIMB_BITS)

typedef struct {
  Limb X[P384_LIMBS];
  Limb Y[P384_LIMBS];
  Limb Z[P384_LIMBS];
} P384_POINT;

typedef struct {
  Limb X[P384_LIMBS];
  Limb Y[P384_LIMBS];
} P384_POINT_AFFINE;


// Prototypes to avoid -Wmissing-prototypes warnings.
void GFp_nistz384_point_double(P384_POINT *r, const P384_POINT *a);
void GFp_nistz384_point_add(P384_POINT *r, const P384_POINT *a,
                            const P384_POINT *b);

#endif // OPENSSL_HEADER_EC_ECP_NISTZ384_H
