---
page_ref: "@ARK_PROJECT__VARIANT@/termux/termux-exec-package/releases/2/v2.0.0.html"
---

# termux-exec-package v2.0.0 - 2025-03-21

## Changelog

**Commit history:** [`v1.0...v2.0.0`](https://github.com/termux/termux-exec-package/compare/v1.0...v2.0.0)

&nbsp;



### Added

- The `libtermux-exec_nos_c_tre` c library has been added to handle all the `LD_PRELOAD` intercepts implementation, and other functionality required for `termux-exec` like the environment/config. This can be used statically or dynamically for `termux-exec` executables/libraries and also for other packages. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

- The `libtermux-exec-direct-ld-preload.so` `$LD_PRELOAD` library variant has been added. It statically depends on `libtermux-exec_nos_c_tre` library and primarily includes `app/termux-exec-direct-ld-preload/src/termux/api/termux_exec/ld_preload/direct/TermuxExecDirectLDPreloadEntryPoint.c`, which now exclusively only defines the functions intercepted by `libtermux-exec-direct-ld-preload.so` and directs them to their intercepts in respective source files of `libtermux-exec_nos_c_tre` library. The `libtermux-exec-direct-ld-preload.so` is used as primary `$LD_PRELOAD` library variant by copying it to `$TERMUX__PREFIX/usr/lib/libtermux-exec-ld-preload.so` and this path is exported in `$LD_PRELOAD` by the `login` script. For backward compatibility, `libtermux-exec.so` is also created as a copy of `libtermux-exec-ld-preload.so`  so that older clients do not break which have exported path to `libtermux-exec.so` in `$LD_PRELOAD`. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

- The intercepts implementation of `execve` done by `src/termux-exec.c` has been moved to `lib/termux-exec_nos_c_tre/src/termux/api/termux_exec/ld_preload/direct/exec/ExecIntercept.c`. The `src/exec-variants.c` has been moved to `lib/termux-exec_nos_c_tre/src/termux/api/termux_exec/ld_preload/direct/exec/ExecVariantsIntercept.c` which handles intercepts of the entire `exec()` family of functions except `execve()`. The intercept implementations are now called from `app/termux-exec-direct-ld-preload/src/termux/api/termux_exec/ld_preload/direct/TermuxExecDirectLDPreloadEntryPoint.c`. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

&nbsp;

- Intercept the entire `exec()` family of functions, which is required for Android `14`. Closes termux/termux-packages#18537, termux/termux-app#3758. ([`5ea25ee3`](https://github.com/termux/termux-exec-package/commit/5ea25ee3), [`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Added the `string` environment variable `TERMUX_EXEC__EXECVE_CALL__INTERCEPT` for whether `execve` would be intercepted for shebang fix or `system_linker_exec`. If set to `enable`, then `execve()` intercept will be enabled. If set to `disable`, then `execve()` intercept will be disabled. The default value is `enable`. The other wrapper functions in the `exec()` family of functions declared in `unistd.h` are always intercepted to solve some other issues on older Android versions, check [`libc/bionic/exec.cpp`](https://cs.android.com/android/platform/superproject/+/android-14.0.0_r1:bionic/libc/bionic/exec.cpp) git history. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

&nbsp;

- Add support to execute ELF files by passing them to `/system/bin/linker*` to bypass android app data file exec restriction if using `targetSdkVersion` `>= 28` on Android `>= 10`. Check [technical](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/technical/index.md) and [system linker exec](https://github.com/agnostic-apollo/Android-Docs/blob/master/site/pages/en/projects/docs/apps/processes/app-data-file-execute-restrictions.md#system-linker-exec) docs for info on how `system_linker_exec` works and why it is needed. ([`db738a11`](https://github.com/termux/termux-exec-package/commit/db738a11))
- The `libtermux-exec-linker-ld-preload.so` `$LD_PRELOAD` library variant has been added and is meant to intercept additional functions to solve other issues specific to `system_linker_exec` execution. The `libtermux-exec-direct-ld-preload.so` variant needs to support `system_linker_exec` as well as during package updates, before the `linker` variant is set as primary variant, the `direct` variant will get used for certain commands as it gets installed as the primary variant by default, and commands will fail if `system_linker_exec` is required to bypass execution restrictions. The primary `$LD_PRELOAD` library variant to be used is set by copying it to `$TERMUX__PREFIX/usr/lib/libtermux-exec-ld-preload.so` and this path is exported in `$LD_PRELOAD` by `login` script. This is done by the `postinst` script run during package installation, which runs `termux-exec-ld-preload-lib setup` to set the correct variant as per the execution type required for the Termux environment of the host device by running `termux-exec-system-linker-exec is-enabled` to check if `system_linker_exec` is to be enabled. ([`db738a11`](https://github.com/termux/termux-exec-package/commit/db738a11))
- Since when executing with linker, the `/proc/self/exe` will be set to linker path, export `TERMUX_EXEC__PROC_SELF_EXE` environment variable with actual path to executable being executed so that packages can be patched to read it instead. Additional hocking will need to be done for programs that read `/proc/<pid>/exe`. ([`5ea25ee3`](https://github.com/termux/termux-exec-package/commit/5ea25ee3), [`db738a11`](https://github.com/termux/termux-exec-package/commit/db738a11))
- Added the `string` `TERMUX_EXEC__SYSTEM_LINKER_EXEC__MODE` environment variable for whether to use `system_linker_exec` if `TERMUX_EXEC__EXECVE_CALL__INTERCEPT` is enabled. If set to `disable`, `system_linker_exec` will be disabled. If set to `enable`, then `system_linker_exec` will be enabled but only if required. If set to `force`, then `system_linker_exec` will be force enabled even if not required and is supported. The default value is `enable`. Check `isSystemLinkerExecEnabled()` function ([1](https://github.com/termux/termux-exec-package/blob/v2.0.0/lib/termux-exec_nos_c_tre/include/termux/termux_exec__nos__c/v1/termux/api/termux_exec/ld_preload/TermuxExecLDPreload.h#L20), [2](https://github.com/termux/termux-exec-package/blob/v2.0.0/lib/termux-exec_nos_c_tre/src/termux/api/termux_exec/ld_preload/TermuxExecLDPreload.c#L31)) and `shouldEnableSystemLinkerExecForFile()` function ([1](https://github.com/termux/termux-exec-package/blob/v2.0.0/lib/termux-exec_nos_c_tre/include/termux/termux_exec__nos__c/v1/termux/api/termux_exec/ld_preload/TermuxExecLDPreload.h#L55), [2](https://github.com/termux/termux-exec-package/blob/v2.0.0/lib/termux-exec_nos_c_tre/src/termux/api/termux_exec/ld_preload/TermuxExecLDPreload.c#L2137)) in `TermuxExecLDPreload.h` and implemented by `TermuxExecLDPreload.c` for more info and how its handled. The `system_linker_exec` will now engage for executable or interpreter paths that are under `TERMUX_APP__DATA_DIR` or `TERMUX_APP__LEGACY_DATA_DIR` instead of `TERMUX__ROOTFS` (`TERMUX_BASE_DIR`). ([`db738a11`](https://github.com/termux/termux-exec-package/commit/db738a11))

&nbsp;

- Added logger framework with multiple log levels with log entries for all the important variable states to track logic. The singular `TERMUX_EXEC_DEBUG` environment variable has been removed. The `int` `TERMUX_EXEC__LOG_LEVEL` environment variable controls the log level based on `(OFF=0, NORMAL=1, DEBUG=2, VERBOSE=3, VVERBOSE=4 and VVVERBOSE=5)`. The default value is `1`. Normally, `termux-exec` does not log anything at default log level `1` (`NORMAL`) for intercepts even and will require setting log level to `>= 2` (`DEBUG`) to see log messages. To enable `VVERBOSE` logging for a command, you can run something like `TERMUX_EXEC__LOG_LEVEL=4 id -u`. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Added `TERMUX_EXEC_PKG__VERSION` `Makefile` parameter that gets logged on intercept for `termux-exec` package version currently installed. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

&nbsp;

- Added testing framework via `app/main/tests/termux-exec-tests.in` and `lib/termux-exec_nos_c_tre/tests/libtermux-exec_nos_c_tre_tests.in` that calls `termux-exec/lib/termux-exec_nos_c_tre/tests/src/libtermux-exec_nos_c_tre_unit-binary-tests.c` to run unit tests, and `lib/termux-exec_nos_c_tre/tests/src/libtermux-exec_nos_c_tre_runtime-binary-tests.c` and `lib/termux-exec_nos_c_tre/tests/scripts/libtermux-exec_nos_c_tre_runtime-script-tests.in` for runtime tests. Old tests files in random places have been removed. The entire `exec()` family of functions is also tested by `lib/termux-exec_nos_c_tre/tests/src/termux/api/termux_exec/ld_preload/direct/exec/ExecIntercept_RuntimeBinaryTests.c`. Docs will be added in a later commit.Tests can be run with `"${TERMUX__PREFIX:-$PREFIX}/libexec/installed-tests/termux-exec/app/main/termux-exec-tests -vv all"`. ([`ad67e020`](https://github.com/termux/termux-exec-package/commit/ad67e020))

&nbsp;

- Add site, docs and old changelog files under `MIT` license. ([`2fe47750`](https://github.com/termux/termux-exec-package/commit/2fe47750), [`21e6e634`](https://github.com/termux/termux-exec-package/commit/21e6e634))

## &nbsp;

&nbsp;



### Changed

- Use `TERMUX__PREFIX` environment variable to generate Termux bin path to replace `/bin` and `/usr/bin` path in shebang of scripts instead of using hardcoded `TERMUX_BASE_DIR` build variable. If environment variable is not set or is invalid as per `TERMUX__ROOTFS_DIR___MAX_LEN`, then we use the default Termux prefix for which package was compiled for as long as its executable and readable to ensure termux-exec was not compiled for a different package. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Increase buffer size for executable file shebang header from `256` to `340` defined by `TERMUX__FILE_HEADER__BUFFER_SIZE` as per termux path limits, check comment in `ExecIntercept.h` file and [Termux File Path Limits](https://github.com/termux/termux-packages/wiki/Termux-file-system-layout#file-path-limits) docs. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Decrease max length of valid `TERMUX__ROOTFS` from `200` to `86` defined by `TERMUX__ROOTFS_DIR___MAX_LEN`, check `TermuxFile.h` file and [Termux File Path Limits](https://github.com/termux/termux-packages/wiki/Termux-file-system-layout#file-path-limits) docs. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Move `termux-exec` Apache 2.0 license file content from `LICENSE` to `licenses/termux__termux-exec__Apache-2.0.md` file and use `debian/copyright` format in `LICENSE` file. ([`7ccbc61e`](https://github.com/termux/termux-exec-package/commit/7ccbc61e))

## &nbsp;

&nbsp;



### Fixed

- Fix relative paths for interpreter path by absolutizing it. Previously, only prefix was being replaced. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Fix `argv[0]` for executing shell scripts where it should be set to the original interpreter set in the file as is instead of the `argv[0]` to `execve()` being intercepted for the executable. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Fix `fexecve()` where executable path would be `/proc/self/fd/<n>` and checking if its under Termux app data directory directory would give wrong results. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Fix checking if executable is under Termux directories. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Fix hardcoded `com.termux` values being used, all constants are replaced during building including the root scope of environment variables that are read and as per `TERMUX_ENV__S_ROOT` defined in `properties.sh` of `termux-pacakges` as `TERMUX_`. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- Abort `execve()` with a debug error if `argv[0]` length is `>= 128` on Android `< 6` instead of letting process fail post `execve()` without an error. ([`e726fba2`](https://github.com/termux/termux-exec-package/commit/e726fba2))
- Fix issues where `errno` may already be set when `execve` is entered, check comment in `init()` function of `TermuxExecProcess.c` where it is set to `0`. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- The `termux-exec-package.json` will now have correct version and be consistent with `build.sh`, and also include tests files, which wasn't being done before. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- The `termux-exec-package.json` previously had hardcoded `aarch64` as architecture, now we find and replace it for the compiler based on which predefined architecture macro is defined. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

## &nbsp;

&nbsp;



### Removed

- Removed the singular `TERMUX_EXEC_OPTOUT` environment variable. Opt outs should be confined to specific intercepts and logics. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))
- The singular `TERMUX_EXEC_DEBUG` environment variable has been removed. ([`1fac1073`](https://github.com/termux/termux-exec-package/commit/1fac1073))

---

&nbsp;





## Notes

- Usage docs are available [here](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/usage/index.md). You can run commands with `TERMUX_EXEC__LOG_LEVEL=4 id -u` after installing package for debugging. To run on normal termux with `targetSdkVersion` `<= 28`, run `TERMUX_EXEC__SYSTEM_LINKER_EXEC__MODE=force TERMUX_EXEC__LOG_LEVEL=4 id -u` instead. **Check [`TERMUX_EXEC__LOG_LEVEL`](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/usage/index.md#termux_exec__log_level), [`TERMUX_EXEC__EXECVE_CALL__INTERCEPT`](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/usage/index.md#termux_exec__execve_call__intercept), [`TERMUX_EXEC__SYSTEM_LINKER_EXEC__MODE`](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/usage/index.md#termux_exec__system_linker_exec__mode) variable docs for more info on how to control behaviour of `termux-exec`.**
- Testing docs are available [here](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/developer/test/index.md). Run tests with `TERMUX_ROOTFS__PACKAGE_MANAGER=apt "${TERMUX__PREFIX:-$PREFIX}/libexec/installed-tests/termux-exec/app/main/termux-exec-tests" -vv all`. Exporting `TERMUX_ROOTFS__PACKAGE_MANAGER` variables is necessary for running tests on older Termux app versions without scoped environment variable changes for package manager tests to run.
- Build docs are available [here](https://github.com/termux/termux-exec-package/blob/master/site/pages/en/projects/docs/developer/build/index.md).

---

&nbsp;
