<!-- This file is machine generated: DO NOT EDIT! -->

# Constants, Sequences, and Random Values <a class="md-anchor" id="AUTOGENERATED-constants--sequences--and-random-values"></a>

Note: Functions taking `Tensor` arguments can also take anything accepted by
[`tf.convert_to_tensor`](../../api_docs/python/framework.md#convert_to_tensor).

<!-- TOC-BEGIN This section is generated by neural network: DO NOT EDIT! -->
## Contents
### [Constants, Sequences, and Random Values](#AUTOGENERATED-constants--sequences--and-random-values)
* [Constant Value Tensors](#AUTOGENERATED-constant-value-tensors)
  * [`tf.zeros(shape, dtype=tf.float32, name=None)`](#zeros)
  * [`tf.zeros_like(tensor, dtype=None, name=None)`](#zeros_like)
  * [`tf.ones(shape, dtype=tf.float32, name=None)`](#ones)
  * [`tf.ones_like(tensor, dtype=None, name=None)`](#ones_like)
  * [`tf.fill(dims, value, name=None)`](#fill)
  * [`tf.constant(value, dtype=None, shape=None, name='Const')`](#constant)
* [Sequences](#AUTOGENERATED-sequences)
  * [`tf.linspace(start, stop, num, name=None)`](#linspace)
  * [`tf.range(start, limit, delta=1, name='range')`](#range)
* [Random Tensors](#AUTOGENERATED-random-tensors)
  * [Examples:](#AUTOGENERATED-examples-)
  * [`tf.random_normal(shape, mean=0.0, stddev=1.0, dtype=tf.float32, seed=None, name=None)`](#random_normal)
  * [`tf.truncated_normal(shape, mean=0.0, stddev=1.0, dtype=tf.float32, seed=None, name=None)`](#truncated_normal)
  * [`tf.random_uniform(shape, minval=0.0, maxval=1.0, dtype=tf.float32, seed=None, name=None)`](#random_uniform)
  * [`tf.random_shuffle(value, seed=None, name=None)`](#random_shuffle)
  * [`tf.set_random_seed(seed)`](#set_random_seed)


<!-- TOC-END This section was generated by neural network, THANKS FOR READING! -->

## Constant Value Tensors <a class="md-anchor" id="AUTOGENERATED-constant-value-tensors"></a>

TensorFlow provides several operations that you can use to generate constants.

- - -

### `tf.zeros(shape, dtype=tf.float32, name=None)` <a class="md-anchor" id="zeros"></a>

Creates a tensor with all elements set to zero.

This operation returns a tensor of type `dtype` with shape `shape` and
all elements set to zero.

For example:

```python
tf.zeros([3, 4], int32) ==> [[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>shape</b>: Either a list of integers, or a 1-D `Tensor` of type `int32`.
*  <b>dtype</b>: The type of an element in the resulting `Tensor`.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A `Tensor` with all elements set to zero.


- - -

### `tf.zeros_like(tensor, dtype=None, name=None)` <a class="md-anchor" id="zeros_like"></a>

Creates a tensor with all elements set to zero.

Given a single tensor (`tensor`), this operation returns a tensor of the
same type and shape as `tensor` with all elements set to zero. Optionally,
you can use `dtype` to specify a new type for the returned tensor.

For example:

```python
# 'tensor' is [[1, 2, 3], [4, 5, 6]]
tf.zeros_like(tensor) ==> [[0, 0, 0], [0, 0, 0]]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>tensor</b>: A `Tensor`.
*  <b>dtype</b>: A type for the returned `Tensor`. Must be `float32`, `float64`,
  `int8`, `int16`, `int32`, `int64`, `uint8`, or `complex64`.

*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A `Tensor` with all elements set to zero.



- - -

### `tf.ones(shape, dtype=tf.float32, name=None)` <a class="md-anchor" id="ones"></a>

Creates a tensor with all elements set to 1.

This operation returns a tensor of type `dtype` with shape `shape` and all
elements set to 1.

For example:

```python
tf.ones([2, 3], int32) ==> [[1, 1, 1], [1, 1, 1]]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>shape</b>: Either a list of integers, or a 1-D `Tensor` of type `int32`.
*  <b>dtype</b>: The type of an element in the resulting `Tensor`.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A `Tensor` with all elements set to 1.


- - -

### `tf.ones_like(tensor, dtype=None, name=None)` <a class="md-anchor" id="ones_like"></a>

Creates a tensor with all elements set to 1.

Given a single tensor (`tensor`), this operation returns a tensor of the same
type and shape as `tensor` with all elements set to 1. Optionally, you can
specify a new type (`dtype`) for the returned tensor.

For example:

```python
# 'tensor' is [[1, 2, 3], [4, 5, 6]]
tf.ones_like(tensor) ==> [[1, 1, 1], [1, 1, 1]]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>tensor</b>: A `Tensor`.
*  <b>dtype</b>: A type for the returned `Tensor`. Must be `float32`, `float64`,
  `int8`, `int16`, `int32`, `int64`, `uint8`, or `complex64`.

*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A `Tensor` with all elements set to 1.



- - -

### `tf.fill(dims, value, name=None)` <a class="md-anchor" id="fill"></a>

Creates a tensor filled with a scalar value.

This operation creates a tensor of shape `dims` and fills it with `value`.

For example:

```prettyprint
# output tensor shape needs to be [2, 3]
# so 'dims' is [2, 3]
fill(dims, 9) ==> [[9, 9, 9]
                   [9, 9, 9]]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>dims</b>: A `Tensor` of type `int32`.
    1-D. Represents the shape of the output tensor.
*  <b>value</b>: A `Tensor`. 0-D (scalar). Value to fill the returned tensor.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A `Tensor`. Has the same type as `value`.



- - -

### `tf.constant(value, dtype=None, shape=None, name='Const')` <a class="md-anchor" id="constant"></a>

Creates a constant tensor.

 The resulting tensor is populated with values of type `dtype`, as
 specified by arguments `value` and (optionally) `shape` (see examples
 below).

 The argument `value` can be a constant value, or a list of values of type
 `dtype`. If `value` is a list, then the length of the list must be less
 than or equal to the number of elements implied by the `shape` argument (if
 specified). In the case where the list length is less than the number of
 elements specified by `shape`, the last element in the list will be used
 to fill the remaining entries.

 The argument `shape` is optional. If present, it specifies the dimensions
 of the resulting tensor. If not present, then the tensor is a scalar (0-D)
 if `value` is a scalar, or 1-D otherwise.

 If the argument `dtype` is not specified, then the type is inferred from
 the type of `value`.

 For example:

 ```python
 # Constant 1-D Tensor populated with value list.
 tensor = tf.constant([1, 2, 3, 4, 5, 6, 7]) => [1 2 3 4 5 6 7]

 # Constant 2-D tensor populated with scalar value -1.
 tensor = tf.constant(-1.0, shape=[2, 3]) => [[-1. -1. -1.]
                                              [-1. -1. -1.]]
 ```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>value</b>: A constant value (or list) of output type `dtype`.


*  <b>dtype</b>: The type of the elements of the resulting tensor.


*  <b>shape</b>: Optional dimensions of resulting tensor.


*  <b>name</b>: Optional name for the tensor.

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A Constant Tensor.



## Sequences <a class="md-anchor" id="AUTOGENERATED-sequences"></a>

- - -

### `tf.linspace(start, stop, num, name=None)` <a class="md-anchor" id="linspace"></a>

Generates values in an interval.

A sequence of `num` evenly-spaced values are generated beginning at `start`.
If `num > 1`, the values in the sequence increase by `stop - start / num - 1`,
so that the last one is exactly `stop`.

For example:

```
tf.linspace(10.0, 12.0, 3, name="linspace") => [ 10.0  11.0  12.0]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>start</b>: A `Tensor`. Must be one of the following types: `float32`, `float64`.
    First entry in the range.
*  <b>stop</b>: A `Tensor`. Must have the same type as `start`.
    Last entry in the range.
*  <b>num</b>: A `Tensor` of type `int32`. Number of values to generate.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A `Tensor`. Has the same type as `start`. 1-D. The generated values.



- - -

### `tf.range(start, limit, delta=1, name='range')` <a class="md-anchor" id="range"></a>

Creates a sequence of integers.

This operation creates a sequence of integers that begins at `start` and
extends by increments of `delta` up to but not including `limit`.

For example:

```
# 'start' is 3
# 'limit' is 18
# 'delta' is 3
tf.range(start, limit, delta) ==> [3, 6, 9, 12, 15]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>start</b>: A 0-D (scalar) of type `int32`. First entry in sequence.
*  <b>limit</b>: A 0-D (scalar) of type `int32`. Upper limit of sequence,
    exclusive.
*  <b>delta</b>: A 0-D `Tensor` (scalar) of type `int32`. Optional. Default is 1.
    Number that increments `start`.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  An 1-D `int32` `Tensor`.



## Random Tensors <a class="md-anchor" id="AUTOGENERATED-random-tensors"></a>

TensorFlow has several ops that create random tensors with different
distributions.  The random ops are stateful, and create new random values each
time they are evaluated.

The `seed` keyword argument in these functions acts in conjunction with
the graph-level random seed. Changing either the graph-level seed using
[`set_random_seed`](../../api_docs/python/constant_op.md#set_random_seed) or the
op-level seed will change the underlying seed of these operations. Setting
neither graph-level nor op-level seed, results in a random seed for all
operations.
See [`set_random_seed`](../../api_docs/python/constant_op.md#set_random_seed)
for details on the interaction between operation-level and graph-level random
seeds.

### Examples: <a class="md-anchor" id="AUTOGENERATED-examples-"></a>

```python
# Create a tensor of shape [2, 3] consisting of random normal values, with mean
# -1 and standard deviation 4.
norm = tf.random_normal([2, 3], mean=-1, stddev=4)

# Shuffle the first dimension of a tensor
c = tf.constant([[1, 2], [3, 4], [5, 6]])
shuff = tf.random_shuffle(c)

# Each time we run these ops, different results are generated
sess = tf.Session()
print sess.run(norm)
print sess.run(norm)

# Set an op-level seed to generate repeatable sequences across sessions.
c = tf.constant([[1, 2], [3, 4], [5, 6]])
sess = tf.Session()
norm = tf.random_normal(c, seed=1234)
print sess.run(norm)
print sess.run(norm)
```

Another common use of random values is the intialization of variables. Also see
the [Variables How To](../../how_tos/variables/index.md).

```python
# Use random uniform values in [0, 1) as the initializer for a variable of shape
# [2, 3]. The default type is float32.
var = tf.Variable(tf.random_uniform([2, 3]), name="var")
init = tf.initialize_all_variables()

sess = tf.Session()
sess.run(init)
print sess.run(var)
```

- - -

### `tf.random_normal(shape, mean=0.0, stddev=1.0, dtype=tf.float32, seed=None, name=None)` <a class="md-anchor" id="random_normal"></a>

Outputs random values from a normal distribution.

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>shape</b>: A 1-D integer Tensor or Python array. The shape of the output tensor.
*  <b>mean</b>: A 0-D Tensor or Python value of type `dtype`. The mean of the normal
    distribution.
*  <b>stddev</b>: A 0-D Tensor or Python value of type `dtype`. The standard deviation
    of the normal distribution.
*  <b>dtype</b>: The type of the output.
*  <b>seed</b>: A Python integer. Used to create a random seed for the distribution.
    See
    [`set_random_seed`](../../api_docs/python/constant_op.md#set_random_seed)
    for behavior.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A tensor of the specified shape filled with random normal values.


- - -

### `tf.truncated_normal(shape, mean=0.0, stddev=1.0, dtype=tf.float32, seed=None, name=None)` <a class="md-anchor" id="truncated_normal"></a>

Outputs random values from a truncated normal distribution.

The generated values follow a normal distribution with specified mean and
standard deviation, except that values whose magnitude is more than 2 standard
deviations from the mean are dropped and re-picked.

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>shape</b>: A 1-D integer Tensor or Python array. The shape of the output tensor.
*  <b>mean</b>: A 0-D Tensor or Python value of type `dtype`. The mean of the
    truncated normal distribution.
*  <b>stddev</b>: A 0-D Tensor or Python value of type `dtype`. The standard deviation
    of the truncated normal distribution.
*  <b>dtype</b>: The type of the output.
*  <b>seed</b>: A Python integer. Used to create a random seed for the distribution.
    See
    [`set_random_seed`](../../api_docs/python/constant_op.md#set_random_seed)
    for behavior.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A tensor of the specified shape filled with random truncated normal values.


- - -

### `tf.random_uniform(shape, minval=0.0, maxval=1.0, dtype=tf.float32, seed=None, name=None)` <a class="md-anchor" id="random_uniform"></a>

Outputs random values from a uniform distribution.

The generated values follow a uniform distribution in the range
`[minval, maxval)`. The lower bound `minval` is included in the range, while
the upper bound `maxval` is excluded.

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>shape</b>: A 1-D integer Tensor or Python array. The shape of the output tensor.
*  <b>minval</b>: A 0-D Tensor or Python value of type `dtype`. The lower bound on the
    range of random values to generate.
*  <b>maxval</b>: A 0-D Tensor or Python value of type `dtype`. The upper bound on
    the range of random values to generate.
*  <b>dtype</b>: The type of the output.
*  <b>seed</b>: A Python integer. Used to create a random seed for the distribution.
    See
    [`set_random_seed`](../../api_docs/python/constant_op.md#set_random_seed)
    for behavior.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A tensor of the specified shape filled with random uniform values.


- - -

### `tf.random_shuffle(value, seed=None, name=None)` <a class="md-anchor" id="random_shuffle"></a>

Randomly shuffles a tensor along its first dimension.

The tensor is shuffled along dimension 0, such that each `value[j]` is mapped
to one and only one `output[i]`. For example, a mapping that might occur for a
3x2 tensor is:

```python
[[1, 2],       [[5, 6],
 [3, 4],  ==>   [1, 2],
 [5, 6]]        [3, 4]]
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>value</b>: A Tensor to be shuffled.
*  <b>seed</b>: A Python integer. Used to create a random seed for the distribution.
    See
    [`set_random_seed`](../../api_docs/python/constant_op.md#set_random_seed)
    for behavior.
*  <b>name</b>: A name for the operation (optional).

##### Returns: <a class="md-anchor" id="AUTOGENERATED-returns-"></a>

  A tensor of same shape and type as `value`, shuffled along its first
  dimension.


- - -

### `tf.set_random_seed(seed)` <a class="md-anchor" id="set_random_seed"></a>

Sets the graph-level random seed.

Operations that rely on a random seed actually derive it from two seeds:
the graph-level and operation-level seeds. This sets the graph-level seed.

Its interactions with operation-level seeds is as follows:

  1. If neither the graph-level nor the operation seed is set:
    A random seed is used for this op.
  2. If the graph-level seed is set, but the operation seed is not:
    The system deterministically picks an operation seed in conjunction
    with the graph-level seed so that it gets a unique random sequence.
  3. If the graph-level seed is not set, but the operation seed is set:
    A default graph-level seed and the specified operation seed are used to
    determine the random sequence.
  4. If both the graph-level and the operation seed are set:
    Both seeds are used in conjunction to determine the random sequence.

To illustrate the user-visible effects, consider these examples:

To generate different sequences across sessions, set neither
graph-level nor op-level seeds:

```python
a = tf.random_uniform([1])
b = tf.random_normal([1])

print "Session 1"
with tf.Session() as sess1:
  print sess1.run(a)  # generates 'A1'
  print sess1.run(a)  # generates 'A2'
  print sess1.run(b)  # generates 'B1'
  print sess1.run(b)  # generates 'B2'

print "Session 2"
with tf.Session() as sess2:
  print sess2.run(a)  # generates 'A3'
  print sess2.run(a)  # generates 'A4'
  print sess2.run(b)  # generates 'B3'
  print sess2.run(b)  # generates 'B4'
```

To generate the same repeatable sequence for an op across sessions, set the
seed for the op:

```python
a = tf.random_uniform([1], seed=1)
b = tf.random_normal([1])

# Repeatedly running this block with the same graph will generate the same
# sequence of values for 'a', but different sequences of values for 'b'.
print "Session 1"
with tf.Session() as sess1:
  print sess1.run(a)  # generates 'A1'
  print sess1.run(a)  # generates 'A2'
  print sess1.run(b)  # generates 'B1'
  print sess1.run(b)  # generates 'B2'

print "Session 2"
with tf.Session() as sess2:
  print sess2.run(a)  # generates 'A1'
  print sess2.run(a)  # generates 'A2'
  print sess2.run(b)  # generates 'B3'
  print sess2.run(b)  # generates 'B4'
```

To make the random sequences generated by all ops be repeatable across
sessions, set a graph-level seed:

```python
tf.set_random_seed(1234)
a = tf.random_uniform([1])
b = tf.random_normal([1])

# Repeatedly running this block with the same graph will generate different
# sequences of 'a' and 'b'.
print "Session 1"
with tf.Session() as sess1:
  print sess1.run(a)  # generates 'A1'
  print sess1.run(a)  # generates 'A2'
  print sess1.run(b)  # generates 'B1'
  print sess1.run(b)  # generates 'B2'

print "Session 2"
with tf.Session() as sess2:
  print sess2.run(a)  # generates 'A1'
  print sess2.run(a)  # generates 'A2'
  print sess2.run(b)  # generates 'B1'
  print sess2.run(b)  # generates 'B2'
```

##### Args: <a class="md-anchor" id="AUTOGENERATED-args-"></a>


*  <b>seed</b>: integer.


