# Class `tensorflow::TensorShape` <a class="md-anchor" id="AUTOGENERATED-class--tensorflow--tensorshape-"></a>

Manages the dimensions of a Tensor and their sizes.



##Member Summary <a class="md-anchor" id="AUTOGENERATED-member-summary"></a>

* [`tensorflow::TensorShape::TensorShape(gtl::ArraySlice< int64 > dim_sizes)`](#tensorflow_TensorShape_TensorShape)
  * Construct a TensorShape from the provided sizes.. REQUIRES: dim_sizes[i] >= 0.
* [`tensorflow::TensorShape::TensorShape(std::initializer_list< int64 > dim_sizes)`](#tensorflow_TensorShape_TensorShape)
* [`tensorflow::TensorShape::TensorShape(const TensorShapeProto &proto)`](#tensorflow_TensorShape_TensorShape)
  * REQUIRES: IsValid(proto)
* [`tensorflow::TensorShape::TensorShape()`](#tensorflow_TensorShape_TensorShape)
* [`void tensorflow::TensorShape::Clear()`](#void_tensorflow_TensorShape_Clear)
  * Clear a tensor shape.
* [`void tensorflow::TensorShape::AddDim(int64 size)`](#void_tensorflow_TensorShape_AddDim)
  * Add a dimension to the end ("inner-most"). REQUIRES: size >= 0.
* [`void tensorflow::TensorShape::AppendShape(const TensorShape &shape)`](#void_tensorflow_TensorShape_AppendShape)
  * Appends all the dimensions from shape.
* [`void tensorflow::TensorShape::InsertDim(int d, int64 size)`](#void_tensorflow_TensorShape_InsertDim)
  * Insert a dimension somewhere in the TensorShape . REQUIRES: "0 <= d <= dims()" REQUIRES: size >= 0.
* [`void tensorflow::TensorShape::set_dim(int d, int64 size)`](#void_tensorflow_TensorShape_set_dim)
  * Modifies the size of the dimension &apos;d&apos; to be &apos;size&apos; REQUIRES: "0 <= d < dims()" REQUIRES: size >= 0.
* [`void tensorflow::TensorShape::RemoveDim(int d)`](#void_tensorflow_TensorShape_RemoveDim)
  * Removes dimension &apos;d&apos; from the TensorShape . REQUIRES: "0 <= d < dims()".
* [`int tensorflow::TensorShape::dims() const`](#int_tensorflow_TensorShape_dims)
  * Return the number of dimensions in the tensor.
* [`int64 tensorflow::TensorShape::dim_size(int d) const`](#int64_tensorflow_TensorShape_dim_size)
  * Returns the number of elements in dimension "d". REQUIRES: "0 <= d < dims()".
* [`gtl::ArraySlice<int64> tensorflow::TensorShape::dim_sizes() const`](#gtl_ArraySlice_int64_tensorflow_TensorShape_dim_sizes)
  * Returns sizes of all dimensions.
* [`int64 tensorflow::TensorShape::num_elements() const`](#int64_tensorflow_TensorShape_num_elements)
  * Returns the number of elements in the tensor.
* [`bool tensorflow::TensorShape::IsSameSize(const TensorShape &b) const`](#bool_tensorflow_TensorShape_IsSameSize)
  * Returns true if *this and b have the same sizes. Ignores dimension names.
* [`bool tensorflow::TensorShape::operator==(const TensorShape &b) const`](#bool_tensorflow_TensorShape_operator_)
* [`void tensorflow::TensorShape::AsProto(TensorShapeProto *proto) const`](#void_tensorflow_TensorShape_AsProto)
  * Fill *proto from *this.
* [`Eigen::DSizes< Eigen::DenseIndex, NDIMS > tensorflow::TensorShape::AsEigenDSizes() const`](#Eigen_DSizes_Eigen_DenseIndex_NDIMS_tensorflow_TensorShape_AsEigenDSizes)
  * Fill *dsizes from *this.
* [`Eigen::DSizes< Eigen::DenseIndex, NDIMS > tensorflow::TensorShape::AsEigenDSizesWithPadding() const`](#Eigen_DSizes_Eigen_DenseIndex_NDIMS_tensorflow_TensorShape_AsEigenDSizesWithPadding)
* [`TensorShapeIter tensorflow::TensorShape::begin() const`](#TensorShapeIter_tensorflow_TensorShape_begin)
  * For iterating through the dimensions.
* [`TensorShapeIter tensorflow::TensorShape::end() const`](#TensorShapeIter_tensorflow_TensorShape_end)
* [`string tensorflow::TensorShape::DebugString() const`](#string_tensorflow_TensorShape_DebugString)
  * For error messages.
* [`string tensorflow::TensorShape::ShortDebugString() const`](#string_tensorflow_TensorShape_ShortDebugString)
* [`static bool tensorflow::TensorShape::IsValid(const TensorShapeProto &proto)`](#static_bool_tensorflow_TensorShape_IsValid)
  * Returns true iff "proto" is a valid tensor shape.

##Member Details <a class="md-anchor" id="AUTOGENERATED-member-details"></a>

#### `tensorflow::TensorShape::TensorShape(gtl::ArraySlice< int64 > dim_sizes)` <a class="md-anchor" id="tensorflow_TensorShape_TensorShape"></a>

Construct a TensorShape from the provided sizes.. REQUIRES: dim_sizes[i] >= 0.



#### `tensorflow::TensorShape::TensorShape(std::initializer_list< int64 > dim_sizes)` <a class="md-anchor" id="tensorflow_TensorShape_TensorShape"></a>





#### `tensorflow::TensorShape::TensorShape(const TensorShapeProto &proto)` <a class="md-anchor" id="tensorflow_TensorShape_TensorShape"></a>

REQUIRES: IsValid(proto)



#### `tensorflow::TensorShape::TensorShape()` <a class="md-anchor" id="tensorflow_TensorShape_TensorShape"></a>



Create a tensor shape with no dimensions and one element, which you can then call AddDim() on.

#### `void tensorflow::TensorShape::Clear()` <a class="md-anchor" id="void_tensorflow_TensorShape_Clear"></a>

Clear a tensor shape.



#### `void tensorflow::TensorShape::AddDim(int64 size)` <a class="md-anchor" id="void_tensorflow_TensorShape_AddDim"></a>

Add a dimension to the end ("inner-most"). REQUIRES: size >= 0.



#### `void tensorflow::TensorShape::AppendShape(const TensorShape &shape)` <a class="md-anchor" id="void_tensorflow_TensorShape_AppendShape"></a>

Appends all the dimensions from shape.



#### `void tensorflow::TensorShape::InsertDim(int d, int64 size)` <a class="md-anchor" id="void_tensorflow_TensorShape_InsertDim"></a>

Insert a dimension somewhere in the TensorShape . REQUIRES: "0 <= d <= dims()" REQUIRES: size >= 0.



#### `void tensorflow::TensorShape::set_dim(int d, int64 size)` <a class="md-anchor" id="void_tensorflow_TensorShape_set_dim"></a>

Modifies the size of the dimension &apos;d&apos; to be &apos;size&apos; REQUIRES: "0 <= d < dims()" REQUIRES: size >= 0.



#### `void tensorflow::TensorShape::RemoveDim(int d)` <a class="md-anchor" id="void_tensorflow_TensorShape_RemoveDim"></a>

Removes dimension &apos;d&apos; from the TensorShape . REQUIRES: "0 <= d < dims()".



#### `int tensorflow::TensorShape::dims() const` <a class="md-anchor" id="int_tensorflow_TensorShape_dims"></a>

Return the number of dimensions in the tensor.



#### `int64 tensorflow::TensorShape::dim_size(int d) const` <a class="md-anchor" id="int64_tensorflow_TensorShape_dim_size"></a>

Returns the number of elements in dimension "d". REQUIRES: "0 <= d < dims()".



#### `gtl::ArraySlice<int64> tensorflow::TensorShape::dim_sizes() const` <a class="md-anchor" id="gtl_ArraySlice_int64_tensorflow_TensorShape_dim_sizes"></a>

Returns sizes of all dimensions.



#### `int64 tensorflow::TensorShape::num_elements() const` <a class="md-anchor" id="int64_tensorflow_TensorShape_num_elements"></a>

Returns the number of elements in the tensor.

We use int64 and not size_t to be compatible with Eigen::Tensor which uses ptr_fi

#### `bool tensorflow::TensorShape::IsSameSize(const TensorShape &b) const` <a class="md-anchor" id="bool_tensorflow_TensorShape_IsSameSize"></a>

Returns true if *this and b have the same sizes. Ignores dimension names.



#### `bool tensorflow::TensorShape::operator==(const TensorShape &b) const` <a class="md-anchor" id="bool_tensorflow_TensorShape_operator_"></a>





#### `void tensorflow::TensorShape::AsProto(TensorShapeProto *proto) const` <a class="md-anchor" id="void_tensorflow_TensorShape_AsProto"></a>

Fill *proto from *this.



#### `Eigen::DSizes< Eigen::DenseIndex, NDIMS > tensorflow::TensorShape::AsEigenDSizes() const` <a class="md-anchor" id="Eigen_DSizes_Eigen_DenseIndex_NDIMS_tensorflow_TensorShape_AsEigenDSizes"></a>

Fill *dsizes from *this.



#### `Eigen::DSizes< Eigen::DenseIndex, NDIMS > tensorflow::TensorShape::AsEigenDSizesWithPadding() const` <a class="md-anchor" id="Eigen_DSizes_Eigen_DenseIndex_NDIMS_tensorflow_TensorShape_AsEigenDSizesWithPadding"></a>



Same as AsEigenDSizes() but allows for NDIMS > dims()  in which case we pad the rest of the sizes with 1.

#### `TensorShapeIter tensorflow::TensorShape::begin() const` <a class="md-anchor" id="TensorShapeIter_tensorflow_TensorShape_begin"></a>

For iterating through the dimensions.



#### `TensorShapeIter tensorflow::TensorShape::end() const` <a class="md-anchor" id="TensorShapeIter_tensorflow_TensorShape_end"></a>





#### `string tensorflow::TensorShape::DebugString() const` <a class="md-anchor" id="string_tensorflow_TensorShape_DebugString"></a>

For error messages.



#### `string tensorflow::TensorShape::ShortDebugString() const` <a class="md-anchor" id="string_tensorflow_TensorShape_ShortDebugString"></a>





#### `static bool tensorflow::TensorShape::IsValid(const TensorShapeProto &proto)` <a class="md-anchor" id="static_bool_tensorflow_TensorShape_IsValid"></a>

Returns true iff "proto" is a valid tensor shape.


