/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import { execSync } from 'child_process';
import { existsSync, mkdirSync, writeFileSync } from 'fs';
import { dirname, join } from 'path';
import { fileURLToPath } from 'url';

const __dirname = dirname(fileURLToPath(import.meta.url));
const root = join(__dirname, '..');
const generatedDir = join(root, 'packages/cli/src/generated');
const gitCommitFile = join(generatedDir, 'git-commit.ts');
let gitCommitInfo = 'N/A';

if (!existsSync(generatedDir)) {
  mkdirSync(generatedDir, { recursive: true });
}

try {
  const gitHash = execSync('git rev-parse --short HEAD', {
    encoding: 'utf-8',
  }).trim();
  if (gitHash) {
    gitCommitInfo = gitHash;
    const gitStatus = execSync('git status --porcelain', {
      encoding: 'utf-8',
    }).trim();
    if (gitStatus) {
      gitCommitInfo = `${gitHash} (local modifications)`;
    }
  }
} catch {
  // ignore
}

const fileContent = `/**
 * @license
 * Copyright ${new Date().getFullYear()} Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

// This file is auto-generated by the build script (scripts/build.js)
// Do not edit this file manually.
export const GIT_COMMIT_INFO = '${gitCommitInfo}';
`;

writeFileSync(gitCommitFile, fileContent);
