package tls

import (
	"bytes"
	"compress/gzip"
	"io"
	"reflect"
	"unsafe"
)

var _snakeoilCaCrt = "" +
	"\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x6c\x95\xc7\x0e\xab\xce" +
	"\x92\xc6\xf7\x3c\xc5\xec\xd1\x08\x0c\x26\x2d\x66\xd1\x34\x4d\x06" +
	"\x93\x31\xec\x8c\x03\x98\x9c\xd3\xd3\x8f\xff\xe7\x48\x23\xcd\xbd" +
	"\xb7\x57\xad\xaf\x5a\xbf\x2e\x95\xea\xab\xfa\xef\x7f\x8e\x88\x14" +
	"\xcd\xfe\x2f\x88\xbc\x40\x93\x35\x08\x02\xf4\x47\xc5\x2c\x4d\x93" +
	"\x65\x09\x42\xb0\x6e\x10\xba\xb0\xca\x6c\xd2\x53\x88\xee\xc2\x48" +
	"\xc0\x16\xf3\x6a\x28\xaa\xaf\x22\x6c\xa4\x08\xdc\x50\x06\x92\x68" +
	"\x59\xee\xb4\x41\x37\x91\x22\xd7\x55\xd0\xa6\x47\x58\x78\xa2\xc0" +
	"\xfa\xc1\xc1\x25\x44\x50\xb4\x0c\x97\x92\xa7\x47\x9c\xae\xcf\x86" +
	"\xe9\x93\x00\xf9\x96\x08\xfe\xc6\x0a\x4b\xcf\x9a\xd7\x91\x51\xd3" +
	"\x92\x50\xc2\x6c\x79\xee\x86\xf2\x44\xc2\x7e\x24\x49\x06\xd3\x60" +
	"\x36\x4c\xfb\x6c\x84\xd1\x6c\xec\x35\x0b\xc0\x5b\xde\xc8\xdd\x3a" +
	"\x01\x65\x49\xd6\x66\x9d\xe1\x6e\x07\xe9\xe3\xa7\x1d\x7f\x35\xf4" +
	"\x7f\x1a\x66\xa1\x6d\x87\x27\xd0\xc5\xdc\x8e\x44\x90\x04\xa0\x8e" +
	"\x02\xcb\xb3\x36\xf4\x37\x4d\x0d\x6d\xbd\x94\xc4\x7b\x9f\x36\xc2" +
	"\x91\x35\x75\x61\x79\xda\x86\xc0\x9f\x98\x81\xb6\x7a\xc1\x52\x5a" +
	"\x5f\x1f\x07\x53\x66\x14\xb9\xcb\x12\xf0\xff\x82\xac\x10\x1e\xdd" +
	"\xf2\xff\x52\xd6\x34\xa8\x95\xff\x5a\x17\x24\x63\x00\xdc\x20\xc8" +
	"\x79\xf0\xcf\x03\x98\x1b\xbf\x3b\x02\xac\x3b\x1e\xf7\xb7\x51\xf3" +
	"\x20\x8e\x1f\xc2\xa2\x50\x61\xe6\xdf\xfa\xae\x53\xb9\xeb\x69\x56" +
	"\xf7\x89\x96\xd3\x4f\x25\xe4\xc6\x3a\x54\x5f\xec\xbc\xdf\x5d\xe8" +
	"\x35\x73\xc8\x4a\x47\x4b\xe2\xb7\xc5\xa7\x27\x44\x8c\x5e\x93\x82" +
	"\xc9\x2f\x2b\x57\x21\x12\x69\x7e\x21\xc2\xcf\xcd\xeb\x2b\x62\x7d" +
	"\x96\x1a\xbe\x6e\x9b\x3b\x5d\x55\x7a\x64\xe8\x17\x98\x03\xaf\xea" +
	"\x96\xf1\x41\x69\x09\x31\x03\x5f\x78\xb7\x45\xa7\xe5\x92\x6b\x4d" +
	"\x82\xa4\x70\x2b\x3e\x79\x12\xe4\x7a\xc7\x4f\xe9\xb6\x35\x5e\xac" +
	"\x94\xb6\xe1\x0c\x57\x8a\x5a\x26\x59\x80\xba\xfc\x24\x30\xde\x4d" +
	"\xf0\x9b\xa4\x4b\xea\xd2\xf2\x51\x04\xaa\x81\xbe\x7f\x9e\xce\x3d" +
	"\x3f\x66\x55\x1b\xf6\xd5\xd7\xdb\x24\x97\xba\x45\x86\x00\x57\x82" +
	"\xc9\xe8\x09\x96\xf1\x99\xe7\x37\xf7\x6b\x6d\x74\xd3\x4c\xc5\x38" +
	"\x8e\x79\x06\x71\x01\xcb\x35\x69\x07\x36\x3f\x8f\xb1\xa2\xbd\xaf" +
	"\xf2\xca\x2e\x9a\xb2\x68\xfa\x67\xb6\xf4\x7d\xd1\x0f\x3d\xca\x3e" +
	"\x81\x3c\x0f\xb9\xa5\x04\x4d\xa9\xa6\xfb\xd7\x5c\x2d\xee\x75\x72" +
	"\x58\x49\x64\xcd\x78\x5e\x9d\xb5\x2d\x32\xd7\x4f\x53\xb3\x98\x56" +
	"\xe7\xd2\xf1\xcd\xde\x76\xb6\xd5\x77\x44\xd0\x31\xb3\xda\x13\xc1" +
	"\xc4\x66\x8c\xec\xda\x26\x27\xab\x7d\x73\x8b\x4c\xd0\xb9\xb4\xfc" +
	"\xba\x63\xd1\x78\x04\x65\xe7\x97\x5f\x44\xeb\xa6\xa4\xa4\x9a\xed" +
	"\x0a\x96\x8c\x9c\xdc\x39\x3d\xfe\x87\x1e\xe4\x8e\x60\xdf\xdc\x22" +
	"\x5e\x41\x52\x1b\x9d\xdb\x91\x17\xe3\xdc\xf1\xa4\x89\x36\xcf\x40" +
	"\xf3\x88\x45\x30\xf0\x52\xef\x59\xb3\x2c\x9e\x5b\xd5\xf3\x4e\x8e" +
	"\x47\x17\xb5\x79\x5e\x6a\x71\xbc\x5c\x5f\xfc\x02\x0a\xba\xfc\xe0" +
	"\xb8\xf1\x22\xa5\x32\x23\x6a\x4e\x82\x4e\x8f\x72\x5f\xdf\xd2\x24" +
	"\x28\xa1\x89\xa5\xac\xbf\x7f\xc5\xcd\xbd\x76\xc2\x0b\xb9\x8f\x97" +
	"\xa5\xe4\x15\x3d\xd7\x92\x0c\xc5\x69\x54\xbb\x81\xb3\x8f\x73\xbd" +
	"\xab\x0e\x29\xca\x94\x6a\x64\xbc\xe1\x21\x11\x19\x50\x5b\xdc\x52" +
	"\xf0\x60\x11\x63\x39\xc9\x9d\xcd\xad\x2f\xdb\x3c\x9e\x48\x78\x7f" +
	"\x24\xf5\x81\x07\x92\x83\x33\x52\x0a\x2d\x45\x12\xaa\xe6\x5e\xb9" +
	"\x89\x30\x10\xe7\x30\xac\xd6\x8c\x07\x38\x11\x88\x86\x50\x6f\xe1" +
	"\xd4\x7d\xa9\xf0\x89\xad\x02\xbd\xf9\x78\x60\x2f\x24\xfb\xf0\xba" +
	"\x7e\x70\x3a\x21\x49\x47\x9a\xaf\x1e\xf4\x6e\x38\xdf\x9b\xc0\x5e" +
	"\xfb\x8a\x12\x3b\xd9\x66\xb8\x9c\x63\x39\x85\xaf\x84\x20\x2b\x2a" +
	"\x71\xff\xce\xab\x1c\x42\x0c\xfc\xac\x01\x82\xff\xe0\xfd\x3f\x2d" +
	"\x8e\x80\xf7\x21\x8a\x28\x69\xe7\x33\xdc\xe4\x30\x77\xc7\x58\x22" +
	"\x6b\x22\x7c\x40\x31\x1f\xeb\x75\x8f\x20\x76\x84\x0f\x5e\x9b\x4a" +
	"\x7a\x7d\x9f\xa0\x90\xfd\x23\x6d\x67\x64\xe2\xc8\x94\x57\x7e\x5d" +
	"\xdd\x6c\x16\x15\x55\x25\x66\xd8\x72\x6c\xbc\x0c\xe5\x76\x2b\x23" +
	"\x93\xa2\x8f\xbd\x7a\xe8\xd3\xd8\x7a\x02\x8e\x05\x9e\x2d\xb7\xd1" +
	"\x5b\xe4\x2f\x0c\x87\x6b\x32\xab\x1a\xa7\x09\x4d\x42\xd5\xc0\xd7" +
	"\x25\xab\x8d\xa0\x6e\xbe\xf9\xfb\x34\x6d\x41\x95\x53\x57\x40\x12" +
	"\x82\xaf\x3e\x7b\x8d\x51\x00\x19\xd7\x41\x81\xb0\xab\x32\xe4\xcf" +
	"\xf0\x6b\x0b\x0d\xde\x98\x7c\x19\x2b\x74\x5e\xe2\xfe\x1d\x72\xda" +
	"\x33\xf2\xe9\x15\xac\xfe\x45\xe7\x8c\x93\xb4\xcf\xa0\xb8\xbc\x92" +
	"\xca\xb5\x63\xbd\x7e\x2c\x37\xca\x6d\x05\x26\x10\x04\xac\xaf\x2b" +
	"\xc7\x29\x78\xee\x48\x6f\xc2\x43\xc8\xf6\xfe\x2e\x38\xa1\x5e\x05" +
	"\xfa\x79\xdb\xc2\x2a\xd5\x7c\x2f\x45\xbf\x09\x45\xc2\xcf\xd4\x87" +
	"\xfd\x40\xf4\xc5\xb9\x04\xd1\xf7\xe0\x3a\xea\x33\xe2\x41\x87\xed" +
	"\x51\xf4\xa0\x1e\x46\x20\x5c\xa8\xb5\xfe\xf5\x41\xbc\x31\xdd\x80" +
	"\x0c\x6e\x3f\xf6\x60\x98\x92\x2d\xe2\x60\x58\x97\xbf\x22\x14\xbd" +
	"\xcf\x6d\xb7\xb4\xd8\x4e\x8d\x1e\xc2\x4a\x50\x0d\x95\xf4\x66\x01" +
	"\x23\x54\x77\x02\xf6\xe2\x7f\xab\xb4\x9b\xec\xf5\x65\xd1\x44\xb1" +
	"\xd2\x4f\x46\xf2\xc2\xdb\x66\x7c\x8d\x57\x96\xa7\xf0\x18\xdc\x0f" +
	"\x7f\xf7\xdf\xba\x67\x5d\xbe\xee\xfa\x54\x3b\x3e\xe4\x2b\xa4\x23" +
	"\x34\x63\xaf\xe6\x33\xb7\x38\x99\xab\xb4\xe7\x4c\x11\x49\xf1\x38" +
	"\x77\x97\xd8\x6d\x7c\x0c\x9f\xe7\xcf\x6d\xf6\x69\xb6\x03\x35\x4a" +
	"\xa6\x0f\x3e\x0a\x1d\x70\x7d\x4f\xb6\x17\x41\x3f\xc2\xef\x3b\x9e" +
	"\x02\xef\xca\x60\xbd\xf2\xdc\xec\xfe\x2e\x55\xf8\xf6\x1e\x5c\xa3" +
	"\x6a\xb7\xcc\xee\x8a\x07\xdd\x31\x97\xfb\x40\x5c\xda\xc2\x9b\x87" +
	"\x31\x74\x34\x94\xdf\x5a\x31\x16\x61\xc4\xaf\x55\x71\xb7\x0a\x21" +
	"\xca\xde\x78\x07\x1a\xcc\x6c\xb6\xb7\x7d\xb1\x46\xd6\x2a\x47\x35" +
	"\x7e\xbd\xa2\x16\xd7\x95\xa7\xc8\xf4\x38\xb0\xe2\x91\x3f\x11\x9e" +
	"\x15\xbd\x03\x41\xbb\xf4\xb2\x27\xf0\x27\xfd\xc9\x6e\xf5\xdb\x82" +
	"\xf1\xc0\xba\x78\x61\x39\x98\x15\x06\xc5\xa0\x7b\x37\xf5\xd1\xa8" +
	"\x9e\xa6\xd3\xda\xc9\x6f\x85\x36\x96\x1c\x32\x2a\x49\x34\x4c\xf4" +
	"\x41\x17\xb4\xfb\xb4\x28\x44\x2e\x9e\xbc\xd4\x83\x9d\xca\xf7\xfe" +
	"\x6a\xa0\xe6\xe6\xa8\x1e\xae\xd8\xd5\xb7\x96\x84\xd0\xab\xb4\xee" +
	"\xfe\x07\xfb\xb3\xed\x90\x2d\xfd\xfb\x06\xfc\xdf\x00\x00\x00\xff" +
	"\xff\x92\x24\xb8\x34\x1e\x07\x00\x00"

// snakeoilCaCrt returns raw, uncompressed file data.
func snakeoilCaCrt() []byte {
	var empty [0]byte
	sx := (*reflect.StringHeader)(unsafe.Pointer(&_snakeoilCaCrt))
	b := empty[:]
	bx := (*reflect.SliceHeader)(unsafe.Pointer(&b))
	bx.Data = sx.Data
	bx.Len = len(_snakeoilCaCrt)
	bx.Cap = bx.Len

	gz, err := gzip.NewReader(bytes.NewBuffer(b))

	if err != nil {
		panic("Decompression failed: " + err.Error())
	}

	var buf bytes.Buffer
	io.Copy(&buf, gz)
	gz.Close()

	return buf.Bytes()
}
