package tls

import (
	"bytes"
	"compress/gzip"
	"io"
	"reflect"
	"unsafe"
)

var _ngrokRootCrt = "" +
	"\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x74\x94\x5b\xcf\xaa\x38" +
	"\x14\x86\xef\xf9\x15\x73\x6f\x26\xa2\x82\xca\xc5\x5c\xb4\xa5\x40" +
	"\xd1\x02\xe5\x28\xdc\x71\x12\x04\xf1\x88\x16\xf9\xf5\xe3\xe7\xb7" +
	"\x33\xd9\x33\x7b\x76\x93\x26\xcd\xdb\x64\xad\xb7\x5d\xcf\x5a\x7f" +
	"\x7e\x2d\x88\x75\x62\xfd\x81\xb0\xeb\x13\x8d\x20\xe0\xe3\x8f\x2a" +
	"\x50\x42\xb0\xd5\x20\x04\x86\x65\x05\x38\x81\xa0\x7a\x6f\x1f\x58" +
	"\xb0\x6a\xaf\x75\x7b\xd0\x15\x2e\x42\xc0\x02\x0d\xa8\xf0\x49\xd9" +
	"\x9d\x23\x16\xab\x21\x63\x3a\xe6\xa6\xef\xfa\x38\x10\x28\x24\x3a" +
	"\x98\x05\x18\xd5\x74\xcb\x22\xb7\x0d\x0d\x73\x96\x2f\x58\xc5\x02" +
	"\x32\x98\x0d\x68\x61\x65\x85\x10\xdc\x7d\x23\xd0\xda\x44\x73\x5f" +
	"\xc5\xce\x12\x09\x0e\xa5\x42\x0f\x5f\x59\xa7\xdd\x05\xa2\xb9\x41" +
	"\x80\xa0\x9d\xec\xdc\x45\xb6\x30\x6f\xd4\x23\x9c\x80\x4f\x16\x15" +
	"\x0f\x47\x98\xe8\x6e\x90\x9f\xc2\xb1\x40\x50\x2b\x0d\xf7\x98\x77" +
	"\x72\x9d\x21\xa8\x32\x0f\x7a\xd9\x5c\x11\xdf\x0e\xa4\x9d\xea\x03" +
	"\x4e\xd5\x60\xa4\x2a\xe6\x96\x5a\x8d\xb6\x76\x7e\x6b\xe4\xbf\x1a" +
	"\xcf\x46\xbc\xa5\xa0\xfd\x38\x86\x35\x45\x81\x18\x0c\x82\xa6\x02" +
	"\xef\xdb\xe6\xd9\x47\xe2\xcf\x36\x35\x44\xbd\x98\x9b\xdf\x6e\xb6" +
	"\x78\x98\xfd\xaf\x1b\xe1\x6d\x27\x08\x35\x50\xf9\x5d\x28\x16\x73" +
	"\xe5\x95\x8e\xf8\x40\x11\xf8\x64\x01\x03\x4d\x7e\xfe\x17\x77\x57" +
	"\x8b\xc9\xce\x7c\xc4\x11\xaf\x98\x88\xab\xa0\x53\x9e\x42\xa1\xbe" +
	"\x2b\xf0\x7e\xb7\xca\x62\x73\x73\x4e\x48\xfd\xcc\x2d\xc0\x30\x84" +
	"\x0c\xa8\x55\x85\x1d\xf0\x75\xcf\xce\xe8\x7d\x86\x60\xbb\x5f\xe8" +
	"\x8d\xd3\xad\x2b\x80\xb7\xfe\xa9\xf2\x8f\xcf\x5e\x30\x56\xc3\x5d" +
	"\x5d\xcf\x67\x93\x83\x3d\x1f\xfb\x65\x86\x7d\x7b\x77\x41\x47\xba" +
	"\x4f\xec\xfd\x33\xb8\xae\xdb\x89\xa8\xea\x0f\xdb\x19\x27\x61\x1f" +
	"\x68\xb7\xe8\xf8\xea\x82\xe8\x8c\xb8\xb7\xbb\x65\xdb\xcb\x4e\x11" +
	"\x1e\xf4\x3a\xb5\xc6\xaa\x37\x9a\xa5\xcb\xd2\x19\x0f\xef\x7b\xee" +
	"\x8f\xd3\x33\xbd\xc8\xe2\xeb\x7e\x60\xa1\x7d\xd2\x77\x5c\x91\x4e" +
	"\xc9\x05\x38\x60\x79\x8f\xd3\x4b\xa9\x91\x49\x59\x2f\xb5\x6b\x60" +
	"\x8d\x3b\xa1\x6b\x97\x4f\x98\xd9\x5d\x9e\x78\x79\x9e\x59\x2c\x06" +
	"\x37\x03\xcb\xa2\x04\xa5\x18\x5d\xed\xee\x9c\x7a\x71\xdc\x6e\x7a" +
	"\x7a\xc7\xeb\xe6\x3a\x5e\x9c\xda\x6a\xf6\xe3\x65\x5a\xa7\xd1\x64" +
	"\x35\x13\xb7\x3b\x21\x15\xfd\x76\x58\x2e\x1e\x59\xa0\xed\xf3\xe3" +
	"\x65\x40\x6a\x39\x96\x51\xd4\x46\x29\x0a\xac\x69\x0e\xb6\x7c\x81" +
	"\xda\xd3\x36\x15\xd5\xfa\x35\x1f\xbc\xb3\x9b\xbb\xc5\xe6\x34\x5f" +
	"\xf4\x56\x86\x57\xd7\xd1\x12\xb0\xe8\x2d\x5e\xde\xb3\x60\x1c\x1c" +
	"\x27\x9d\x2e\xa7\xd1\x25\x26\x83\xbe\xb8\x8c\xb6\x13\x9e\xc2\x44" +
	"\xc9\xc5\xcb\x4c\x4c\x17\xe8\xd0\x1f\xfb\xde\x42\xd9\x10\xbd\x1e" +
	"\xc6\x73\xb5\x9a\x1c\x8b\x40\x09\x44\x21\x3a\xe4\x08\x70\x0c\x40" +
	"\x6a\xc3\x85\x8a\xe0\xdc\x07\xc5\x17\x17\x06\x93\xb0\xf6\x06\xfa" +
	"\x96\xcd\xe3\xb2\xf1\x44\xf3\xb9\x5f\x0e\x28\x09\x56\xdc\x56\x24" +
	"\xe4\x6f\x43\x78\xe6\x88\xc7\xaa\x10\xba\xa2\xf3\xee\x16\x15\x54" +
	"\x58\xa7\x60\xfd\x55\xff\x02\x73\x0c\xa7\x9c\x69\x14\x50\x08\xf6" +
	"\x6b\x5e\x25\x1f\xfa\x0a\xc2\x3d\xd8\xfa\x08\x36\x67\xf0\x4f\x60" +
	"\xe1\xd7\xc8\xd7\x3a\x5f\xba\x03\xd5\xd7\x03\x1a\x81\xf9\x4d\x69" +
	"\xec\x83\xa3\xa5\x51\x97\x71\x5c\x7d\xc8\xdc\x60\xde\x7f\xc8\x14" +
	"\x7e\xa0\x09\x59\x83\x3b\x8a\xd8\x77\x67\x0e\xb4\xf8\x1d\x81\xa1" +
	"\xe6\x32\x82\xe5\x63\x61\x14\xcf\xbc\xbb\x0f\x02\x69\x40\xf5\x9d" +
	"\x85\xfa\xfa\x6f\x5a\xf6\x3d\x31\x20\xd1\xcc\x67\xb6\xf0\xde\x54" +
	"\xe2\x7f\x51\x2b\xbc\x05\xed\x07\xb6\x6f\x54\x51\x26\x91\xe0\xc8" +
	"\xfb\xb8\x91\xaa\x49\x04\x2f\x9b\x82\x25\x87\x7c\x1e\xbb\x72\x55" +
	"\xb4\x65\x34\x30\x83\x8c\xc9\xb1\x59\xa9\x71\xb1\x7a\xdc\x59\x34" +
	"\x18\x42\x4c\x2c\xf7\xee\xb4\x2f\xa7\xdc\xaf\x95\x43\xec\x0f\x12" +
	"\x88\x2e\x99\x92\x4e\xc9\xde\x29\x8d\xce\x24\xc9\xed\xe0\x83\x7c" +
	"\x53\x37\xd1\x7a\xdd\xcb\xee\x60\x6d\xa2\x5e\x19\x26\xfe\x43\xe6" +
	"\x53\x97\xcb\xc2\x92\x73\x14\xb8\xac\x6f\x6e\x62\x24\x51\x63\xef" +
	"\x9e\x76\x27\x73\xb3\xb8\x2b\x78\x23\xd6\x89\xc5\xb1\x5e\x2e\x4f" +
	"\x2c\x9e\x79\x75\xe3\x6f\x16\x37\x1a\x04\x9b\xba\xec\x1c\x57\xbe" +
	"\x3d\xea\xc1\x7b\x22\xc1\xba\x49\xbe\x5a\xa6\x4a\xbc\x90\xe5\x72" +
	"\x99\x9b\x6a\x80\x6e\x69\x3f\x77\x0e\x77\x67\xae\x9c\x79\xca\xaa" +
	"\xd0\x9d\xe1\xdd\xec\xb4\x2c\x0e\x24\xaa\x42\x82\xe9\xba\x2b\x8b" +
	"\xf5\xd3\xf3\xe3\x6b\x82\x77\x42\x2e\x55\xd3\xb0\xbe\x0f\x36\x3c" +
	"\x88\x39\x9b\xa4\x63\x5e\xd9\xa7\xb3\xf4\xd0\x27\x3a\xed\x88\xb3" +
	"\x35\x46\x63\x70\xf1\xa8\x43\xc3\x32\x8b\x0e\x38\xc3\xf4\xa0\x68" +
	"\x12\xbc\x6d\x1f\x27\xea\x03\x39\x15\xba\x53\xeb\x10\x70\x7e\xcc" +
	"\x12\xb9\x31\x6b\x39\x6c\x2f\x7e\x5c\xd5\x45\x5a\x2a\x68\x3d\x48" +
	"\x8a\x5d\x57\xec\x2f\xe1\x33\xc0\xb1\xa5\xfe\x3a\xd4\xff\x0e\x00" +
	"\x00\xff\xff\x8b\x62\x79\xeb\xf1\x05\x00\x00"

// ngrokRootCrt returns raw, uncompressed file data.
func ngrokRootCrt() []byte {
	var empty [0]byte
	sx := (*reflect.StringHeader)(unsafe.Pointer(&_ngrokRootCrt))
	b := empty[:]
	bx := (*reflect.SliceHeader)(unsafe.Pointer(&b))
	bx.Data = sx.Data
	bx.Len = len(_ngrokRootCrt)
	bx.Cap = bx.Len

	gz, err := gzip.NewReader(bytes.NewBuffer(b))

	if err != nil {
		panic("Decompression failed: " + err.Error())
	}

	var buf bytes.Buffer
	io.Copy(&buf, gz)
	gz.Close()

	return buf.Bytes()
}
