/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License") +  you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openmeetings.web.app;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import javax.servlet.http.Cookie;

import org.apache.openmeetings.AbstractWicketTester;
import org.apache.openmeetings.db.entity.user.User;
import org.junit.Test;

public class TestOmAuthenticationStrategy extends AbstractWicketTester {
	@Test
	public void test() {
		OmAuthenticationStrategy s = new OmAuthenticationStrategy();
		s.save(null, null, User.Type.oauth, null);
		assertNull("Wasn't saved, should not be loaded", s.load());

		s.save("aa", "bb", User.Type.contact, null);
		copyCookies();
		assertNotNull("Should be loaded", s.load());

		assertEquals(0, s.decode(null).length);
		assertEquals(4, s.decode("1").length);
		assertEquals(4, s.decode("1-sep-2").length);
		assertEquals(4, s.decode("1-sep-2-sep-user").length);
		assertEquals(4, s.decode("1-sep-2-sep-user-sep-3").length);
		assertEquals(4, s.decode("-sep--sep--sep-").length);
	}

	private void copyCookies() {
		for (Cookie c : tester.getResponse().getCookies()) {
			tester.getRequest().addCookie(c);
		}
	}
}
