/* Copyright 2015 the SumatraPDF project authors (see AUTHORS file).
   License: Simplified BSD (see COPYING.BSD) */

// Relatively high-precision timer. Can be used e.g. for measuring execution
// time of a piece of code.

inline LARGE_INTEGER TimeGet() {
    LARGE_INTEGER t;
    QueryPerformanceCounter(&t);
    return t;
}

inline double TimeSinceInMs(LARGE_INTEGER start) {
    LARGE_INTEGER t = TimeGet();
    LARGE_INTEGER freq;
    QueryPerformanceFrequency(&freq);
    double timeInSecs = (double)(t.QuadPart - start.QuadPart) / (double)freq.QuadPart;
    return timeInSecs * 1000.0;
}
