/* Test data for regression tests: Search in PDF

To run these regression tests, you need an external PDF file:
sumatra-search-across-pages-20170615.pdf (SHA1 1922e3a9dcfa5c6341ed23ac3882fc5d3c149e7c)
https://drive.google.com/file/d/0B2EXZJHDEYllMnkzMUZWWGdueDA/view?usp=sharing
*/

const size_t MAX_REGRESS_DATA = 6421;

struct RegressSearchInfo {
    WCHAR *searchPhrase;
    int count; // how many times it is found in the test document
    int rectCounts[MAX_REGRESS_DATA]; // how many rects or pages (see next struct members) are needed to locate each hit [count elements]
    RectI rects[MAX_REGRESS_DATA]; // rectangles covering the hits [sum(rectCounts) elements]
    int pages[MAX_REGRESS_DATA]; // pages on which the hist are found [sum(rectCounts) elements
};

RegressSearchInfo data_suspendisse = { 
  L"suspendisse",
  66, // matches
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, // rectCounts
  { {293, 126, 58, 14}, {335, 130, 59, 14}, {56, 671, 59, 14}, {315, 458, 58, 15}, 
    {221, 525, 59, 14}, {109, 163, 59, 14}, {323, 229, 59, 14}, 
    {56, 302, 59, 15}, {56, 508, 59, 14}, {131, 598, 59, 14}, 
    {255, 515, 59, 14}, {302, 695, 58, 14}, {395, 246, 58, 14}, 
    {390, 697, 59, 14}, {323, 196, 58, 14}, {266, 302, 59, 15}, 
    {339, 728, 59, 14}, {430, 744, 58, 14}, {292, 279, 59, 14}, 
    {218, 508, 59, 14}, {269, 638, 59, 14}, {300, 465, 59, 15}, 
    {56, 612, 59, 14}, {116, 735, 59, 14}, {146, 229, 59, 14}, 
    {56, 754, 59, 14}, {56, 196, 59, 14}, {338, 376, 59, 14}, 
    {292, 515, 58, 14}, {56, 605, 59, 14}, {359, 605, 59, 14}, 
    {409, 671, 58, 14}, {313, 106, 59, 15}, {56, 489, 59, 14}, 
    {384, 768, 58, 14}, {177, 425, 59, 15}, {335, 302, 59, 15}, 
    {161, 458, 59, 15}, {324, 548, 59, 14}, {56, 196, 59, 14}, 
    {431, 90, 58, 14}, {56, 286, 59, 14}, {475, 57, 60, 14}, {56, 130, 59, 14}, 
    {188, 546, 59, 14}, {204, 286, 58, 14}, {352, 302, 59, 15}, 
    {56, 499, 59, 14}, {464, 768, 60, 14}, {288, 180, 59, 14}, 
    {365, 515, 59, 14}, {86, 671, 58, 14}, {281, 671, 59, 14}, 
    {193, 704, 58, 14}, {56, 180, 59, 14}, {425, 352, 58, 14}, 
    {71, 508, 59, 14}, {92, 90, 58, 14}, {108, 196, 58, 14}, {94, 295, 59, 15}, 
    {352, 130, 58, 14}, {56, 286, 59, 14}, {56, 532, 59, 14}, 
    {471, 605, 59, 14}, {104, 458, 58, 15}, {313, 515, 58, 14} }, // rects
  { 1, 2, 2, 3, 3, 4, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 
    10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 13, 14, 14, 14, 15, 16, 16, 18, 18, 
    18, 19, 19, 19, 19, 20, 20, 20, 20, 20, 21, 21, 21, 22, 22, 22, 23, 23, 23, 
    23, 25, 25 } }; // pages

RegressSearchInfo data_fermentum_ultricies = {
  L"fermentum ultricies",
  1, // matches
  { 1 }, // rectCounts
  { {156, 319, 94, 14} }, // rects
  { 21 } }; // pages

RegressSearchInfo data_spendis = {
  L"spendis",
  66, // matches
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, // rectCounts
  { {305, 126, 36, 14}, {348, 130, 36, 14}, {69, 671, 36, 14}, {327, 458, 36, 15}, 
    {234, 525, 36, 14}, {122, 163, 36, 14}, {336, 229, 36, 14}, 
    {69, 302, 36, 15}, {69, 508, 36, 14}, {144, 598, 36, 14}, 
    {268, 515, 36, 14}, {315, 695, 35, 14}, {407, 246, 36, 14}, 
    {403, 697, 36, 14}, {335, 196, 36, 14}, {279, 302, 36, 15}, 
    {352, 728, 36, 14}, {442, 744, 36, 14}, {305, 279, 36, 14}, 
    {231, 508, 36, 14}, {282, 638, 36, 14}, {313, 465, 36, 15}, 
    {69, 612, 36, 14}, {129, 735, 36, 14}, {159, 229, 36, 14}, 
    {69, 754, 36, 14}, {69, 196, 36, 14}, {351, 376, 36, 14}, 
    {304, 515, 36, 14}, {69, 605, 36, 14}, {372, 605, 36, 14}, 
    {421, 671, 36, 14}, {326, 106, 36, 15}, {69, 489, 36, 14}, 
    {396, 768, 36, 14}, {190, 425, 36, 15}, {348, 302, 36, 15}, 
    {174, 458, 36, 15}, {337, 548, 36, 14}, {69, 196, 36, 14}, 
    {443, 90, 36, 14}, {69, 286, 36, 14}, {488, 57, 36, 14}, {69, 130, 36, 14}, 
    {201, 546, 36, 14}, {216, 286, 36, 14}, {365, 302, 36, 15}, 
    {69, 499, 36, 14}, {477, 768, 36, 14}, {301, 180, 36, 14}, 
    {378, 515, 36, 14}, {98, 671, 36, 14}, {294, 671, 36, 14}, 
    {205, 704, 36, 14}, {69, 180, 36, 14}, {437, 352, 36, 14}, 
    {84, 508, 36, 14}, {104, 90, 36, 14}, {120, 196, 36, 14}, 
    {107, 295, 36, 15}, {364, 130, 36, 14}, {69, 286, 36, 14}, 
    {69, 532, 36, 14}, {483, 605, 36, 14}, {116, 458, 36, 15}, {325, 515, 36, 14} }, // rects
  { 1, 2, 2, 3, 3, 4, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 
    10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 13, 14, 14, 14, 15, 16, 16, 18, 18, 
    18, 19, 19, 19, 19, 20, 20, 20, 20, 20, 21, 21, 21, 22, 22, 22, 23, 23, 23, 
    23, 25, 25 } }; // pages

RegressSearchInfo data_sit_amet_massa = {
  L"sit amet massa",
  3, // matches
  { 2, 1, 1 }, // rectCounts
  { {500, 770, 38, 15}, {56, 57, 30, 14}, {337, 196, 70, 14}, {145, 343, 69, 14} }, // rects
  { 3, 4, 6, 9 } }; // pages

RegressSearchInfo data_rhoncus_posuere = {
  L"rhoncus posuere",
  1, // matches
  { 2 }, // rectCounts
  { {497, 721, 39, 14}, {56, 737, 38, 14} }, // rects
  { 2, 2 } }; // pages

RegressSearchInfo data_euismod_ac = {
  L"euismod ac",
  3, // matches
  { 1, 1, 1 }, // rectCounts
  { {232, 376, 54, 14}, {56, 392, 55, 14}, {183, 57, 54, 14} }, // rects
  { 2, 2, 9 } }; // pages

RegressSearchInfo data_s = {
  L"s",
  6421, // matches
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, // rectCounts
  { {138, 57, 5, 14}, {192, 57, 5, 14}, {246, 57, 5, 14}, {295, 57, 5, 14}, 
  {351, 57, 5, 14}, {399, 57, 5, 14}, {429, 57, 5, 14}, {495, 57, 4, 14}, 
  {56, 71, 5, 14}, {129, 71, 4, 14}, {163, 71, 5, 14}, {209, 71, 5, 14}, 
  {364, 71, 7, 14}, {431, 71, 4, 14}, {468, 71, 5, 14}, {148, 84, 5, 15}, 
  {156, 84, 4, 15}, {328, 84, 4, 15}, {360, 84, 5, 15}, {365, 84, 4, 15}, 
  {468, 84, 5, 15}, {98, 98, 5, 14}, {230, 98, 5, 14}, {266, 98, 4, 14}, 
  {347, 98, 5, 14}, {449, 98, 5, 14}, {472, 98, 4, 14}, {190, 112, 4, 14}, 
  {231, 112, 4, 14}, {277, 112, 4, 14}, {355, 112, 5, 14}, {401, 112, 5, 14}, 
  {432, 112, 4, 14}, {464, 112, 4, 14}, {514, 112, 5, 14}, {67, 126, 5, 14}, 
  {147, 126, 5, 14}, {252, 126, 5, 14}, {282, 126, 5, 14}, {293, 126, 6, 14}, 
  {305, 126, 5, 14}, {337, 126, 4, 14}, {341, 126, 5, 14}, {428, 126, 4, 14}, 
  {80, 140, 5, 14}, {157, 140, 5, 14}, {74, 153, 5, 15}, {149, 153, 5, 15}, 
  {197, 153, 5, 15}, {301, 153, 5, 15}, {438, 153, 4, 15}, {518, 153, 5, 15}, 
  {167, 167, 4, 14}, {251, 167, 5, 14}, {398, 167, 5, 14}, {527, 167, 5, 14}, 
  {69, 181, 5, 14}, {248, 181, 5, 14}, {395, 181, 4, 14}, {433, 181, 5, 14}, 
  {478, 181, 5, 14}, {489, 181, 5, 14}, {80, 195, 4, 14}, {169, 195, 4, 14}, 
  {229, 195, 5, 14}, {395, 195, 5, 14}, {111, 209, 4, 14}, {130, 209, 5, 14}, 
  {310, 209, 5, 14}, {421, 209, 5, 14}, {469, 209, 5, 14}, {78, 222, 4, 15}, 
  {218, 222, 4, 15}, {270, 222, 4, 15}, {328, 222, 5, 15}, {418, 222, 4, 15}, 
  {446, 222, 5, 15}, {493, 222, 5, 15}, {161, 236, 7, 14}, {299, 236, 5, 14}, 
  {369, 236, 4, 14}, {400, 236, 5, 14}, {495, 236, 7, 14}, {67, 250, 5, 14}, 
  {344, 250, 5, 14}, {393, 250, 4, 14}, {74, 264, 5, 14}, {109, 264, 4, 14}, 
  {188, 264, 5, 14}, {219, 264, 5, 14}, {449, 264, 5, 14}, {475, 264, 4, 14}, 
  {129, 278, 4, 14}, {260, 278, 5, 14}, {340, 278, 5, 14}, {378, 278, 5, 14}, 
  {416, 278, 5, 14}, {464, 278, 5, 14}, {487, 278, 5, 14}, {153, 291, 5, 15}, 
  {175, 291, 5, 15}, {336, 291, 4, 15}, {380, 291, 4, 15}, {407, 291, 5, 15}, 
  {415, 291, 5, 15}, {462, 291, 4, 15}, {493, 291, 5, 15}, {533, 291, 6, 15}, 
  {80, 305, 4, 14}, {288, 305, 5, 14}, {366, 305, 5, 14}, {459, 305, 4, 14}, 
  {506, 305, 4, 14}, {516, 305, 6, 14}, {56, 319, 5, 14}, {56, 333, 7, 14}, 
  {149, 333, 5, 14}, {174, 333, 4, 14}, {187, 333, 5, 14}, {223, 333, 5, 14}, 
  {262, 333, 5, 14}, {357, 333, 4, 14}, {481, 333, 5, 14}, {151, 347, 5, 14}, 
  {379, 347, 5, 14}, {471, 347, 5, 14}, {66, 360, 4, 15}, {192, 360, 5, 15}, 
  {288, 360, 5, 15}, {324, 360, 5, 15}, {341, 360, 5, 15}, {410, 360, 5, 15}, 
  {442, 360, 5, 15}, {94, 374, 5, 14}, {126, 374, 5, 14}, {247, 374, 5, 14}, 
  {397, 374, 5, 14}, {450, 374, 5, 14}, {473, 374, 5, 14}, {81, 388, 5, 14}, 
  {86, 388, 4, 14}, {134, 388, 5, 14}, {216, 388, 5, 14}, {437, 388, 5, 14}, 
  {481, 388, 5, 14}, {239, 402, 4, 14}, {306, 402, 4, 14}, {370, 402, 5, 14}, 
  {482, 402, 4, 14}, {514, 402, 6, 14}, {80, 416, 4, 14}, {113, 416, 4, 14}, 
  {183, 416, 5, 14}, {251, 429, 5, 15}, {100, 443, 4, 14}, {136, 443, 5, 14}, 
  {319, 443, 5, 14}, {106, 457, 5, 14}, {117, 457, 5, 14}, {248, 457, 5, 14}, 
  {316, 457, 4, 14}, {362, 457, 5, 14}, {406, 457, 4, 14}, {465, 457, 5, 14}, 
  {129, 471, 5, 14}, {140, 471, 6, 14}, {175, 471, 5, 14}, {260, 471, 5, 14}, 
  {290, 471, 5, 14}, {415, 471, 4, 14}, {425, 471, 5, 14}, {468, 471, 5, 14}, 
  {90, 485, 5, 14}, {103, 485, 5, 14}, {147, 485, 4, 14}, {171, 485, 5, 14}, 
  {184, 485, 5, 14}, {259, 485, 5, 14}, {328, 485, 5, 14}, {432, 485, 5, 14}, 
  {104, 498, 5, 15}, {139, 498, 5, 15}, {347, 512, 5, 14}, {352, 512, 4, 14}, 
  {368, 512, 6, 14}, {446, 512, 4, 14}, {87, 526, 5, 14}, {296, 526, 5, 14}, 
  {301, 526, 5, 14}, {379, 526, 5, 14}, {469, 526, 5, 14}, {201, 540, 5, 14}, 
  {209, 540, 5, 14}, {222, 540, 5, 14}, {309, 540, 4, 14}, {358, 540, 5, 14}, 
  {389, 540, 5, 14}, {468, 540, 5, 14}, {123, 554, 5, 14}, {151, 554, 4, 14}, 
  {237, 554, 5, 14}, {268, 554, 5, 14}, {298, 554, 5, 14}, {435, 554, 5, 14}, 
  {492, 554, 5, 14}, {56, 567, 5, 15}, {87, 567, 5, 15}, {95, 567, 4, 15}, 
  {159, 567, 4, 15}, {182, 567, 4, 15}, {251, 567, 4, 15}, {407, 567, 5, 15}, 
  {459, 567, 4, 15}, {469, 567, 5, 15}, {500, 567, 5, 15}, {71, 581, 5, 14}, 
  {114, 581, 5, 14}, {294, 581, 5, 14}, {311, 581, 5, 14}, {69, 595, 5, 14}, 
  {167, 595, 5, 14}, {214, 595, 5, 14}, {496, 595, 4, 14}, {110, 609, 4, 14}, 
  {242, 609, 5, 14}, {306, 609, 5, 14}, {344, 609, 4, 14}, {81, 57, 5, 14}, 
  {119, 57, 5, 14}, {192, 57, 4, 14}, {217, 57, 4, 14}, {247, 57, 5, 14}, 
  {402, 57, 5, 14}, {123, 73, 5, 15}, {267, 73, 4, 15}, {325, 73, 4, 15}, 
  {511, 73, 5, 15}, {86, 90, 4, 14}, {118, 90, 5, 14}, {126, 90, 5, 14}, 
  {256, 90, 5, 14}, {261, 90, 5, 14}, {318, 90, 4, 14}, {345, 90, 5, 14}, 
  {359, 90, 4, 14}, {366, 90, 5, 14}, {133, 106, 5, 15}, {141, 106, 5, 15}, 
  {220, 106, 5, 15}, {248, 106, 5, 15}, {271, 106, 5, 15}, {122, 130, 4, 14}, 
  {132, 130, 5, 14}, {168, 130, 5, 14}, {176, 130, 5, 14}, {212, 130, 4, 14}, 
  {225, 130, 5, 14}, {298, 130, 5, 14}, {335, 130, 7, 14}, {348, 130, 4, 14}, 
  {379, 130, 5, 14}, {384, 130, 4, 14}, {129, 147, 5, 14}, {159, 147, 4, 14}, 
  {191, 147, 4, 14}, {220, 147, 5, 14}, {231, 147, 6, 14}, {251, 147, 5, 14}, 
  {282, 147, 5, 14}, {370, 147, 5, 14}, {66, 163, 4, 14}, {229, 163, 5, 14}, 
  {260, 163, 4, 14}, {342, 163, 5, 14}, {406, 163, 4, 14}, {424, 163, 5, 14}, 
  {435, 163, 4, 14}, {473, 163, 5, 14}, {174, 180, 5, 14}, {241, 180, 5, 14}, 
  {332, 180, 4, 14}, {367, 180, 5, 14}, {413, 180, 5, 14}, {444, 180, 5, 14}, 
  {469, 180, 5, 14}, {74, 196, 5, 14}, {360, 196, 4, 14}, {370, 196, 5, 14}, 
  {436, 196, 5, 14}, {481, 196, 5, 14}, {112, 213, 5, 14}, {129, 213, 5, 14}, 
  {187, 229, 4, 14}, {253, 229, 4, 14}, {275, 229, 5, 14}, {303, 229, 4, 14}, 
  {409, 229, 5, 14}, {460, 229, 5, 14}, {145, 246, 5, 14}, {194, 246, 5, 14}, 
  {219, 246, 5, 14}, {436, 246, 4, 14}, {81, 262, 5, 15}, {86, 262, 4, 15}, 
  {145, 262, 4, 15}, {168, 262, 4, 15}, {233, 262, 4, 15}, {276, 262, 4, 15}, 
  {380, 262, 5, 15}, {507, 262, 5, 15}, {110, 302, 5, 15}, {165, 302, 5, 15}, 
  {296, 302, 5, 15}, {331, 302, 4, 15}, {391, 302, 5, 15}, {82, 319, 4, 14}, 
  {321, 319, 5, 14}, {383, 319, 5, 14}, {406, 319, 5, 14}, {465, 319, 5, 14}, 
  {127, 336, 4, 14}, {347, 336, 5, 14}, {394, 336, 5, 14}, {512, 336, 5, 14}, 
  {133, 352, 5, 14}, {156, 352, 4, 14}, {270, 352, 4, 14}, {105, 376, 5, 14}, 
  {246, 376, 5, 14}, {307, 376, 4, 14}, {358, 376, 5, 14}, {366, 376, 4, 14}, 
  {71, 392, 5, 14}, {130, 392, 4, 14}, {232, 392, 4, 14}, {347, 392, 5, 14}, 
  {370, 392, 4, 14}, {401, 392, 5, 14}, {478, 392, 5, 14}, {98, 409, 4, 14}, 
  {147, 409, 5, 14}, {164, 409, 5, 14}, {251, 409, 5, 14}, {273, 409, 5, 14}, 
  {342, 409, 5, 14}, {365, 409, 5, 14}, {394, 409, 4, 14}, {90, 425, 4, 15}, 
  {130, 425, 4, 15}, {168, 425, 5, 15}, {250, 425, 5, 15}, {261, 425, 4, 15}, 
  {366, 425, 5, 15}, {379, 425, 5, 15}, {485, 425, 5, 15}, {532, 425, 6, 15}, 
  {78, 442, 5, 14}, {164, 442, 5, 14}, {235, 442, 4, 14}, {272, 442, 5, 14}, 
  {449, 442, 5, 14}, {94, 458, 5, 15}, {141, 458, 4, 15}, {234, 458, 5, 15}, 
  {313, 458, 5, 15}, {417, 458, 5, 15}, {120, 475, 6, 14}, {165, 475, 5, 14}, 
  {173, 475, 5, 14}, {202, 475, 5, 14}, {94, 499, 5, 14}, {118, 499, 5, 14}, 
  {132, 499, 5, 14}, {150, 499, 5, 14}, {199, 499, 5, 14}, {456, 499, 5, 14}, 
  {500, 499, 5, 14}, {86, 515, 4, 14}, {93, 515, 5, 14}, {143, 515, 4, 14}, 
  {173, 515, 5, 14}, {267, 515, 4, 14}, {307, 515, 4, 14}, {329, 515, 5, 14}, 
  {359, 515, 4, 14}, {369, 515, 5, 14}, {411, 515, 4, 14}, {447, 515, 4, 14}, 
  {457, 515, 5, 14}, {84, 532, 5, 14}, {133, 532, 5, 14}, {161, 532, 5, 14}, 
  {236, 532, 4, 14}, {423, 532, 7, 14}, {459, 532, 5, 14}, {470, 532, 5, 14}, 
  {128, 548, 5, 14}, {202, 548, 5, 14}, {254, 548, 5, 14}, {143, 565, 4, 14}, 
  {171, 565, 5, 14}, {242, 565, 5, 14}, {253, 565, 5, 14}, {350, 565, 6, 14}, 
  {432, 565, 4, 14}, {497, 565, 4, 14}, {229, 581, 5, 14}, {460, 581, 5, 14}, 
  {292, 598, 5, 14}, {348, 598, 4, 14}, {480, 598, 5, 14}, {117, 614, 5, 15}, 
  {136, 614, 5, 15}, {303, 614, 5, 15}, {416, 614, 4, 15}, {440, 614, 5, 15}, 
  {453, 614, 5, 15}, {78, 638, 4, 14}, {322, 638, 5, 14}, {346, 638, 4, 14}, 
  {364, 638, 5, 14}, {433, 638, 5, 14}, {56, 654, 7, 15}, {131, 654, 4, 15}, 
  {138, 654, 5, 15}, {244, 654, 5, 15}, {290, 654, 5, 15}, {440, 654, 4, 15}, 
  {450, 654, 5, 15}, {56, 671, 7, 14}, {69, 671, 5, 14}, {100, 671, 5, 14}, 
  {105, 671, 5, 14}, {294, 671, 5, 14}, {438, 671, 5, 14}, {83, 688, 5, 14}, 
  {126, 688, 5, 14}, {175, 688, 5, 14}, {218, 688, 5, 14}, {439, 688, 4, 14}, 
  {514, 688, 5, 14}, {86, 704, 4, 14}, {136, 704, 5, 14}, {261, 704, 5, 14}, 
  {364, 704, 7, 14}, {403, 704, 5, 14}, {503, 704, 5, 14}, {80, 721, 4, 14}, 
  {115, 721, 4, 14}, {146, 721, 5, 14}, {217, 721, 5, 14}, {277, 721, 4, 14}, 
  {381, 721, 5, 14}, {443, 721, 5, 14}, {480, 721, 5, 14}, {530, 721, 6, 14}, 
  {68, 737, 5, 14}, {155, 737, 5, 14}, {211, 737, 4, 14}, {221, 737, 5, 14}, 
  {268, 737, 5, 14}, {345, 737, 5, 14}, {436, 737, 5, 14}, {80, 754, 5, 14}, 
  {194, 754, 5, 14}, {217, 754, 4, 14}, {290, 754, 5, 14}, {196, 57, 5, 14}, 
  {225, 57, 5, 14}, {253, 57, 5, 14}, {322, 57, 5, 14}, {330, 57, 5, 14}, 
  {68, 73, 5, 15}, {179, 73, 5, 15}, {220, 73, 5, 15}, {274, 73, 5, 15}, 
  {398, 73, 5, 15}, {409, 73, 5, 15}, {438, 73, 4, 15}, {463, 73, 4, 15}, 
  {492, 73, 5, 15}, {527, 73, 5, 15}, {124, 90, 5, 14}, {132, 90, 5, 14}, 
  {152, 90, 5, 14}, {257, 90, 4, 14}, {288, 90, 4, 14}, {429, 90, 4, 14}, 
  {439, 90, 5, 14}, {317, 106, 5, 15}, {322, 106, 5, 15}, {387, 106, 5, 15}, 
  {410, 106, 4, 15}, {86, 123, 5, 14}, {138, 123, 6, 14}, {237, 123, 5, 14}, 
  {333, 123, 5, 14}, {435, 123, 5, 14}, {443, 123, 4, 14}, {474, 123, 4, 14}, 
  {66, 140, 4, 14}, {199, 140, 5, 14}, {207, 140, 5, 14}, {78, 163, 4, 14}, 
  {379, 163, 5, 14}, {433, 163, 5, 14}, {487, 163, 5, 14}, {82, 180, 5, 14}, 
  {138, 180, 5, 14}, {195, 180, 5, 14}, {250, 180, 5, 14}, {317, 180, 5, 14}, 
  {476, 180, 4, 14}, {495, 180, 4, 14}, {162, 196, 5, 14}, {185, 196, 5, 14}, 
  {193, 196, 4, 14}, {203, 196, 5, 14}, {257, 196, 4, 14}, {298, 196, 4, 14}, 
  {308, 196, 7, 14}, {361, 196, 5, 14}, {381, 196, 5, 14}, {404, 196, 5, 14}, 
  {103, 213, 4, 14}, {110, 213, 5, 14}, {142, 213, 4, 14}, {244, 213, 5, 14}, 
  {163, 229, 5, 14}, {201, 229, 5, 14}, {226, 229, 5, 14}, {281, 229, 5, 14}, 
  {286, 229, 5, 14}, {302, 229, 7, 14}, {359, 229, 5, 14}, {83, 246, 5, 14}, 
  {138, 246, 5, 14}, {189, 246, 5, 14}, {250, 246, 5, 14}, {314, 246, 5, 14}, 
  {403, 246, 4, 14}, {452, 246, 5, 14}, {460, 246, 5, 14}, {505, 246, 5, 14}, 
  {74, 262, 4, 15}, {133, 262, 5, 15}, {163, 262, 4, 15}, {258, 262, 5, 15}, 
  {407, 262, 5, 15}, {418, 262, 4, 15}, {94, 279, 5, 14}, {135, 279, 4, 14}, 
  {193, 279, 5, 14}, {270, 279, 5, 14}, {281, 279, 5, 14}, {385, 279, 4, 14}, 
  {404, 279, 5, 14}, {485, 279, 4, 14}, {98, 295, 4, 15}, {147, 295, 5, 15}, 
  {164, 295, 5, 15}, {251, 295, 5, 15}, {273, 295, 5, 15}, {342, 295, 5, 15}, 
  {365, 295, 5, 15}, {81, 319, 5, 14}, {160, 319, 5, 14}, {310, 319, 5, 14}, 
  {376, 319, 5, 14}, {472, 319, 5, 14}, {483, 319, 5, 14}, {94, 336, 5, 14}, 
  {153, 336, 5, 14}, {200, 336, 5, 14}, {208, 336, 5, 14}, {269, 336, 5, 14}, 
  {291, 336, 5, 14}, {296, 336, 4, 14}, {389, 336, 4, 14}, {489, 336, 6, 14}, 
  {218, 352, 5, 14}, {329, 352, 5, 14}, {337, 352, 5, 14}, {407, 352, 5, 14}, 
  {442, 352, 4, 14}, {473, 352, 4, 14}, {480, 352, 5, 14}, {514, 352, 4, 14}, 
  {518, 352, 5, 14}, {74, 369, 4, 14}, {107, 369, 5, 14}, {118, 369, 5, 14}, 
  {150, 369, 7, 14}, {289, 369, 5, 14}, {358, 369, 5, 14}, {457, 369, 7, 14}, 
  {242, 385, 5, 14}, {255, 385, 5, 14}, {341, 385, 5, 14}, {462, 385, 5, 14}, 
  {514, 385, 7, 14}, {69, 402, 4, 14}, {182, 402, 4, 14}, {231, 402, 5, 14}, 
  {262, 402, 5, 14}, {312, 402, 4, 14}, {476, 402, 4, 14}, {483, 402, 5, 14}, 
  {494, 402, 5, 14}, {114, 418, 5, 15}, {122, 418, 5, 15}, {163, 418, 5, 15}, 
  {248, 418, 5, 15}, {331, 418, 5, 15}, {353, 418, 5, 15}, {417, 418, 5, 15}, 
  {436, 418, 5, 15}, {74, 442, 4, 14}, {110, 442, 4, 14}, {232, 442, 5, 14}, 
  {313, 442, 4, 14}, {419, 442, 4, 14}, {423, 442, 5, 14}, {95, 458, 5, 15}, 
  {112, 458, 5, 15}, {190, 458, 5, 15}, {304, 458, 5, 15}, {315, 458, 6, 15}, 
  {327, 458, 5, 15}, {359, 458, 4, 15}, {363, 458, 5, 15}, {409, 458, 5, 15}, 
  {447, 458, 4, 15}, {524, 458, 5, 15}, {56, 475, 5, 14}, {96, 475, 4, 14}, 
  {161, 475, 4, 14}, {202, 475, 7, 14}, {252, 475, 5, 14}, {275, 475, 5, 14}, 
  {315, 475, 5, 14}, {407, 475, 5, 14}, {421, 475, 4, 14}, {444, 475, 4, 14}, 
  {466, 475, 5, 14}, {96, 492, 4, 14}, {220, 492, 5, 14}, {290, 492, 5, 14}, 
  {377, 492, 5, 14}, {390, 492, 5, 14}, {473, 492, 5, 14}, {94, 508, 5, 14}, 
  {135, 508, 4, 14}, {183, 508, 5, 14}, {500, 508, 5, 14}, {113, 525, 5, 14}, 
  {221, 525, 7, 14}, {234, 525, 5, 14}, {265, 525, 5, 14}, {270, 525, 4, 14}, 
  {356, 525, 5, 14}, {405, 525, 4, 14}, {409, 525, 5, 14}, {95, 541, 5, 14}, 
  {126, 541, 4, 14}, {133, 541, 5, 14}, {163, 541, 4, 14}, {178, 541, 4, 14}, 
  {188, 541, 5, 14}, {245, 541, 4, 14}, {323, 541, 4, 14}, {358, 541, 6, 14}, 
  {410, 541, 5, 14}, {441, 541, 5, 14}, {492, 541, 5, 14}, {74, 558, 4, 14}, 
  {156, 558, 4, 14}, {261, 558, 5, 14}, {269, 558, 5, 14}, {331, 558, 5, 14}, 
  {385, 558, 5, 14}, {451, 558, 4, 14}, {459, 558, 4, 14}, {488, 558, 5, 14}, 
  {122, 574, 5, 14}, {158, 574, 4, 14}, {180, 574, 4, 14}, {300, 574, 5, 14}, 
  {369, 574, 5, 14}, {377, 574, 4, 14}, {406, 574, 5, 14}, {74, 598, 5, 14}, 
  {99, 598, 5, 14}, {110, 598, 5, 14}, {146, 598, 5, 14}, {157, 598, 5, 14}, 
  {257, 598, 5, 14}, {292, 598, 5, 14}, {418, 598, 5, 14}, {488, 598, 4, 14}, 
  {95, 614, 5, 15}, {135, 614, 5, 15}, {146, 614, 5, 15}, {163, 614, 5, 15}, 
  {298, 614, 5, 15}, {413, 614, 4, 15}, {417, 614, 5, 15}, {438, 614, 4, 15}, 
  {524, 614, 5, 15}, {239, 631, 5, 14}, {244, 631, 5, 14}, {322, 631, 4, 14}, 
  {348, 631, 5, 14}, {378, 631, 5, 14}, {518, 631, 4, 14}, {108, 647, 5, 15}, 
  {173, 647, 4, 15}, {236, 647, 5, 15}, {284, 647, 5, 15}, {388, 647, 5, 15}, 
  {398, 647, 5, 15}, {482, 647, 4, 15}, {72, 664, 4, 14}, {79, 664, 5, 14}, 
  {144, 664, 5, 14}, {229, 664, 5, 14}, {282, 664, 5, 14}, {446, 664, 5, 14}, 
  {526, 664, 5, 14}, {131, 681, 5, 14}, {234, 681, 5, 14}, {347, 681, 5, 14}, 
  {400, 681, 4, 14}, {454, 681, 4, 14}, {64, 697, 4, 14}, {74, 697, 5, 14}, 
  {108, 697, 5, 14}, {139, 697, 5, 14}, {151, 721, 5, 14}, {225, 721, 5, 14}, 
  {230, 721, 4, 14}, {257, 721, 5, 14}, {268, 721, 5, 14}, {311, 721, 5, 14}, 
  {56, 737, 5, 14}, {408, 737, 5, 14}, {462, 737, 5, 14}, {495, 737, 5, 14}, 
  {119, 754, 5, 14}, {139, 754, 5, 14}, {213, 754, 5, 14}, {245, 754, 5, 14}, 
  {303, 754, 4, 14}, {394, 754, 4, 14}, {476, 754, 5, 14}, {506, 754, 6, 14}, 
  {94, 770, 5, 15}, {355, 770, 5, 15}, {500, 770, 4, 15}, {71, 57, 5, 14}, 
  {76, 57, 4, 14}, {243, 57, 4, 14}, {268, 57, 4, 14}, {351, 57, 4, 14}, 
  {399, 57, 4, 14}, {448, 57, 4, 14}, {479, 57, 5, 14}, {98, 73, 5, 15}, 
  {190, 73, 5, 15}, {253, 73, 4, 15}, {289, 73, 5, 15}, {311, 73, 5, 15}, 
  {453, 73, 5, 15}, {512, 73, 5, 15}, {74, 90, 5, 14}, {114, 90, 5, 14}, 
  {328, 90, 5, 14}, {357, 90, 5, 14}, {481, 90, 5, 14}, {492, 90, 4, 14}, 
  {106, 106, 5, 15}, {193, 106, 5, 15}, {216, 106, 5, 15}, {239, 106, 5, 15}, 
  {275, 106, 5, 15}, {324, 106, 4, 15}, {347, 106, 4, 15}, {437, 106, 5, 15}, 
  {468, 106, 5, 15}, {106, 123, 5, 14}, {134, 123, 4, 14}, {144, 123, 5, 14}, 
  {195, 123, 5, 14}, {56, 147, 7, 14}, {202, 147, 5, 14}, {210, 147, 4, 14}, 
  {241, 147, 5, 14}, {281, 147, 5, 14}, {386, 147, 5, 14}, {411, 147, 5, 14}, 
  {474, 147, 4, 14}, {525, 147, 6, 14}, {81, 163, 5, 14}, {86, 163, 4, 14}, 
  {109, 163, 7, 14}, {122, 163, 4, 14}, {153, 163, 5, 14}, {158, 163, 4, 14}, 
  {182, 163, 5, 14}, {236, 163, 5, 14}, {259, 163, 5, 14}, {306, 163, 5, 14}, 
  {413, 163, 4, 14}, {430, 163, 4, 14}, {67, 180, 5, 14}, {167, 180, 5, 14}, 
  {269, 180, 5, 14}, {481, 180, 5, 14}, {486, 180, 5, 14}, {161, 196, 4, 14}, 
  {222, 196, 5, 14}, {282, 196, 5, 14}, {325, 196, 5, 14}, {386, 196, 5, 14}, 
  {432, 196, 5, 14}, {469, 196, 5, 14}, {480, 196, 5, 14}, {68, 213, 4, 14}, 
  {264, 213, 5, 14}, {311, 213, 5, 14}, {362, 213, 5, 14}, {393, 213, 5, 14}, 
  {151, 229, 5, 14}, {159, 229, 4, 14}, {190, 229, 5, 14}, {323, 229, 7, 14}, 
  {336, 229, 4, 14}, {367, 229, 5, 14}, {372, 229, 4, 14}, {498, 229, 6, 14}, 
  {153, 246, 5, 14}, {279, 246, 5, 14}, {287, 246, 5, 14}, {515, 246, 5, 14}, 
  {520, 246, 5, 14}, {105, 262, 5, 15}, {137, 262, 5, 15}, {187, 262, 5, 15}, 
  {233, 262, 4, 15}, {241, 262, 4, 15}, {248, 262, 5, 15}, {301, 262, 5, 15}, 
  {324, 262, 5, 15}, {411, 262, 4, 15}, {490, 262, 4, 15}, {81, 279, 5, 14}, 
  {86, 279, 4, 14}, {263, 279, 4, 14}, {309, 279, 5, 14}, {346, 279, 4, 14}, 
  {410, 279, 5, 14}, {56, 302, 7, 15}, {69, 302, 5, 15}, {100, 302, 5, 15}, 
  {105, 302, 5, 15}, {154, 302, 4, 15}, {191, 302, 5, 15}, {350, 302, 5, 15}, 
  {373, 302, 5, 15}, {497, 302, 5, 15}, {83, 319, 5, 14}, {149, 319, 5, 14}, 
  {177, 319, 5, 14}, {302, 319, 5, 14}, {325, 319, 4, 14}, {329, 319, 5, 14}, 
  {392, 319, 5, 14}, {475, 319, 4, 14}, {445, 336, 4, 14}, {499, 336, 4, 14}, 
  {74, 352, 5, 14}, {97, 352, 5, 14}, {231, 352, 5, 14}, {239, 352, 5, 14}, 
  {319, 352, 5, 14}, {387, 352, 5, 14}, {426, 352, 5, 14}, {492, 352, 4, 14}, 
  {89, 369, 4, 14}, {138, 369, 4, 14}, {194, 369, 4, 14}, {247, 369, 5, 14}, 
  {297, 369, 4, 14}, {316, 369, 5, 14}, {452, 369, 5, 14}, {493, 369, 5, 14}, 
  {521, 369, 5, 14}, {56, 385, 7, 14}, {178, 385, 5, 14}, {201, 385, 5, 14}, 
  {265, 385, 5, 14}, {318, 385, 5, 14}, {456, 385, 4, 14}, {506, 385, 4, 14}, 
  {120, 402, 5, 14}, {165, 402, 4, 14}, {175, 402, 5, 14}, {129, 425, 5, 15}, 
  {146, 425, 5, 15}, {192, 425, 4, 15}, {212, 425, 4, 15}, {243, 425, 5, 15}, 
  {268, 425, 5, 15}, {397, 425, 4, 15}, {477, 425, 5, 15}, {127, 442, 5, 14}, 
  {146, 442, 5, 14}, {227, 442, 5, 14}, {244, 442, 5, 14}, {284, 442, 5, 14}, 
  {376, 442, 5, 14}, {398, 442, 5, 14}, {484, 442, 5, 14}, {511, 442, 4, 14}, 
  {84, 458, 5, 15}, {112, 458, 4, 15}, {162, 458, 5, 15}, {175, 458, 5, 15}, 
  {207, 458, 5, 15}, {295, 458, 4, 15}, {313, 458, 5, 15}, {429, 458, 4, 15}, 
  {275, 475, 5, 14}, {119, 492, 5, 14}, {127, 492, 4, 14}, {192, 492, 4, 14}, 
  {200, 492, 4, 14}, {301, 492, 4, 14}, {395, 492, 5, 14}, {56, 508, 7, 14}, 
  {69, 508, 5, 14}, {100, 508, 5, 14}, {105, 508, 5, 14}, {199, 508, 4, 14}, 
  {261, 508, 4, 14}, {387, 508, 4, 14}, {455, 508, 4, 14}, {459, 508, 5, 14}, 
  {494, 508, 5, 14}, {95, 525, 5, 14}, {151, 525, 5, 14}, {375, 525, 4, 14}, 
  {392, 525, 4, 14}, {403, 525, 4, 14}, {432, 525, 5, 14}, {112, 541, 5, 14}, 
  {231, 541, 4, 14}, {235, 541, 5, 14}, {74, 565, 5, 14}, {166, 565, 5, 14}, 
  {177, 565, 4, 14}, {235, 565, 5, 14}, {266, 565, 5, 14}, {307, 565, 5, 14}, 
  {445, 565, 5, 14}, {477, 565, 5, 14}, {56, 581, 5, 14}, {174, 581, 4, 14}, 
  {304, 581, 4, 14}, {427, 581, 4, 14}, {131, 598, 7, 14}, {144, 598, 5, 14}, 
  {175, 598, 5, 14}, {180, 598, 5, 14}, {235, 598, 5, 14}, {264, 598, 5, 14}, 
  {313, 598, 4, 14}, {323, 598, 5, 14}, {501, 598, 4, 14}, {514, 598, 5, 14}, 
  {74, 638, 5, 14}, {123, 638, 5, 14}, {144, 638, 5, 14}, {217, 638, 5, 14}, 
  {225, 638, 5, 14}, {256, 638, 5, 14}, {281, 638, 5, 14}, {330, 638, 5, 14}, 
  {392, 638, 5, 14}, {397, 638, 5, 14}, {464, 638, 5, 14}, {489, 638, 5, 14}, 
  {199, 654, 5, 15}, {276, 654, 5, 15}, {330, 654, 5, 15}, {359, 654, 4, 15}, 
  {466, 654, 4, 15}, {491, 654, 5, 15}, {522, 654, 4, 15}, {100, 671, 4, 14}, 
  {143, 671, 5, 14}, {151, 671, 5, 14}, {207, 671, 5, 14}, {252, 671, 5, 14}, 
  {307, 671, 5, 14}, {352, 671, 5, 14}, {367, 671, 5, 14}, {378, 671, 4, 14}, 
  {405, 671, 5, 14}, {410, 671, 4, 14}, {477, 671, 4, 14}, {502, 671, 5, 14}, 
  {199, 688, 5, 14}, {276, 688, 5, 14}, {330, 688, 5, 14}, {422, 688, 5, 14}, 
  {73, 704, 5, 14}, {86, 704, 5, 14}, {110, 704, 4, 14}, {207, 704, 5, 14}, 
  {269, 704, 5, 14}, {307, 704, 5, 14}, {56, 728, 7, 14}, {327, 728, 4, 14}, 
  {384, 728, 4, 14}, {403, 728, 5, 14}, {470, 728, 5, 14}, {146, 744, 5, 14}, 
  {275, 744, 5, 14}, {433, 744, 5, 14}, {163, 761, 5, 14}, {251, 761, 5, 14}, 
  {300, 761, 5, 14}, {308, 761, 5, 14}, {137, 57, 4, 14}, {184, 57, 5, 14}, 
  {431, 57, 4, 14}, {482, 57, 5, 14}, {85, 73, 5, 15}, {96, 73, 5, 15}, 
  {237, 73, 4, 15}, {300, 73, 5, 15}, {371, 73, 5, 15}, {444, 73, 5, 15}, 
  {449, 73, 4, 15}, {527, 73, 4, 15}, {107, 90, 5, 14}, {200, 90, 4, 14}, 
  {239, 90, 4, 14}, {74, 113, 5, 15}, {166, 113, 5, 15}, {281, 113, 5, 15}, 
  {313, 113, 5, 15}, {374, 113, 5, 15}, {97, 130, 5, 14}, {125, 130, 5, 14}, 
  {133, 130, 4, 14}, {143, 130, 5, 14}, {190, 130, 4, 14}, {290, 130, 5, 14}, 
  {327, 130, 5, 14}, {418, 130, 5, 14}, {474, 130, 4, 14}, {71, 147, 5, 14}, 
  {76, 147, 4, 14}, {232, 147, 5, 14}, {266, 147, 4, 14}, {270, 147, 5, 14}, 
  {441, 147, 4, 14}, {302, 163, 4, 14}, {120, 187, 4, 14}, {195, 187, 4, 14}, 
  {295, 187, 5, 14}, {362, 187, 5, 14}, {462, 187, 5, 14}, {487, 187, 5, 14}, 
  {56, 203, 5, 14}, {88, 203, 4, 14}, {144, 203, 5, 14}, {209, 203, 5, 14}, 
  {262, 203, 5, 14}, {313, 203, 5, 14}, {365, 203, 5, 14}, {373, 203, 5, 14}, 
  {74, 220, 4, 14}, {192, 220, 5, 14}, {228, 220, 4, 14}, {259, 220, 5, 14}, 
  {295, 220, 5, 14}, {395, 220, 5, 14}, {406, 220, 5, 14}, {455, 220, 5, 14}, 
  {508, 220, 4, 14}, {231, 236, 5, 14}, {341, 236, 5, 14}, {420, 236, 5, 14}, 
  {431, 236, 4, 14}, {121, 253, 5, 14}, {150, 253, 5, 14}, {173, 253, 4, 14}, 
  {209, 253, 5, 14}, {237, 253, 4, 14}, {289, 253, 5, 14}, {320, 253, 5, 14}, 
  {373, 253, 5, 14}, {408, 253, 4, 14}, {431, 253, 4, 14}, {485, 253, 4, 14}, 
  {508, 253, 5, 14}, {170, 269, 5, 15}, {111, 293, 5, 14}, {119, 293, 5, 14}, 
  {310, 309, 4, 15}, {345, 309, 5, 15}, {394, 309, 5, 15}, {453, 309, 5, 15}, 
  {481, 309, 4, 15}, {510, 309, 5, 15}, {117, 326, 5, 14}, {156, 326, 4, 14}, 
  {239, 326, 5, 14}, {315, 326, 5, 14}, {365, 326, 4, 14}, {465, 326, 5, 14}, 
  {107, 343, 4, 14}, {114, 343, 5, 14}, {304, 343, 4, 14}, {382, 343, 5, 14}, 
  {500, 343, 5, 14}, {165, 359, 5, 14}, {281, 359, 5, 14}, {318, 359, 5, 14}, 
  {459, 359, 5, 14}, {517, 359, 5, 14}, {56, 376, 5, 14}, {88, 376, 4, 14}, 
  {94, 399, 5, 14}, {162, 399, 5, 14}, {185, 399, 5, 14}, {259, 399, 5, 14}, 
  {290, 399, 5, 14}, {380, 399, 4, 14}, {472, 399, 5, 14}, {522, 399, 5, 14}, 
  {245, 416, 4, 14}, {273, 416, 5, 14}, {343, 416, 5, 14}, {404, 416, 4, 14}, 
  {115, 432, 5, 15}, {129, 432, 4, 15}, {152, 432, 4, 15}, {162, 432, 5, 15}, 
  {204, 432, 5, 15}, {215, 432, 5, 15}, {246, 432, 4, 15}, {276, 432, 4, 15}, 
  {376, 432, 5, 15}, {402, 432, 5, 15}, {122, 449, 4, 14}, {129, 449, 5, 14}, 
  {206, 449, 5, 14}, {238, 449, 4, 14}, {287, 449, 5, 14}, {304, 449, 5, 14}, 
  {383, 449, 4, 14}, {409, 449, 4, 14}, {483, 449, 4, 14}, {151, 465, 5, 15}, 
  {241, 465, 5, 15}, {252, 465, 7, 15}, {319, 465, 4, 15}, {371, 465, 5, 15}, 
  {480, 465, 5, 15}, {56, 482, 5, 14}, {92, 482, 5, 14}, {132, 482, 5, 14}, 
  {175, 482, 5, 14}, {229, 482, 5, 14}, {273, 482, 5, 14}, {297, 482, 5, 14}, 
  {311, 482, 4, 14}, {462, 482, 4, 14}, {493, 482, 5, 14}, {68, 499, 4, 14}, 
  {133, 499, 4, 14}, {185, 499, 4, 14}, {193, 499, 4, 14}, {265, 499, 5, 14}, 
  {325, 499, 5, 14}, {359, 499, 5, 14}, {463, 499, 4, 14}, {492, 499, 5, 14}, 
  {509, 499, 5, 14}, {114, 515, 5, 14}, {156, 515, 5, 14}, {212, 515, 4, 14}, 
  {255, 515, 7, 14}, {268, 515, 4, 14}, {299, 515, 5, 14}, {304, 515, 4, 14}, 
  {332, 515, 5, 14}, {372, 515, 4, 14}, {158, 532, 4, 14}, {210, 532, 5, 14}, 
  {78, 555, 4, 14}, {155, 555, 5, 14}, {216, 555, 5, 14}, {247, 555, 5, 14}, 
  {344, 555, 5, 14}, {468, 555, 4, 14}, {481, 555, 4, 14}, {194, 572, 5, 14}, 
  {202, 572, 5, 14}, {282, 572, 5, 14}, {290, 572, 4, 14}, {309, 572, 4, 14}, 
  {373, 572, 4, 14}, {516, 572, 6, 14}, {177, 588, 5, 14}, {304, 588, 4, 14}, 
  {398, 588, 5, 14}, {458, 588, 5, 14}, {469, 588, 5, 14}, {516, 588, 6, 14}, 
  {164, 605, 5, 14}, {216, 605, 5, 14}, {266, 605, 5, 14}, {319, 605, 5, 14}, 
  {359, 605, 5, 14}, {395, 605, 5, 14}, {486, 605, 5, 14}, {504, 605, 5, 14}, 
  {120, 621, 4, 15}, {267, 621, 5, 15}, {364, 621, 4, 15}, {452, 621, 4, 15}, 
  {80, 638, 5, 14}, {206, 638, 5, 14}, {302, 638, 4, 14}, {359, 638, 5, 14}, 
  {382, 638, 4, 14}, {120, 654, 4, 15}, {127, 654, 5, 15}, {225, 654, 5, 15}, 
  {286, 654, 4, 15}, {323, 654, 5, 15}, {334, 654, 5, 15}, {345, 654, 4, 15}, 
  {385, 654, 5, 15}, {90, 671, 4, 14}, {108, 671, 5, 14}, {299, 671, 5, 14}, 
  {349, 671, 4, 14}, {406, 671, 4, 14}, {452, 671, 5, 14}, {484, 671, 5, 14}, 
  {74, 695, 5, 14}, {97, 695, 5, 14}, {144, 695, 4, 14}, {191, 695, 4, 14}, 
  {195, 695, 5, 14}, {291, 695, 5, 14}, {302, 695, 7, 14}, {315, 695, 4, 14}, 
  {346, 695, 4, 14}, {350, 695, 5, 14}, {390, 695, 5, 14}, {398, 695, 4, 14}, 
  {509, 695, 6, 14}, {105, 711, 7, 14}, {138, 711, 5, 14}, {190, 711, 5, 14}, 
  {371, 711, 5, 14}, {421, 711, 4, 14}, {431, 711, 5, 14}, {515, 711, 5, 14}, 
  {335, 728, 5, 14}, {399, 728, 5, 14}, {150, 744, 5, 14}, {204, 744, 5, 14}, 
  {69, 57, 5, 14}, {96, 57, 4, 14}, {106, 57, 5, 14}, {146, 57, 5, 14}, 
  {227, 57, 5, 14}, {331, 57, 5, 14}, {376, 57, 5, 14}, {435, 57, 4, 14}, 
  {492, 57, 6, 14}, {97, 73, 5, 15}, {213, 73, 5, 15}, {460, 73, 4, 15}, 
  {520, 73, 5, 15}, {90, 90, 5, 14}, {177, 90, 5, 14}, {188, 90, 5, 14}, 
  {196, 90, 4, 14}, {272, 90, 5, 14}, {304, 90, 5, 14}, {362, 90, 5, 14}, 
  {402, 90, 4, 14}, {499, 90, 5, 14}, {507, 90, 6, 14}, {81, 106, 5, 15}, 
  {89, 106, 5, 15}, {127, 106, 5, 15}, {138, 106, 7, 15}, {191, 106, 5, 15}, 
  {220, 106, 4, 15}, {249, 106, 5, 15}, {293, 106, 4, 15}, {311, 106, 5, 15}, 
  {428, 106, 5, 15}, {461, 106, 4, 15}, {465, 106, 5, 15}, {507, 106, 6, 15}, 
  {148, 123, 7, 14}, {194, 123, 5, 14}, {232, 123, 4, 14}, {250, 123, 5, 14}, 
  {325, 123, 4, 14}, {377, 123, 4, 14}, {476, 123, 5, 14}, {524, 123, 6, 14}, 
  {319, 140, 5, 14}, {330, 140, 4, 14}, {519, 140, 6, 14}, {107, 156, 4, 14}, 
  {117, 156, 5, 14}, {133, 156, 5, 14}, {201, 156, 5, 14}, {278, 156, 5, 14}, 
  {334, 156, 5, 14}, {342, 156, 5, 14}, {451, 156, 5, 14}, {468, 156, 5, 14}, 
  {94, 180, 5, 14}, {162, 180, 4, 14}, {169, 180, 5, 14}, {218, 180, 5, 14}, 
  {278, 180, 4, 14}, {315, 180, 5, 14}, {389, 180, 4, 14}, {415, 180, 5, 14}, 
  {84, 196, 5, 14}, {216, 196, 5, 14}, {274, 196, 5, 14}, {299, 196, 5, 14}, 
  {330, 196, 4, 14}, {337, 196, 5, 14}, {393, 196, 4, 14}, {397, 196, 5, 14}, 
  {115, 213, 5, 14}, {214, 213, 4, 14}, {277, 213, 4, 14}, {332, 213, 4, 14}, 
  {408, 213, 4, 14}, {446, 213, 5, 14}, {460, 213, 5, 14}, {80, 229, 5, 14}, 
  {157, 229, 5, 14}, {190, 229, 4, 14}, {194, 229, 5, 14}, {377, 229, 5, 14}, 
  {388, 229, 6, 14}, {478, 229, 5, 14}, {95, 246, 5, 14}, {163, 246, 5, 14}, 
  {299, 246, 5, 14}, {324, 246, 5, 14}, {395, 246, 6, 14}, {407, 246, 5, 14}, 
  {439, 246, 4, 14}, {443, 246, 5, 14}, {456, 246, 5, 14}, {116, 262, 4, 15}, 
  {169, 262, 5, 15}, {209, 262, 5, 15}, {241, 262, 5, 15}, {281, 262, 5, 15}, 
  {304, 262, 4, 15}, {308, 262, 5, 15}, {380, 262, 5, 15}, {388, 262, 5, 15}, 
  {410, 262, 5, 15}, {442, 262, 7, 15}, {78, 279, 4, 14}, {88, 279, 5, 14}, 
  {109, 302, 4, 15}, {126, 302, 4, 15}, {137, 302, 4, 15}, {161, 302, 5, 15}, 
  {332, 302, 5, 15}, {387, 302, 5, 15}, {416, 302, 5, 15}, {448, 302, 5, 15}, 
  {488, 302, 4, 15}, {85, 319, 5, 14}, {154, 319, 4, 14}, {241, 319, 4, 14}, 
  {308, 319, 5, 14}, {316, 319, 5, 14}, {451, 319, 5, 14}, {481, 319, 5, 14}, 
  {492, 319, 4, 14}, {68, 336, 5, 14}, {159, 336, 4, 14}, {243, 336, 5, 14}, 
  {266, 336, 5, 14}, {297, 336, 5, 14}, {332, 336, 5, 14}, {449, 336, 4, 14}, 
  {459, 336, 5, 14}, {167, 352, 4, 14}, {289, 352, 5, 14}, {351, 352, 4, 14}, 
  {406, 352, 5, 14}, {503, 352, 6, 14}, {80, 369, 4, 14}, {195, 369, 5, 14}, 
  {249, 369, 5, 14}, {303, 369, 4, 14}, {352, 369, 4, 14}, {408, 369, 4, 14}, 
  {463, 369, 4, 14}, {494, 369, 5, 14}, {64, 385, 4, 14}, {74, 385, 5, 14}, 
  {162, 385, 4, 14}, {193, 385, 5, 14}, {299, 385, 5, 14}, {389, 385, 5, 14}, 
  {438, 385, 5, 14}, {455, 385, 5, 14}, {86, 402, 5, 14}, {108, 402, 5, 14}, 
  {177, 402, 5, 14}, {200, 402, 5, 14}, {250, 402, 4, 14}, {308, 402, 5, 14}, 
  {387, 402, 5, 14}, {513, 402, 6, 14}, {204, 418, 5, 15}, {265, 418, 5, 15}, 
  {331, 418, 5, 15}, {398, 418, 5, 15}, {420, 418, 5, 15}, {457, 418, 4, 15}, 
  {531, 418, 6, 15}, {76, 435, 5, 14}, {84, 435, 5, 14}, {95, 435, 4, 14}, 
  {106, 458, 5, 15}, {117, 458, 4, 15}, {160, 458, 5, 15}, {239, 458, 5, 15}, 
  {283, 458, 5, 15}, {338, 458, 4, 15}, {342, 458, 5, 15}, {380, 458, 5, 15}, 
  {385, 458, 4, 15}, {433, 458, 4, 15}, {437, 458, 5, 15}, {488, 458, 5, 15}, 
  {103, 475, 5, 14}, {290, 475, 5, 14}, {319, 475, 6, 14}, {349, 475, 5, 14}, 
  {438, 475, 5, 14}, {56, 492, 5, 14}, {129, 492, 4, 14}, {204, 492, 4, 14}, 
  {279, 492, 4, 14}, {495, 492, 4, 14}, {140, 508, 5, 14}, {267, 508, 5, 14}, 
  {299, 508, 5, 14}, {307, 508, 5, 14}, {337, 508, 5, 14}, {418, 508, 5, 14}, 
  {465, 508, 5, 14}, {80, 525, 5, 14}, {139, 525, 5, 14}, {188, 525, 4, 14}, 
  {195, 525, 5, 14}, {227, 525, 4, 14}, {274, 525, 5, 14}, {351, 525, 5, 14}, 
  {374, 525, 5, 14}, {385, 525, 4, 14}, {413, 525, 5, 14}, {465, 525, 5, 14}, 
  {476, 525, 5, 14}, {512, 525, 6, 14}, {129, 541, 4, 14}, {198, 541, 4, 14}, 
  {205, 541, 5, 14}, {278, 541, 5, 14}, {389, 541, 5, 14}, {418, 541, 5, 14}, 
  {471, 541, 4, 14}, {99, 558, 4, 14}, {130, 558, 5, 14}, {166, 558, 5, 14}, 
  {206, 558, 5, 14}, {249, 558, 5, 14}, {303, 558, 5, 14}, {347, 558, 5, 14}, 
  {371, 558, 5, 14}, {385, 558, 4, 14}, {395, 558, 7, 14}, {428, 558, 5, 14}, 
  {515, 558, 6, 14}, {81, 574, 5, 14}, {304, 574, 5, 14}, {493, 574, 5, 14}, 
  {132, 591, 5, 14}, {140, 591, 5, 14}, {232, 591, 5, 14}, {74, 614, 5, 15}, 
  {249, 614, 4, 15}, {259, 614, 5, 15}, {328, 614, 5, 15}, {357, 614, 5, 15}, 
  {404, 614, 4, 15}, {432, 614, 5, 15}, {484, 614, 5, 15}, {507, 614, 6, 15}, 
  {80, 631, 4, 14}, {111, 631, 5, 14}, {160, 631, 4, 14}, {187, 631, 5, 14}, 
  {243, 631, 5, 14}, {334, 631, 5, 14}, {412, 631, 4, 14}, {78, 647, 4, 15}, 
  {121, 647, 5, 15}, {132, 647, 5, 15}, {207, 647, 5, 15}, {215, 647, 5, 15}, 
  {357, 647, 4, 15}, {361, 647, 5, 15}, {396, 647, 4, 15}, {465, 647, 5, 15}, 
  {470, 647, 5, 15}, {80, 664, 5, 14}, {186, 664, 5, 14}, {227, 664, 5, 14}, 
  {306, 664, 5, 14}, {346, 664, 5, 14}, {414, 664, 5, 14}, {465, 664, 5, 14}, 
  {100, 681, 5, 14}, {111, 681, 4, 14}, {159, 681, 4, 14}, {226, 681, 5, 14}, 
  {454, 681, 4, 14}, {512, 681, 5, 14}, {72, 697, 4, 14}, {160, 697, 4, 14}, 
  {188, 697, 4, 14}, {195, 697, 5, 14}, {293, 697, 4, 14}, {297, 697, 5, 14}, 
  {359, 697, 4, 14}, {390, 697, 7, 14}, {403, 697, 4, 14}, {434, 697, 5, 14}, 
  {439, 697, 4, 14}, {56, 714, 5, 14}, {166, 714, 5, 14}, {171, 714, 5, 14}, 
  {292, 714, 5, 14}, {363, 714, 4, 14}, {533, 714, 6, 14}, {108, 730, 5, 14}, 
  {140, 730, 5, 14}, {148, 730, 5, 14}, {132, 754, 5, 14}, {224, 754, 4, 14}, 
  {287, 754, 5, 14}, {292, 754, 4, 14}, {359, 754, 4, 14}, {384, 754, 5, 14}, 
  {109, 770, 5, 15}, {186, 770, 5, 15}, {240, 770, 5, 15}, {358, 770, 4, 15}, 
  {453, 770, 4, 15}, {485, 770, 5, 15}, {490, 770, 4, 15}, {510, 770, 5, 15}, 
  {149, 57, 5, 14}, {154, 57, 5, 14}, {225, 57, 5, 14}, {233, 57, 5, 14}, 
  {241, 57, 5, 14}, {291, 57, 5, 14}, {391, 57, 5, 14}, {86, 73, 5, 15}, 
  {206, 73, 5, 15}, {281, 73, 5, 15}, {382, 73, 5, 15}, {102, 90, 5, 14}, 
  {137, 90, 5, 14}, {145, 90, 5, 14}, {320, 90, 4, 14}, {337, 90, 4, 14}, 
  {369, 90, 4, 14}, {376, 90, 5, 14}, {387, 90, 5, 14}, {416, 90, 5, 14}, 
  {460, 90, 5, 14}, {482, 90, 4, 14}, {80, 106, 4, 15}, {113, 106, 7, 15}, 
  {363, 106, 5, 15}, {439, 106, 5, 15}, {82, 123, 4, 14}, {185, 123, 4, 14}, 
  {257, 123, 5, 14}, {286, 123, 5, 14}, {294, 123, 5, 14}, {387, 123, 4, 14}, 
  {135, 140, 4, 14}, {203, 140, 5, 14}, {142, 163, 5, 14}, {252, 163, 5, 14}, 
  {257, 163, 5, 14}, {340, 163, 5, 14}, {406, 163, 4, 14}, {442, 163, 5, 14}, 
  {229, 180, 5, 14}, {237, 180, 5, 14}, {286, 180, 4, 14}, {375, 180, 4, 14}, 
  {382, 180, 5, 14}, {405, 180, 4, 14}, {448, 180, 5, 14}, {453, 180, 5, 14}, 
  {56, 196, 5, 14}, {67, 196, 5, 14}, {111, 196, 4, 14}, {115, 196, 5, 14}, 
  {144, 196, 4, 14}, {188, 196, 5, 14}, {211, 196, 4, 14}, {240, 196, 4, 14}, 
  {298, 196, 5, 14}, {323, 196, 6, 14}, {335, 196, 5, 14}, {367, 196, 4, 14}, 
  {371, 196, 5, 14}, {66, 213, 4, 14}, {192, 213, 4, 14}, {315, 213, 5, 14}, 
  {360, 213, 5, 14}, {384, 213, 5, 14}, {411, 213, 5, 14}, {469, 213, 4, 14}, 
  {486, 213, 4, 14}, {497, 213, 4, 14}, {56, 229, 5, 14}, {87, 229, 5, 14}, 
  {127, 229, 4, 14}, {137, 229, 7, 14}, {198, 229, 5, 14}, {272, 229, 4, 14}, 
  {428, 229, 5, 14}, {74, 246, 5, 14}, {97, 246, 5, 14}, {129, 246, 4, 14}, 
  {248, 246, 4, 14}, {389, 246, 4, 14}, {461, 246, 4, 14}, {222, 262, 5, 15}, 
  {257, 262, 5, 15}, {398, 262, 5, 15}, {421, 262, 5, 15}, {456, 262, 4, 15}, 
  {111, 279, 4, 14}, {124, 279, 5, 14}, {132, 279, 4, 14}, {233, 279, 4, 14}, 
  {281, 279, 5, 14}, {286, 279, 4, 14}, {299, 279, 4, 14}, {125, 302, 4, 15}, 
  {158, 302, 5, 15}, {163, 302, 5, 15}, {255, 302, 5, 15}, {266, 302, 7, 15}, 
  {279, 302, 5, 15}, {310, 302, 5, 15}, {315, 302, 4, 15}, {328, 302, 4, 15}, 
  {505, 302, 5, 15}, {186, 319, 5, 14}, {209, 319, 4, 14}, {320, 319, 5, 14}, 
  {349, 319, 5, 14}, {370, 319, 4, 14}, {439, 319, 5, 14}, {197, 336, 5, 14}, 
  {253, 336, 5, 14}, {346, 336, 5, 14}, {501, 336, 5, 14}, {524, 336, 5, 14}, 
  {80, 352, 4, 14}, {146, 352, 4, 14}, {232, 352, 5, 14}, {353, 352, 5, 14}, 
  {200, 376, 4, 14}, {231, 376, 5, 14}, {272, 376, 5, 14}, {393, 376, 4, 14}, 
  {78, 392, 5, 14}, {101, 392, 5, 14}, {154, 392, 5, 14}, {186, 392, 4, 14}, 
  {470, 392, 4, 14}, {86, 409, 4, 14}, {129, 409, 5, 14}, {264, 409, 5, 14}, 
  {307, 409, 5, 14}, {516, 409, 5, 14}, {83, 425, 5, 15}, {130, 425, 4, 15}, 
  {340, 425, 4, 15}, {444, 425, 5, 15}, {467, 425, 4, 15}, {64, 442, 4, 14}, 
  {74, 442, 5, 14}, {139, 442, 5, 14}, {215, 442, 5, 14}, {220, 442, 5, 14}, 
  {298, 442, 4, 14}, {394, 442, 4, 14}, {448, 442, 5, 14}, {502, 442, 4, 14}, 
  {82, 458, 5, 15}, {138, 458, 5, 15}, {260, 458, 4, 15}, {264, 458, 5, 15}, 
  {365, 458, 5, 15}, {56, 482, 7, 14}, {114, 482, 4, 14}, {151, 482, 7, 14}, 
  {203, 482, 5, 14}, {235, 482, 5, 14}, {338, 482, 4, 14}, {348, 482, 5, 14}, 
  {391, 482, 5, 14}, {426, 482, 5, 14}, {515, 482, 6, 14}, {79, 499, 5, 14}, 
  {125, 499, 4, 14}, {135, 499, 5, 14}, {246, 499, 5, 14}, {272, 499, 5, 14}, 
  {300, 499, 5, 14}, {308, 499, 4, 14}, {338, 499, 5, 14}, {349, 499, 4, 14}, 
  {444, 499, 4, 14}, {488, 499, 4, 14}, {506, 499, 5, 14}, {92, 515, 5, 14}, 
  {131, 515, 4, 14}, {196, 515, 5, 14}, {201, 515, 4, 14}, {389, 515, 4, 14}, 
  {465, 515, 5, 14}, {97, 532, 5, 14}, {274, 532, 5, 14}, {288, 532, 6, 14}, 
  {375, 532, 5, 14}, {437, 532, 5, 14}, {468, 532, 5, 14}, {497, 532, 4, 14}, 
  {86, 548, 4, 14}, {190, 548, 5, 14}, {356, 548, 5, 14}, {418, 548, 4, 14}, 
  {71, 565, 5, 14}, {229, 565, 5, 14}, {261, 565, 4, 14}, {327, 565, 5, 14}, 
  {350, 565, 5, 14}, {360, 565, 5, 14}, {83, 581, 5, 14}, {106, 581, 5, 14}, 
  {117, 581, 4, 14}, {143, 581, 5, 14}, {151, 581, 5, 14}, {196, 581, 5, 14}, 
  {274, 581, 4, 14}, {382, 581, 5, 14}, {420, 581, 4, 14}, {443, 581, 4, 14}, 
  {69, 605, 5, 14}, {146, 605, 5, 14}, {195, 605, 5, 14}, {251, 605, 5, 14}, 
  {305, 605, 4, 14}, {354, 605, 5, 14}, {374, 605, 5, 14}, {137, 621, 4, 15}, 
  {177, 621, 5, 15}, {234, 621, 5, 15}, {278, 621, 4, 15}, {288, 621, 5, 15}, 
  {338, 621, 5, 15}, {390, 621, 5, 15}, {398, 621, 4, 15}, {506, 621, 5, 15}, 
  {115, 638, 5, 14}, {207, 638, 4, 14}, {217, 638, 5, 14}, {265, 638, 5, 14}, 
  {369, 638, 5, 14}, {91, 654, 5, 15}, {129, 654, 4, 15}, {252, 654, 5, 15}, 
  {263, 654, 5, 15}, {372, 654, 5, 15}, {404, 654, 4, 15}, {73, 671, 5, 14}, 
  {86, 671, 5, 14}, {109, 671, 5, 14}, {140, 671, 5, 14}, {237, 671, 5, 14}, 
  {327, 671, 4, 14}, {376, 671, 5, 14}, {393, 671, 5, 14}, {480, 671, 5, 14}, 
  {502, 671, 5, 14}, {94, 688, 4, 14}, {117, 688, 4, 14}, {145, 688, 5, 14}, 
  {153, 688, 5, 14}, {284, 688, 5, 14}, {331, 688, 5, 14}, {370, 688, 4, 14}, 
  {383, 688, 5, 14}, {406, 688, 5, 14}, {437, 688, 4, 14}, {141, 704, 4, 14}, 
  {351, 704, 5, 14}, {74, 728, 5, 14}, {210, 728, 5, 14}, {328, 728, 5, 14}, 
  {339, 728, 7, 14}, {352, 728, 4, 14}, {383, 728, 5, 14}, {388, 728, 4, 14}, 
  {476, 728, 5, 14}, {156, 744, 5, 14}, {297, 744, 5, 14}, {338, 744, 5, 14}, 
  {369, 744, 5, 14}, {409, 744, 5, 14}, {414, 744, 4, 14}, {430, 744, 6, 14}, 
  {442, 744, 5, 14}, {474, 744, 4, 14}, {478, 744, 5, 14}, {56, 761, 5, 14}, 
  {181, 761, 5, 14}, {301, 761, 5, 14}, {332, 761, 5, 14}, {397, 761, 5, 14}, 
  {428, 761, 5, 14}, {461, 761, 4, 14}, {471, 761, 5, 14}, {500, 761, 5, 14}, 
  {523, 761, 5, 14}, {110, 57, 5, 14}, {207, 57, 5, 14}, {227, 57, 5, 14}, 
  {438, 57, 5, 14}, {449, 57, 5, 14}, {487, 57, 4, 14}, {510, 57, 5, 14}, 
  {72, 73, 4, 15}, {91, 73, 5, 15}, {193, 73, 5, 15}, {333, 73, 5, 15}, 
  {390, 73, 5, 15}, {442, 73, 4, 15}, {446, 73, 5, 15}, {129, 90, 4, 14}, 
  {197, 90, 4, 14}, {228, 90, 5, 14}, {348, 90, 4, 14}, {421, 90, 4, 14}, 
  {479, 90, 5, 14}, {490, 90, 5, 14}, {121, 106, 4, 15}, {131, 106, 7, 15}, 
  {152, 106, 5, 15}, {182, 106, 4, 15}, {319, 106, 5, 15}, {500, 106, 6, 15}, 
  {56, 123, 5, 14}, {87, 123, 5, 14}, {216, 123, 4, 14}, {226, 123, 5, 14}, 
  {273, 123, 4, 14}, {277, 123, 5, 14}, {441, 123, 5, 14}, {484, 123, 5, 14}, 
  {78, 140, 5, 14}, {137, 140, 5, 14}, {370, 140, 5, 14}, {378, 140, 5, 14}, 
  {459, 140, 5, 14}, {516, 140, 6, 14}, {72, 156, 4, 14}, {82, 156, 5, 14}, 
  {163, 156, 4, 14}, {213, 156, 5, 14}, {321, 156, 5, 14}, {411, 156, 5, 14}, 
  {434, 156, 5, 14}, {445, 156, 5, 14}, {80, 173, 4, 14}, {110, 173, 5, 14}, 
  {147, 173, 5, 14}, {152, 173, 4, 14}, {95, 196, 5, 14}, {253, 196, 4, 14}, 
  {305, 196, 5, 14}, {345, 196, 4, 14}, {386, 196, 5, 14}, {440, 196, 5, 14}, 
  {80, 213, 5, 14}, {163, 213, 5, 14}, {191, 213, 5, 14}, {256, 213, 5, 14}, 
  {313, 213, 4, 14}, {357, 213, 4, 14}, {487, 213, 5, 14}, {93, 229, 5, 14}, 
  {172, 229, 5, 14}, {230, 229, 5, 14}, {415, 229, 5, 14}, {454, 229, 5, 14}, 
  {504, 229, 5, 14}, {333, 246, 5, 14}, {416, 246, 5, 14}, {465, 246, 5, 14}, 
  {108, 262, 5, 15}, {172, 262, 5, 15}, {218, 262, 5, 15}, {247, 262, 5, 15}, 
  {312, 262, 5, 15}, {335, 262, 4, 15}, {430, 262, 5, 15}, {495, 262, 5, 15}, 
  {186, 279, 5, 14}, {292, 279, 7, 14}, {305, 279, 4, 14}, {336, 279, 5, 14}, 
  {341, 279, 4, 14}, {419, 279, 5, 14}, {430, 279, 5, 14}, {186, 302, 5, 15}, 
  {215, 302, 5, 15}, {284, 302, 5, 15}, {317, 302, 4, 15}, {459, 302, 5, 15}, 
  {464, 302, 4, 15}, {90, 319, 5, 14}, {113, 319, 5, 14}, {236, 319, 5, 14}, 
  {259, 319, 5, 14}, {330, 319, 4, 14}, {347, 319, 4, 14}, {405, 319, 4, 14}, 
  {453, 319, 5, 14}, {495, 319, 4, 14}, {72, 336, 4, 14}, {197, 336, 5, 14}, 
  {264, 336, 4, 14}, {346, 336, 4, 14}, {356, 336, 5, 14}, {386, 336, 4, 14}, 
  {488, 336, 5, 14}, {72, 352, 5, 14}, {150, 352, 5, 14}, {173, 352, 5, 14}, 
  {493, 352, 5, 14}, {81, 369, 5, 14}, {86, 369, 4, 14}, {188, 369, 5, 14}, 
  {257, 369, 5, 14}, {427, 369, 4, 14}, {437, 369, 5, 14}, {477, 369, 5, 14}, 
  {94, 409, 5, 14}, {102, 409, 5, 14}, {205, 409, 5, 14}, {229, 409, 5, 14}, 
  {258, 409, 4, 14}, {341, 409, 5, 14}, {346, 409, 4, 14}, {386, 409, 4, 14}, 
  {436, 409, 4, 14}, {491, 409, 5, 14}, {283, 425, 4, 15}, {291, 425, 4, 15}, 
  {306, 425, 4, 15}, {316, 425, 5, 15}, {357, 425, 4, 15}, {455, 425, 5, 15}, 
  {472, 425, 5, 15}, {146, 442, 5, 14}, {262, 442, 5, 14}, {492, 442, 5, 14}, 
  {503, 442, 5, 14}, {94, 458, 5, 15}, {122, 458, 4, 15}, {133, 458, 4, 15}, 
  {152, 458, 4, 15}, {198, 458, 5, 15}, {206, 458, 5, 15}, {250, 458, 5, 15}, 
  {258, 458, 5, 15}, {312, 458, 4, 15}, {393, 458, 5, 15}, {439, 458, 5, 15}, 
  {80, 475, 4, 14}, {113, 475, 7, 14}, {160, 475, 4, 14}, {272, 475, 5, 14}, 
  {321, 475, 4, 14}, {481, 475, 6, 14}, {125, 492, 4, 14}, {204, 492, 6, 14}, 
  {249, 492, 5, 14}, {254, 492, 5, 14}, {321, 492, 5, 14}, {332, 492, 5, 14}, 
  {459, 492, 5, 14}, {531, 492, 5, 14}, {72, 508, 4, 14}, {134, 508, 5, 14}, 
  {218, 508, 7, 14}, {231, 508, 5, 14}, {262, 508, 5, 14}, {267, 508, 5, 14}, 
  {351, 508, 5, 14}, {374, 508, 5, 14}, {405, 508, 5, 14}, {276, 532, 5, 14}, 
  {287, 532, 6, 14}, {308, 532, 4, 14}, {378, 532, 5, 14}, {386, 532, 4, 14}, 
  {455, 532, 4, 14}, {96, 548, 4, 14}, {286, 548, 5, 14}, {297, 548, 4, 14}, 
  {418, 548, 5, 14}, {480, 548, 4, 14}, {509, 548, 5, 14}, {88, 565, 5, 14}, 
  {124, 565, 5, 14}, {174, 565, 5, 14}, {188, 565, 4, 14}, {267, 565, 5, 14}, 
  {272, 565, 4, 14}, {301, 565, 5, 14}, {56, 581, 5, 14}, {100, 581, 5, 14}, 
  {149, 581, 5, 14}, {347, 581, 5, 14}, {410, 581, 5, 14}, {108, 605, 5, 14}, 
  {183, 605, 5, 14}, {224, 605, 4, 14}, {439, 605, 5, 14}, {81, 621, 5, 15}, 
  {89, 621, 5, 15}, {164, 621, 5, 15}, {217, 621, 5, 15}, {345, 621, 5, 15}, 
  {488, 621, 5, 15}, {78, 638, 4, 14}, {142, 638, 4, 14}, {152, 638, 5, 14}, 
  {227, 638, 4, 14}, {237, 638, 5, 14}, {269, 638, 7, 14}, {282, 638, 4, 14}, 
  {313, 638, 5, 14}, {318, 638, 4, 14}, {432, 638, 5, 14}, {443, 638, 5, 14}, 
  {90, 654, 4, 15}, {103, 654, 4, 15}, {154, 654, 5, 15}, {228, 654, 5, 15}, 
  {239, 654, 4, 15}, {246, 654, 5, 15}, {381, 654, 5, 15}, {439, 654, 4, 15}, 
  {505, 654, 6, 15}, {113, 671, 4, 14}, {136, 671, 5, 14}, {241, 671, 5, 14}, 
  {252, 671, 4, 14}, {329, 671, 5, 14}, {396, 671, 4, 14}, {427, 671, 5, 14}, 
  {117, 695, 5, 14}, {149, 695, 5, 14}, {263, 695, 5, 14}, {330, 695, 5, 14}, 
  {392, 695, 5, 14}, {512, 695, 5, 14}, {520, 695, 5, 14}, {86, 711, 4, 14}, 
  {147, 711, 5, 14}, {158, 711, 4, 14}, {288, 711, 4, 14}, {298, 711, 5, 14}, 
  {397, 711, 4, 14}, {445, 711, 5, 14}, {120, 728, 5, 14}, {155, 728, 4, 14}, 
  {290, 728, 5, 14}, {376, 728, 5, 14}, {520, 728, 6, 14}, {56, 744, 5, 14}, 
  {170, 744, 5, 14}, {260, 744, 4, 14}, {420, 744, 4, 14}, {471, 744, 5, 14}, 
  {518, 744, 5, 14}, {151, 57, 5, 14}, {198, 57, 4, 14}, {286, 57, 5, 14}, 
  {136, 73, 5, 15}, {168, 73, 5, 15}, {69, 97, 5, 14}, {164, 97, 5, 14}, 
  {175, 97, 5, 14}, {219, 97, 5, 14}, {323, 97, 5, 14}, {454, 97, 4, 14}, 
  {94, 113, 5, 15}, {159, 113, 5, 15}, {211, 113, 5, 15}, {298, 113, 5, 15}, 
  {303, 113, 4, 15}, {356, 113, 5, 15}, {404, 113, 5, 15}, {56, 130, 5, 14}, 
  {240, 130, 5, 14}, {289, 130, 5, 14}, {294, 130, 5, 14}, {413, 130, 4, 14}, 
  {461, 130, 5, 14}, {490, 130, 5, 14}, {149, 147, 4, 14}, {215, 147, 4, 14}, 
  {269, 147, 5, 14}, {293, 147, 5, 14}, {327, 147, 5, 14}, {377, 147, 5, 14}, 
  {400, 147, 4, 14}, {423, 147, 4, 14}, {74, 163, 4, 14}, {141, 163, 4, 14}, 
  {214, 163, 4, 14}, {354, 163, 5, 14}, {450, 163, 5, 14}, {123, 187, 5, 14}, 
  {164, 187, 4, 14}, {174, 187, 5, 14}, {182, 187, 5, 14}, {211, 187, 5, 14}, 
  {265, 187, 5, 14}, {307, 187, 5, 14}, {320, 187, 5, 14}, {400, 187, 5, 14}, 
  {408, 187, 5, 14}, {56, 203, 5, 14}, {156, 203, 5, 14}, {261, 203, 5, 14}, 
  {301, 203, 5, 14}, {374, 203, 5, 14}, {428, 203, 5, 14}, {487, 203, 4, 14}, 
  {511, 203, 5, 14}, {115, 220, 4, 14}, {143, 220, 4, 14}, {180, 220, 5, 14}, 
  {238, 220, 5, 14}, {345, 220, 5, 14}, {81, 236, 5, 14}, {86, 236, 4, 14}, 
  {144, 236, 5, 14}, {226, 236, 4, 14}, {276, 236, 4, 14}, {345, 236, 5, 14}, 
  {429, 236, 5, 14}, {461, 236, 4, 14}, {152, 253, 4, 14}, {215, 253, 5, 14}, 
  {322, 253, 5, 14}, {446, 253, 5, 14}, {72, 269, 4, 15}, {113, 269, 4, 15}, 
  {150, 269, 4, 15}, {253, 269, 4, 15}, {101, 309, 4, 15}, {134, 309, 4, 15}, 
  {222, 309, 5, 15}, {246, 309, 5, 15}, {346, 309, 4, 15}, {411, 309, 5, 15}, 
  {135, 326, 5, 14}, {187, 326, 5, 14}, {460, 326, 4, 14}, {483, 326, 5, 14}, 
  {87, 343, 5, 14}, {95, 343, 4, 14}, {137, 343, 5, 14}, {145, 343, 4, 14}, 
  {200, 343, 4, 14}, {204, 343, 5, 14}, {233, 343, 5, 14}, {293, 343, 5, 14}, 
  {323, 343, 5, 14}, {355, 343, 5, 14}, {470, 343, 4, 14}, {56, 359, 7, 14}, 
  {101, 359, 5, 14}, {139, 359, 5, 14}, {168, 359, 5, 14}, {194, 359, 5, 14}, 
  {267, 359, 5, 14}, {389, 359, 5, 14}, {74, 376, 4, 14}, {157, 376, 5, 14}, 
  {226, 376, 5, 14}, {371, 376, 5, 14}, {500, 376, 4, 14}, {531, 376, 5, 14}, 
  {137, 392, 4, 14}, {176, 392, 5, 14}, {223, 392, 5, 14}, {312, 392, 5, 14}, 
  {320, 392, 4, 14}, {153, 416, 5, 14}, {203, 416, 4, 14}, {524, 416, 6, 14}, 
  {126, 432, 5, 15}, {158, 432, 4, 15}, {324, 432, 5, 15}, {355, 432, 5, 15}, 
  {387, 432, 5, 15}, {496, 432, 4, 15}, {109, 449, 5, 14}, {131, 449, 5, 14}, 
  {211, 449, 5, 14}, {329, 449, 5, 14}, {346, 449, 5, 14}, {439, 449, 4, 14}, 
  {96, 465, 4, 15}, {128, 465, 5, 15}, {156, 465, 5, 15}, {196, 465, 5, 15}, 
  {204, 465, 5, 15}, {300, 465, 7, 15}, {313, 465, 5, 15}, {344, 465, 5, 15}, 
  {349, 465, 4, 15}, {362, 465, 4, 15}, {484, 465, 4, 15}, {81, 482, 5, 14}, 
  {86, 482, 4, 14}, {156, 482, 5, 14}, {203, 482, 4, 14}, {258, 482, 5, 14}, 
  {290, 482, 5, 14}, {329, 482, 5, 14}, {479, 482, 5, 14}, {114, 499, 5, 14}, 
  {257, 499, 5, 14}, {454, 499, 5, 14}, {486, 499, 5, 14}, {71, 515, 5, 14}, 
  {76, 515, 4, 14}, {161, 515, 4, 14}, {188, 515, 5, 14}, {250, 515, 5, 14}, 
  {79, 539, 4, 14}, {164, 539, 5, 14}, {236, 539, 4, 14}, {297, 539, 4, 14}, 
  {322, 539, 5, 14}, {501, 539, 5, 14}, {509, 539, 5, 14}, {74, 555, 4, 14}, 
  {180, 555, 5, 14}, {305, 555, 5, 14}, {331, 555, 5, 14}, {390, 555, 5, 14}, 
  {528, 555, 6, 14}, {355, 572, 5, 14}, {379, 572, 4, 14}, {490, 572, 4, 14}, 
  {497, 572, 5, 14}, {141, 588, 4, 14}, {187, 588, 5, 14}, {195, 588, 4, 14}, 
  {435, 588, 4, 14}, {56, 612, 7, 14}, {69, 612, 5, 14}, {100, 612, 5, 14}, 
  {105, 612, 5, 14}, {233, 612, 4, 14}, {288, 612, 5, 14}, {311, 612, 4, 14}, 
  {456, 612, 5, 14}, {467, 612, 5, 14}, {94, 628, 5, 15}, {111, 628, 5, 15}, 
  {186, 628, 5, 15}, {307, 628, 5, 15}, {353, 628, 7, 15}, {396, 628, 4, 15}, 
  {80, 645, 4, 14}, {152, 645, 5, 14}, {347, 645, 5, 14}, {401, 645, 5, 14}, 
  {455, 645, 5, 14}, {504, 645, 5, 14}, {92, 661, 5, 15}, {121, 661, 5, 15}, 
  {163, 661, 4, 15}, {261, 661, 5, 15}, {336, 661, 5, 15}, {66, 678, 4, 14}, 
  {166, 678, 5, 14}, {171, 678, 5, 14}, {219, 678, 4, 14}, {423, 678, 5, 14}, 
  {452, 678, 5, 14}, {74, 695, 5, 14}, {97, 695, 5, 14}, {100, 718, 4, 14}, 
  {201, 718, 5, 14}, {239, 718, 4, 14}, {311, 718, 5, 14}, {351, 718, 5, 14}, 
  {362, 718, 4, 14}, {388, 718, 4, 14}, {398, 718, 5, 14}, {452, 718, 5, 14}, 
  {83, 735, 5, 14}, {91, 735, 4, 14}, {116, 735, 7, 14}, {129, 735, 4, 14}, 
  {160, 735, 5, 14}, {165, 735, 4, 14}, {205, 735, 4, 14}, {493, 735, 5, 14}, 
  {524, 735, 5, 14}, {165, 751, 5, 14}, {210, 751, 4, 14}, {291, 751, 5, 14}, 
  {331, 751, 5, 14}, {342, 751, 5, 14}, {115, 768, 5, 14}, {140, 768, 5, 14}, 
  {284, 768, 7, 14}, {455, 768, 4, 14}, {94, 57, 5, 14}, {150, 57, 5, 14}, 
  {305, 57, 5, 14}, {316, 57, 4, 14}, {453, 57, 5, 14}, {464, 57, 4, 14}, 
  {471, 57, 5, 14}, {518, 57, 5, 14}, {56, 73, 5, 15}, {135, 73, 5, 15}, 
  {204, 73, 5, 15}, {247, 73, 5, 15}, {271, 73, 4, 15}, {399, 73, 5, 15}, 
  {470, 73, 5, 15}, {98, 90, 4, 14}, {360, 90, 4, 14}, {364, 90, 5, 14}, 
  {431, 90, 5, 14}, {457, 90, 4, 14}, {171, 106, 4, 15}, {247, 106, 5, 15}, 
  {302, 106, 5, 15}, {103, 130, 4, 14}, {354, 130, 4, 14}, {220, 147, 4, 14}, 
  {377, 147, 5, 14}, {474, 147, 5, 14}, {199, 163, 5, 14}, {263, 163, 5, 14}, 
  {335, 163, 5, 14}, {412, 163, 5, 14}, {454, 163, 4, 14}, {177, 180, 4, 14}, 
  {218, 180, 5, 14}, {320, 180, 5, 14}, {328, 180, 5, 14}, {94, 196, 5, 14}, 
  {244, 196, 4, 14}, {394, 196, 5, 14}, {476, 196, 5, 14}, {149, 213, 5, 14}, 
  {157, 213, 5, 14}, {283, 213, 4, 14}, {305, 213, 5, 14}, {352, 213, 5, 14}, 
  {388, 213, 5, 14}, {461, 213, 5, 14}, {469, 213, 5, 14}, {529, 213, 6, 14}, 
  {78, 229, 5, 14}, {86, 229, 5, 14}, {146, 229, 7, 14}, {159, 229, 4, 14}, 
  {190, 229, 5, 14}, {195, 229, 4, 14}, {231, 229, 5, 14}, {332, 229, 5, 14}, 
  {381, 229, 4, 14}, {470, 229, 5, 14}, {56, 253, 7, 14}, {144, 253, 5, 14}, 
  {249, 253, 4, 14}, {316, 253, 4, 14}, {405, 253, 5, 14}, {496, 253, 5, 14}, 
  {175, 269, 5, 15}, {206, 269, 4, 15}, {238, 269, 4, 15}, {285, 269, 4, 15}, 
  {313, 269, 5, 15}, {446, 269, 6, 15}, {467, 269, 4, 15}, {212, 286, 4, 14}, 
  {343, 286, 5, 14}, {433, 286, 5, 14}, {438, 286, 5, 14}, {474, 286, 5, 14}, 
  {76, 302, 5, 15}, {223, 302, 5, 15}, {296, 302, 5, 15}, {360, 302, 5, 15}, 
  {406, 302, 4, 15}, {517, 302, 5, 15}, {100, 319, 4, 14}, {119, 319, 5, 14}, 
  {177, 319, 5, 14}, {214, 319, 5, 14}, {344, 319, 4, 14}, {416, 319, 5, 14}, 
  {500, 319, 4, 14}, {510, 319, 5, 14}, {82, 336, 4, 14}, {99, 336, 4, 14}, 
  {156, 336, 5, 14}, {164, 336, 5, 14}, {315, 336, 5, 14}, {350, 336, 5, 14}, 
  {381, 336, 4, 14}, {403, 336, 5, 14}, {408, 336, 4, 14}, {88, 352, 5, 14}, 
  {151, 352, 4, 14}, {173, 352, 5, 14}, {290, 352, 5, 14}, {309, 352, 4, 14}, 
  {423, 352, 5, 14}, {78, 392, 4, 14}, {156, 392, 5, 14}, {161, 392, 4, 14}, 
  {420, 392, 5, 14}, {463, 392, 5, 14}, {201, 409, 5, 14}, {209, 409, 5, 14}, 
  {278, 409, 4, 14}, {309, 409, 5, 14}, {432, 409, 4, 14}, {442, 409, 5, 14}, 
  {450, 409, 5, 14}, {461, 409, 4, 14}, {133, 425, 4, 15}, {143, 425, 7, 15}, 
  {180, 425, 4, 15}, {308, 425, 5, 15}, {414, 425, 5, 15}, {464, 425, 4, 15}, 
  {128, 442, 5, 14}, {147, 442, 5, 14}, {158, 442, 5, 14}, {223, 442, 4, 14}, 
  {286, 442, 5, 14}, {294, 442, 5, 14}, {323, 442, 5, 14}, {356, 442, 5, 14}, 
  {394, 442, 4, 14}, {56, 458, 5, 15}, {88, 458, 4, 15}, {219, 458, 5, 15}, 
  {230, 458, 7, 15}, {251, 458, 5, 15}, {420, 458, 5, 15}, {443, 458, 5, 15}, 
  {503, 458, 4, 15}, {305, 475, 4, 14}, {369, 475, 6, 14}, {80, 492, 5, 14}, 
  {207, 492, 5, 14}, {237, 492, 5, 14}, {270, 492, 5, 14}, {288, 492, 5, 14}, 
  {397, 492, 4, 14}, {449, 492, 5, 14}, {481, 492, 4, 14}, {95, 508, 5, 14}, 
  {244, 508, 5, 14}, {289, 508, 5, 14}, {338, 508, 5, 14}, {349, 508, 4, 14}, 
  {393, 508, 5, 14}, {453, 508, 5, 14}, {464, 508, 5, 14}, {498, 508, 5, 14}, 
  {103, 548, 4, 14}, {225, 548, 4, 14}, {69, 565, 5, 14}, {103, 565, 4, 14}, 
  {113, 565, 5, 14}, {248, 565, 5, 14}, {265, 565, 5, 14}, {402, 565, 5, 14}, 
  {436, 565, 5, 14}, {515, 565, 5, 14}, {97, 581, 5, 14}, {120, 581, 5, 14}, 
  {128, 581, 4, 14}, {207, 581, 4, 14}, {211, 581, 5, 14}, {253, 581, 5, 14}, 
  {272, 581, 5, 14}, {283, 581, 4, 14}, {367, 581, 5, 14}, {388, 581, 4, 14}, 
  {423, 581, 5, 14}, {428, 581, 5, 14}, {470, 581, 5, 14}, {89, 598, 5, 14}, 
  {144, 598, 4, 14}, {198, 598, 4, 14}, {208, 598, 7, 14}, {286, 598, 5, 14}, 
  {323, 598, 5, 14}, {430, 598, 5, 14}, {500, 598, 5, 14}, {88, 614, 4, 15}, 
  {116, 614, 5, 15}, {206, 614, 5, 15}, {229, 614, 4, 15}, {259, 614, 5, 15}, 
  {56, 631, 5, 14}, {67, 631, 5, 14}, {132, 631, 5, 14}, {86, 654, 4, 15}, 
  {124, 654, 5, 15}, {202, 654, 5, 15}, {207, 654, 4, 15}, {259, 654, 5, 15}, 
  {360, 654, 4, 15}, {383, 654, 4, 15}, {398, 654, 4, 15}, {408, 654, 5, 15}, 
  {427, 654, 5, 15}, {87, 671, 5, 14}, {143, 671, 5, 14}, {307, 671, 5, 14}, 
  {350, 671, 6, 14}, {387, 671, 4, 14}, {394, 671, 5, 14}, {515, 671, 4, 14}, 
  {92, 688, 5, 14}, {123, 688, 5, 14}, {149, 688, 5, 14}, {227, 688, 4, 14}, 
  {276, 688, 4, 14}, {332, 688, 4, 14}, {385, 688, 5, 14}, {435, 688, 5, 14}, 
  {454, 688, 5, 14}, {91, 704, 7, 14}, {198, 704, 4, 14}, {250, 704, 5, 14}, 
  {365, 704, 4, 14}, {416, 704, 5, 14}, {80, 721, 5, 14}, {223, 721, 5, 14}, 
  {228, 721, 5, 14}, {290, 721, 5, 14}, {319, 721, 5, 14}, {342, 721, 4, 14}, 
  {346, 721, 5, 14}, {382, 721, 5, 14}, {411, 721, 4, 14}, {437, 721, 5, 14}, 
  {68, 737, 5, 14}, {170, 737, 4, 14}, {257, 737, 5, 14}, {313, 737, 5, 14}, 
  {354, 737, 4, 14}, {429, 737, 4, 14}, {487, 737, 5, 14}, {56, 754, 7, 14}, 
  {69, 754, 5, 14}, {100, 754, 5, 14}, {105, 754, 5, 14}, {133, 754, 5, 14}, 
  {215, 754, 4, 14}, {237, 754, 5, 14}, {257, 754, 5, 14}, {319, 754, 5, 14}, 
  {462, 754, 5, 14}, {509, 754, 5, 14}, {180, 770, 4, 15}, {203, 770, 4, 15}, 
  {233, 770, 5, 15}, {252, 770, 5, 15}, {325, 770, 5, 15}, {333, 770, 5, 15}, 
  {385, 770, 5, 15}, {69, 57, 5, 14}, {138, 57, 5, 14}, {411, 57, 5, 14}, 
  {454, 57, 5, 14}, {111, 73, 5, 15}, {131, 73, 4, 15}, {171, 73, 5, 15}, 
  {211, 73, 5, 15}, {240, 73, 5, 15}, {306, 73, 5, 15}, {311, 73, 5, 15}, 
  {367, 73, 4, 15}, {396, 73, 4, 15}, {465, 73, 5, 15}, {86, 90, 4, 14}, 
  {93, 90, 5, 14}, {164, 90, 4, 14}, {271, 90, 5, 14}, {317, 90, 4, 14}, 
  {389, 90, 5, 14}, {418, 90, 4, 14}, {447, 90, 4, 14}, {520, 90, 4, 14}, 
  {190, 106, 5, 15}, {230, 106, 5, 15}, {259, 106, 5, 15}, {374, 106, 5, 15}, 
  {494, 106, 5, 15}, {502, 106, 5, 15}, {88, 123, 4, 14}, {112, 123, 5, 14}, 
  {144, 123, 5, 14}, {190, 123, 5, 14}, {249, 123, 5, 14}, {361, 123, 4, 14}, 
  {371, 123, 5, 14}, {94, 147, 5, 14}, {235, 147, 4, 14}, {265, 147, 5, 14}, 
  {320, 147, 5, 14}, {373, 147, 4, 14}, {377, 147, 5, 14}, {526, 147, 6, 14}, 
  {109, 163, 5, 14}, {213, 163, 5, 14}, {333, 163, 5, 14}, {385, 163, 5, 14}, 
  {396, 163, 5, 14}, {415, 163, 5, 14}, {95, 180, 5, 14}, {194, 180, 4, 14}, 
  {366, 180, 4, 14}, {397, 180, 5, 14}, {449, 180, 5, 14}, {484, 180, 5, 14}, 
  {495, 180, 4, 14}, {56, 196, 7, 14}, {69, 196, 5, 14}, {100, 196, 5, 14}, 
  {105, 196, 5, 14}, {181, 196, 5, 14}, {215, 196, 5, 14}, {226, 196, 5, 14}, 
  {269, 196, 5, 14}, {280, 196, 5, 14}, {303, 196, 4, 14}, {64, 213, 4, 14}, 
  {74, 213, 5, 14}, {82, 213, 5, 14}, {111, 213, 5, 14}, {262, 213, 4, 14}, 
  {266, 213, 5, 14}, {358, 213, 4, 14}, {400, 213, 5, 14}, {446, 213, 5, 14}, 
  {96, 229, 4, 14}, {115, 229, 4, 14}, {181, 229, 4, 14}, {215, 229, 5, 14}, 
  {223, 229, 4, 14}, {333, 229, 5, 14}, {516, 229, 6, 14}, {178, 246, 5, 14}, 
  {236, 246, 5, 14}, {311, 246, 5, 14}, {334, 246, 5, 14}, {201, 262, 5, 15}, 
  {251, 262, 4, 15}, {259, 262, 4, 15}, {303, 262, 5, 15}, {69, 286, 5, 14}, 
  {87, 286, 5, 14}, {98, 286, 5, 14}, {160, 286, 5, 14}, {201, 286, 4, 14}, 
  {296, 286, 5, 14}, {332, 286, 4, 14}, {363, 286, 5, 14}, {416, 286, 4, 14}, 
  {82, 302, 4, 15}, {120, 302, 4, 15}, {249, 302, 4, 15}, {299, 302, 5, 15}, 
  {310, 302, 4, 15}, {426, 302, 4, 15}, {434, 302, 4, 15}, {474, 302, 4, 15}, 
  {122, 319, 5, 14}, {127, 319, 4, 14}, {214, 319, 5, 14}, {240, 319, 5, 14}, 
  {337, 319, 5, 14}, {123, 336, 5, 14}, {134, 336, 5, 14}, {176, 336, 5, 14}, 
  {249, 336, 4, 14}, {311, 336, 5, 14}, {355, 336, 4, 14}, {456, 336, 5, 14}, 
  {156, 352, 4, 14}, {254, 352, 5, 14}, {259, 352, 5, 14}, {338, 376, 7, 14}, 
  {351, 376, 5, 14}, {382, 376, 5, 14}, {387, 376, 5, 14}, {423, 376, 5, 14}, 
  {493, 376, 5, 14}, {510, 376, 5, 14}, {253, 392, 5, 14}, {311, 392, 5, 14}, 
  {419, 392, 5, 14}, {424, 392, 4, 14}, {475, 392, 5, 14}, {504, 392, 5, 14}, 
  {108, 409, 5, 14}, {228, 409, 5, 14}, {326, 409, 5, 14}, {488, 409, 5, 14}, 
  {71, 425, 5, 15}, {76, 425, 4, 15}, {135, 425, 5, 15}, {143, 425, 4, 15}, 
  {174, 425, 5, 15}, {199, 425, 5, 15}, {236, 425, 4, 15}, {380, 425, 5, 15}, 
  {413, 425, 4, 15}, {421, 425, 4, 15}, {515, 425, 6, 15}, {96, 442, 4, 14}, 
  {192, 442, 5, 14}, {333, 442, 5, 14}, {388, 442, 5, 14}, {442, 442, 5, 14}, 
  {485, 442, 5, 14}, {524, 442, 6, 14}, {94, 482, 5, 14}, {123, 482, 5, 14}, 
  {159, 482, 5, 14}, {259, 482, 5, 14}, {402, 482, 5, 14}, {515, 482, 4, 14}, 
  {131, 499, 5, 14}, {136, 499, 4, 14}, {149, 499, 4, 14}, {206, 499, 4, 14}, 
  {303, 499, 5, 14}, {430, 499, 4, 14}, {437, 499, 5, 14}, {217, 515, 5, 14}, 
  {272, 515, 5, 14}, {292, 515, 6, 14}, {304, 515, 5, 14}, {336, 515, 4, 14}, 
  {340, 515, 5, 14}, {473, 515, 5, 14}, {484, 515, 5, 14}, {507, 515, 5, 14}, 
  {66, 532, 4, 14}, {317, 532, 5, 14}, {413, 532, 5, 14}, {445, 532, 4, 14}, 
  {490, 532, 5, 14}, {498, 532, 4, 14}, {56, 548, 5, 14}, {199, 548, 4, 14}, 
  {246, 548, 5, 14}, {268, 548, 5, 14}, {333, 548, 5, 14}, {341, 548, 5, 14}, 
  {488, 548, 5, 14}, {493, 548, 5, 14}, {142, 565, 4, 14}, {382, 565, 5, 14}, 
  {139, 581, 5, 14}, {56, 605, 7, 14}, {69, 605, 5, 14}, {100, 605, 5, 14}, 
  {105, 605, 5, 14}, {143, 605, 4, 14}, {151, 605, 4, 14}, {298, 605, 4, 14}, 
  {359, 605, 7, 14}, {372, 605, 4, 14}, {403, 605, 5, 14}, {408, 605, 4, 14}, 
  {482, 605, 4, 14}, {511, 605, 6, 14}, {90, 621, 5, 15}, {154, 621, 5, 15}, 
  {373, 621, 4, 15}, {482, 621, 5, 15}, {509, 621, 6, 15}, {120, 638, 5, 14}, 
  {137, 638, 5, 14}, {210, 638, 5, 14}, {379, 638, 5, 14}, {387, 638, 5, 14}, 
  {489, 638, 5, 14}, {68, 654, 4, 15}, {172, 654, 5, 15}, {238, 654, 4, 15}, 
  {287, 654, 4, 15}, {379, 654, 5, 15}, {429, 654, 5, 15}, {56, 671, 5, 14}, 
  {81, 671, 4, 14}, {121, 671, 4, 14}, {134, 671, 5, 14}, {199, 671, 5, 14}, 
  {231, 671, 5, 14}, {353, 671, 5, 14}, {409, 671, 6, 14}, {421, 671, 5, 14}, 
  {453, 671, 4, 14}, {457, 671, 5, 14}, {470, 671, 5, 14}, {481, 671, 5, 14}, 
  {519, 671, 5, 14}, {122, 688, 5, 14}, {225, 688, 5, 14}, {298, 688, 5, 14}, 
  {306, 688, 5, 14}, {348, 688, 5, 14}, {361, 688, 5, 14}, {413, 688, 5, 14}, 
  {456, 688, 5, 14}, {488, 688, 4, 14}, {175, 704, 5, 14}, {206, 704, 5, 14}, 
  {293, 704, 5, 14}, {308, 704, 5, 14}, {319, 704, 5, 14}, {413, 704, 4, 14}, 
  {423, 704, 5, 14}, {246, 721, 5, 14}, {305, 721, 5, 14}, {316, 721, 4, 14}, 
  {393, 721, 5, 14}, {404, 721, 6, 14}, {450, 721, 5, 14}, {527, 721, 5, 14}, 
  {110, 744, 4, 14}, {120, 744, 5, 14}, {128, 744, 5, 14}, {171, 744, 5, 14}, 
  {179, 744, 4, 14}, {189, 744, 5, 14}, {402, 744, 5, 14}, {410, 744, 4, 14}, 
  {502, 744, 4, 14}, {513, 744, 4, 14}, {74, 761, 4, 14}, {87, 761, 4, 14}, 
  {122, 761, 4, 14}, {150, 761, 4, 14}, {277, 761, 5, 14}, {285, 761, 5, 14}, 
  {377, 761, 4, 14}, {410, 761, 4, 14}, {85, 57, 5, 14}, {103, 57, 5, 14}, 
  {114, 57, 4, 14}, {225, 57, 4, 14}, {235, 57, 5, 14}, {373, 57, 4, 14}, 
  {413, 57, 4, 14}, {69, 73, 5, 15}, {162, 73, 5, 15}, {167, 73, 4, 15}, 
  {211, 73, 5, 15}, {222, 73, 4, 15}, {239, 73, 4, 15}, {302, 73, 5, 15}, 
  {360, 73, 5, 15}, {391, 73, 5, 15}, {408, 73, 5, 15}, {498, 73, 5, 15}, 
  {204, 90, 4, 14}, {246, 90, 5, 14}, {303, 90, 4, 14}, {333, 90, 5, 14}, 
  {511, 90, 5, 14}, {519, 90, 4, 14}, {72, 106, 4, 15}, {124, 106, 4, 15}, 
  {276, 106, 5, 15}, {313, 106, 7, 15}, {326, 106, 4, 15}, {357, 106, 5, 15}, 
  {362, 106, 4, 15}, {407, 106, 5, 15}, {415, 106, 5, 15}, {426, 106, 4, 15}, 
  {142, 123, 5, 14}, {150, 123, 5, 14}, {210, 123, 5, 14}, {303, 123, 5, 14}, 
  {351, 123, 5, 14}, {374, 123, 5, 14}, {505, 123, 5, 14}, {93, 140, 5, 14}, 
  {233, 140, 5, 14}, {294, 140, 5, 14}, {326, 140, 4, 14}, {393, 140, 5, 14}, 
  {416, 140, 4, 14}, {420, 140, 5, 14}, {530, 140, 6, 14}, {56, 156, 5, 14}, 
  {160, 180, 5, 14}, {273, 180, 5, 14}, {388, 180, 4, 14}, {474, 180, 5, 14}, 
  {510, 180, 5, 14}, {66, 196, 4, 14}, {127, 196, 4, 14}, {188, 196, 5, 14}, 
  {290, 196, 5, 14}, {377, 196, 5, 14}, {382, 196, 4, 14}, {460, 196, 4, 14}, 
  {512, 196, 5, 14}, {105, 213, 4, 14}, {210, 213, 5, 14}, {332, 213, 5, 14}, 
  {368, 213, 4, 14}, {409, 213, 4, 14}, {462, 213, 5, 14}, {500, 213, 4, 14}, 
  {510, 213, 5, 14}, {161, 229, 4, 14}, {245, 253, 5, 14}, {412, 253, 4, 14}, 
  {72, 269, 4, 15}, {82, 269, 5, 15}, {205, 269, 5, 15}, {280, 269, 5, 15}, 
  {321, 269, 5, 15}, {329, 269, 5, 15}, {374, 269, 5, 15}, {453, 269, 5, 15}, 
  {133, 286, 4, 14}, {192, 286, 5, 14}, {211, 286, 4, 14}, {240, 286, 5, 14}, 
  {445, 286, 5, 14}, {521, 286, 6, 14}, {56, 302, 5, 15}, {180, 302, 4, 15}, 
  {103, 326, 5, 14}, {114, 326, 5, 14}, {278, 326, 5, 14}, {330, 326, 5, 14}, 
  {376, 326, 5, 14}, {444, 326, 4, 14}, {217, 343, 5, 14}, {354, 343, 5, 14}, 
  {362, 343, 5, 14}, {123, 359, 4, 14}, {154, 359, 4, 14}, {176, 359, 5, 14}, 
  {205, 359, 5, 14}, {253, 359, 4, 14}, {455, 359, 5, 14}, {94, 376, 5, 14}, 
  {135, 376, 4, 14}, {204, 376, 5, 14}, {218, 376, 5, 14}, {249, 376, 5, 14}, 
  {349, 376, 5, 14}, {380, 376, 4, 14}, {519, 376, 5, 14}, {138, 399, 5, 14}, 
  {192, 399, 5, 14}, {246, 399, 5, 14}, {295, 399, 5, 14}, {351, 399, 5, 14}, 
  {391, 399, 4, 14}, {167, 416, 5, 14}, {216, 416, 5, 14}, {255, 416, 5, 14}, 
  {280, 416, 5, 14}, {399, 416, 5, 14}, {435, 416, 4, 14}, {443, 416, 4, 14}, 
  {450, 416, 5, 14}, {505, 416, 5, 14}, {528, 416, 5, 14}, {98, 432, 5, 15}, 
  {127, 432, 5, 15}, {206, 432, 4, 15}, {216, 432, 5, 15}, {342, 432, 5, 15}, 
  {433, 432, 5, 15}, {458, 432, 5, 15}, {490, 432, 4, 15}, {117, 449, 4, 14}, 
  {181, 449, 5, 14}, {314, 449, 5, 14}, {346, 449, 4, 14}, {353, 449, 5, 14}, 
  {72, 465, 4, 15}, {82, 465, 5, 15}, {123, 465, 5, 15}, {153, 465, 4, 15}, 
  {213, 465, 5, 15}, {244, 465, 5, 15}, {56, 489, 7, 14}, {69, 489, 5, 14}, 
  {100, 489, 5, 14}, {105, 489, 5, 14}, {216, 489, 4, 14}, {326, 489, 5, 14}, 
  {351, 489, 5, 14}, {364, 489, 5, 14}, {387, 489, 5, 14}, {491, 489, 5, 14}, 
  {273, 506, 5, 14}, {284, 506, 5, 14}, {332, 506, 5, 14}, {532, 506, 6, 14}, 
  {64, 522, 4, 14}, {74, 522, 5, 14}, {133, 522, 4, 14}, {150, 522, 4, 14}, 
  {161, 522, 4, 14}, {413, 522, 5, 14}, {475, 522, 5, 14}, {521, 522, 5, 14}, 
  {97, 539, 5, 14}, {183, 539, 5, 14}, {286, 539, 4, 14}, {423, 539, 5, 14}, 
  {471, 539, 4, 14}, {522, 539, 6, 14}, {76, 555, 5, 14}, {56, 579, 7, 14}, 
  {215, 579, 7, 14}, {267, 579, 5, 14}, {291, 579, 5, 14}, {304, 579, 5, 14}, 
  {321, 579, 5, 14}, {418, 579, 5, 14}, {466, 579, 5, 14}, {169, 595, 4, 14}, 
  {243, 595, 5, 14}, {265, 595, 5, 14}, {339, 595, 5, 14}, {394, 595, 5, 14}, 
  {435, 595, 4, 14}, {464, 595, 5, 14}, {518, 595, 5, 14}, {104, 612, 5, 14}, 
  {250, 612, 4, 14}, {317, 612, 5, 14}, {477, 612, 5, 14}, {500, 612, 5, 14}, 
  {87, 628, 5, 15}, {98, 628, 4, 15}, {150, 628, 5, 15}, {165, 628, 5, 15}, 
  {176, 628, 4, 15}, {434, 628, 5, 15}, {451, 628, 5, 15}, {468, 628, 5, 15}, 
  {127, 645, 5, 14}, {304, 645, 5, 14}, {378, 645, 5, 14}, {427, 645, 5, 14}, 
  {523, 645, 5, 14}, {115, 661, 5, 15}, {148, 661, 5, 15}, {204, 661, 4, 15}, 
  {256, 661, 5, 15}, {303, 661, 5, 15}, {424, 661, 5, 15}, {435, 661, 4, 15}, 
  {497, 661, 5, 15}, {505, 661, 4, 15}, {92, 678, 5, 14}, {139, 702, 5, 14}, 
  {201, 702, 4, 14}, {221, 702, 4, 14}, {297, 702, 5, 14}, {380, 702, 5, 14}, 
  {515, 702, 6, 14}, {194, 718, 5, 14}, {276, 718, 5, 14}, {287, 718, 4, 14}, 
  {380, 718, 4, 14}, {458, 718, 4, 14}, {141, 735, 5, 14}, {205, 735, 5, 14}, 
  {235, 735, 4, 14}, {278, 735, 5, 14}, {301, 735, 5, 14}, {360, 735, 4, 14}, 
  {370, 735, 5, 14}, {429, 735, 5, 14}, {74, 751, 4, 14}, {154, 751, 4, 14}, 
  {266, 751, 4, 14}, {338, 751, 5, 14}, {407, 751, 5, 14}, {467, 751, 5, 14}, 
  {149, 768, 4, 14}, {174, 768, 4, 14}, {327, 768, 5, 14}, {373, 768, 5, 14}, 
  {384, 768, 6, 14}, {396, 768, 5, 14}, {428, 768, 4, 14}, {432, 768, 5, 14}, 
  {502, 768, 4, 14}, {509, 768, 5, 14}, {191, 57, 4, 14}, {195, 57, 5, 14}, 
  {291, 57, 4, 14}, {298, 57, 5, 14}, {346, 57, 4, 14}, {356, 57, 5, 14}, 
  {364, 57, 5, 14}, {419, 57, 4, 14}, {448, 57, 5, 14}, {508, 57, 6, 14}, 
  {147, 73, 5, 15}, {324, 73, 5, 15}, {343, 73, 4, 15}, {435, 73, 5, 15}, 
  {496, 73, 5, 15}, {524, 73, 6, 15}, {135, 90, 5, 14}, {192, 90, 5, 14}, 
  {224, 90, 5, 14}, {253, 90, 5, 14}, {316, 90, 5, 14}, {69, 113, 5, 15}, 
  {339, 113, 5, 15}, {406, 113, 5, 15}, {149, 130, 4, 14}, {355, 130, 5, 14}, 
  {383, 130, 5, 14}, {406, 130, 5, 14}, {94, 147, 5, 14}, {129, 147, 4, 14}, 
  {196, 147, 4, 14}, {219, 147, 5, 14}, {353, 147, 4, 14}, {375, 147, 5, 14}, 
  {392, 147, 5, 14}, {451, 147, 5, 14}, {90, 163, 4, 14}, {122, 163, 5, 14}, 
  {130, 163, 5, 14}, {147, 163, 5, 14}, {196, 163, 5, 14}, {219, 163, 5, 14}, 
  {236, 163, 5, 14}, {317, 163, 4, 14}, {321, 163, 5, 14}, {422, 163, 5, 14}, 
  {179, 180, 4, 14}, {315, 180, 5, 14}, {403, 180, 4, 14}, {462, 180, 5, 14}, 
  {467, 180, 5, 14}, {480, 180, 5, 14}, {526, 180, 4, 14}, {83, 196, 4, 14}, 
  {156, 196, 4, 14}, {233, 196, 5, 14}, {94, 220, 5, 14}, {238, 220, 5, 14}, 
  {305, 220, 5, 14}, {335, 220, 4, 14}, {389, 220, 4, 14}, {434, 220, 5, 14}, 
  {491, 220, 5, 14}, {508, 220, 5, 14}, {117, 236, 5, 14}, {215, 236, 5, 14}, 
  {406, 236, 5, 14}, {96, 253, 4, 14}, {291, 253, 5, 14}, {350, 253, 5, 14}, 
  {396, 253, 5, 14}, {424, 253, 5, 14}, {193, 269, 5, 15}, {281, 269, 5, 15}, 
  {375, 269, 5, 15}, {429, 269, 5, 15}, {95, 286, 5, 14}, {112, 286, 5, 14}, 
  {157, 286, 5, 14}, {267, 286, 5, 14}, {367, 286, 5, 14}, {420, 286, 4, 14}, 
  {466, 286, 5, 14}, {507, 286, 5, 14}, {71, 302, 5, 15}, {199, 302, 5, 15}, 
  {373, 302, 5, 15}, {428, 302, 5, 15}, {480, 302, 5, 15}, {491, 302, 6, 15}, 
  {97, 319, 5, 14}, {179, 319, 5, 14}, {296, 319, 5, 14}, {371, 319, 4, 14}, 
  {427, 319, 5, 14}, {484, 319, 5, 14}, {498, 319, 4, 14}, {505, 319, 5, 14}, 
  {81, 336, 5, 14}, {92, 336, 6, 14}, {132, 359, 5, 14}, {214, 359, 5, 14}, 
  {258, 359, 5, 14}, {263, 359, 4, 14}, {492, 359, 5, 14}, {64, 376, 4, 14}, 
  {74, 376, 5, 14}, {128, 376, 5, 14}, {151, 376, 5, 14}, {417, 376, 5, 14}, 
  {440, 376, 5, 14}, {457, 376, 5, 14}, {499, 376, 6, 14}, {154, 392, 4, 14}, 
  {230, 392, 5, 14}, {334, 392, 4, 14}, {445, 392, 5, 14}, {492, 392, 4, 14}, 
  {114, 409, 4, 14}, {160, 409, 4, 14}, {280, 409, 5, 14}, {288, 409, 5, 14}, 
  {372, 409, 5, 14}, {449, 409, 4, 14}, {462, 409, 5, 14}, {83, 425, 5, 15}, 
  {177, 425, 7, 15}, {190, 425, 4, 15}, {221, 425, 5, 15}, {226, 425, 4, 15}, 
  {312, 425, 5, 15}, {467, 425, 5, 15}, {513, 425, 6, 15}, {97, 442, 5, 14}, 
  {105, 442, 4, 14}, {168, 442, 4, 14}, {255, 442, 5, 14}, {336, 442, 5, 14}, 
  {397, 442, 5, 14}, {86, 458, 4, 15}, {114, 458, 5, 15}, {301, 458, 4, 15}, 
  {382, 458, 5, 15}, {403, 458, 4, 15}, {440, 458, 5, 15}, {518, 458, 6, 15}, 
  {74, 475, 4, 14}, {196, 475, 5, 14}, {331, 475, 4, 14}, {510, 475, 5, 14}, 
  {103, 499, 4, 14}, {146, 499, 4, 14}, {286, 499, 5, 14}, {334, 499, 5, 14}, 
  {459, 499, 5, 14}, {113, 515, 4, 14}, {154, 515, 4, 14}, {204, 515, 5, 14}, 
  {209, 515, 5, 14}, {297, 515, 5, 14}, {345, 515, 5, 14}, {80, 532, 4, 14}, 
  {156, 532, 5, 14}, {204, 532, 5, 14}, {218, 532, 5, 14}, {337, 532, 5, 14}, 
  {382, 532, 5, 14}, {411, 532, 5, 14}, {100, 548, 4, 14}, {256, 548, 5, 14}, 
  {264, 548, 4, 14}, {295, 548, 4, 14}, {329, 548, 5, 14}, {78, 572, 4, 14}, 
  {100, 572, 5, 14}, {205, 572, 4, 14}, {242, 572, 5, 14}, {253, 572, 4, 14}, 
  {270, 572, 4, 14}, {308, 572, 5, 14}, {456, 572, 5, 14}, {461, 572, 4, 14}, 
  {90, 588, 4, 14}, {176, 588, 4, 14}, {217, 588, 5, 14}, {294, 588, 4, 14}, 
  {331, 588, 5, 14}, {405, 588, 5, 14}, {468, 588, 5, 14}, {476, 588, 5, 14}, 
  {134, 605, 5, 14}, {384, 605, 5, 14}, {448, 605, 4, 14}, {471, 605, 4, 14}, 
  {152, 621, 5, 15}, {180, 621, 5, 15}, {250, 621, 5, 15}, {258, 621, 5, 15}, 
  {467, 621, 5, 15}, {487, 621, 4, 15}, {522, 621, 5, 15}, {533, 621, 6, 15}, 
  {72, 638, 5, 14}, {101, 638, 4, 14}, {178, 638, 4, 14}, {185, 638, 5, 14}, 
  {196, 638, 5, 14}, {56, 661, 7, 15}, {98, 661, 5, 15}, {133, 661, 5, 15}, 
  {303, 661, 4, 15}, {409, 661, 5, 15}, {432, 661, 4, 15}, {524, 661, 5, 15}, 
  {137, 678, 5, 14}, {307, 678, 5, 14}, {443, 678, 4, 14}, {78, 695, 4, 14}, 
  {148, 695, 4, 14}, {195, 695, 4, 14}, {291, 695, 5, 14}, {319, 695, 5, 14}, 
  {425, 695, 4, 14}, {479, 695, 4, 14}, {86, 711, 5, 14}, {151, 711, 5, 14}, 
  {174, 711, 5, 14}, {253, 711, 5, 14}, {307, 711, 5, 14}, {343, 711, 5, 14}, 
  {366, 711, 4, 14}, {427, 711, 5, 14}, {470, 711, 4, 14}, {110, 728, 4, 14}, 
  {244, 728, 5, 14}, {341, 728, 5, 14}, {346, 728, 5, 14}, {497, 728, 5, 14}, 
  {127, 744, 5, 14}, {228, 744, 5, 14}, {242, 744, 4, 14}, {290, 744, 5, 14}, 
  {313, 744, 5, 14}, {500, 744, 5, 14}, {102, 761, 4, 14}, {124, 761, 5, 14}, 
  {199, 761, 4, 14}, {239, 761, 5, 14}, {314, 761, 4, 14}, {420, 761, 4, 14}, 
  {451, 761, 4, 14}, {491, 761, 5, 14}, {126, 57, 5, 14}, {137, 57, 6, 14}, 
  {318, 57, 5, 14}, {381, 57, 5, 14}, {400, 57, 4, 14}, {474, 57, 4, 14}, 
  {505, 57, 5, 14}, {81, 73, 4, 15}, {103, 73, 5, 15}, {167, 73, 5, 15}, 
  {216, 73, 5, 15}, {266, 73, 5, 15}, {311, 73, 5, 15}, {385, 73, 4, 15}, 
  {105, 97, 5, 14}, {195, 97, 5, 14}, {244, 97, 5, 14}, {262, 97, 4, 14}, 
  {349, 97, 4, 14}, {371, 97, 4, 14}, {440, 97, 4, 14}, {463, 97, 4, 14}, 
  {96, 113, 4, 15}, {237, 113, 5, 15}, {422, 113, 5, 15}, {430, 113, 5, 15}, 
  {90, 130, 5, 14}, {150, 130, 5, 14}, {186, 130, 4, 14}, {241, 130, 5, 14}, 
  {430, 130, 4, 14}, {507, 130, 5, 14}, {82, 147, 5, 14}, {138, 147, 5, 14}, 
  {192, 147, 4, 14}, {242, 147, 4, 14}, {261, 147, 5, 14}, {377, 147, 4, 14}, 
  {381, 147, 5, 14}, {448, 147, 5, 14}, {474, 147, 4, 14}, {171, 163, 4, 14}, 
  {247, 163, 5, 14}, {302, 163, 5, 14}, {361, 163, 5, 14}, {457, 163, 5, 14}, 
  {505, 163, 4, 14}, {81, 180, 5, 14}, {98, 180, 5, 14}, {121, 180, 5, 14}, 
  {176, 180, 5, 14}, {201, 180, 5, 14}, {287, 180, 5, 14}, {482, 180, 6, 14}, 
  {503, 180, 4, 14}, {533, 180, 6, 14}, {132, 196, 4, 14}, {142, 196, 5, 14}, 
  {243, 196, 5, 14}, {365, 196, 5, 14}, {431, 196, 5, 14}, {449, 196, 5, 14}, 
  {349, 213, 5, 14}, {380, 213, 5, 14}, {393, 213, 5, 14}, {178, 229, 4, 14}, 
  {201, 229, 4, 14}, {211, 229, 5, 14}, {300, 229, 5, 14}, {380, 229, 4, 14}, 
  {140, 246, 5, 14}, {250, 269, 4, 15}, {412, 269, 4, 15}, {84, 286, 5, 14}, 
  {133, 286, 4, 14}, {187, 286, 5, 14}, {253, 286, 5, 14}, {264, 286, 5, 14}, 
  {293, 286, 5, 14}, {315, 286, 5, 14}, {420, 286, 5, 14}, {518, 286, 5, 14}, 
  {523, 286, 4, 14}, {64, 302, 4, 15}, {74, 302, 5, 15}, {107, 302, 4, 15}, 
  {115, 302, 4, 15}, {150, 302, 4, 15}, {239, 302, 5, 15}, {269, 302, 4, 15}, 
  {286, 302, 4, 15}, {324, 302, 5, 15}, {335, 302, 7, 15}, {348, 302, 4, 15}, 
  {379, 302, 5, 15}, {384, 302, 4, 15}, {421, 302, 4, 15}, {448, 302, 5, 15}, 
  {456, 302, 5, 15}, {56, 319, 5, 14}, {131, 319, 4, 14}, {185, 319, 5, 14}, 
  {208, 319, 5, 14}, {239, 319, 5, 14}, {337, 319, 4, 14}, {359, 319, 5, 14}, 
  {396, 319, 4, 14}, {67, 336, 5, 14}, {130, 336, 4, 14}, {206, 336, 4, 14}, 
  {240, 336, 4, 14}, {254, 336, 4, 14}, {372, 336, 4, 14}, {402, 336, 5, 14}, 
  {450, 336, 5, 14}, {494, 336, 5, 14}, {511, 336, 5, 14}, {270, 352, 5, 14}, 
  {339, 352, 5, 14}, {383, 352, 4, 14}, {418, 352, 5, 14}, {474, 352, 5, 14}, 
  {108, 369, 5, 14}, {131, 369, 5, 14}, {184, 392, 5, 14}, {215, 392, 5, 14}, 
  {240, 392, 5, 14}, {269, 392, 5, 14}, {293, 392, 4, 14}, {56, 409, 5, 14}, 
  {181, 409, 5, 14}, {302, 409, 5, 14}, {422, 409, 5, 14}, {433, 409, 7, 14}, 
  {87, 425, 5, 15}, {164, 425, 5, 15}, {184, 425, 5, 15}, {250, 425, 5, 15}, 
  {366, 425, 4, 15}, {458, 425, 5, 15}, {64, 442, 4, 14}, {74, 442, 5, 14}, 
  {91, 442, 5, 14}, {127, 442, 4, 14}, {172, 442, 5, 14}, {207, 442, 4, 14}, 
  {389, 442, 5, 14}, {150, 458, 5, 15}, {161, 458, 7, 15}, {174, 458, 4, 15}, 
  {205, 458, 5, 15}, {210, 458, 4, 15}, {258, 458, 5, 15}, {329, 458, 5, 15}, 
  {445, 458, 5, 15}, {477, 458, 4, 15}, {511, 458, 6, 15}, {101, 475, 7, 14}, 
  {122, 475, 5, 14}, {153, 475, 4, 14}, {214, 475, 5, 14}, {225, 475, 4, 14}, 
  {312, 475, 5, 14}, {348, 475, 4, 14}, {356, 475, 4, 14}, {475, 475, 5, 14}, 
  {132, 492, 5, 14}, {140, 492, 5, 14}, {200, 492, 7, 14}, {278, 492, 5, 14}, 
  {323, 492, 5, 14}, {376, 508, 5, 14}, {425, 508, 5, 14}, {449, 508, 5, 14}, 
  {457, 508, 4, 14}, {485, 508, 4, 14}, {117, 548, 5, 14}, {190, 548, 5, 14}, 
  {220, 548, 4, 14}, {289, 548, 5, 14}, {324, 548, 7, 14}, {337, 548, 4, 14}, 
  {368, 548, 5, 14}, {373, 548, 4, 14}, {56, 565, 5, 14}, {125, 565, 4, 14}, 
  {214, 565, 5, 14}, {331, 565, 5, 14}, {357, 565, 4, 14}, {394, 565, 5, 14}, 
  {121, 581, 5, 14}, {201, 581, 5, 14}, {299, 581, 5, 14}, {362, 581, 5, 14}, 
  {419, 581, 5, 14}, {468, 581, 5, 14}, {491, 581, 5, 14}, {112, 598, 5, 14}, 
  {223, 598, 5, 14}, {257, 598, 6, 14}, {324, 598, 4, 14}, {328, 598, 5, 14}, 
  {386, 598, 5, 14}, {434, 598, 5, 14}, {490, 598, 4, 14}, {100, 614, 5, 15}, 
  {191, 614, 4, 15}, {262, 614, 5, 15}, {86, 638, 4, 14}, {125, 638, 5, 14}, 
  {172, 638, 5, 14}, {254, 638, 5, 14}, {375, 638, 5, 14}, {423, 638, 4, 14}, 
  {56, 654, 5, 15}, {184, 654, 5, 15}, {363, 654, 4, 15}, {153, 671, 5, 14}, 
  {176, 671, 5, 14}, {400, 671, 5, 14}, {423, 671, 5, 14}, {495, 671, 5, 14}, 
  {105, 688, 4, 14}, {116, 688, 4, 14}, {175, 688, 4, 14}, {185, 688, 5, 14}, 
  {268, 688, 5, 14}, {303, 688, 5, 14}, {329, 688, 5, 14}, {340, 688, 5, 14}, 
  {365, 688, 5, 14}, {119, 704, 4, 14}, {158, 704, 5, 14}, {351, 704, 5, 14}, 
  {412, 704, 5, 14}, {499, 704, 4, 14}, {81, 721, 5, 14}, {116, 721, 5, 14}, 
  {266, 721, 5, 14}, {343, 721, 4, 14}, {389, 721, 5, 14}, {443, 721, 5, 14}, 
  {480, 721, 5, 14}, {485, 721, 4, 14}, {513, 721, 5, 14}, {71, 737, 5, 14}, 
  {124, 737, 5, 14}, {160, 737, 4, 14}, {210, 737, 5, 14}, {227, 737, 5, 14}, 
  {326, 737, 5, 14}, {334, 737, 5, 14}, {365, 737, 5, 14}, {450, 737, 5, 14}, 
  {481, 737, 5, 14}, {512, 737, 6, 14}, {88, 754, 5, 14}, {184, 754, 4, 14}, 
  {250, 754, 4, 14}, {295, 754, 5, 14}, {360, 754, 4, 14}, {364, 754, 5, 14}, 
  {437, 754, 5, 14}, {123, 57, 5, 14}, {172, 57, 4, 14}, {201, 57, 5, 14}, 
  {248, 57, 5, 14}, {313, 57, 5, 14}, {457, 57, 5, 14}, {158, 73, 4, 15}, 
  {317, 73, 5, 15}, {369, 73, 5, 15}, {71, 90, 5, 14}, {76, 90, 4, 14}, 
  {113, 90, 4, 14}, {250, 90, 5, 14}, {345, 90, 5, 14}, {464, 90, 5, 14}, 
  {69, 106, 5, 15}, {126, 106, 5, 15}, {240, 106, 5, 15}, {251, 106, 5, 15}, 
  {374, 106, 5, 15}, {406, 106, 4, 15}, {441, 106, 5, 15}, {76, 123, 5, 14}, 
  {126, 123, 5, 14}, {131, 123, 4, 14}, {179, 123, 5, 14}, {239, 123, 5, 14}, 
  {250, 123, 5, 14}, {258, 123, 4, 14}, {344, 123, 5, 14}, {399, 123, 5, 14}, 
  {451, 123, 4, 14}, {74, 140, 4, 14}, {138, 140, 5, 14}, {205, 140, 5, 14}, 
  {301, 140, 5, 14}, {351, 140, 4, 14}, {420, 140, 5, 14}, {484, 140, 5, 14}, 
  {489, 140, 5, 14}, {71, 156, 5, 14}, {137, 156, 5, 14}, {145, 156, 5, 14}, 
  {180, 156, 5, 14}, {238, 156, 5, 14}, {284, 156, 5, 14}, {307, 156, 4, 14}, 
  {343, 156, 5, 14}, {442, 156, 5, 14}, {67, 173, 5, 14}, {99, 173, 4, 14}, 
  {135, 173, 4, 14}, {175, 173, 4, 14}, {217, 173, 5, 14}, {271, 173, 5, 14}, 
  {315, 173, 5, 14}, {340, 173, 4, 14}, {353, 173, 5, 14}, {56, 196, 7, 14}, 
  {69, 196, 5, 14}, {100, 196, 5, 14}, {105, 196, 5, 14}, {141, 196, 5, 14}, 
  {201, 196, 5, 14}, {289, 196, 5, 14}, {430, 196, 4, 14}, {440, 196, 5, 14}, 
  {482, 196, 5, 14}, {142, 213, 5, 14}, {153, 213, 5, 14}, {252, 213, 5, 14}, 
  {349, 213, 4, 14}, {447, 213, 4, 14}, {470, 213, 5, 14}, {522, 213, 6, 14}, 
  {285, 229, 5, 14}, {307, 229, 5, 14}, {398, 229, 4, 14}, {470, 229, 5, 14}, 
  {186, 246, 5, 14}, {303, 246, 5, 14}, {348, 246, 5, 14}, {412, 246, 5, 14}, 
  {462, 246, 4, 14}, {484, 246, 5, 14}, {507, 246, 6, 14}, {184, 262, 4, 15}, 
  {194, 262, 5, 15}, {217, 262, 5, 15}, {228, 262, 5, 15}, {258, 262, 5, 15}, 
  {286, 262, 5, 15}, {326, 262, 5, 15}, {349, 262, 5, 15}, {360, 262, 4, 15}, 
  {424, 262, 4, 15}, {428, 262, 5, 15}, {491, 262, 5, 15}, {100, 279, 4, 14}, 
  {140, 279, 5, 14}, {244, 279, 5, 14}, {305, 279, 5, 14}, {346, 279, 5, 14}, 
  {441, 279, 5, 14}, {512, 279, 5, 14}, {149, 295, 4, 15}, {183, 295, 4, 15}, 
  {248, 295, 4, 15}, {299, 295, 5, 15}, {371, 295, 5, 15}, {466, 295, 5, 15}, 
  {84, 312, 5, 14}, {128, 312, 4, 14}, {257, 312, 5, 14}, {326, 312, 5, 14}, 
  {358, 312, 5, 14}, {421, 312, 5, 14}, {511, 312, 6, 14}, {81, 329, 5, 14}, 
  {86, 329, 4, 14}, {160, 352, 4, 14}, {208, 352, 5, 14}, {340, 352, 5, 14}, 
  {445, 352, 5, 14}, {94, 369, 5, 14}, {212, 369, 5, 14}, {258, 369, 5, 14}, 
  {268, 369, 5, 14}, {343, 369, 4, 14}, {56, 385, 5, 14}, {86, 385, 4, 14}, 
  {109, 385, 4, 14}, {119, 385, 5, 14}, {183, 385, 5, 14}, {212, 385, 4, 14}, 
  {234, 385, 5, 14}, {257, 385, 5, 14}, {118, 402, 5, 14}, {191, 402, 5, 14}, 
  {228, 402, 5, 14}, {266, 402, 5, 14}, {392, 402, 5, 14}, {98, 418, 5, 15}, 
  {302, 435, 5, 14}, {430, 435, 4, 14}, {444, 435, 4, 14}, {475, 435, 5, 14}, 
  {79, 451, 5, 15}, {108, 451, 5, 15}, {141, 451, 4, 15}, {149, 451, 4, 15}, 
  {172, 451, 4, 15}, {74, 475, 4, 14}, {120, 475, 5, 14}, {251, 475, 5, 14}, 
  {312, 475, 5, 14}, {445, 475, 5, 14}, {103, 492, 5, 14}, {108, 492, 4, 14}, 
  {175, 492, 4, 14}, {200, 492, 5, 14}, {376, 492, 5, 14}, {453, 492, 5, 14}, 
  {508, 492, 4, 14}, {144, 508, 5, 14}, {236, 508, 4, 14}, {253, 508, 4, 14}, 
  {285, 508, 5, 14}, {296, 508, 4, 14}, {356, 508, 5, 14}, {463, 508, 5, 14}, 
  {150, 525, 4, 14}, {206, 525, 5, 14}, {347, 525, 4, 14}, {470, 525, 5, 14}, 
  {128, 541, 5, 14}, {191, 541, 5, 14}, {246, 541, 4, 14}, {275, 541, 5, 14}, 
  {283, 541, 4, 14}, {510, 541, 5, 14}, {85, 558, 4, 14}, {146, 558, 4, 14}, 
  {210, 558, 5, 14}, {118, 574, 5, 14}, {123, 574, 4, 14}, {168, 574, 4, 14}, 
  {176, 574, 4, 14}, {191, 574, 4, 14}, {201, 574, 5, 14}, {212, 574, 5, 14}, 
  {379, 574, 4, 14}, {402, 574, 5, 14}, {420, 574, 5, 14}, {451, 574, 5, 14}, 
  {478, 574, 4, 14}, {243, 591, 4, 14}, {272, 591, 4, 14}, {358, 591, 5, 14}, 
  {405, 591, 5, 14}, {437, 591, 5, 14}, {82, 614, 5, 15}, {124, 614, 5, 15}, 
  {156, 614, 5, 15}, {346, 614, 4, 15}, {368, 614, 5, 15}, {373, 614, 4, 15}, 
  {109, 631, 5, 14}, {135, 631, 5, 14}, {412, 631, 5, 14}, {131, 647, 5, 15}, 
  {175, 647, 5, 15}, {247, 647, 5, 15}, {324, 647, 5, 15}, {355, 647, 5, 15}, 
  {426, 647, 5, 15}, {439, 647, 5, 15}, {470, 647, 4, 15}, {481, 647, 6, 15}, 
  {68, 664, 4, 14}, {145, 664, 5, 14}, {405, 664, 4, 14}, {428, 664, 4, 14}, 
  {435, 664, 5, 14}, {466, 664, 5, 14}, {516, 664, 4, 14}, {56, 681, 5, 14}, 
  {211, 681, 5, 14}, {250, 681, 5, 14}, {302, 681, 4, 14}, {351, 681, 4, 14}, 
  {467, 681, 5, 14}, {490, 681, 6, 14}, {95, 697, 5, 14}, {204, 697, 7, 14}, 
  {281, 697, 5, 14}, {366, 697, 5, 14}, {74, 721, 5, 14}, {134, 721, 5, 14}, 
  {198, 721, 5, 14}, {247, 721, 5, 14}, {302, 721, 5, 14}, {374, 721, 4, 14}, 
  {133, 737, 5, 14}, {188, 737, 5, 14}, {258, 737, 5, 14}, {300, 737, 5, 14}, 
  {330, 737, 5, 14}, {379, 737, 5, 14}, {390, 737, 5, 14}, {500, 737, 4, 14}, 
  {224, 754, 5, 14}, {326, 754, 4, 14}, {398, 754, 4, 14}, {109, 770, 5, 15}, 
  {176, 770, 4, 15}, {195, 770, 4, 15}, {238, 770, 4, 15}, {296, 770, 5, 15}, 
  {339, 770, 5, 15}, {442, 770, 5, 15}, {447, 770, 5, 15}, {525, 770, 5, 15}, 
  {100, 57, 4, 14}, {215, 57, 4, 14}, {248, 57, 5, 14}, {263, 57, 5, 14}, 
  {274, 57, 5, 14}, {301, 57, 5, 14}, {314, 57, 5, 14}, {322, 57, 5, 14}, 
  {353, 57, 5, 14}, {389, 57, 5, 14}, {481, 57, 5, 14}, {104, 73, 5, 15}, 
  {420, 73, 4, 15}, {451, 73, 5, 15}, {97, 90, 5, 14}, {114, 90, 5, 14}, 
  {431, 90, 6, 14}, {443, 90, 5, 14}, {475, 90, 4, 14}, {479, 90, 5, 14}, 
  {532, 90, 5, 14}, {88, 106, 5, 15}, {130, 106, 5, 15}, {141, 106, 6, 15}, 
  {385, 106, 4, 15}, {443, 106, 5, 15}, {462, 106, 4, 15}, {95, 147, 5, 14}, 
  {201, 147, 4, 14}, {305, 147, 5, 14}, {379, 147, 5, 14}, {413, 147, 5, 14}, 
  {454, 147, 4, 14}, {491, 147, 5, 14}, {105, 163, 4, 14}, {137, 163, 4, 14}, 
  {260, 163, 5, 14}, {474, 163, 4, 14}, {101, 180, 4, 14}, {152, 180, 5, 14}, 
  {213, 180, 5, 14}, {277, 180, 5, 14}, {421, 180, 5, 14}, {116, 196, 5, 14}, 
  {180, 196, 5, 14}, {191, 196, 4, 14}, {315, 196, 5, 14}, {451, 196, 4, 14}, 
  {88, 213, 5, 14}, {111, 213, 4, 14}, {115, 213, 5, 14}, {169, 213, 5, 14}, 
  {453, 213, 5, 14}, {136, 229, 5, 14}, {144, 229, 4, 14}, {166, 229, 4, 14}, 
  {197, 229, 5, 14}, {268, 229, 4, 14}, {352, 229, 4, 14}, {359, 229, 5, 14}, 
  {425, 229, 4, 14}, {433, 229, 4, 14}, {452, 229, 5, 14}, {88, 246, 4, 14}, 
  {129, 246, 4, 14}, {263, 246, 5, 14}, {274, 246, 4, 14}, {281, 246, 5, 14}, 
  {316, 246, 5, 14}, {94, 262, 5, 15}, {135, 262, 4, 15}, {166, 262, 5, 15}, 
  {233, 262, 5, 15}, {241, 262, 5, 15}, {56, 286, 7, 14}, {69, 286, 5, 14}, 
  {100, 286, 5, 14}, {105, 286, 5, 14}, {359, 286, 4, 14}, {393, 286, 5, 14}, 
  {432, 286, 4, 14}, {497, 286, 4, 14}, {168, 302, 5, 15}, {270, 302, 4, 15}, 
  {292, 302, 5, 15}, {452, 302, 5, 15}, {493, 302, 5, 15}, {78, 319, 4, 14}, 
  {130, 319, 5, 14}, {153, 319, 5, 14}, {164, 319, 4, 14}, {181, 319, 4, 14}, 
  {232, 319, 5, 14}, {305, 319, 5, 14}, {316, 319, 5, 14}, {367, 319, 5, 14}, 
  {113, 336, 5, 14}, {133, 336, 4, 14}, {219, 336, 4, 14}, {269, 336, 5, 14}, 
  {320, 336, 5, 14}, {416, 336, 4, 14}, {471, 336, 5, 14}, {88, 352, 5, 14}, 
  {221, 352, 4, 14}, {238, 352, 4, 14}, {329, 352, 4, 14}, {346, 352, 4, 14}, 
  {363, 352, 5, 14}, {440, 352, 5, 14}, {465, 352, 5, 14}, {496, 352, 5, 14}, 
  {72, 369, 4, 14}, {110, 369, 5, 14}, {230, 369, 5, 14}, {261, 369, 5, 14}, 
  {286, 369, 5, 14}, {341, 369, 5, 14}, {383, 369, 5, 14}, {459, 369, 5, 14}, 
  {503, 369, 5, 14}, {139, 385, 5, 14}, {174, 385, 5, 14}, {221, 385, 4, 14}, 
  {273, 385, 4, 14}, {332, 385, 5, 14}, {427, 385, 4, 14}, {532, 385, 6, 14}, 
  {140, 402, 5, 14}, {148, 402, 4, 14}, {170, 402, 5, 14}, {294, 402, 5, 14}, 
  {389, 402, 4, 14}, {494, 402, 5, 14}, {100, 442, 4, 14}, {122, 442, 4, 14}, 
  {259, 442, 5, 14}, {334, 442, 5, 14}, {342, 442, 4, 14}, {371, 442, 5, 14}, 
  {393, 442, 5, 14}, {398, 442, 5, 14}, {94, 458, 5, 15}, {145, 458, 5, 15}, 
  {248, 458, 4, 15}, {258, 458, 5, 15}, {301, 458, 6, 15}, {352, 458, 5, 15}, 
  {408, 458, 5, 15}, {125, 475, 5, 14}, {157, 475, 4, 14}, {182, 475, 4, 14}, 
  {280, 475, 5, 14}, {177, 492, 5, 14}, {212, 492, 5, 14}, {312, 492, 5, 14}, 
  {352, 492, 5, 14}, {422, 492, 5, 14}, {453, 492, 4, 14}, {80, 508, 5, 14}, 
  {104, 508, 5, 14}, {177, 508, 5, 14}, {219, 508, 5, 14}, {279, 508, 5, 14}, 
  {308, 508, 5, 14}, {357, 508, 5, 14}, {388, 508, 4, 14}, {504, 508, 5, 14}, 
  {255, 525, 5, 14}, {301, 525, 5, 14}, {343, 525, 5, 14}, {439, 525, 4, 14}, 
  {470, 525, 5, 14}, {527, 525, 6, 14}, {72, 541, 4, 14}, {118, 541, 5, 14}, 
  {180, 541, 5, 14}, {191, 541, 4, 14}, {208, 541, 4, 14}, {287, 541, 4, 14}, 
  {462, 541, 4, 14}, {497, 541, 5, 14}, {502, 541, 5, 14}, {205, 581, 5, 14}, 
  {281, 581, 5, 14}, {56, 598, 5, 14}, {124, 598, 4, 14}, {280, 598, 5, 14}, 
  {311, 598, 4, 14}, {361, 598, 5, 14}, {518, 598, 6, 14}, {71, 614, 5, 15}, 
  {76, 614, 4, 15}, {121, 614, 4, 15}, {196, 614, 4, 15}, {244, 614, 5, 15}, 
  {339, 614, 5, 15}, {369, 614, 4, 15}, {94, 631, 5, 14}, {162, 631, 4, 14}, 
  {294, 631, 5, 14}, {380, 631, 5, 14}, {391, 631, 4, 14}, {498, 631, 5, 14}, 
  {521, 631, 5, 14}, {56, 647, 5, 15}, {182, 647, 5, 15}, {94, 671, 5, 14}, 
  {116, 671, 5, 14}, {155, 671, 5, 14}, {201, 671, 5, 14}, {366, 671, 7, 14}, 
  {472, 671, 4, 14}, {119, 688, 5, 14}, {182, 688, 5, 14}, {199, 688, 5, 14}, 
  {283, 688, 5, 14}, {373, 688, 5, 14}, {471, 688, 4, 14}, {98, 704, 5, 14}, 
  {129, 704, 4, 14}, {184, 704, 5, 14}, {189, 704, 4, 14}, {328, 704, 5, 14}, 
  {139, 721, 4, 14}, {190, 721, 5, 14}, {241, 721, 5, 14}, {272, 721, 5, 14}, 
  {313, 721, 4, 14}, {404, 721, 5, 14}, {512, 721, 5, 14}, {122, 737, 5, 14}, 
  {133, 737, 5, 14}, {282, 737, 5, 14}, {351, 737, 4, 14}, {366, 737, 4, 14}, 
  {376, 737, 5, 14}, {460, 737, 4, 14}, {467, 737, 5, 14}, {105, 754, 4, 14}, 
  {115, 754, 5, 14}, {123, 754, 5, 14}, {181, 754, 5, 14}, {248, 754, 5, 14}, 
  {259, 754, 5, 14}, {332, 754, 4, 14}, {419, 754, 5, 14}, {78, 57, 4, 14}, 
  {339, 57, 5, 14}, {370, 57, 5, 14}, {429, 57, 4, 14}, {496, 57, 4, 14}, 
  {158, 73, 5, 15}, {169, 73, 4, 15}, {261, 73, 5, 15}, {315, 73, 5, 15}, 
  {369, 73, 5, 15}, {418, 73, 5, 15}, {474, 73, 5, 15}, {128, 97, 5, 14}, 
  {167, 97, 4, 14}, {317, 97, 4, 14}, {373, 97, 5, 14}, {381, 97, 5, 14}, 
  {409, 97, 5, 14}, {499, 97, 5, 14}, {161, 113, 5, 15}, {174, 113, 5, 15}, 
  {226, 113, 5, 15}, {248, 113, 5, 15}, {381, 113, 5, 15}, {400, 113, 5, 15}, 
  {69, 130, 5, 14}, {166, 130, 5, 14}, {221, 130, 5, 14}, {250, 130, 4, 14}, 
  {449, 130, 5, 14}, {499, 130, 4, 14}, {266, 147, 5, 14}, {277, 147, 5, 14}, 
  {352, 147, 4, 14}, {435, 147, 5, 14}, {493, 147, 5, 14}, {197, 163, 4, 14}, 
  {387, 163, 4, 14}, {434, 163, 5, 14}, {56, 180, 5, 14}, {225, 180, 5, 14}, 
  {306, 180, 5, 14}, {503, 180, 5, 14}, {508, 180, 5, 14}, {113, 196, 5, 14}, 
  {166, 196, 5, 14}, {300, 196, 5, 14}, {305, 196, 4, 14}, {156, 213, 5, 14}, 
  {313, 213, 5, 14}, {343, 213, 5, 14}, {375, 213, 5, 14}, {404, 213, 5, 14}, 
  {418, 213, 5, 14}, {476, 213, 5, 14}, {66, 229, 4, 14}, {89, 229, 4, 14}, 
  {132, 229, 4, 14}, {201, 229, 5, 14}, {206, 229, 5, 14}, {244, 229, 4, 14}, 
  {361, 229, 5, 14}, {392, 229, 4, 14}, {439, 229, 4, 14}, {488, 229, 5, 14}, 
  {125, 246, 4, 14}, {160, 246, 5, 14}, {174, 246, 4, 14}, {205, 246, 5, 14}, 
  {241, 246, 5, 14}, {279, 246, 6, 14}, {372, 246, 5, 14}, {520, 246, 4, 14}, 
  {114, 262, 4, 15}, {181, 262, 4, 15}, {191, 262, 5, 15}, {220, 262, 5, 15}, 
  {258, 262, 4, 15}, {298, 262, 5, 15}, {69, 286, 5, 14}, {140, 286, 5, 14}, 
  {145, 286, 5, 14}, {222, 286, 5, 14}, {359, 286, 5, 14}, {481, 286, 5, 14}, 
  {260, 302, 4, 15}, {307, 302, 5, 15}, {474, 302, 6, 15}, {165, 319, 4, 14}, 
  {227, 319, 5, 14}, {261, 319, 4, 14}, {291, 319, 5, 14}, {204, 336, 5, 14}, 
  {227, 336, 5, 14}, {262, 336, 4, 14}, {272, 336, 5, 14}, {69, 359, 5, 14}, 
  {95, 359, 4, 14}, {105, 359, 5, 14}, {122, 359, 5, 14}, {439, 359, 5, 14}, 
  {514, 359, 5, 14}, {227, 376, 5, 14}, {251, 376, 5, 14}, {368, 376, 4, 14}, 
  {397, 376, 4, 14}, {122, 392, 5, 14}, {147, 392, 5, 14}, {213, 392, 5, 14}, 
  {457, 392, 4, 14}, {497, 392, 5, 14}, {90, 409, 4, 14}, {153, 409, 5, 14}, 
  {263, 409, 5, 14}, {283, 409, 5, 14}, {352, 409, 5, 14}, {363, 409, 4, 14}, 
  {95, 425, 5, 15}, {204, 425, 5, 15}, {236, 425, 4, 15}, {271, 425, 5, 15}, 
  {311, 425, 5, 15}, {354, 425, 5, 15}, {408, 425, 5, 15}, {452, 425, 5, 15}, 
  {477, 425, 4, 15}, {490, 425, 5, 15}, {271, 442, 4, 14}, {281, 442, 5, 14}, 
  {127, 465, 4, 15}, {331, 465, 5, 15}, {448, 465, 4, 15}, {119, 482, 4, 14}, 
  {149, 482, 5, 14}, {219, 482, 5, 14}, {283, 482, 5, 14}, {460, 482, 5, 14}, 
  {184, 499, 4, 14}, {224, 499, 5, 14}, {332, 499, 5, 14}, {372, 499, 5, 14}, 
  {394, 499, 5, 14}, {480, 499, 5, 14}, {488, 499, 5, 14}, {518, 499, 6, 14}, 
  {78, 515, 4, 14}, {142, 515, 5, 14}, {355, 515, 5, 14}, {383, 515, 5, 14}, 
  {441, 515, 4, 14}, {497, 515, 5, 14}, {502, 515, 5, 14}, {144, 532, 5, 14}, 
  {188, 532, 5, 14}, {316, 532, 5, 14}, {360, 532, 4, 14}, {403, 532, 5, 14}, 
  {56, 548, 5, 14}, {193, 548, 5, 14}, {204, 548, 5, 14}, {376, 548, 4, 14}, 
  {119, 572, 5, 14}, {132, 572, 5, 14}, {198, 572, 5, 14}, {336, 572, 5, 14}, 
  {353, 572, 5, 14}, {405, 572, 5, 14}, {66, 588, 4, 14}, {123, 588, 5, 14}, 
  {207, 588, 5, 14}, {260, 588, 5, 14}, {265, 588, 4, 14}, {325, 588, 5, 14}, 
  {423, 588, 5, 14}, {123, 605, 5, 14}, {155, 605, 5, 14}, {239, 605, 4, 14}, 
  {297, 605, 5, 14}, {336, 605, 5, 14}, {428, 605, 5, 14}, {436, 605, 5, 14}, 
  {466, 605, 4, 14}, {81, 621, 5, 15}, {89, 621, 5, 15}, {104, 621, 5, 15}, 
  {115, 621, 4, 15}, {243, 621, 5, 15}, {414, 621, 5, 15}, {439, 621, 5, 15}, 
  {495, 621, 4, 15}, {96, 638, 4, 14}, {154, 638, 5, 14}, {263, 638, 4, 14}, 
  {273, 638, 5, 14}, {351, 638, 5, 14}, {451, 638, 4, 14}, {461, 638, 5, 14}, 
  {493, 638, 6, 14}, {275, 654, 4, 15}, {372, 654, 5, 15}, {377, 654, 4, 15}, 
  {412, 654, 5, 15}, {218, 671, 5, 14}, {226, 671, 5, 14}, {249, 671, 5, 14}, 
  {330, 671, 5, 14}, {341, 671, 5, 14}, {411, 671, 5, 14}, {450, 671, 5, 14}, 
  {493, 671, 4, 14}, {156, 688, 5, 14}, {164, 688, 5, 14}, {94, 711, 5, 14}, 
  {145, 711, 5, 14}, {158, 711, 5, 14}, {188, 711, 5, 14}, {498, 711, 6, 14}, 
  {56, 728, 5, 14}, {87, 728, 5, 14}, {130, 728, 4, 14}, {143, 728, 5, 14}, 
  {189, 728, 5, 14}, {287, 728, 5, 14}, {418, 728, 5, 14}, {429, 728, 4, 14}, 
  {532, 728, 6, 14}, {144, 744, 5, 14}, {176, 744, 5, 14}, {270, 744, 4, 14}, 
  {391, 744, 5, 14}, {509, 744, 5, 14}, {107, 761, 5, 14}, {136, 761, 5, 14}, 
  {159, 761, 4, 14}, {188, 761, 5, 14}, {80, 57, 5, 14}, {123, 57, 4, 14}, 
  {153, 57, 5, 14}, {249, 57, 5, 14}, {300, 57, 5, 14}, {361, 57, 5, 14}, 
  {425, 57, 5, 14}, {475, 57, 7, 14}, {488, 57, 4, 14}, {519, 57, 5, 14}, 
  {524, 57, 4, 14}, {95, 73, 5, 15}, {139, 73, 5, 15}, {239, 73, 5, 15}, 
  {252, 73, 5, 15}, {405, 73, 4, 15}, {459, 73, 7, 15}, {516, 73, 4, 15}, 
  {111, 90, 5, 14}, {122, 90, 4, 14}, {187, 90, 4, 14}, {242, 90, 4, 14}, 
  {255, 90, 5, 14}, {263, 90, 4, 14}, {443, 90, 5, 14}, {135, 113, 4, 15}, 
  {148, 113, 4, 15}, {239, 113, 5, 15}, {267, 113, 5, 15}, {341, 113, 5, 15}, 
  {352, 113, 4, 15}, {389, 113, 4, 15}, {523, 113, 5, 15}, {56, 130, 7, 14}, 
  {69, 130, 5, 14}, {100, 130, 5, 14}, {105, 130, 5, 14}, {424, 130, 5, 14}, 
  {473, 130, 5, 14}, {505, 130, 5, 14}, {104, 147, 5, 14}, {136, 147, 5, 14}, 
  {246, 147, 4, 14}, {250, 147, 5, 14}, {303, 147, 4, 14}, {391, 147, 5, 14}, 
  {430, 147, 4, 14}, {468, 147, 4, 14}, {440, 163, 5, 14}, {114, 187, 5, 14}, 
  {291, 187, 5, 14}, {314, 187, 5, 14}, {346, 187, 5, 14}, {379, 187, 5, 14}, 
  {408, 187, 5, 14}, {488, 187, 5, 14}, {76, 203, 5, 14}, {151, 203, 5, 14}, 
  {187, 203, 4, 14}, {244, 203, 5, 14}, {107, 220, 4, 14}, {111, 220, 5, 14}, 
  {134, 220, 4, 14}, {212, 220, 4, 14}, {223, 220, 4, 14}, {319, 220, 5, 14}, 
  {396, 220, 5, 14}, {473, 220, 4, 14}, {486, 220, 5, 14}, {210, 236, 5, 14}, 
  {239, 236, 5, 14}, {261, 236, 5, 14}, {292, 236, 4, 14}, {353, 236, 4, 14}, 
  {430, 236, 5, 14}, {479, 236, 5, 14}, {92, 253, 5, 14}, {146, 253, 4, 14}, 
  {196, 253, 4, 14}, {215, 253, 5, 14}, {394, 253, 5, 14}, {74, 269, 5, 15}, 
  {97, 269, 5, 15}, {156, 269, 5, 15}, {178, 269, 4, 15}, {209, 269, 5, 15}, 
  {452, 269, 4, 15}, {521, 269, 5, 15}, {56, 286, 5, 14}, {176, 286, 5, 14}, 
  {223, 286, 5, 14}, {278, 286, 4, 14}, {285, 286, 5, 14}, {356, 286, 4, 14}, 
  {99, 309, 4, 15}, {198, 309, 5, 15}, {221, 309, 5, 15}, {298, 309, 5, 15}, 
  {347, 309, 5, 15}, {403, 309, 5, 15}, {456, 309, 5, 15}, {506, 309, 6, 15}, 
  {68, 326, 5, 14}, {189, 326, 4, 14}, {371, 326, 5, 14}, {390, 326, 5, 14}, 
  {440, 326, 5, 14}, {222, 343, 5, 14}, {282, 343, 5, 14}, {374, 343, 4, 14}, 
  {422, 343, 5, 14}, {446, 343, 4, 14}, {530, 343, 6, 14}, {88, 383, 5, 14}, 
  {133, 383, 5, 14}, {144, 383, 4, 14}, {167, 383, 4, 14}, {177, 383, 5, 14}, 
  {345, 383, 4, 14}, {388, 383, 4, 14}, {526, 383, 5, 14}, {95, 399, 5, 14}, 
  {135, 399, 4, 14}, {321, 399, 5, 14}, {344, 399, 4, 14}, {397, 399, 5, 14}, 
  {453, 399, 4, 14}, {353, 416, 4, 14}, {392, 416, 5, 14}, {109, 439, 4, 15}, 
  {119, 439, 5, 15}, {176, 439, 5, 15}, {239, 439, 4, 15}, {310, 439, 5, 15}, 
  {368, 439, 5, 15}, {397, 439, 5, 15}, {446, 439, 4, 15}, {453, 439, 5, 15}, 
  {485, 439, 4, 15}, {533, 439, 6, 15}, {145, 456, 5, 14}, {211, 456, 5, 14}, 
  {424, 456, 5, 14}, {195, 472, 5, 15}, {200, 472, 4, 15}, {285, 472, 5, 15}, 
  {293, 472, 4, 15}, {410, 472, 4, 15}, {442, 472, 4, 15}, {493, 472, 5, 15}, 
  {157, 489, 5, 14}, {184, 489, 5, 14}, {235, 489, 4, 14}, {457, 489, 5, 14}, 
  {519, 489, 4, 14}, {136, 506, 5, 14}, {216, 506, 5, 14}, {250, 506, 5, 14}, 
  {335, 506, 5, 14}, {400, 506, 5, 14}, {101, 546, 5, 14}, {135, 546, 5, 14}, 
  {188, 546, 7, 14}, {201, 546, 4, 14}, {232, 546, 5, 14}, {237, 546, 4, 14}, 
  {282, 546, 5, 14}, {341, 546, 5, 14}, {352, 546, 5, 14}, {485, 546, 5, 14}, 
  {179, 562, 5, 14}, {346, 562, 5, 14}, {414, 562, 5, 14}, {471, 562, 5, 14}, 
  {514, 562, 6, 14}, {202, 579, 5, 14}, {265, 579, 5, 14}, {304, 579, 4, 14}, 
  {381, 579, 5, 14}, {430, 579, 5, 14}, {486, 579, 4, 14}, {80, 595, 5, 14}, 
  {130, 595, 5, 14}, {150, 595, 5, 14}, {358, 595, 5, 14}, {366, 595, 5, 14}, 
  {453, 595, 4, 14}, {85, 612, 5, 14}, {56, 635, 7, 15}, {116, 635, 5, 15}, 
  {179, 635, 5, 15}, {208, 635, 5, 15}, {231, 635, 5, 15}, {345, 635, 5, 15}, 
  {384, 635, 5, 15}, {427, 635, 4, 15}, {72, 652, 4, 14}, {82, 652, 5, 14}, 
  {106, 652, 5, 14}, {194, 652, 5, 14}, {202, 652, 5, 14}, {243, 652, 4, 14}, 
  {292, 652, 5, 14}, {362, 652, 6, 14}, {430, 652, 5, 14}, {56, 668, 7, 15}, 
  {109, 668, 5, 15}, {148, 668, 5, 15}, {192, 668, 5, 15}, {330, 668, 5, 15}, 
  {370, 668, 5, 15}, {416, 668, 5, 15}, {152, 685, 5, 14}, {331, 685, 4, 14}, 
  {391, 685, 5, 14}, {414, 685, 4, 14}, {471, 685, 5, 14}, {501, 685, 5, 14}, 
  {100, 709, 4, 14}, {122, 709, 5, 14}, {208, 709, 5, 14}, {260, 709, 5, 14}, 
  {348, 709, 7, 14}, {382, 709, 4, 14}, {411, 709, 5, 14}, {440, 709, 5, 14}, 
  {56, 725, 5, 14}, {86, 725, 4, 14}, {132, 725, 5, 14}, {137, 725, 5, 14}, 
  {229, 725, 4, 14}, {362, 725, 4, 14}, {484, 725, 5, 14}, {135, 742, 4, 14}, 
  {158, 742, 4, 14}, {235, 742, 5, 14}, {284, 742, 5, 14}, {340, 742, 5, 14}, 
  {393, 742, 5, 14}, {443, 742, 5, 14}, {463, 742, 5, 14}, {91, 57, 7, 14}, 
  {128, 57, 4, 14}, {169, 57, 4, 14}, {479, 57, 5, 14}, {519, 57, 5, 14}, 
  {119, 73, 4, 15}, {144, 73, 5, 15}, {173, 73, 5, 15}, {354, 73, 4, 15}, 
  {78, 97, 4, 14}, {175, 97, 5, 14}, {281, 97, 5, 14}, {348, 97, 5, 14}, 
  {399, 97, 5, 14}, {452, 97, 5, 14}, {496, 97, 5, 14}, {519, 97, 5, 14}, 
  {77, 113, 5, 15}, {108, 113, 5, 15}, {139, 113, 5, 15}, {203, 113, 4, 15}, 
  {220, 113, 4, 15}, {368, 113, 5, 15}, {436, 113, 5, 15}, {148, 130, 5, 14}, 
  {228, 130, 4, 14}, {245, 130, 4, 14}, {255, 130, 5, 14}, {299, 130, 4, 14}, 
  {397, 130, 5, 14}, {417, 130, 4, 14}, {469, 130, 5, 14}, {477, 130, 4, 14}, 
  {56, 147, 5, 14}, {88, 147, 4, 14}, {191, 147, 5, 14}, {218, 147, 5, 14}, 
  {247, 147, 5, 14}, {270, 147, 4, 14}, {364, 147, 5, 14}, {72, 163, 4, 14}, 
  {100, 163, 5, 14}, {252, 163, 5, 14}, {326, 163, 5, 14}, {380, 163, 5, 14}, 
  {385, 163, 5, 14}, {452, 163, 5, 14}, {477, 163, 5, 14}, {171, 180, 4, 14}, 
  {247, 180, 5, 14}, {302, 180, 5, 14}, {389, 180, 5, 14}, {418, 180, 5, 14}, 
  {120, 196, 5, 14}, {178, 196, 4, 14}, {188, 196, 5, 14}, {56, 220, 7, 14}, 
  {89, 220, 4, 14}, {151, 220, 5, 14}, {156, 220, 5, 14}, {177, 220, 5, 14}, 
  {209, 220, 4, 14}, {407, 220, 5, 14}, {447, 220, 5, 14}, {497, 220, 5, 14}, 
  {508, 220, 5, 14}, {110, 236, 5, 14}, {322, 236, 4, 14}, {425, 236, 5, 14}, 
  {234, 253, 4, 14}, {256, 253, 5, 14}, {300, 253, 5, 14}, {311, 253, 4, 14}, 
  {362, 253, 5, 14}, {496, 253, 4, 14}, {522, 253, 5, 14}, {80, 269, 5, 15}, 
  {130, 269, 5, 15}, {227, 269, 5, 15}, {266, 269, 4, 15}, {301, 269, 5, 15}, 
  {354, 269, 4, 15}, {445, 269, 5, 15}, {468, 269, 5, 15}, {479, 269, 5, 15}, 
  {156, 286, 5, 14}, {164, 286, 4, 14}, {204, 286, 6, 14}, {216, 286, 5, 14}, 
  {248, 286, 4, 14}, {252, 286, 5, 14}, {474, 286, 4, 14}, {504, 286, 6, 14}, 
  {68, 302, 4, 15}, {155, 302, 5, 15}, {195, 302, 4, 15}, {202, 302, 5, 15}, 
  {242, 302, 7, 15}, {320, 302, 5, 15}, {352, 302, 7, 15}, {365, 302, 4, 15}, 
  {396, 302, 5, 15}, {401, 302, 4, 15}, {487, 302, 5, 15}, {492, 302, 5, 15}, 
  {88, 319, 5, 14}, {171, 319, 5, 14}, {229, 319, 5, 14}, {314, 319, 4, 14}, 
  {401, 319, 5, 14}, {128, 343, 5, 14}, {203, 343, 5, 14}, {232, 343, 5, 14}, 
  {249, 343, 5, 14}, {260, 343, 5, 14}, {344, 343, 5, 14}, {439, 343, 5, 14}, 
  {463, 343, 5, 14}, {512, 343, 5, 14}, {68, 359, 5, 14}, {183, 359, 5, 14}, 
  {196, 359, 5, 14}, {230, 359, 5, 14}, {276, 359, 7, 14}, {339, 359, 4, 14}, 
  {346, 359, 5, 14}, {422, 359, 5, 14}, {132, 376, 4, 14}, {283, 376, 5, 14}, 
  {357, 376, 5, 14}, {368, 376, 6, 14}, {95, 392, 5, 14}, {127, 392, 5, 14}, 
  {394, 392, 4, 14}, {452, 392, 5, 14}, {475, 392, 4, 14}, {275, 409, 5, 14}, 
  {297, 409, 5, 14}, {302, 409, 4, 14}, {392, 409, 5, 14}, {161, 425, 5, 15}, 
  {245, 425, 5, 15}, {56, 449, 7, 14}, {92, 449, 4, 14}, {148, 449, 5, 14}, 
  {302, 449, 5, 14}, {353, 449, 7, 14}, {406, 449, 4, 14}, {92, 465, 5, 15}, 
  {146, 465, 5, 15}, {225, 465, 4, 15}, {307, 465, 5, 15}, {359, 465, 7, 15}, 
  {441, 465, 5, 15}, {504, 465, 5, 15}, {74, 482, 4, 14}, {147, 482, 5, 14}, 
  {158, 482, 5, 14}, {249, 482, 5, 14}, {269, 482, 5, 14}, {313, 482, 4, 14}, 
  {378, 482, 5, 14}, {486, 482, 5, 14}, {56, 499, 7, 14}, {69, 499, 5, 14}, 
  {100, 499, 5, 14}, {105, 499, 5, 14}, {135, 499, 4, 14}, {148, 499, 5, 14}, 
  {156, 499, 4, 14}, {277, 499, 5, 14}, {356, 499, 4, 14}, {207, 522, 5, 14}, 
  {345, 522, 4, 14}, {375, 522, 5, 14}, {487, 522, 4, 14}, {119, 539, 5, 14}, 
  {142, 539, 4, 14}, {244, 539, 5, 14}, {284, 539, 4, 14}, {288, 539, 5, 14}, 
  {374, 539, 4, 14}, {412, 539, 4, 14}, {422, 539, 5, 14}, {69, 555, 5, 14}, 
  {354, 555, 5, 14}, {367, 555, 5, 14}, {439, 555, 5, 14}, {126, 572, 5, 14}, 
  {165, 572, 5, 14}, {336, 572, 4, 14}, {69, 595, 5, 14}, {139, 595, 4, 14}, 
  {162, 595, 4, 14}, {313, 595, 5, 14}, {342, 595, 4, 14}, {415, 595, 5, 14}, 
  {81, 612, 5, 14}, {127, 612, 5, 14}, {240, 612, 4, 14}, {250, 612, 5, 14}, 
  {303, 612, 5, 14}, {385, 612, 4, 14}, {197, 628, 5, 15}, {362, 628, 4, 15}, 
  {489, 628, 5, 15}, {186, 645, 4, 14}, {208, 645, 5, 14}, {334, 645, 4, 14}, 
  {406, 645, 4, 14}, {64, 661, 4, 15}, {74, 661, 5, 15}, {97, 661, 4, 15}, 
  {107, 661, 5, 15}, {164, 661, 5, 15}, {248, 661, 5, 15}, {341, 661, 5, 15}, 
  {430, 661, 4, 15}, {449, 661, 5, 15}, {500, 661, 5, 15}, {56, 678, 5, 14}, 
  {88, 678, 4, 14}, {122, 678, 5, 14}, {149, 678, 4, 14}, {202, 678, 5, 14}, 
  {247, 678, 5, 14}, {252, 678, 4, 14}, {288, 678, 4, 14}, {311, 678, 5, 14}, 
  {388, 678, 5, 14}, {437, 678, 5, 14}, {493, 678, 5, 14}, {80, 695, 5, 14}, 
  {130, 695, 5, 14}, {150, 695, 5, 14}, {345, 695, 5, 14}, {417, 695, 5, 14}, 
  {74, 718, 5, 14}, {174, 718, 5, 14}, {261, 718, 5, 14}, {396, 718, 5, 14}, 
  {468, 718, 5, 14}, {139, 735, 5, 14}, {147, 735, 4, 14}, {178, 735, 5, 14}, 
  {422, 735, 5, 14}, {474, 735, 4, 14}, {74, 751, 4, 14}, {138, 751, 5, 14}, 
  {226, 751, 5, 14}, {335, 751, 5, 14}, {367, 751, 4, 14}, {403, 751, 4, 14}, 
  {443, 751, 4, 14}, {485, 751, 5, 14}, {80, 768, 5, 14}, {124, 768, 5, 14}, 
  {149, 768, 4, 14}, {162, 768, 5, 14}, {224, 768, 5, 14}, {389, 768, 4, 14}, 
  {408, 768, 4, 14}, {464, 768, 7, 14}, {477, 768, 4, 14}, {508, 768, 5, 14}, 
  {513, 768, 4, 14}, {108, 57, 5, 14}, {298, 57, 5, 14}, {303, 57, 4, 14}, 
  {411, 57, 4, 14}, {454, 57, 5, 14}, {473, 57, 5, 14}, {97, 73, 5, 15}, 
  {236, 73, 5, 15}, {359, 73, 5, 15}, {405, 73, 5, 15}, {462, 73, 5, 15}, 
  {95, 113, 5, 15}, {127, 113, 4, 15}, {174, 113, 5, 15}, {197, 113, 5, 15}, 
  {246, 113, 5, 15}, {328, 113, 4, 15}, {405, 113, 5, 15}, {416, 113, 5, 15}, 
  {488, 113, 5, 15}, {117, 130, 5, 14}, {171, 130, 4, 14}, {246, 130, 5, 14}, 
  {263, 130, 4, 14}, {387, 130, 5, 14}, {67, 147, 5, 14}, {207, 147, 5, 14}, 
  {218, 147, 5, 14}, {251, 147, 5, 14}, {268, 147, 5, 14}, {309, 147, 4, 14}, 
  {371, 147, 4, 14}, {381, 147, 5, 14}, {455, 147, 5, 14}, {62, 163, 4, 14}, 
  {76, 163, 6, 14}, {204, 163, 5, 14}, {289, 163, 5, 14}, {302, 163, 5, 14}, 
  {342, 163, 5, 14}, {418, 163, 5, 14}, {83, 180, 5, 14}, {115, 180, 4, 14}, 
  {203, 180, 4, 14}, {248, 180, 5, 14}, {288, 180, 7, 14}, {301, 180, 5, 14}, 
  {332, 180, 5, 14}, {337, 180, 5, 14}, {461, 180, 5, 14}, {492, 180, 4, 14}, 
  {78, 196, 5, 14}, {241, 196, 5, 14}, {249, 196, 4, 14}, {138, 220, 5, 14}, 
  {192, 220, 5, 14}, {246, 220, 5, 14}, {295, 220, 5, 14}, {351, 220, 5, 14}, 
  {362, 220, 6, 14}, {81, 236, 5, 14}, {86, 236, 4, 14}, {145, 236, 5, 14}, 
  {177, 236, 5, 14}, {205, 236, 5, 14}, {345, 236, 5, 14}, {359, 236, 7, 14}, 
  {465, 236, 5, 14}, {201, 253, 5, 14}, {276, 253, 4, 14}, {357, 253, 5, 14}, 
  {365, 253, 5, 14}, {381, 253, 5, 14}, {451, 253, 4, 14}, {525, 253, 5, 14}, 
  {533, 253, 6, 14}, {71, 269, 4, 15}, {119, 269, 4, 15}, {200, 269, 5, 15}, 
  {256, 269, 5, 15}, {305, 269, 4, 15}, {368, 269, 5, 15}, {499, 269, 5, 15}, 
  {127, 286, 5, 14}, {224, 286, 4, 14}, {263, 286, 5, 14}, {295, 286, 5, 14}, 
  {300, 286, 5, 14}, {343, 286, 4, 14}, {477, 286, 5, 14}, {482, 286, 5, 14}, 
  {113, 302, 4, 15}, {177, 302, 4, 15}, {301, 302, 4, 15}, {311, 302, 5, 15}, 
  {138, 319, 4, 14}, {240, 319, 5, 14}, {309, 319, 4, 14}, {114, 336, 5, 14}, 
  {125, 336, 4, 14}, {182, 336, 4, 14}, {294, 336, 5, 14}, {299, 336, 4, 14}, 
  {315, 336, 6, 14}, {387, 336, 5, 14}, {398, 336, 5, 14}, {493, 336, 4, 14}, 
  {497, 336, 5, 14}, {142, 352, 5, 14}, {220, 376, 5, 14}, {228, 376, 5, 14}, 
  {236, 376, 5, 14}, {433, 376, 5, 14}, {233, 392, 5, 14}, {259, 392, 4, 14}, 
  {417, 392, 4, 14}, {491, 392, 4, 14}, {89, 409, 4, 14}, {138, 409, 4, 14}, 
  {194, 409, 4, 14}, {247, 409, 5, 14}, {297, 409, 4, 14}, {316, 409, 5, 14}, 
  {459, 409, 4, 14}, {124, 425, 5, 15}, {168, 425, 5, 15}, {233, 425, 4, 15}, 
  {97, 442, 5, 14}, {178, 442, 5, 14}, {216, 442, 5, 14}, {226, 442, 5, 14}, 
  {276, 442, 4, 14}, {315, 442, 5, 14}, {362, 442, 5, 14}, {367, 442, 4, 14}, 
  {380, 442, 4, 14}, {72, 458, 5, 15}, {112, 458, 5, 15}, {144, 458, 4, 15}, 
  {271, 458, 5, 15}, {308, 458, 5, 15}, {121, 482, 4, 14}, {179, 482, 5, 14}, 
  {211, 482, 4, 14}, {330, 482, 4, 14}, {435, 482, 4, 14}, {92, 499, 4, 14}, 
  {147, 499, 4, 14}, {469, 499, 5, 14}, {522, 499, 5, 14}, {107, 515, 5, 14}, 
  {170, 515, 5, 14}, {228, 515, 4, 14}, {241, 515, 4, 14}, {258, 515, 4, 14}, 
  {365, 515, 7, 14}, {378, 515, 4, 14}, {409, 515, 5, 14}, {414, 515, 4, 14}, 
  {451, 515, 5, 14}, {459, 515, 5, 14}, {488, 515, 5, 14}, {531, 515, 6, 14}, 
  {173, 532, 5, 14}, {354, 532, 4, 14}, {364, 532, 5, 14}, {435, 532, 5, 14}, 
  {151, 548, 4, 14}, {234, 548, 4, 14}, {308, 548, 4, 14}, {366, 548, 4, 14}, 
  {373, 548, 5, 14}, {471, 548, 5, 14}, {503, 548, 5, 14}, {508, 548, 5, 14}, 
  {115, 565, 7, 14}, {151, 565, 5, 14}, {182, 565, 5, 14}, {225, 565, 5, 14}, 
  {273, 565, 4, 14}, {305, 565, 5, 14}, {379, 565, 5, 14}, {470, 565, 5, 14}, 
  {502, 565, 5, 14}, {56, 581, 5, 14}, {56, 605, 7, 14}, {116, 605, 5, 14}, 
  {264, 605, 4, 14}, {445, 605, 5, 14}, {509, 605, 4, 14}, {516, 605, 5, 14}, 
  {157, 621, 4, 15}, {272, 621, 4, 15}, {390, 621, 4, 15}, {400, 621, 5, 15}, 
  {84, 638, 5, 14}, {232, 638, 5, 14}, {279, 638, 5, 14}, {310, 638, 5, 14}, 
  {403, 638, 4, 14}, {458, 638, 4, 14}, {509, 638, 5, 14}, {103, 654, 5, 15}, 
  {167, 654, 5, 15}, {260, 654, 5, 15}, {344, 654, 5, 15}, {367, 654, 5, 15}, 
  {410, 654, 5, 15}, {476, 654, 5, 15}, {525, 654, 5, 15}, {86, 671, 6, 14}, 
  {98, 671, 5, 14}, {130, 671, 4, 14}, {134, 671, 5, 14}, {177, 671, 5, 14}, 
  {281, 671, 7, 14}, {294, 671, 4, 14}, {325, 671, 5, 14}, {330, 671, 4, 14}, 
  {384, 671, 5, 14}, {427, 671, 5, 14}, {493, 671, 5, 14}, {82, 688, 4, 14}, 
  {185, 688, 5, 14}, {233, 688, 5, 14}, {264, 688, 5, 14}, {310, 688, 5, 14}, 
  {395, 688, 5, 14}, {453, 688, 5, 14}, {96, 704, 4, 14}, {193, 704, 6, 14}, 
  {205, 704, 5, 14}, {237, 704, 4, 14}, {241, 704, 5, 14}, {404, 704, 7, 14}, 
  {71, 721, 5, 14}, {169, 721, 4, 14}, {286, 721, 5, 14}, {300, 721, 5, 14}, 
  {313, 721, 5, 14}, {403, 721, 5, 14}, {73, 744, 5, 14}, {78, 744, 4, 14}, 
  {145, 744, 4, 14}, {170, 744, 5, 14}, {346, 744, 5, 14}, {423, 744, 5, 14}, 
  {478, 744, 4, 14}, {77, 761, 5, 14}, {108, 761, 5, 14}, {138, 761, 4, 14}, 
  {207, 761, 4, 14}, {234, 761, 4, 14}, {244, 761, 5, 14}, {269, 761, 5, 14}, 
  {319, 761, 5, 14}, {342, 761, 4, 14}, {371, 761, 5, 14}, {379, 761, 4, 14}, 
  {408, 761, 5, 14}, {419, 761, 6, 14}, {518, 761, 5, 14}, {171, 57, 5, 14}, 
  {185, 57, 4, 14}, {192, 57, 5, 14}, {291, 57, 4, 14}, {389, 57, 5, 14}, 
  {474, 57, 5, 14}, {89, 73, 5, 15}, {202, 73, 5, 15}, {317, 73, 5, 15}, 
  {372, 73, 5, 15}, {443, 73, 5, 15}, {62, 90, 4, 14}, {132, 90, 4, 14}, 
  {178, 90, 5, 14}, {214, 90, 4, 14}, {337, 90, 5, 14}, {447, 90, 5, 14}, 
  {119, 106, 5, 15}, {155, 106, 5, 15}, {333, 106, 4, 15}, {352, 106, 5, 15}, 
  {428, 106, 5, 15}, {88, 123, 5, 14}, {111, 123, 4, 14}, {360, 123, 5, 14}, 
  {423, 123, 5, 14}, {475, 123, 4, 14}, {524, 123, 6, 14}, {142, 140, 5, 14}, 
  {267, 140, 4, 14}, {307, 140, 5, 14}, {320, 140, 5, 14}, {367, 140, 5, 14}, 
  {413, 140, 5, 14}, {466, 140, 4, 14}, {470, 140, 5, 14}, {56, 180, 7, 14}, 
  {69, 180, 5, 14}, {100, 180, 5, 14}, {105, 180, 5, 14}, {175, 180, 4, 14}, 
  {216, 180, 4, 14}, {295, 180, 5, 14}, {341, 180, 5, 14}, {366, 180, 5, 14}, 
  {397, 180, 5, 14}, {499, 180, 5, 14}, {507, 180, 6, 14}, {71, 196, 5, 14}, 
  {123, 196, 5, 14}, {220, 196, 5, 14}, {319, 196, 5, 14}, {350, 196, 5, 14}, 
  {358, 196, 4, 14}, {458, 196, 5, 14}, {491, 196, 4, 14}, {499, 196, 4, 14}, 
  {170, 213, 5, 14}, {211, 213, 4, 14}, {270, 213, 5, 14}, {318, 213, 4, 14}, 
  {466, 213, 4, 14}, {99, 229, 4, 14}, {130, 229, 5, 14}, {166, 229, 5, 14}, 
  {206, 229, 5, 14}, {249, 229, 5, 14}, {303, 229, 5, 14}, {347, 229, 5, 14}, 
  {371, 229, 5, 14}, {385, 229, 4, 14}, {408, 229, 5, 14}, {472, 229, 4, 14}, 
  {532, 229, 6, 14}, {71, 246, 5, 14}, {115, 246, 5, 14}, {126, 246, 5, 14}, 
  {186, 246, 4, 14}, {275, 246, 5, 14}, {325, 246, 5, 14}, {342, 246, 4, 14}, 
  {429, 246, 5, 14}, {451, 246, 5, 14}, {520, 246, 6, 14}, {72, 262, 4, 15}, 
  {100, 262, 5, 15}, {233, 262, 5, 15}, {253, 262, 4, 15}, {284, 262, 5, 15}, 
  {336, 262, 4, 15}, {484, 262, 5, 15}, {82, 279, 4, 14}, {117, 279, 5, 14}, 
  {171, 279, 4, 14}, {343, 279, 5, 14}, {385, 279, 5, 14}, {423, 279, 4, 14}, 
  {111, 295, 5, 15}, {122, 295, 4, 15}, {159, 295, 5, 15}, {114, 319, 5, 14}, 
  {246, 319, 4, 14}, {317, 319, 4, 14}, {416, 319, 4, 14}, {71, 336, 5, 14}, 
  {208, 336, 5, 14}, {216, 336, 5, 14}, {257, 336, 5, 14}, {335, 336, 4, 14}, 
  {381, 336, 5, 14}, {167, 352, 4, 14}, {223, 352, 5, 14}, {246, 352, 5, 14}, 
  {297, 352, 5, 14}, {425, 352, 6, 14}, {437, 352, 5, 14}, {469, 352, 4, 14}, 
  {473, 352, 5, 14}, {119, 369, 4, 14}, {212, 369, 5, 14}, {273, 369, 5, 14}, 
  {362, 369, 5, 14}, {415, 369, 5, 14}, {462, 369, 4, 14}, {499, 369, 4, 14}, 
  {81, 385, 5, 14}, {86, 385, 4, 14}, {130, 385, 5, 14}, {147, 385, 5, 14}, 
  {178, 385, 5, 14}, {288, 385, 5, 14}, {435, 385, 4, 14}, {155, 402, 5, 14}, 
  {285, 402, 5, 14}, {464, 402, 4, 14}, {493, 402, 4, 14}, {523, 402, 5, 14}, 
  {186, 418, 5, 15}, {263, 418, 5, 15}, {294, 418, 4, 15}, {333, 418, 5, 15}, 
  {426, 418, 4, 15}, {451, 418, 4, 15}, {74, 442, 5, 14}, {97, 442, 5, 14}, 
  {247, 442, 5, 14}, {260, 442, 5, 14}, {301, 442, 5, 14}, {339, 442, 5, 14}, 
  {416, 442, 5, 14}, {465, 442, 5, 14}, {521, 442, 6, 14}, {102, 458, 5, 15}, 
  {152, 458, 5, 15}, {172, 458, 4, 15}, {372, 458, 5, 15}, {452, 458, 4, 15}, 
  {505, 458, 4, 15}, {147, 475, 5, 14}, {184, 475, 5, 14}, {213, 475, 5, 14}, 
  {237, 475, 5, 14}, {251, 475, 5, 14}, {312, 475, 4, 14}, {355, 475, 5, 14}, 
  {379, 475, 5, 14}, {124, 492, 5, 14}, {180, 492, 5, 14}, {248, 492, 5, 14}, 
  {322, 492, 5, 14}, {526, 492, 6, 14}, {71, 508, 7, 14}, {84, 508, 4, 14}, 
  {115, 508, 5, 14}, {120, 508, 4, 14}, {172, 508, 5, 14}, {204, 508, 5, 14}, 
  {291, 508, 4, 14}, {336, 508, 4, 14}, {340, 508, 5, 14}, {402, 508, 7, 14}, 
  {438, 508, 5, 14}, {78, 525, 4, 14}, {98, 525, 4, 14}, {128, 525, 5, 14}, 
  {239, 525, 5, 14}, {247, 525, 4, 14}, {299, 525, 5, 14}, {369, 525, 5, 14}, 
  {91, 548, 4, 14}, {101, 548, 5, 14}, {221, 548, 5, 14}, {338, 548, 4, 14}, 
  {407, 548, 7, 14}, {363, 565, 5, 14}, {410, 565, 5, 14}, {473, 565, 7, 14}, 
  {510, 565, 5, 14}, {524, 565, 5, 14}, {74, 581, 5, 14}, {180, 581, 4, 14}, 
  {190, 581, 5, 14}, {314, 581, 5, 14}, {363, 581, 4, 14}, {509, 581, 5, 14}, 
  {153, 598, 4, 14}, {225, 598, 5, 14}, {236, 598, 5, 14}, {301, 598, 5, 14}, 
  {346, 598, 5, 14}, {416, 598, 4, 14}, {74, 614, 4, 15}, {155, 614, 5, 15}, 
  {163, 614, 5, 15}, {171, 614, 4, 15}, {389, 614, 5, 15}, {447, 614, 7, 15}, 
  {483, 614, 5, 15}, {494, 614, 5, 15}, {104, 631, 5, 14}, {184, 631, 4, 14}, 
  {323, 631, 4, 14}, {355, 631, 4, 14}, {405, 631, 5, 14}, {418, 631, 5, 14}, 
  {94, 654, 5, 15}, {157, 654, 5, 15}, {185, 654, 5, 15}, {245, 654, 5, 15}, 
  {274, 654, 5, 15}, {284, 654, 5, 15}, {386, 654, 4, 15}, {435, 654, 5, 15}, 
  {187, 671, 5, 14}, {217, 671, 5, 14}, {313, 671, 5, 14}, {400, 671, 5, 14}, 
  {498, 671, 4, 14}, {530, 671, 5, 14}, {121, 688, 5, 14}, {156, 688, 4, 14}, 
  {265, 688, 5, 14}, {273, 688, 5, 14}, {354, 688, 5, 14}, {385, 688, 4, 14}, 
  {398, 688, 4, 14}, {462, 688, 5, 14}, {165, 704, 5, 14}, {176, 704, 6, 14}, 
  {248, 704, 5, 14}, {355, 704, 5, 14}, {450, 704, 4, 14}, {68, 721, 5, 14}, 
  {56, 737, 5, 14}, {265, 737, 5, 14}, {387, 737, 5, 14}, {518, 737, 5, 14}, 
  {56, 754, 5, 14}, {87, 754, 5, 14}, {146, 754, 7, 14}, {167, 754, 5, 14}, 
  {178, 754, 5, 14}, {464, 754, 5, 14}, {80, 770, 5, 15}, {69, 57, 5, 14}, 
  {159, 57, 5, 14}, {244, 57, 5, 14}, {273, 57, 5, 14}, {399, 57, 5, 14}, 
  {470, 57, 5, 14}, {188, 73, 4, 15}, {203, 73, 4, 15}, {213, 73, 5, 15}, 
  {257, 73, 4, 15}, {306, 73, 5, 15}, {377, 73, 5, 15}, {400, 73, 4, 15}, 
  {478, 73, 5, 15}, {510, 73, 5, 15}, {81, 90, 5, 14}, {92, 90, 6, 14}, 
  {104, 90, 5, 14}, {136, 90, 4, 14}, {140, 90, 5, 14}, {206, 90, 5, 14}, 
  {219, 90, 5, 14}, {334, 90, 5, 14}, {233, 106, 5, 15}, {246, 106, 5, 15}, 
  {282, 106, 5, 15}, {327, 106, 5, 15}, {371, 106, 5, 15}, {382, 106, 4, 15}, 
  {420, 106, 5, 15}, {483, 106, 5, 15}, {112, 123, 4, 14}, {141, 123, 4, 14}, 
  {172, 123, 5, 14}, {244, 123, 5, 14}, {296, 123, 4, 14}, {356, 123, 5, 14}, 
  {421, 123, 4, 14}, {500, 123, 5, 14}, {83, 140, 5, 14}, {131, 140, 5, 14}, 
  {155, 140, 5, 14}, {236, 140, 5, 14}, {113, 163, 4, 14}, {117, 163, 5, 14}, 
  {138, 163, 4, 14}, {183, 163, 4, 14}, {207, 163, 4, 14}, {237, 163, 5, 14}, 
  {284, 163, 5, 14}, {372, 163, 4, 14}, {520, 163, 4, 14}, {94, 180, 5, 14}, 
  {138, 180, 5, 14}, {266, 180, 5, 14}, {274, 180, 5, 14}, {97, 196, 5, 14}, 
  {108, 196, 6, 14}, {120, 196, 5, 14}, {152, 196, 4, 14}, {156, 196, 5, 14}, 
  {193, 196, 5, 14}, {219, 196, 4, 14}, {299, 196, 5, 14}, {304, 196, 5, 14}, 
  {334, 196, 5, 14}, {351, 196, 4, 14}, {382, 196, 5, 14}, {514, 196, 4, 14}, 
  {66, 213, 4, 14}, {138, 213, 5, 14}, {170, 213, 5, 14}, {193, 213, 5, 14}, 
  {224, 213, 4, 14}, {253, 213, 4, 14}, {296, 213, 5, 14}, {432, 213, 5, 14}, 
  {464, 213, 5, 14}, {143, 229, 5, 14}, {154, 229, 4, 14}, {177, 229, 5, 14}, 
  {207, 229, 5, 14}, {258, 229, 5, 14}, {311, 229, 5, 14}, {376, 229, 5, 14}, 
  {439, 229, 4, 14}, {456, 229, 4, 14}, {71, 246, 5, 14}, {76, 246, 4, 14}, 
  {141, 246, 4, 14}, {231, 246, 4, 14}, {293, 246, 5, 14}, {453, 246, 5, 14}, 
  {159, 262, 4, 15}, {242, 262, 5, 15}, {292, 262, 5, 15}, {354, 262, 5, 15}, 
  {394, 262, 7, 15}, {431, 262, 5, 15}, {448, 262, 5, 15}, {518, 262, 4, 15}, 
  {104, 279, 5, 14}, {160, 279, 5, 14}, {183, 279, 4, 14}, {285, 279, 4, 14}, 
  {382, 279, 4, 14}, {431, 279, 5, 14}, {482, 279, 5, 14}, {94, 295, 7, 15}, 
  {107, 295, 5, 15}, {138, 295, 5, 15}, {143, 295, 5, 15}, {156, 295, 5, 15}, 
  {482, 295, 4, 15}, {89, 312, 5, 14}, {108, 312, 5, 14}, {170, 312, 4, 14}, 
  {235, 312, 5, 14}, {69, 336, 5, 14}, {181, 336, 5, 14}, {344, 336, 4, 14}, 
  {489, 336, 5, 14}, {520, 336, 5, 14}, {148, 352, 5, 14}, {217, 352, 5, 14}, 
  {250, 352, 5, 14}, {258, 352, 5, 14}, {336, 352, 5, 14}, {455, 352, 4, 14}, 
  {480, 352, 5, 14}, {81, 369, 5, 14}, {112, 369, 4, 14}, {170, 369, 5, 14}, 
  {202, 369, 4, 14}, {324, 369, 5, 14}, {356, 369, 5, 14}, {466, 369, 5, 14}, 
  {506, 369, 4, 14}, {78, 385, 4, 14}, {135, 385, 5, 14}, {219, 385, 5, 14}, 
  {325, 385, 5, 14}, {356, 385, 4, 14}, {378, 385, 5, 14}, {383, 385, 4, 14}, 
  {185, 402, 4, 14}, {250, 402, 5, 14}, {322, 402, 5, 14}, {390, 402, 5, 14}, 
  {454, 402, 4, 14}, {80, 418, 5, 15}, {115, 418, 5, 15}, {154, 418, 5, 15}, 
  {200, 418, 4, 15}, {228, 418, 5, 15}, {359, 418, 4, 15}, {446, 418, 4, 15}, 
  {469, 418, 4, 15}, {74, 435, 5, 14}, {138, 435, 5, 14}, {69, 458, 5, 15}, 
  {221, 458, 4, 15}, {312, 458, 5, 15}, {320, 458, 4, 15}, {392, 458, 4, 15}, 
  {402, 458, 7, 15}, {448, 458, 5, 15}, {521, 458, 4, 15}, {181, 475, 4, 14}, 
  {206, 475, 4, 14}, {277, 475, 5, 14}, {313, 475, 5, 14}, {428, 475, 4, 14}, 
  {495, 475, 4, 14}, {56, 492, 5, 14}, {129, 492, 5, 14}, {175, 492, 4, 14}, 
  {270, 492, 4, 14}, {274, 492, 5, 14}, {352, 492, 5, 14}, {404, 492, 5, 14}, 
  {506, 492, 4, 14}, {516, 492, 5, 14}, {56, 508, 5, 14}, {122, 508, 5, 14}, 
  {191, 508, 5, 14}, {299, 508, 5, 14}, {514, 508, 5, 14}, {525, 508, 6, 14}, 
  {101, 525, 5, 14}, {145, 525, 5, 14}, {261, 525, 5, 14}, {316, 525, 4, 14}, 
  {348, 525, 5, 14}, {495, 525, 5, 14}, {107, 548, 4, 14}, {164, 548, 4, 14}, 
  {228, 548, 7, 14}, {324, 548, 4, 14}, {445, 548, 5, 14}, {468, 548, 5, 14}, 
  {158, 565, 5, 14}, {190, 565, 4, 14}, {322, 565, 5, 14}, {345, 565, 5, 14}, 
  {429, 565, 5, 14}, {440, 565, 4, 14}, {67, 581, 5, 14}, {216, 581, 5, 14}, 
  {304, 581, 7, 14}, {356, 581, 5, 14}, {468, 581, 4, 14}, {82, 598, 4, 14}, 
  {111, 598, 4, 14}, {167, 598, 5, 14}, {207, 598, 5, 14}, {260, 598, 4, 14}, 
  {329, 598, 4, 14}, {349, 598, 5, 14}, {394, 598, 4, 14}, {404, 598, 5, 14}, 
  {428, 598, 4, 14}, {529, 598, 6, 14}, {121, 614, 4, 15}, {189, 614, 5, 15}, 
  {314, 614, 5, 15}, {319, 614, 5, 15}, {410, 614, 4, 15}, {452, 614, 4, 15}, 
  {56, 631, 5, 14}, {116, 631, 4, 14}, {179, 631, 4, 14}, {203, 631, 5, 14}, 
  {216, 631, 5, 14}, {263, 631, 5, 14}, {271, 631, 5, 14}, {429, 631, 5, 14}, 
  {452, 631, 4, 14}, {502, 631, 5, 14}, {150, 647, 4, 15}, {238, 647, 5, 15}, 
  {270, 647, 5, 15}, {370, 647, 5, 15}, {384, 647, 4, 15}, {413, 647, 5, 15}, 
  {74, 671, 4, 14}, {150, 671, 5, 14}, {275, 671, 5, 14}, {316, 671, 4, 14}, 
  {485, 671, 4, 14}, {177, 688, 5, 14}, {211, 688, 5, 14}, {306, 688, 5, 14}, 
  {491, 688, 5, 14}, {502, 688, 5, 14}, {127, 704, 4, 14}, {154, 704, 5, 14}, 
  {159, 704, 4, 14}, {226, 704, 4, 14}, {251, 704, 5, 14}, {427, 704, 5, 14}, 
  {504, 704, 6, 14}, {103, 721, 5, 14}, {143, 721, 5, 14}, {240, 721, 5, 14}, 
  {251, 721, 5, 14}, {391, 721, 5, 14}, {455, 721, 5, 14}, {479, 721, 5, 14}, 
  {490, 721, 4, 14}, {56, 737, 5, 14}, {88, 737, 4, 14}, {204, 737, 5, 14}, 
  {248, 737, 5, 14}, {327, 737, 5, 14}, {376, 737, 5, 14}, {418, 737, 5, 14}, 
  {432, 737, 4, 14}, {80, 754, 5, 14}, {151, 754, 5, 14}, {253, 754, 4, 14}, 
  {263, 754, 5, 14}, {322, 754, 5, 14}, {390, 754, 5, 14}, {455, 754, 5, 14}, 
  {487, 754, 5, 14}, {126, 770, 4, 15}, {176, 770, 5, 15}, {225, 770, 4, 15}, 
  {238, 770, 4, 15}, {433, 770, 5, 15}, {56, 57, 5, 14}, {67, 57, 5, 14}, 
  {127, 57, 5, 14}, {187, 57, 5, 14}, {252, 57, 5, 14}, {435, 57, 5, 14}, 
  {84, 73, 5, 15}, {143, 73, 5, 15}, {174, 73, 5, 15}, {250, 73, 5, 15}, 
  {310, 73, 4, 15}, {441, 73, 5, 15}, {86, 90, 5, 14}, {74, 113, 4, 15}, 
  {105, 113, 5, 15}, {125, 113, 5, 15}, {136, 113, 4, 15}, {186, 113, 5, 15}, 
  {233, 113, 4, 15}, {272, 113, 5, 15}, {297, 113, 5, 15}, {69, 130, 5, 14}, 
  {183, 130, 4, 14}, {238, 130, 5, 14}, {311, 130, 5, 14}, {341, 130, 5, 14}, 
  {352, 130, 6, 14}, {364, 130, 5, 14}, {395, 130, 5, 14}, {400, 130, 5, 14}, 
  {95, 147, 5, 14}, {126, 147, 5, 14}, {172, 147, 5, 14}, {209, 147, 5, 14}, 
  {220, 147, 5, 14}, {392, 147, 5, 14}, {397, 147, 4, 14}, {475, 147, 4, 14}, 
  {97, 163, 5, 14}, {308, 163, 5, 14}, {423, 163, 5, 14}, {446, 163, 4, 14}, 
  {154, 180, 5, 14}, {342, 180, 5, 14}, {384, 180, 5, 14}, {56, 196, 5, 14}, 
  {223, 220, 5, 14}, {442, 220, 5, 14}, {497, 220, 4, 14}, {80, 236, 4, 14}, 
  {108, 236, 5, 14}, {139, 236, 5, 14}, {204, 236, 5, 14}, {364, 236, 5, 14}, 
  {396, 236, 5, 14}, {445, 236, 5, 14}, {450, 236, 4, 14}, {512, 236, 5, 14}, 
  {95, 253, 5, 14}, {133, 253, 5, 14}, {141, 253, 5, 14}, {203, 253, 4, 14}, 
  {301, 253, 5, 14}, {306, 253, 4, 14}, {384, 253, 4, 14}, {480, 253, 4, 14}, 
  {80, 269, 5, 15}, {134, 269, 5, 15}, {183, 269, 5, 15}, {239, 269, 5, 15}, 
  {262, 269, 5, 15}, {341, 269, 4, 15}, {410, 269, 5, 15}, {446, 269, 4, 15}, 
  {459, 269, 5, 15}, {482, 269, 5, 15}, {56, 286, 7, 14}, {69, 286, 5, 14}, 
  {100, 286, 5, 14}, {105, 286, 5, 14}, {261, 286, 5, 14}, {443, 286, 5, 14}, 
  {458, 286, 5, 14}, {469, 286, 5, 14}, {86, 302, 5, 15}, {139, 302, 5, 15}, 
  {297, 302, 5, 15}, {387, 302, 5, 15}, {437, 302, 4, 15}, {454, 302, 4, 15}, 
  {86, 319, 5, 14}, {108, 319, 5, 14}, {177, 319, 5, 14}, {200, 319, 5, 14}, 
  {229, 319, 5, 14}, {285, 319, 5, 14}, {349, 319, 5, 14}, {404, 319, 5, 14}, 
  {448, 319, 4, 14}, {477, 319, 5, 14}, {494, 319, 5, 14}, {56, 336, 5, 14}, 
  {67, 336, 5, 14}, {225, 336, 5, 14}, {465, 336, 5, 14}, {473, 336, 5, 14}, 
  {484, 336, 4, 14}, {154, 376, 5, 14}, {171, 376, 5, 14}, {323, 376, 4, 14}, 
  {354, 376, 5, 14}, {394, 376, 5, 14}, {472, 376, 4, 14}, {74, 392, 4, 14}, 
  {172, 392, 7, 14}, {215, 392, 5, 14}, {271, 392, 4, 14}, {313, 392, 5, 14}, 
  {324, 392, 4, 14}, {397, 392, 4, 14}, {474, 392, 5, 14}, {100, 409, 4, 14}, 
  {164, 409, 5, 14}, {298, 409, 5, 14}, {530, 409, 6, 14}, {78, 449, 4, 14}, 
  {115, 449, 5, 14}, {184, 449, 5, 14}, {275, 449, 5, 14}, {324, 449, 5, 14}, 
  {501, 449, 5, 14}, {168, 465, 5, 15}, {208, 465, 5, 15}, {329, 465, 5, 15}, 
  {387, 465, 5, 15}, {392, 465, 4, 15}, {417, 465, 4, 15}, {460, 465, 6, 15}, 
  {514, 465, 5, 15}, {125, 482, 5, 14}, {177, 482, 5, 14}, {268, 482, 5, 14}, 
  {411, 482, 5, 14}, {424, 482, 5, 14}, {486, 482, 5, 14}, {252, 499, 5, 14}, 
  {257, 499, 4, 14}, {308, 499, 5, 14}, {327, 499, 5, 14}, {411, 499, 5, 14}, 
  {488, 499, 5, 14}, {56, 515, 5, 14}, {67, 515, 5, 14}, {118, 515, 5, 14}, 
  {140, 515, 5, 14}, {145, 515, 5, 14}, {286, 515, 5, 14}, {322, 515, 5, 14}, 
  {56, 532, 7, 14}, {69, 532, 5, 14}, {100, 532, 5, 14}, {105, 532, 5, 14}, 
  {163, 532, 5, 14}, {168, 532, 5, 14}, {261, 532, 5, 14}, {296, 532, 5, 14}, 
  {304, 532, 5, 14}, {361, 532, 5, 14}, {430, 532, 5, 14}, {463, 532, 4, 14}, 
  {471, 532, 4, 14}, {502, 532, 5, 14}, {89, 548, 4, 14}, {93, 548, 5, 14}, 
  {211, 548, 5, 14}, {222, 548, 5, 14}, {78, 572, 4, 14}, {111, 572, 5, 14}, 
  {195, 572, 5, 14}, {316, 572, 4, 14}, {346, 572, 5, 14}, {81, 588, 5, 14}, 
  {109, 588, 4, 14}, {116, 588, 5, 14}, {188, 588, 5, 14}, {219, 588, 5, 14}, 
  {311, 588, 5, 14}, {344, 588, 4, 14}, {379, 588, 5, 14}, {446, 588, 5, 14}, 
  {478, 588, 5, 14}, {56, 605, 5, 14}, {87, 605, 5, 14}, {123, 605, 5, 14}, 
  {134, 605, 4, 14}, {227, 605, 5, 14}, {334, 605, 4, 14}, {347, 605, 5, 14}, 
  {355, 605, 4, 14}, {460, 605, 5, 14}, {471, 605, 6, 14}, {483, 605, 5, 14}, 
  {515, 605, 4, 14}, {519, 605, 5, 14}, {194, 621, 4, 15}, {240, 621, 5, 15}, 
  {273, 621, 4, 15}, {342, 621, 4, 15}, {359, 621, 4, 15}, {490, 621, 4, 15}, 
  {125, 638, 5, 14}, {150, 638, 5, 14}, {252, 638, 4, 14}, {344, 638, 5, 14}, 
  {355, 638, 7, 14}, {387, 638, 5, 14}, {451, 638, 4, 14}, {72, 654, 5, 15}, 
  {151, 654, 5, 15}, {118, 678, 5, 14}, {226, 678, 5, 14}, {307, 678, 4, 14}, 
  {315, 678, 4, 14}, {391, 678, 5, 14}, {505, 678, 4, 14}, {131, 695, 4, 14}, 
  {331, 695, 4, 14}, {74, 711, 4, 14}, {133, 711, 5, 14}, {343, 711, 5, 14}, 
  {412, 711, 5, 14}, {453, 711, 4, 14}, {97, 728, 5, 14}, {222, 728, 5, 14}, 
  {391, 728, 5, 14}, {399, 728, 4, 14}, {428, 728, 5, 14}, {483, 728, 4, 14}, 
  {513, 728, 6, 14}, {72, 744, 4, 14}, {172, 744, 5, 14}, {195, 744, 5, 14}, 
  {249, 744, 5, 14}, {367, 744, 5, 14}, {440, 744, 4, 14}, {484, 744, 4, 14}, 
  {101, 57, 4, 14}, {176, 57, 4, 14}, {250, 57, 5, 14}, {258, 57, 5, 14}, 
  {319, 57, 5, 14}, {344, 57, 5, 14}, {374, 57, 5, 14}, {433, 57, 4, 14}, 
  {441, 57, 4, 14}, {62, 73, 4, 15}, {95, 73, 4, 15}, {191, 97, 5, 14}, 
  {204, 97, 5, 14}, {328, 97, 5, 14}, {400, 97, 4, 14}, {404, 97, 5, 14}, 
  {449, 97, 4, 14}, {495, 97, 5, 14}, {94, 113, 5, 15}, {125, 113, 5, 15}, 
  {244, 113, 5, 15}, {252, 113, 5, 15}, {260, 113, 5, 15}, {289, 113, 5, 15}, 
  {389, 113, 4, 15}, {107, 130, 5, 14}, {115, 130, 4, 14}, {125, 130, 5, 14}, 
  {313, 130, 4, 14}, {349, 130, 4, 14}, {80, 147, 4, 14}, {127, 147, 4, 14}, 
  {140, 147, 5, 14}, {199, 147, 5, 14}, {378, 147, 5, 14}, {408, 147, 4, 14}, 
  {425, 147, 4, 14}, {512, 147, 6, 14}, {79, 163, 5, 14}, {215, 163, 5, 14}, 
  {245, 163, 5, 14}, {366, 163, 5, 14}, {80, 180, 4, 14}, {134, 180, 5, 14}, 
  {187, 180, 5, 14}, {236, 180, 5, 14}, {292, 180, 5, 14}, {320, 180, 5, 14}, 
  {395, 180, 5, 14}, {484, 180, 5, 14}, {147, 196, 5, 14}, {290, 196, 5, 14}, 
  {319, 196, 5, 14}, {387, 196, 5, 14}, {479, 196, 4, 14}, {100, 213, 5, 14}, 
  {146, 213, 5, 14}, {192, 213, 5, 14}, {279, 213, 5, 14}, {355, 213, 5, 14}, 
  {412, 213, 4, 14}, {464, 213, 4, 14}, {496, 213, 5, 14}, {101, 229, 5, 14}, 
  {164, 229, 5, 14}, {202, 229, 5, 14}, {240, 229, 5, 14}, {380, 229, 5, 14}, 
  {78, 246, 5, 14}, {74, 269, 4, 15}, {105, 269, 4, 15}, {135, 269, 5, 15}, 
  {178, 269, 5, 15}, {289, 269, 5, 15}, {354, 269, 5, 15}, {399, 269, 5, 15}, 
  {446, 269, 5, 15}, {490, 269, 5, 15}, {495, 269, 5, 15}, {146, 286, 4, 14}, 
  {207, 286, 5, 14}, {415, 286, 5, 14}, {84, 302, 5, 15}, {164, 302, 5, 15}, 
  {193, 302, 5, 15}, {386, 302, 5, 15}, {465, 302, 4, 15}, {475, 302, 5, 15}, 
  {104, 319, 5, 14}, {109, 319, 4, 14}, {252, 319, 5, 14}, {423, 319, 7, 14}, 
  {74, 336, 5, 14}, {97, 336, 5, 14}, {140, 336, 5, 14}, {159, 336, 5, 14}, 
  {231, 336, 4, 14}, {307, 336, 5, 14}, {329, 336, 5, 14}, {397, 336, 5, 14}, 
  {452, 336, 4, 14}, {479, 336, 5, 14}, {190, 376, 5, 14}, {307, 376, 5, 14}, 
  {324, 376, 4, 14}, {503, 376, 5, 14}, {197, 392, 5, 14}, {229, 392, 5, 14}, 
  {252, 392, 4, 14}, {281, 392, 4, 14}, {318, 392, 5, 14}, {349, 392, 4, 14}, 
  {366, 392, 4, 14}, {402, 392, 5, 14}, {420, 392, 5, 14}, {280, 409, 5, 14}, 
  {378, 409, 5, 14}, {409, 409, 4, 14}, {416, 409, 5, 14}, {502, 409, 5, 14}, 
  {78, 425, 4, 15}, {116, 425, 5, 15}, {97, 442, 5, 14}, {143, 442, 4, 14}, 
  {225, 442, 5, 14}, {255, 442, 5, 14}, {272, 442, 5, 14}, {360, 442, 5, 14}, 
  {417, 442, 5, 14}, {488, 442, 4, 14}, {95, 482, 5, 14}, {161, 482, 4, 14}, 
  {263, 482, 5, 14}, {327, 482, 5, 14}, {374, 482, 5, 14}, {382, 482, 4, 14}, 
  {433, 482, 4, 14}, {73, 499, 5, 14}, {86, 499, 5, 14}, {157, 499, 5, 14}, 
  {202, 499, 5, 14}, {324, 499, 5, 14}, {356, 499, 4, 14}, {95, 515, 5, 14}, 
  {156, 515, 5, 14}, {164, 515, 4, 14}, {258, 515, 5, 14}, {399, 515, 5, 14}, 
  {478, 515, 4, 14}, {121, 532, 7, 14}, {166, 532, 5, 14}, {202, 532, 4, 14}, 
  {356, 532, 5, 14}, {393, 532, 5, 14}, {450, 532, 5, 14}, {495, 532, 4, 14}, 
  {90, 548, 5, 14}, {194, 548, 5, 14}, {241, 548, 5, 14}, {369, 548, 5, 14}, 
  {485, 548, 5, 14}, {508, 548, 4, 14}, {107, 565, 5, 14}, {112, 565, 5, 14}, 
  {163, 565, 5, 14}, {212, 565, 5, 14}, {242, 565, 4, 14}, {172, 588, 5, 14}, 
  {201, 588, 5, 14}, {271, 588, 5, 14}, {293, 588, 5, 14}, {298, 588, 4, 14}, 
  {358, 588, 5, 14}, {418, 588, 5, 14}, {473, 588, 5, 14}, {520, 588, 5, 14}, 
  {69, 605, 5, 14}, {174, 605, 5, 14}, {201, 605, 4, 14}, {224, 605, 4, 14}, 
  {247, 605, 4, 14}, {257, 605, 5, 14}, {365, 605, 5, 14}, {376, 605, 4, 14}, 
  {386, 605, 5, 14}, {458, 605, 5, 14}, {66, 621, 4, 15}, {132, 621, 4, 15}, 
  {163, 621, 5, 15}, {243, 621, 5, 15}, {401, 621, 5, 15}, {445, 621, 4, 15}, 
  {505, 621, 5, 15}, {56, 638, 5, 14}, {88, 638, 4, 14}, {232, 638, 5, 14}, 
  {337, 638, 5, 14}, {360, 638, 5, 14}, {371, 638, 4, 14}, {404, 638, 4, 14}, 
  {414, 638, 7, 14}, {474, 638, 5, 14}, {80, 654, 4, 15}, {276, 654, 5, 15}, 
  {318, 654, 5, 15}, {422, 654, 5, 15}, {525, 654, 4, 15}, {529, 654, 6, 15}, 
  {116, 671, 4, 14}, {141, 671, 5, 14}, {317, 671, 5, 14}, {394, 671, 5, 14}, 
  {449, 671, 4, 14}, {56, 688, 5, 14}, {87, 688, 5, 14}, {104, 688, 5, 14}, 
  {224, 688, 4, 14}, {112, 711, 5, 14}, {162, 711, 5, 14}, {236, 711, 5, 14}, 
  {283, 711, 4, 14}, {320, 711, 5, 14}, {369, 711, 5, 14}, {426, 711, 5, 14}, 
  {71, 728, 5, 14}, {76, 728, 4, 14}, {107, 728, 5, 14}, {208, 728, 5, 14}, 
  {231, 728, 5, 14}, {268, 728, 5, 14}, {344, 728, 5, 14}, {382, 728, 5, 14}, 
  {423, 728, 4, 14}, {472, 728, 5, 14}, {519, 728, 4, 14}, {159, 744, 5, 14}, 
  {235, 744, 4, 14}, {257, 744, 5, 14}, {320, 744, 5, 14}, {445, 744, 4, 14}, 
  {120, 57, 5, 14}, {137, 57, 5, 14}, {381, 57, 5, 14}, {491, 57, 5, 14}, 
  {74, 73, 4, 15}, {101, 97, 5, 14}, {132, 97, 5, 14}, {149, 97, 5, 14}, 
  {166, 97, 5, 14}, {211, 97, 5, 14}, {327, 97, 5, 14}, {408, 97, 5, 14}, 
  {480, 97, 4, 14}, {99, 113, 5, 15}, {198, 113, 5, 15}, {258, 113, 4, 15}, 
  {282, 113, 5, 15}, {351, 113, 5, 15}, {359, 113, 5, 15}, {498, 113, 5, 15}, 
  {259, 130, 4, 14}, {305, 130, 5, 14}, {357, 130, 5, 14}, {409, 130, 4, 14}, 
  {450, 130, 5, 14}, {94, 147, 5, 14}, {177, 147, 5, 14}, {220, 147, 5, 14}, 
  {290, 147, 5, 14}, {295, 147, 5, 14}, {364, 147, 5, 14}, {467, 147, 5, 14}, 
  {514, 147, 5, 14}, {522, 147, 6, 14}, {84, 163, 4, 14}, {115, 163, 5, 14}, 
  {261, 163, 4, 14}, {293, 163, 5, 14}, {396, 163, 5, 14}, {401, 163, 5, 14}, 
  {80, 180, 4, 14}, {161, 180, 5, 14}, {216, 180, 5, 14}, {432, 180, 5, 14}, 
  {504, 180, 6, 14}, {56, 196, 5, 14}, {88, 196, 4, 14}, {268, 196, 4, 14}, 
  {373, 196, 5, 14}, {452, 196, 5, 14}, {475, 196, 4, 14}, {126, 213, 5, 14}, 
  {157, 213, 5, 14}, {318, 213, 5, 14}, {489, 213, 5, 14}, {128, 229, 5, 14}, 
  {236, 229, 5, 14}, {302, 253, 5, 14}, {435, 253, 5, 14}, {450, 253, 5, 14}, 
  {461, 253, 4, 14}, {98, 269, 5, 15}, {151, 269, 5, 15}, {182, 269, 4, 15}, 
  {215, 269, 5, 15}, {334, 269, 4, 15}, {388, 269, 5, 15}, {442, 269, 4, 15}, 
  {491, 269, 4, 15}, {92, 286, 5, 14}, {121, 286, 5, 14}, {179, 286, 5, 14}, 
  {209, 286, 5, 14}, {217, 286, 4, 14}, {279, 286, 5, 14}, {290, 286, 4, 14}, 
  {350, 286, 5, 14}, {439, 286, 5, 14}, {80, 302, 5, 15}, {141, 302, 4, 15}, 
  {172, 302, 5, 15}, {273, 302, 4, 15}, {414, 302, 4, 15}, {104, 319, 5, 14}, 
  {339, 319, 5, 14}, {385, 319, 4, 14}, {69, 336, 5, 14}, {247, 336, 5, 14}, 
  {258, 336, 5, 14}, {305, 336, 7, 14}, {379, 336, 5, 14}, {469, 336, 5, 14}, 
  {84, 352, 5, 14}, {116, 376, 5, 14}, {124, 376, 4, 14}, {154, 376, 5, 14}, 
  {502, 376, 4, 14}, {81, 392, 5, 14}, {86, 392, 4, 14}, {122, 392, 5, 14}, 
  {326, 392, 4, 14}, {428, 392, 5, 14}, {484, 392, 4, 14}, {515, 392, 5, 14}, 
  {56, 409, 7, 14}, {118, 409, 5, 14}, {203, 409, 4, 14}, {210, 409, 5, 14}, 
  {241, 409, 5, 14}, {422, 409, 5, 14}, {439, 409, 5, 14}, {482, 409, 4, 14}, 
  {112, 425, 5, 15}, {135, 425, 5, 15}, {188, 425, 5, 15}, {407, 425, 5, 15}, 
  {420, 425, 5, 15}, {516, 425, 5, 15}, {530, 425, 4, 15}, {81, 442, 5, 14}, 
  {116, 442, 7, 14}, {365, 442, 5, 14}, {450, 442, 5, 14}, {455, 442, 5, 14}, 
  {90, 458, 4, 15}, {104, 458, 6, 15}, {116, 458, 5, 15}, {148, 458, 4, 15}, 
  {152, 458, 5, 15}, {213, 458, 5, 15}, {298, 458, 4, 15}, {94, 482, 5, 14}, 
  {346, 482, 4, 14}, {400, 482, 5, 14}, {423, 482, 5, 14}, {503, 482, 5, 14}, 
  {514, 482, 5, 14}, {111, 499, 4, 14}, {176, 499, 5, 14}, {189, 499, 5, 14}, 
  {242, 499, 5, 14}, {272, 499, 5, 14}, {379, 499, 4, 14}, {407, 499, 5, 14}, 
  {482, 499, 4, 14}, {122, 515, 4, 14}, {170, 515, 5, 14}, {219, 515, 5, 14}, 
  {232, 515, 5, 14}, {313, 515, 6, 14}, {325, 515, 5, 14}, {357, 515, 4, 14}, 
  {361, 515, 5, 14}, {413, 515, 5, 14}, {437, 515, 4, 14}, {127, 532, 4, 14}, 
  {208, 532, 5, 14}, {248, 532, 5, 14}, {279, 532, 4, 14}, {68, 548, 5, 14}, 
  {177, 548, 4, 14}, {243, 548, 4, 14}, {250, 548, 5, 14}, {322, 548, 5, 14}, {333, 548, 5, 14} }, // rects
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25 } }; // pages

RegressSearchInfo data_morbi_mattis = {
  L"morbi mattis",
  2, // matches
  { 1, 2 }, // rectCounts
  { {287, 250, 62, 14}, {488, 609, 31, 14}, {56, 57, 30, 14} }, // rects
  { 1, 1, 2 } }; // pages

RegressSearchInfo data_xyzzy = {
  L"xyzzy",
  0, // matches
  {  }, // rectCounts
  {  }, // rects
  {  } }; // pages

RegressSearchInfo data_S = {
  L"S",
  6421, // matches
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, // rectCounts
  { {138, 57, 5, 14}, {192, 57, 5, 14}, {246, 57, 5, 14}, {295, 57, 5, 14}, 
  {351, 57, 5, 14}, {399, 57, 5, 14}, {429, 57, 5, 14}, {495, 57, 4, 14}, 
  {56, 71, 5, 14}, {129, 71, 4, 14}, {163, 71, 5, 14}, {209, 71, 5, 14}, 
  {364, 71, 7, 14}, {431, 71, 4, 14}, {468, 71, 5, 14}, {148, 84, 5, 15}, 
  {156, 84, 4, 15}, {328, 84, 4, 15}, {360, 84, 5, 15}, {365, 84, 4, 15}, 
  {468, 84, 5, 15}, {98, 98, 5, 14}, {230, 98, 5, 14}, {266, 98, 4, 14}, 
  {347, 98, 5, 14}, {449, 98, 5, 14}, {472, 98, 4, 14}, {190, 112, 4, 14}, 
  {231, 112, 4, 14}, {277, 112, 4, 14}, {355, 112, 5, 14}, {401, 112, 5, 14}, 
  {432, 112, 4, 14}, {464, 112, 4, 14}, {514, 112, 5, 14}, {67, 126, 5, 14}, 
  {147, 126, 5, 14}, {252, 126, 5, 14}, {282, 126, 5, 14}, {293, 126, 6, 14}, 
  {305, 126, 5, 14}, {337, 126, 4, 14}, {341, 126, 5, 14}, {428, 126, 4, 14}, 
  {80, 140, 5, 14}, {157, 140, 5, 14}, {74, 153, 5, 15}, {149, 153, 5, 15}, 
  {197, 153, 5, 15}, {301, 153, 5, 15}, {438, 153, 4, 15}, {518, 153, 5, 15}, 
  {167, 167, 4, 14}, {251, 167, 5, 14}, {398, 167, 5, 14}, {527, 167, 5, 14}, 
  {69, 181, 5, 14}, {248, 181, 5, 14}, {395, 181, 4, 14}, {433, 181, 5, 14}, 
  {478, 181, 5, 14}, {489, 181, 5, 14}, {80, 195, 4, 14}, {169, 195, 4, 14}, 
  {229, 195, 5, 14}, {395, 195, 5, 14}, {111, 209, 4, 14}, {130, 209, 5, 14}, 
  {310, 209, 5, 14}, {421, 209, 5, 14}, {469, 209, 5, 14}, {78, 222, 4, 15}, 
  {218, 222, 4, 15}, {270, 222, 4, 15}, {328, 222, 5, 15}, {418, 222, 4, 15}, 
  {446, 222, 5, 15}, {493, 222, 5, 15}, {161, 236, 7, 14}, {299, 236, 5, 14}, 
  {369, 236, 4, 14}, {400, 236, 5, 14}, {495, 236, 7, 14}, {67, 250, 5, 14}, 
  {344, 250, 5, 14}, {393, 250, 4, 14}, {74, 264, 5, 14}, {109, 264, 4, 14}, 
  {188, 264, 5, 14}, {219, 264, 5, 14}, {449, 264, 5, 14}, {475, 264, 4, 14}, 
  {129, 278, 4, 14}, {260, 278, 5, 14}, {340, 278, 5, 14}, {378, 278, 5, 14}, 
  {416, 278, 5, 14}, {464, 278, 5, 14}, {487, 278, 5, 14}, {153, 291, 5, 15}, 
  {175, 291, 5, 15}, {336, 291, 4, 15}, {380, 291, 4, 15}, {407, 291, 5, 15}, 
  {415, 291, 5, 15}, {462, 291, 4, 15}, {493, 291, 5, 15}, {533, 291, 6, 15}, 
  {80, 305, 4, 14}, {288, 305, 5, 14}, {366, 305, 5, 14}, {459, 305, 4, 14}, 
  {506, 305, 4, 14}, {516, 305, 6, 14}, {56, 319, 5, 14}, {56, 333, 7, 14}, 
  {149, 333, 5, 14}, {174, 333, 4, 14}, {187, 333, 5, 14}, {223, 333, 5, 14}, 
  {262, 333, 5, 14}, {357, 333, 4, 14}, {481, 333, 5, 14}, {151, 347, 5, 14}, 
  {379, 347, 5, 14}, {471, 347, 5, 14}, {66, 360, 4, 15}, {192, 360, 5, 15}, 
  {288, 360, 5, 15}, {324, 360, 5, 15}, {341, 360, 5, 15}, {410, 360, 5, 15}, 
  {442, 360, 5, 15}, {94, 374, 5, 14}, {126, 374, 5, 14}, {247, 374, 5, 14}, 
  {397, 374, 5, 14}, {450, 374, 5, 14}, {473, 374, 5, 14}, {81, 388, 5, 14}, 
  {86, 388, 4, 14}, {134, 388, 5, 14}, {216, 388, 5, 14}, {437, 388, 5, 14}, 
  {481, 388, 5, 14}, {239, 402, 4, 14}, {306, 402, 4, 14}, {370, 402, 5, 14}, 
  {482, 402, 4, 14}, {514, 402, 6, 14}, {80, 416, 4, 14}, {113, 416, 4, 14}, 
  {183, 416, 5, 14}, {251, 429, 5, 15}, {100, 443, 4, 14}, {136, 443, 5, 14}, 
  {319, 443, 5, 14}, {106, 457, 5, 14}, {117, 457, 5, 14}, {248, 457, 5, 14}, 
  {316, 457, 4, 14}, {362, 457, 5, 14}, {406, 457, 4, 14}, {465, 457, 5, 14}, 
  {129, 471, 5, 14}, {140, 471, 6, 14}, {175, 471, 5, 14}, {260, 471, 5, 14}, 
  {290, 471, 5, 14}, {415, 471, 4, 14}, {425, 471, 5, 14}, {468, 471, 5, 14}, 
  {90, 485, 5, 14}, {103, 485, 5, 14}, {147, 485, 4, 14}, {171, 485, 5, 14}, 
  {184, 485, 5, 14}, {259, 485, 5, 14}, {328, 485, 5, 14}, {432, 485, 5, 14}, 
  {104, 498, 5, 15}, {139, 498, 5, 15}, {347, 512, 5, 14}, {352, 512, 4, 14}, 
  {368, 512, 6, 14}, {446, 512, 4, 14}, {87, 526, 5, 14}, {296, 526, 5, 14}, 
  {301, 526, 5, 14}, {379, 526, 5, 14}, {469, 526, 5, 14}, {201, 540, 5, 14}, 
  {209, 540, 5, 14}, {222, 540, 5, 14}, {309, 540, 4, 14}, {358, 540, 5, 14}, 
  {389, 540, 5, 14}, {468, 540, 5, 14}, {123, 554, 5, 14}, {151, 554, 4, 14}, 
  {237, 554, 5, 14}, {268, 554, 5, 14}, {298, 554, 5, 14}, {435, 554, 5, 14}, 
  {492, 554, 5, 14}, {56, 567, 5, 15}, {87, 567, 5, 15}, {95, 567, 4, 15}, 
  {159, 567, 4, 15}, {182, 567, 4, 15}, {251, 567, 4, 15}, {407, 567, 5, 15}, 
  {459, 567, 4, 15}, {469, 567, 5, 15}, {500, 567, 5, 15}, {71, 581, 5, 14}, 
  {114, 581, 5, 14}, {294, 581, 5, 14}, {311, 581, 5, 14}, {69, 595, 5, 14}, 
  {167, 595, 5, 14}, {214, 595, 5, 14}, {496, 595, 4, 14}, {110, 609, 4, 14}, 
  {242, 609, 5, 14}, {306, 609, 5, 14}, {344, 609, 4, 14}, {81, 57, 5, 14}, 
  {119, 57, 5, 14}, {192, 57, 4, 14}, {217, 57, 4, 14}, {247, 57, 5, 14}, 
  {402, 57, 5, 14}, {123, 73, 5, 15}, {267, 73, 4, 15}, {325, 73, 4, 15}, 
  {511, 73, 5, 15}, {86, 90, 4, 14}, {118, 90, 5, 14}, {126, 90, 5, 14}, 
  {256, 90, 5, 14}, {261, 90, 5, 14}, {318, 90, 4, 14}, {345, 90, 5, 14}, 
  {359, 90, 4, 14}, {366, 90, 5, 14}, {133, 106, 5, 15}, {141, 106, 5, 15}, 
  {220, 106, 5, 15}, {248, 106, 5, 15}, {271, 106, 5, 15}, {122, 130, 4, 14}, 
  {132, 130, 5, 14}, {168, 130, 5, 14}, {176, 130, 5, 14}, {212, 130, 4, 14}, 
  {225, 130, 5, 14}, {298, 130, 5, 14}, {335, 130, 7, 14}, {348, 130, 4, 14}, 
  {379, 130, 5, 14}, {384, 130, 4, 14}, {129, 147, 5, 14}, {159, 147, 4, 14}, 
  {191, 147, 4, 14}, {220, 147, 5, 14}, {231, 147, 6, 14}, {251, 147, 5, 14}, 
  {282, 147, 5, 14}, {370, 147, 5, 14}, {66, 163, 4, 14}, {229, 163, 5, 14}, 
  {260, 163, 4, 14}, {342, 163, 5, 14}, {406, 163, 4, 14}, {424, 163, 5, 14}, 
  {435, 163, 4, 14}, {473, 163, 5, 14}, {174, 180, 5, 14}, {241, 180, 5, 14}, 
  {332, 180, 4, 14}, {367, 180, 5, 14}, {413, 180, 5, 14}, {444, 180, 5, 14}, 
  {469, 180, 5, 14}, {74, 196, 5, 14}, {360, 196, 4, 14}, {370, 196, 5, 14}, 
  {436, 196, 5, 14}, {481, 196, 5, 14}, {112, 213, 5, 14}, {129, 213, 5, 14}, 
  {187, 229, 4, 14}, {253, 229, 4, 14}, {275, 229, 5, 14}, {303, 229, 4, 14}, 
  {409, 229, 5, 14}, {460, 229, 5, 14}, {145, 246, 5, 14}, {194, 246, 5, 14}, 
  {219, 246, 5, 14}, {436, 246, 4, 14}, {81, 262, 5, 15}, {86, 262, 4, 15}, 
  {145, 262, 4, 15}, {168, 262, 4, 15}, {233, 262, 4, 15}, {276, 262, 4, 15}, 
  {380, 262, 5, 15}, {507, 262, 5, 15}, {110, 302, 5, 15}, {165, 302, 5, 15}, 
  {296, 302, 5, 15}, {331, 302, 4, 15}, {391, 302, 5, 15}, {82, 319, 4, 14}, 
  {321, 319, 5, 14}, {383, 319, 5, 14}, {406, 319, 5, 14}, {465, 319, 5, 14}, 
  {127, 336, 4, 14}, {347, 336, 5, 14}, {394, 336, 5, 14}, {512, 336, 5, 14}, 
  {133, 352, 5, 14}, {156, 352, 4, 14}, {270, 352, 4, 14}, {105, 376, 5, 14}, 
  {246, 376, 5, 14}, {307, 376, 4, 14}, {358, 376, 5, 14}, {366, 376, 4, 14}, 
  {71, 392, 5, 14}, {130, 392, 4, 14}, {232, 392, 4, 14}, {347, 392, 5, 14}, 
  {370, 392, 4, 14}, {401, 392, 5, 14}, {478, 392, 5, 14}, {98, 409, 4, 14}, 
  {147, 409, 5, 14}, {164, 409, 5, 14}, {251, 409, 5, 14}, {273, 409, 5, 14}, 
  {342, 409, 5, 14}, {365, 409, 5, 14}, {394, 409, 4, 14}, {90, 425, 4, 15}, 
  {130, 425, 4, 15}, {168, 425, 5, 15}, {250, 425, 5, 15}, {261, 425, 4, 15}, 
  {366, 425, 5, 15}, {379, 425, 5, 15}, {485, 425, 5, 15}, {532, 425, 6, 15}, 
  {78, 442, 5, 14}, {164, 442, 5, 14}, {235, 442, 4, 14}, {272, 442, 5, 14}, 
  {449, 442, 5, 14}, {94, 458, 5, 15}, {141, 458, 4, 15}, {234, 458, 5, 15}, 
  {313, 458, 5, 15}, {417, 458, 5, 15}, {120, 475, 6, 14}, {165, 475, 5, 14}, 
  {173, 475, 5, 14}, {202, 475, 5, 14}, {94, 499, 5, 14}, {118, 499, 5, 14}, 
  {132, 499, 5, 14}, {150, 499, 5, 14}, {199, 499, 5, 14}, {456, 499, 5, 14}, 
  {500, 499, 5, 14}, {86, 515, 4, 14}, {93, 515, 5, 14}, {143, 515, 4, 14}, 
  {173, 515, 5, 14}, {267, 515, 4, 14}, {307, 515, 4, 14}, {329, 515, 5, 14}, 
  {359, 515, 4, 14}, {369, 515, 5, 14}, {411, 515, 4, 14}, {447, 515, 4, 14}, 
  {457, 515, 5, 14}, {84, 532, 5, 14}, {133, 532, 5, 14}, {161, 532, 5, 14}, 
  {236, 532, 4, 14}, {423, 532, 7, 14}, {459, 532, 5, 14}, {470, 532, 5, 14}, 
  {128, 548, 5, 14}, {202, 548, 5, 14}, {254, 548, 5, 14}, {143, 565, 4, 14}, 
  {171, 565, 5, 14}, {242, 565, 5, 14}, {253, 565, 5, 14}, {350, 565, 6, 14}, 
  {432, 565, 4, 14}, {497, 565, 4, 14}, {229, 581, 5, 14}, {460, 581, 5, 14}, 
  {292, 598, 5, 14}, {348, 598, 4, 14}, {480, 598, 5, 14}, {117, 614, 5, 15}, 
  {136, 614, 5, 15}, {303, 614, 5, 15}, {416, 614, 4, 15}, {440, 614, 5, 15}, 
  {453, 614, 5, 15}, {78, 638, 4, 14}, {322, 638, 5, 14}, {346, 638, 4, 14}, 
  {364, 638, 5, 14}, {433, 638, 5, 14}, {56, 654, 7, 15}, {131, 654, 4, 15}, 
  {138, 654, 5, 15}, {244, 654, 5, 15}, {290, 654, 5, 15}, {440, 654, 4, 15}, 
  {450, 654, 5, 15}, {56, 671, 7, 14}, {69, 671, 5, 14}, {100, 671, 5, 14}, 
  {105, 671, 5, 14}, {294, 671, 5, 14}, {438, 671, 5, 14}, {83, 688, 5, 14}, 
  {126, 688, 5, 14}, {175, 688, 5, 14}, {218, 688, 5, 14}, {439, 688, 4, 14}, 
  {514, 688, 5, 14}, {86, 704, 4, 14}, {136, 704, 5, 14}, {261, 704, 5, 14}, 
  {364, 704, 7, 14}, {403, 704, 5, 14}, {503, 704, 5, 14}, {80, 721, 4, 14}, 
  {115, 721, 4, 14}, {146, 721, 5, 14}, {217, 721, 5, 14}, {277, 721, 4, 14}, 
  {381, 721, 5, 14}, {443, 721, 5, 14}, {480, 721, 5, 14}, {530, 721, 6, 14}, 
  {68, 737, 5, 14}, {155, 737, 5, 14}, {211, 737, 4, 14}, {221, 737, 5, 14}, 
  {268, 737, 5, 14}, {345, 737, 5, 14}, {436, 737, 5, 14}, {80, 754, 5, 14}, 
  {194, 754, 5, 14}, {217, 754, 4, 14}, {290, 754, 5, 14}, {196, 57, 5, 14}, 
  {225, 57, 5, 14}, {253, 57, 5, 14}, {322, 57, 5, 14}, {330, 57, 5, 14}, 
  {68, 73, 5, 15}, {179, 73, 5, 15}, {220, 73, 5, 15}, {274, 73, 5, 15}, 
  {398, 73, 5, 15}, {409, 73, 5, 15}, {438, 73, 4, 15}, {463, 73, 4, 15}, 
  {492, 73, 5, 15}, {527, 73, 5, 15}, {124, 90, 5, 14}, {132, 90, 5, 14}, 
  {152, 90, 5, 14}, {257, 90, 4, 14}, {288, 90, 4, 14}, {429, 90, 4, 14}, 
  {439, 90, 5, 14}, {317, 106, 5, 15}, {322, 106, 5, 15}, {387, 106, 5, 15}, 
  {410, 106, 4, 15}, {86, 123, 5, 14}, {138, 123, 6, 14}, {237, 123, 5, 14}, 
  {333, 123, 5, 14}, {435, 123, 5, 14}, {443, 123, 4, 14}, {474, 123, 4, 14}, 
  {66, 140, 4, 14}, {199, 140, 5, 14}, {207, 140, 5, 14}, {78, 163, 4, 14}, 
  {379, 163, 5, 14}, {433, 163, 5, 14}, {487, 163, 5, 14}, {82, 180, 5, 14}, 
  {138, 180, 5, 14}, {195, 180, 5, 14}, {250, 180, 5, 14}, {317, 180, 5, 14}, 
  {476, 180, 4, 14}, {495, 180, 4, 14}, {162, 196, 5, 14}, {185, 196, 5, 14}, 
  {193, 196, 4, 14}, {203, 196, 5, 14}, {257, 196, 4, 14}, {298, 196, 4, 14}, 
  {308, 196, 7, 14}, {361, 196, 5, 14}, {381, 196, 5, 14}, {404, 196, 5, 14}, 
  {103, 213, 4, 14}, {110, 213, 5, 14}, {142, 213, 4, 14}, {244, 213, 5, 14}, 
  {163, 229, 5, 14}, {201, 229, 5, 14}, {226, 229, 5, 14}, {281, 229, 5, 14}, 
  {286, 229, 5, 14}, {302, 229, 7, 14}, {359, 229, 5, 14}, {83, 246, 5, 14}, 
  {138, 246, 5, 14}, {189, 246, 5, 14}, {250, 246, 5, 14}, {314, 246, 5, 14}, 
  {403, 246, 4, 14}, {452, 246, 5, 14}, {460, 246, 5, 14}, {505, 246, 5, 14}, 
  {74, 262, 4, 15}, {133, 262, 5, 15}, {163, 262, 4, 15}, {258, 262, 5, 15}, 
  {407, 262, 5, 15}, {418, 262, 4, 15}, {94, 279, 5, 14}, {135, 279, 4, 14}, 
  {193, 279, 5, 14}, {270, 279, 5, 14}, {281, 279, 5, 14}, {385, 279, 4, 14}, 
  {404, 279, 5, 14}, {485, 279, 4, 14}, {98, 295, 4, 15}, {147, 295, 5, 15}, 
  {164, 295, 5, 15}, {251, 295, 5, 15}, {273, 295, 5, 15}, {342, 295, 5, 15}, 
  {365, 295, 5, 15}, {81, 319, 5, 14}, {160, 319, 5, 14}, {310, 319, 5, 14}, 
  {376, 319, 5, 14}, {472, 319, 5, 14}, {483, 319, 5, 14}, {94, 336, 5, 14}, 
  {153, 336, 5, 14}, {200, 336, 5, 14}, {208, 336, 5, 14}, {269, 336, 5, 14}, 
  {291, 336, 5, 14}, {296, 336, 4, 14}, {389, 336, 4, 14}, {489, 336, 6, 14}, 
  {218, 352, 5, 14}, {329, 352, 5, 14}, {337, 352, 5, 14}, {407, 352, 5, 14}, 
  {442, 352, 4, 14}, {473, 352, 4, 14}, {480, 352, 5, 14}, {514, 352, 4, 14}, 
  {518, 352, 5, 14}, {74, 369, 4, 14}, {107, 369, 5, 14}, {118, 369, 5, 14}, 
  {150, 369, 7, 14}, {289, 369, 5, 14}, {358, 369, 5, 14}, {457, 369, 7, 14}, 
  {242, 385, 5, 14}, {255, 385, 5, 14}, {341, 385, 5, 14}, {462, 385, 5, 14}, 
  {514, 385, 7, 14}, {69, 402, 4, 14}, {182, 402, 4, 14}, {231, 402, 5, 14}, 
  {262, 402, 5, 14}, {312, 402, 4, 14}, {476, 402, 4, 14}, {483, 402, 5, 14}, 
  {494, 402, 5, 14}, {114, 418, 5, 15}, {122, 418, 5, 15}, {163, 418, 5, 15}, 
  {248, 418, 5, 15}, {331, 418, 5, 15}, {353, 418, 5, 15}, {417, 418, 5, 15}, 
  {436, 418, 5, 15}, {74, 442, 4, 14}, {110, 442, 4, 14}, {232, 442, 5, 14}, 
  {313, 442, 4, 14}, {419, 442, 4, 14}, {423, 442, 5, 14}, {95, 458, 5, 15}, 
  {112, 458, 5, 15}, {190, 458, 5, 15}, {304, 458, 5, 15}, {315, 458, 6, 15}, 
  {327, 458, 5, 15}, {359, 458, 4, 15}, {363, 458, 5, 15}, {409, 458, 5, 15}, 
  {447, 458, 4, 15}, {524, 458, 5, 15}, {56, 475, 5, 14}, {96, 475, 4, 14}, 
  {161, 475, 4, 14}, {202, 475, 7, 14}, {252, 475, 5, 14}, {275, 475, 5, 14}, 
  {315, 475, 5, 14}, {407, 475, 5, 14}, {421, 475, 4, 14}, {444, 475, 4, 14}, 
  {466, 475, 5, 14}, {96, 492, 4, 14}, {220, 492, 5, 14}, {290, 492, 5, 14}, 
  {377, 492, 5, 14}, {390, 492, 5, 14}, {473, 492, 5, 14}, {94, 508, 5, 14}, 
  {135, 508, 4, 14}, {183, 508, 5, 14}, {500, 508, 5, 14}, {113, 525, 5, 14}, 
  {221, 525, 7, 14}, {234, 525, 5, 14}, {265, 525, 5, 14}, {270, 525, 4, 14}, 
  {356, 525, 5, 14}, {405, 525, 4, 14}, {409, 525, 5, 14}, {95, 541, 5, 14}, 
  {126, 541, 4, 14}, {133, 541, 5, 14}, {163, 541, 4, 14}, {178, 541, 4, 14}, 
  {188, 541, 5, 14}, {245, 541, 4, 14}, {323, 541, 4, 14}, {358, 541, 6, 14}, 
  {410, 541, 5, 14}, {441, 541, 5, 14}, {492, 541, 5, 14}, {74, 558, 4, 14}, 
  {156, 558, 4, 14}, {261, 558, 5, 14}, {269, 558, 5, 14}, {331, 558, 5, 14}, 
  {385, 558, 5, 14}, {451, 558, 4, 14}, {459, 558, 4, 14}, {488, 558, 5, 14}, 
  {122, 574, 5, 14}, {158, 574, 4, 14}, {180, 574, 4, 14}, {300, 574, 5, 14}, 
  {369, 574, 5, 14}, {377, 574, 4, 14}, {406, 574, 5, 14}, {74, 598, 5, 14}, 
  {99, 598, 5, 14}, {110, 598, 5, 14}, {146, 598, 5, 14}, {157, 598, 5, 14}, 
  {257, 598, 5, 14}, {292, 598, 5, 14}, {418, 598, 5, 14}, {488, 598, 4, 14}, 
  {95, 614, 5, 15}, {135, 614, 5, 15}, {146, 614, 5, 15}, {163, 614, 5, 15}, 
  {298, 614, 5, 15}, {413, 614, 4, 15}, {417, 614, 5, 15}, {438, 614, 4, 15}, 
  {524, 614, 5, 15}, {239, 631, 5, 14}, {244, 631, 5, 14}, {322, 631, 4, 14}, 
  {348, 631, 5, 14}, {378, 631, 5, 14}, {518, 631, 4, 14}, {108, 647, 5, 15}, 
  {173, 647, 4, 15}, {236, 647, 5, 15}, {284, 647, 5, 15}, {388, 647, 5, 15}, 
  {398, 647, 5, 15}, {482, 647, 4, 15}, {72, 664, 4, 14}, {79, 664, 5, 14}, 
  {144, 664, 5, 14}, {229, 664, 5, 14}, {282, 664, 5, 14}, {446, 664, 5, 14}, 
  {526, 664, 5, 14}, {131, 681, 5, 14}, {234, 681, 5, 14}, {347, 681, 5, 14}, 
  {400, 681, 4, 14}, {454, 681, 4, 14}, {64, 697, 4, 14}, {74, 697, 5, 14}, 
  {108, 697, 5, 14}, {139, 697, 5, 14}, {151, 721, 5, 14}, {225, 721, 5, 14}, 
  {230, 721, 4, 14}, {257, 721, 5, 14}, {268, 721, 5, 14}, {311, 721, 5, 14}, 
  {56, 737, 5, 14}, {408, 737, 5, 14}, {462, 737, 5, 14}, {495, 737, 5, 14}, 
  {119, 754, 5, 14}, {139, 754, 5, 14}, {213, 754, 5, 14}, {245, 754, 5, 14}, 
  {303, 754, 4, 14}, {394, 754, 4, 14}, {476, 754, 5, 14}, {506, 754, 6, 14}, 
  {94, 770, 5, 15}, {355, 770, 5, 15}, {500, 770, 4, 15}, {71, 57, 5, 14}, 
  {76, 57, 4, 14}, {243, 57, 4, 14}, {268, 57, 4, 14}, {351, 57, 4, 14}, 
  {399, 57, 4, 14}, {448, 57, 4, 14}, {479, 57, 5, 14}, {98, 73, 5, 15}, 
  {190, 73, 5, 15}, {253, 73, 4, 15}, {289, 73, 5, 15}, {311, 73, 5, 15}, 
  {453, 73, 5, 15}, {512, 73, 5, 15}, {74, 90, 5, 14}, {114, 90, 5, 14}, 
  {328, 90, 5, 14}, {357, 90, 5, 14}, {481, 90, 5, 14}, {492, 90, 4, 14}, 
  {106, 106, 5, 15}, {193, 106, 5, 15}, {216, 106, 5, 15}, {239, 106, 5, 15}, 
  {275, 106, 5, 15}, {324, 106, 4, 15}, {347, 106, 4, 15}, {437, 106, 5, 15}, 
  {468, 106, 5, 15}, {106, 123, 5, 14}, {134, 123, 4, 14}, {144, 123, 5, 14}, 
  {195, 123, 5, 14}, {56, 147, 7, 14}, {202, 147, 5, 14}, {210, 147, 4, 14}, 
  {241, 147, 5, 14}, {281, 147, 5, 14}, {386, 147, 5, 14}, {411, 147, 5, 14}, 
  {474, 147, 4, 14}, {525, 147, 6, 14}, {81, 163, 5, 14}, {86, 163, 4, 14}, 
  {109, 163, 7, 14}, {122, 163, 4, 14}, {153, 163, 5, 14}, {158, 163, 4, 14}, 
  {182, 163, 5, 14}, {236, 163, 5, 14}, {259, 163, 5, 14}, {306, 163, 5, 14}, 
  {413, 163, 4, 14}, {430, 163, 4, 14}, {67, 180, 5, 14}, {167, 180, 5, 14}, 
  {269, 180, 5, 14}, {481, 180, 5, 14}, {486, 180, 5, 14}, {161, 196, 4, 14}, 
  {222, 196, 5, 14}, {282, 196, 5, 14}, {325, 196, 5, 14}, {386, 196, 5, 14}, 
  {432, 196, 5, 14}, {469, 196, 5, 14}, {480, 196, 5, 14}, {68, 213, 4, 14}, 
  {264, 213, 5, 14}, {311, 213, 5, 14}, {362, 213, 5, 14}, {393, 213, 5, 14}, 
  {151, 229, 5, 14}, {159, 229, 4, 14}, {190, 229, 5, 14}, {323, 229, 7, 14}, 
  {336, 229, 4, 14}, {367, 229, 5, 14}, {372, 229, 4, 14}, {498, 229, 6, 14}, 
  {153, 246, 5, 14}, {279, 246, 5, 14}, {287, 246, 5, 14}, {515, 246, 5, 14}, 
  {520, 246, 5, 14}, {105, 262, 5, 15}, {137, 262, 5, 15}, {187, 262, 5, 15}, 
  {233, 262, 4, 15}, {241, 262, 4, 15}, {248, 262, 5, 15}, {301, 262, 5, 15}, 
  {324, 262, 5, 15}, {411, 262, 4, 15}, {490, 262, 4, 15}, {81, 279, 5, 14}, 
  {86, 279, 4, 14}, {263, 279, 4, 14}, {309, 279, 5, 14}, {346, 279, 4, 14}, 
  {410, 279, 5, 14}, {56, 302, 7, 15}, {69, 302, 5, 15}, {100, 302, 5, 15}, 
  {105, 302, 5, 15}, {154, 302, 4, 15}, {191, 302, 5, 15}, {350, 302, 5, 15}, 
  {373, 302, 5, 15}, {497, 302, 5, 15}, {83, 319, 5, 14}, {149, 319, 5, 14}, 
  {177, 319, 5, 14}, {302, 319, 5, 14}, {325, 319, 4, 14}, {329, 319, 5, 14}, 
  {392, 319, 5, 14}, {475, 319, 4, 14}, {445, 336, 4, 14}, {499, 336, 4, 14}, 
  {74, 352, 5, 14}, {97, 352, 5, 14}, {231, 352, 5, 14}, {239, 352, 5, 14}, 
  {319, 352, 5, 14}, {387, 352, 5, 14}, {426, 352, 5, 14}, {492, 352, 4, 14}, 
  {89, 369, 4, 14}, {138, 369, 4, 14}, {194, 369, 4, 14}, {247, 369, 5, 14}, 
  {297, 369, 4, 14}, {316, 369, 5, 14}, {452, 369, 5, 14}, {493, 369, 5, 14}, 
  {521, 369, 5, 14}, {56, 385, 7, 14}, {178, 385, 5, 14}, {201, 385, 5, 14}, 
  {265, 385, 5, 14}, {318, 385, 5, 14}, {456, 385, 4, 14}, {506, 385, 4, 14}, 
  {120, 402, 5, 14}, {165, 402, 4, 14}, {175, 402, 5, 14}, {129, 425, 5, 15}, 
  {146, 425, 5, 15}, {192, 425, 4, 15}, {212, 425, 4, 15}, {243, 425, 5, 15}, 
  {268, 425, 5, 15}, {397, 425, 4, 15}, {477, 425, 5, 15}, {127, 442, 5, 14}, 
  {146, 442, 5, 14}, {227, 442, 5, 14}, {244, 442, 5, 14}, {284, 442, 5, 14}, 
  {376, 442, 5, 14}, {398, 442, 5, 14}, {484, 442, 5, 14}, {511, 442, 4, 14}, 
  {84, 458, 5, 15}, {112, 458, 4, 15}, {162, 458, 5, 15}, {175, 458, 5, 15}, 
  {207, 458, 5, 15}, {295, 458, 4, 15}, {313, 458, 5, 15}, {429, 458, 4, 15}, 
  {275, 475, 5, 14}, {119, 492, 5, 14}, {127, 492, 4, 14}, {192, 492, 4, 14}, 
  {200, 492, 4, 14}, {301, 492, 4, 14}, {395, 492, 5, 14}, {56, 508, 7, 14}, 
  {69, 508, 5, 14}, {100, 508, 5, 14}, {105, 508, 5, 14}, {199, 508, 4, 14}, 
  {261, 508, 4, 14}, {387, 508, 4, 14}, {455, 508, 4, 14}, {459, 508, 5, 14}, 
  {494, 508, 5, 14}, {95, 525, 5, 14}, {151, 525, 5, 14}, {375, 525, 4, 14}, 
  {392, 525, 4, 14}, {403, 525, 4, 14}, {432, 525, 5, 14}, {112, 541, 5, 14}, 
  {231, 541, 4, 14}, {235, 541, 5, 14}, {74, 565, 5, 14}, {166, 565, 5, 14}, 
  {177, 565, 4, 14}, {235, 565, 5, 14}, {266, 565, 5, 14}, {307, 565, 5, 14}, 
  {445, 565, 5, 14}, {477, 565, 5, 14}, {56, 581, 5, 14}, {174, 581, 4, 14}, 
  {304, 581, 4, 14}, {427, 581, 4, 14}, {131, 598, 7, 14}, {144, 598, 5, 14}, 
  {175, 598, 5, 14}, {180, 598, 5, 14}, {235, 598, 5, 14}, {264, 598, 5, 14}, 
  {313, 598, 4, 14}, {323, 598, 5, 14}, {501, 598, 4, 14}, {514, 598, 5, 14}, 
  {74, 638, 5, 14}, {123, 638, 5, 14}, {144, 638, 5, 14}, {217, 638, 5, 14}, 
  {225, 638, 5, 14}, {256, 638, 5, 14}, {281, 638, 5, 14}, {330, 638, 5, 14}, 
  {392, 638, 5, 14}, {397, 638, 5, 14}, {464, 638, 5, 14}, {489, 638, 5, 14}, 
  {199, 654, 5, 15}, {276, 654, 5, 15}, {330, 654, 5, 15}, {359, 654, 4, 15}, 
  {466, 654, 4, 15}, {491, 654, 5, 15}, {522, 654, 4, 15}, {100, 671, 4, 14}, 
  {143, 671, 5, 14}, {151, 671, 5, 14}, {207, 671, 5, 14}, {252, 671, 5, 14}, 
  {307, 671, 5, 14}, {352, 671, 5, 14}, {367, 671, 5, 14}, {378, 671, 4, 14}, 
  {405, 671, 5, 14}, {410, 671, 4, 14}, {477, 671, 4, 14}, {502, 671, 5, 14}, 
  {199, 688, 5, 14}, {276, 688, 5, 14}, {330, 688, 5, 14}, {422, 688, 5, 14}, 
  {73, 704, 5, 14}, {86, 704, 5, 14}, {110, 704, 4, 14}, {207, 704, 5, 14}, 
  {269, 704, 5, 14}, {307, 704, 5, 14}, {56, 728, 7, 14}, {327, 728, 4, 14}, 
  {384, 728, 4, 14}, {403, 728, 5, 14}, {470, 728, 5, 14}, {146, 744, 5, 14}, 
  {275, 744, 5, 14}, {433, 744, 5, 14}, {163, 761, 5, 14}, {251, 761, 5, 14}, 
  {300, 761, 5, 14}, {308, 761, 5, 14}, {137, 57, 4, 14}, {184, 57, 5, 14}, 
  {431, 57, 4, 14}, {482, 57, 5, 14}, {85, 73, 5, 15}, {96, 73, 5, 15}, 
  {237, 73, 4, 15}, {300, 73, 5, 15}, {371, 73, 5, 15}, {444, 73, 5, 15}, 
  {449, 73, 4, 15}, {527, 73, 4, 15}, {107, 90, 5, 14}, {200, 90, 4, 14}, 
  {239, 90, 4, 14}, {74, 113, 5, 15}, {166, 113, 5, 15}, {281, 113, 5, 15}, 
  {313, 113, 5, 15}, {374, 113, 5, 15}, {97, 130, 5, 14}, {125, 130, 5, 14}, 
  {133, 130, 4, 14}, {143, 130, 5, 14}, {190, 130, 4, 14}, {290, 130, 5, 14}, 
  {327, 130, 5, 14}, {418, 130, 5, 14}, {474, 130, 4, 14}, {71, 147, 5, 14}, 
  {76, 147, 4, 14}, {232, 147, 5, 14}, {266, 147, 4, 14}, {270, 147, 5, 14}, 
  {441, 147, 4, 14}, {302, 163, 4, 14}, {120, 187, 4, 14}, {195, 187, 4, 14}, 
  {295, 187, 5, 14}, {362, 187, 5, 14}, {462, 187, 5, 14}, {487, 187, 5, 14}, 
  {56, 203, 5, 14}, {88, 203, 4, 14}, {144, 203, 5, 14}, {209, 203, 5, 14}, 
  {262, 203, 5, 14}, {313, 203, 5, 14}, {365, 203, 5, 14}, {373, 203, 5, 14}, 
  {74, 220, 4, 14}, {192, 220, 5, 14}, {228, 220, 4, 14}, {259, 220, 5, 14}, 
  {295, 220, 5, 14}, {395, 220, 5, 14}, {406, 220, 5, 14}, {455, 220, 5, 14}, 
  {508, 220, 4, 14}, {231, 236, 5, 14}, {341, 236, 5, 14}, {420, 236, 5, 14}, 
  {431, 236, 4, 14}, {121, 253, 5, 14}, {150, 253, 5, 14}, {173, 253, 4, 14}, 
  {209, 253, 5, 14}, {237, 253, 4, 14}, {289, 253, 5, 14}, {320, 253, 5, 14}, 
  {373, 253, 5, 14}, {408, 253, 4, 14}, {431, 253, 4, 14}, {485, 253, 4, 14}, 
  {508, 253, 5, 14}, {170, 269, 5, 15}, {111, 293, 5, 14}, {119, 293, 5, 14}, 
  {310, 309, 4, 15}, {345, 309, 5, 15}, {394, 309, 5, 15}, {453, 309, 5, 15}, 
  {481, 309, 4, 15}, {510, 309, 5, 15}, {117, 326, 5, 14}, {156, 326, 4, 14}, 
  {239, 326, 5, 14}, {315, 326, 5, 14}, {365, 326, 4, 14}, {465, 326, 5, 14}, 
  {107, 343, 4, 14}, {114, 343, 5, 14}, {304, 343, 4, 14}, {382, 343, 5, 14}, 
  {500, 343, 5, 14}, {165, 359, 5, 14}, {281, 359, 5, 14}, {318, 359, 5, 14}, 
  {459, 359, 5, 14}, {517, 359, 5, 14}, {56, 376, 5, 14}, {88, 376, 4, 14}, 
  {94, 399, 5, 14}, {162, 399, 5, 14}, {185, 399, 5, 14}, {259, 399, 5, 14}, 
  {290, 399, 5, 14}, {380, 399, 4, 14}, {472, 399, 5, 14}, {522, 399, 5, 14}, 
  {245, 416, 4, 14}, {273, 416, 5, 14}, {343, 416, 5, 14}, {404, 416, 4, 14}, 
  {115, 432, 5, 15}, {129, 432, 4, 15}, {152, 432, 4, 15}, {162, 432, 5, 15}, 
  {204, 432, 5, 15}, {215, 432, 5, 15}, {246, 432, 4, 15}, {276, 432, 4, 15}, 
  {376, 432, 5, 15}, {402, 432, 5, 15}, {122, 449, 4, 14}, {129, 449, 5, 14}, 
  {206, 449, 5, 14}, {238, 449, 4, 14}, {287, 449, 5, 14}, {304, 449, 5, 14}, 
  {383, 449, 4, 14}, {409, 449, 4, 14}, {483, 449, 4, 14}, {151, 465, 5, 15}, 
  {241, 465, 5, 15}, {252, 465, 7, 15}, {319, 465, 4, 15}, {371, 465, 5, 15}, 
  {480, 465, 5, 15}, {56, 482, 5, 14}, {92, 482, 5, 14}, {132, 482, 5, 14}, 
  {175, 482, 5, 14}, {229, 482, 5, 14}, {273, 482, 5, 14}, {297, 482, 5, 14}, 
  {311, 482, 4, 14}, {462, 482, 4, 14}, {493, 482, 5, 14}, {68, 499, 4, 14}, 
  {133, 499, 4, 14}, {185, 499, 4, 14}, {193, 499, 4, 14}, {265, 499, 5, 14}, 
  {325, 499, 5, 14}, {359, 499, 5, 14}, {463, 499, 4, 14}, {492, 499, 5, 14}, 
  {509, 499, 5, 14}, {114, 515, 5, 14}, {156, 515, 5, 14}, {212, 515, 4, 14}, 
  {255, 515, 7, 14}, {268, 515, 4, 14}, {299, 515, 5, 14}, {304, 515, 4, 14}, 
  {332, 515, 5, 14}, {372, 515, 4, 14}, {158, 532, 4, 14}, {210, 532, 5, 14}, 
  {78, 555, 4, 14}, {155, 555, 5, 14}, {216, 555, 5, 14}, {247, 555, 5, 14}, 
  {344, 555, 5, 14}, {468, 555, 4, 14}, {481, 555, 4, 14}, {194, 572, 5, 14}, 
  {202, 572, 5, 14}, {282, 572, 5, 14}, {290, 572, 4, 14}, {309, 572, 4, 14}, 
  {373, 572, 4, 14}, {516, 572, 6, 14}, {177, 588, 5, 14}, {304, 588, 4, 14}, 
  {398, 588, 5, 14}, {458, 588, 5, 14}, {469, 588, 5, 14}, {516, 588, 6, 14}, 
  {164, 605, 5, 14}, {216, 605, 5, 14}, {266, 605, 5, 14}, {319, 605, 5, 14}, 
  {359, 605, 5, 14}, {395, 605, 5, 14}, {486, 605, 5, 14}, {504, 605, 5, 14}, 
  {120, 621, 4, 15}, {267, 621, 5, 15}, {364, 621, 4, 15}, {452, 621, 4, 15}, 
  {80, 638, 5, 14}, {206, 638, 5, 14}, {302, 638, 4, 14}, {359, 638, 5, 14}, 
  {382, 638, 4, 14}, {120, 654, 4, 15}, {127, 654, 5, 15}, {225, 654, 5, 15}, 
  {286, 654, 4, 15}, {323, 654, 5, 15}, {334, 654, 5, 15}, {345, 654, 4, 15}, 
  {385, 654, 5, 15}, {90, 671, 4, 14}, {108, 671, 5, 14}, {299, 671, 5, 14}, 
  {349, 671, 4, 14}, {406, 671, 4, 14}, {452, 671, 5, 14}, {484, 671, 5, 14}, 
  {74, 695, 5, 14}, {97, 695, 5, 14}, {144, 695, 4, 14}, {191, 695, 4, 14}, 
  {195, 695, 5, 14}, {291, 695, 5, 14}, {302, 695, 7, 14}, {315, 695, 4, 14}, 
  {346, 695, 4, 14}, {350, 695, 5, 14}, {390, 695, 5, 14}, {398, 695, 4, 14}, 
  {509, 695, 6, 14}, {105, 711, 7, 14}, {138, 711, 5, 14}, {190, 711, 5, 14}, 
  {371, 711, 5, 14}, {421, 711, 4, 14}, {431, 711, 5, 14}, {515, 711, 5, 14}, 
  {335, 728, 5, 14}, {399, 728, 5, 14}, {150, 744, 5, 14}, {204, 744, 5, 14}, 
  {69, 57, 5, 14}, {96, 57, 4, 14}, {106, 57, 5, 14}, {146, 57, 5, 14}, 
  {227, 57, 5, 14}, {331, 57, 5, 14}, {376, 57, 5, 14}, {435, 57, 4, 14}, 
  {492, 57, 6, 14}, {97, 73, 5, 15}, {213, 73, 5, 15}, {460, 73, 4, 15}, 
  {520, 73, 5, 15}, {90, 90, 5, 14}, {177, 90, 5, 14}, {188, 90, 5, 14}, 
  {196, 90, 4, 14}, {272, 90, 5, 14}, {304, 90, 5, 14}, {362, 90, 5, 14}, 
  {402, 90, 4, 14}, {499, 90, 5, 14}, {507, 90, 6, 14}, {81, 106, 5, 15}, 
  {89, 106, 5, 15}, {127, 106, 5, 15}, {138, 106, 7, 15}, {191, 106, 5, 15}, 
  {220, 106, 4, 15}, {249, 106, 5, 15}, {293, 106, 4, 15}, {311, 106, 5, 15}, 
  {428, 106, 5, 15}, {461, 106, 4, 15}, {465, 106, 5, 15}, {507, 106, 6, 15}, 
  {148, 123, 7, 14}, {194, 123, 5, 14}, {232, 123, 4, 14}, {250, 123, 5, 14}, 
  {325, 123, 4, 14}, {377, 123, 4, 14}, {476, 123, 5, 14}, {524, 123, 6, 14}, 
  {319, 140, 5, 14}, {330, 140, 4, 14}, {519, 140, 6, 14}, {107, 156, 4, 14}, 
  {117, 156, 5, 14}, {133, 156, 5, 14}, {201, 156, 5, 14}, {278, 156, 5, 14}, 
  {334, 156, 5, 14}, {342, 156, 5, 14}, {451, 156, 5, 14}, {468, 156, 5, 14}, 
  {94, 180, 5, 14}, {162, 180, 4, 14}, {169, 180, 5, 14}, {218, 180, 5, 14}, 
  {278, 180, 4, 14}, {315, 180, 5, 14}, {389, 180, 4, 14}, {415, 180, 5, 14}, 
  {84, 196, 5, 14}, {216, 196, 5, 14}, {274, 196, 5, 14}, {299, 196, 5, 14}, 
  {330, 196, 4, 14}, {337, 196, 5, 14}, {393, 196, 4, 14}, {397, 196, 5, 14}, 
  {115, 213, 5, 14}, {214, 213, 4, 14}, {277, 213, 4, 14}, {332, 213, 4, 14}, 
  {408, 213, 4, 14}, {446, 213, 5, 14}, {460, 213, 5, 14}, {80, 229, 5, 14}, 
  {157, 229, 5, 14}, {190, 229, 4, 14}, {194, 229, 5, 14}, {377, 229, 5, 14}, 
  {388, 229, 6, 14}, {478, 229, 5, 14}, {95, 246, 5, 14}, {163, 246, 5, 14}, 
  {299, 246, 5, 14}, {324, 246, 5, 14}, {395, 246, 6, 14}, {407, 246, 5, 14}, 
  {439, 246, 4, 14}, {443, 246, 5, 14}, {456, 246, 5, 14}, {116, 262, 4, 15}, 
  {169, 262, 5, 15}, {209, 262, 5, 15}, {241, 262, 5, 15}, {281, 262, 5, 15}, 
  {304, 262, 4, 15}, {308, 262, 5, 15}, {380, 262, 5, 15}, {388, 262, 5, 15}, 
  {410, 262, 5, 15}, {442, 262, 7, 15}, {78, 279, 4, 14}, {88, 279, 5, 14}, 
  {109, 302, 4, 15}, {126, 302, 4, 15}, {137, 302, 4, 15}, {161, 302, 5, 15}, 
  {332, 302, 5, 15}, {387, 302, 5, 15}, {416, 302, 5, 15}, {448, 302, 5, 15}, 
  {488, 302, 4, 15}, {85, 319, 5, 14}, {154, 319, 4, 14}, {241, 319, 4, 14}, 
  {308, 319, 5, 14}, {316, 319, 5, 14}, {451, 319, 5, 14}, {481, 319, 5, 14}, 
  {492, 319, 4, 14}, {68, 336, 5, 14}, {159, 336, 4, 14}, {243, 336, 5, 14}, 
  {266, 336, 5, 14}, {297, 336, 5, 14}, {332, 336, 5, 14}, {449, 336, 4, 14}, 
  {459, 336, 5, 14}, {167, 352, 4, 14}, {289, 352, 5, 14}, {351, 352, 4, 14}, 
  {406, 352, 5, 14}, {503, 352, 6, 14}, {80, 369, 4, 14}, {195, 369, 5, 14}, 
  {249, 369, 5, 14}, {303, 369, 4, 14}, {352, 369, 4, 14}, {408, 369, 4, 14}, 
  {463, 369, 4, 14}, {494, 369, 5, 14}, {64, 385, 4, 14}, {74, 385, 5, 14}, 
  {162, 385, 4, 14}, {193, 385, 5, 14}, {299, 385, 5, 14}, {389, 385, 5, 14}, 
  {438, 385, 5, 14}, {455, 385, 5, 14}, {86, 402, 5, 14}, {108, 402, 5, 14}, 
  {177, 402, 5, 14}, {200, 402, 5, 14}, {250, 402, 4, 14}, {308, 402, 5, 14}, 
  {387, 402, 5, 14}, {513, 402, 6, 14}, {204, 418, 5, 15}, {265, 418, 5, 15}, 
  {331, 418, 5, 15}, {398, 418, 5, 15}, {420, 418, 5, 15}, {457, 418, 4, 15}, 
  {531, 418, 6, 15}, {76, 435, 5, 14}, {84, 435, 5, 14}, {95, 435, 4, 14}, 
  {106, 458, 5, 15}, {117, 458, 4, 15}, {160, 458, 5, 15}, {239, 458, 5, 15}, 
  {283, 458, 5, 15}, {338, 458, 4, 15}, {342, 458, 5, 15}, {380, 458, 5, 15}, 
  {385, 458, 4, 15}, {433, 458, 4, 15}, {437, 458, 5, 15}, {488, 458, 5, 15}, 
  {103, 475, 5, 14}, {290, 475, 5, 14}, {319, 475, 6, 14}, {349, 475, 5, 14}, 
  {438, 475, 5, 14}, {56, 492, 5, 14}, {129, 492, 4, 14}, {204, 492, 4, 14}, 
  {279, 492, 4, 14}, {495, 492, 4, 14}, {140, 508, 5, 14}, {267, 508, 5, 14}, 
  {299, 508, 5, 14}, {307, 508, 5, 14}, {337, 508, 5, 14}, {418, 508, 5, 14}, 
  {465, 508, 5, 14}, {80, 525, 5, 14}, {139, 525, 5, 14}, {188, 525, 4, 14}, 
  {195, 525, 5, 14}, {227, 525, 4, 14}, {274, 525, 5, 14}, {351, 525, 5, 14}, 
  {374, 525, 5, 14}, {385, 525, 4, 14}, {413, 525, 5, 14}, {465, 525, 5, 14}, 
  {476, 525, 5, 14}, {512, 525, 6, 14}, {129, 541, 4, 14}, {198, 541, 4, 14}, 
  {205, 541, 5, 14}, {278, 541, 5, 14}, {389, 541, 5, 14}, {418, 541, 5, 14}, 
  {471, 541, 4, 14}, {99, 558, 4, 14}, {130, 558, 5, 14}, {166, 558, 5, 14}, 
  {206, 558, 5, 14}, {249, 558, 5, 14}, {303, 558, 5, 14}, {347, 558, 5, 14}, 
  {371, 558, 5, 14}, {385, 558, 4, 14}, {395, 558, 7, 14}, {428, 558, 5, 14}, 
  {515, 558, 6, 14}, {81, 574, 5, 14}, {304, 574, 5, 14}, {493, 574, 5, 14}, 
  {132, 591, 5, 14}, {140, 591, 5, 14}, {232, 591, 5, 14}, {74, 614, 5, 15}, 
  {249, 614, 4, 15}, {259, 614, 5, 15}, {328, 614, 5, 15}, {357, 614, 5, 15}, 
  {404, 614, 4, 15}, {432, 614, 5, 15}, {484, 614, 5, 15}, {507, 614, 6, 15}, 
  {80, 631, 4, 14}, {111, 631, 5, 14}, {160, 631, 4, 14}, {187, 631, 5, 14}, 
  {243, 631, 5, 14}, {334, 631, 5, 14}, {412, 631, 4, 14}, {78, 647, 4, 15}, 
  {121, 647, 5, 15}, {132, 647, 5, 15}, {207, 647, 5, 15}, {215, 647, 5, 15}, 
  {357, 647, 4, 15}, {361, 647, 5, 15}, {396, 647, 4, 15}, {465, 647, 5, 15}, 
  {470, 647, 5, 15}, {80, 664, 5, 14}, {186, 664, 5, 14}, {227, 664, 5, 14}, 
  {306, 664, 5, 14}, {346, 664, 5, 14}, {414, 664, 5, 14}, {465, 664, 5, 14}, 
  {100, 681, 5, 14}, {111, 681, 4, 14}, {159, 681, 4, 14}, {226, 681, 5, 14}, 
  {454, 681, 4, 14}, {512, 681, 5, 14}, {72, 697, 4, 14}, {160, 697, 4, 14}, 
  {188, 697, 4, 14}, {195, 697, 5, 14}, {293, 697, 4, 14}, {297, 697, 5, 14}, 
  {359, 697, 4, 14}, {390, 697, 7, 14}, {403, 697, 4, 14}, {434, 697, 5, 14}, 
  {439, 697, 4, 14}, {56, 714, 5, 14}, {166, 714, 5, 14}, {171, 714, 5, 14}, 
  {292, 714, 5, 14}, {363, 714, 4, 14}, {533, 714, 6, 14}, {108, 730, 5, 14}, 
  {140, 730, 5, 14}, {148, 730, 5, 14}, {132, 754, 5, 14}, {224, 754, 4, 14}, 
  {287, 754, 5, 14}, {292, 754, 4, 14}, {359, 754, 4, 14}, {384, 754, 5, 14}, 
  {109, 770, 5, 15}, {186, 770, 5, 15}, {240, 770, 5, 15}, {358, 770, 4, 15}, 
  {453, 770, 4, 15}, {485, 770, 5, 15}, {490, 770, 4, 15}, {510, 770, 5, 15}, 
  {149, 57, 5, 14}, {154, 57, 5, 14}, {225, 57, 5, 14}, {233, 57, 5, 14}, 
  {241, 57, 5, 14}, {291, 57, 5, 14}, {391, 57, 5, 14}, {86, 73, 5, 15}, 
  {206, 73, 5, 15}, {281, 73, 5, 15}, {382, 73, 5, 15}, {102, 90, 5, 14}, 
  {137, 90, 5, 14}, {145, 90, 5, 14}, {320, 90, 4, 14}, {337, 90, 4, 14}, 
  {369, 90, 4, 14}, {376, 90, 5, 14}, {387, 90, 5, 14}, {416, 90, 5, 14}, 
  {460, 90, 5, 14}, {482, 90, 4, 14}, {80, 106, 4, 15}, {113, 106, 7, 15}, 
  {363, 106, 5, 15}, {439, 106, 5, 15}, {82, 123, 4, 14}, {185, 123, 4, 14}, 
  {257, 123, 5, 14}, {286, 123, 5, 14}, {294, 123, 5, 14}, {387, 123, 4, 14}, 
  {135, 140, 4, 14}, {203, 140, 5, 14}, {142, 163, 5, 14}, {252, 163, 5, 14}, 
  {257, 163, 5, 14}, {340, 163, 5, 14}, {406, 163, 4, 14}, {442, 163, 5, 14}, 
  {229, 180, 5, 14}, {237, 180, 5, 14}, {286, 180, 4, 14}, {375, 180, 4, 14}, 
  {382, 180, 5, 14}, {405, 180, 4, 14}, {448, 180, 5, 14}, {453, 180, 5, 14}, 
  {56, 196, 5, 14}, {67, 196, 5, 14}, {111, 196, 4, 14}, {115, 196, 5, 14}, 
  {144, 196, 4, 14}, {188, 196, 5, 14}, {211, 196, 4, 14}, {240, 196, 4, 14}, 
  {298, 196, 5, 14}, {323, 196, 6, 14}, {335, 196, 5, 14}, {367, 196, 4, 14}, 
  {371, 196, 5, 14}, {66, 213, 4, 14}, {192, 213, 4, 14}, {315, 213, 5, 14}, 
  {360, 213, 5, 14}, {384, 213, 5, 14}, {411, 213, 5, 14}, {469, 213, 4, 14}, 
  {486, 213, 4, 14}, {497, 213, 4, 14}, {56, 229, 5, 14}, {87, 229, 5, 14}, 
  {127, 229, 4, 14}, {137, 229, 7, 14}, {198, 229, 5, 14}, {272, 229, 4, 14}, 
  {428, 229, 5, 14}, {74, 246, 5, 14}, {97, 246, 5, 14}, {129, 246, 4, 14}, 
  {248, 246, 4, 14}, {389, 246, 4, 14}, {461, 246, 4, 14}, {222, 262, 5, 15}, 
  {257, 262, 5, 15}, {398, 262, 5, 15}, {421, 262, 5, 15}, {456, 262, 4, 15}, 
  {111, 279, 4, 14}, {124, 279, 5, 14}, {132, 279, 4, 14}, {233, 279, 4, 14}, 
  {281, 279, 5, 14}, {286, 279, 4, 14}, {299, 279, 4, 14}, {125, 302, 4, 15}, 
  {158, 302, 5, 15}, {163, 302, 5, 15}, {255, 302, 5, 15}, {266, 302, 7, 15}, 
  {279, 302, 5, 15}, {310, 302, 5, 15}, {315, 302, 4, 15}, {328, 302, 4, 15}, 
  {505, 302, 5, 15}, {186, 319, 5, 14}, {209, 319, 4, 14}, {320, 319, 5, 14}, 
  {349, 319, 5, 14}, {370, 319, 4, 14}, {439, 319, 5, 14}, {197, 336, 5, 14}, 
  {253, 336, 5, 14}, {346, 336, 5, 14}, {501, 336, 5, 14}, {524, 336, 5, 14}, 
  {80, 352, 4, 14}, {146, 352, 4, 14}, {232, 352, 5, 14}, {353, 352, 5, 14}, 
  {200, 376, 4, 14}, {231, 376, 5, 14}, {272, 376, 5, 14}, {393, 376, 4, 14}, 
  {78, 392, 5, 14}, {101, 392, 5, 14}, {154, 392, 5, 14}, {186, 392, 4, 14}, 
  {470, 392, 4, 14}, {86, 409, 4, 14}, {129, 409, 5, 14}, {264, 409, 5, 14}, 
  {307, 409, 5, 14}, {516, 409, 5, 14}, {83, 425, 5, 15}, {130, 425, 4, 15}, 
  {340, 425, 4, 15}, {444, 425, 5, 15}, {467, 425, 4, 15}, {64, 442, 4, 14}, 
  {74, 442, 5, 14}, {139, 442, 5, 14}, {215, 442, 5, 14}, {220, 442, 5, 14}, 
  {298, 442, 4, 14}, {394, 442, 4, 14}, {448, 442, 5, 14}, {502, 442, 4, 14}, 
  {82, 458, 5, 15}, {138, 458, 5, 15}, {260, 458, 4, 15}, {264, 458, 5, 15}, 
  {365, 458, 5, 15}, {56, 482, 7, 14}, {114, 482, 4, 14}, {151, 482, 7, 14}, 
  {203, 482, 5, 14}, {235, 482, 5, 14}, {338, 482, 4, 14}, {348, 482, 5, 14}, 
  {391, 482, 5, 14}, {426, 482, 5, 14}, {515, 482, 6, 14}, {79, 499, 5, 14}, 
  {125, 499, 4, 14}, {135, 499, 5, 14}, {246, 499, 5, 14}, {272, 499, 5, 14}, 
  {300, 499, 5, 14}, {308, 499, 4, 14}, {338, 499, 5, 14}, {349, 499, 4, 14}, 
  {444, 499, 4, 14}, {488, 499, 4, 14}, {506, 499, 5, 14}, {92, 515, 5, 14}, 
  {131, 515, 4, 14}, {196, 515, 5, 14}, {201, 515, 4, 14}, {389, 515, 4, 14}, 
  {465, 515, 5, 14}, {97, 532, 5, 14}, {274, 532, 5, 14}, {288, 532, 6, 14}, 
  {375, 532, 5, 14}, {437, 532, 5, 14}, {468, 532, 5, 14}, {497, 532, 4, 14}, 
  {86, 548, 4, 14}, {190, 548, 5, 14}, {356, 548, 5, 14}, {418, 548, 4, 14}, 
  {71, 565, 5, 14}, {229, 565, 5, 14}, {261, 565, 4, 14}, {327, 565, 5, 14}, 
  {350, 565, 5, 14}, {360, 565, 5, 14}, {83, 581, 5, 14}, {106, 581, 5, 14}, 
  {117, 581, 4, 14}, {143, 581, 5, 14}, {151, 581, 5, 14}, {196, 581, 5, 14}, 
  {274, 581, 4, 14}, {382, 581, 5, 14}, {420, 581, 4, 14}, {443, 581, 4, 14}, 
  {69, 605, 5, 14}, {146, 605, 5, 14}, {195, 605, 5, 14}, {251, 605, 5, 14}, 
  {305, 605, 4, 14}, {354, 605, 5, 14}, {374, 605, 5, 14}, {137, 621, 4, 15}, 
  {177, 621, 5, 15}, {234, 621, 5, 15}, {278, 621, 4, 15}, {288, 621, 5, 15}, 
  {338, 621, 5, 15}, {390, 621, 5, 15}, {398, 621, 4, 15}, {506, 621, 5, 15}, 
  {115, 638, 5, 14}, {207, 638, 4, 14}, {217, 638, 5, 14}, {265, 638, 5, 14}, 
  {369, 638, 5, 14}, {91, 654, 5, 15}, {129, 654, 4, 15}, {252, 654, 5, 15}, 
  {263, 654, 5, 15}, {372, 654, 5, 15}, {404, 654, 4, 15}, {73, 671, 5, 14}, 
  {86, 671, 5, 14}, {109, 671, 5, 14}, {140, 671, 5, 14}, {237, 671, 5, 14}, 
  {327, 671, 4, 14}, {376, 671, 5, 14}, {393, 671, 5, 14}, {480, 671, 5, 14}, 
  {502, 671, 5, 14}, {94, 688, 4, 14}, {117, 688, 4, 14}, {145, 688, 5, 14}, 
  {153, 688, 5, 14}, {284, 688, 5, 14}, {331, 688, 5, 14}, {370, 688, 4, 14}, 
  {383, 688, 5, 14}, {406, 688, 5, 14}, {437, 688, 4, 14}, {141, 704, 4, 14}, 
  {351, 704, 5, 14}, {74, 728, 5, 14}, {210, 728, 5, 14}, {328, 728, 5, 14}, 
  {339, 728, 7, 14}, {352, 728, 4, 14}, {383, 728, 5, 14}, {388, 728, 4, 14}, 
  {476, 728, 5, 14}, {156, 744, 5, 14}, {297, 744, 5, 14}, {338, 744, 5, 14}, 
  {369, 744, 5, 14}, {409, 744, 5, 14}, {414, 744, 4, 14}, {430, 744, 6, 14}, 
  {442, 744, 5, 14}, {474, 744, 4, 14}, {478, 744, 5, 14}, {56, 761, 5, 14}, 
  {181, 761, 5, 14}, {301, 761, 5, 14}, {332, 761, 5, 14}, {397, 761, 5, 14}, 
  {428, 761, 5, 14}, {461, 761, 4, 14}, {471, 761, 5, 14}, {500, 761, 5, 14}, 
  {523, 761, 5, 14}, {110, 57, 5, 14}, {207, 57, 5, 14}, {227, 57, 5, 14}, 
  {438, 57, 5, 14}, {449, 57, 5, 14}, {487, 57, 4, 14}, {510, 57, 5, 14}, 
  {72, 73, 4, 15}, {91, 73, 5, 15}, {193, 73, 5, 15}, {333, 73, 5, 15}, 
  {390, 73, 5, 15}, {442, 73, 4, 15}, {446, 73, 5, 15}, {129, 90, 4, 14}, 
  {197, 90, 4, 14}, {228, 90, 5, 14}, {348, 90, 4, 14}, {421, 90, 4, 14}, 
  {479, 90, 5, 14}, {490, 90, 5, 14}, {121, 106, 4, 15}, {131, 106, 7, 15}, 
  {152, 106, 5, 15}, {182, 106, 4, 15}, {319, 106, 5, 15}, {500, 106, 6, 15}, 
  {56, 123, 5, 14}, {87, 123, 5, 14}, {216, 123, 4, 14}, {226, 123, 5, 14}, 
  {273, 123, 4, 14}, {277, 123, 5, 14}, {441, 123, 5, 14}, {484, 123, 5, 14}, 
  {78, 140, 5, 14}, {137, 140, 5, 14}, {370, 140, 5, 14}, {378, 140, 5, 14}, 
  {459, 140, 5, 14}, {516, 140, 6, 14}, {72, 156, 4, 14}, {82, 156, 5, 14}, 
  {163, 156, 4, 14}, {213, 156, 5, 14}, {321, 156, 5, 14}, {411, 156, 5, 14}, 
  {434, 156, 5, 14}, {445, 156, 5, 14}, {80, 173, 4, 14}, {110, 173, 5, 14}, 
  {147, 173, 5, 14}, {152, 173, 4, 14}, {95, 196, 5, 14}, {253, 196, 4, 14}, 
  {305, 196, 5, 14}, {345, 196, 4, 14}, {386, 196, 5, 14}, {440, 196, 5, 14}, 
  {80, 213, 5, 14}, {163, 213, 5, 14}, {191, 213, 5, 14}, {256, 213, 5, 14}, 
  {313, 213, 4, 14}, {357, 213, 4, 14}, {487, 213, 5, 14}, {93, 229, 5, 14}, 
  {172, 229, 5, 14}, {230, 229, 5, 14}, {415, 229, 5, 14}, {454, 229, 5, 14}, 
  {504, 229, 5, 14}, {333, 246, 5, 14}, {416, 246, 5, 14}, {465, 246, 5, 14}, 
  {108, 262, 5, 15}, {172, 262, 5, 15}, {218, 262, 5, 15}, {247, 262, 5, 15}, 
  {312, 262, 5, 15}, {335, 262, 4, 15}, {430, 262, 5, 15}, {495, 262, 5, 15}, 
  {186, 279, 5, 14}, {292, 279, 7, 14}, {305, 279, 4, 14}, {336, 279, 5, 14}, 
  {341, 279, 4, 14}, {419, 279, 5, 14}, {430, 279, 5, 14}, {186, 302, 5, 15}, 
  {215, 302, 5, 15}, {284, 302, 5, 15}, {317, 302, 4, 15}, {459, 302, 5, 15}, 
  {464, 302, 4, 15}, {90, 319, 5, 14}, {113, 319, 5, 14}, {236, 319, 5, 14}, 
  {259, 319, 5, 14}, {330, 319, 4, 14}, {347, 319, 4, 14}, {405, 319, 4, 14}, 
  {453, 319, 5, 14}, {495, 319, 4, 14}, {72, 336, 4, 14}, {197, 336, 5, 14}, 
  {264, 336, 4, 14}, {346, 336, 4, 14}, {356, 336, 5, 14}, {386, 336, 4, 14}, 
  {488, 336, 5, 14}, {72, 352, 5, 14}, {150, 352, 5, 14}, {173, 352, 5, 14}, 
  {493, 352, 5, 14}, {81, 369, 5, 14}, {86, 369, 4, 14}, {188, 369, 5, 14}, 
  {257, 369, 5, 14}, {427, 369, 4, 14}, {437, 369, 5, 14}, {477, 369, 5, 14}, 
  {94, 409, 5, 14}, {102, 409, 5, 14}, {205, 409, 5, 14}, {229, 409, 5, 14}, 
  {258, 409, 4, 14}, {341, 409, 5, 14}, {346, 409, 4, 14}, {386, 409, 4, 14}, 
  {436, 409, 4, 14}, {491, 409, 5, 14}, {283, 425, 4, 15}, {291, 425, 4, 15}, 
  {306, 425, 4, 15}, {316, 425, 5, 15}, {357, 425, 4, 15}, {455, 425, 5, 15}, 
  {472, 425, 5, 15}, {146, 442, 5, 14}, {262, 442, 5, 14}, {492, 442, 5, 14}, 
  {503, 442, 5, 14}, {94, 458, 5, 15}, {122, 458, 4, 15}, {133, 458, 4, 15}, 
  {152, 458, 4, 15}, {198, 458, 5, 15}, {206, 458, 5, 15}, {250, 458, 5, 15}, 
  {258, 458, 5, 15}, {312, 458, 4, 15}, {393, 458, 5, 15}, {439, 458, 5, 15}, 
  {80, 475, 4, 14}, {113, 475, 7, 14}, {160, 475, 4, 14}, {272, 475, 5, 14}, 
  {321, 475, 4, 14}, {481, 475, 6, 14}, {125, 492, 4, 14}, {204, 492, 6, 14}, 
  {249, 492, 5, 14}, {254, 492, 5, 14}, {321, 492, 5, 14}, {332, 492, 5, 14}, 
  {459, 492, 5, 14}, {531, 492, 5, 14}, {72, 508, 4, 14}, {134, 508, 5, 14}, 
  {218, 508, 7, 14}, {231, 508, 5, 14}, {262, 508, 5, 14}, {267, 508, 5, 14}, 
  {351, 508, 5, 14}, {374, 508, 5, 14}, {405, 508, 5, 14}, {276, 532, 5, 14}, 
  {287, 532, 6, 14}, {308, 532, 4, 14}, {378, 532, 5, 14}, {386, 532, 4, 14}, 
  {455, 532, 4, 14}, {96, 548, 4, 14}, {286, 548, 5, 14}, {297, 548, 4, 14}, 
  {418, 548, 5, 14}, {480, 548, 4, 14}, {509, 548, 5, 14}, {88, 565, 5, 14}, 
  {124, 565, 5, 14}, {174, 565, 5, 14}, {188, 565, 4, 14}, {267, 565, 5, 14}, 
  {272, 565, 4, 14}, {301, 565, 5, 14}, {56, 581, 5, 14}, {100, 581, 5, 14}, 
  {149, 581, 5, 14}, {347, 581, 5, 14}, {410, 581, 5, 14}, {108, 605, 5, 14}, 
  {183, 605, 5, 14}, {224, 605, 4, 14}, {439, 605, 5, 14}, {81, 621, 5, 15}, 
  {89, 621, 5, 15}, {164, 621, 5, 15}, {217, 621, 5, 15}, {345, 621, 5, 15}, 
  {488, 621, 5, 15}, {78, 638, 4, 14}, {142, 638, 4, 14}, {152, 638, 5, 14}, 
  {227, 638, 4, 14}, {237, 638, 5, 14}, {269, 638, 7, 14}, {282, 638, 4, 14}, 
  {313, 638, 5, 14}, {318, 638, 4, 14}, {432, 638, 5, 14}, {443, 638, 5, 14}, 
  {90, 654, 4, 15}, {103, 654, 4, 15}, {154, 654, 5, 15}, {228, 654, 5, 15}, 
  {239, 654, 4, 15}, {246, 654, 5, 15}, {381, 654, 5, 15}, {439, 654, 4, 15}, 
  {505, 654, 6, 15}, {113, 671, 4, 14}, {136, 671, 5, 14}, {241, 671, 5, 14}, 
  {252, 671, 4, 14}, {329, 671, 5, 14}, {396, 671, 4, 14}, {427, 671, 5, 14}, 
  {117, 695, 5, 14}, {149, 695, 5, 14}, {263, 695, 5, 14}, {330, 695, 5, 14}, 
  {392, 695, 5, 14}, {512, 695, 5, 14}, {520, 695, 5, 14}, {86, 711, 4, 14}, 
  {147, 711, 5, 14}, {158, 711, 4, 14}, {288, 711, 4, 14}, {298, 711, 5, 14}, 
  {397, 711, 4, 14}, {445, 711, 5, 14}, {120, 728, 5, 14}, {155, 728, 4, 14}, 
  {290, 728, 5, 14}, {376, 728, 5, 14}, {520, 728, 6, 14}, {56, 744, 5, 14}, 
  {170, 744, 5, 14}, {260, 744, 4, 14}, {420, 744, 4, 14}, {471, 744, 5, 14}, 
  {518, 744, 5, 14}, {151, 57, 5, 14}, {198, 57, 4, 14}, {286, 57, 5, 14}, 
  {136, 73, 5, 15}, {168, 73, 5, 15}, {69, 97, 5, 14}, {164, 97, 5, 14}, 
  {175, 97, 5, 14}, {219, 97, 5, 14}, {323, 97, 5, 14}, {454, 97, 4, 14}, 
  {94, 113, 5, 15}, {159, 113, 5, 15}, {211, 113, 5, 15}, {298, 113, 5, 15}, 
  {303, 113, 4, 15}, {356, 113, 5, 15}, {404, 113, 5, 15}, {56, 130, 5, 14}, 
  {240, 130, 5, 14}, {289, 130, 5, 14}, {294, 130, 5, 14}, {413, 130, 4, 14}, 
  {461, 130, 5, 14}, {490, 130, 5, 14}, {149, 147, 4, 14}, {215, 147, 4, 14}, 
  {269, 147, 5, 14}, {293, 147, 5, 14}, {327, 147, 5, 14}, {377, 147, 5, 14}, 
  {400, 147, 4, 14}, {423, 147, 4, 14}, {74, 163, 4, 14}, {141, 163, 4, 14}, 
  {214, 163, 4, 14}, {354, 163, 5, 14}, {450, 163, 5, 14}, {123, 187, 5, 14}, 
  {164, 187, 4, 14}, {174, 187, 5, 14}, {182, 187, 5, 14}, {211, 187, 5, 14}, 
  {265, 187, 5, 14}, {307, 187, 5, 14}, {320, 187, 5, 14}, {400, 187, 5, 14}, 
  {408, 187, 5, 14}, {56, 203, 5, 14}, {156, 203, 5, 14}, {261, 203, 5, 14}, 
  {301, 203, 5, 14}, {374, 203, 5, 14}, {428, 203, 5, 14}, {487, 203, 4, 14}, 
  {511, 203, 5, 14}, {115, 220, 4, 14}, {143, 220, 4, 14}, {180, 220, 5, 14}, 
  {238, 220, 5, 14}, {345, 220, 5, 14}, {81, 236, 5, 14}, {86, 236, 4, 14}, 
  {144, 236, 5, 14}, {226, 236, 4, 14}, {276, 236, 4, 14}, {345, 236, 5, 14}, 
  {429, 236, 5, 14}, {461, 236, 4, 14}, {152, 253, 4, 14}, {215, 253, 5, 14}, 
  {322, 253, 5, 14}, {446, 253, 5, 14}, {72, 269, 4, 15}, {113, 269, 4, 15}, 
  {150, 269, 4, 15}, {253, 269, 4, 15}, {101, 309, 4, 15}, {134, 309, 4, 15}, 
  {222, 309, 5, 15}, {246, 309, 5, 15}, {346, 309, 4, 15}, {411, 309, 5, 15}, 
  {135, 326, 5, 14}, {187, 326, 5, 14}, {460, 326, 4, 14}, {483, 326, 5, 14}, 
  {87, 343, 5, 14}, {95, 343, 4, 14}, {137, 343, 5, 14}, {145, 343, 4, 14}, 
  {200, 343, 4, 14}, {204, 343, 5, 14}, {233, 343, 5, 14}, {293, 343, 5, 14}, 
  {323, 343, 5, 14}, {355, 343, 5, 14}, {470, 343, 4, 14}, {56, 359, 7, 14}, 
  {101, 359, 5, 14}, {139, 359, 5, 14}, {168, 359, 5, 14}, {194, 359, 5, 14}, 
  {267, 359, 5, 14}, {389, 359, 5, 14}, {74, 376, 4, 14}, {157, 376, 5, 14}, 
  {226, 376, 5, 14}, {371, 376, 5, 14}, {500, 376, 4, 14}, {531, 376, 5, 14}, 
  {137, 392, 4, 14}, {176, 392, 5, 14}, {223, 392, 5, 14}, {312, 392, 5, 14}, 
  {320, 392, 4, 14}, {153, 416, 5, 14}, {203, 416, 4, 14}, {524, 416, 6, 14}, 
  {126, 432, 5, 15}, {158, 432, 4, 15}, {324, 432, 5, 15}, {355, 432, 5, 15}, 
  {387, 432, 5, 15}, {496, 432, 4, 15}, {109, 449, 5, 14}, {131, 449, 5, 14}, 
  {211, 449, 5, 14}, {329, 449, 5, 14}, {346, 449, 5, 14}, {439, 449, 4, 14}, 
  {96, 465, 4, 15}, {128, 465, 5, 15}, {156, 465, 5, 15}, {196, 465, 5, 15}, 
  {204, 465, 5, 15}, {300, 465, 7, 15}, {313, 465, 5, 15}, {344, 465, 5, 15}, 
  {349, 465, 4, 15}, {362, 465, 4, 15}, {484, 465, 4, 15}, {81, 482, 5, 14}, 
  {86, 482, 4, 14}, {156, 482, 5, 14}, {203, 482, 4, 14}, {258, 482, 5, 14}, 
  {290, 482, 5, 14}, {329, 482, 5, 14}, {479, 482, 5, 14}, {114, 499, 5, 14}, 
  {257, 499, 5, 14}, {454, 499, 5, 14}, {486, 499, 5, 14}, {71, 515, 5, 14}, 
  {76, 515, 4, 14}, {161, 515, 4, 14}, {188, 515, 5, 14}, {250, 515, 5, 14}, 
  {79, 539, 4, 14}, {164, 539, 5, 14}, {236, 539, 4, 14}, {297, 539, 4, 14}, 
  {322, 539, 5, 14}, {501, 539, 5, 14}, {509, 539, 5, 14}, {74, 555, 4, 14}, 
  {180, 555, 5, 14}, {305, 555, 5, 14}, {331, 555, 5, 14}, {390, 555, 5, 14}, 
  {528, 555, 6, 14}, {355, 572, 5, 14}, {379, 572, 4, 14}, {490, 572, 4, 14}, 
  {497, 572, 5, 14}, {141, 588, 4, 14}, {187, 588, 5, 14}, {195, 588, 4, 14}, 
  {435, 588, 4, 14}, {56, 612, 7, 14}, {69, 612, 5, 14}, {100, 612, 5, 14}, 
  {105, 612, 5, 14}, {233, 612, 4, 14}, {288, 612, 5, 14}, {311, 612, 4, 14}, 
  {456, 612, 5, 14}, {467, 612, 5, 14}, {94, 628, 5, 15}, {111, 628, 5, 15}, 
  {186, 628, 5, 15}, {307, 628, 5, 15}, {353, 628, 7, 15}, {396, 628, 4, 15}, 
  {80, 645, 4, 14}, {152, 645, 5, 14}, {347, 645, 5, 14}, {401, 645, 5, 14}, 
  {455, 645, 5, 14}, {504, 645, 5, 14}, {92, 661, 5, 15}, {121, 661, 5, 15}, 
  {163, 661, 4, 15}, {261, 661, 5, 15}, {336, 661, 5, 15}, {66, 678, 4, 14}, 
  {166, 678, 5, 14}, {171, 678, 5, 14}, {219, 678, 4, 14}, {423, 678, 5, 14}, 
  {452, 678, 5, 14}, {74, 695, 5, 14}, {97, 695, 5, 14}, {100, 718, 4, 14}, 
  {201, 718, 5, 14}, {239, 718, 4, 14}, {311, 718, 5, 14}, {351, 718, 5, 14}, 
  {362, 718, 4, 14}, {388, 718, 4, 14}, {398, 718, 5, 14}, {452, 718, 5, 14}, 
  {83, 735, 5, 14}, {91, 735, 4, 14}, {116, 735, 7, 14}, {129, 735, 4, 14}, 
  {160, 735, 5, 14}, {165, 735, 4, 14}, {205, 735, 4, 14}, {493, 735, 5, 14}, 
  {524, 735, 5, 14}, {165, 751, 5, 14}, {210, 751, 4, 14}, {291, 751, 5, 14}, 
  {331, 751, 5, 14}, {342, 751, 5, 14}, {115, 768, 5, 14}, {140, 768, 5, 14}, 
  {284, 768, 7, 14}, {455, 768, 4, 14}, {94, 57, 5, 14}, {150, 57, 5, 14}, 
  {305, 57, 5, 14}, {316, 57, 4, 14}, {453, 57, 5, 14}, {464, 57, 4, 14}, 
  {471, 57, 5, 14}, {518, 57, 5, 14}, {56, 73, 5, 15}, {135, 73, 5, 15}, 
  {204, 73, 5, 15}, {247, 73, 5, 15}, {271, 73, 4, 15}, {399, 73, 5, 15}, 
  {470, 73, 5, 15}, {98, 90, 4, 14}, {360, 90, 4, 14}, {364, 90, 5, 14}, 
  {431, 90, 5, 14}, {457, 90, 4, 14}, {171, 106, 4, 15}, {247, 106, 5, 15}, 
  {302, 106, 5, 15}, {103, 130, 4, 14}, {354, 130, 4, 14}, {220, 147, 4, 14}, 
  {377, 147, 5, 14}, {474, 147, 5, 14}, {199, 163, 5, 14}, {263, 163, 5, 14}, 
  {335, 163, 5, 14}, {412, 163, 5, 14}, {454, 163, 4, 14}, {177, 180, 4, 14}, 
  {218, 180, 5, 14}, {320, 180, 5, 14}, {328, 180, 5, 14}, {94, 196, 5, 14}, 
  {244, 196, 4, 14}, {394, 196, 5, 14}, {476, 196, 5, 14}, {149, 213, 5, 14}, 
  {157, 213, 5, 14}, {283, 213, 4, 14}, {305, 213, 5, 14}, {352, 213, 5, 14}, 
  {388, 213, 5, 14}, {461, 213, 5, 14}, {469, 213, 5, 14}, {529, 213, 6, 14}, 
  {78, 229, 5, 14}, {86, 229, 5, 14}, {146, 229, 7, 14}, {159, 229, 4, 14}, 
  {190, 229, 5, 14}, {195, 229, 4, 14}, {231, 229, 5, 14}, {332, 229, 5, 14}, 
  {381, 229, 4, 14}, {470, 229, 5, 14}, {56, 253, 7, 14}, {144, 253, 5, 14}, 
  {249, 253, 4, 14}, {316, 253, 4, 14}, {405, 253, 5, 14}, {496, 253, 5, 14}, 
  {175, 269, 5, 15}, {206, 269, 4, 15}, {238, 269, 4, 15}, {285, 269, 4, 15}, 
  {313, 269, 5, 15}, {446, 269, 6, 15}, {467, 269, 4, 15}, {212, 286, 4, 14}, 
  {343, 286, 5, 14}, {433, 286, 5, 14}, {438, 286, 5, 14}, {474, 286, 5, 14}, 
  {76, 302, 5, 15}, {223, 302, 5, 15}, {296, 302, 5, 15}, {360, 302, 5, 15}, 
  {406, 302, 4, 15}, {517, 302, 5, 15}, {100, 319, 4, 14}, {119, 319, 5, 14}, 
  {177, 319, 5, 14}, {214, 319, 5, 14}, {344, 319, 4, 14}, {416, 319, 5, 14}, 
  {500, 319, 4, 14}, {510, 319, 5, 14}, {82, 336, 4, 14}, {99, 336, 4, 14}, 
  {156, 336, 5, 14}, {164, 336, 5, 14}, {315, 336, 5, 14}, {350, 336, 5, 14}, 
  {381, 336, 4, 14}, {403, 336, 5, 14}, {408, 336, 4, 14}, {88, 352, 5, 14}, 
  {151, 352, 4, 14}, {173, 352, 5, 14}, {290, 352, 5, 14}, {309, 352, 4, 14}, 
  {423, 352, 5, 14}, {78, 392, 4, 14}, {156, 392, 5, 14}, {161, 392, 4, 14}, 
  {420, 392, 5, 14}, {463, 392, 5, 14}, {201, 409, 5, 14}, {209, 409, 5, 14}, 
  {278, 409, 4, 14}, {309, 409, 5, 14}, {432, 409, 4, 14}, {442, 409, 5, 14}, 
  {450, 409, 5, 14}, {461, 409, 4, 14}, {133, 425, 4, 15}, {143, 425, 7, 15}, 
  {180, 425, 4, 15}, {308, 425, 5, 15}, {414, 425, 5, 15}, {464, 425, 4, 15}, 
  {128, 442, 5, 14}, {147, 442, 5, 14}, {158, 442, 5, 14}, {223, 442, 4, 14}, 
  {286, 442, 5, 14}, {294, 442, 5, 14}, {323, 442, 5, 14}, {356, 442, 5, 14}, 
  {394, 442, 4, 14}, {56, 458, 5, 15}, {88, 458, 4, 15}, {219, 458, 5, 15}, 
  {230, 458, 7, 15}, {251, 458, 5, 15}, {420, 458, 5, 15}, {443, 458, 5, 15}, 
  {503, 458, 4, 15}, {305, 475, 4, 14}, {369, 475, 6, 14}, {80, 492, 5, 14}, 
  {207, 492, 5, 14}, {237, 492, 5, 14}, {270, 492, 5, 14}, {288, 492, 5, 14}, 
  {397, 492, 4, 14}, {449, 492, 5, 14}, {481, 492, 4, 14}, {95, 508, 5, 14}, 
  {244, 508, 5, 14}, {289, 508, 5, 14}, {338, 508, 5, 14}, {349, 508, 4, 14}, 
  {393, 508, 5, 14}, {453, 508, 5, 14}, {464, 508, 5, 14}, {498, 508, 5, 14}, 
  {103, 548, 4, 14}, {225, 548, 4, 14}, {69, 565, 5, 14}, {103, 565, 4, 14}, 
  {113, 565, 5, 14}, {248, 565, 5, 14}, {265, 565, 5, 14}, {402, 565, 5, 14}, 
  {436, 565, 5, 14}, {515, 565, 5, 14}, {97, 581, 5, 14}, {120, 581, 5, 14}, 
  {128, 581, 4, 14}, {207, 581, 4, 14}, {211, 581, 5, 14}, {253, 581, 5, 14}, 
  {272, 581, 5, 14}, {283, 581, 4, 14}, {367, 581, 5, 14}, {388, 581, 4, 14}, 
  {423, 581, 5, 14}, {428, 581, 5, 14}, {470, 581, 5, 14}, {89, 598, 5, 14}, 
  {144, 598, 4, 14}, {198, 598, 4, 14}, {208, 598, 7, 14}, {286, 598, 5, 14}, 
  {323, 598, 5, 14}, {430, 598, 5, 14}, {500, 598, 5, 14}, {88, 614, 4, 15}, 
  {116, 614, 5, 15}, {206, 614, 5, 15}, {229, 614, 4, 15}, {259, 614, 5, 15}, 
  {56, 631, 5, 14}, {67, 631, 5, 14}, {132, 631, 5, 14}, {86, 654, 4, 15}, 
  {124, 654, 5, 15}, {202, 654, 5, 15}, {207, 654, 4, 15}, {259, 654, 5, 15}, 
  {360, 654, 4, 15}, {383, 654, 4, 15}, {398, 654, 4, 15}, {408, 654, 5, 15}, 
  {427, 654, 5, 15}, {87, 671, 5, 14}, {143, 671, 5, 14}, {307, 671, 5, 14}, 
  {350, 671, 6, 14}, {387, 671, 4, 14}, {394, 671, 5, 14}, {515, 671, 4, 14}, 
  {92, 688, 5, 14}, {123, 688, 5, 14}, {149, 688, 5, 14}, {227, 688, 4, 14}, 
  {276, 688, 4, 14}, {332, 688, 4, 14}, {385, 688, 5, 14}, {435, 688, 5, 14}, 
  {454, 688, 5, 14}, {91, 704, 7, 14}, {198, 704, 4, 14}, {250, 704, 5, 14}, 
  {365, 704, 4, 14}, {416, 704, 5, 14}, {80, 721, 5, 14}, {223, 721, 5, 14}, 
  {228, 721, 5, 14}, {290, 721, 5, 14}, {319, 721, 5, 14}, {342, 721, 4, 14}, 
  {346, 721, 5, 14}, {382, 721, 5, 14}, {411, 721, 4, 14}, {437, 721, 5, 14}, 
  {68, 737, 5, 14}, {170, 737, 4, 14}, {257, 737, 5, 14}, {313, 737, 5, 14}, 
  {354, 737, 4, 14}, {429, 737, 4, 14}, {487, 737, 5, 14}, {56, 754, 7, 14}, 
  {69, 754, 5, 14}, {100, 754, 5, 14}, {105, 754, 5, 14}, {133, 754, 5, 14}, 
  {215, 754, 4, 14}, {237, 754, 5, 14}, {257, 754, 5, 14}, {319, 754, 5, 14}, 
  {462, 754, 5, 14}, {509, 754, 5, 14}, {180, 770, 4, 15}, {203, 770, 4, 15}, 
  {233, 770, 5, 15}, {252, 770, 5, 15}, {325, 770, 5, 15}, {333, 770, 5, 15}, 
  {385, 770, 5, 15}, {69, 57, 5, 14}, {138, 57, 5, 14}, {411, 57, 5, 14}, 
  {454, 57, 5, 14}, {111, 73, 5, 15}, {131, 73, 4, 15}, {171, 73, 5, 15}, 
  {211, 73, 5, 15}, {240, 73, 5, 15}, {306, 73, 5, 15}, {311, 73, 5, 15}, 
  {367, 73, 4, 15}, {396, 73, 4, 15}, {465, 73, 5, 15}, {86, 90, 4, 14}, 
  {93, 90, 5, 14}, {164, 90, 4, 14}, {271, 90, 5, 14}, {317, 90, 4, 14}, 
  {389, 90, 5, 14}, {418, 90, 4, 14}, {447, 90, 4, 14}, {520, 90, 4, 14}, 
  {190, 106, 5, 15}, {230, 106, 5, 15}, {259, 106, 5, 15}, {374, 106, 5, 15}, 
  {494, 106, 5, 15}, {502, 106, 5, 15}, {88, 123, 4, 14}, {112, 123, 5, 14}, 
  {144, 123, 5, 14}, {190, 123, 5, 14}, {249, 123, 5, 14}, {361, 123, 4, 14}, 
  {371, 123, 5, 14}, {94, 147, 5, 14}, {235, 147, 4, 14}, {265, 147, 5, 14}, 
  {320, 147, 5, 14}, {373, 147, 4, 14}, {377, 147, 5, 14}, {526, 147, 6, 14}, 
  {109, 163, 5, 14}, {213, 163, 5, 14}, {333, 163, 5, 14}, {385, 163, 5, 14}, 
  {396, 163, 5, 14}, {415, 163, 5, 14}, {95, 180, 5, 14}, {194, 180, 4, 14}, 
  {366, 180, 4, 14}, {397, 180, 5, 14}, {449, 180, 5, 14}, {484, 180, 5, 14}, 
  {495, 180, 4, 14}, {56, 196, 7, 14}, {69, 196, 5, 14}, {100, 196, 5, 14}, 
  {105, 196, 5, 14}, {181, 196, 5, 14}, {215, 196, 5, 14}, {226, 196, 5, 14}, 
  {269, 196, 5, 14}, {280, 196, 5, 14}, {303, 196, 4, 14}, {64, 213, 4, 14}, 
  {74, 213, 5, 14}, {82, 213, 5, 14}, {111, 213, 5, 14}, {262, 213, 4, 14}, 
  {266, 213, 5, 14}, {358, 213, 4, 14}, {400, 213, 5, 14}, {446, 213, 5, 14}, 
  {96, 229, 4, 14}, {115, 229, 4, 14}, {181, 229, 4, 14}, {215, 229, 5, 14}, 
  {223, 229, 4, 14}, {333, 229, 5, 14}, {516, 229, 6, 14}, {178, 246, 5, 14}, 
  {236, 246, 5, 14}, {311, 246, 5, 14}, {334, 246, 5, 14}, {201, 262, 5, 15}, 
  {251, 262, 4, 15}, {259, 262, 4, 15}, {303, 262, 5, 15}, {69, 286, 5, 14}, 
  {87, 286, 5, 14}, {98, 286, 5, 14}, {160, 286, 5, 14}, {201, 286, 4, 14}, 
  {296, 286, 5, 14}, {332, 286, 4, 14}, {363, 286, 5, 14}, {416, 286, 4, 14}, 
  {82, 302, 4, 15}, {120, 302, 4, 15}, {249, 302, 4, 15}, {299, 302, 5, 15}, 
  {310, 302, 4, 15}, {426, 302, 4, 15}, {434, 302, 4, 15}, {474, 302, 4, 15}, 
  {122, 319, 5, 14}, {127, 319, 4, 14}, {214, 319, 5, 14}, {240, 319, 5, 14}, 
  {337, 319, 5, 14}, {123, 336, 5, 14}, {134, 336, 5, 14}, {176, 336, 5, 14}, 
  {249, 336, 4, 14}, {311, 336, 5, 14}, {355, 336, 4, 14}, {456, 336, 5, 14}, 
  {156, 352, 4, 14}, {254, 352, 5, 14}, {259, 352, 5, 14}, {338, 376, 7, 14}, 
  {351, 376, 5, 14}, {382, 376, 5, 14}, {387, 376, 5, 14}, {423, 376, 5, 14}, 
  {493, 376, 5, 14}, {510, 376, 5, 14}, {253, 392, 5, 14}, {311, 392, 5, 14}, 
  {419, 392, 5, 14}, {424, 392, 4, 14}, {475, 392, 5, 14}, {504, 392, 5, 14}, 
  {108, 409, 5, 14}, {228, 409, 5, 14}, {326, 409, 5, 14}, {488, 409, 5, 14}, 
  {71, 425, 5, 15}, {76, 425, 4, 15}, {135, 425, 5, 15}, {143, 425, 4, 15}, 
  {174, 425, 5, 15}, {199, 425, 5, 15}, {236, 425, 4, 15}, {380, 425, 5, 15}, 
  {413, 425, 4, 15}, {421, 425, 4, 15}, {515, 425, 6, 15}, {96, 442, 4, 14}, 
  {192, 442, 5, 14}, {333, 442, 5, 14}, {388, 442, 5, 14}, {442, 442, 5, 14}, 
  {485, 442, 5, 14}, {524, 442, 6, 14}, {94, 482, 5, 14}, {123, 482, 5, 14}, 
  {159, 482, 5, 14}, {259, 482, 5, 14}, {402, 482, 5, 14}, {515, 482, 4, 14}, 
  {131, 499, 5, 14}, {136, 499, 4, 14}, {149, 499, 4, 14}, {206, 499, 4, 14}, 
  {303, 499, 5, 14}, {430, 499, 4, 14}, {437, 499, 5, 14}, {217, 515, 5, 14}, 
  {272, 515, 5, 14}, {292, 515, 6, 14}, {304, 515, 5, 14}, {336, 515, 4, 14}, 
  {340, 515, 5, 14}, {473, 515, 5, 14}, {484, 515, 5, 14}, {507, 515, 5, 14}, 
  {66, 532, 4, 14}, {317, 532, 5, 14}, {413, 532, 5, 14}, {445, 532, 4, 14}, 
  {490, 532, 5, 14}, {498, 532, 4, 14}, {56, 548, 5, 14}, {199, 548, 4, 14}, 
  {246, 548, 5, 14}, {268, 548, 5, 14}, {333, 548, 5, 14}, {341, 548, 5, 14}, 
  {488, 548, 5, 14}, {493, 548, 5, 14}, {142, 565, 4, 14}, {382, 565, 5, 14}, 
  {139, 581, 5, 14}, {56, 605, 7, 14}, {69, 605, 5, 14}, {100, 605, 5, 14}, 
  {105, 605, 5, 14}, {143, 605, 4, 14}, {151, 605, 4, 14}, {298, 605, 4, 14}, 
  {359, 605, 7, 14}, {372, 605, 4, 14}, {403, 605, 5, 14}, {408, 605, 4, 14}, 
  {482, 605, 4, 14}, {511, 605, 6, 14}, {90, 621, 5, 15}, {154, 621, 5, 15}, 
  {373, 621, 4, 15}, {482, 621, 5, 15}, {509, 621, 6, 15}, {120, 638, 5, 14}, 
  {137, 638, 5, 14}, {210, 638, 5, 14}, {379, 638, 5, 14}, {387, 638, 5, 14}, 
  {489, 638, 5, 14}, {68, 654, 4, 15}, {172, 654, 5, 15}, {238, 654, 4, 15}, 
  {287, 654, 4, 15}, {379, 654, 5, 15}, {429, 654, 5, 15}, {56, 671, 5, 14}, 
  {81, 671, 4, 14}, {121, 671, 4, 14}, {134, 671, 5, 14}, {199, 671, 5, 14}, 
  {231, 671, 5, 14}, {353, 671, 5, 14}, {409, 671, 6, 14}, {421, 671, 5, 14}, 
  {453, 671, 4, 14}, {457, 671, 5, 14}, {470, 671, 5, 14}, {481, 671, 5, 14}, 
  {519, 671, 5, 14}, {122, 688, 5, 14}, {225, 688, 5, 14}, {298, 688, 5, 14}, 
  {306, 688, 5, 14}, {348, 688, 5, 14}, {361, 688, 5, 14}, {413, 688, 5, 14}, 
  {456, 688, 5, 14}, {488, 688, 4, 14}, {175, 704, 5, 14}, {206, 704, 5, 14}, 
  {293, 704, 5, 14}, {308, 704, 5, 14}, {319, 704, 5, 14}, {413, 704, 4, 14}, 
  {423, 704, 5, 14}, {246, 721, 5, 14}, {305, 721, 5, 14}, {316, 721, 4, 14}, 
  {393, 721, 5, 14}, {404, 721, 6, 14}, {450, 721, 5, 14}, {527, 721, 5, 14}, 
  {110, 744, 4, 14}, {120, 744, 5, 14}, {128, 744, 5, 14}, {171, 744, 5, 14}, 
  {179, 744, 4, 14}, {189, 744, 5, 14}, {402, 744, 5, 14}, {410, 744, 4, 14}, 
  {502, 744, 4, 14}, {513, 744, 4, 14}, {74, 761, 4, 14}, {87, 761, 4, 14}, 
  {122, 761, 4, 14}, {150, 761, 4, 14}, {277, 761, 5, 14}, {285, 761, 5, 14}, 
  {377, 761, 4, 14}, {410, 761, 4, 14}, {85, 57, 5, 14}, {103, 57, 5, 14}, 
  {114, 57, 4, 14}, {225, 57, 4, 14}, {235, 57, 5, 14}, {373, 57, 4, 14}, 
  {413, 57, 4, 14}, {69, 73, 5, 15}, {162, 73, 5, 15}, {167, 73, 4, 15}, 
  {211, 73, 5, 15}, {222, 73, 4, 15}, {239, 73, 4, 15}, {302, 73, 5, 15}, 
  {360, 73, 5, 15}, {391, 73, 5, 15}, {408, 73, 5, 15}, {498, 73, 5, 15}, 
  {204, 90, 4, 14}, {246, 90, 5, 14}, {303, 90, 4, 14}, {333, 90, 5, 14}, 
  {511, 90, 5, 14}, {519, 90, 4, 14}, {72, 106, 4, 15}, {124, 106, 4, 15}, 
  {276, 106, 5, 15}, {313, 106, 7, 15}, {326, 106, 4, 15}, {357, 106, 5, 15}, 
  {362, 106, 4, 15}, {407, 106, 5, 15}, {415, 106, 5, 15}, {426, 106, 4, 15}, 
  {142, 123, 5, 14}, {150, 123, 5, 14}, {210, 123, 5, 14}, {303, 123, 5, 14}, 
  {351, 123, 5, 14}, {374, 123, 5, 14}, {505, 123, 5, 14}, {93, 140, 5, 14}, 
  {233, 140, 5, 14}, {294, 140, 5, 14}, {326, 140, 4, 14}, {393, 140, 5, 14}, 
  {416, 140, 4, 14}, {420, 140, 5, 14}, {530, 140, 6, 14}, {56, 156, 5, 14}, 
  {160, 180, 5, 14}, {273, 180, 5, 14}, {388, 180, 4, 14}, {474, 180, 5, 14}, 
  {510, 180, 5, 14}, {66, 196, 4, 14}, {127, 196, 4, 14}, {188, 196, 5, 14}, 
  {290, 196, 5, 14}, {377, 196, 5, 14}, {382, 196, 4, 14}, {460, 196, 4, 14}, 
  {512, 196, 5, 14}, {105, 213, 4, 14}, {210, 213, 5, 14}, {332, 213, 5, 14}, 
  {368, 213, 4, 14}, {409, 213, 4, 14}, {462, 213, 5, 14}, {500, 213, 4, 14}, 
  {510, 213, 5, 14}, {161, 229, 4, 14}, {245, 253, 5, 14}, {412, 253, 4, 14}, 
  {72, 269, 4, 15}, {82, 269, 5, 15}, {205, 269, 5, 15}, {280, 269, 5, 15}, 
  {321, 269, 5, 15}, {329, 269, 5, 15}, {374, 269, 5, 15}, {453, 269, 5, 15}, 
  {133, 286, 4, 14}, {192, 286, 5, 14}, {211, 286, 4, 14}, {240, 286, 5, 14}, 
  {445, 286, 5, 14}, {521, 286, 6, 14}, {56, 302, 5, 15}, {180, 302, 4, 15}, 
  {103, 326, 5, 14}, {114, 326, 5, 14}, {278, 326, 5, 14}, {330, 326, 5, 14}, 
  {376, 326, 5, 14}, {444, 326, 4, 14}, {217, 343, 5, 14}, {354, 343, 5, 14}, 
  {362, 343, 5, 14}, {123, 359, 4, 14}, {154, 359, 4, 14}, {176, 359, 5, 14}, 
  {205, 359, 5, 14}, {253, 359, 4, 14}, {455, 359, 5, 14}, {94, 376, 5, 14}, 
  {135, 376, 4, 14}, {204, 376, 5, 14}, {218, 376, 5, 14}, {249, 376, 5, 14}, 
  {349, 376, 5, 14}, {380, 376, 4, 14}, {519, 376, 5, 14}, {138, 399, 5, 14}, 
  {192, 399, 5, 14}, {246, 399, 5, 14}, {295, 399, 5, 14}, {351, 399, 5, 14}, 
  {391, 399, 4, 14}, {167, 416, 5, 14}, {216, 416, 5, 14}, {255, 416, 5, 14}, 
  {280, 416, 5, 14}, {399, 416, 5, 14}, {435, 416, 4, 14}, {443, 416, 4, 14}, 
  {450, 416, 5, 14}, {505, 416, 5, 14}, {528, 416, 5, 14}, {98, 432, 5, 15}, 
  {127, 432, 5, 15}, {206, 432, 4, 15}, {216, 432, 5, 15}, {342, 432, 5, 15}, 
  {433, 432, 5, 15}, {458, 432, 5, 15}, {490, 432, 4, 15}, {117, 449, 4, 14}, 
  {181, 449, 5, 14}, {314, 449, 5, 14}, {346, 449, 4, 14}, {353, 449, 5, 14}, 
  {72, 465, 4, 15}, {82, 465, 5, 15}, {123, 465, 5, 15}, {153, 465, 4, 15}, 
  {213, 465, 5, 15}, {244, 465, 5, 15}, {56, 489, 7, 14}, {69, 489, 5, 14}, 
  {100, 489, 5, 14}, {105, 489, 5, 14}, {216, 489, 4, 14}, {326, 489, 5, 14}, 
  {351, 489, 5, 14}, {364, 489, 5, 14}, {387, 489, 5, 14}, {491, 489, 5, 14}, 
  {273, 506, 5, 14}, {284, 506, 5, 14}, {332, 506, 5, 14}, {532, 506, 6, 14}, 
  {64, 522, 4, 14}, {74, 522, 5, 14}, {133, 522, 4, 14}, {150, 522, 4, 14}, 
  {161, 522, 4, 14}, {413, 522, 5, 14}, {475, 522, 5, 14}, {521, 522, 5, 14}, 
  {97, 539, 5, 14}, {183, 539, 5, 14}, {286, 539, 4, 14}, {423, 539, 5, 14}, 
  {471, 539, 4, 14}, {522, 539, 6, 14}, {76, 555, 5, 14}, {56, 579, 7, 14}, 
  {215, 579, 7, 14}, {267, 579, 5, 14}, {291, 579, 5, 14}, {304, 579, 5, 14}, 
  {321, 579, 5, 14}, {418, 579, 5, 14}, {466, 579, 5, 14}, {169, 595, 4, 14}, 
  {243, 595, 5, 14}, {265, 595, 5, 14}, {339, 595, 5, 14}, {394, 595, 5, 14}, 
  {435, 595, 4, 14}, {464, 595, 5, 14}, {518, 595, 5, 14}, {104, 612, 5, 14}, 
  {250, 612, 4, 14}, {317, 612, 5, 14}, {477, 612, 5, 14}, {500, 612, 5, 14}, 
  {87, 628, 5, 15}, {98, 628, 4, 15}, {150, 628, 5, 15}, {165, 628, 5, 15}, 
  {176, 628, 4, 15}, {434, 628, 5, 15}, {451, 628, 5, 15}, {468, 628, 5, 15}, 
  {127, 645, 5, 14}, {304, 645, 5, 14}, {378, 645, 5, 14}, {427, 645, 5, 14}, 
  {523, 645, 5, 14}, {115, 661, 5, 15}, {148, 661, 5, 15}, {204, 661, 4, 15}, 
  {256, 661, 5, 15}, {303, 661, 5, 15}, {424, 661, 5, 15}, {435, 661, 4, 15}, 
  {497, 661, 5, 15}, {505, 661, 4, 15}, {92, 678, 5, 14}, {139, 702, 5, 14}, 
  {201, 702, 4, 14}, {221, 702, 4, 14}, {297, 702, 5, 14}, {380, 702, 5, 14}, 
  {515, 702, 6, 14}, {194, 718, 5, 14}, {276, 718, 5, 14}, {287, 718, 4, 14}, 
  {380, 718, 4, 14}, {458, 718, 4, 14}, {141, 735, 5, 14}, {205, 735, 5, 14}, 
  {235, 735, 4, 14}, {278, 735, 5, 14}, {301, 735, 5, 14}, {360, 735, 4, 14}, 
  {370, 735, 5, 14}, {429, 735, 5, 14}, {74, 751, 4, 14}, {154, 751, 4, 14}, 
  {266, 751, 4, 14}, {338, 751, 5, 14}, {407, 751, 5, 14}, {467, 751, 5, 14}, 
  {149, 768, 4, 14}, {174, 768, 4, 14}, {327, 768, 5, 14}, {373, 768, 5, 14}, 
  {384, 768, 6, 14}, {396, 768, 5, 14}, {428, 768, 4, 14}, {432, 768, 5, 14}, 
  {502, 768, 4, 14}, {509, 768, 5, 14}, {191, 57, 4, 14}, {195, 57, 5, 14}, 
  {291, 57, 4, 14}, {298, 57, 5, 14}, {346, 57, 4, 14}, {356, 57, 5, 14}, 
  {364, 57, 5, 14}, {419, 57, 4, 14}, {448, 57, 5, 14}, {508, 57, 6, 14}, 
  {147, 73, 5, 15}, {324, 73, 5, 15}, {343, 73, 4, 15}, {435, 73, 5, 15}, 
  {496, 73, 5, 15}, {524, 73, 6, 15}, {135, 90, 5, 14}, {192, 90, 5, 14}, 
  {224, 90, 5, 14}, {253, 90, 5, 14}, {316, 90, 5, 14}, {69, 113, 5, 15}, 
  {339, 113, 5, 15}, {406, 113, 5, 15}, {149, 130, 4, 14}, {355, 130, 5, 14}, 
  {383, 130, 5, 14}, {406, 130, 5, 14}, {94, 147, 5, 14}, {129, 147, 4, 14}, 
  {196, 147, 4, 14}, {219, 147, 5, 14}, {353, 147, 4, 14}, {375, 147, 5, 14}, 
  {392, 147, 5, 14}, {451, 147, 5, 14}, {90, 163, 4, 14}, {122, 163, 5, 14}, 
  {130, 163, 5, 14}, {147, 163, 5, 14}, {196, 163, 5, 14}, {219, 163, 5, 14}, 
  {236, 163, 5, 14}, {317, 163, 4, 14}, {321, 163, 5, 14}, {422, 163, 5, 14}, 
  {179, 180, 4, 14}, {315, 180, 5, 14}, {403, 180, 4, 14}, {462, 180, 5, 14}, 
  {467, 180, 5, 14}, {480, 180, 5, 14}, {526, 180, 4, 14}, {83, 196, 4, 14}, 
  {156, 196, 4, 14}, {233, 196, 5, 14}, {94, 220, 5, 14}, {238, 220, 5, 14}, 
  {305, 220, 5, 14}, {335, 220, 4, 14}, {389, 220, 4, 14}, {434, 220, 5, 14}, 
  {491, 220, 5, 14}, {508, 220, 5, 14}, {117, 236, 5, 14}, {215, 236, 5, 14}, 
  {406, 236, 5, 14}, {96, 253, 4, 14}, {291, 253, 5, 14}, {350, 253, 5, 14}, 
  {396, 253, 5, 14}, {424, 253, 5, 14}, {193, 269, 5, 15}, {281, 269, 5, 15}, 
  {375, 269, 5, 15}, {429, 269, 5, 15}, {95, 286, 5, 14}, {112, 286, 5, 14}, 
  {157, 286, 5, 14}, {267, 286, 5, 14}, {367, 286, 5, 14}, {420, 286, 4, 14}, 
  {466, 286, 5, 14}, {507, 286, 5, 14}, {71, 302, 5, 15}, {199, 302, 5, 15}, 
  {373, 302, 5, 15}, {428, 302, 5, 15}, {480, 302, 5, 15}, {491, 302, 6, 15}, 
  {97, 319, 5, 14}, {179, 319, 5, 14}, {296, 319, 5, 14}, {371, 319, 4, 14}, 
  {427, 319, 5, 14}, {484, 319, 5, 14}, {498, 319, 4, 14}, {505, 319, 5, 14}, 
  {81, 336, 5, 14}, {92, 336, 6, 14}, {132, 359, 5, 14}, {214, 359, 5, 14}, 
  {258, 359, 5, 14}, {263, 359, 4, 14}, {492, 359, 5, 14}, {64, 376, 4, 14}, 
  {74, 376, 5, 14}, {128, 376, 5, 14}, {151, 376, 5, 14}, {417, 376, 5, 14}, 
  {440, 376, 5, 14}, {457, 376, 5, 14}, {499, 376, 6, 14}, {154, 392, 4, 14}, 
  {230, 392, 5, 14}, {334, 392, 4, 14}, {445, 392, 5, 14}, {492, 392, 4, 14}, 
  {114, 409, 4, 14}, {160, 409, 4, 14}, {280, 409, 5, 14}, {288, 409, 5, 14}, 
  {372, 409, 5, 14}, {449, 409, 4, 14}, {462, 409, 5, 14}, {83, 425, 5, 15}, 
  {177, 425, 7, 15}, {190, 425, 4, 15}, {221, 425, 5, 15}, {226, 425, 4, 15}, 
  {312, 425, 5, 15}, {467, 425, 5, 15}, {513, 425, 6, 15}, {97, 442, 5, 14}, 
  {105, 442, 4, 14}, {168, 442, 4, 14}, {255, 442, 5, 14}, {336, 442, 5, 14}, 
  {397, 442, 5, 14}, {86, 458, 4, 15}, {114, 458, 5, 15}, {301, 458, 4, 15}, 
  {382, 458, 5, 15}, {403, 458, 4, 15}, {440, 458, 5, 15}, {518, 458, 6, 15}, 
  {74, 475, 4, 14}, {196, 475, 5, 14}, {331, 475, 4, 14}, {510, 475, 5, 14}, 
  {103, 499, 4, 14}, {146, 499, 4, 14}, {286, 499, 5, 14}, {334, 499, 5, 14}, 
  {459, 499, 5, 14}, {113, 515, 4, 14}, {154, 515, 4, 14}, {204, 515, 5, 14}, 
  {209, 515, 5, 14}, {297, 515, 5, 14}, {345, 515, 5, 14}, {80, 532, 4, 14}, 
  {156, 532, 5, 14}, {204, 532, 5, 14}, {218, 532, 5, 14}, {337, 532, 5, 14}, 
  {382, 532, 5, 14}, {411, 532, 5, 14}, {100, 548, 4, 14}, {256, 548, 5, 14}, 
  {264, 548, 4, 14}, {295, 548, 4, 14}, {329, 548, 5, 14}, {78, 572, 4, 14}, 
  {100, 572, 5, 14}, {205, 572, 4, 14}, {242, 572, 5, 14}, {253, 572, 4, 14}, 
  {270, 572, 4, 14}, {308, 572, 5, 14}, {456, 572, 5, 14}, {461, 572, 4, 14}, 
  {90, 588, 4, 14}, {176, 588, 4, 14}, {217, 588, 5, 14}, {294, 588, 4, 14}, 
  {331, 588, 5, 14}, {405, 588, 5, 14}, {468, 588, 5, 14}, {476, 588, 5, 14}, 
  {134, 605, 5, 14}, {384, 605, 5, 14}, {448, 605, 4, 14}, {471, 605, 4, 14}, 
  {152, 621, 5, 15}, {180, 621, 5, 15}, {250, 621, 5, 15}, {258, 621, 5, 15}, 
  {467, 621, 5, 15}, {487, 621, 4, 15}, {522, 621, 5, 15}, {533, 621, 6, 15}, 
  {72, 638, 5, 14}, {101, 638, 4, 14}, {178, 638, 4, 14}, {185, 638, 5, 14}, 
  {196, 638, 5, 14}, {56, 661, 7, 15}, {98, 661, 5, 15}, {133, 661, 5, 15}, 
  {303, 661, 4, 15}, {409, 661, 5, 15}, {432, 661, 4, 15}, {524, 661, 5, 15}, 
  {137, 678, 5, 14}, {307, 678, 5, 14}, {443, 678, 4, 14}, {78, 695, 4, 14}, 
  {148, 695, 4, 14}, {195, 695, 4, 14}, {291, 695, 5, 14}, {319, 695, 5, 14}, 
  {425, 695, 4, 14}, {479, 695, 4, 14}, {86, 711, 5, 14}, {151, 711, 5, 14}, 
  {174, 711, 5, 14}, {253, 711, 5, 14}, {307, 711, 5, 14}, {343, 711, 5, 14}, 
  {366, 711, 4, 14}, {427, 711, 5, 14}, {470, 711, 4, 14}, {110, 728, 4, 14}, 
  {244, 728, 5, 14}, {341, 728, 5, 14}, {346, 728, 5, 14}, {497, 728, 5, 14}, 
  {127, 744, 5, 14}, {228, 744, 5, 14}, {242, 744, 4, 14}, {290, 744, 5, 14}, 
  {313, 744, 5, 14}, {500, 744, 5, 14}, {102, 761, 4, 14}, {124, 761, 5, 14}, 
  {199, 761, 4, 14}, {239, 761, 5, 14}, {314, 761, 4, 14}, {420, 761, 4, 14}, 
  {451, 761, 4, 14}, {491, 761, 5, 14}, {126, 57, 5, 14}, {137, 57, 6, 14}, 
  {318, 57, 5, 14}, {381, 57, 5, 14}, {400, 57, 4, 14}, {474, 57, 4, 14}, 
  {505, 57, 5, 14}, {81, 73, 4, 15}, {103, 73, 5, 15}, {167, 73, 5, 15}, 
  {216, 73, 5, 15}, {266, 73, 5, 15}, {311, 73, 5, 15}, {385, 73, 4, 15}, 
  {105, 97, 5, 14}, {195, 97, 5, 14}, {244, 97, 5, 14}, {262, 97, 4, 14}, 
  {349, 97, 4, 14}, {371, 97, 4, 14}, {440, 97, 4, 14}, {463, 97, 4, 14}, 
  {96, 113, 4, 15}, {237, 113, 5, 15}, {422, 113, 5, 15}, {430, 113, 5, 15}, 
  {90, 130, 5, 14}, {150, 130, 5, 14}, {186, 130, 4, 14}, {241, 130, 5, 14}, 
  {430, 130, 4, 14}, {507, 130, 5, 14}, {82, 147, 5, 14}, {138, 147, 5, 14}, 
  {192, 147, 4, 14}, {242, 147, 4, 14}, {261, 147, 5, 14}, {377, 147, 4, 14}, 
  {381, 147, 5, 14}, {448, 147, 5, 14}, {474, 147, 4, 14}, {171, 163, 4, 14}, 
  {247, 163, 5, 14}, {302, 163, 5, 14}, {361, 163, 5, 14}, {457, 163, 5, 14}, 
  {505, 163, 4, 14}, {81, 180, 5, 14}, {98, 180, 5, 14}, {121, 180, 5, 14}, 
  {176, 180, 5, 14}, {201, 180, 5, 14}, {287, 180, 5, 14}, {482, 180, 6, 14}, 
  {503, 180, 4, 14}, {533, 180, 6, 14}, {132, 196, 4, 14}, {142, 196, 5, 14}, 
  {243, 196, 5, 14}, {365, 196, 5, 14}, {431, 196, 5, 14}, {449, 196, 5, 14}, 
  {349, 213, 5, 14}, {380, 213, 5, 14}, {393, 213, 5, 14}, {178, 229, 4, 14}, 
  {201, 229, 4, 14}, {211, 229, 5, 14}, {300, 229, 5, 14}, {380, 229, 4, 14}, 
  {140, 246, 5, 14}, {250, 269, 4, 15}, {412, 269, 4, 15}, {84, 286, 5, 14}, 
  {133, 286, 4, 14}, {187, 286, 5, 14}, {253, 286, 5, 14}, {264, 286, 5, 14}, 
  {293, 286, 5, 14}, {315, 286, 5, 14}, {420, 286, 5, 14}, {518, 286, 5, 14}, 
  {523, 286, 4, 14}, {64, 302, 4, 15}, {74, 302, 5, 15}, {107, 302, 4, 15}, 
  {115, 302, 4, 15}, {150, 302, 4, 15}, {239, 302, 5, 15}, {269, 302, 4, 15}, 
  {286, 302, 4, 15}, {324, 302, 5, 15}, {335, 302, 7, 15}, {348, 302, 4, 15}, 
  {379, 302, 5, 15}, {384, 302, 4, 15}, {421, 302, 4, 15}, {448, 302, 5, 15}, 
  {456, 302, 5, 15}, {56, 319, 5, 14}, {131, 319, 4, 14}, {185, 319, 5, 14}, 
  {208, 319, 5, 14}, {239, 319, 5, 14}, {337, 319, 4, 14}, {359, 319, 5, 14}, 
  {396, 319, 4, 14}, {67, 336, 5, 14}, {130, 336, 4, 14}, {206, 336, 4, 14}, 
  {240, 336, 4, 14}, {254, 336, 4, 14}, {372, 336, 4, 14}, {402, 336, 5, 14}, 
  {450, 336, 5, 14}, {494, 336, 5, 14}, {511, 336, 5, 14}, {270, 352, 5, 14}, 
  {339, 352, 5, 14}, {383, 352, 4, 14}, {418, 352, 5, 14}, {474, 352, 5, 14}, 
  {108, 369, 5, 14}, {131, 369, 5, 14}, {184, 392, 5, 14}, {215, 392, 5, 14}, 
  {240, 392, 5, 14}, {269, 392, 5, 14}, {293, 392, 4, 14}, {56, 409, 5, 14}, 
  {181, 409, 5, 14}, {302, 409, 5, 14}, {422, 409, 5, 14}, {433, 409, 7, 14}, 
  {87, 425, 5, 15}, {164, 425, 5, 15}, {184, 425, 5, 15}, {250, 425, 5, 15}, 
  {366, 425, 4, 15}, {458, 425, 5, 15}, {64, 442, 4, 14}, {74, 442, 5, 14}, 
  {91, 442, 5, 14}, {127, 442, 4, 14}, {172, 442, 5, 14}, {207, 442, 4, 14}, 
  {389, 442, 5, 14}, {150, 458, 5, 15}, {161, 458, 7, 15}, {174, 458, 4, 15}, 
  {205, 458, 5, 15}, {210, 458, 4, 15}, {258, 458, 5, 15}, {329, 458, 5, 15}, 
  {445, 458, 5, 15}, {477, 458, 4, 15}, {511, 458, 6, 15}, {101, 475, 7, 14}, 
  {122, 475, 5, 14}, {153, 475, 4, 14}, {214, 475, 5, 14}, {225, 475, 4, 14}, 
  {312, 475, 5, 14}, {348, 475, 4, 14}, {356, 475, 4, 14}, {475, 475, 5, 14}, 
  {132, 492, 5, 14}, {140, 492, 5, 14}, {200, 492, 7, 14}, {278, 492, 5, 14}, 
  {323, 492, 5, 14}, {376, 508, 5, 14}, {425, 508, 5, 14}, {449, 508, 5, 14}, 
  {457, 508, 4, 14}, {485, 508, 4, 14}, {117, 548, 5, 14}, {190, 548, 5, 14}, 
  {220, 548, 4, 14}, {289, 548, 5, 14}, {324, 548, 7, 14}, {337, 548, 4, 14}, 
  {368, 548, 5, 14}, {373, 548, 4, 14}, {56, 565, 5, 14}, {125, 565, 4, 14}, 
  {214, 565, 5, 14}, {331, 565, 5, 14}, {357, 565, 4, 14}, {394, 565, 5, 14}, 
  {121, 581, 5, 14}, {201, 581, 5, 14}, {299, 581, 5, 14}, {362, 581, 5, 14}, 
  {419, 581, 5, 14}, {468, 581, 5, 14}, {491, 581, 5, 14}, {112, 598, 5, 14}, 
  {223, 598, 5, 14}, {257, 598, 6, 14}, {324, 598, 4, 14}, {328, 598, 5, 14}, 
  {386, 598, 5, 14}, {434, 598, 5, 14}, {490, 598, 4, 14}, {100, 614, 5, 15}, 
  {191, 614, 4, 15}, {262, 614, 5, 15}, {86, 638, 4, 14}, {125, 638, 5, 14}, 
  {172, 638, 5, 14}, {254, 638, 5, 14}, {375, 638, 5, 14}, {423, 638, 4, 14}, 
  {56, 654, 5, 15}, {184, 654, 5, 15}, {363, 654, 4, 15}, {153, 671, 5, 14}, 
  {176, 671, 5, 14}, {400, 671, 5, 14}, {423, 671, 5, 14}, {495, 671, 5, 14}, 
  {105, 688, 4, 14}, {116, 688, 4, 14}, {175, 688, 4, 14}, {185, 688, 5, 14}, 
  {268, 688, 5, 14}, {303, 688, 5, 14}, {329, 688, 5, 14}, {340, 688, 5, 14}, 
  {365, 688, 5, 14}, {119, 704, 4, 14}, {158, 704, 5, 14}, {351, 704, 5, 14}, 
  {412, 704, 5, 14}, {499, 704, 4, 14}, {81, 721, 5, 14}, {116, 721, 5, 14}, 
  {266, 721, 5, 14}, {343, 721, 4, 14}, {389, 721, 5, 14}, {443, 721, 5, 14}, 
  {480, 721, 5, 14}, {485, 721, 4, 14}, {513, 721, 5, 14}, {71, 737, 5, 14}, 
  {124, 737, 5, 14}, {160, 737, 4, 14}, {210, 737, 5, 14}, {227, 737, 5, 14}, 
  {326, 737, 5, 14}, {334, 737, 5, 14}, {365, 737, 5, 14}, {450, 737, 5, 14}, 
  {481, 737, 5, 14}, {512, 737, 6, 14}, {88, 754, 5, 14}, {184, 754, 4, 14}, 
  {250, 754, 4, 14}, {295, 754, 5, 14}, {360, 754, 4, 14}, {364, 754, 5, 14}, 
  {437, 754, 5, 14}, {123, 57, 5, 14}, {172, 57, 4, 14}, {201, 57, 5, 14}, 
  {248, 57, 5, 14}, {313, 57, 5, 14}, {457, 57, 5, 14}, {158, 73, 4, 15}, 
  {317, 73, 5, 15}, {369, 73, 5, 15}, {71, 90, 5, 14}, {76, 90, 4, 14}, 
  {113, 90, 4, 14}, {250, 90, 5, 14}, {345, 90, 5, 14}, {464, 90, 5, 14}, 
  {69, 106, 5, 15}, {126, 106, 5, 15}, {240, 106, 5, 15}, {251, 106, 5, 15}, 
  {374, 106, 5, 15}, {406, 106, 4, 15}, {441, 106, 5, 15}, {76, 123, 5, 14}, 
  {126, 123, 5, 14}, {131, 123, 4, 14}, {179, 123, 5, 14}, {239, 123, 5, 14}, 
  {250, 123, 5, 14}, {258, 123, 4, 14}, {344, 123, 5, 14}, {399, 123, 5, 14}, 
  {451, 123, 4, 14}, {74, 140, 4, 14}, {138, 140, 5, 14}, {205, 140, 5, 14}, 
  {301, 140, 5, 14}, {351, 140, 4, 14}, {420, 140, 5, 14}, {484, 140, 5, 14}, 
  {489, 140, 5, 14}, {71, 156, 5, 14}, {137, 156, 5, 14}, {145, 156, 5, 14}, 
  {180, 156, 5, 14}, {238, 156, 5, 14}, {284, 156, 5, 14}, {307, 156, 4, 14}, 
  {343, 156, 5, 14}, {442, 156, 5, 14}, {67, 173, 5, 14}, {99, 173, 4, 14}, 
  {135, 173, 4, 14}, {175, 173, 4, 14}, {217, 173, 5, 14}, {271, 173, 5, 14}, 
  {315, 173, 5, 14}, {340, 173, 4, 14}, {353, 173, 5, 14}, {56, 196, 7, 14}, 
  {69, 196, 5, 14}, {100, 196, 5, 14}, {105, 196, 5, 14}, {141, 196, 5, 14}, 
  {201, 196, 5, 14}, {289, 196, 5, 14}, {430, 196, 4, 14}, {440, 196, 5, 14}, 
  {482, 196, 5, 14}, {142, 213, 5, 14}, {153, 213, 5, 14}, {252, 213, 5, 14}, 
  {349, 213, 4, 14}, {447, 213, 4, 14}, {470, 213, 5, 14}, {522, 213, 6, 14}, 
  {285, 229, 5, 14}, {307, 229, 5, 14}, {398, 229, 4, 14}, {470, 229, 5, 14}, 
  {186, 246, 5, 14}, {303, 246, 5, 14}, {348, 246, 5, 14}, {412, 246, 5, 14}, 
  {462, 246, 4, 14}, {484, 246, 5, 14}, {507, 246, 6, 14}, {184, 262, 4, 15}, 
  {194, 262, 5, 15}, {217, 262, 5, 15}, {228, 262, 5, 15}, {258, 262, 5, 15}, 
  {286, 262, 5, 15}, {326, 262, 5, 15}, {349, 262, 5, 15}, {360, 262, 4, 15}, 
  {424, 262, 4, 15}, {428, 262, 5, 15}, {491, 262, 5, 15}, {100, 279, 4, 14}, 
  {140, 279, 5, 14}, {244, 279, 5, 14}, {305, 279, 5, 14}, {346, 279, 5, 14}, 
  {441, 279, 5, 14}, {512, 279, 5, 14}, {149, 295, 4, 15}, {183, 295, 4, 15}, 
  {248, 295, 4, 15}, {299, 295, 5, 15}, {371, 295, 5, 15}, {466, 295, 5, 15}, 
  {84, 312, 5, 14}, {128, 312, 4, 14}, {257, 312, 5, 14}, {326, 312, 5, 14}, 
  {358, 312, 5, 14}, {421, 312, 5, 14}, {511, 312, 6, 14}, {81, 329, 5, 14}, 
  {86, 329, 4, 14}, {160, 352, 4, 14}, {208, 352, 5, 14}, {340, 352, 5, 14}, 
  {445, 352, 5, 14}, {94, 369, 5, 14}, {212, 369, 5, 14}, {258, 369, 5, 14}, 
  {268, 369, 5, 14}, {343, 369, 4, 14}, {56, 385, 5, 14}, {86, 385, 4, 14}, 
  {109, 385, 4, 14}, {119, 385, 5, 14}, {183, 385, 5, 14}, {212, 385, 4, 14}, 
  {234, 385, 5, 14}, {257, 385, 5, 14}, {118, 402, 5, 14}, {191, 402, 5, 14}, 
  {228, 402, 5, 14}, {266, 402, 5, 14}, {392, 402, 5, 14}, {98, 418, 5, 15}, 
  {302, 435, 5, 14}, {430, 435, 4, 14}, {444, 435, 4, 14}, {475, 435, 5, 14}, 
  {79, 451, 5, 15}, {108, 451, 5, 15}, {141, 451, 4, 15}, {149, 451, 4, 15}, 
  {172, 451, 4, 15}, {74, 475, 4, 14}, {120, 475, 5, 14}, {251, 475, 5, 14}, 
  {312, 475, 5, 14}, {445, 475, 5, 14}, {103, 492, 5, 14}, {108, 492, 4, 14}, 
  {175, 492, 4, 14}, {200, 492, 5, 14}, {376, 492, 5, 14}, {453, 492, 5, 14}, 
  {508, 492, 4, 14}, {144, 508, 5, 14}, {236, 508, 4, 14}, {253, 508, 4, 14}, 
  {285, 508, 5, 14}, {296, 508, 4, 14}, {356, 508, 5, 14}, {463, 508, 5, 14}, 
  {150, 525, 4, 14}, {206, 525, 5, 14}, {347, 525, 4, 14}, {470, 525, 5, 14}, 
  {128, 541, 5, 14}, {191, 541, 5, 14}, {246, 541, 4, 14}, {275, 541, 5, 14}, 
  {283, 541, 4, 14}, {510, 541, 5, 14}, {85, 558, 4, 14}, {146, 558, 4, 14}, 
  {210, 558, 5, 14}, {118, 574, 5, 14}, {123, 574, 4, 14}, {168, 574, 4, 14}, 
  {176, 574, 4, 14}, {191, 574, 4, 14}, {201, 574, 5, 14}, {212, 574, 5, 14}, 
  {379, 574, 4, 14}, {402, 574, 5, 14}, {420, 574, 5, 14}, {451, 574, 5, 14}, 
  {478, 574, 4, 14}, {243, 591, 4, 14}, {272, 591, 4, 14}, {358, 591, 5, 14}, 
  {405, 591, 5, 14}, {437, 591, 5, 14}, {82, 614, 5, 15}, {124, 614, 5, 15}, 
  {156, 614, 5, 15}, {346, 614, 4, 15}, {368, 614, 5, 15}, {373, 614, 4, 15}, 
  {109, 631, 5, 14}, {135, 631, 5, 14}, {412, 631, 5, 14}, {131, 647, 5, 15}, 
  {175, 647, 5, 15}, {247, 647, 5, 15}, {324, 647, 5, 15}, {355, 647, 5, 15}, 
  {426, 647, 5, 15}, {439, 647, 5, 15}, {470, 647, 4, 15}, {481, 647, 6, 15}, 
  {68, 664, 4, 14}, {145, 664, 5, 14}, {405, 664, 4, 14}, {428, 664, 4, 14}, 
  {435, 664, 5, 14}, {466, 664, 5, 14}, {516, 664, 4, 14}, {56, 681, 5, 14}, 
  {211, 681, 5, 14}, {250, 681, 5, 14}, {302, 681, 4, 14}, {351, 681, 4, 14}, 
  {467, 681, 5, 14}, {490, 681, 6, 14}, {95, 697, 5, 14}, {204, 697, 7, 14}, 
  {281, 697, 5, 14}, {366, 697, 5, 14}, {74, 721, 5, 14}, {134, 721, 5, 14}, 
  {198, 721, 5, 14}, {247, 721, 5, 14}, {302, 721, 5, 14}, {374, 721, 4, 14}, 
  {133, 737, 5, 14}, {188, 737, 5, 14}, {258, 737, 5, 14}, {300, 737, 5, 14}, 
  {330, 737, 5, 14}, {379, 737, 5, 14}, {390, 737, 5, 14}, {500, 737, 4, 14}, 
  {224, 754, 5, 14}, {326, 754, 4, 14}, {398, 754, 4, 14}, {109, 770, 5, 15}, 
  {176, 770, 4, 15}, {195, 770, 4, 15}, {238, 770, 4, 15}, {296, 770, 5, 15}, 
  {339, 770, 5, 15}, {442, 770, 5, 15}, {447, 770, 5, 15}, {525, 770, 5, 15}, 
  {100, 57, 4, 14}, {215, 57, 4, 14}, {248, 57, 5, 14}, {263, 57, 5, 14}, 
  {274, 57, 5, 14}, {301, 57, 5, 14}, {314, 57, 5, 14}, {322, 57, 5, 14}, 
  {353, 57, 5, 14}, {389, 57, 5, 14}, {481, 57, 5, 14}, {104, 73, 5, 15}, 
  {420, 73, 4, 15}, {451, 73, 5, 15}, {97, 90, 5, 14}, {114, 90, 5, 14}, 
  {431, 90, 6, 14}, {443, 90, 5, 14}, {475, 90, 4, 14}, {479, 90, 5, 14}, 
  {532, 90, 5, 14}, {88, 106, 5, 15}, {130, 106, 5, 15}, {141, 106, 6, 15}, 
  {385, 106, 4, 15}, {443, 106, 5, 15}, {462, 106, 4, 15}, {95, 147, 5, 14}, 
  {201, 147, 4, 14}, {305, 147, 5, 14}, {379, 147, 5, 14}, {413, 147, 5, 14}, 
  {454, 147, 4, 14}, {491, 147, 5, 14}, {105, 163, 4, 14}, {137, 163, 4, 14}, 
  {260, 163, 5, 14}, {474, 163, 4, 14}, {101, 180, 4, 14}, {152, 180, 5, 14}, 
  {213, 180, 5, 14}, {277, 180, 5, 14}, {421, 180, 5, 14}, {116, 196, 5, 14}, 
  {180, 196, 5, 14}, {191, 196, 4, 14}, {315, 196, 5, 14}, {451, 196, 4, 14}, 
  {88, 213, 5, 14}, {111, 213, 4, 14}, {115, 213, 5, 14}, {169, 213, 5, 14}, 
  {453, 213, 5, 14}, {136, 229, 5, 14}, {144, 229, 4, 14}, {166, 229, 4, 14}, 
  {197, 229, 5, 14}, {268, 229, 4, 14}, {352, 229, 4, 14}, {359, 229, 5, 14}, 
  {425, 229, 4, 14}, {433, 229, 4, 14}, {452, 229, 5, 14}, {88, 246, 4, 14}, 
  {129, 246, 4, 14}, {263, 246, 5, 14}, {274, 246, 4, 14}, {281, 246, 5, 14}, 
  {316, 246, 5, 14}, {94, 262, 5, 15}, {135, 262, 4, 15}, {166, 262, 5, 15}, 
  {233, 262, 5, 15}, {241, 262, 5, 15}, {56, 286, 7, 14}, {69, 286, 5, 14}, 
  {100, 286, 5, 14}, {105, 286, 5, 14}, {359, 286, 4, 14}, {393, 286, 5, 14}, 
  {432, 286, 4, 14}, {497, 286, 4, 14}, {168, 302, 5, 15}, {270, 302, 4, 15}, 
  {292, 302, 5, 15}, {452, 302, 5, 15}, {493, 302, 5, 15}, {78, 319, 4, 14}, 
  {130, 319, 5, 14}, {153, 319, 5, 14}, {164, 319, 4, 14}, {181, 319, 4, 14}, 
  {232, 319, 5, 14}, {305, 319, 5, 14}, {316, 319, 5, 14}, {367, 319, 5, 14}, 
  {113, 336, 5, 14}, {133, 336, 4, 14}, {219, 336, 4, 14}, {269, 336, 5, 14}, 
  {320, 336, 5, 14}, {416, 336, 4, 14}, {471, 336, 5, 14}, {88, 352, 5, 14}, 
  {221, 352, 4, 14}, {238, 352, 4, 14}, {329, 352, 4, 14}, {346, 352, 4, 14}, 
  {363, 352, 5, 14}, {440, 352, 5, 14}, {465, 352, 5, 14}, {496, 352, 5, 14}, 
  {72, 369, 4, 14}, {110, 369, 5, 14}, {230, 369, 5, 14}, {261, 369, 5, 14}, 
  {286, 369, 5, 14}, {341, 369, 5, 14}, {383, 369, 5, 14}, {459, 369, 5, 14}, 
  {503, 369, 5, 14}, {139, 385, 5, 14}, {174, 385, 5, 14}, {221, 385, 4, 14}, 
  {273, 385, 4, 14}, {332, 385, 5, 14}, {427, 385, 4, 14}, {532, 385, 6, 14}, 
  {140, 402, 5, 14}, {148, 402, 4, 14}, {170, 402, 5, 14}, {294, 402, 5, 14}, 
  {389, 402, 4, 14}, {494, 402, 5, 14}, {100, 442, 4, 14}, {122, 442, 4, 14}, 
  {259, 442, 5, 14}, {334, 442, 5, 14}, {342, 442, 4, 14}, {371, 442, 5, 14}, 
  {393, 442, 5, 14}, {398, 442, 5, 14}, {94, 458, 5, 15}, {145, 458, 5, 15}, 
  {248, 458, 4, 15}, {258, 458, 5, 15}, {301, 458, 6, 15}, {352, 458, 5, 15}, 
  {408, 458, 5, 15}, {125, 475, 5, 14}, {157, 475, 4, 14}, {182, 475, 4, 14}, 
  {280, 475, 5, 14}, {177, 492, 5, 14}, {212, 492, 5, 14}, {312, 492, 5, 14}, 
  {352, 492, 5, 14}, {422, 492, 5, 14}, {453, 492, 4, 14}, {80, 508, 5, 14}, 
  {104, 508, 5, 14}, {177, 508, 5, 14}, {219, 508, 5, 14}, {279, 508, 5, 14}, 
  {308, 508, 5, 14}, {357, 508, 5, 14}, {388, 508, 4, 14}, {504, 508, 5, 14}, 
  {255, 525, 5, 14}, {301, 525, 5, 14}, {343, 525, 5, 14}, {439, 525, 4, 14}, 
  {470, 525, 5, 14}, {527, 525, 6, 14}, {72, 541, 4, 14}, {118, 541, 5, 14}, 
  {180, 541, 5, 14}, {191, 541, 4, 14}, {208, 541, 4, 14}, {287, 541, 4, 14}, 
  {462, 541, 4, 14}, {497, 541, 5, 14}, {502, 541, 5, 14}, {205, 581, 5, 14}, 
  {281, 581, 5, 14}, {56, 598, 5, 14}, {124, 598, 4, 14}, {280, 598, 5, 14}, 
  {311, 598, 4, 14}, {361, 598, 5, 14}, {518, 598, 6, 14}, {71, 614, 5, 15}, 
  {76, 614, 4, 15}, {121, 614, 4, 15}, {196, 614, 4, 15}, {244, 614, 5, 15}, 
  {339, 614, 5, 15}, {369, 614, 4, 15}, {94, 631, 5, 14}, {162, 631, 4, 14}, 
  {294, 631, 5, 14}, {380, 631, 5, 14}, {391, 631, 4, 14}, {498, 631, 5, 14}, 
  {521, 631, 5, 14}, {56, 647, 5, 15}, {182, 647, 5, 15}, {94, 671, 5, 14}, 
  {116, 671, 5, 14}, {155, 671, 5, 14}, {201, 671, 5, 14}, {366, 671, 7, 14}, 
  {472, 671, 4, 14}, {119, 688, 5, 14}, {182, 688, 5, 14}, {199, 688, 5, 14}, 
  {283, 688, 5, 14}, {373, 688, 5, 14}, {471, 688, 4, 14}, {98, 704, 5, 14}, 
  {129, 704, 4, 14}, {184, 704, 5, 14}, {189, 704, 4, 14}, {328, 704, 5, 14}, 
  {139, 721, 4, 14}, {190, 721, 5, 14}, {241, 721, 5, 14}, {272, 721, 5, 14}, 
  {313, 721, 4, 14}, {404, 721, 5, 14}, {512, 721, 5, 14}, {122, 737, 5, 14}, 
  {133, 737, 5, 14}, {282, 737, 5, 14}, {351, 737, 4, 14}, {366, 737, 4, 14}, 
  {376, 737, 5, 14}, {460, 737, 4, 14}, {467, 737, 5, 14}, {105, 754, 4, 14}, 
  {115, 754, 5, 14}, {123, 754, 5, 14}, {181, 754, 5, 14}, {248, 754, 5, 14}, 
  {259, 754, 5, 14}, {332, 754, 4, 14}, {419, 754, 5, 14}, {78, 57, 4, 14}, 
  {339, 57, 5, 14}, {370, 57, 5, 14}, {429, 57, 4, 14}, {496, 57, 4, 14}, 
  {158, 73, 5, 15}, {169, 73, 4, 15}, {261, 73, 5, 15}, {315, 73, 5, 15}, 
  {369, 73, 5, 15}, {418, 73, 5, 15}, {474, 73, 5, 15}, {128, 97, 5, 14}, 
  {167, 97, 4, 14}, {317, 97, 4, 14}, {373, 97, 5, 14}, {381, 97, 5, 14}, 
  {409, 97, 5, 14}, {499, 97, 5, 14}, {161, 113, 5, 15}, {174, 113, 5, 15}, 
  {226, 113, 5, 15}, {248, 113, 5, 15}, {381, 113, 5, 15}, {400, 113, 5, 15}, 
  {69, 130, 5, 14}, {166, 130, 5, 14}, {221, 130, 5, 14}, {250, 130, 4, 14}, 
  {449, 130, 5, 14}, {499, 130, 4, 14}, {266, 147, 5, 14}, {277, 147, 5, 14}, 
  {352, 147, 4, 14}, {435, 147, 5, 14}, {493, 147, 5, 14}, {197, 163, 4, 14}, 
  {387, 163, 4, 14}, {434, 163, 5, 14}, {56, 180, 5, 14}, {225, 180, 5, 14}, 
  {306, 180, 5, 14}, {503, 180, 5, 14}, {508, 180, 5, 14}, {113, 196, 5, 14}, 
  {166, 196, 5, 14}, {300, 196, 5, 14}, {305, 196, 4, 14}, {156, 213, 5, 14}, 
  {313, 213, 5, 14}, {343, 213, 5, 14}, {375, 213, 5, 14}, {404, 213, 5, 14}, 
  {418, 213, 5, 14}, {476, 213, 5, 14}, {66, 229, 4, 14}, {89, 229, 4, 14}, 
  {132, 229, 4, 14}, {201, 229, 5, 14}, {206, 229, 5, 14}, {244, 229, 4, 14}, 
  {361, 229, 5, 14}, {392, 229, 4, 14}, {439, 229, 4, 14}, {488, 229, 5, 14}, 
  {125, 246, 4, 14}, {160, 246, 5, 14}, {174, 246, 4, 14}, {205, 246, 5, 14}, 
  {241, 246, 5, 14}, {279, 246, 6, 14}, {372, 246, 5, 14}, {520, 246, 4, 14}, 
  {114, 262, 4, 15}, {181, 262, 4, 15}, {191, 262, 5, 15}, {220, 262, 5, 15}, 
  {258, 262, 4, 15}, {298, 262, 5, 15}, {69, 286, 5, 14}, {140, 286, 5, 14}, 
  {145, 286, 5, 14}, {222, 286, 5, 14}, {359, 286, 5, 14}, {481, 286, 5, 14}, 
  {260, 302, 4, 15}, {307, 302, 5, 15}, {474, 302, 6, 15}, {165, 319, 4, 14}, 
  {227, 319, 5, 14}, {261, 319, 4, 14}, {291, 319, 5, 14}, {204, 336, 5, 14}, 
  {227, 336, 5, 14}, {262, 336, 4, 14}, {272, 336, 5, 14}, {69, 359, 5, 14}, 
  {95, 359, 4, 14}, {105, 359, 5, 14}, {122, 359, 5, 14}, {439, 359, 5, 14}, 
  {514, 359, 5, 14}, {227, 376, 5, 14}, {251, 376, 5, 14}, {368, 376, 4, 14}, 
  {397, 376, 4, 14}, {122, 392, 5, 14}, {147, 392, 5, 14}, {213, 392, 5, 14}, 
  {457, 392, 4, 14}, {497, 392, 5, 14}, {90, 409, 4, 14}, {153, 409, 5, 14}, 
  {263, 409, 5, 14}, {283, 409, 5, 14}, {352, 409, 5, 14}, {363, 409, 4, 14}, 
  {95, 425, 5, 15}, {204, 425, 5, 15}, {236, 425, 4, 15}, {271, 425, 5, 15}, 
  {311, 425, 5, 15}, {354, 425, 5, 15}, {408, 425, 5, 15}, {452, 425, 5, 15}, 
  {477, 425, 4, 15}, {490, 425, 5, 15}, {271, 442, 4, 14}, {281, 442, 5, 14}, 
  {127, 465, 4, 15}, {331, 465, 5, 15}, {448, 465, 4, 15}, {119, 482, 4, 14}, 
  {149, 482, 5, 14}, {219, 482, 5, 14}, {283, 482, 5, 14}, {460, 482, 5, 14}, 
  {184, 499, 4, 14}, {224, 499, 5, 14}, {332, 499, 5, 14}, {372, 499, 5, 14}, 
  {394, 499, 5, 14}, {480, 499, 5, 14}, {488, 499, 5, 14}, {518, 499, 6, 14}, 
  {78, 515, 4, 14}, {142, 515, 5, 14}, {355, 515, 5, 14}, {383, 515, 5, 14}, 
  {441, 515, 4, 14}, {497, 515, 5, 14}, {502, 515, 5, 14}, {144, 532, 5, 14}, 
  {188, 532, 5, 14}, {316, 532, 5, 14}, {360, 532, 4, 14}, {403, 532, 5, 14}, 
  {56, 548, 5, 14}, {193, 548, 5, 14}, {204, 548, 5, 14}, {376, 548, 4, 14}, 
  {119, 572, 5, 14}, {132, 572, 5, 14}, {198, 572, 5, 14}, {336, 572, 5, 14}, 
  {353, 572, 5, 14}, {405, 572, 5, 14}, {66, 588, 4, 14}, {123, 588, 5, 14}, 
  {207, 588, 5, 14}, {260, 588, 5, 14}, {265, 588, 4, 14}, {325, 588, 5, 14}, 
  {423, 588, 5, 14}, {123, 605, 5, 14}, {155, 605, 5, 14}, {239, 605, 4, 14}, 
  {297, 605, 5, 14}, {336, 605, 5, 14}, {428, 605, 5, 14}, {436, 605, 5, 14}, 
  {466, 605, 4, 14}, {81, 621, 5, 15}, {89, 621, 5, 15}, {104, 621, 5, 15}, 
  {115, 621, 4, 15}, {243, 621, 5, 15}, {414, 621, 5, 15}, {439, 621, 5, 15}, 
  {495, 621, 4, 15}, {96, 638, 4, 14}, {154, 638, 5, 14}, {263, 638, 4, 14}, 
  {273, 638, 5, 14}, {351, 638, 5, 14}, {451, 638, 4, 14}, {461, 638, 5, 14}, 
  {493, 638, 6, 14}, {275, 654, 4, 15}, {372, 654, 5, 15}, {377, 654, 4, 15}, 
  {412, 654, 5, 15}, {218, 671, 5, 14}, {226, 671, 5, 14}, {249, 671, 5, 14}, 
  {330, 671, 5, 14}, {341, 671, 5, 14}, {411, 671, 5, 14}, {450, 671, 5, 14}, 
  {493, 671, 4, 14}, {156, 688, 5, 14}, {164, 688, 5, 14}, {94, 711, 5, 14}, 
  {145, 711, 5, 14}, {158, 711, 5, 14}, {188, 711, 5, 14}, {498, 711, 6, 14}, 
  {56, 728, 5, 14}, {87, 728, 5, 14}, {130, 728, 4, 14}, {143, 728, 5, 14}, 
  {189, 728, 5, 14}, {287, 728, 5, 14}, {418, 728, 5, 14}, {429, 728, 4, 14}, 
  {532, 728, 6, 14}, {144, 744, 5, 14}, {176, 744, 5, 14}, {270, 744, 4, 14}, 
  {391, 744, 5, 14}, {509, 744, 5, 14}, {107, 761, 5, 14}, {136, 761, 5, 14}, 
  {159, 761, 4, 14}, {188, 761, 5, 14}, {80, 57, 5, 14}, {123, 57, 4, 14}, 
  {153, 57, 5, 14}, {249, 57, 5, 14}, {300, 57, 5, 14}, {361, 57, 5, 14}, 
  {425, 57, 5, 14}, {475, 57, 7, 14}, {488, 57, 4, 14}, {519, 57, 5, 14}, 
  {524, 57, 4, 14}, {95, 73, 5, 15}, {139, 73, 5, 15}, {239, 73, 5, 15}, 
  {252, 73, 5, 15}, {405, 73, 4, 15}, {459, 73, 7, 15}, {516, 73, 4, 15}, 
  {111, 90, 5, 14}, {122, 90, 4, 14}, {187, 90, 4, 14}, {242, 90, 4, 14}, 
  {255, 90, 5, 14}, {263, 90, 4, 14}, {443, 90, 5, 14}, {135, 113, 4, 15}, 
  {148, 113, 4, 15}, {239, 113, 5, 15}, {267, 113, 5, 15}, {341, 113, 5, 15}, 
  {352, 113, 4, 15}, {389, 113, 4, 15}, {523, 113, 5, 15}, {56, 130, 7, 14}, 
  {69, 130, 5, 14}, {100, 130, 5, 14}, {105, 130, 5, 14}, {424, 130, 5, 14}, 
  {473, 130, 5, 14}, {505, 130, 5, 14}, {104, 147, 5, 14}, {136, 147, 5, 14}, 
  {246, 147, 4, 14}, {250, 147, 5, 14}, {303, 147, 4, 14}, {391, 147, 5, 14}, 
  {430, 147, 4, 14}, {468, 147, 4, 14}, {440, 163, 5, 14}, {114, 187, 5, 14}, 
  {291, 187, 5, 14}, {314, 187, 5, 14}, {346, 187, 5, 14}, {379, 187, 5, 14}, 
  {408, 187, 5, 14}, {488, 187, 5, 14}, {76, 203, 5, 14}, {151, 203, 5, 14}, 
  {187, 203, 4, 14}, {244, 203, 5, 14}, {107, 220, 4, 14}, {111, 220, 5, 14}, 
  {134, 220, 4, 14}, {212, 220, 4, 14}, {223, 220, 4, 14}, {319, 220, 5, 14}, 
  {396, 220, 5, 14}, {473, 220, 4, 14}, {486, 220, 5, 14}, {210, 236, 5, 14}, 
  {239, 236, 5, 14}, {261, 236, 5, 14}, {292, 236, 4, 14}, {353, 236, 4, 14}, 
  {430, 236, 5, 14}, {479, 236, 5, 14}, {92, 253, 5, 14}, {146, 253, 4, 14}, 
  {196, 253, 4, 14}, {215, 253, 5, 14}, {394, 253, 5, 14}, {74, 269, 5, 15}, 
  {97, 269, 5, 15}, {156, 269, 5, 15}, {178, 269, 4, 15}, {209, 269, 5, 15}, 
  {452, 269, 4, 15}, {521, 269, 5, 15}, {56, 286, 5, 14}, {176, 286, 5, 14}, 
  {223, 286, 5, 14}, {278, 286, 4, 14}, {285, 286, 5, 14}, {356, 286, 4, 14}, 
  {99, 309, 4, 15}, {198, 309, 5, 15}, {221, 309, 5, 15}, {298, 309, 5, 15}, 
  {347, 309, 5, 15}, {403, 309, 5, 15}, {456, 309, 5, 15}, {506, 309, 6, 15}, 
  {68, 326, 5, 14}, {189, 326, 4, 14}, {371, 326, 5, 14}, {390, 326, 5, 14}, 
  {440, 326, 5, 14}, {222, 343, 5, 14}, {282, 343, 5, 14}, {374, 343, 4, 14}, 
  {422, 343, 5, 14}, {446, 343, 4, 14}, {530, 343, 6, 14}, {88, 383, 5, 14}, 
  {133, 383, 5, 14}, {144, 383, 4, 14}, {167, 383, 4, 14}, {177, 383, 5, 14}, 
  {345, 383, 4, 14}, {388, 383, 4, 14}, {526, 383, 5, 14}, {95, 399, 5, 14}, 
  {135, 399, 4, 14}, {321, 399, 5, 14}, {344, 399, 4, 14}, {397, 399, 5, 14}, 
  {453, 399, 4, 14}, {353, 416, 4, 14}, {392, 416, 5, 14}, {109, 439, 4, 15}, 
  {119, 439, 5, 15}, {176, 439, 5, 15}, {239, 439, 4, 15}, {310, 439, 5, 15}, 
  {368, 439, 5, 15}, {397, 439, 5, 15}, {446, 439, 4, 15}, {453, 439, 5, 15}, 
  {485, 439, 4, 15}, {533, 439, 6, 15}, {145, 456, 5, 14}, {211, 456, 5, 14}, 
  {424, 456, 5, 14}, {195, 472, 5, 15}, {200, 472, 4, 15}, {285, 472, 5, 15}, 
  {293, 472, 4, 15}, {410, 472, 4, 15}, {442, 472, 4, 15}, {493, 472, 5, 15}, 
  {157, 489, 5, 14}, {184, 489, 5, 14}, {235, 489, 4, 14}, {457, 489, 5, 14}, 
  {519, 489, 4, 14}, {136, 506, 5, 14}, {216, 506, 5, 14}, {250, 506, 5, 14}, 
  {335, 506, 5, 14}, {400, 506, 5, 14}, {101, 546, 5, 14}, {135, 546, 5, 14}, 
  {188, 546, 7, 14}, {201, 546, 4, 14}, {232, 546, 5, 14}, {237, 546, 4, 14}, 
  {282, 546, 5, 14}, {341, 546, 5, 14}, {352, 546, 5, 14}, {485, 546, 5, 14}, 
  {179, 562, 5, 14}, {346, 562, 5, 14}, {414, 562, 5, 14}, {471, 562, 5, 14}, 
  {514, 562, 6, 14}, {202, 579, 5, 14}, {265, 579, 5, 14}, {304, 579, 4, 14}, 
  {381, 579, 5, 14}, {430, 579, 5, 14}, {486, 579, 4, 14}, {80, 595, 5, 14}, 
  {130, 595, 5, 14}, {150, 595, 5, 14}, {358, 595, 5, 14}, {366, 595, 5, 14}, 
  {453, 595, 4, 14}, {85, 612, 5, 14}, {56, 635, 7, 15}, {116, 635, 5, 15}, 
  {179, 635, 5, 15}, {208, 635, 5, 15}, {231, 635, 5, 15}, {345, 635, 5, 15}, 
  {384, 635, 5, 15}, {427, 635, 4, 15}, {72, 652, 4, 14}, {82, 652, 5, 14}, 
  {106, 652, 5, 14}, {194, 652, 5, 14}, {202, 652, 5, 14}, {243, 652, 4, 14}, 
  {292, 652, 5, 14}, {362, 652, 6, 14}, {430, 652, 5, 14}, {56, 668, 7, 15}, 
  {109, 668, 5, 15}, {148, 668, 5, 15}, {192, 668, 5, 15}, {330, 668, 5, 15}, 
  {370, 668, 5, 15}, {416, 668, 5, 15}, {152, 685, 5, 14}, {331, 685, 4, 14}, 
  {391, 685, 5, 14}, {414, 685, 4, 14}, {471, 685, 5, 14}, {501, 685, 5, 14}, 
  {100, 709, 4, 14}, {122, 709, 5, 14}, {208, 709, 5, 14}, {260, 709, 5, 14}, 
  {348, 709, 7, 14}, {382, 709, 4, 14}, {411, 709, 5, 14}, {440, 709, 5, 14}, 
  {56, 725, 5, 14}, {86, 725, 4, 14}, {132, 725, 5, 14}, {137, 725, 5, 14}, 
  {229, 725, 4, 14}, {362, 725, 4, 14}, {484, 725, 5, 14}, {135, 742, 4, 14}, 
  {158, 742, 4, 14}, {235, 742, 5, 14}, {284, 742, 5, 14}, {340, 742, 5, 14}, 
  {393, 742, 5, 14}, {443, 742, 5, 14}, {463, 742, 5, 14}, {91, 57, 7, 14}, 
  {128, 57, 4, 14}, {169, 57, 4, 14}, {479, 57, 5, 14}, {519, 57, 5, 14}, 
  {119, 73, 4, 15}, {144, 73, 5, 15}, {173, 73, 5, 15}, {354, 73, 4, 15}, 
  {78, 97, 4, 14}, {175, 97, 5, 14}, {281, 97, 5, 14}, {348, 97, 5, 14}, 
  {399, 97, 5, 14}, {452, 97, 5, 14}, {496, 97, 5, 14}, {519, 97, 5, 14}, 
  {77, 113, 5, 15}, {108, 113, 5, 15}, {139, 113, 5, 15}, {203, 113, 4, 15}, 
  {220, 113, 4, 15}, {368, 113, 5, 15}, {436, 113, 5, 15}, {148, 130, 5, 14}, 
  {228, 130, 4, 14}, {245, 130, 4, 14}, {255, 130, 5, 14}, {299, 130, 4, 14}, 
  {397, 130, 5, 14}, {417, 130, 4, 14}, {469, 130, 5, 14}, {477, 130, 4, 14}, 
  {56, 147, 5, 14}, {88, 147, 4, 14}, {191, 147, 5, 14}, {218, 147, 5, 14}, 
  {247, 147, 5, 14}, {270, 147, 4, 14}, {364, 147, 5, 14}, {72, 163, 4, 14}, 
  {100, 163, 5, 14}, {252, 163, 5, 14}, {326, 163, 5, 14}, {380, 163, 5, 14}, 
  {385, 163, 5, 14}, {452, 163, 5, 14}, {477, 163, 5, 14}, {171, 180, 4, 14}, 
  {247, 180, 5, 14}, {302, 180, 5, 14}, {389, 180, 5, 14}, {418, 180, 5, 14}, 
  {120, 196, 5, 14}, {178, 196, 4, 14}, {188, 196, 5, 14}, {56, 220, 7, 14}, 
  {89, 220, 4, 14}, {151, 220, 5, 14}, {156, 220, 5, 14}, {177, 220, 5, 14}, 
  {209, 220, 4, 14}, {407, 220, 5, 14}, {447, 220, 5, 14}, {497, 220, 5, 14}, 
  {508, 220, 5, 14}, {110, 236, 5, 14}, {322, 236, 4, 14}, {425, 236, 5, 14}, 
  {234, 253, 4, 14}, {256, 253, 5, 14}, {300, 253, 5, 14}, {311, 253, 4, 14}, 
  {362, 253, 5, 14}, {496, 253, 4, 14}, {522, 253, 5, 14}, {80, 269, 5, 15}, 
  {130, 269, 5, 15}, {227, 269, 5, 15}, {266, 269, 4, 15}, {301, 269, 5, 15}, 
  {354, 269, 4, 15}, {445, 269, 5, 15}, {468, 269, 5, 15}, {479, 269, 5, 15}, 
  {156, 286, 5, 14}, {164, 286, 4, 14}, {204, 286, 6, 14}, {216, 286, 5, 14}, 
  {248, 286, 4, 14}, {252, 286, 5, 14}, {474, 286, 4, 14}, {504, 286, 6, 14}, 
  {68, 302, 4, 15}, {155, 302, 5, 15}, {195, 302, 4, 15}, {202, 302, 5, 15}, 
  {242, 302, 7, 15}, {320, 302, 5, 15}, {352, 302, 7, 15}, {365, 302, 4, 15}, 
  {396, 302, 5, 15}, {401, 302, 4, 15}, {487, 302, 5, 15}, {492, 302, 5, 15}, 
  {88, 319, 5, 14}, {171, 319, 5, 14}, {229, 319, 5, 14}, {314, 319, 4, 14}, 
  {401, 319, 5, 14}, {128, 343, 5, 14}, {203, 343, 5, 14}, {232, 343, 5, 14}, 
  {249, 343, 5, 14}, {260, 343, 5, 14}, {344, 343, 5, 14}, {439, 343, 5, 14}, 
  {463, 343, 5, 14}, {512, 343, 5, 14}, {68, 359, 5, 14}, {183, 359, 5, 14}, 
  {196, 359, 5, 14}, {230, 359, 5, 14}, {276, 359, 7, 14}, {339, 359, 4, 14}, 
  {346, 359, 5, 14}, {422, 359, 5, 14}, {132, 376, 4, 14}, {283, 376, 5, 14}, 
  {357, 376, 5, 14}, {368, 376, 6, 14}, {95, 392, 5, 14}, {127, 392, 5, 14}, 
  {394, 392, 4, 14}, {452, 392, 5, 14}, {475, 392, 4, 14}, {275, 409, 5, 14}, 
  {297, 409, 5, 14}, {302, 409, 4, 14}, {392, 409, 5, 14}, {161, 425, 5, 15}, 
  {245, 425, 5, 15}, {56, 449, 7, 14}, {92, 449, 4, 14}, {148, 449, 5, 14}, 
  {302, 449, 5, 14}, {353, 449, 7, 14}, {406, 449, 4, 14}, {92, 465, 5, 15}, 
  {146, 465, 5, 15}, {225, 465, 4, 15}, {307, 465, 5, 15}, {359, 465, 7, 15}, 
  {441, 465, 5, 15}, {504, 465, 5, 15}, {74, 482, 4, 14}, {147, 482, 5, 14}, 
  {158, 482, 5, 14}, {249, 482, 5, 14}, {269, 482, 5, 14}, {313, 482, 4, 14}, 
  {378, 482, 5, 14}, {486, 482, 5, 14}, {56, 499, 7, 14}, {69, 499, 5, 14}, 
  {100, 499, 5, 14}, {105, 499, 5, 14}, {135, 499, 4, 14}, {148, 499, 5, 14}, 
  {156, 499, 4, 14}, {277, 499, 5, 14}, {356, 499, 4, 14}, {207, 522, 5, 14}, 
  {345, 522, 4, 14}, {375, 522, 5, 14}, {487, 522, 4, 14}, {119, 539, 5, 14}, 
  {142, 539, 4, 14}, {244, 539, 5, 14}, {284, 539, 4, 14}, {288, 539, 5, 14}, 
  {374, 539, 4, 14}, {412, 539, 4, 14}, {422, 539, 5, 14}, {69, 555, 5, 14}, 
  {354, 555, 5, 14}, {367, 555, 5, 14}, {439, 555, 5, 14}, {126, 572, 5, 14}, 
  {165, 572, 5, 14}, {336, 572, 4, 14}, {69, 595, 5, 14}, {139, 595, 4, 14}, 
  {162, 595, 4, 14}, {313, 595, 5, 14}, {342, 595, 4, 14}, {415, 595, 5, 14}, 
  {81, 612, 5, 14}, {127, 612, 5, 14}, {240, 612, 4, 14}, {250, 612, 5, 14}, 
  {303, 612, 5, 14}, {385, 612, 4, 14}, {197, 628, 5, 15}, {362, 628, 4, 15}, 
  {489, 628, 5, 15}, {186, 645, 4, 14}, {208, 645, 5, 14}, {334, 645, 4, 14}, 
  {406, 645, 4, 14}, {64, 661, 4, 15}, {74, 661, 5, 15}, {97, 661, 4, 15}, 
  {107, 661, 5, 15}, {164, 661, 5, 15}, {248, 661, 5, 15}, {341, 661, 5, 15}, 
  {430, 661, 4, 15}, {449, 661, 5, 15}, {500, 661, 5, 15}, {56, 678, 5, 14}, 
  {88, 678, 4, 14}, {122, 678, 5, 14}, {149, 678, 4, 14}, {202, 678, 5, 14}, 
  {247, 678, 5, 14}, {252, 678, 4, 14}, {288, 678, 4, 14}, {311, 678, 5, 14}, 
  {388, 678, 5, 14}, {437, 678, 5, 14}, {493, 678, 5, 14}, {80, 695, 5, 14}, 
  {130, 695, 5, 14}, {150, 695, 5, 14}, {345, 695, 5, 14}, {417, 695, 5, 14}, 
  {74, 718, 5, 14}, {174, 718, 5, 14}, {261, 718, 5, 14}, {396, 718, 5, 14}, 
  {468, 718, 5, 14}, {139, 735, 5, 14}, {147, 735, 4, 14}, {178, 735, 5, 14}, 
  {422, 735, 5, 14}, {474, 735, 4, 14}, {74, 751, 4, 14}, {138, 751, 5, 14}, 
  {226, 751, 5, 14}, {335, 751, 5, 14}, {367, 751, 4, 14}, {403, 751, 4, 14}, 
  {443, 751, 4, 14}, {485, 751, 5, 14}, {80, 768, 5, 14}, {124, 768, 5, 14}, 
  {149, 768, 4, 14}, {162, 768, 5, 14}, {224, 768, 5, 14}, {389, 768, 4, 14}, 
  {408, 768, 4, 14}, {464, 768, 7, 14}, {477, 768, 4, 14}, {508, 768, 5, 14}, 
  {513, 768, 4, 14}, {108, 57, 5, 14}, {298, 57, 5, 14}, {303, 57, 4, 14}, 
  {411, 57, 4, 14}, {454, 57, 5, 14}, {473, 57, 5, 14}, {97, 73, 5, 15}, 
  {236, 73, 5, 15}, {359, 73, 5, 15}, {405, 73, 5, 15}, {462, 73, 5, 15}, 
  {95, 113, 5, 15}, {127, 113, 4, 15}, {174, 113, 5, 15}, {197, 113, 5, 15}, 
  {246, 113, 5, 15}, {328, 113, 4, 15}, {405, 113, 5, 15}, {416, 113, 5, 15}, 
  {488, 113, 5, 15}, {117, 130, 5, 14}, {171, 130, 4, 14}, {246, 130, 5, 14}, 
  {263, 130, 4, 14}, {387, 130, 5, 14}, {67, 147, 5, 14}, {207, 147, 5, 14}, 
  {218, 147, 5, 14}, {251, 147, 5, 14}, {268, 147, 5, 14}, {309, 147, 4, 14}, 
  {371, 147, 4, 14}, {381, 147, 5, 14}, {455, 147, 5, 14}, {62, 163, 4, 14}, 
  {76, 163, 6, 14}, {204, 163, 5, 14}, {289, 163, 5, 14}, {302, 163, 5, 14}, 
  {342, 163, 5, 14}, {418, 163, 5, 14}, {83, 180, 5, 14}, {115, 180, 4, 14}, 
  {203, 180, 4, 14}, {248, 180, 5, 14}, {288, 180, 7, 14}, {301, 180, 5, 14}, 
  {332, 180, 5, 14}, {337, 180, 5, 14}, {461, 180, 5, 14}, {492, 180, 4, 14}, 
  {78, 196, 5, 14}, {241, 196, 5, 14}, {249, 196, 4, 14}, {138, 220, 5, 14}, 
  {192, 220, 5, 14}, {246, 220, 5, 14}, {295, 220, 5, 14}, {351, 220, 5, 14}, 
  {362, 220, 6, 14}, {81, 236, 5, 14}, {86, 236, 4, 14}, {145, 236, 5, 14}, 
  {177, 236, 5, 14}, {205, 236, 5, 14}, {345, 236, 5, 14}, {359, 236, 7, 14}, 
  {465, 236, 5, 14}, {201, 253, 5, 14}, {276, 253, 4, 14}, {357, 253, 5, 14}, 
  {365, 253, 5, 14}, {381, 253, 5, 14}, {451, 253, 4, 14}, {525, 253, 5, 14}, 
  {533, 253, 6, 14}, {71, 269, 4, 15}, {119, 269, 4, 15}, {200, 269, 5, 15}, 
  {256, 269, 5, 15}, {305, 269, 4, 15}, {368, 269, 5, 15}, {499, 269, 5, 15}, 
  {127, 286, 5, 14}, {224, 286, 4, 14}, {263, 286, 5, 14}, {295, 286, 5, 14}, 
  {300, 286, 5, 14}, {343, 286, 4, 14}, {477, 286, 5, 14}, {482, 286, 5, 14}, 
  {113, 302, 4, 15}, {177, 302, 4, 15}, {301, 302, 4, 15}, {311, 302, 5, 15}, 
  {138, 319, 4, 14}, {240, 319, 5, 14}, {309, 319, 4, 14}, {114, 336, 5, 14}, 
  {125, 336, 4, 14}, {182, 336, 4, 14}, {294, 336, 5, 14}, {299, 336, 4, 14}, 
  {315, 336, 6, 14}, {387, 336, 5, 14}, {398, 336, 5, 14}, {493, 336, 4, 14}, 
  {497, 336, 5, 14}, {142, 352, 5, 14}, {220, 376, 5, 14}, {228, 376, 5, 14}, 
  {236, 376, 5, 14}, {433, 376, 5, 14}, {233, 392, 5, 14}, {259, 392, 4, 14}, 
  {417, 392, 4, 14}, {491, 392, 4, 14}, {89, 409, 4, 14}, {138, 409, 4, 14}, 
  {194, 409, 4, 14}, {247, 409, 5, 14}, {297, 409, 4, 14}, {316, 409, 5, 14}, 
  {459, 409, 4, 14}, {124, 425, 5, 15}, {168, 425, 5, 15}, {233, 425, 4, 15}, 
  {97, 442, 5, 14}, {178, 442, 5, 14}, {216, 442, 5, 14}, {226, 442, 5, 14}, 
  {276, 442, 4, 14}, {315, 442, 5, 14}, {362, 442, 5, 14}, {367, 442, 4, 14}, 
  {380, 442, 4, 14}, {72, 458, 5, 15}, {112, 458, 5, 15}, {144, 458, 4, 15}, 
  {271, 458, 5, 15}, {308, 458, 5, 15}, {121, 482, 4, 14}, {179, 482, 5, 14}, 
  {211, 482, 4, 14}, {330, 482, 4, 14}, {435, 482, 4, 14}, {92, 499, 4, 14}, 
  {147, 499, 4, 14}, {469, 499, 5, 14}, {522, 499, 5, 14}, {107, 515, 5, 14}, 
  {170, 515, 5, 14}, {228, 515, 4, 14}, {241, 515, 4, 14}, {258, 515, 4, 14}, 
  {365, 515, 7, 14}, {378, 515, 4, 14}, {409, 515, 5, 14}, {414, 515, 4, 14}, 
  {451, 515, 5, 14}, {459, 515, 5, 14}, {488, 515, 5, 14}, {531, 515, 6, 14}, 
  {173, 532, 5, 14}, {354, 532, 4, 14}, {364, 532, 5, 14}, {435, 532, 5, 14}, 
  {151, 548, 4, 14}, {234, 548, 4, 14}, {308, 548, 4, 14}, {366, 548, 4, 14}, 
  {373, 548, 5, 14}, {471, 548, 5, 14}, {503, 548, 5, 14}, {508, 548, 5, 14}, 
  {115, 565, 7, 14}, {151, 565, 5, 14}, {182, 565, 5, 14}, {225, 565, 5, 14}, 
  {273, 565, 4, 14}, {305, 565, 5, 14}, {379, 565, 5, 14}, {470, 565, 5, 14}, 
  {502, 565, 5, 14}, {56, 581, 5, 14}, {56, 605, 7, 14}, {116, 605, 5, 14}, 
  {264, 605, 4, 14}, {445, 605, 5, 14}, {509, 605, 4, 14}, {516, 605, 5, 14}, 
  {157, 621, 4, 15}, {272, 621, 4, 15}, {390, 621, 4, 15}, {400, 621, 5, 15}, 
  {84, 638, 5, 14}, {232, 638, 5, 14}, {279, 638, 5, 14}, {310, 638, 5, 14}, 
  {403, 638, 4, 14}, {458, 638, 4, 14}, {509, 638, 5, 14}, {103, 654, 5, 15}, 
  {167, 654, 5, 15}, {260, 654, 5, 15}, {344, 654, 5, 15}, {367, 654, 5, 15}, 
  {410, 654, 5, 15}, {476, 654, 5, 15}, {525, 654, 5, 15}, {86, 671, 6, 14}, 
  {98, 671, 5, 14}, {130, 671, 4, 14}, {134, 671, 5, 14}, {177, 671, 5, 14}, 
  {281, 671, 7, 14}, {294, 671, 4, 14}, {325, 671, 5, 14}, {330, 671, 4, 14}, 
  {384, 671, 5, 14}, {427, 671, 5, 14}, {493, 671, 5, 14}, {82, 688, 4, 14}, 
  {185, 688, 5, 14}, {233, 688, 5, 14}, {264, 688, 5, 14}, {310, 688, 5, 14}, 
  {395, 688, 5, 14}, {453, 688, 5, 14}, {96, 704, 4, 14}, {193, 704, 6, 14}, 
  {205, 704, 5, 14}, {237, 704, 4, 14}, {241, 704, 5, 14}, {404, 704, 7, 14}, 
  {71, 721, 5, 14}, {169, 721, 4, 14}, {286, 721, 5, 14}, {300, 721, 5, 14}, 
  {313, 721, 5, 14}, {403, 721, 5, 14}, {73, 744, 5, 14}, {78, 744, 4, 14}, 
  {145, 744, 4, 14}, {170, 744, 5, 14}, {346, 744, 5, 14}, {423, 744, 5, 14}, 
  {478, 744, 4, 14}, {77, 761, 5, 14}, {108, 761, 5, 14}, {138, 761, 4, 14}, 
  {207, 761, 4, 14}, {234, 761, 4, 14}, {244, 761, 5, 14}, {269, 761, 5, 14}, 
  {319, 761, 5, 14}, {342, 761, 4, 14}, {371, 761, 5, 14}, {379, 761, 4, 14}, 
  {408, 761, 5, 14}, {419, 761, 6, 14}, {518, 761, 5, 14}, {171, 57, 5, 14}, 
  {185, 57, 4, 14}, {192, 57, 5, 14}, {291, 57, 4, 14}, {389, 57, 5, 14}, 
  {474, 57, 5, 14}, {89, 73, 5, 15}, {202, 73, 5, 15}, {317, 73, 5, 15}, 
  {372, 73, 5, 15}, {443, 73, 5, 15}, {62, 90, 4, 14}, {132, 90, 4, 14}, 
  {178, 90, 5, 14}, {214, 90, 4, 14}, {337, 90, 5, 14}, {447, 90, 5, 14}, 
  {119, 106, 5, 15}, {155, 106, 5, 15}, {333, 106, 4, 15}, {352, 106, 5, 15}, 
  {428, 106, 5, 15}, {88, 123, 5, 14}, {111, 123, 4, 14}, {360, 123, 5, 14}, 
  {423, 123, 5, 14}, {475, 123, 4, 14}, {524, 123, 6, 14}, {142, 140, 5, 14}, 
  {267, 140, 4, 14}, {307, 140, 5, 14}, {320, 140, 5, 14}, {367, 140, 5, 14}, 
  {413, 140, 5, 14}, {466, 140, 4, 14}, {470, 140, 5, 14}, {56, 180, 7, 14}, 
  {69, 180, 5, 14}, {100, 180, 5, 14}, {105, 180, 5, 14}, {175, 180, 4, 14}, 
  {216, 180, 4, 14}, {295, 180, 5, 14}, {341, 180, 5, 14}, {366, 180, 5, 14}, 
  {397, 180, 5, 14}, {499, 180, 5, 14}, {507, 180, 6, 14}, {71, 196, 5, 14}, 
  {123, 196, 5, 14}, {220, 196, 5, 14}, {319, 196, 5, 14}, {350, 196, 5, 14}, 
  {358, 196, 4, 14}, {458, 196, 5, 14}, {491, 196, 4, 14}, {499, 196, 4, 14}, 
  {170, 213, 5, 14}, {211, 213, 4, 14}, {270, 213, 5, 14}, {318, 213, 4, 14}, 
  {466, 213, 4, 14}, {99, 229, 4, 14}, {130, 229, 5, 14}, {166, 229, 5, 14}, 
  {206, 229, 5, 14}, {249, 229, 5, 14}, {303, 229, 5, 14}, {347, 229, 5, 14}, 
  {371, 229, 5, 14}, {385, 229, 4, 14}, {408, 229, 5, 14}, {472, 229, 4, 14}, 
  {532, 229, 6, 14}, {71, 246, 5, 14}, {115, 246, 5, 14}, {126, 246, 5, 14}, 
  {186, 246, 4, 14}, {275, 246, 5, 14}, {325, 246, 5, 14}, {342, 246, 4, 14}, 
  {429, 246, 5, 14}, {451, 246, 5, 14}, {520, 246, 6, 14}, {72, 262, 4, 15}, 
  {100, 262, 5, 15}, {233, 262, 5, 15}, {253, 262, 4, 15}, {284, 262, 5, 15}, 
  {336, 262, 4, 15}, {484, 262, 5, 15}, {82, 279, 4, 14}, {117, 279, 5, 14}, 
  {171, 279, 4, 14}, {343, 279, 5, 14}, {385, 279, 5, 14}, {423, 279, 4, 14}, 
  {111, 295, 5, 15}, {122, 295, 4, 15}, {159, 295, 5, 15}, {114, 319, 5, 14}, 
  {246, 319, 4, 14}, {317, 319, 4, 14}, {416, 319, 4, 14}, {71, 336, 5, 14}, 
  {208, 336, 5, 14}, {216, 336, 5, 14}, {257, 336, 5, 14}, {335, 336, 4, 14}, 
  {381, 336, 5, 14}, {167, 352, 4, 14}, {223, 352, 5, 14}, {246, 352, 5, 14}, 
  {297, 352, 5, 14}, {425, 352, 6, 14}, {437, 352, 5, 14}, {469, 352, 4, 14}, 
  {473, 352, 5, 14}, {119, 369, 4, 14}, {212, 369, 5, 14}, {273, 369, 5, 14}, 
  {362, 369, 5, 14}, {415, 369, 5, 14}, {462, 369, 4, 14}, {499, 369, 4, 14}, 
  {81, 385, 5, 14}, {86, 385, 4, 14}, {130, 385, 5, 14}, {147, 385, 5, 14}, 
  {178, 385, 5, 14}, {288, 385, 5, 14}, {435, 385, 4, 14}, {155, 402, 5, 14}, 
  {285, 402, 5, 14}, {464, 402, 4, 14}, {493, 402, 4, 14}, {523, 402, 5, 14}, 
  {186, 418, 5, 15}, {263, 418, 5, 15}, {294, 418, 4, 15}, {333, 418, 5, 15}, 
  {426, 418, 4, 15}, {451, 418, 4, 15}, {74, 442, 5, 14}, {97, 442, 5, 14}, 
  {247, 442, 5, 14}, {260, 442, 5, 14}, {301, 442, 5, 14}, {339, 442, 5, 14}, 
  {416, 442, 5, 14}, {465, 442, 5, 14}, {521, 442, 6, 14}, {102, 458, 5, 15}, 
  {152, 458, 5, 15}, {172, 458, 4, 15}, {372, 458, 5, 15}, {452, 458, 4, 15}, 
  {505, 458, 4, 15}, {147, 475, 5, 14}, {184, 475, 5, 14}, {213, 475, 5, 14}, 
  {237, 475, 5, 14}, {251, 475, 5, 14}, {312, 475, 4, 14}, {355, 475, 5, 14}, 
  {379, 475, 5, 14}, {124, 492, 5, 14}, {180, 492, 5, 14}, {248, 492, 5, 14}, 
  {322, 492, 5, 14}, {526, 492, 6, 14}, {71, 508, 7, 14}, {84, 508, 4, 14}, 
  {115, 508, 5, 14}, {120, 508, 4, 14}, {172, 508, 5, 14}, {204, 508, 5, 14}, 
  {291, 508, 4, 14}, {336, 508, 4, 14}, {340, 508, 5, 14}, {402, 508, 7, 14}, 
  {438, 508, 5, 14}, {78, 525, 4, 14}, {98, 525, 4, 14}, {128, 525, 5, 14}, 
  {239, 525, 5, 14}, {247, 525, 4, 14}, {299, 525, 5, 14}, {369, 525, 5, 14}, 
  {91, 548, 4, 14}, {101, 548, 5, 14}, {221, 548, 5, 14}, {338, 548, 4, 14}, 
  {407, 548, 7, 14}, {363, 565, 5, 14}, {410, 565, 5, 14}, {473, 565, 7, 14}, 
  {510, 565, 5, 14}, {524, 565, 5, 14}, {74, 581, 5, 14}, {180, 581, 4, 14}, 
  {190, 581, 5, 14}, {314, 581, 5, 14}, {363, 581, 4, 14}, {509, 581, 5, 14}, 
  {153, 598, 4, 14}, {225, 598, 5, 14}, {236, 598, 5, 14}, {301, 598, 5, 14}, 
  {346, 598, 5, 14}, {416, 598, 4, 14}, {74, 614, 4, 15}, {155, 614, 5, 15}, 
  {163, 614, 5, 15}, {171, 614, 4, 15}, {389, 614, 5, 15}, {447, 614, 7, 15}, 
  {483, 614, 5, 15}, {494, 614, 5, 15}, {104, 631, 5, 14}, {184, 631, 4, 14}, 
  {323, 631, 4, 14}, {355, 631, 4, 14}, {405, 631, 5, 14}, {418, 631, 5, 14}, 
  {94, 654, 5, 15}, {157, 654, 5, 15}, {185, 654, 5, 15}, {245, 654, 5, 15}, 
  {274, 654, 5, 15}, {284, 654, 5, 15}, {386, 654, 4, 15}, {435, 654, 5, 15}, 
  {187, 671, 5, 14}, {217, 671, 5, 14}, {313, 671, 5, 14}, {400, 671, 5, 14}, 
  {498, 671, 4, 14}, {530, 671, 5, 14}, {121, 688, 5, 14}, {156, 688, 4, 14}, 
  {265, 688, 5, 14}, {273, 688, 5, 14}, {354, 688, 5, 14}, {385, 688, 4, 14}, 
  {398, 688, 4, 14}, {462, 688, 5, 14}, {165, 704, 5, 14}, {176, 704, 6, 14}, 
  {248, 704, 5, 14}, {355, 704, 5, 14}, {450, 704, 4, 14}, {68, 721, 5, 14}, 
  {56, 737, 5, 14}, {265, 737, 5, 14}, {387, 737, 5, 14}, {518, 737, 5, 14}, 
  {56, 754, 5, 14}, {87, 754, 5, 14}, {146, 754, 7, 14}, {167, 754, 5, 14}, 
  {178, 754, 5, 14}, {464, 754, 5, 14}, {80, 770, 5, 15}, {69, 57, 5, 14}, 
  {159, 57, 5, 14}, {244, 57, 5, 14}, {273, 57, 5, 14}, {399, 57, 5, 14}, 
  {470, 57, 5, 14}, {188, 73, 4, 15}, {203, 73, 4, 15}, {213, 73, 5, 15}, 
  {257, 73, 4, 15}, {306, 73, 5, 15}, {377, 73, 5, 15}, {400, 73, 4, 15}, 
  {478, 73, 5, 15}, {510, 73, 5, 15}, {81, 90, 5, 14}, {92, 90, 6, 14}, 
  {104, 90, 5, 14}, {136, 90, 4, 14}, {140, 90, 5, 14}, {206, 90, 5, 14}, 
  {219, 90, 5, 14}, {334, 90, 5, 14}, {233, 106, 5, 15}, {246, 106, 5, 15}, 
  {282, 106, 5, 15}, {327, 106, 5, 15}, {371, 106, 5, 15}, {382, 106, 4, 15}, 
  {420, 106, 5, 15}, {483, 106, 5, 15}, {112, 123, 4, 14}, {141, 123, 4, 14}, 
  {172, 123, 5, 14}, {244, 123, 5, 14}, {296, 123, 4, 14}, {356, 123, 5, 14}, 
  {421, 123, 4, 14}, {500, 123, 5, 14}, {83, 140, 5, 14}, {131, 140, 5, 14}, 
  {155, 140, 5, 14}, {236, 140, 5, 14}, {113, 163, 4, 14}, {117, 163, 5, 14}, 
  {138, 163, 4, 14}, {183, 163, 4, 14}, {207, 163, 4, 14}, {237, 163, 5, 14}, 
  {284, 163, 5, 14}, {372, 163, 4, 14}, {520, 163, 4, 14}, {94, 180, 5, 14}, 
  {138, 180, 5, 14}, {266, 180, 5, 14}, {274, 180, 5, 14}, {97, 196, 5, 14}, 
  {108, 196, 6, 14}, {120, 196, 5, 14}, {152, 196, 4, 14}, {156, 196, 5, 14}, 
  {193, 196, 5, 14}, {219, 196, 4, 14}, {299, 196, 5, 14}, {304, 196, 5, 14}, 
  {334, 196, 5, 14}, {351, 196, 4, 14}, {382, 196, 5, 14}, {514, 196, 4, 14}, 
  {66, 213, 4, 14}, {138, 213, 5, 14}, {170, 213, 5, 14}, {193, 213, 5, 14}, 
  {224, 213, 4, 14}, {253, 213, 4, 14}, {296, 213, 5, 14}, {432, 213, 5, 14}, 
  {464, 213, 5, 14}, {143, 229, 5, 14}, {154, 229, 4, 14}, {177, 229, 5, 14}, 
  {207, 229, 5, 14}, {258, 229, 5, 14}, {311, 229, 5, 14}, {376, 229, 5, 14}, 
  {439, 229, 4, 14}, {456, 229, 4, 14}, {71, 246, 5, 14}, {76, 246, 4, 14}, 
  {141, 246, 4, 14}, {231, 246, 4, 14}, {293, 246, 5, 14}, {453, 246, 5, 14}, 
  {159, 262, 4, 15}, {242, 262, 5, 15}, {292, 262, 5, 15}, {354, 262, 5, 15}, 
  {394, 262, 7, 15}, {431, 262, 5, 15}, {448, 262, 5, 15}, {518, 262, 4, 15}, 
  {104, 279, 5, 14}, {160, 279, 5, 14}, {183, 279, 4, 14}, {285, 279, 4, 14}, 
  {382, 279, 4, 14}, {431, 279, 5, 14}, {482, 279, 5, 14}, {94, 295, 7, 15}, 
  {107, 295, 5, 15}, {138, 295, 5, 15}, {143, 295, 5, 15}, {156, 295, 5, 15}, 
  {482, 295, 4, 15}, {89, 312, 5, 14}, {108, 312, 5, 14}, {170, 312, 4, 14}, 
  {235, 312, 5, 14}, {69, 336, 5, 14}, {181, 336, 5, 14}, {344, 336, 4, 14}, 
  {489, 336, 5, 14}, {520, 336, 5, 14}, {148, 352, 5, 14}, {217, 352, 5, 14}, 
  {250, 352, 5, 14}, {258, 352, 5, 14}, {336, 352, 5, 14}, {455, 352, 4, 14}, 
  {480, 352, 5, 14}, {81, 369, 5, 14}, {112, 369, 4, 14}, {170, 369, 5, 14}, 
  {202, 369, 4, 14}, {324, 369, 5, 14}, {356, 369, 5, 14}, {466, 369, 5, 14}, 
  {506, 369, 4, 14}, {78, 385, 4, 14}, {135, 385, 5, 14}, {219, 385, 5, 14}, 
  {325, 385, 5, 14}, {356, 385, 4, 14}, {378, 385, 5, 14}, {383, 385, 4, 14}, 
  {185, 402, 4, 14}, {250, 402, 5, 14}, {322, 402, 5, 14}, {390, 402, 5, 14}, 
  {454, 402, 4, 14}, {80, 418, 5, 15}, {115, 418, 5, 15}, {154, 418, 5, 15}, 
  {200, 418, 4, 15}, {228, 418, 5, 15}, {359, 418, 4, 15}, {446, 418, 4, 15}, 
  {469, 418, 4, 15}, {74, 435, 5, 14}, {138, 435, 5, 14}, {69, 458, 5, 15}, 
  {221, 458, 4, 15}, {312, 458, 5, 15}, {320, 458, 4, 15}, {392, 458, 4, 15}, 
  {402, 458, 7, 15}, {448, 458, 5, 15}, {521, 458, 4, 15}, {181, 475, 4, 14}, 
  {206, 475, 4, 14}, {277, 475, 5, 14}, {313, 475, 5, 14}, {428, 475, 4, 14}, 
  {495, 475, 4, 14}, {56, 492, 5, 14}, {129, 492, 5, 14}, {175, 492, 4, 14}, 
  {270, 492, 4, 14}, {274, 492, 5, 14}, {352, 492, 5, 14}, {404, 492, 5, 14}, 
  {506, 492, 4, 14}, {516, 492, 5, 14}, {56, 508, 5, 14}, {122, 508, 5, 14}, 
  {191, 508, 5, 14}, {299, 508, 5, 14}, {514, 508, 5, 14}, {525, 508, 6, 14}, 
  {101, 525, 5, 14}, {145, 525, 5, 14}, {261, 525, 5, 14}, {316, 525, 4, 14}, 
  {348, 525, 5, 14}, {495, 525, 5, 14}, {107, 548, 4, 14}, {164, 548, 4, 14}, 
  {228, 548, 7, 14}, {324, 548, 4, 14}, {445, 548, 5, 14}, {468, 548, 5, 14}, 
  {158, 565, 5, 14}, {190, 565, 4, 14}, {322, 565, 5, 14}, {345, 565, 5, 14}, 
  {429, 565, 5, 14}, {440, 565, 4, 14}, {67, 581, 5, 14}, {216, 581, 5, 14}, 
  {304, 581, 7, 14}, {356, 581, 5, 14}, {468, 581, 4, 14}, {82, 598, 4, 14}, 
  {111, 598, 4, 14}, {167, 598, 5, 14}, {207, 598, 5, 14}, {260, 598, 4, 14}, 
  {329, 598, 4, 14}, {349, 598, 5, 14}, {394, 598, 4, 14}, {404, 598, 5, 14}, 
  {428, 598, 4, 14}, {529, 598, 6, 14}, {121, 614, 4, 15}, {189, 614, 5, 15}, 
  {314, 614, 5, 15}, {319, 614, 5, 15}, {410, 614, 4, 15}, {452, 614, 4, 15}, 
  {56, 631, 5, 14}, {116, 631, 4, 14}, {179, 631, 4, 14}, {203, 631, 5, 14}, 
  {216, 631, 5, 14}, {263, 631, 5, 14}, {271, 631, 5, 14}, {429, 631, 5, 14}, 
  {452, 631, 4, 14}, {502, 631, 5, 14}, {150, 647, 4, 15}, {238, 647, 5, 15}, 
  {270, 647, 5, 15}, {370, 647, 5, 15}, {384, 647, 4, 15}, {413, 647, 5, 15}, 
  {74, 671, 4, 14}, {150, 671, 5, 14}, {275, 671, 5, 14}, {316, 671, 4, 14}, 
  {485, 671, 4, 14}, {177, 688, 5, 14}, {211, 688, 5, 14}, {306, 688, 5, 14}, 
  {491, 688, 5, 14}, {502, 688, 5, 14}, {127, 704, 4, 14}, {154, 704, 5, 14}, 
  {159, 704, 4, 14}, {226, 704, 4, 14}, {251, 704, 5, 14}, {427, 704, 5, 14}, 
  {504, 704, 6, 14}, {103, 721, 5, 14}, {143, 721, 5, 14}, {240, 721, 5, 14}, 
  {251, 721, 5, 14}, {391, 721, 5, 14}, {455, 721, 5, 14}, {479, 721, 5, 14}, 
  {490, 721, 4, 14}, {56, 737, 5, 14}, {88, 737, 4, 14}, {204, 737, 5, 14}, 
  {248, 737, 5, 14}, {327, 737, 5, 14}, {376, 737, 5, 14}, {418, 737, 5, 14}, 
  {432, 737, 4, 14}, {80, 754, 5, 14}, {151, 754, 5, 14}, {253, 754, 4, 14}, 
  {263, 754, 5, 14}, {322, 754, 5, 14}, {390, 754, 5, 14}, {455, 754, 5, 14}, 
  {487, 754, 5, 14}, {126, 770, 4, 15}, {176, 770, 5, 15}, {225, 770, 4, 15}, 
  {238, 770, 4, 15}, {433, 770, 5, 15}, {56, 57, 5, 14}, {67, 57, 5, 14}, 
  {127, 57, 5, 14}, {187, 57, 5, 14}, {252, 57, 5, 14}, {435, 57, 5, 14}, 
  {84, 73, 5, 15}, {143, 73, 5, 15}, {174, 73, 5, 15}, {250, 73, 5, 15}, 
  {310, 73, 4, 15}, {441, 73, 5, 15}, {86, 90, 5, 14}, {74, 113, 4, 15}, 
  {105, 113, 5, 15}, {125, 113, 5, 15}, {136, 113, 4, 15}, {186, 113, 5, 15}, 
  {233, 113, 4, 15}, {272, 113, 5, 15}, {297, 113, 5, 15}, {69, 130, 5, 14}, 
  {183, 130, 4, 14}, {238, 130, 5, 14}, {311, 130, 5, 14}, {341, 130, 5, 14}, 
  {352, 130, 6, 14}, {364, 130, 5, 14}, {395, 130, 5, 14}, {400, 130, 5, 14}, 
  {95, 147, 5, 14}, {126, 147, 5, 14}, {172, 147, 5, 14}, {209, 147, 5, 14}, 
  {220, 147, 5, 14}, {392, 147, 5, 14}, {397, 147, 4, 14}, {475, 147, 4, 14}, 
  {97, 163, 5, 14}, {308, 163, 5, 14}, {423, 163, 5, 14}, {446, 163, 4, 14}, 
  {154, 180, 5, 14}, {342, 180, 5, 14}, {384, 180, 5, 14}, {56, 196, 5, 14}, 
  {223, 220, 5, 14}, {442, 220, 5, 14}, {497, 220, 4, 14}, {80, 236, 4, 14}, 
  {108, 236, 5, 14}, {139, 236, 5, 14}, {204, 236, 5, 14}, {364, 236, 5, 14}, 
  {396, 236, 5, 14}, {445, 236, 5, 14}, {450, 236, 4, 14}, {512, 236, 5, 14}, 
  {95, 253, 5, 14}, {133, 253, 5, 14}, {141, 253, 5, 14}, {203, 253, 4, 14}, 
  {301, 253, 5, 14}, {306, 253, 4, 14}, {384, 253, 4, 14}, {480, 253, 4, 14}, 
  {80, 269, 5, 15}, {134, 269, 5, 15}, {183, 269, 5, 15}, {239, 269, 5, 15}, 
  {262, 269, 5, 15}, {341, 269, 4, 15}, {410, 269, 5, 15}, {446, 269, 4, 15}, 
  {459, 269, 5, 15}, {482, 269, 5, 15}, {56, 286, 7, 14}, {69, 286, 5, 14}, 
  {100, 286, 5, 14}, {105, 286, 5, 14}, {261, 286, 5, 14}, {443, 286, 5, 14}, 
  {458, 286, 5, 14}, {469, 286, 5, 14}, {86, 302, 5, 15}, {139, 302, 5, 15}, 
  {297, 302, 5, 15}, {387, 302, 5, 15}, {437, 302, 4, 15}, {454, 302, 4, 15}, 
  {86, 319, 5, 14}, {108, 319, 5, 14}, {177, 319, 5, 14}, {200, 319, 5, 14}, 
  {229, 319, 5, 14}, {285, 319, 5, 14}, {349, 319, 5, 14}, {404, 319, 5, 14}, 
  {448, 319, 4, 14}, {477, 319, 5, 14}, {494, 319, 5, 14}, {56, 336, 5, 14}, 
  {67, 336, 5, 14}, {225, 336, 5, 14}, {465, 336, 5, 14}, {473, 336, 5, 14}, 
  {484, 336, 4, 14}, {154, 376, 5, 14}, {171, 376, 5, 14}, {323, 376, 4, 14}, 
  {354, 376, 5, 14}, {394, 376, 5, 14}, {472, 376, 4, 14}, {74, 392, 4, 14}, 
  {172, 392, 7, 14}, {215, 392, 5, 14}, {271, 392, 4, 14}, {313, 392, 5, 14}, 
  {324, 392, 4, 14}, {397, 392, 4, 14}, {474, 392, 5, 14}, {100, 409, 4, 14}, 
  {164, 409, 5, 14}, {298, 409, 5, 14}, {530, 409, 6, 14}, {78, 449, 4, 14}, 
  {115, 449, 5, 14}, {184, 449, 5, 14}, {275, 449, 5, 14}, {324, 449, 5, 14}, 
  {501, 449, 5, 14}, {168, 465, 5, 15}, {208, 465, 5, 15}, {329, 465, 5, 15}, 
  {387, 465, 5, 15}, {392, 465, 4, 15}, {417, 465, 4, 15}, {460, 465, 6, 15}, 
  {514, 465, 5, 15}, {125, 482, 5, 14}, {177, 482, 5, 14}, {268, 482, 5, 14}, 
  {411, 482, 5, 14}, {424, 482, 5, 14}, {486, 482, 5, 14}, {252, 499, 5, 14}, 
  {257, 499, 4, 14}, {308, 499, 5, 14}, {327, 499, 5, 14}, {411, 499, 5, 14}, 
  {488, 499, 5, 14}, {56, 515, 5, 14}, {67, 515, 5, 14}, {118, 515, 5, 14}, 
  {140, 515, 5, 14}, {145, 515, 5, 14}, {286, 515, 5, 14}, {322, 515, 5, 14}, 
  {56, 532, 7, 14}, {69, 532, 5, 14}, {100, 532, 5, 14}, {105, 532, 5, 14}, 
  {163, 532, 5, 14}, {168, 532, 5, 14}, {261, 532, 5, 14}, {296, 532, 5, 14}, 
  {304, 532, 5, 14}, {361, 532, 5, 14}, {430, 532, 5, 14}, {463, 532, 4, 14}, 
  {471, 532, 4, 14}, {502, 532, 5, 14}, {89, 548, 4, 14}, {93, 548, 5, 14}, 
  {211, 548, 5, 14}, {222, 548, 5, 14}, {78, 572, 4, 14}, {111, 572, 5, 14}, 
  {195, 572, 5, 14}, {316, 572, 4, 14}, {346, 572, 5, 14}, {81, 588, 5, 14}, 
  {109, 588, 4, 14}, {116, 588, 5, 14}, {188, 588, 5, 14}, {219, 588, 5, 14}, 
  {311, 588, 5, 14}, {344, 588, 4, 14}, {379, 588, 5, 14}, {446, 588, 5, 14}, 
  {478, 588, 5, 14}, {56, 605, 5, 14}, {87, 605, 5, 14}, {123, 605, 5, 14}, 
  {134, 605, 4, 14}, {227, 605, 5, 14}, {334, 605, 4, 14}, {347, 605, 5, 14}, 
  {355, 605, 4, 14}, {460, 605, 5, 14}, {471, 605, 6, 14}, {483, 605, 5, 14}, 
  {515, 605, 4, 14}, {519, 605, 5, 14}, {194, 621, 4, 15}, {240, 621, 5, 15}, 
  {273, 621, 4, 15}, {342, 621, 4, 15}, {359, 621, 4, 15}, {490, 621, 4, 15}, 
  {125, 638, 5, 14}, {150, 638, 5, 14}, {252, 638, 4, 14}, {344, 638, 5, 14}, 
  {355, 638, 7, 14}, {387, 638, 5, 14}, {451, 638, 4, 14}, {72, 654, 5, 15}, 
  {151, 654, 5, 15}, {118, 678, 5, 14}, {226, 678, 5, 14}, {307, 678, 4, 14}, 
  {315, 678, 4, 14}, {391, 678, 5, 14}, {505, 678, 4, 14}, {131, 695, 4, 14}, 
  {331, 695, 4, 14}, {74, 711, 4, 14}, {133, 711, 5, 14}, {343, 711, 5, 14}, 
  {412, 711, 5, 14}, {453, 711, 4, 14}, {97, 728, 5, 14}, {222, 728, 5, 14}, 
  {391, 728, 5, 14}, {399, 728, 4, 14}, {428, 728, 5, 14}, {483, 728, 4, 14}, 
  {513, 728, 6, 14}, {72, 744, 4, 14}, {172, 744, 5, 14}, {195, 744, 5, 14}, 
  {249, 744, 5, 14}, {367, 744, 5, 14}, {440, 744, 4, 14}, {484, 744, 4, 14}, 
  {101, 57, 4, 14}, {176, 57, 4, 14}, {250, 57, 5, 14}, {258, 57, 5, 14}, 
  {319, 57, 5, 14}, {344, 57, 5, 14}, {374, 57, 5, 14}, {433, 57, 4, 14}, 
  {441, 57, 4, 14}, {62, 73, 4, 15}, {95, 73, 4, 15}, {191, 97, 5, 14}, 
  {204, 97, 5, 14}, {328, 97, 5, 14}, {400, 97, 4, 14}, {404, 97, 5, 14}, 
  {449, 97, 4, 14}, {495, 97, 5, 14}, {94, 113, 5, 15}, {125, 113, 5, 15}, 
  {244, 113, 5, 15}, {252, 113, 5, 15}, {260, 113, 5, 15}, {289, 113, 5, 15}, 
  {389, 113, 4, 15}, {107, 130, 5, 14}, {115, 130, 4, 14}, {125, 130, 5, 14}, 
  {313, 130, 4, 14}, {349, 130, 4, 14}, {80, 147, 4, 14}, {127, 147, 4, 14}, 
  {140, 147, 5, 14}, {199, 147, 5, 14}, {378, 147, 5, 14}, {408, 147, 4, 14}, 
  {425, 147, 4, 14}, {512, 147, 6, 14}, {79, 163, 5, 14}, {215, 163, 5, 14}, 
  {245, 163, 5, 14}, {366, 163, 5, 14}, {80, 180, 4, 14}, {134, 180, 5, 14}, 
  {187, 180, 5, 14}, {236, 180, 5, 14}, {292, 180, 5, 14}, {320, 180, 5, 14}, 
  {395, 180, 5, 14}, {484, 180, 5, 14}, {147, 196, 5, 14}, {290, 196, 5, 14}, 
  {319, 196, 5, 14}, {387, 196, 5, 14}, {479, 196, 4, 14}, {100, 213, 5, 14}, 
  {146, 213, 5, 14}, {192, 213, 5, 14}, {279, 213, 5, 14}, {355, 213, 5, 14}, 
  {412, 213, 4, 14}, {464, 213, 4, 14}, {496, 213, 5, 14}, {101, 229, 5, 14}, 
  {164, 229, 5, 14}, {202, 229, 5, 14}, {240, 229, 5, 14}, {380, 229, 5, 14}, 
  {78, 246, 5, 14}, {74, 269, 4, 15}, {105, 269, 4, 15}, {135, 269, 5, 15}, 
  {178, 269, 5, 15}, {289, 269, 5, 15}, {354, 269, 5, 15}, {399, 269, 5, 15}, 
  {446, 269, 5, 15}, {490, 269, 5, 15}, {495, 269, 5, 15}, {146, 286, 4, 14}, 
  {207, 286, 5, 14}, {415, 286, 5, 14}, {84, 302, 5, 15}, {164, 302, 5, 15}, 
  {193, 302, 5, 15}, {386, 302, 5, 15}, {465, 302, 4, 15}, {475, 302, 5, 15}, 
  {104, 319, 5, 14}, {109, 319, 4, 14}, {252, 319, 5, 14}, {423, 319, 7, 14}, 
  {74, 336, 5, 14}, {97, 336, 5, 14}, {140, 336, 5, 14}, {159, 336, 5, 14}, 
  {231, 336, 4, 14}, {307, 336, 5, 14}, {329, 336, 5, 14}, {397, 336, 5, 14}, 
  {452, 336, 4, 14}, {479, 336, 5, 14}, {190, 376, 5, 14}, {307, 376, 5, 14}, 
  {324, 376, 4, 14}, {503, 376, 5, 14}, {197, 392, 5, 14}, {229, 392, 5, 14}, 
  {252, 392, 4, 14}, {281, 392, 4, 14}, {318, 392, 5, 14}, {349, 392, 4, 14}, 
  {366, 392, 4, 14}, {402, 392, 5, 14}, {420, 392, 5, 14}, {280, 409, 5, 14}, 
  {378, 409, 5, 14}, {409, 409, 4, 14}, {416, 409, 5, 14}, {502, 409, 5, 14}, 
  {78, 425, 4, 15}, {116, 425, 5, 15}, {97, 442, 5, 14}, {143, 442, 4, 14}, 
  {225, 442, 5, 14}, {255, 442, 5, 14}, {272, 442, 5, 14}, {360, 442, 5, 14}, 
  {417, 442, 5, 14}, {488, 442, 4, 14}, {95, 482, 5, 14}, {161, 482, 4, 14}, 
  {263, 482, 5, 14}, {327, 482, 5, 14}, {374, 482, 5, 14}, {382, 482, 4, 14}, 
  {433, 482, 4, 14}, {73, 499, 5, 14}, {86, 499, 5, 14}, {157, 499, 5, 14}, 
  {202, 499, 5, 14}, {324, 499, 5, 14}, {356, 499, 4, 14}, {95, 515, 5, 14}, 
  {156, 515, 5, 14}, {164, 515, 4, 14}, {258, 515, 5, 14}, {399, 515, 5, 14}, 
  {478, 515, 4, 14}, {121, 532, 7, 14}, {166, 532, 5, 14}, {202, 532, 4, 14}, 
  {356, 532, 5, 14}, {393, 532, 5, 14}, {450, 532, 5, 14}, {495, 532, 4, 14}, 
  {90, 548, 5, 14}, {194, 548, 5, 14}, {241, 548, 5, 14}, {369, 548, 5, 14}, 
  {485, 548, 5, 14}, {508, 548, 4, 14}, {107, 565, 5, 14}, {112, 565, 5, 14}, 
  {163, 565, 5, 14}, {212, 565, 5, 14}, {242, 565, 4, 14}, {172, 588, 5, 14}, 
  {201, 588, 5, 14}, {271, 588, 5, 14}, {293, 588, 5, 14}, {298, 588, 4, 14}, 
  {358, 588, 5, 14}, {418, 588, 5, 14}, {473, 588, 5, 14}, {520, 588, 5, 14}, 
  {69, 605, 5, 14}, {174, 605, 5, 14}, {201, 605, 4, 14}, {224, 605, 4, 14}, 
  {247, 605, 4, 14}, {257, 605, 5, 14}, {365, 605, 5, 14}, {376, 605, 4, 14}, 
  {386, 605, 5, 14}, {458, 605, 5, 14}, {66, 621, 4, 15}, {132, 621, 4, 15}, 
  {163, 621, 5, 15}, {243, 621, 5, 15}, {401, 621, 5, 15}, {445, 621, 4, 15}, 
  {505, 621, 5, 15}, {56, 638, 5, 14}, {88, 638, 4, 14}, {232, 638, 5, 14}, 
  {337, 638, 5, 14}, {360, 638, 5, 14}, {371, 638, 4, 14}, {404, 638, 4, 14}, 
  {414, 638, 7, 14}, {474, 638, 5, 14}, {80, 654, 4, 15}, {276, 654, 5, 15}, 
  {318, 654, 5, 15}, {422, 654, 5, 15}, {525, 654, 4, 15}, {529, 654, 6, 15}, 
  {116, 671, 4, 14}, {141, 671, 5, 14}, {317, 671, 5, 14}, {394, 671, 5, 14}, 
  {449, 671, 4, 14}, {56, 688, 5, 14}, {87, 688, 5, 14}, {104, 688, 5, 14}, 
  {224, 688, 4, 14}, {112, 711, 5, 14}, {162, 711, 5, 14}, {236, 711, 5, 14}, 
  {283, 711, 4, 14}, {320, 711, 5, 14}, {369, 711, 5, 14}, {426, 711, 5, 14}, 
  {71, 728, 5, 14}, {76, 728, 4, 14}, {107, 728, 5, 14}, {208, 728, 5, 14}, 
  {231, 728, 5, 14}, {268, 728, 5, 14}, {344, 728, 5, 14}, {382, 728, 5, 14}, 
  {423, 728, 4, 14}, {472, 728, 5, 14}, {519, 728, 4, 14}, {159, 744, 5, 14}, 
  {235, 744, 4, 14}, {257, 744, 5, 14}, {320, 744, 5, 14}, {445, 744, 4, 14}, 
  {120, 57, 5, 14}, {137, 57, 5, 14}, {381, 57, 5, 14}, {491, 57, 5, 14}, 
  {74, 73, 4, 15}, {101, 97, 5, 14}, {132, 97, 5, 14}, {149, 97, 5, 14}, 
  {166, 97, 5, 14}, {211, 97, 5, 14}, {327, 97, 5, 14}, {408, 97, 5, 14}, 
  {480, 97, 4, 14}, {99, 113, 5, 15}, {198, 113, 5, 15}, {258, 113, 4, 15}, 
  {282, 113, 5, 15}, {351, 113, 5, 15}, {359, 113, 5, 15}, {498, 113, 5, 15}, 
  {259, 130, 4, 14}, {305, 130, 5, 14}, {357, 130, 5, 14}, {409, 130, 4, 14}, 
  {450, 130, 5, 14}, {94, 147, 5, 14}, {177, 147, 5, 14}, {220, 147, 5, 14}, 
  {290, 147, 5, 14}, {295, 147, 5, 14}, {364, 147, 5, 14}, {467, 147, 5, 14}, 
  {514, 147, 5, 14}, {522, 147, 6, 14}, {84, 163, 4, 14}, {115, 163, 5, 14}, 
  {261, 163, 4, 14}, {293, 163, 5, 14}, {396, 163, 5, 14}, {401, 163, 5, 14}, 
  {80, 180, 4, 14}, {161, 180, 5, 14}, {216, 180, 5, 14}, {432, 180, 5, 14}, 
  {504, 180, 6, 14}, {56, 196, 5, 14}, {88, 196, 4, 14}, {268, 196, 4, 14}, 
  {373, 196, 5, 14}, {452, 196, 5, 14}, {475, 196, 4, 14}, {126, 213, 5, 14}, 
  {157, 213, 5, 14}, {318, 213, 5, 14}, {489, 213, 5, 14}, {128, 229, 5, 14}, 
  {236, 229, 5, 14}, {302, 253, 5, 14}, {435, 253, 5, 14}, {450, 253, 5, 14}, 
  {461, 253, 4, 14}, {98, 269, 5, 15}, {151, 269, 5, 15}, {182, 269, 4, 15}, 
  {215, 269, 5, 15}, {334, 269, 4, 15}, {388, 269, 5, 15}, {442, 269, 4, 15}, 
  {491, 269, 4, 15}, {92, 286, 5, 14}, {121, 286, 5, 14}, {179, 286, 5, 14}, 
  {209, 286, 5, 14}, {217, 286, 4, 14}, {279, 286, 5, 14}, {290, 286, 4, 14}, 
  {350, 286, 5, 14}, {439, 286, 5, 14}, {80, 302, 5, 15}, {141, 302, 4, 15}, 
  {172, 302, 5, 15}, {273, 302, 4, 15}, {414, 302, 4, 15}, {104, 319, 5, 14}, 
  {339, 319, 5, 14}, {385, 319, 4, 14}, {69, 336, 5, 14}, {247, 336, 5, 14}, 
  {258, 336, 5, 14}, {305, 336, 7, 14}, {379, 336, 5, 14}, {469, 336, 5, 14}, 
  {84, 352, 5, 14}, {116, 376, 5, 14}, {124, 376, 4, 14}, {154, 376, 5, 14}, 
  {502, 376, 4, 14}, {81, 392, 5, 14}, {86, 392, 4, 14}, {122, 392, 5, 14}, 
  {326, 392, 4, 14}, {428, 392, 5, 14}, {484, 392, 4, 14}, {515, 392, 5, 14}, 
  {56, 409, 7, 14}, {118, 409, 5, 14}, {203, 409, 4, 14}, {210, 409, 5, 14}, 
  {241, 409, 5, 14}, {422, 409, 5, 14}, {439, 409, 5, 14}, {482, 409, 4, 14}, 
  {112, 425, 5, 15}, {135, 425, 5, 15}, {188, 425, 5, 15}, {407, 425, 5, 15}, 
  {420, 425, 5, 15}, {516, 425, 5, 15}, {530, 425, 4, 15}, {81, 442, 5, 14}, 
  {116, 442, 7, 14}, {365, 442, 5, 14}, {450, 442, 5, 14}, {455, 442, 5, 14}, 
  {90, 458, 4, 15}, {104, 458, 6, 15}, {116, 458, 5, 15}, {148, 458, 4, 15}, 
  {152, 458, 5, 15}, {213, 458, 5, 15}, {298, 458, 4, 15}, {94, 482, 5, 14}, 
  {346, 482, 4, 14}, {400, 482, 5, 14}, {423, 482, 5, 14}, {503, 482, 5, 14}, 
  {514, 482, 5, 14}, {111, 499, 4, 14}, {176, 499, 5, 14}, {189, 499, 5, 14}, 
  {242, 499, 5, 14}, {272, 499, 5, 14}, {379, 499, 4, 14}, {407, 499, 5, 14}, 
  {482, 499, 4, 14}, {122, 515, 4, 14}, {170, 515, 5, 14}, {219, 515, 5, 14}, 
  {232, 515, 5, 14}, {313, 515, 6, 14}, {325, 515, 5, 14}, {357, 515, 4, 14}, 
  {361, 515, 5, 14}, {413, 515, 5, 14}, {437, 515, 4, 14}, {127, 532, 4, 14}, 
  {208, 532, 5, 14}, {248, 532, 5, 14}, {279, 532, 4, 14}, {68, 548, 5, 14}, 
  {177, 548, 4, 14}, {243, 548, 4, 14}, {250, 548, 5, 14}, {322, 548, 5, 14}, {333, 548, 5, 14} }, // rects
  { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
  10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
  17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
  18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
  19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
  20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 
  21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 
  22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
  23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
  25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25 } }; // pages

RegressSearchInfo data_ut_efficitur = {
  L"ut efficitur",
  2, // matches
  { 1, 1 }, // rectCounts
  { {164, 319, 54, 14}, {199, 425, 51, 15} }, // rects
  { 2, 25 } }; // pages

RegressSearchInfo data_sem_eu_augue_pellentesque_accumsan = {
  L"sem eu augue pellentesque accumsan",
  1, // matches
  { 2 }, // rectCounts
  { {455, 768, 66, 14}, {56, 57, 111, 14} }, // rects
  { 9, 10 } }; // pages

RegressSearchInfo data_convallis_libero_nibh = {
  L"convallis libero nibh",
  1, // matches
  { 2 }, // rectCounts
  { {479, 744, 44, 14}, {56, 57, 53, 14} }, // rects
  { 8, 9 } }; // pages
