/*
 * Copyright 2015 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.samples.apps.iosched.framework;

import android.content.Context;

/**
 * A Presenter acts as a controller for both the {@link UpdatableView} (typically a fragment) and
 * the {@link Model} for the MVP architectural pattern.
 * <p />
 * The Presenter listens to events generated by the {@link UpdatableView}, and passes them on to
 * the {@link Model}, which modifies its data as required. The Presenter also listens to events
 * generated by the {@link Model} and then asks the {@link UpdatableView} to update itself.
 */
public interface Presenter {


    /**
     * Sets the {@code model} this Presenter controls.
     */
    public void setModel(Model model);

    /**
     * Sets the {@code view} this Presenter controls.
     */
    public void setUpdatableView(UpdatableView view);


    /**
     * Sets the {@code queries} to load when the {@link android.app.Activity} using this Presenter
     * is created.
     */
    public void setInitialQueriesToLoad(QueryEnum[] queries);

    /**
     * Sets the user {@code actions} allowed by this Presenter.
     */
    public void setValidUserActions(UserActionEnum[] actions);

    /**
     * Cleans up all references to objects containing an {@link android.view.View} or
     * {@link android.content.Context} in order to help with garbage collection and
     * avoid memory leaks.
     */
    public void cleanUp();

    /**
     * @return the {@link android.content.Context} to which this Presenter is attached.
     */
    public Context getContext();
}