/*
 * Decompiled with CFR 0.152.
 */
package com.larvalabs.svgandroid;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.util.Log;
import com.larvalabs.svgandroid.SVG;

public class SVGDrawable
extends PictureDrawable {
    private final String TAG = "SVGDrawable";
    private SVGState mSvgState;

    public SVGDrawable(SVG svg) {
        super(svg.getPicture());
        this.mSvgState = new SVGState(svg);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
    }

    public void draw(Canvas canvas) {
        if (this.getPicture() != null) {
            Rect bounds = this.getBounds();
            canvas.save();
            canvas.drawPicture(this.getPicture(), bounds);
            canvas.restore();
        }
    }

    public int getChangingConfigurations() {
        int c = super.getChangingConfigurations() | this.mSvgState.mChangingConfigurations;
        Log.e((String)"SVGDrawable", (String)("CC = " + c));
        return c;
    }

    public Drawable.ConstantState getConstantState() {
        this.mSvgState.mChangingConfigurations = super.getChangingConfigurations();
        return this.mSvgState;
    }

    static final class SVGState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        private SVG mSvg;

        private SVGState(SVG svg) {
            this.mSvg = svg;
        }

        public Drawable newDrawable() {
            return new SVGDrawable(this.mSvg);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

