/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.youtube.player;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.google.android.youtube.player.internal.z;

public final class YouTubeIntents {
    private YouTubeIntents() {
    }

    public static boolean isYouTubeInstalled(Context context) {
        try {
            context.getPackageManager().getApplicationInfo(YouTubeIntents.a(context), 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static String getInstalledYouTubeVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)YouTubeIntents.a((Context)context), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static int getInstalledYouTubeVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)YouTubeIntents.a((Context)context), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    public static boolean canResolvePlayVideoIntent(Context context) {
        Uri uri = Uri.parse((String)"http://www.youtube.com/watch?v=");
        return YouTubeIntents.a(context, uri);
    }

    public static Intent createPlayVideoIntent(Context context, String string) {
        return YouTubeIntents.createPlayVideoIntentWithOptions(context, string, false, false);
    }

    public static boolean canResolvePlayVideoIntentWithOptions(Context context) {
        int n2 = YouTubeIntents.getInstalledYouTubeVersionCode(context);
        PackageManager packageManager = context.getPackageManager();
        return (z.b(packageManager) ? true : (z.a(packageManager) ? n2 >= Integer.MAX_VALUE : n2 >= 3300)) && YouTubeIntents.canResolvePlayVideoIntent(context);
    }

    public static Intent createPlayVideoIntentWithOptions(Context context, String string, boolean bl, boolean bl2) {
        String string2 = String.valueOf("http://www.youtube.com/watch?v=");
        String string3 = String.valueOf(string);
        string = Uri.parse((String)(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
        return YouTubeIntents.b(context, (Uri)string).putExtra("force_fullscreen", bl).putExtra("finish_on_ended", bl2);
    }

    public static boolean canResolveSearchIntent(Context context) {
        if (z.a(context.getPackageManager()) && YouTubeIntents.getInstalledYouTubeVersionCode(context) < 4700) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.SEARCH").setPackage(YouTubeIntents.a(context));
        return YouTubeIntents.a(context, intent);
    }

    public static Intent createSearchIntent(Context context, String string) {
        return YouTubeIntents.a(new Intent("android.intent.action.SEARCH").setPackage(YouTubeIntents.a(context)).putExtra("query", string), context);
    }

    public static boolean canResolveOpenPlaylistIntent(Context context) {
        Uri uri = Uri.parse((String)"http://www.youtube.com/playlist?list=");
        return YouTubeIntents.a(context, uri);
    }

    public static Intent createOpenPlaylistIntent(Context context, String string) {
        string = YouTubeIntents.a(string);
        return YouTubeIntents.a(YouTubeIntents.b(context, (Uri)string), context);
    }

    public static boolean canResolvePlayPlaylistIntent(Context context) {
        int n2 = YouTubeIntents.getInstalledYouTubeVersionCode(context);
        return (z.a(context.getPackageManager()) ? n2 >= 4700 : n2 >= 4000) && YouTubeIntents.canResolveOpenPlaylistIntent(context);
    }

    public static Intent createPlayPlaylistIntent(Context context, String string) {
        string = YouTubeIntents.a(string).buildUpon().appendQueryParameter("playnext", "1").build();
        return YouTubeIntents.a(YouTubeIntents.b(context, (Uri)string), context);
    }

    public static boolean canResolveUserIntent(Context context) {
        Uri uri = Uri.parse((String)"http://www.youtube.com/user/");
        return YouTubeIntents.a(context, uri);
    }

    public static Intent createUserIntent(Context context, String string) {
        String string2 = String.valueOf("http://www.youtube.com/user/");
        String string3 = String.valueOf(string);
        string = Uri.parse((String)(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
        return YouTubeIntents.b(context, (Uri)string);
    }

    public static boolean canResolveUploadIntent(Context context) {
        Intent intent = new Intent("com.google.android.youtube.intent.action.UPLOAD").setPackage(YouTubeIntents.a(context)).setType("video/*");
        return YouTubeIntents.a(context, intent);
    }

    public static Intent createUploadIntent(Context context, Uri uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("videoUri parameter cannot be null.");
        }
        if (!uri.toString().startsWith("content://media/")) {
            throw new IllegalArgumentException("videoUri parameter must be a URI pointing to a valid video file. It must begin with \"content://media/\"");
        }
        return YouTubeIntents.a(new Intent("com.google.android.youtube.intent.action.UPLOAD").setPackage(YouTubeIntents.a(context)).setDataAndType(uri, "video/*"), context);
    }

    private static boolean a(Context context, Uri uri) {
        uri = new Intent("android.intent.action.VIEW", uri).setPackage(YouTubeIntents.a(context));
        return YouTubeIntents.a(context, (Intent)uri);
    }

    private static Intent b(Context context, Uri uri) {
        return YouTubeIntents.a(new Intent("android.intent.action.VIEW", uri).setPackage(YouTubeIntents.a(context)), context);
    }

    static Intent a(Intent intent, Context context) {
        intent.putExtra("app_package", context.getPackageName()).putExtra("app_version", z.d(context)).putExtra("client_library_version", z.a());
        return intent;
    }

    private static boolean a(Context object, Intent intent) {
        return (object = object.getPackageManager().queryIntentActivities(intent, 65536)) != null && !object.isEmpty();
    }

    private static String a(Context context) {
        if (z.b((PackageManager)(context = context.getPackageManager()))) {
            return "com.google.android.youtube.tv";
        }
        if (z.a((PackageManager)context)) {
            return "com.google.android.youtube.googletv";
        }
        return "com.google.android.youtube";
    }

    private static Uri a(String string) {
        String string2 = String.valueOf("http://www.youtube.com/playlist?list=");
        String string3 = String.valueOf(string);
        return Uri.parse((String)(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
    }
}

