/*
 * Decompiled with CFR 0.152.
 */
package com.larvalabs.svgandroid;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.Log;
import com.larvalabs.svgandroid.ParserHelper;
import com.larvalabs.svgandroid.SVG;
import com.larvalabs.svgandroid.SVGParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser {
    static final String TAG = "SVGAndroid";

    public static SVG getSVGFromInputStream(InputStream inputStream) throws SVGParseException {
        return SVGParser.parse(inputStream, 0, 0, false);
    }

    public static SVG getSVGFromString(String string) throws SVGParseException {
        return SVGParser.parse(new ByteArrayInputStream(string.getBytes()), 0, 0, false);
    }

    public static SVG getSVGFromResource(Resources resources, int n) throws SVGParseException {
        return SVGParser.parse(resources.openRawResource(n), 0, 0, false);
    }

    public static SVG getSVGFromAsset(AssetManager assetManager, String string) throws SVGParseException, IOException {
        InputStream inputStream = assetManager.open(string);
        SVG sVG = SVGParser.getSVGFromInputStream(inputStream);
        inputStream.close();
        return sVG;
    }

    public static SVG getSVGFromInputStream(InputStream inputStream, int n, int n2) throws SVGParseException {
        return SVGParser.parse(inputStream, n, n2, false);
    }

    public static SVG getSVGFromString(String string, int n, int n2) throws SVGParseException {
        return SVGParser.parse(new ByteArrayInputStream(string.getBytes()), n, n2, false);
    }

    public static SVG getSVGFromResource(Resources resources, int n, int n2, int n3) throws SVGParseException {
        return SVGParser.parse(resources.openRawResource(n), n2, n3, false);
    }

    public static SVG getSVGFromAsset(AssetManager assetManager, String string, int n, int n2) throws SVGParseException, IOException {
        InputStream inputStream = assetManager.open(string);
        SVG sVG = SVGParser.getSVGFromInputStream(inputStream, n, n2);
        inputStream.close();
        return sVG;
    }

    public static Path parsePath(String string) {
        return SVGParser.doPath(string);
    }

    private static SVG parse(InputStream inputStream, Integer n, Integer n2, boolean bl) throws SVGParseException {
        try {
            long l = System.currentTimeMillis();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            Picture picture = new Picture();
            SVGHandler sVGHandler = new SVGHandler(picture);
            sVGHandler.setColorSwap(n, n2);
            sVGHandler.setWhiteMode(bl);
            xMLReader.setContentHandler(sVGHandler);
            xMLReader.parse(new InputSource(inputStream));
            SVG sVG = new SVG(picture, sVGHandler.bounds);
            if (!Float.isInfinite(sVGHandler.limits.top)) {
                sVG.setLimits(sVGHandler.limits);
            }
            return sVG;
        }
        catch (Exception exception) {
            throw new SVGParseException(exception);
        }
    }

    private static NumberParse parseNumbers(String string) {
        int n = string.length();
        int n2 = 0;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        boolean bl = false;
        block6: for (int i = 1; i < n; ++i) {
            if (bl) {
                bl = false;
                continue;
            }
            char c = string.charAt(i);
            switch (c) {
                case ')': 
                case 'C': 
                case 'H': 
                case 'L': 
                case 'M': 
                case 'Q': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Z': 
                case 'c': 
                case 'h': 
                case 'l': 
                case 'm': 
                case 'q': 
                case 's': 
                case 't': 
                case 'v': 
                case 'z': {
                    Float f;
                    String string2 = string.substring(n2, i);
                    if (string2.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(string2));
                        arrayList.add(f);
                    }
                    n2 = i;
                    return new NumberParse(arrayList, n2);
                }
                case '\t': 
                case '\n': 
                case ' ': 
                case ',': 
                case '-': {
                    Float f;
                    String string2 = string.substring(n2, i);
                    if (string2.trim().length() > 0) {
                        f = Float.valueOf(Float.parseFloat(string2));
                        arrayList.add(f);
                        if (c == '-') {
                            n2 = i;
                            continue block6;
                        }
                        n2 = i + 1;
                        bl = true;
                        continue block6;
                    }
                    ++n2;
                    continue block6;
                }
            }
        }
        String string3 = string.substring(n2);
        if (string3.length() > 0) {
            try {
                arrayList.add(Float.valueOf(Float.parseFloat(string3)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n2 = string.length();
        }
        return new NumberParse(arrayList, n2);
    }

    private static Matrix parseTransform(String string) {
        NumberParse numberParse;
        if (string.startsWith("matrix(")) {
            NumberParse numberParse2 = SVGParser.parseNumbers(string.substring("matrix(".length()));
            if (numberParse2.numbers.size() == 6) {
                Matrix matrix = new Matrix();
                matrix.setValues(new float[]{((Float)numberParse2.numbers.get(0)).floatValue(), ((Float)numberParse2.numbers.get(2)).floatValue(), ((Float)numberParse2.numbers.get(4)).floatValue(), ((Float)numberParse2.numbers.get(1)).floatValue(), ((Float)numberParse2.numbers.get(3)).floatValue(), ((Float)numberParse2.numbers.get(5)).floatValue(), 0.0f, 0.0f, 1.0f});
                return matrix;
            }
        } else if (string.startsWith("translate(")) {
            NumberParse numberParse3 = SVGParser.parseNumbers(string.substring("translate(".length()));
            if (numberParse3.numbers.size() > 0) {
                float f = ((Float)numberParse3.numbers.get(0)).floatValue();
                float f2 = 0.0f;
                if (numberParse3.numbers.size() > 1) {
                    f2 = ((Float)numberParse3.numbers.get(1)).floatValue();
                }
                Matrix matrix = new Matrix();
                matrix.postTranslate(f, f2);
                return matrix;
            }
        } else if (string.startsWith("scale(")) {
            NumberParse numberParse4 = SVGParser.parseNumbers(string.substring("scale(".length()));
            if (numberParse4.numbers.size() > 0) {
                float f = ((Float)numberParse4.numbers.get(0)).floatValue();
                float f3 = 0.0f;
                if (numberParse4.numbers.size() > 1) {
                    f3 = ((Float)numberParse4.numbers.get(1)).floatValue();
                }
                Matrix matrix = new Matrix();
                matrix.postScale(f, f3);
                return matrix;
            }
        } else if (string.startsWith("skewX(")) {
            NumberParse numberParse5 = SVGParser.parseNumbers(string.substring("skewX(".length()));
            if (numberParse5.numbers.size() > 0) {
                float f = ((Float)numberParse5.numbers.get(0)).floatValue();
                Matrix matrix = new Matrix();
                matrix.postSkew((float)Math.tan(f), 0.0f);
                return matrix;
            }
        } else if (string.startsWith("skewY(")) {
            NumberParse numberParse6 = SVGParser.parseNumbers(string.substring("skewY(".length()));
            if (numberParse6.numbers.size() > 0) {
                float f = ((Float)numberParse6.numbers.get(0)).floatValue();
                Matrix matrix = new Matrix();
                matrix.postSkew(0.0f, (float)Math.tan(f));
                return matrix;
            }
        } else if (string.startsWith("rotate(") && (numberParse = SVGParser.parseNumbers(string.substring("rotate(".length()))).numbers.size() > 0) {
            float f = ((Float)numberParse.numbers.get(0)).floatValue();
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (numberParse.numbers.size() > 2) {
                f4 = ((Float)numberParse.numbers.get(1)).floatValue();
                f5 = ((Float)numberParse.numbers.get(2)).floatValue();
            }
            Matrix matrix = new Matrix();
            matrix.postTranslate(f4, f5);
            matrix.postRotate(f);
            matrix.postTranslate(-f4, -f5);
            return matrix;
        }
        return null;
    }

    private static Path doPath(String string) {
        int n = string.length();
        ParserHelper parserHelper = new ParserHelper(string, 0);
        parserHelper.skipWhitespace();
        Path path = new Path();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        while (parserHelper.pos < n) {
            char c = string.charAt(parserHelper.pos);
            parserHelper.advance();
            boolean bl = false;
            switch (c) {
                case 'M': 
                case 'm': {
                    float f5 = parserHelper.nextFloat();
                    float f6 = parserHelper.nextFloat();
                    if (c == 'm') {
                        path.rMoveTo(f5, f6);
                        f += f5;
                        f2 += f6;
                        break;
                    }
                    path.moveTo(f5, f6);
                    f = f5;
                    f2 = f6;
                    break;
                }
                case 'Z': 
                case 'z': {
                    path.close();
                    break;
                }
                case 'L': 
                case 'l': {
                    float f5 = parserHelper.nextFloat();
                    float f6 = parserHelper.nextFloat();
                    if (c == 'l') {
                        path.rLineTo(f5, f6);
                        f += f5;
                        f2 += f6;
                        break;
                    }
                    path.lineTo(f5, f6);
                    f = f5;
                    f2 = f6;
                    break;
                }
                case 'H': 
                case 'h': {
                    float f5 = parserHelper.nextFloat();
                    if (c == 'h') {
                        path.rLineTo(f5, 0.0f);
                        f += f5;
                        break;
                    }
                    path.lineTo(f5, f2);
                    f = f5;
                    break;
                }
                case 'V': 
                case 'v': {
                    float f5 = parserHelper.nextFloat();
                    if (c == 'v') {
                        path.rLineTo(0.0f, f5);
                        f2 += f5;
                        break;
                    }
                    path.lineTo(f, f5);
                    f2 = f5;
                    break;
                }
                case 'C': 
                case 'c': {
                    bl = true;
                    float f5 = parserHelper.nextFloat();
                    float f6 = parserHelper.nextFloat();
                    float f7 = parserHelper.nextFloat();
                    float f8 = parserHelper.nextFloat();
                    float f9 = parserHelper.nextFloat();
                    float f10 = parserHelper.nextFloat();
                    if (c == 'c') {
                        f5 += f;
                        f7 += f;
                        f9 += f;
                        f6 += f2;
                        f8 += f2;
                        f10 += f2;
                    }
                    path.cubicTo(f5, f6, f7, f8, f9, f10);
                    f3 = f7;
                    f4 = f8;
                    f = f9;
                    f2 = f10;
                    break;
                }
                case 'S': 
                case 's': {
                    bl = true;
                    float f5 = parserHelper.nextFloat();
                    float f6 = parserHelper.nextFloat();
                    float f7 = parserHelper.nextFloat();
                    float f8 = parserHelper.nextFloat();
                    if (c == 's') {
                        f5 += f;
                        f7 += f;
                        f6 += f2;
                        f8 += f2;
                    }
                    float f9 = 2.0f * f - f3;
                    float f10 = 2.0f * f2 - f4;
                    path.cubicTo(f9, f10, f5, f6, f7, f8);
                    f3 = f5;
                    f4 = f6;
                    f = f7;
                    f2 = f8;
                    break;
                }
            }
            if (!bl) {
                f3 = f;
                f4 = f2;
            }
            parserHelper.skipWhitespace();
        }
        return path;
    }

    private static NumberParse getNumberParseAttr(String string, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals(string)) continue;
            return SVGParser.parseNumbers(attributes.getValue(i));
        }
        return null;
    }

    private static String getStringAttr(String string, Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals(string)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private static Float getFloatAttr(String string, Attributes attributes) {
        String string2 = SVGParser.getStringAttr(string, attributes);
        if (string2 == null) {
            return null;
        }
        if (string2.endsWith("px")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return Float.valueOf(Float.parseFloat(string2));
    }

    private static Integer getHexAttr(String string, Attributes attributes) {
        String string2 = SVGParser.getStringAttr(string, attributes);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2.substring(1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class SVGHandler
    extends DefaultHandler {
        Picture picture;
        Canvas canvas;
        Paint paint;
        RectF rect = new RectF();
        RectF bounds = null;
        RectF limits = new RectF(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Integer searchColor = null;
        Integer replaceColor = null;
        boolean whiteMode = false;
        HashMap<String, Shader> gradientMap = new HashMap();
        Gradient gradient = null;
        private boolean hidden = false;
        private int hiddenLevel = 0;
        private boolean boundsMode = false;

        private SVGHandler(Picture picture) {
            this.picture = picture;
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
        }

        public void setColorSwap(Integer n, Integer n2) {
            this.searchColor = n;
            this.replaceColor = n2;
        }

        public void setWhiteMode(boolean bl) {
            this.whiteMode = bl;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        private boolean doFill(Attributes attributes, HashMap<String, Shader> hashMap) {
            if ("none".equals(SVGParser.getStringAttr("display", attributes))) {
                return false;
            }
            if (this.whiteMode) {
                this.paint.setStyle(Paint.Style.FILL);
                this.paint.setColor(-1);
                return true;
            }
            String string = SVGParser.getStringAttr("fill", attributes);
            if (string != null && string.startsWith("url(#")) {
                String string2 = string.substring("url(#".length(), string.length() - 1);
                Shader shader = hashMap.get(string2);
                if (shader != null) {
                    this.paint.setShader(shader);
                    this.paint.setStyle(Paint.Style.FILL);
                    return true;
                }
                return false;
            }
            this.paint.setShader(null);
            Integer n = SVGParser.getHexAttr("fill", attributes);
            if (n != null) {
                this.doColor(attributes, n);
                this.paint.setStyle(Paint.Style.FILL);
                return true;
            }
            if (SVGParser.getStringAttr("fill", attributes) == null && SVGParser.getStringAttr("stroke", attributes) == null) {
                this.paint.setStyle(Paint.Style.FILL);
                this.paint.setColor(-16777216);
                return true;
            }
            return false;
        }

        private boolean doStroke(Attributes attributes) {
            if (this.whiteMode) {
                return false;
            }
            if ("none".equals(SVGParser.getStringAttr("display", attributes))) {
                return false;
            }
            Integer n = SVGParser.getHexAttr("stroke", attributes);
            if (n != null) {
                String string;
                this.doColor(attributes, n);
                Float f = SVGParser.getFloatAttr("stroke-width", attributes);
                if (f != null) {
                    this.paint.setStrokeWidth(f.floatValue());
                }
                if ("round".equals(string = SVGParser.getStringAttr("stroke-linecap", attributes))) {
                    this.paint.setStrokeCap(Paint.Cap.ROUND);
                } else if ("square".equals(string)) {
                    this.paint.setStrokeCap(Paint.Cap.SQUARE);
                } else if ("butt".equals(string)) {
                    this.paint.setStrokeCap(Paint.Cap.BUTT);
                }
                String string2 = SVGParser.getStringAttr("stroke-linejoin", attributes);
                if ("miter".equals(string2)) {
                    this.paint.setStrokeJoin(Paint.Join.MITER);
                } else if ("round".equals(string2)) {
                    this.paint.setStrokeJoin(Paint.Join.ROUND);
                } else if ("bevel".equals(string2)) {
                    this.paint.setStrokeJoin(Paint.Join.BEVEL);
                }
                this.paint.setStyle(Paint.Style.STROKE);
                return true;
            }
            return false;
        }

        private Gradient doGradient(boolean bl, Attributes attributes) {
            Gradient gradient = new Gradient();
            gradient.id = SVGParser.getStringAttr("id", attributes);
            gradient.isLinear = bl;
            if (bl) {
                gradient.x1 = SVGParser.getFloatAttr("x1", attributes).floatValue();
                gradient.x2 = SVGParser.getFloatAttr("x2", attributes).floatValue();
                gradient.y1 = SVGParser.getFloatAttr("y1", attributes).floatValue();
                gradient.y2 = SVGParser.getFloatAttr("y2", attributes).floatValue();
            } else {
                gradient.x = SVGParser.getFloatAttr("cx", attributes).floatValue();
                gradient.y = SVGParser.getFloatAttr("cy", attributes).floatValue();
                gradient.radius = SVGParser.getFloatAttr("r", attributes).floatValue();
            }
            String string = SVGParser.getStringAttr("gradientTransform", attributes);
            if (string != null) {
                gradient.matrix = SVGParser.parseTransform(string);
            }
            return gradient;
        }

        private void doColor(Attributes attributes, Integer n) {
            int n2 = 0xFFFFFF & n | 0xFF000000;
            if (this.searchColor != null && this.searchColor == n2) {
                n2 = this.replaceColor;
            }
            this.paint.setColor(n2);
            Float f = SVGParser.getFloatAttr("opacity", attributes);
            if (f == null) {
                this.paint.setAlpha(255);
            } else {
                this.paint.setAlpha((int)(255.0f * f.floatValue()));
            }
        }

        private void doLimits(float f, float f2) {
            if (f < this.limits.left) {
                this.limits.left = f;
            }
            if (f > this.limits.right) {
                this.limits.right = f;
            }
            if (f2 < this.limits.top) {
                this.limits.top = f2;
            }
            if (f2 > this.limits.bottom) {
                this.limits.bottom = f2;
            }
        }

        private void doLimits(float f, float f2, float f3, float f4) {
            this.doLimits(f, f2);
            this.doLimits(f + f3, f2 + f4);
        }

        private void doLimits(Path path) {
            path.computeBounds(this.rect, false);
            this.doLimits(this.rect.left, this.rect.top);
            this.doLimits(this.rect.right, this.rect.bottom);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.boundsMode) {
                if (string2.equals("rect")) {
                    Float f;
                    Float f2 = SVGParser.getFloatAttr("x", attributes);
                    if (f2 == null) {
                        f2 = Float.valueOf(0.0f);
                    }
                    if ((f = SVGParser.getFloatAttr("y", attributes)) == null) {
                        f = Float.valueOf(0.0f);
                    }
                    Float f3 = SVGParser.getFloatAttr("width", attributes);
                    Float f4 = SVGParser.getFloatAttr("height", attributes);
                    this.bounds = new RectF(f2.floatValue(), f.floatValue(), f2.floatValue() + f3.floatValue(), f.floatValue() + f3.floatValue());
                }
                return;
            }
            if (string2.equals("svg")) {
                int n = (int)Math.ceil(SVGParser.getFloatAttr("width", attributes).floatValue());
                int n2 = (int)Math.ceil(SVGParser.getFloatAttr("height", attributes).floatValue());
                this.canvas = this.picture.beginRecording(n, n2);
            } else if (!string2.equals("defs")) {
                if (string2.equals("linearGradient")) {
                    this.gradient = this.doGradient(true, attributes);
                } else if (string2.equals("radialGradient")) {
                    this.gradient = this.doGradient(false, attributes);
                } else if (string2.equals("stop")) {
                    if (this.gradient != null) {
                        float f = SVGParser.getFloatAttr("offset", attributes).floatValue();
                        String string4 = SVGParser.getStringAttr("style", attributes);
                        if (string4.startsWith("stop-color:#")) {
                            int n = Integer.parseInt(string4.substring("stop-color:#".length()), 16);
                            this.gradient.positions.add(Float.valueOf(f));
                            this.gradient.colors.add(n |= 0xFF000000);
                        }
                    }
                } else if (string2.equals("g")) {
                    if ("bounds".equalsIgnoreCase(SVGParser.getStringAttr("id", attributes))) {
                        this.boundsMode = true;
                    }
                    if (this.hidden) {
                        ++this.hiddenLevel;
                    }
                    if ("none".equals(SVGParser.getStringAttr("display", attributes)) && !this.hidden) {
                        this.hidden = true;
                        this.hiddenLevel = 1;
                    }
                } else if (!this.hidden && string2.equals("rect")) {
                    Float f;
                    Float f5 = SVGParser.getFloatAttr("x", attributes);
                    if (f5 == null) {
                        f5 = Float.valueOf(0.0f);
                    }
                    if ((f = SVGParser.getFloatAttr("y", attributes)) == null) {
                        f = Float.valueOf(0.0f);
                    }
                    Float f6 = SVGParser.getFloatAttr("width", attributes);
                    Float f7 = SVGParser.getFloatAttr("height", attributes);
                    if (this.doFill(attributes, this.gradientMap)) {
                        this.doLimits(f5.floatValue(), f.floatValue(), f6.floatValue(), f7.floatValue());
                        this.canvas.drawRect(f5.floatValue(), f.floatValue(), f5.floatValue() + f6.floatValue(), f.floatValue() + f7.floatValue(), this.paint);
                    }
                    if (this.doStroke(attributes)) {
                        this.canvas.drawRect(f5.floatValue(), f.floatValue(), f5.floatValue() + f6.floatValue(), f.floatValue() + f7.floatValue(), this.paint);
                    }
                } else if (!this.hidden && string2.equals("line")) {
                    Float f = SVGParser.getFloatAttr("x1", attributes);
                    Float f8 = SVGParser.getFloatAttr("x2", attributes);
                    Float f9 = SVGParser.getFloatAttr("y1", attributes);
                    Float f10 = SVGParser.getFloatAttr("y2", attributes);
                    if (this.doStroke(attributes)) {
                        this.doLimits(f.floatValue(), f9.floatValue());
                        this.doLimits(f8.floatValue(), f10.floatValue());
                        this.canvas.drawLine(f.floatValue(), f9.floatValue(), f8.floatValue(), f10.floatValue(), this.paint);
                    }
                } else if (!this.hidden && string2.equals("circle")) {
                    Float f = SVGParser.getFloatAttr("cx", attributes);
                    Float f11 = SVGParser.getFloatAttr("cy", attributes);
                    Float f12 = SVGParser.getFloatAttr("r", attributes);
                    if (f != null && f11 != null && f12 != null) {
                        if (this.doFill(attributes, this.gradientMap)) {
                            this.doLimits(f.floatValue() - f12.floatValue(), f11.floatValue() - f12.floatValue());
                            this.doLimits(f.floatValue() + f12.floatValue(), f11.floatValue() + f12.floatValue());
                            this.canvas.drawCircle(f.floatValue(), f11.floatValue(), f12.floatValue(), this.paint);
                        }
                        if (this.doStroke(attributes)) {
                            this.canvas.drawCircle(f.floatValue(), f11.floatValue(), f12.floatValue(), this.paint);
                        }
                    }
                } else if (!this.hidden && string2.equals("ellipse")) {
                    Float f = SVGParser.getFloatAttr("cx", attributes);
                    Float f13 = SVGParser.getFloatAttr("cy", attributes);
                    Float f14 = SVGParser.getFloatAttr("rx", attributes);
                    Float f15 = SVGParser.getFloatAttr("ry", attributes);
                    if (f != null && f13 != null && f14 != null && f15 != null) {
                        this.rect.set(f.floatValue() - f14.floatValue(), f13.floatValue() - f15.floatValue(), f.floatValue() + f14.floatValue(), f13.floatValue() + f15.floatValue());
                        if (this.doFill(attributes, this.gradientMap)) {
                            this.doLimits(f.floatValue() - f14.floatValue(), f13.floatValue() - f15.floatValue());
                            this.doLimits(f.floatValue() + f14.floatValue(), f13.floatValue() + f15.floatValue());
                            this.canvas.drawOval(this.rect, this.paint);
                        }
                        if (this.doStroke(attributes)) {
                            this.canvas.drawOval(this.rect, this.paint);
                        }
                    }
                } else if (!this.hidden && (string2.equals("polygon") || string2.equals("polyline"))) {
                    NumberParse numberParse = SVGParser.getNumberParseAttr("points", attributes);
                    if (numberParse != null) {
                        Path path = new Path();
                        ArrayList arrayList = numberParse.numbers;
                        if (arrayList.size() > 1) {
                            path.moveTo(((Float)arrayList.get(0)).floatValue(), ((Float)arrayList.get(1)).floatValue());
                            for (int i = 2; i < arrayList.size(); i += 2) {
                                float f = ((Float)arrayList.get(i)).floatValue();
                                float f16 = ((Float)arrayList.get(i + 1)).floatValue();
                                path.lineTo(f, f16);
                            }
                            if (string2.equals("polygon")) {
                                path.close();
                            }
                            if (this.doFill(attributes, this.gradientMap)) {
                                this.doLimits(path);
                                this.canvas.drawPath(path, this.paint);
                            }
                            if (this.doStroke(attributes)) {
                                this.canvas.drawPath(path, this.paint);
                            }
                        }
                    }
                } else if (!this.hidden && string2.equals("path")) {
                    Path path = SVGParser.doPath(SVGParser.getStringAttr("d", attributes));
                    if (this.doFill(attributes, this.gradientMap)) {
                        this.doLimits(path);
                        this.canvas.drawPath(path, this.paint);
                    }
                    if (this.doStroke(attributes)) {
                        this.canvas.drawPath(path, this.paint);
                    }
                } else if (!this.hidden) {
                    Log.d((String)SVGParser.TAG, (String)("UNRECOGNIZED SVG COMMAND: " + string2));
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals("svg")) {
                this.picture.endRecording();
            } else if (string2.equals("linearGradient")) {
                if (this.gradient.id != null) {
                    int[] nArray = new int[this.gradient.colors.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = this.gradient.colors.get(i);
                    }
                    float[] fArray = new float[this.gradient.positions.size()];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = this.gradient.positions.get(i).floatValue();
                    }
                    LinearGradient linearGradient = new LinearGradient(this.gradient.x1, this.gradient.y1, this.gradient.x2, this.gradient.y2, nArray, fArray, Shader.TileMode.CLAMP);
                    if (this.gradient.matrix != null) {
                        linearGradient.setLocalMatrix(this.gradient.matrix);
                    }
                    this.gradientMap.put(this.gradient.id, (Shader)linearGradient);
                }
            } else if (string2.equals("radialGradient")) {
                if (this.gradient.id != null) {
                    int[] nArray = new int[this.gradient.colors.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = this.gradient.colors.get(i);
                    }
                    float[] fArray = new float[this.gradient.positions.size()];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = this.gradient.positions.get(i).floatValue();
                    }
                    RadialGradient radialGradient = new RadialGradient(this.gradient.x, this.gradient.y, this.gradient.radius, nArray, fArray, Shader.TileMode.CLAMP);
                    if (this.gradient.matrix != null) {
                        radialGradient.setLocalMatrix(this.gradient.matrix);
                    }
                    this.gradientMap.put(this.gradient.id, (Shader)radialGradient);
                }
            } else if (string2.equals("g")) {
                if (this.boundsMode) {
                    this.boundsMode = false;
                }
                if (this.hidden) {
                    --this.hiddenLevel;
                    if (this.hiddenLevel == 0) {
                        this.hidden = false;
                    }
                }
                this.gradientMap.clear();
            }
        }
    }

    private static class Gradient {
        String id;
        boolean isLinear;
        float x1;
        float y1;
        float x2;
        float y2;
        float x;
        float y;
        float radius;
        ArrayList<Float> positions = new ArrayList();
        ArrayList<Integer> colors = new ArrayList();
        Matrix matrix = null;

        private Gradient() {
        }
    }

    private static class NumberParse {
        private ArrayList<Float> numbers;
        private int nextCmd;

        public NumberParse(ArrayList<Float> arrayList, int n) {
            this.numbers = arrayList;
            this.nextCmd = n;
        }

        public int getNextCmd() {
            return this.nextCmd;
        }

        public float getNumber(int n) {
            return this.numbers.get(n).floatValue();
        }
    }
}

