/*
 * Decompiled with CFR 0.152.
 */
package com.larvalabs.svgandroid;

public class ParserHelper {
    private char current;
    private CharSequence s;
    public int pos;
    private int n;
    private static final double[] pow10 = new double[128];

    public ParserHelper(CharSequence charSequence, int n) {
        this.s = charSequence;
        this.pos = n;
        this.n = charSequence.length();
        this.current = charSequence.charAt(n);
    }

    private char read() {
        if (this.pos < this.n) {
            ++this.pos;
        }
        if (this.pos == this.n) {
            return '\u0000';
        }
        return this.s.charAt(this.pos);
    }

    public void skipWhitespace() {
        while (this.pos < this.n && Character.isWhitespace(this.s.charAt(this.pos))) {
            this.advance();
        }
    }

    public void skipNumberSeparator() {
        block3: while (this.pos < this.n) {
            char c = this.s.charAt(this.pos);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': 
                case ',': {
                    this.advance();
                    continue block3;
                }
            }
            return;
        }
    }

    public void advance() {
        this.current = this.read();
    }

    public float parseFloat() {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = true;
        switch (this.current) {
            case '-': {
                bl = false;
            }
            case '+': {
                this.current = this.read();
            }
        }
        block4 : switch (this.current) {
            default: {
                return Float.NaN;
            }
            case '.': {
                break;
            }
            case '0': {
                bl2 = true;
                block50: while (true) {
                    this.current = this.read();
                    switch (this.current) {
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block50;
                        }
                        case '.': 
                        case 'E': 
                        case 'e': {
                            break block4;
                        }
                        default: {
                            return 0.0f;
                        }
                        case '0': {
                            continue block50;
                        }
                    }
                    break;
                }
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                bl2 = true;
                while (true) {
                    if (n2 < 9) {
                        ++n2;
                        n = n * 10 + (this.current - 48);
                    } else {
                        ++n5;
                    }
                    this.current = this.read();
                    switch (this.current) {
                        default: {
                            break block4;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                    }
                }
            }
        }
        if (this.current == '.') {
            this.current = this.read();
            block17 : switch (this.current) {
                default: {
                    if (bl2) break;
                    this.reportUnexpectedCharacterError(this.current);
                    return 0.0f;
                }
                case '0': {
                    if (n2 == 0) {
                        block52: while (true) {
                            this.current = this.read();
                            --n5;
                            switch (this.current) {
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    break block52;
                                }
                                default: {
                                    if (bl2) break block17;
                                    return 0.0f;
                                }
                                case '0': {
                                    continue block52;
                                }
                            }
                            break;
                        }
                    }
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    while (true) {
                        if (n2 < 9) {
                            ++n2;
                            n = n * 10 + (this.current - 48);
                            --n5;
                        }
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                break block17;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                        }
                    }
                }
            }
        }
        block28 : switch (this.current) {
            case 'E': 
            case 'e': {
                this.current = this.read();
                switch (this.current) {
                    default: {
                        this.reportUnexpectedCharacterError(this.current);
                        return 0.0f;
                    }
                    case '-': {
                        bl3 = false;
                    }
                    case '+': {
                        this.current = this.read();
                        switch (this.current) {
                            default: {
                                this.reportUnexpectedCharacterError(this.current);
                                return 0.0f;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                        }
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                }
                switch (this.current) {
                    case '0': {
                        block54: while (true) {
                            this.current = this.read();
                            switch (this.current) {
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    break block54;
                                }
                                default: {
                                    break block28;
                                }
                                case '0': {
                                    continue block54;
                                }
                            }
                            break;
                        }
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        while (true) {
                            if (n4 < 3) {
                                ++n4;
                                n3 = n3 * 10 + (this.current - 48);
                            }
                            this.current = this.read();
                            switch (this.current) {
                                default: {
                                    break block28;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                            }
                        }
                    }
                }
            }
        }
        if (!bl3) {
            n3 = -n3;
        }
        n3 += n5;
        if (!bl) {
            n = -n;
        }
        return ParserHelper.buildFloat(n, n3);
    }

    private void reportUnexpectedCharacterError(char c) {
        throw new RuntimeException("Unexpected char '" + c + "'.");
    }

    public static float buildFloat(int n, int n2) {
        if (n2 < -125 || n == 0) {
            return 0.0f;
        }
        if (n2 >= 128) {
            return n > 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (n2 == 0) {
            return n;
        }
        if (n >= 0x4000000) {
            ++n;
        }
        return (float)(n2 > 0 ? (double)n * pow10[n2] : (double)n / pow10[-n2]);
    }

    public float nextFloat() {
        float f = this.parseFloat();
        this.skipNumberSeparator();
        return f;
    }

    static {
        for (int i = 0; i < pow10.length; ++i) {
            ParserHelper.pow10[i] = Math.pow(10.0, i);
        }
    }
}

