/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.googledevelopers;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.googledevelopers.GoogledevelopersRequest;
import com.google.api.services.googledevelopers.GoogledevelopersRequestInitializer;
import com.google.api.services.googledevelopers.model.AnnouncementsResponse;
import com.google.api.services.googledevelopers.model.EventResponse;
import com.google.api.services.googledevelopers.model.EventsResponse;
import com.google.api.services.googledevelopers.model.FeedbackResponse;
import com.google.api.services.googledevelopers.model.ModifyBadgeRequest;
import com.google.api.services.googledevelopers.model.ModifyCheckinRequest;
import com.google.api.services.googledevelopers.model.ModifyFeedbackRequest;
import com.google.api.services.googledevelopers.model.ModifyTodoRequest;
import com.google.api.services.googledevelopers.model.ModifyUserSessionRequest;
import com.google.api.services.googledevelopers.model.PresenterResponse;
import com.google.api.services.googledevelopers.model.PresentersResponse;
import com.google.api.services.googledevelopers.model.RegistrationResponse;
import com.google.api.services.googledevelopers.model.SessionResponse;
import com.google.api.services.googledevelopers.model.SessionsResponse;
import com.google.api.services.googledevelopers.model.TodoResponse;
import com.google.api.services.googledevelopers.model.TodosResponse;
import com.google.api.services.googledevelopers.model.TrackResponse;
import com.google.api.services.googledevelopers.model.TracksResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Googledevelopers
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "googledevelopers/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/googledevelopers/v1/";

    public Googledevelopers(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Googledevelopers(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public CheckIns checkIns() {
        return new CheckIns();
    }

    public Events events() {
        return new Events();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.17.0-rc of the googledevelopers library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Googledevelopers.DEFAULT_ROOT_URL, Googledevelopers.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Googledevelopers build() {
            return new Googledevelopers(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setGoogledevelopersRequestInitializer(GoogledevelopersRequestInitializer googledevelopersRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)googledevelopersRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public Events events() {
            return new Events();
        }

        public class Events {
            public Badge badge() {
                return new Badge();
            }

            public Registration registration() {
                return new Registration();
            }

            public Sessions sessions() {
                return new Sessions();
            }

            public Todos todos() {
                return new Todos();
            }

            public class Todos {
                public Get get(String userId, String eventId, String todoId) throws IOException {
                    Get result = new Get(userId, eventId, todoId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String userId, String eventId) throws IOException {
                    List result = new List(userId, eventId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String userId, String eventId, String todoId, ModifyTodoRequest content) throws IOException {
                    Patch result = new Patch(userId, eventId, todoId, content);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String userId, String eventId, String todoId, ModifyTodoRequest content) throws IOException {
                    Update result = new Update(userId, eventId, todoId, content);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends GoogledevelopersRequest<TodosResponse> {
                    private static final String REST_PATH = "users/{userId}/events/{eventId}/todos/{todoId}";
                    @Key
                    private String userId;
                    @Key
                    private String eventId;
                    @Key
                    private String todoId;

                    protected Update(String userId, String eventId, String todoId, ModifyTodoRequest content) {
                        super(Googledevelopers.this, "PUT", REST_PATH, (Object)content, TodosResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                        this.todoId = (String)Preconditions.checkNotNull((Object)todoId, (Object)"Required parameter todoId must be specified.");
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUserIp(String userIp) {
                        return (Update)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Update setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Update setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    public String getTodoId() {
                        return this.todoId;
                    }

                    public Update setTodoId(String todoId) {
                        this.todoId = todoId;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends GoogledevelopersRequest<TodosResponse> {
                    private static final String REST_PATH = "users/{userId}/events/{eventId}/todos/{todoId}";
                    @Key
                    private String userId;
                    @Key
                    private String eventId;
                    @Key
                    private String todoId;

                    protected Patch(String userId, String eventId, String todoId, ModifyTodoRequest content) {
                        super(Googledevelopers.this, "PATCH", REST_PATH, (Object)content, TodosResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                        this.todoId = (String)Preconditions.checkNotNull((Object)todoId, (Object)"Required parameter todoId must be specified.");
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUserIp(String userIp) {
                        return (Patch)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Patch setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Patch setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    public String getTodoId() {
                        return this.todoId;
                    }

                    public Patch setTodoId(String todoId) {
                        this.todoId = todoId;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends GoogledevelopersRequest<TodosResponse> {
                    private static final String REST_PATH = "users/{userId}/events/{eventId}/todos";
                    @Key
                    private String userId;
                    @Key
                    private String eventId;

                    protected List(String userId, String eventId) {
                        super(Googledevelopers.this, "GET", REST_PATH, null, TodosResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public List setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends GoogledevelopersRequest<TodoResponse> {
                    private static final String REST_PATH = "users/{userId}/events/{eventId}/todos/{todoId}";
                    @Key
                    private String userId;
                    @Key
                    private String eventId;
                    @Key
                    private String todoId;

                    protected Get(String userId, String eventId, String todoId) {
                        super(Googledevelopers.this, "GET", REST_PATH, null, TodoResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                        this.todoId = (String)Preconditions.checkNotNull((Object)todoId, (Object)"Required parameter todoId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Get setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    public String getTodoId() {
                        return this.todoId;
                    }

                    public Get setTodoId(String todoId) {
                        this.todoId = todoId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Sessions {
                public Delete delete(String eventId, String sessionId) throws IOException {
                    Delete result = new Delete(eventId, sessionId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String eventId) throws IOException {
                    List result = new List(eventId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String eventId, String sessionId, ModifyUserSessionRequest content) throws IOException {
                    Update result = new Update(eventId, sessionId, content);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends GoogledevelopersRequest<SessionsResponse> {
                    private static final String REST_PATH = "userevents/{eventId}/sessions/{sessionId}";
                    @Key
                    private String eventId;
                    @Key
                    private String sessionId;

                    protected Update(String eventId, String sessionId, ModifyUserSessionRequest content) {
                        super(Googledevelopers.this, "PUT", REST_PATH, (Object)content, SessionsResponse.class);
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUserIp(String userIp) {
                        return (Update)super.setUserIp(userIp);
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Update setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    public String getSessionId() {
                        return this.sessionId;
                    }

                    public Update setSessionId(String sessionId) {
                        this.sessionId = sessionId;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends GoogledevelopersRequest<SessionsResponse> {
                    private static final String REST_PATH = "userevents/{eventId}/sessions";
                    @Key
                    private String eventId;

                    protected List(String eventId) {
                        super(Googledevelopers.this, "GET", REST_PATH, null, SessionsResponse.class);
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public List setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends GoogledevelopersRequest<SessionsResponse> {
                    private static final String REST_PATH = "userevents/{eventId}/sessions/{sessionId}";
                    @Key
                    private String eventId;
                    @Key
                    private String sessionId;

                    protected Delete(String eventId, String sessionId) {
                        super(Googledevelopers.this, "DELETE", REST_PATH, null, SessionsResponse.class);
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUserIp(String userIp) {
                        return (Delete)super.setUserIp(userIp);
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Delete setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    public String getSessionId() {
                        return this.sessionId;
                    }

                    public Delete setSessionId(String sessionId) {
                        this.sessionId = sessionId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }
            }

            public class Registration {
                public Get get(String eventId) throws IOException {
                    Get result = new Get(eventId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends GoogledevelopersRequest<RegistrationResponse> {
                    private static final String REST_PATH = "events/{eventId}/registration";
                    @Key
                    private String eventId;

                    protected Get(String eventId) {
                        super(Googledevelopers.this, "GET", REST_PATH, null, RegistrationResponse.class);
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Get setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Badge {
                public Delete delete(String userId, String eventId) throws IOException {
                    Delete result = new Delete(userId, eventId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String userId, String eventId, ModifyBadgeRequest content) throws IOException {
                    Update result = new Update(userId, eventId, content);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends GoogledevelopersRequest<RegistrationResponse> {
                    private static final String REST_PATH = "users/{userId}/events/{eventId}/badge";
                    @Key
                    private String userId;
                    @Key
                    private String eventId;

                    protected Update(String userId, String eventId, ModifyBadgeRequest content) {
                        super(Googledevelopers.this, "PUT", REST_PATH, (Object)content, RegistrationResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUserIp(String userIp) {
                        return (Update)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Update setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Update setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends GoogledevelopersRequest<RegistrationResponse> {
                    private static final String REST_PATH = "users/{userId}/events/{eventId}/badge";
                    @Key
                    private String userId;
                    @Key
                    private String eventId;

                    protected Delete(String userId, String eventId) {
                        super(Googledevelopers.this, "DELETE", REST_PATH, null, RegistrationResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUserIp(String userIp) {
                        return (Delete)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public Delete setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }
            }
        }
    }

    public class Events {
        public Get get(String eventId) throws IOException {
            Get result = new Get(eventId);
            Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Announcements announcements() {
            return new Announcements();
        }

        public Presenters presenters() {
            return new Presenters();
        }

        public Sessions sessions() {
            return new Sessions();
        }

        public Tracks tracks() {
            return new Tracks();
        }

        public class Tracks {
            public Get get(String eventId, String trackId) throws IOException {
                Get result = new Get(eventId, trackId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String eventId) throws IOException {
                List result = new List(eventId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GoogledevelopersRequest<TracksResponse> {
                private static final String REST_PATH = "events/{eventId}/tracks";
                @Key
                private String eventId;

                protected List(String eventId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, TracksResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public List setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GoogledevelopersRequest<TrackResponse> {
                private static final String REST_PATH = "events/{eventId}/tracks/{trackId}";
                @Key
                private String eventId;
                @Key
                private String trackId;

                protected Get(String eventId, String trackId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, TrackResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    this.trackId = (String)Preconditions.checkNotNull((Object)trackId, (Object)"Required parameter trackId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public Get setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                public String getTrackId() {
                    return this.trackId;
                }

                public Get setTrackId(String trackId) {
                    this.trackId = trackId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Sessions {
            public Feedback feedback(String eventId, String sessionId, ModifyFeedbackRequest content) throws IOException {
                Feedback result = new Feedback(eventId, sessionId, content);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String eventId, String sessionId) throws IOException {
                Get result = new Get(eventId, sessionId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String eventId) throws IOException {
                List result = new List(eventId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Presenters presenters() {
                return new Presenters();
            }

            public class Presenters {
                public List list(String eventId, String sessionId) throws IOException {
                    List result = new List(eventId, sessionId);
                    Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends GoogledevelopersRequest<PresentersResponse> {
                    private static final String REST_PATH = "events/{eventId}/sessions/{sessionId}/presenters";
                    @Key
                    private String eventId;
                    @Key
                    private String sessionId;

                    protected List(String eventId, String sessionId) {
                        super(Googledevelopers.this, "GET", REST_PATH, null, PresentersResponse.class);
                        this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                        this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getEventId() {
                        return this.eventId;
                    }

                    public List setEventId(String eventId) {
                        this.eventId = eventId;
                        return this;
                    }

                    public String getSessionId() {
                        return this.sessionId;
                    }

                    public List setSessionId(String sessionId) {
                        this.sessionId = sessionId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GoogledevelopersRequest<SessionsResponse> {
                private static final String REST_PATH = "events/{eventId}/sessions";
                @Key
                private String eventId;
                @Key
                private Long limit;

                protected List(String eventId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, SessionsResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public List setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                public Long getLimit() {
                    return this.limit;
                }

                public List setLimit(Long limit) {
                    this.limit = limit;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GoogledevelopersRequest<SessionResponse> {
                private static final String REST_PATH = "events/{eventId}/sessions/{sessionId}";
                @Key
                private String eventId;
                @Key
                private String sessionId;

                protected Get(String eventId, String sessionId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, SessionResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public Get setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                public String getSessionId() {
                    return this.sessionId;
                }

                public Get setSessionId(String sessionId) {
                    this.sessionId = sessionId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Feedback
            extends GoogledevelopersRequest<FeedbackResponse> {
                private static final String REST_PATH = "events/{eventId}/sessions/{sessionId}/feedback";
                @Key
                private String eventId;
                @Key
                private String sessionId;

                protected Feedback(String eventId, String sessionId, ModifyFeedbackRequest content) {
                    super(Googledevelopers.this, "PUT", REST_PATH, (Object)content, FeedbackResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                }

                public Feedback setAlt(String alt) {
                    return (Feedback)super.setAlt(alt);
                }

                public Feedback setFields(String fields) {
                    return (Feedback)super.setFields(fields);
                }

                public Feedback setKey(String key) {
                    return (Feedback)super.setKey(key);
                }

                public Feedback setOauthToken(String oauthToken) {
                    return (Feedback)super.setOauthToken(oauthToken);
                }

                public Feedback setPrettyPrint(Boolean prettyPrint) {
                    return (Feedback)super.setPrettyPrint(prettyPrint);
                }

                public Feedback setQuotaUser(String quotaUser) {
                    return (Feedback)super.setQuotaUser(quotaUser);
                }

                public Feedback setUserIp(String userIp) {
                    return (Feedback)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public Feedback setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                public String getSessionId() {
                    return this.sessionId;
                }

                public Feedback setSessionId(String sessionId) {
                    this.sessionId = sessionId;
                    return this;
                }

                @Override
                public Feedback set(String parameterName, Object value) {
                    return (Feedback)super.set(parameterName, value);
                }
            }
        }

        public class Presenters {
            public Get get(String eventId, String presenterId) throws IOException {
                Get result = new Get(eventId, presenterId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String eventId) throws IOException {
                List result = new List(eventId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GoogledevelopersRequest<PresentersResponse> {
                private static final String REST_PATH = "events/{eventId}/presenters";
                @Key
                private String eventId;

                protected List(String eventId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, PresentersResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public List setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GoogledevelopersRequest<PresenterResponse> {
                private static final String REST_PATH = "events/{eventId}/presenters/{presenterId}";
                @Key
                private String eventId;
                @Key
                private String presenterId;

                protected Get(String eventId, String presenterId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, PresenterResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                    this.presenterId = (String)Preconditions.checkNotNull((Object)presenterId, (Object)"Required parameter presenterId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public Get setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                public String getPresenterId() {
                    return this.presenterId;
                }

                public Get setPresenterId(String presenterId) {
                    this.presenterId = presenterId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Announcements {
            public List list(String eventId) throws IOException {
                List result = new List(eventId);
                Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GoogledevelopersRequest<AnnouncementsResponse> {
                private static final String REST_PATH = "events/{eventId}/announcements";
                @Key
                private String eventId;

                protected List(String eventId) {
                    super(Googledevelopers.this, "GET", REST_PATH, null, AnnouncementsResponse.class);
                    this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getEventId() {
                    return this.eventId;
                }

                public List setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends GoogledevelopersRequest<EventsResponse> {
            private static final String REST_PATH = "events";
            @Key
            private Long limit;
            @Key
            private Long searchWindowDays;
            @Key
            private Double startTimestamp;

            protected List() {
                super(Googledevelopers.this, "GET", REST_PATH, null, EventsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public Long getLimit() {
                return this.limit;
            }

            public List setLimit(Long limit) {
                this.limit = limit;
                return this;
            }

            public Long getSearchWindowDays() {
                return this.searchWindowDays;
            }

            public List setSearchWindowDays(Long searchWindowDays) {
                this.searchWindowDays = searchWindowDays;
                return this;
            }

            public Double getStartTimestamp() {
                return this.startTimestamp;
            }

            public List setStartTimestamp(Double startTimestamp) {
                this.startTimestamp = startTimestamp;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GoogledevelopersRequest<EventResponse> {
            private static final String REST_PATH = "events/{eventId}";
            @Key
            private String eventId;

            protected Get(String eventId) {
                super(Googledevelopers.this, "GET", REST_PATH, null, EventResponse.class);
                this.eventId = (String)Preconditions.checkNotNull((Object)eventId, (Object)"Required parameter eventId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getEventId() {
                return this.eventId;
            }

            public Get setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class CheckIns {
        public Delete delete(String confirmationCode) throws IOException {
            Delete result = new Delete(confirmationCode);
            Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String confirmationCode, ModifyCheckinRequest content) throws IOException {
            Update result = new Update(confirmationCode, content);
            Googledevelopers.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends GoogledevelopersRequest<RegistrationResponse> {
            private static final String REST_PATH = "checkins/{confirmationCode}";
            @Key
            private String confirmationCode;

            protected Update(String confirmationCode, ModifyCheckinRequest content) {
                super(Googledevelopers.this, "PUT", REST_PATH, (Object)content, RegistrationResponse.class);
                this.confirmationCode = (String)Preconditions.checkNotNull((Object)confirmationCode, (Object)"Required parameter confirmationCode must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getConfirmationCode() {
                return this.confirmationCode;
            }

            public Update setConfirmationCode(String confirmationCode) {
                this.confirmationCode = confirmationCode;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends GoogledevelopersRequest<RegistrationResponse> {
            private static final String REST_PATH = "checkins/{confirmationCode}";
            @Key
            private String confirmationCode;

            protected Delete(String confirmationCode) {
                super(Googledevelopers.this, "DELETE", REST_PATH, null, RegistrationResponse.class);
                this.confirmationCode = (String)Preconditions.checkNotNull((Object)confirmationCode, (Object)"Required parameter confirmationCode must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getConfirmationCode() {
                return this.confirmationCode;
            }

            public Delete setConfirmationCode(String confirmationCode) {
                this.confirmationCode = confirmationCode;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

