<div align="center">

<img width="100px" src="https://github.com/homanp/superagent/assets/2464556/eb51fa38-4a2a-4c41-b348-d3c1abc04234" />

# Superagent

### The Open Source AI Assistant Framework & API

<p>
<img alt="GitHub Contributors" src="https://img.shields.io/github/contributors/homanp/Superagent" />
<img alt="GitHub Last Commit" src="https://img.shields.io/github/last-commit/homanp/Superagent" />
<img alt="" src="https://img.shields.io/github/repo-size/homanp/Superagent" />
<img alt="GitHub Issues" src="https://img.shields.io/github/issues/homanp/Superagent" />
<img alt="GitHub Pull Requests" src="https://img.shields.io/github/issues-pr/homanp/Superagent" />
<img alt="Github License" src="https://img.shields.io/badge/License-MIT-yellow.svg" />
<img alt="Discord" src="https://img.shields.io/discord/1110910277110743103?label=Discord&logo=discord&logoColor=white&style=plastic&color=d7b023)](https://discord.gg/e8j7mgjDUK" />
</p>

<p>Backed by:</p>
<img width="150px" src="https://asset.brandfetch.io/idKhWTXUYD/idkQv7L0Mm.svg?updated=1668020996653" alt="Backed by YCombinator" />
</div>

-----

<p align="center">
  <a href="#-demo">Demo</a> •
  <a href="#-use-cases">Use cases</a> •
  <a href="#-features">Features</a> •
  <a href="https://docs.superagent.sh" target="_blank">Docs</a> •
  <a href="https://discord.com/invite/mhmJUTjW4b" target="_blank">Discord</a> •
  <a href="#-tutorials" target="_blank">Tutorials</a> •
  <a href="#-sdks" target="_blank">SDKs</a> •
  <a href="#-contributions" target="_blank">Contributions</a>
</p>

-----

Superagent allows any developer to add powerful AI assistants to their applications. These assistants use large language models (LLM), retrieval augmented generation (RAG), and generative AI to help users.

Fully open-source. Backed by Y Combinator. Part of YC W24.

-----

## 🎥 Demo

https://github.com/homanp/superagent/assets/2464556/1a742181-6a5f-428c-82db-5f891dad0d31


## ✨ Use cases

Superagent lets you build any AI application/microservice you want, including:

- Question/Answering over Documents (LLM Finetunes/Vectorstores).
- Chatbots.
- Co-pilots & AI assistants.
- Content generation.
- Data aggregation.
- Workflow automation agent.


## 👀 Features:

- Memory
- Streaming
- Python and Typescript SDKs
- REST API
- API connectivity
- Vectorization
- Support for third-party vector stores (e.g Weaviate, Pinecone)
- Support for proprietary and open-source LLMs
- API concurrency support


## 📋 Documentation:
For full documentation, examples and setup guidelines, visit [docs.superagent.sh](https://docs.superagent.sh)


## 🧐 Tutorials

We post tutorials regularly on our [YouTube channel](https://www.youtube.com/channel/UCBeXnF8gh2EwAmOIwpmfjmA). Make sure to check them out ! 


## 🔗 SDKs

If you are planning to integrate Superagent into your stack, you can use one of the following SDKs:

- [Python](https://github.com/homanp/superagent-py)
- [Typescript/Javascript](https://github.com/homanp/superagent-js)
- [Swift](https://github.com/simonweniger/superagent-swift) (Community)


## 🫶 Contributions:

Superagent is an open-source project, and contributions are welcome. If you want to contribute, you can create new features, fix bugs, or improve the infrastructure. Please refer to the [CONTRIBUTING.md](https://github.com/homanp/Superagent/blob/main/.github/CONTRIBUTING.md) file in the repository for more information on how to contribute.

To see how to contribute, visit [Contribution guidelines](https://github.com/homanp/Superagent/blob/main/.github/CONTRIBUTING.md)

To help with contributions, you can search, navigate, and understand Superagent's source code using Onboard AI's free tool LearnThisRepo.
[learnthisrepo.com/superagent](https://learnthisrepo.com/superagent)

<a href="https://github.com/homanp/superagent/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=homanp/superagent" />
</a>
