# 🧠 SuperDesign — AI Design Agent for Your IDE

### **By:** [AI Jason](https://x.com/jasonzhou1993) & [JackJack](https://x.com/jackjack_eth)

SuperDesign is the first **open-source design agent** that lives right inside your IDE.  
Generate UI mockups, components, and wireframes directly from natural language prompts.  
Works seamlessly with Cursor, Windsurf, Claude Code, and plain VS Code.

> ✨ "Why design one option when you can explore ten?" — SuperDesign

---

## 🚀 Features

- 🖼️ **Product Mock**: Instantly generate full UI screens from a single prompt
- 🧩 **UI Components**: Create reusable components you can drop into your code
- 📝 **Wireframes**: Explore low-fidelity layouts for fast iteration
- 🔁 **Fork & Iterate**: Duplicate and evolve designs easily
- 📥 **Prompt-to-IDE**: Copy prompts into your favorite AI IDE (Cursor, Windsurf, Claude Code)

---

## 🧠 Works Great With

- [Cursor](https://www.cursor.sh/)
- [Windsurf](https://windsurf.ai/)
- [Claude Code](https://www.anthropic.com/index/claude-code)
- [Visual Studio Code](https://code.visualstudio.com/)

---

## 🛠️ Getting Started

1. **Install the Extension** from the Cursor/VS Code Marketplace
2. Open the `SuperDesign` sidebar panel
3. Type a prompt (e.g., _"Design a modern login screen"_)
4. View generated mockups, components, and wireframes
5. Fork, tweak, and paste into your project

---

## 📂 Where Are My Designs Stored?

Your generated designs are saved locally inside `.superdesign/`.

---

## ❓ FAQ

**Is it free and open source?**  
Yes! Licensed under MIT — fork it, extend it, remix it.

**Can I customize the design agent?**  
Yes — use your own prompt templates, modify behaviors, or add commands.

**Can SuperDesign update existing UI?**  
Absolutely — select a component, describe the change, and let the agent do the rest.

**How can I contribute?**  
Pull requests are welcome. Star the repo and join us on [Discord](https://discord.gg/XYZ)!

---

## 🔗 Links

- 🌐 Website: [https://superdesign.dev](https://superdesign.dev)
- 📦 GitHub: [https://github.com/your-org/superdesign](https://github.com/your-org/superdesign)
- 💬 Discord: [Join the Community](https://discord.gg/XYZ)
- 🐦 Twitter / X: [@SuperDesignDev](https://x.com/SuperDesignDev)

---

## 🪪 License

MIT — Built with ❤️ by the SuperDesign team
