#
# Autogenerated by Thrift Compiler (0.7.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

from thrift.Thrift import *
import hadoop.api.common.HadoopServiceBase
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(hadoop.api.common.HadoopServiceBase.Iface):
  """
  A proxy service onto a Jobtracker, exposing read-only methods for cluster monitoring
  """
  def getJobTrackerName(self, ctx):
    """
    Get the name of the tracker exporting this service

    Parameters:
     - ctx
    """
    pass

  def getClusterStatus(self, ctx):
    """
    Get the current cluster status

    Parameters:
     - ctx
    """
    pass

  def getQueues(self, ctx):
    """
    Get a list of job queues managed by this tracker

    Parameters:
     - ctx
    """
    pass

  def getJob(self, ctx, jobID):
    """
    Get a job by ID

    Parameters:
     - ctx
     - jobID
    """
    pass

  def getRunningJobs(self, ctx):
    """
    Get a list of currently running jobs

    Parameters:
     - ctx
    """
    pass

  def getCompletedJobs(self, ctx):
    """
    Get a list of completed jobs

    Parameters:
     - ctx
    """
    pass

  def getRetiredJob(self, ctx, jobID):
    """
    Get a retired job

    Parameters:
     - ctx
     - jobID
    """
    pass

  def getRetiredJobs(self, ctx, state):
    """
    Get a list of retired jobs

    Parameters:
     - ctx
     - state
    """
    pass

  def getFailedJobs(self, ctx):
    """
    Get a list of failed (due to error, not killed) jobs

    Parameters:
     - ctx
    """
    pass

  def getKilledJobs(self, ctx):
    """
    Get a list of killed jobs

    Parameters:
     - ctx
    """
    pass

  def getAllJobs(self, ctx):
    """
    Get a list of all failed, completed and running jobs (could be expensive!)

    Parameters:
     - ctx
    """
    pass

  def getUserJobCounts(self, ctx, user):
    """
    Get the count of jobs by status for a given user

    Parameters:
     - ctx
     - user
    """
    pass

  def getTaskList(self, ctx, jobID, types, states, text, count, offset):
    """
    Get a (possibly incomplete) list of tasks

    Parameters:
     - ctx
     - jobID
     - types
     - states
     - text
     - count
     - offset
    """
    pass

  def getTask(self, ctx, taskID):
    """
    Get details of a task

    Parameters:
     - ctx
     - taskID
    """
    pass

  def getJobCounters(self, ctx, jobID):
    """
    Get a list of groups of counters attached to the job with provided id.
    This returns the total counters


    Parameters:
     - ctx
     - jobID
    """
    pass

  def getJobCounterRollups(self, ctx, jobID):
    """
    Return job counters rolled up by map, reduce, and total

    Parameters:
     - ctx
     - jobID
    """
    pass

  def getActiveTrackers(self, ctx):
    """
    Get all active trackers

    Parameters:
     - ctx
    """
    pass

  def getBlacklistedTrackers(self, ctx):
    """
    Get all blacklisted trackers

    Parameters:
     - ctx
    """
    pass

  def getAllTrackers(self, ctx):
    """
    Get all trackers

    Parameters:
     - ctx
    """
    pass

  def getTracker(self, ctx, name):
    """
    Get a single task tracker by name

    Parameters:
     - ctx
     - name
    """
    pass

  def getCurrentTime(self, ctx):
    """
    Get the current time in ms according to the JT

    Parameters:
     - ctx
    """
    pass

  def getJobConfXML(self, ctx, jobID):
    """
    Get the xml for a job's configuration, serialised from the local filesystem on the JT

    Parameters:
     - ctx
     - jobID
    """
    pass

  def killJob(self, ctx, jobID):
    """
    Kill a job

    Parameters:
     - ctx
     - jobID
    """
    pass

  def killTaskAttempt(self, ctx, attemptID):
    """
    Kill a task attempt

    Parameters:
     - ctx
     - attemptID
    """
    pass

  def setJobPriority(self, ctx, jobID, priority):
    """
    Set a job's priority

    Parameters:
     - ctx
     - jobID
     - priority
    """
    pass

  def getDelegationToken(self, ctx, renewer):
    """
    Get an MR delegation token.

    Parameters:
     - ctx
     - renewer
    """
    pass


class Client(hadoop.api.common.HadoopServiceBase.Client, Iface):
  """
  A proxy service onto a Jobtracker, exposing read-only methods for cluster monitoring
  """
  def __init__(self, iprot, oprot=None):
    hadoop.api.common.HadoopServiceBase.Client.__init__(self, iprot, oprot)

  def getJobTrackerName(self, ctx):
    """
    Get the name of the tracker exporting this service

    Parameters:
     - ctx
    """
    self.send_getJobTrackerName(ctx)
    return self.recv_getJobTrackerName()

  def send_getJobTrackerName(self, ctx):
    self._oprot.writeMessageBegin('getJobTrackerName', TMessageType.CALL, self._seqid)
    args = getJobTrackerName_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getJobTrackerName(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getJobTrackerName_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getJobTrackerName failed: unknown result");

  def getClusterStatus(self, ctx):
    """
    Get the current cluster status

    Parameters:
     - ctx
    """
    self.send_getClusterStatus(ctx)
    return self.recv_getClusterStatus()

  def send_getClusterStatus(self, ctx):
    self._oprot.writeMessageBegin('getClusterStatus', TMessageType.CALL, self._seqid)
    args = getClusterStatus_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getClusterStatus(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getClusterStatus_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getClusterStatus failed: unknown result");

  def getQueues(self, ctx):
    """
    Get a list of job queues managed by this tracker

    Parameters:
     - ctx
    """
    self.send_getQueues(ctx)
    return self.recv_getQueues()

  def send_getQueues(self, ctx):
    self._oprot.writeMessageBegin('getQueues', TMessageType.CALL, self._seqid)
    args = getQueues_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getQueues(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getQueues_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getQueues failed: unknown result");

  def getJob(self, ctx, jobID):
    """
    Get a job by ID

    Parameters:
     - ctx
     - jobID
    """
    self.send_getJob(ctx, jobID)
    return self.recv_getJob()

  def send_getJob(self, ctx, jobID):
    self._oprot.writeMessageBegin('getJob', TMessageType.CALL, self._seqid)
    args = getJob_args()
    args.ctx = ctx
    args.jobID = jobID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getJob(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getJob_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getJob failed: unknown result");

  def getRunningJobs(self, ctx):
    """
    Get a list of currently running jobs

    Parameters:
     - ctx
    """
    self.send_getRunningJobs(ctx)
    return self.recv_getRunningJobs()

  def send_getRunningJobs(self, ctx):
    self._oprot.writeMessageBegin('getRunningJobs', TMessageType.CALL, self._seqid)
    args = getRunningJobs_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRunningJobs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRunningJobs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRunningJobs failed: unknown result");

  def getCompletedJobs(self, ctx):
    """
    Get a list of completed jobs

    Parameters:
     - ctx
    """
    self.send_getCompletedJobs(ctx)
    return self.recv_getCompletedJobs()

  def send_getCompletedJobs(self, ctx):
    self._oprot.writeMessageBegin('getCompletedJobs', TMessageType.CALL, self._seqid)
    args = getCompletedJobs_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getCompletedJobs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getCompletedJobs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getCompletedJobs failed: unknown result");

  def getRetiredJob(self, ctx, jobID):
    """
    Get a retired job

    Parameters:
     - ctx
     - jobID
    """
    self.send_getRetiredJob(ctx, jobID)
    return self.recv_getRetiredJob()

  def send_getRetiredJob(self, ctx, jobID):
    self._oprot.writeMessageBegin('getRetiredJob', TMessageType.CALL, self._seqid)
    args = getRetiredJob_args()
    args.ctx = ctx
    args.jobID = jobID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRetiredJob(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRetiredJob_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRetiredJob failed: unknown result");

  def getRetiredJobs(self, ctx, state):
    """
    Get a list of retired jobs

    Parameters:
     - ctx
     - state
    """
    self.send_getRetiredJobs(ctx, state)
    return self.recv_getRetiredJobs()

  def send_getRetiredJobs(self, ctx, state):
    self._oprot.writeMessageBegin('getRetiredJobs', TMessageType.CALL, self._seqid)
    args = getRetiredJobs_args()
    args.ctx = ctx
    args.state = state
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRetiredJobs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRetiredJobs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRetiredJobs failed: unknown result");

  def getFailedJobs(self, ctx):
    """
    Get a list of failed (due to error, not killed) jobs

    Parameters:
     - ctx
    """
    self.send_getFailedJobs(ctx)
    return self.recv_getFailedJobs()

  def send_getFailedJobs(self, ctx):
    self._oprot.writeMessageBegin('getFailedJobs', TMessageType.CALL, self._seqid)
    args = getFailedJobs_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getFailedJobs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getFailedJobs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getFailedJobs failed: unknown result");

  def getKilledJobs(self, ctx):
    """
    Get a list of killed jobs

    Parameters:
     - ctx
    """
    self.send_getKilledJobs(ctx)
    return self.recv_getKilledJobs()

  def send_getKilledJobs(self, ctx):
    self._oprot.writeMessageBegin('getKilledJobs', TMessageType.CALL, self._seqid)
    args = getKilledJobs_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getKilledJobs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getKilledJobs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getKilledJobs failed: unknown result");

  def getAllJobs(self, ctx):
    """
    Get a list of all failed, completed and running jobs (could be expensive!)

    Parameters:
     - ctx
    """
    self.send_getAllJobs(ctx)
    return self.recv_getAllJobs()

  def send_getAllJobs(self, ctx):
    self._oprot.writeMessageBegin('getAllJobs', TMessageType.CALL, self._seqid)
    args = getAllJobs_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getAllJobs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getAllJobs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getAllJobs failed: unknown result");

  def getUserJobCounts(self, ctx, user):
    """
    Get the count of jobs by status for a given user

    Parameters:
     - ctx
     - user
    """
    self.send_getUserJobCounts(ctx, user)
    return self.recv_getUserJobCounts()

  def send_getUserJobCounts(self, ctx, user):
    self._oprot.writeMessageBegin('getUserJobCounts', TMessageType.CALL, self._seqid)
    args = getUserJobCounts_args()
    args.ctx = ctx
    args.user = user
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getUserJobCounts(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getUserJobCounts_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getUserJobCounts failed: unknown result");

  def getTaskList(self, ctx, jobID, types, states, text, count, offset):
    """
    Get a (possibly incomplete) list of tasks

    Parameters:
     - ctx
     - jobID
     - types
     - states
     - text
     - count
     - offset
    """
    self.send_getTaskList(ctx, jobID, types, states, text, count, offset)
    return self.recv_getTaskList()

  def send_getTaskList(self, ctx, jobID, types, states, text, count, offset):
    self._oprot.writeMessageBegin('getTaskList', TMessageType.CALL, self._seqid)
    args = getTaskList_args()
    args.ctx = ctx
    args.jobID = jobID
    args.types = types
    args.states = states
    args.text = text
    args.count = count
    args.offset = offset
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTaskList(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTaskList_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTaskList failed: unknown result");

  def getTask(self, ctx, taskID):
    """
    Get details of a task

    Parameters:
     - ctx
     - taskID
    """
    self.send_getTask(ctx, taskID)
    return self.recv_getTask()

  def send_getTask(self, ctx, taskID):
    self._oprot.writeMessageBegin('getTask', TMessageType.CALL, self._seqid)
    args = getTask_args()
    args.ctx = ctx
    args.taskID = taskID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTask(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTask_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.jnf is not None:
      raise result.jnf
    if result.tnf is not None:
      raise result.tnf
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTask failed: unknown result");

  def getJobCounters(self, ctx, jobID):
    """
    Get a list of groups of counters attached to the job with provided id.
    This returns the total counters


    Parameters:
     - ctx
     - jobID
    """
    self.send_getJobCounters(ctx, jobID)
    return self.recv_getJobCounters()

  def send_getJobCounters(self, ctx, jobID):
    self._oprot.writeMessageBegin('getJobCounters', TMessageType.CALL, self._seqid)
    args = getJobCounters_args()
    args.ctx = ctx
    args.jobID = jobID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getJobCounters(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getJobCounters_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getJobCounters failed: unknown result");

  def getJobCounterRollups(self, ctx, jobID):
    """
    Return job counters rolled up by map, reduce, and total

    Parameters:
     - ctx
     - jobID
    """
    self.send_getJobCounterRollups(ctx, jobID)
    return self.recv_getJobCounterRollups()

  def send_getJobCounterRollups(self, ctx, jobID):
    self._oprot.writeMessageBegin('getJobCounterRollups', TMessageType.CALL, self._seqid)
    args = getJobCounterRollups_args()
    args.ctx = ctx
    args.jobID = jobID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getJobCounterRollups(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getJobCounterRollups_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getJobCounterRollups failed: unknown result");

  def getActiveTrackers(self, ctx):
    """
    Get all active trackers

    Parameters:
     - ctx
    """
    self.send_getActiveTrackers(ctx)
    return self.recv_getActiveTrackers()

  def send_getActiveTrackers(self, ctx):
    self._oprot.writeMessageBegin('getActiveTrackers', TMessageType.CALL, self._seqid)
    args = getActiveTrackers_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getActiveTrackers(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getActiveTrackers_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getActiveTrackers failed: unknown result");

  def getBlacklistedTrackers(self, ctx):
    """
    Get all blacklisted trackers

    Parameters:
     - ctx
    """
    self.send_getBlacklistedTrackers(ctx)
    return self.recv_getBlacklistedTrackers()

  def send_getBlacklistedTrackers(self, ctx):
    self._oprot.writeMessageBegin('getBlacklistedTrackers', TMessageType.CALL, self._seqid)
    args = getBlacklistedTrackers_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getBlacklistedTrackers(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getBlacklistedTrackers_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getBlacklistedTrackers failed: unknown result");

  def getAllTrackers(self, ctx):
    """
    Get all trackers

    Parameters:
     - ctx
    """
    self.send_getAllTrackers(ctx)
    return self.recv_getAllTrackers()

  def send_getAllTrackers(self, ctx):
    self._oprot.writeMessageBegin('getAllTrackers', TMessageType.CALL, self._seqid)
    args = getAllTrackers_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getAllTrackers(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getAllTrackers_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getAllTrackers failed: unknown result");

  def getTracker(self, ctx, name):
    """
    Get a single task tracker by name

    Parameters:
     - ctx
     - name
    """
    self.send_getTracker(ctx, name)
    return self.recv_getTracker()

  def send_getTracker(self, ctx, name):
    self._oprot.writeMessageBegin('getTracker', TMessageType.CALL, self._seqid)
    args = getTracker_args()
    args.ctx = ctx
    args.name = name
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTracker(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTracker_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.tne is not None:
      raise result.tne
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTracker failed: unknown result");

  def getCurrentTime(self, ctx):
    """
    Get the current time in ms according to the JT

    Parameters:
     - ctx
    """
    self.send_getCurrentTime(ctx)
    return self.recv_getCurrentTime()

  def send_getCurrentTime(self, ctx):
    self._oprot.writeMessageBegin('getCurrentTime', TMessageType.CALL, self._seqid)
    args = getCurrentTime_args()
    args.ctx = ctx
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getCurrentTime(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getCurrentTime_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getCurrentTime failed: unknown result");

  def getJobConfXML(self, ctx, jobID):
    """
    Get the xml for a job's configuration, serialised from the local filesystem on the JT

    Parameters:
     - ctx
     - jobID
    """
    self.send_getJobConfXML(ctx, jobID)
    return self.recv_getJobConfXML()

  def send_getJobConfXML(self, ctx, jobID):
    self._oprot.writeMessageBegin('getJobConfXML', TMessageType.CALL, self._seqid)
    args = getJobConfXML_args()
    args.ctx = ctx
    args.jobID = jobID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getJobConfXML(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getJobConfXML_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getJobConfXML failed: unknown result");

  def killJob(self, ctx, jobID):
    """
    Kill a job

    Parameters:
     - ctx
     - jobID
    """
    self.send_killJob(ctx, jobID)
    self.recv_killJob()

  def send_killJob(self, ctx, jobID):
    self._oprot.writeMessageBegin('killJob', TMessageType.CALL, self._seqid)
    args = killJob_args()
    args.ctx = ctx
    args.jobID = jobID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_killJob(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = killJob_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    if result.jne is not None:
      raise result.jne
    return

  def killTaskAttempt(self, ctx, attemptID):
    """
    Kill a task attempt

    Parameters:
     - ctx
     - attemptID
    """
    self.send_killTaskAttempt(ctx, attemptID)
    self.recv_killTaskAttempt()

  def send_killTaskAttempt(self, ctx, attemptID):
    self._oprot.writeMessageBegin('killTaskAttempt', TMessageType.CALL, self._seqid)
    args = killTaskAttempt_args()
    args.ctx = ctx
    args.attemptID = attemptID
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_killTaskAttempt(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = killTaskAttempt_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    if result.tne is not None:
      raise result.tne
    if result.jne is not None:
      raise result.jne
    return

  def setJobPriority(self, ctx, jobID, priority):
    """
    Set a job's priority

    Parameters:
     - ctx
     - jobID
     - priority
    """
    self.send_setJobPriority(ctx, jobID, priority)
    self.recv_setJobPriority()

  def send_setJobPriority(self, ctx, jobID, priority):
    self._oprot.writeMessageBegin('setJobPriority', TMessageType.CALL, self._seqid)
    args = setJobPriority_args()
    args.ctx = ctx
    args.jobID = jobID
    args.priority = priority
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setJobPriority(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setJobPriority_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.err is not None:
      raise result.err
    if result.jne is not None:
      raise result.jne
    return

  def getDelegationToken(self, ctx, renewer):
    """
    Get an MR delegation token.

    Parameters:
     - ctx
     - renewer
    """
    self.send_getDelegationToken(ctx, renewer)
    return self.recv_getDelegationToken()

  def send_getDelegationToken(self, ctx, renewer):
    self._oprot.writeMessageBegin('getDelegationToken', TMessageType.CALL, self._seqid)
    args = getDelegationToken_args()
    args.ctx = ctx
    args.renewer = renewer
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getDelegationToken(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getDelegationToken_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.err is not None:
      raise result.err
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getDelegationToken failed: unknown result");


class Processor(hadoop.api.common.HadoopServiceBase.Processor, Iface, TProcessor):
  def __init__(self, handler):
    hadoop.api.common.HadoopServiceBase.Processor.__init__(self, handler)
    self._processMap["getJobTrackerName"] = Processor.process_getJobTrackerName
    self._processMap["getClusterStatus"] = Processor.process_getClusterStatus
    self._processMap["getQueues"] = Processor.process_getQueues
    self._processMap["getJob"] = Processor.process_getJob
    self._processMap["getRunningJobs"] = Processor.process_getRunningJobs
    self._processMap["getCompletedJobs"] = Processor.process_getCompletedJobs
    self._processMap["getRetiredJob"] = Processor.process_getRetiredJob
    self._processMap["getRetiredJobs"] = Processor.process_getRetiredJobs
    self._processMap["getFailedJobs"] = Processor.process_getFailedJobs
    self._processMap["getKilledJobs"] = Processor.process_getKilledJobs
    self._processMap["getAllJobs"] = Processor.process_getAllJobs
    self._processMap["getUserJobCounts"] = Processor.process_getUserJobCounts
    self._processMap["getTaskList"] = Processor.process_getTaskList
    self._processMap["getTask"] = Processor.process_getTask
    self._processMap["getJobCounters"] = Processor.process_getJobCounters
    self._processMap["getJobCounterRollups"] = Processor.process_getJobCounterRollups
    self._processMap["getActiveTrackers"] = Processor.process_getActiveTrackers
    self._processMap["getBlacklistedTrackers"] = Processor.process_getBlacklistedTrackers
    self._processMap["getAllTrackers"] = Processor.process_getAllTrackers
    self._processMap["getTracker"] = Processor.process_getTracker
    self._processMap["getCurrentTime"] = Processor.process_getCurrentTime
    self._processMap["getJobConfXML"] = Processor.process_getJobConfXML
    self._processMap["killJob"] = Processor.process_killJob
    self._processMap["killTaskAttempt"] = Processor.process_killTaskAttempt
    self._processMap["setJobPriority"] = Processor.process_setJobPriority
    self._processMap["getDelegationToken"] = Processor.process_getDelegationToken

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_getJobTrackerName(self, seqid, iprot, oprot):
    args = getJobTrackerName_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getJobTrackerName_result()
    result.success = self._handler.getJobTrackerName(args.ctx)
    oprot.writeMessageBegin("getJobTrackerName", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getClusterStatus(self, seqid, iprot, oprot):
    args = getClusterStatus_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getClusterStatus_result()
    result.success = self._handler.getClusterStatus(args.ctx)
    oprot.writeMessageBegin("getClusterStatus", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getQueues(self, seqid, iprot, oprot):
    args = getQueues_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getQueues_result()
    try:
      result.success = self._handler.getQueues(args.ctx)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getQueues", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getJob(self, seqid, iprot, oprot):
    args = getJob_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getJob_result()
    try:
      result.success = self._handler.getJob(args.ctx, args.jobID)
    except JobNotFoundException, err:
      result.err = err
    oprot.writeMessageBegin("getJob", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRunningJobs(self, seqid, iprot, oprot):
    args = getRunningJobs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRunningJobs_result()
    result.success = self._handler.getRunningJobs(args.ctx)
    oprot.writeMessageBegin("getRunningJobs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getCompletedJobs(self, seqid, iprot, oprot):
    args = getCompletedJobs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getCompletedJobs_result()
    result.success = self._handler.getCompletedJobs(args.ctx)
    oprot.writeMessageBegin("getCompletedJobs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRetiredJob(self, seqid, iprot, oprot):
    args = getRetiredJob_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRetiredJob_result()
    try:
      result.success = self._handler.getRetiredJob(args.ctx, args.jobID)
    except JobNotFoundException, err:
      result.err = err
    oprot.writeMessageBegin("getRetiredJob", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRetiredJobs(self, seqid, iprot, oprot):
    args = getRetiredJobs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRetiredJobs_result()
    result.success = self._handler.getRetiredJobs(args.ctx, args.state)
    oprot.writeMessageBegin("getRetiredJobs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getFailedJobs(self, seqid, iprot, oprot):
    args = getFailedJobs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getFailedJobs_result()
    result.success = self._handler.getFailedJobs(args.ctx)
    oprot.writeMessageBegin("getFailedJobs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getKilledJobs(self, seqid, iprot, oprot):
    args = getKilledJobs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getKilledJobs_result()
    result.success = self._handler.getKilledJobs(args.ctx)
    oprot.writeMessageBegin("getKilledJobs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getAllJobs(self, seqid, iprot, oprot):
    args = getAllJobs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getAllJobs_result()
    result.success = self._handler.getAllJobs(args.ctx)
    oprot.writeMessageBegin("getAllJobs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getUserJobCounts(self, seqid, iprot, oprot):
    args = getUserJobCounts_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getUserJobCounts_result()
    result.success = self._handler.getUserJobCounts(args.ctx, args.user)
    oprot.writeMessageBegin("getUserJobCounts", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTaskList(self, seqid, iprot, oprot):
    args = getTaskList_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTaskList_result()
    try:
      result.success = self._handler.getTaskList(args.ctx, args.jobID, args.types, args.states, args.text, args.count, args.offset)
    except JobNotFoundException, err:
      result.err = err
    oprot.writeMessageBegin("getTaskList", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTask(self, seqid, iprot, oprot):
    args = getTask_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTask_result()
    try:
      result.success = self._handler.getTask(args.ctx, args.taskID)
    except JobNotFoundException, jnf:
      result.jnf = jnf
    except TaskNotFoundException, tnf:
      result.tnf = tnf
    oprot.writeMessageBegin("getTask", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getJobCounters(self, seqid, iprot, oprot):
    args = getJobCounters_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getJobCounters_result()
    try:
      result.success = self._handler.getJobCounters(args.ctx, args.jobID)
    except JobNotFoundException, err:
      result.err = err
    oprot.writeMessageBegin("getJobCounters", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getJobCounterRollups(self, seqid, iprot, oprot):
    args = getJobCounterRollups_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getJobCounterRollups_result()
    try:
      result.success = self._handler.getJobCounterRollups(args.ctx, args.jobID)
    except JobNotFoundException, err:
      result.err = err
    oprot.writeMessageBegin("getJobCounterRollups", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getActiveTrackers(self, seqid, iprot, oprot):
    args = getActiveTrackers_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getActiveTrackers_result()
    result.success = self._handler.getActiveTrackers(args.ctx)
    oprot.writeMessageBegin("getActiveTrackers", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getBlacklistedTrackers(self, seqid, iprot, oprot):
    args = getBlacklistedTrackers_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getBlacklistedTrackers_result()
    result.success = self._handler.getBlacklistedTrackers(args.ctx)
    oprot.writeMessageBegin("getBlacklistedTrackers", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getAllTrackers(self, seqid, iprot, oprot):
    args = getAllTrackers_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getAllTrackers_result()
    result.success = self._handler.getAllTrackers(args.ctx)
    oprot.writeMessageBegin("getAllTrackers", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTracker(self, seqid, iprot, oprot):
    args = getTracker_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTracker_result()
    try:
      result.success = self._handler.getTracker(args.ctx, args.name)
    except TaskTrackerNotFoundException, tne:
      result.tne = tne
    oprot.writeMessageBegin("getTracker", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getCurrentTime(self, seqid, iprot, oprot):
    args = getCurrentTime_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getCurrentTime_result()
    result.success = self._handler.getCurrentTime(args.ctx)
    oprot.writeMessageBegin("getCurrentTime", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getJobConfXML(self, seqid, iprot, oprot):
    args = getJobConfXML_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getJobConfXML_result()
    try:
      result.success = self._handler.getJobConfXML(args.ctx, args.jobID)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getJobConfXML", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_killJob(self, seqid, iprot, oprot):
    args = killJob_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = killJob_result()
    try:
      self._handler.killJob(args.ctx, args.jobID)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    except JobNotFoundException, jne:
      result.jne = jne
    oprot.writeMessageBegin("killJob", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_killTaskAttempt(self, seqid, iprot, oprot):
    args = killTaskAttempt_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = killTaskAttempt_result()
    try:
      self._handler.killTaskAttempt(args.ctx, args.attemptID)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    except TaskAttemptNotFoundException, tne:
      result.tne = tne
    except JobNotFoundException, jne:
      result.jne = jne
    oprot.writeMessageBegin("killTaskAttempt", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setJobPriority(self, seqid, iprot, oprot):
    args = setJobPriority_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setJobPriority_result()
    try:
      self._handler.setJobPriority(args.ctx, args.jobID, args.priority)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    except JobNotFoundException, jne:
      result.jne = jne
    oprot.writeMessageBegin("setJobPriority", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getDelegationToken(self, seqid, iprot, oprot):
    args = getDelegationToken_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getDelegationToken_result()
    try:
      result.success = self._handler.getDelegationToken(args.ctx, args.renewer)
    except hadoop.api.common.ttypes.IOException, err:
      result.err = err
    oprot.writeMessageBegin("getDelegationToken", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class getJobTrackerName_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobTrackerName_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobTrackerName_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobTrackerName_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getClusterStatus_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getClusterStatus_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getClusterStatus_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftClusterStatus, ThriftClusterStatus.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftClusterStatus()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getClusterStatus_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getQueues_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getQueues_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getQueues_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobQueueList, ThriftJobQueueList.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobQueueList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getQueues_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJob_args(object):
  """
  Attributes:
   - ctx
   - jobID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None,):
    self.ctx = ctx
    self.jobID = jobID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJob_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJob_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobInProgress, ThriftJobInProgress.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobInProgress()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = JobNotFoundException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJob_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRunningJobs_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRunningJobs_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRunningJobs_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobList, ThriftJobList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRunningJobs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getCompletedJobs_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getCompletedJobs_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getCompletedJobs_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobList, ThriftJobList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getCompletedJobs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRetiredJob_args(object):
  """
  Attributes:
   - ctx
   - jobID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None,):
    self.ctx = ctx
    self.jobID = jobID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRetiredJob_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRetiredJob_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobInProgress, ThriftJobInProgress.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobInProgress()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = JobNotFoundException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRetiredJob_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRetiredJobs_args(object):
  """
  Attributes:
   - ctx
   - state
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'state', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, state=None,):
    self.ctx = ctx
    self.state = state

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.I32:
          self.state = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRetiredJobs_args')
    if self.state is not None:
      oprot.writeFieldBegin('state', TType.I32, 1)
      oprot.writeI32(self.state)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRetiredJobs_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobList, ThriftJobList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRetiredJobs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getFailedJobs_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getFailedJobs_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getFailedJobs_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobList, ThriftJobList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getFailedJobs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getKilledJobs_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getKilledJobs_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getKilledJobs_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobList, ThriftJobList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getKilledJobs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getAllJobs_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getAllJobs_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getAllJobs_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobList, ThriftJobList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getAllJobs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getUserJobCounts_args(object):
  """
  Attributes:
   - ctx
   - user
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 1
    (2, TType.STRING, 'user', None, None, ), # 2
  )

  def __init__(self, ctx=None, user=None,):
    self.ctx = ctx
    self.user = user

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.user = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getUserJobCounts_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 1)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    if self.user is not None:
      oprot.writeFieldBegin('user', TType.STRING, 2)
      oprot.writeString(self.user)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getUserJobCounts_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftUserJobCounts, ThriftUserJobCounts.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftUserJobCounts()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getUserJobCounts_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTaskList_args(object):
  """
  Attributes:
   - ctx
   - jobID
   - types
   - states
   - text
   - count
   - offset
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 2
    (3, TType.SET, 'types', (TType.I32,None), None, ), # 3
    (4, TType.SET, 'states', (TType.I32,None), None, ), # 4
    (5, TType.STRING, 'text', None, None, ), # 5
    (6, TType.I32, 'count', None, None, ), # 6
    (7, TType.I32, 'offset', None, None, ), # 7
  )

  def __init__(self, ctx=None, jobID=None, types=None, states=None, text=None, count=None, offset=None,):
    self.ctx = ctx
    self.jobID = jobID
    self.types = types
    self.states = states
    self.text = text
    self.count = count
    self.offset = offset

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.SET:
          self.types = set()
          (_etype107, _size104) = iprot.readSetBegin()
          for _i108 in xrange(_size104):
            _elem109 = iprot.readI32();
            self.types.add(_elem109)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.SET:
          self.states = set()
          (_etype113, _size110) = iprot.readSetBegin()
          for _i114 in xrange(_size110):
            _elem115 = iprot.readI32();
            self.states.add(_elem115)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.text = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.count = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I32:
          self.offset = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTaskList_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 1)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 2)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.types is not None:
      oprot.writeFieldBegin('types', TType.SET, 3)
      oprot.writeSetBegin(TType.I32, len(self.types))
      for iter116 in self.types:
        oprot.writeI32(iter116)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    if self.states is not None:
      oprot.writeFieldBegin('states', TType.SET, 4)
      oprot.writeSetBegin(TType.I32, len(self.states))
      for iter117 in self.states:
        oprot.writeI32(iter117)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    if self.text is not None:
      oprot.writeFieldBegin('text', TType.STRING, 5)
      oprot.writeString(self.text)
      oprot.writeFieldEnd()
    if self.count is not None:
      oprot.writeFieldBegin('count', TType.I32, 6)
      oprot.writeI32(self.count)
      oprot.writeFieldEnd()
    if self.offset is not None:
      oprot.writeFieldBegin('offset', TType.I32, 7)
      oprot.writeI32(self.offset)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTaskList_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftTaskInProgressList, ThriftTaskInProgressList.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftTaskInProgressList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = JobNotFoundException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTaskList_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTask_args(object):
  """
  Attributes:
   - ctx
   - taskID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'taskID', (ThriftTaskID, ThriftTaskID.thrift_spec), None, ), # 2
  )

  def __init__(self, ctx=None, taskID=None,):
    self.ctx = ctx
    self.taskID = taskID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.taskID = ThriftTaskID()
          self.taskID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTask_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 1)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    if self.taskID is not None:
      oprot.writeFieldBegin('taskID', TType.STRUCT, 2)
      self.taskID.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTask_result(object):
  """
  Attributes:
   - success
   - jnf
   - tnf
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftTaskInProgress, ThriftTaskInProgress.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'jnf', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'tnf', (TaskNotFoundException, TaskNotFoundException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, jnf=None, tnf=None,):
    self.success = success
    self.jnf = jnf
    self.tnf = tnf

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftTaskInProgress()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jnf = JobNotFoundException()
          self.jnf.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.tnf = TaskNotFoundException()
          self.tnf.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTask_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.jnf is not None:
      oprot.writeFieldBegin('jnf', TType.STRUCT, 1)
      self.jnf.write(oprot)
      oprot.writeFieldEnd()
    if self.tnf is not None:
      oprot.writeFieldBegin('tnf', TType.STRUCT, 2)
      self.tnf.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobCounters_args(object):
  """
  Attributes:
   - ctx
   - jobID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None,):
    self.ctx = ctx
    self.jobID = jobID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobCounters_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobCounters_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftGroupList, ThriftGroupList.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftGroupList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = JobNotFoundException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobCounters_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobCounterRollups_args(object):
  """
  Attributes:
   - ctx
   - jobID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None,):
    self.ctx = ctx
    self.jobID = jobID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobCounterRollups_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobCounterRollups_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftJobCounterRollups, ThriftJobCounterRollups.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftJobCounterRollups()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = JobNotFoundException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobCounterRollups_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getActiveTrackers_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getActiveTrackers_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getActiveTrackers_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftTaskTrackerStatusList, ThriftTaskTrackerStatusList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftTaskTrackerStatusList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getActiveTrackers_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getBlacklistedTrackers_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getBlacklistedTrackers_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getBlacklistedTrackers_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftTaskTrackerStatusList, ThriftTaskTrackerStatusList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftTaskTrackerStatusList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getBlacklistedTrackers_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getAllTrackers_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getAllTrackers_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getAllTrackers_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftTaskTrackerStatusList, ThriftTaskTrackerStatusList.thrift_spec), None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftTaskTrackerStatusList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getAllTrackers_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTracker_args(object):
  """
  Attributes:
   - ctx
   - name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'name', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, name=None,):
    self.ctx = ctx
    self.name = name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTracker_args')
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 1)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTracker_result(object):
  """
  Attributes:
   - success
   - tne
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (ThriftTaskTrackerStatus, ThriftTaskTrackerStatus.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'tne', (TaskTrackerNotFoundException, TaskTrackerNotFoundException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, tne=None,):
    self.success = success
    self.tne = tne

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = ThriftTaskTrackerStatus()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.tne = TaskTrackerNotFoundException()
          self.tne.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTracker_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.tne is not None:
      oprot.writeFieldBegin('tne', TType.STRUCT, 1)
      self.tne.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getCurrentTime_args(object):
  """
  Attributes:
   - ctx
  """

  thrift_spec = (
    None, # 0
    None, # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None,):
    self.ctx = ctx

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getCurrentTime_args')
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getCurrentTime_result(object):
  """
  Attributes:
   - success
  """

  thrift_spec = (
    (0, TType.I64, 'success', None, None, ), # 0
  )

  def __init__(self, success=None,):
    self.success = success

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I64:
          self.success = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getCurrentTime_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I64, 0)
      oprot.writeI64(self.success)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobConfXML_args(object):
  """
  Attributes:
   - ctx
   - jobID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None,):
    self.ctx = ctx
    self.jobID = jobID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobConfXML_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getJobConfXML_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getJobConfXML_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class killJob_args(object):
  """
  Attributes:
   - ctx
   - jobID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None,):
    self.ctx = ctx
    self.jobID = jobID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('killJob_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class killJob_result(object):
  """
  Attributes:
   - err
   - jne
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'jne', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 2
  )

  def __init__(self, err=None, jne=None,):
    self.err = err
    self.jne = jne

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.jne = JobNotFoundException()
          self.jne.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('killJob_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    if self.jne is not None:
      oprot.writeFieldBegin('jne', TType.STRUCT, 2)
      self.jne.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class killTaskAttempt_args(object):
  """
  Attributes:
   - ctx
   - attemptID
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'attemptID', (ThriftTaskAttemptID, ThriftTaskAttemptID.thrift_spec), None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, attemptID=None,):
    self.ctx = ctx
    self.attemptID = attemptID

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.attemptID = ThriftTaskAttemptID()
          self.attemptID.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('killTaskAttempt_args')
    if self.attemptID is not None:
      oprot.writeFieldBegin('attemptID', TType.STRUCT, 1)
      self.attemptID.write(oprot)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class killTaskAttempt_result(object):
  """
  Attributes:
   - err
   - tne
   - jne
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'tne', (TaskAttemptNotFoundException, TaskAttemptNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'jne', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, err=None, tne=None, jne=None,):
    self.err = err
    self.tne = tne
    self.jne = jne

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.tne = TaskAttemptNotFoundException()
          self.tne.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.jne = JobNotFoundException()
          self.jne.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('killTaskAttempt_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    if self.tne is not None:
      oprot.writeFieldBegin('tne', TType.STRUCT, 2)
      self.tne.write(oprot)
      oprot.writeFieldEnd()
    if self.jne is not None:
      oprot.writeFieldBegin('jne', TType.STRUCT, 3)
      self.jne.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setJobPriority_args(object):
  """
  Attributes:
   - ctx
   - jobID
   - priority
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'jobID', (ThriftJobID, ThriftJobID.thrift_spec), None, ), # 1
    (2, TType.I32, 'priority', None, None, ), # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, jobID=None, priority=None,):
    self.ctx = ctx
    self.jobID = jobID
    self.priority = priority

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.jobID = ThriftJobID()
          self.jobID.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.priority = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setJobPriority_args')
    if self.jobID is not None:
      oprot.writeFieldBegin('jobID', TType.STRUCT, 1)
      self.jobID.write(oprot)
      oprot.writeFieldEnd()
    if self.priority is not None:
      oprot.writeFieldBegin('priority', TType.I32, 2)
      oprot.writeI32(self.priority)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setJobPriority_result(object):
  """
  Attributes:
   - err
   - jne
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'jne', (JobNotFoundException, JobNotFoundException.thrift_spec), None, ), # 2
  )

  def __init__(self, err=None, jne=None,):
    self.err = err
    self.jne = jne

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.jne = JobNotFoundException()
          self.jne.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setJobPriority_result')
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    if self.jne is not None:
      oprot.writeFieldBegin('jne', TType.STRUCT, 2)
      self.jne.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDelegationToken_args(object):
  """
  Attributes:
   - ctx
   - renewer
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'renewer', None, None, ), # 1
    None, # 2
    None, # 3
    None, # 4
    None, # 5
    None, # 6
    None, # 7
    None, # 8
    None, # 9
    (10, TType.STRUCT, 'ctx', (hadoop.api.common.ttypes.RequestContext, hadoop.api.common.ttypes.RequestContext.thrift_spec), None, ), # 10
  )

  def __init__(self, ctx=None, renewer=None,):
    self.ctx = ctx
    self.renewer = renewer

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 10:
        if ftype == TType.STRUCT:
          self.ctx = hadoop.api.common.ttypes.RequestContext()
          self.ctx.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRING:
          self.renewer = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDelegationToken_args')
    if self.renewer is not None:
      oprot.writeFieldBegin('renewer', TType.STRING, 1)
      oprot.writeString(self.renewer)
      oprot.writeFieldEnd()
    if self.ctx is not None:
      oprot.writeFieldBegin('ctx', TType.STRUCT, 10)
      self.ctx.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDelegationToken_result(object):
  """
  Attributes:
   - success
   - err
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (hadoop.api.common.ttypes.ThriftDelegationToken, hadoop.api.common.ttypes.ThriftDelegationToken.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'err', (hadoop.api.common.ttypes.IOException, hadoop.api.common.ttypes.IOException.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, err=None,):
    self.success = success
    self.err = err

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = hadoop.api.common.ttypes.ThriftDelegationToken()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.err = hadoop.api.common.ttypes.IOException()
          self.err.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDelegationToken_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.err is not None:
      oprot.writeFieldBegin('err', TType.STRUCT, 1)
      self.err.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
