## Licensed to Cloudera, Inc. under one
## or more contributor license agreements.  See the NOTICE file
## distributed with this work for additional information
## regarding copyright ownership.  Cloudera, Inc. licenses this file
## to you under the Apache License, Version 2.0 (the
## "License"); you may not use this file except in compliance
## with the License.  You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.

<%!
import posixpath
%>


<%def name="filelink(path)">${ path + '#' + posixpath.basename(path) }</%def>


<%def name="prepares(prepares)">
        % if prepares:
            <prepare>
                % for p in prepares:
                  <%
                    # Same as Fs action convention. No change if path is just a parameter.
                    operation = p['type']
                    path = p['value']

                    if not path.startswith('/') and not path.startswith('$') and not path.startswith('hdfs://'):
                      path = '/user/%(username)s/%(path)s' % {'username': '${wf:user()}', 'path': path}

                    if not path.startswith('hdfs://'):
                      path = '%(nameNode)s%(path)s' % {'nameNode': '${nameNode}', 'path': path}
                  %>

                  <${ operation } path="${ path }"/>
                % endfor
            </prepare>
        % endif
</%def>


<%def name="configuration(properties)">
        % if properties:
            <configuration>
                % for p in properties:
                <property>
                    <name>${ p['name'] }</name>
                    <value>${ p['value'] }</value>
                </property>
                % endfor
            </configuration>
        % endif
</%def>


<%def name="distributed_cache(files, archives)">
    % for f in files:
        % if len(f) != 0:
            <file>${ filelink(f) }</file>
        % endif
    % endfor
    % for a in archives:
        % if len(a) != 0:
            <archive>${ a }</archive>
        % endif
    % endfor
</%def>
