/**
 * Autogenerated by Thrift Compiler (0.7.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.cloudera.beeswax.api;

import org.apache.commons.lang.builder.HashCodeBuilder;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeeswaxService {

  public interface Iface {

    /**
     * Submit a query and return a handle (QueryHandle). The query runs asynchronously.
     * 
     * @param query
     */
    public QueryHandle query(Query query) throws BeeswaxException, org.apache.thrift.TException;

    /**
     * run a query synchronously and return a handle (QueryHandle).
     * 
     * @param query
     * @param clientCtx
     */
    public QueryHandle executeAndWait(Query query, String clientCtx) throws BeeswaxException, org.apache.thrift.TException;

    /**
     * Get the query plan for a query.
     * 
     * @param query
     */
    public QueryExplanation explain(Query query) throws BeeswaxException, org.apache.thrift.TException;

    /**
     * Get the results of a query. This is non-blocking. Caller should check
     * Results.ready to determine if the results are in yet. The call requests
     * the batch size of fetch.
     * 
     * @param query_id
     * @param start_over
     * @param fetch_size
     */
    public Results fetch(QueryHandle query_id, boolean start_over, int fetch_size) throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException;

    /**
     * Get the state of the query
     * 
     * @param handle
     */
    public QueryState get_state(QueryHandle handle) throws QueryNotFoundException, org.apache.thrift.TException;

    /**
     * Get the result metadata
     * 
     * @param handle
     */
    public ResultsMetadata get_results_metadata(QueryHandle handle) throws QueryNotFoundException, org.apache.thrift.TException;

    /**
     * Used to test connection to server.  A "noop" command.
     * 
     * @param s
     */
    public String echo(String s) throws org.apache.thrift.TException;

    /**
     * Returns a string representation of the configuration object being used.
     * Handy for debugging.
     */
    public String dump_config() throws org.apache.thrift.TException;

    /**
     * Get the log messages related to the given context.
     * 
     * @param context
     */
    public String get_log(String context) throws QueryNotFoundException, org.apache.thrift.TException;

    public List<ConfigVariable> get_default_configuration(boolean include_hadoop) throws org.apache.thrift.TException;

    public void close(QueryHandle handle) throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException;

    public void clean(String log_context) throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void query(Query query, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.query_call> resultHandler) throws org.apache.thrift.TException;

    public void executeAndWait(Query query, String clientCtx, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.executeAndWait_call> resultHandler) throws org.apache.thrift.TException;

    public void explain(Query query, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.explain_call> resultHandler) throws org.apache.thrift.TException;

    public void fetch(QueryHandle query_id, boolean start_over, int fetch_size, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.fetch_call> resultHandler) throws org.apache.thrift.TException;

    public void get_state(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_state_call> resultHandler) throws org.apache.thrift.TException;

    public void get_results_metadata(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_results_metadata_call> resultHandler) throws org.apache.thrift.TException;

    public void echo(String s, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.echo_call> resultHandler) throws org.apache.thrift.TException;

    public void dump_config(org.apache.thrift.async.AsyncMethodCallback<AsyncClient.dump_config_call> resultHandler) throws org.apache.thrift.TException;

    public void get_log(String context, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_log_call> resultHandler) throws org.apache.thrift.TException;

    public void get_default_configuration(boolean include_hadoop, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.get_default_configuration_call> resultHandler) throws org.apache.thrift.TException;

    public void close(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.close_call> resultHandler) throws org.apache.thrift.TException;

    public void clean(String log_context, org.apache.thrift.async.AsyncMethodCallback<AsyncClient.clean_call> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public QueryHandle query(Query query) throws BeeswaxException, org.apache.thrift.TException
    {
      send_query(query);
      return recv_query();
    }

    public void send_query(Query query) throws org.apache.thrift.TException
    {
      query_args args = new query_args();
      args.setQuery(query);
      sendBase("query", args);
    }

    public QueryHandle recv_query() throws BeeswaxException, org.apache.thrift.TException
    {
      query_result result = new query_result();
      receiveBase(result, "query");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "query failed: unknown result");
    }

    public QueryHandle executeAndWait(Query query, String clientCtx) throws BeeswaxException, org.apache.thrift.TException
    {
      send_executeAndWait(query, clientCtx);
      return recv_executeAndWait();
    }

    public void send_executeAndWait(Query query, String clientCtx) throws org.apache.thrift.TException
    {
      executeAndWait_args args = new executeAndWait_args();
      args.setQuery(query);
      args.setClientCtx(clientCtx);
      sendBase("executeAndWait", args);
    }

    public QueryHandle recv_executeAndWait() throws BeeswaxException, org.apache.thrift.TException
    {
      executeAndWait_result result = new executeAndWait_result();
      receiveBase(result, "executeAndWait");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "executeAndWait failed: unknown result");
    }

    public QueryExplanation explain(Query query) throws BeeswaxException, org.apache.thrift.TException
    {
      send_explain(query);
      return recv_explain();
    }

    public void send_explain(Query query) throws org.apache.thrift.TException
    {
      explain_args args = new explain_args();
      args.setQuery(query);
      sendBase("explain", args);
    }

    public QueryExplanation recv_explain() throws BeeswaxException, org.apache.thrift.TException
    {
      explain_result result = new explain_result();
      receiveBase(result, "explain");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "explain failed: unknown result");
    }

    public Results fetch(QueryHandle query_id, boolean start_over, int fetch_size) throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException
    {
      send_fetch(query_id, start_over, fetch_size);
      return recv_fetch();
    }

    public void send_fetch(QueryHandle query_id, boolean start_over, int fetch_size) throws org.apache.thrift.TException
    {
      fetch_args args = new fetch_args();
      args.setQuery_id(query_id);
      args.setStart_over(start_over);
      args.setFetch_size(fetch_size);
      sendBase("fetch", args);
    }

    public Results recv_fetch() throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException
    {
      fetch_result result = new fetch_result();
      receiveBase(result, "fetch");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      if (result.error2 != null) {
        throw result.error2;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "fetch failed: unknown result");
    }

    public QueryState get_state(QueryHandle handle) throws QueryNotFoundException, org.apache.thrift.TException
    {
      send_get_state(handle);
      return recv_get_state();
    }

    public void send_get_state(QueryHandle handle) throws org.apache.thrift.TException
    {
      get_state_args args = new get_state_args();
      args.setHandle(handle);
      sendBase("get_state", args);
    }

    public QueryState recv_get_state() throws QueryNotFoundException, org.apache.thrift.TException
    {
      get_state_result result = new get_state_result();
      receiveBase(result, "get_state");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_state failed: unknown result");
    }

    public ResultsMetadata get_results_metadata(QueryHandle handle) throws QueryNotFoundException, org.apache.thrift.TException
    {
      send_get_results_metadata(handle);
      return recv_get_results_metadata();
    }

    public void send_get_results_metadata(QueryHandle handle) throws org.apache.thrift.TException
    {
      get_results_metadata_args args = new get_results_metadata_args();
      args.setHandle(handle);
      sendBase("get_results_metadata", args);
    }

    public ResultsMetadata recv_get_results_metadata() throws QueryNotFoundException, org.apache.thrift.TException
    {
      get_results_metadata_result result = new get_results_metadata_result();
      receiveBase(result, "get_results_metadata");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_results_metadata failed: unknown result");
    }

    public String echo(String s) throws org.apache.thrift.TException
    {
      send_echo(s);
      return recv_echo();
    }

    public void send_echo(String s) throws org.apache.thrift.TException
    {
      echo_args args = new echo_args();
      args.setS(s);
      sendBase("echo", args);
    }

    public String recv_echo() throws org.apache.thrift.TException
    {
      echo_result result = new echo_result();
      receiveBase(result, "echo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "echo failed: unknown result");
    }

    public String dump_config() throws org.apache.thrift.TException
    {
      send_dump_config();
      return recv_dump_config();
    }

    public void send_dump_config() throws org.apache.thrift.TException
    {
      dump_config_args args = new dump_config_args();
      sendBase("dump_config", args);
    }

    public String recv_dump_config() throws org.apache.thrift.TException
    {
      dump_config_result result = new dump_config_result();
      receiveBase(result, "dump_config");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "dump_config failed: unknown result");
    }

    public String get_log(String context) throws QueryNotFoundException, org.apache.thrift.TException
    {
      send_get_log(context);
      return recv_get_log();
    }

    public void send_get_log(String context) throws org.apache.thrift.TException
    {
      get_log_args args = new get_log_args();
      args.setContext(context);
      sendBase("get_log", args);
    }

    public String recv_get_log() throws QueryNotFoundException, org.apache.thrift.TException
    {
      get_log_result result = new get_log_result();
      receiveBase(result, "get_log");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.error != null) {
        throw result.error;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_log failed: unknown result");
    }

    public List<ConfigVariable> get_default_configuration(boolean include_hadoop) throws org.apache.thrift.TException
    {
      send_get_default_configuration(include_hadoop);
      return recv_get_default_configuration();
    }

    public void send_get_default_configuration(boolean include_hadoop) throws org.apache.thrift.TException
    {
      get_default_configuration_args args = new get_default_configuration_args();
      args.setInclude_hadoop(include_hadoop);
      sendBase("get_default_configuration", args);
    }

    public List<ConfigVariable> recv_get_default_configuration() throws org.apache.thrift.TException
    {
      get_default_configuration_result result = new get_default_configuration_result();
      receiveBase(result, "get_default_configuration");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get_default_configuration failed: unknown result");
    }

    public void close(QueryHandle handle) throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException
    {
      send_close(handle);
      recv_close();
    }

    public void send_close(QueryHandle handle) throws org.apache.thrift.TException
    {
      close_args args = new close_args();
      args.setHandle(handle);
      sendBase("close", args);
    }

    public void recv_close() throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException
    {
      close_result result = new close_result();
      receiveBase(result, "close");
      if (result.error != null) {
        throw result.error;
      }
      if (result.error2 != null) {
        throw result.error2;
      }
      return;
    }

    public void clean(String log_context) throws org.apache.thrift.TException
    {
      send_clean(log_context);
      recv_clean();
    }

    public void send_clean(String log_context) throws org.apache.thrift.TException
    {
      clean_args args = new clean_args();
      args.setLog_context(log_context);
      sendBase("clean", args);
    }

    public void recv_clean() throws org.apache.thrift.TException
    {
      clean_result result = new clean_result();
      receiveBase(result, "clean");
      return;
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void query(Query query, org.apache.thrift.async.AsyncMethodCallback<query_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      query_call method_call = new query_call(query, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class query_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Query query;
      public query_call(Query query, org.apache.thrift.async.AsyncMethodCallback<query_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("query", org.apache.thrift.protocol.TMessageType.CALL, 0));
        query_args args = new query_args();
        args.setQuery(query);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public QueryHandle getResult() throws BeeswaxException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_query();
      }
    }

    public void executeAndWait(Query query, String clientCtx, org.apache.thrift.async.AsyncMethodCallback<executeAndWait_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      executeAndWait_call method_call = new executeAndWait_call(query, clientCtx, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class executeAndWait_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Query query;
      private String clientCtx;
      public executeAndWait_call(Query query, String clientCtx, org.apache.thrift.async.AsyncMethodCallback<executeAndWait_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
        this.clientCtx = clientCtx;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("executeAndWait", org.apache.thrift.protocol.TMessageType.CALL, 0));
        executeAndWait_args args = new executeAndWait_args();
        args.setQuery(query);
        args.setClientCtx(clientCtx);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public QueryHandle getResult() throws BeeswaxException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_executeAndWait();
      }
    }

    public void explain(Query query, org.apache.thrift.async.AsyncMethodCallback<explain_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      explain_call method_call = new explain_call(query, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class explain_call extends org.apache.thrift.async.TAsyncMethodCall {
      private Query query;
      public explain_call(Query query, org.apache.thrift.async.AsyncMethodCallback<explain_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query = query;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("explain", org.apache.thrift.protocol.TMessageType.CALL, 0));
        explain_args args = new explain_args();
        args.setQuery(query);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public QueryExplanation getResult() throws BeeswaxException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_explain();
      }
    }

    public void fetch(QueryHandle query_id, boolean start_over, int fetch_size, org.apache.thrift.async.AsyncMethodCallback<fetch_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      fetch_call method_call = new fetch_call(query_id, start_over, fetch_size, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class fetch_call extends org.apache.thrift.async.TAsyncMethodCall {
      private QueryHandle query_id;
      private boolean start_over;
      private int fetch_size;
      public fetch_call(QueryHandle query_id, boolean start_over, int fetch_size, org.apache.thrift.async.AsyncMethodCallback<fetch_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.query_id = query_id;
        this.start_over = start_over;
        this.fetch_size = fetch_size;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("fetch", org.apache.thrift.protocol.TMessageType.CALL, 0));
        fetch_args args = new fetch_args();
        args.setQuery_id(query_id);
        args.setStart_over(start_over);
        args.setFetch_size(fetch_size);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Results getResult() throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_fetch();
      }
    }

    public void get_state(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<get_state_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_state_call method_call = new get_state_call(handle, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_state_call extends org.apache.thrift.async.TAsyncMethodCall {
      private QueryHandle handle;
      public get_state_call(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<get_state_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.handle = handle;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_state", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_state_args args = new get_state_args();
        args.setHandle(handle);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public QueryState getResult() throws QueryNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_state();
      }
    }

    public void get_results_metadata(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<get_results_metadata_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_results_metadata_call method_call = new get_results_metadata_call(handle, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_results_metadata_call extends org.apache.thrift.async.TAsyncMethodCall {
      private QueryHandle handle;
      public get_results_metadata_call(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<get_results_metadata_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.handle = handle;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_results_metadata", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_results_metadata_args args = new get_results_metadata_args();
        args.setHandle(handle);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ResultsMetadata getResult() throws QueryNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_results_metadata();
      }
    }

    public void echo(String s, org.apache.thrift.async.AsyncMethodCallback<echo_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      echo_call method_call = new echo_call(s, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class echo_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String s;
      public echo_call(String s, org.apache.thrift.async.AsyncMethodCallback<echo_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.s = s;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("echo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        echo_args args = new echo_args();
        args.setS(s);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_echo();
      }
    }

    public void dump_config(org.apache.thrift.async.AsyncMethodCallback<dump_config_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      dump_config_call method_call = new dump_config_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class dump_config_call extends org.apache.thrift.async.TAsyncMethodCall {
      public dump_config_call(org.apache.thrift.async.AsyncMethodCallback<dump_config_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("dump_config", org.apache.thrift.protocol.TMessageType.CALL, 0));
        dump_config_args args = new dump_config_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_dump_config();
      }
    }

    public void get_log(String context, org.apache.thrift.async.AsyncMethodCallback<get_log_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_log_call method_call = new get_log_call(context, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_log_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String context;
      public get_log_call(String context, org.apache.thrift.async.AsyncMethodCallback<get_log_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.context = context;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_log", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_log_args args = new get_log_args();
        args.setContext(context);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws QueryNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_log();
      }
    }

    public void get_default_configuration(boolean include_hadoop, org.apache.thrift.async.AsyncMethodCallback<get_default_configuration_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_default_configuration_call method_call = new get_default_configuration_call(include_hadoop, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_default_configuration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private boolean include_hadoop;
      public get_default_configuration_call(boolean include_hadoop, org.apache.thrift.async.AsyncMethodCallback<get_default_configuration_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.include_hadoop = include_hadoop;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get_default_configuration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_default_configuration_args args = new get_default_configuration_args();
        args.setInclude_hadoop(include_hadoop);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<ConfigVariable> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get_default_configuration();
      }
    }

    public void close(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<close_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      close_call method_call = new close_call(handle, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class close_call extends org.apache.thrift.async.TAsyncMethodCall {
      private QueryHandle handle;
      public close_call(QueryHandle handle, org.apache.thrift.async.AsyncMethodCallback<close_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.handle = handle;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("close", org.apache.thrift.protocol.TMessageType.CALL, 0));
        close_args args = new close_args();
        args.setHandle(handle);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws QueryNotFoundException, BeeswaxException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_close();
      }
    }

    public void clean(String log_context, org.apache.thrift.async.AsyncMethodCallback<clean_call> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      clean_call method_call = new clean_call(log_context, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class clean_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String log_context;
      public clean_call(String log_context, org.apache.thrift.async.AsyncMethodCallback<clean_call> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.log_context = log_context;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("clean", org.apache.thrift.protocol.TMessageType.CALL, 0));
        clean_args args = new clean_args();
        args.setLog_context(log_context);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_clean();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("query", new query());
      processMap.put("executeAndWait", new executeAndWait());
      processMap.put("explain", new explain());
      processMap.put("fetch", new fetch());
      processMap.put("get_state", new get_state());
      processMap.put("get_results_metadata", new get_results_metadata());
      processMap.put("echo", new echo());
      processMap.put("dump_config", new dump_config());
      processMap.put("get_log", new get_log());
      processMap.put("get_default_configuration", new get_default_configuration());
      processMap.put("close", new close());
      processMap.put("clean", new clean());
      return processMap;
    }

    private static class query<I extends Iface> extends org.apache.thrift.ProcessFunction<I, query_args> {
      public query() {
        super("query");
      }

      protected query_args getEmptyArgsInstance() {
        return new query_args();
      }

      protected query_result getResult(I iface, query_args args) throws org.apache.thrift.TException {
        query_result result = new query_result();
        try {
          result.success = iface.query(args.query);
        } catch (BeeswaxException error) {
          result.error = error;
        }
        return result;
      }
    }

    private static class executeAndWait<I extends Iface> extends org.apache.thrift.ProcessFunction<I, executeAndWait_args> {
      public executeAndWait() {
        super("executeAndWait");
      }

      protected executeAndWait_args getEmptyArgsInstance() {
        return new executeAndWait_args();
      }

      protected executeAndWait_result getResult(I iface, executeAndWait_args args) throws org.apache.thrift.TException {
        executeAndWait_result result = new executeAndWait_result();
        try {
          result.success = iface.executeAndWait(args.query, args.clientCtx);
        } catch (BeeswaxException error) {
          result.error = error;
        }
        return result;
      }
    }

    private static class explain<I extends Iface> extends org.apache.thrift.ProcessFunction<I, explain_args> {
      public explain() {
        super("explain");
      }

      protected explain_args getEmptyArgsInstance() {
        return new explain_args();
      }

      protected explain_result getResult(I iface, explain_args args) throws org.apache.thrift.TException {
        explain_result result = new explain_result();
        try {
          result.success = iface.explain(args.query);
        } catch (BeeswaxException error) {
          result.error = error;
        }
        return result;
      }
    }

    private static class fetch<I extends Iface> extends org.apache.thrift.ProcessFunction<I, fetch_args> {
      public fetch() {
        super("fetch");
      }

      protected fetch_args getEmptyArgsInstance() {
        return new fetch_args();
      }

      protected fetch_result getResult(I iface, fetch_args args) throws org.apache.thrift.TException {
        fetch_result result = new fetch_result();
        try {
          result.success = iface.fetch(args.query_id, args.start_over, args.fetch_size);
        } catch (QueryNotFoundException error) {
          result.error = error;
        } catch (BeeswaxException error2) {
          result.error2 = error2;
        }
        return result;
      }
    }

    private static class get_state<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_state_args> {
      public get_state() {
        super("get_state");
      }

      protected get_state_args getEmptyArgsInstance() {
        return new get_state_args();
      }

      protected get_state_result getResult(I iface, get_state_args args) throws org.apache.thrift.TException {
        get_state_result result = new get_state_result();
        try {
          result.success = iface.get_state(args.handle);
        } catch (QueryNotFoundException error) {
          result.error = error;
        }
        return result;
      }
    }

    private static class get_results_metadata<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_results_metadata_args> {
      public get_results_metadata() {
        super("get_results_metadata");
      }

      protected get_results_metadata_args getEmptyArgsInstance() {
        return new get_results_metadata_args();
      }

      protected get_results_metadata_result getResult(I iface, get_results_metadata_args args) throws org.apache.thrift.TException {
        get_results_metadata_result result = new get_results_metadata_result();
        try {
          result.success = iface.get_results_metadata(args.handle);
        } catch (QueryNotFoundException error) {
          result.error = error;
        }
        return result;
      }
    }

    private static class echo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, echo_args> {
      public echo() {
        super("echo");
      }

      protected echo_args getEmptyArgsInstance() {
        return new echo_args();
      }

      protected echo_result getResult(I iface, echo_args args) throws org.apache.thrift.TException {
        echo_result result = new echo_result();
        result.success = iface.echo(args.s);
        return result;
      }
    }

    private static class dump_config<I extends Iface> extends org.apache.thrift.ProcessFunction<I, dump_config_args> {
      public dump_config() {
        super("dump_config");
      }

      protected dump_config_args getEmptyArgsInstance() {
        return new dump_config_args();
      }

      protected dump_config_result getResult(I iface, dump_config_args args) throws org.apache.thrift.TException {
        dump_config_result result = new dump_config_result();
        result.success = iface.dump_config();
        return result;
      }
    }

    private static class get_log<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_log_args> {
      public get_log() {
        super("get_log");
      }

      protected get_log_args getEmptyArgsInstance() {
        return new get_log_args();
      }

      protected get_log_result getResult(I iface, get_log_args args) throws org.apache.thrift.TException {
        get_log_result result = new get_log_result();
        try {
          result.success = iface.get_log(args.context);
        } catch (QueryNotFoundException error) {
          result.error = error;
        }
        return result;
      }
    }

    private static class get_default_configuration<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_default_configuration_args> {
      public get_default_configuration() {
        super("get_default_configuration");
      }

      protected get_default_configuration_args getEmptyArgsInstance() {
        return new get_default_configuration_args();
      }

      protected get_default_configuration_result getResult(I iface, get_default_configuration_args args) throws org.apache.thrift.TException {
        get_default_configuration_result result = new get_default_configuration_result();
        result.success = iface.get_default_configuration(args.include_hadoop);
        return result;
      }
    }

    private static class close<I extends Iface> extends org.apache.thrift.ProcessFunction<I, close_args> {
      public close() {
        super("close");
      }

      protected close_args getEmptyArgsInstance() {
        return new close_args();
      }

      protected close_result getResult(I iface, close_args args) throws org.apache.thrift.TException {
        close_result result = new close_result();
        try {
          iface.close(args.handle);
        } catch (QueryNotFoundException error) {
          result.error = error;
        } catch (BeeswaxException error2) {
          result.error2 = error2;
        }
        return result;
      }
    }

    private static class clean<I extends Iface> extends org.apache.thrift.ProcessFunction<I, clean_args> {
      public clean() {
        super("clean");
      }

      protected clean_args getEmptyArgsInstance() {
        return new clean_args();
      }

      protected clean_result getResult(I iface, clean_args args) throws org.apache.thrift.TException {
        clean_result result = new clean_result();
        iface.clean(args.log_context);
        return result;
      }
    }

  }

  public static class query_args implements org.apache.thrift.TBase<query_args, query_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("query_args");

    private static final org.apache.thrift.protocol.TField QUERY_FIELD_DESC = new org.apache.thrift.protocol.TField("query", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public Query query; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      QUERY((short)1, "query");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // QUERY
            return QUERY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.QUERY, new org.apache.thrift.meta_data.FieldMetaData("query", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Query.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(query_args.class, metaDataMap);
    }

    public query_args() {
    }

    public query_args(
      Query query)
    {
      this();
      this.query = query;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public query_args(query_args other) {
      if (other.isSetQuery()) {
        this.query = new Query(other.query);
      }
    }

    public query_args deepCopy() {
      return new query_args(this);
    }

    @Override
    public void clear() {
      this.query = null;
    }

    public Query getQuery() {
      return this.query;
    }

    public query_args setQuery(Query query) {
      this.query = query;
      return this;
    }

    public void unsetQuery() {
      this.query = null;
    }

    /** Returns true if field query is set (has been assigned a value) and false otherwise */
    public boolean isSetQuery() {
      return this.query != null;
    }

    public void setQueryIsSet(boolean value) {
      if (!value) {
        this.query = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case QUERY:
        if (value == null) {
          unsetQuery();
        } else {
          setQuery((Query)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case QUERY:
        return getQuery();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case QUERY:
        return isSetQuery();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof query_args)
        return this.equals((query_args)that);
      return false;
    }

    public boolean equals(query_args that) {
      if (that == null)
        return false;

      boolean this_present_query = true && this.isSetQuery();
      boolean that_present_query = true && that.isSetQuery();
      if (this_present_query || that_present_query) {
        if (!(this_present_query && that_present_query))
          return false;
        if (!this.query.equals(that.query))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_query = true && (isSetQuery());
      builder.append(present_query);
      if (present_query)
        builder.append(query);

      return builder.toHashCode();
    }

    public int compareTo(query_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      query_args typedOther = (query_args)other;

      lastComparison = Boolean.valueOf(isSetQuery()).compareTo(typedOther.isSetQuery());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetQuery()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.query, typedOther.query);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // QUERY
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.query = new Query();
              this.query.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.query != null) {
        oprot.writeFieldBegin(QUERY_FIELD_DESC);
        this.query.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("query_args(");
      boolean first = true;

      sb.append("query:");
      if (this.query == null) {
        sb.append("null");
      } else {
        sb.append(this.query);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class query_result implements org.apache.thrift.TBase<query_result, query_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("query_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public QueryHandle success; // required
    public BeeswaxException error; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryHandle.class)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(query_result.class, metaDataMap);
    }

    public query_result() {
    }

    public query_result(
      QueryHandle success,
      BeeswaxException error)
    {
      this();
      this.success = success;
      this.error = error;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public query_result(query_result other) {
      if (other.isSetSuccess()) {
        this.success = new QueryHandle(other.success);
      }
      if (other.isSetError()) {
        this.error = new BeeswaxException(other.error);
      }
    }

    public query_result deepCopy() {
      return new query_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
    }

    public QueryHandle getSuccess() {
      return this.success;
    }

    public query_result setSuccess(QueryHandle success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public BeeswaxException getError() {
      return this.error;
    }

    public query_result setError(BeeswaxException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((QueryHandle)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((BeeswaxException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof query_result)
        return this.equals((query_result)that);
      return false;
    }

    public boolean equals(query_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      return builder.toHashCode();
    }

    public int compareTo(query_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      query_result typedOther = (query_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new QueryHandle();
              this.success.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new BeeswaxException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("query_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class executeAndWait_args implements org.apache.thrift.TBase<executeAndWait_args, executeAndWait_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("executeAndWait_args");

    private static final org.apache.thrift.protocol.TField QUERY_FIELD_DESC = new org.apache.thrift.protocol.TField("query", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CLIENT_CTX_FIELD_DESC = new org.apache.thrift.protocol.TField("clientCtx", org.apache.thrift.protocol.TType.STRING, (short)2);

    public Query query; // required
    public String clientCtx; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      QUERY((short)1, "query"),
      CLIENT_CTX((short)2, "clientCtx");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // QUERY
            return QUERY;
          case 2: // CLIENT_CTX
            return CLIENT_CTX;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.QUERY, new org.apache.thrift.meta_data.FieldMetaData("query", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Query.class)));
      tmpMap.put(_Fields.CLIENT_CTX, new org.apache.thrift.meta_data.FieldMetaData("clientCtx", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "LogContextId")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(executeAndWait_args.class, metaDataMap);
    }

    public executeAndWait_args() {
    }

    public executeAndWait_args(
      Query query,
      String clientCtx)
    {
      this();
      this.query = query;
      this.clientCtx = clientCtx;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public executeAndWait_args(executeAndWait_args other) {
      if (other.isSetQuery()) {
        this.query = new Query(other.query);
      }
      if (other.isSetClientCtx()) {
        this.clientCtx = other.clientCtx;
      }
    }

    public executeAndWait_args deepCopy() {
      return new executeAndWait_args(this);
    }

    @Override
    public void clear() {
      this.query = null;
      this.clientCtx = null;
    }

    public Query getQuery() {
      return this.query;
    }

    public executeAndWait_args setQuery(Query query) {
      this.query = query;
      return this;
    }

    public void unsetQuery() {
      this.query = null;
    }

    /** Returns true if field query is set (has been assigned a value) and false otherwise */
    public boolean isSetQuery() {
      return this.query != null;
    }

    public void setQueryIsSet(boolean value) {
      if (!value) {
        this.query = null;
      }
    }

    public String getClientCtx() {
      return this.clientCtx;
    }

    public executeAndWait_args setClientCtx(String clientCtx) {
      this.clientCtx = clientCtx;
      return this;
    }

    public void unsetClientCtx() {
      this.clientCtx = null;
    }

    /** Returns true if field clientCtx is set (has been assigned a value) and false otherwise */
    public boolean isSetClientCtx() {
      return this.clientCtx != null;
    }

    public void setClientCtxIsSet(boolean value) {
      if (!value) {
        this.clientCtx = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case QUERY:
        if (value == null) {
          unsetQuery();
        } else {
          setQuery((Query)value);
        }
        break;

      case CLIENT_CTX:
        if (value == null) {
          unsetClientCtx();
        } else {
          setClientCtx((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case QUERY:
        return getQuery();

      case CLIENT_CTX:
        return getClientCtx();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case QUERY:
        return isSetQuery();
      case CLIENT_CTX:
        return isSetClientCtx();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof executeAndWait_args)
        return this.equals((executeAndWait_args)that);
      return false;
    }

    public boolean equals(executeAndWait_args that) {
      if (that == null)
        return false;

      boolean this_present_query = true && this.isSetQuery();
      boolean that_present_query = true && that.isSetQuery();
      if (this_present_query || that_present_query) {
        if (!(this_present_query && that_present_query))
          return false;
        if (!this.query.equals(that.query))
          return false;
      }

      boolean this_present_clientCtx = true && this.isSetClientCtx();
      boolean that_present_clientCtx = true && that.isSetClientCtx();
      if (this_present_clientCtx || that_present_clientCtx) {
        if (!(this_present_clientCtx && that_present_clientCtx))
          return false;
        if (!this.clientCtx.equals(that.clientCtx))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_query = true && (isSetQuery());
      builder.append(present_query);
      if (present_query)
        builder.append(query);

      boolean present_clientCtx = true && (isSetClientCtx());
      builder.append(present_clientCtx);
      if (present_clientCtx)
        builder.append(clientCtx);

      return builder.toHashCode();
    }

    public int compareTo(executeAndWait_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      executeAndWait_args typedOther = (executeAndWait_args)other;

      lastComparison = Boolean.valueOf(isSetQuery()).compareTo(typedOther.isSetQuery());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetQuery()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.query, typedOther.query);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetClientCtx()).compareTo(typedOther.isSetClientCtx());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClientCtx()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.clientCtx, typedOther.clientCtx);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // QUERY
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.query = new Query();
              this.query.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // CLIENT_CTX
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.clientCtx = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.query != null) {
        oprot.writeFieldBegin(QUERY_FIELD_DESC);
        this.query.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.clientCtx != null) {
        oprot.writeFieldBegin(CLIENT_CTX_FIELD_DESC);
        oprot.writeString(this.clientCtx);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("executeAndWait_args(");
      boolean first = true;

      sb.append("query:");
      if (this.query == null) {
        sb.append("null");
      } else {
        sb.append(this.query);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("clientCtx:");
      if (this.clientCtx == null) {
        sb.append("null");
      } else {
        sb.append(this.clientCtx);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class executeAndWait_result implements org.apache.thrift.TBase<executeAndWait_result, executeAndWait_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("executeAndWait_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public QueryHandle success; // required
    public BeeswaxException error; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryHandle.class)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(executeAndWait_result.class, metaDataMap);
    }

    public executeAndWait_result() {
    }

    public executeAndWait_result(
      QueryHandle success,
      BeeswaxException error)
    {
      this();
      this.success = success;
      this.error = error;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public executeAndWait_result(executeAndWait_result other) {
      if (other.isSetSuccess()) {
        this.success = new QueryHandle(other.success);
      }
      if (other.isSetError()) {
        this.error = new BeeswaxException(other.error);
      }
    }

    public executeAndWait_result deepCopy() {
      return new executeAndWait_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
    }

    public QueryHandle getSuccess() {
      return this.success;
    }

    public executeAndWait_result setSuccess(QueryHandle success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public BeeswaxException getError() {
      return this.error;
    }

    public executeAndWait_result setError(BeeswaxException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((QueryHandle)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((BeeswaxException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof executeAndWait_result)
        return this.equals((executeAndWait_result)that);
      return false;
    }

    public boolean equals(executeAndWait_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      return builder.toHashCode();
    }

    public int compareTo(executeAndWait_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      executeAndWait_result typedOther = (executeAndWait_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new QueryHandle();
              this.success.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new BeeswaxException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("executeAndWait_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class explain_args implements org.apache.thrift.TBase<explain_args, explain_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("explain_args");

    private static final org.apache.thrift.protocol.TField QUERY_FIELD_DESC = new org.apache.thrift.protocol.TField("query", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public Query query; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      QUERY((short)1, "query");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // QUERY
            return QUERY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.QUERY, new org.apache.thrift.meta_data.FieldMetaData("query", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Query.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(explain_args.class, metaDataMap);
    }

    public explain_args() {
    }

    public explain_args(
      Query query)
    {
      this();
      this.query = query;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public explain_args(explain_args other) {
      if (other.isSetQuery()) {
        this.query = new Query(other.query);
      }
    }

    public explain_args deepCopy() {
      return new explain_args(this);
    }

    @Override
    public void clear() {
      this.query = null;
    }

    public Query getQuery() {
      return this.query;
    }

    public explain_args setQuery(Query query) {
      this.query = query;
      return this;
    }

    public void unsetQuery() {
      this.query = null;
    }

    /** Returns true if field query is set (has been assigned a value) and false otherwise */
    public boolean isSetQuery() {
      return this.query != null;
    }

    public void setQueryIsSet(boolean value) {
      if (!value) {
        this.query = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case QUERY:
        if (value == null) {
          unsetQuery();
        } else {
          setQuery((Query)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case QUERY:
        return getQuery();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case QUERY:
        return isSetQuery();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof explain_args)
        return this.equals((explain_args)that);
      return false;
    }

    public boolean equals(explain_args that) {
      if (that == null)
        return false;

      boolean this_present_query = true && this.isSetQuery();
      boolean that_present_query = true && that.isSetQuery();
      if (this_present_query || that_present_query) {
        if (!(this_present_query && that_present_query))
          return false;
        if (!this.query.equals(that.query))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_query = true && (isSetQuery());
      builder.append(present_query);
      if (present_query)
        builder.append(query);

      return builder.toHashCode();
    }

    public int compareTo(explain_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      explain_args typedOther = (explain_args)other;

      lastComparison = Boolean.valueOf(isSetQuery()).compareTo(typedOther.isSetQuery());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetQuery()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.query, typedOther.query);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // QUERY
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.query = new Query();
              this.query.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.query != null) {
        oprot.writeFieldBegin(QUERY_FIELD_DESC);
        this.query.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("explain_args(");
      boolean first = true;

      sb.append("query:");
      if (this.query == null) {
        sb.append("null");
      } else {
        sb.append(this.query);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class explain_result implements org.apache.thrift.TBase<explain_result, explain_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("explain_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public QueryExplanation success; // required
    public BeeswaxException error; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryExplanation.class)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(explain_result.class, metaDataMap);
    }

    public explain_result() {
    }

    public explain_result(
      QueryExplanation success,
      BeeswaxException error)
    {
      this();
      this.success = success;
      this.error = error;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public explain_result(explain_result other) {
      if (other.isSetSuccess()) {
        this.success = new QueryExplanation(other.success);
      }
      if (other.isSetError()) {
        this.error = new BeeswaxException(other.error);
      }
    }

    public explain_result deepCopy() {
      return new explain_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
    }

    public QueryExplanation getSuccess() {
      return this.success;
    }

    public explain_result setSuccess(QueryExplanation success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public BeeswaxException getError() {
      return this.error;
    }

    public explain_result setError(BeeswaxException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((QueryExplanation)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((BeeswaxException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof explain_result)
        return this.equals((explain_result)that);
      return false;
    }

    public boolean equals(explain_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      return builder.toHashCode();
    }

    public int compareTo(explain_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      explain_result typedOther = (explain_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new QueryExplanation();
              this.success.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new BeeswaxException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("explain_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class fetch_args implements org.apache.thrift.TBase<fetch_args, fetch_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("fetch_args");

    private static final org.apache.thrift.protocol.TField QUERY_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("query_id", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField START_OVER_FIELD_DESC = new org.apache.thrift.protocol.TField("start_over", org.apache.thrift.protocol.TType.BOOL, (short)2);
    private static final org.apache.thrift.protocol.TField FETCH_SIZE_FIELD_DESC = new org.apache.thrift.protocol.TField("fetch_size", org.apache.thrift.protocol.TType.I32, (short)3);

    public QueryHandle query_id; // required
    public boolean start_over; // required
    public int fetch_size; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      QUERY_ID((short)1, "query_id"),
      START_OVER((short)2, "start_over"),
      FETCH_SIZE((short)3, "fetch_size");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // QUERY_ID
            return QUERY_ID;
          case 2: // START_OVER
            return START_OVER;
          case 3: // FETCH_SIZE
            return FETCH_SIZE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __START_OVER_ISSET_ID = 0;
    private static final int __FETCH_SIZE_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.QUERY_ID, new org.apache.thrift.meta_data.FieldMetaData("query_id", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryHandle.class)));
      tmpMap.put(_Fields.START_OVER, new org.apache.thrift.meta_data.FieldMetaData("start_over", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.FETCH_SIZE, new org.apache.thrift.meta_data.FieldMetaData("fetch_size", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(fetch_args.class, metaDataMap);
    }

    public fetch_args() {
      this.fetch_size = -1;

    }

    public fetch_args(
      QueryHandle query_id,
      boolean start_over,
      int fetch_size)
    {
      this();
      this.query_id = query_id;
      this.start_over = start_over;
      setStart_overIsSet(true);
      this.fetch_size = fetch_size;
      setFetch_sizeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public fetch_args(fetch_args other) {
      __isset_bit_vector.clear();
      __isset_bit_vector.or(other.__isset_bit_vector);
      if (other.isSetQuery_id()) {
        this.query_id = new QueryHandle(other.query_id);
      }
      this.start_over = other.start_over;
      this.fetch_size = other.fetch_size;
    }

    public fetch_args deepCopy() {
      return new fetch_args(this);
    }

    @Override
    public void clear() {
      this.query_id = null;
      setStart_overIsSet(false);
      this.start_over = false;
      this.fetch_size = -1;

    }

    public QueryHandle getQuery_id() {
      return this.query_id;
    }

    public fetch_args setQuery_id(QueryHandle query_id) {
      this.query_id = query_id;
      return this;
    }

    public void unsetQuery_id() {
      this.query_id = null;
    }

    /** Returns true if field query_id is set (has been assigned a value) and false otherwise */
    public boolean isSetQuery_id() {
      return this.query_id != null;
    }

    public void setQuery_idIsSet(boolean value) {
      if (!value) {
        this.query_id = null;
      }
    }

    public boolean isStart_over() {
      return this.start_over;
    }

    public fetch_args setStart_over(boolean start_over) {
      this.start_over = start_over;
      setStart_overIsSet(true);
      return this;
    }

    public void unsetStart_over() {
      __isset_bit_vector.clear(__START_OVER_ISSET_ID);
    }

    /** Returns true if field start_over is set (has been assigned a value) and false otherwise */
    public boolean isSetStart_over() {
      return __isset_bit_vector.get(__START_OVER_ISSET_ID);
    }

    public void setStart_overIsSet(boolean value) {
      __isset_bit_vector.set(__START_OVER_ISSET_ID, value);
    }

    public int getFetch_size() {
      return this.fetch_size;
    }

    public fetch_args setFetch_size(int fetch_size) {
      this.fetch_size = fetch_size;
      setFetch_sizeIsSet(true);
      return this;
    }

    public void unsetFetch_size() {
      __isset_bit_vector.clear(__FETCH_SIZE_ISSET_ID);
    }

    /** Returns true if field fetch_size is set (has been assigned a value) and false otherwise */
    public boolean isSetFetch_size() {
      return __isset_bit_vector.get(__FETCH_SIZE_ISSET_ID);
    }

    public void setFetch_sizeIsSet(boolean value) {
      __isset_bit_vector.set(__FETCH_SIZE_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case QUERY_ID:
        if (value == null) {
          unsetQuery_id();
        } else {
          setQuery_id((QueryHandle)value);
        }
        break;

      case START_OVER:
        if (value == null) {
          unsetStart_over();
        } else {
          setStart_over((Boolean)value);
        }
        break;

      case FETCH_SIZE:
        if (value == null) {
          unsetFetch_size();
        } else {
          setFetch_size((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case QUERY_ID:
        return getQuery_id();

      case START_OVER:
        return Boolean.valueOf(isStart_over());

      case FETCH_SIZE:
        return Integer.valueOf(getFetch_size());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case QUERY_ID:
        return isSetQuery_id();
      case START_OVER:
        return isSetStart_over();
      case FETCH_SIZE:
        return isSetFetch_size();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof fetch_args)
        return this.equals((fetch_args)that);
      return false;
    }

    public boolean equals(fetch_args that) {
      if (that == null)
        return false;

      boolean this_present_query_id = true && this.isSetQuery_id();
      boolean that_present_query_id = true && that.isSetQuery_id();
      if (this_present_query_id || that_present_query_id) {
        if (!(this_present_query_id && that_present_query_id))
          return false;
        if (!this.query_id.equals(that.query_id))
          return false;
      }

      boolean this_present_start_over = true;
      boolean that_present_start_over = true;
      if (this_present_start_over || that_present_start_over) {
        if (!(this_present_start_over && that_present_start_over))
          return false;
        if (this.start_over != that.start_over)
          return false;
      }

      boolean this_present_fetch_size = true;
      boolean that_present_fetch_size = true;
      if (this_present_fetch_size || that_present_fetch_size) {
        if (!(this_present_fetch_size && that_present_fetch_size))
          return false;
        if (this.fetch_size != that.fetch_size)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_query_id = true && (isSetQuery_id());
      builder.append(present_query_id);
      if (present_query_id)
        builder.append(query_id);

      boolean present_start_over = true;
      builder.append(present_start_over);
      if (present_start_over)
        builder.append(start_over);

      boolean present_fetch_size = true;
      builder.append(present_fetch_size);
      if (present_fetch_size)
        builder.append(fetch_size);

      return builder.toHashCode();
    }

    public int compareTo(fetch_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      fetch_args typedOther = (fetch_args)other;

      lastComparison = Boolean.valueOf(isSetQuery_id()).compareTo(typedOther.isSetQuery_id());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetQuery_id()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.query_id, typedOther.query_id);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetStart_over()).compareTo(typedOther.isSetStart_over());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStart_over()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.start_over, typedOther.start_over);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetFetch_size()).compareTo(typedOther.isSetFetch_size());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFetch_size()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.fetch_size, typedOther.fetch_size);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // QUERY_ID
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.query_id = new QueryHandle();
              this.query_id.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // START_OVER
            if (field.type == org.apache.thrift.protocol.TType.BOOL) {
              this.start_over = iprot.readBool();
              setStart_overIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3: // FETCH_SIZE
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.fetch_size = iprot.readI32();
              setFetch_sizeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.query_id != null) {
        oprot.writeFieldBegin(QUERY_ID_FIELD_DESC);
        this.query_id.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(START_OVER_FIELD_DESC);
      oprot.writeBool(this.start_over);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(FETCH_SIZE_FIELD_DESC);
      oprot.writeI32(this.fetch_size);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("fetch_args(");
      boolean first = true;

      sb.append("query_id:");
      if (this.query_id == null) {
        sb.append("null");
      } else {
        sb.append(this.query_id);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("start_over:");
      sb.append(this.start_over);
      first = false;
      if (!first) sb.append(", ");
      sb.append("fetch_size:");
      sb.append(this.fetch_size);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class fetch_result implements org.apache.thrift.TBase<fetch_result, fetch_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("fetch_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField ERROR2_FIELD_DESC = new org.apache.thrift.protocol.TField("error2", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    public Results success; // required
    public QueryNotFoundException error; // required
    public BeeswaxException error2; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error"),
      ERROR2((short)2, "error2");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          case 2: // ERROR2
            return ERROR2;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Results.class)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.ERROR2, new org.apache.thrift.meta_data.FieldMetaData("error2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(fetch_result.class, metaDataMap);
    }

    public fetch_result() {
    }

    public fetch_result(
      Results success,
      QueryNotFoundException error,
      BeeswaxException error2)
    {
      this();
      this.success = success;
      this.error = error;
      this.error2 = error2;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public fetch_result(fetch_result other) {
      if (other.isSetSuccess()) {
        this.success = new Results(other.success);
      }
      if (other.isSetError()) {
        this.error = new QueryNotFoundException(other.error);
      }
      if (other.isSetError2()) {
        this.error2 = new BeeswaxException(other.error2);
      }
    }

    public fetch_result deepCopy() {
      return new fetch_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
      this.error2 = null;
    }

    public Results getSuccess() {
      return this.success;
    }

    public fetch_result setSuccess(Results success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public QueryNotFoundException getError() {
      return this.error;
    }

    public fetch_result setError(QueryNotFoundException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public BeeswaxException getError2() {
      return this.error2;
    }

    public fetch_result setError2(BeeswaxException error2) {
      this.error2 = error2;
      return this;
    }

    public void unsetError2() {
      this.error2 = null;
    }

    /** Returns true if field error2 is set (has been assigned a value) and false otherwise */
    public boolean isSetError2() {
      return this.error2 != null;
    }

    public void setError2IsSet(boolean value) {
      if (!value) {
        this.error2 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Results)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((QueryNotFoundException)value);
        }
        break;

      case ERROR2:
        if (value == null) {
          unsetError2();
        } else {
          setError2((BeeswaxException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      case ERROR2:
        return getError2();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      case ERROR2:
        return isSetError2();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof fetch_result)
        return this.equals((fetch_result)that);
      return false;
    }

    public boolean equals(fetch_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      boolean this_present_error2 = true && this.isSetError2();
      boolean that_present_error2 = true && that.isSetError2();
      if (this_present_error2 || that_present_error2) {
        if (!(this_present_error2 && that_present_error2))
          return false;
        if (!this.error2.equals(that.error2))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      boolean present_error2 = true && (isSetError2());
      builder.append(present_error2);
      if (present_error2)
        builder.append(error2);

      return builder.toHashCode();
    }

    public int compareTo(fetch_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      fetch_result typedOther = (fetch_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError2()).compareTo(typedOther.isSetError2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error2, typedOther.error2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new Results();
              this.success.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new QueryNotFoundException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // ERROR2
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error2 = new BeeswaxException();
              this.error2.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError2()) {
        oprot.writeFieldBegin(ERROR2_FIELD_DESC);
        this.error2.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("fetch_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error2:");
      if (this.error2 == null) {
        sb.append("null");
      } else {
        sb.append(this.error2);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_state_args implements org.apache.thrift.TBase<get_state_args, get_state_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_state_args");

    private static final org.apache.thrift.protocol.TField HANDLE_FIELD_DESC = new org.apache.thrift.protocol.TField("handle", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public QueryHandle handle; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      HANDLE((short)1, "handle");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // HANDLE
            return HANDLE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.HANDLE, new org.apache.thrift.meta_data.FieldMetaData("handle", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryHandle.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_state_args.class, metaDataMap);
    }

    public get_state_args() {
    }

    public get_state_args(
      QueryHandle handle)
    {
      this();
      this.handle = handle;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_state_args(get_state_args other) {
      if (other.isSetHandle()) {
        this.handle = new QueryHandle(other.handle);
      }
    }

    public get_state_args deepCopy() {
      return new get_state_args(this);
    }

    @Override
    public void clear() {
      this.handle = null;
    }

    public QueryHandle getHandle() {
      return this.handle;
    }

    public get_state_args setHandle(QueryHandle handle) {
      this.handle = handle;
      return this;
    }

    public void unsetHandle() {
      this.handle = null;
    }

    /** Returns true if field handle is set (has been assigned a value) and false otherwise */
    public boolean isSetHandle() {
      return this.handle != null;
    }

    public void setHandleIsSet(boolean value) {
      if (!value) {
        this.handle = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case HANDLE:
        if (value == null) {
          unsetHandle();
        } else {
          setHandle((QueryHandle)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case HANDLE:
        return getHandle();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case HANDLE:
        return isSetHandle();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_state_args)
        return this.equals((get_state_args)that);
      return false;
    }

    public boolean equals(get_state_args that) {
      if (that == null)
        return false;

      boolean this_present_handle = true && this.isSetHandle();
      boolean that_present_handle = true && that.isSetHandle();
      if (this_present_handle || that_present_handle) {
        if (!(this_present_handle && that_present_handle))
          return false;
        if (!this.handle.equals(that.handle))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_handle = true && (isSetHandle());
      builder.append(present_handle);
      if (present_handle)
        builder.append(handle);

      return builder.toHashCode();
    }

    public int compareTo(get_state_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_state_args typedOther = (get_state_args)other;

      lastComparison = Boolean.valueOf(isSetHandle()).compareTo(typedOther.isSetHandle());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetHandle()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.handle, typedOther.handle);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // HANDLE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.handle = new QueryHandle();
              this.handle.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.handle != null) {
        oprot.writeFieldBegin(HANDLE_FIELD_DESC);
        this.handle.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_state_args(");
      boolean first = true;

      sb.append("handle:");
      if (this.handle == null) {
        sb.append("null");
      } else {
        sb.append(this.handle);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_state_result implements org.apache.thrift.TBase<get_state_result, get_state_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_state_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    /**
     * 
     * @see QueryState
     */
    public QueryState success; // required
    public QueryNotFoundException error; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * 
       * @see QueryState
       */
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, QueryState.class)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_state_result.class, metaDataMap);
    }

    public get_state_result() {
    }

    public get_state_result(
      QueryState success,
      QueryNotFoundException error)
    {
      this();
      this.success = success;
      this.error = error;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_state_result(get_state_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetError()) {
        this.error = new QueryNotFoundException(other.error);
      }
    }

    public get_state_result deepCopy() {
      return new get_state_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
    }

    /**
     * 
     * @see QueryState
     */
    public QueryState getSuccess() {
      return this.success;
    }

    /**
     * 
     * @see QueryState
     */
    public get_state_result setSuccess(QueryState success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public QueryNotFoundException getError() {
      return this.error;
    }

    public get_state_result setError(QueryNotFoundException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((QueryState)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((QueryNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_state_result)
        return this.equals((get_state_result)that);
      return false;
    }

    public boolean equals(get_state_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success.getValue());

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      return builder.toHashCode();
    }

    public int compareTo(get_state_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_state_result typedOther = (get_state_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.I32) {
              this.success = QueryState.findByValue(iprot.readI32());
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new QueryNotFoundException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeI32(this.success.getValue());
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_state_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_results_metadata_args implements org.apache.thrift.TBase<get_results_metadata_args, get_results_metadata_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_results_metadata_args");

    private static final org.apache.thrift.protocol.TField HANDLE_FIELD_DESC = new org.apache.thrift.protocol.TField("handle", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public QueryHandle handle; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      HANDLE((short)1, "handle");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // HANDLE
            return HANDLE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.HANDLE, new org.apache.thrift.meta_data.FieldMetaData("handle", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryHandle.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_results_metadata_args.class, metaDataMap);
    }

    public get_results_metadata_args() {
    }

    public get_results_metadata_args(
      QueryHandle handle)
    {
      this();
      this.handle = handle;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_results_metadata_args(get_results_metadata_args other) {
      if (other.isSetHandle()) {
        this.handle = new QueryHandle(other.handle);
      }
    }

    public get_results_metadata_args deepCopy() {
      return new get_results_metadata_args(this);
    }

    @Override
    public void clear() {
      this.handle = null;
    }

    public QueryHandle getHandle() {
      return this.handle;
    }

    public get_results_metadata_args setHandle(QueryHandle handle) {
      this.handle = handle;
      return this;
    }

    public void unsetHandle() {
      this.handle = null;
    }

    /** Returns true if field handle is set (has been assigned a value) and false otherwise */
    public boolean isSetHandle() {
      return this.handle != null;
    }

    public void setHandleIsSet(boolean value) {
      if (!value) {
        this.handle = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case HANDLE:
        if (value == null) {
          unsetHandle();
        } else {
          setHandle((QueryHandle)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case HANDLE:
        return getHandle();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case HANDLE:
        return isSetHandle();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_results_metadata_args)
        return this.equals((get_results_metadata_args)that);
      return false;
    }

    public boolean equals(get_results_metadata_args that) {
      if (that == null)
        return false;

      boolean this_present_handle = true && this.isSetHandle();
      boolean that_present_handle = true && that.isSetHandle();
      if (this_present_handle || that_present_handle) {
        if (!(this_present_handle && that_present_handle))
          return false;
        if (!this.handle.equals(that.handle))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_handle = true && (isSetHandle());
      builder.append(present_handle);
      if (present_handle)
        builder.append(handle);

      return builder.toHashCode();
    }

    public int compareTo(get_results_metadata_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_results_metadata_args typedOther = (get_results_metadata_args)other;

      lastComparison = Boolean.valueOf(isSetHandle()).compareTo(typedOther.isSetHandle());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetHandle()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.handle, typedOther.handle);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // HANDLE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.handle = new QueryHandle();
              this.handle.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.handle != null) {
        oprot.writeFieldBegin(HANDLE_FIELD_DESC);
        this.handle.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_results_metadata_args(");
      boolean first = true;

      sb.append("handle:");
      if (this.handle == null) {
        sb.append("null");
      } else {
        sb.append(this.handle);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_results_metadata_result implements org.apache.thrift.TBase<get_results_metadata_result, get_results_metadata_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_results_metadata_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public ResultsMetadata success; // required
    public QueryNotFoundException error; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ResultsMetadata.class)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_results_metadata_result.class, metaDataMap);
    }

    public get_results_metadata_result() {
    }

    public get_results_metadata_result(
      ResultsMetadata success,
      QueryNotFoundException error)
    {
      this();
      this.success = success;
      this.error = error;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_results_metadata_result(get_results_metadata_result other) {
      if (other.isSetSuccess()) {
        this.success = new ResultsMetadata(other.success);
      }
      if (other.isSetError()) {
        this.error = new QueryNotFoundException(other.error);
      }
    }

    public get_results_metadata_result deepCopy() {
      return new get_results_metadata_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
    }

    public ResultsMetadata getSuccess() {
      return this.success;
    }

    public get_results_metadata_result setSuccess(ResultsMetadata success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public QueryNotFoundException getError() {
      return this.error;
    }

    public get_results_metadata_result setError(QueryNotFoundException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ResultsMetadata)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((QueryNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_results_metadata_result)
        return this.equals((get_results_metadata_result)that);
      return false;
    }

    public boolean equals(get_results_metadata_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      return builder.toHashCode();
    }

    public int compareTo(get_results_metadata_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_results_metadata_result typedOther = (get_results_metadata_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.success = new ResultsMetadata();
              this.success.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new QueryNotFoundException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        this.success.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_results_metadata_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class echo_args implements org.apache.thrift.TBase<echo_args, echo_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("echo_args");

    private static final org.apache.thrift.protocol.TField S_FIELD_DESC = new org.apache.thrift.protocol.TField("s", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String s; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      S((short)1, "s");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // S
            return S;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.S, new org.apache.thrift.meta_data.FieldMetaData("s", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(echo_args.class, metaDataMap);
    }

    public echo_args() {
    }

    public echo_args(
      String s)
    {
      this();
      this.s = s;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public echo_args(echo_args other) {
      if (other.isSetS()) {
        this.s = other.s;
      }
    }

    public echo_args deepCopy() {
      return new echo_args(this);
    }

    @Override
    public void clear() {
      this.s = null;
    }

    public String getS() {
      return this.s;
    }

    public echo_args setS(String s) {
      this.s = s;
      return this;
    }

    public void unsetS() {
      this.s = null;
    }

    /** Returns true if field s is set (has been assigned a value) and false otherwise */
    public boolean isSetS() {
      return this.s != null;
    }

    public void setSIsSet(boolean value) {
      if (!value) {
        this.s = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case S:
        if (value == null) {
          unsetS();
        } else {
          setS((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case S:
        return getS();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case S:
        return isSetS();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof echo_args)
        return this.equals((echo_args)that);
      return false;
    }

    public boolean equals(echo_args that) {
      if (that == null)
        return false;

      boolean this_present_s = true && this.isSetS();
      boolean that_present_s = true && that.isSetS();
      if (this_present_s || that_present_s) {
        if (!(this_present_s && that_present_s))
          return false;
        if (!this.s.equals(that.s))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_s = true && (isSetS());
      builder.append(present_s);
      if (present_s)
        builder.append(s);

      return builder.toHashCode();
    }

    public int compareTo(echo_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      echo_args typedOther = (echo_args)other;

      lastComparison = Boolean.valueOf(isSetS()).compareTo(typedOther.isSetS());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetS()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.s, typedOther.s);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // S
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.s = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.s != null) {
        oprot.writeFieldBegin(S_FIELD_DESC);
        oprot.writeString(this.s);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("echo_args(");
      boolean first = true;

      sb.append("s:");
      if (this.s == null) {
        sb.append("null");
      } else {
        sb.append(this.s);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class echo_result implements org.apache.thrift.TBase<echo_result, echo_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("echo_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(echo_result.class, metaDataMap);
    }

    public echo_result() {
    }

    public echo_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public echo_result(echo_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public echo_result deepCopy() {
      return new echo_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public echo_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof echo_result)
        return this.equals((echo_result)that);
      return false;
    }

    public boolean equals(echo_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(echo_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      echo_result typedOther = (echo_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("echo_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class dump_config_args implements org.apache.thrift.TBase<dump_config_args, dump_config_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("dump_config_args");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(dump_config_args.class, metaDataMap);
    }

    public dump_config_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public dump_config_args(dump_config_args other) {
    }

    public dump_config_args deepCopy() {
      return new dump_config_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof dump_config_args)
        return this.equals((dump_config_args)that);
      return false;
    }

    public boolean equals(dump_config_args that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(dump_config_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      dump_config_args typedOther = (dump_config_args)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("dump_config_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class dump_config_result implements org.apache.thrift.TBase<dump_config_result, dump_config_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("dump_config_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

    public String success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(dump_config_result.class, metaDataMap);
    }

    public dump_config_result() {
    }

    public dump_config_result(
      String success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public dump_config_result(dump_config_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
    }

    public dump_config_result deepCopy() {
      return new dump_config_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public dump_config_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof dump_config_result)
        return this.equals((dump_config_result)that);
      return false;
    }

    public boolean equals(dump_config_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(dump_config_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      dump_config_result typedOther = (dump_config_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("dump_config_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_log_args implements org.apache.thrift.TBase<get_log_args, get_log_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_log_args");

    private static final org.apache.thrift.protocol.TField CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("context", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String context; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CONTEXT((short)1, "context");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CONTEXT
            return CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("context", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "LogContextId")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_log_args.class, metaDataMap);
    }

    public get_log_args() {
    }

    public get_log_args(
      String context)
    {
      this();
      this.context = context;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_log_args(get_log_args other) {
      if (other.isSetContext()) {
        this.context = other.context;
      }
    }

    public get_log_args deepCopy() {
      return new get_log_args(this);
    }

    @Override
    public void clear() {
      this.context = null;
    }

    public String getContext() {
      return this.context;
    }

    public get_log_args setContext(String context) {
      this.context = context;
      return this;
    }

    public void unsetContext() {
      this.context = null;
    }

    /** Returns true if field context is set (has been assigned a value) and false otherwise */
    public boolean isSetContext() {
      return this.context != null;
    }

    public void setContextIsSet(boolean value) {
      if (!value) {
        this.context = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CONTEXT:
        if (value == null) {
          unsetContext();
        } else {
          setContext((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CONTEXT:
        return getContext();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CONTEXT:
        return isSetContext();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_log_args)
        return this.equals((get_log_args)that);
      return false;
    }

    public boolean equals(get_log_args that) {
      if (that == null)
        return false;

      boolean this_present_context = true && this.isSetContext();
      boolean that_present_context = true && that.isSetContext();
      if (this_present_context || that_present_context) {
        if (!(this_present_context && that_present_context))
          return false;
        if (!this.context.equals(that.context))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_context = true && (isSetContext());
      builder.append(present_context);
      if (present_context)
        builder.append(context);

      return builder.toHashCode();
    }

    public int compareTo(get_log_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_log_args typedOther = (get_log_args)other;

      lastComparison = Boolean.valueOf(isSetContext()).compareTo(typedOther.isSetContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.context, typedOther.context);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // CONTEXT
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.context = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.context != null) {
        oprot.writeFieldBegin(CONTEXT_FIELD_DESC);
        oprot.writeString(this.context);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_log_args(");
      boolean first = true;

      sb.append("context:");
      if (this.context == null) {
        sb.append("null");
      } else {
        sb.append(this.context);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_log_result implements org.apache.thrift.TBase<get_log_result, get_log_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_log_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public String success; // required
    public QueryNotFoundException error; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      ERROR((short)1, "error");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // ERROR
            return ERROR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_log_result.class, metaDataMap);
    }

    public get_log_result() {
    }

    public get_log_result(
      String success,
      QueryNotFoundException error)
    {
      this();
      this.success = success;
      this.error = error;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_log_result(get_log_result other) {
      if (other.isSetSuccess()) {
        this.success = other.success;
      }
      if (other.isSetError()) {
        this.error = new QueryNotFoundException(other.error);
      }
    }

    public get_log_result deepCopy() {
      return new get_log_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.error = null;
    }

    public String getSuccess() {
      return this.success;
    }

    public get_log_result setSuccess(String success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public QueryNotFoundException getError() {
      return this.error;
    }

    public get_log_result setError(QueryNotFoundException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((String)value);
        }
        break;

      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((QueryNotFoundException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case ERROR:
        return getError();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case ERROR:
        return isSetError();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_log_result)
        return this.equals((get_log_result)that);
      return false;
    }

    public boolean equals(get_log_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      return builder.toHashCode();
    }

    public int compareTo(get_log_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_log_result typedOther = (get_log_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.success = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new QueryNotFoundException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        oprot.writeString(this.success);
        oprot.writeFieldEnd();
      } else if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_log_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_default_configuration_args implements org.apache.thrift.TBase<get_default_configuration_args, get_default_configuration_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_default_configuration_args");

    private static final org.apache.thrift.protocol.TField INCLUDE_HADOOP_FIELD_DESC = new org.apache.thrift.protocol.TField("include_hadoop", org.apache.thrift.protocol.TType.BOOL, (short)1);

    public boolean include_hadoop; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      INCLUDE_HADOOP((short)1, "include_hadoop");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // INCLUDE_HADOOP
            return INCLUDE_HADOOP;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __INCLUDE_HADOOP_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.INCLUDE_HADOOP, new org.apache.thrift.meta_data.FieldMetaData("include_hadoop", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_default_configuration_args.class, metaDataMap);
    }

    public get_default_configuration_args() {
    }

    public get_default_configuration_args(
      boolean include_hadoop)
    {
      this();
      this.include_hadoop = include_hadoop;
      setInclude_hadoopIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_default_configuration_args(get_default_configuration_args other) {
      __isset_bit_vector.clear();
      __isset_bit_vector.or(other.__isset_bit_vector);
      this.include_hadoop = other.include_hadoop;
    }

    public get_default_configuration_args deepCopy() {
      return new get_default_configuration_args(this);
    }

    @Override
    public void clear() {
      setInclude_hadoopIsSet(false);
      this.include_hadoop = false;
    }

    public boolean isInclude_hadoop() {
      return this.include_hadoop;
    }

    public get_default_configuration_args setInclude_hadoop(boolean include_hadoop) {
      this.include_hadoop = include_hadoop;
      setInclude_hadoopIsSet(true);
      return this;
    }

    public void unsetInclude_hadoop() {
      __isset_bit_vector.clear(__INCLUDE_HADOOP_ISSET_ID);
    }

    /** Returns true if field include_hadoop is set (has been assigned a value) and false otherwise */
    public boolean isSetInclude_hadoop() {
      return __isset_bit_vector.get(__INCLUDE_HADOOP_ISSET_ID);
    }

    public void setInclude_hadoopIsSet(boolean value) {
      __isset_bit_vector.set(__INCLUDE_HADOOP_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case INCLUDE_HADOOP:
        if (value == null) {
          unsetInclude_hadoop();
        } else {
          setInclude_hadoop((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case INCLUDE_HADOOP:
        return Boolean.valueOf(isInclude_hadoop());

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case INCLUDE_HADOOP:
        return isSetInclude_hadoop();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_default_configuration_args)
        return this.equals((get_default_configuration_args)that);
      return false;
    }

    public boolean equals(get_default_configuration_args that) {
      if (that == null)
        return false;

      boolean this_present_include_hadoop = true;
      boolean that_present_include_hadoop = true;
      if (this_present_include_hadoop || that_present_include_hadoop) {
        if (!(this_present_include_hadoop && that_present_include_hadoop))
          return false;
        if (this.include_hadoop != that.include_hadoop)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_include_hadoop = true;
      builder.append(present_include_hadoop);
      if (present_include_hadoop)
        builder.append(include_hadoop);

      return builder.toHashCode();
    }

    public int compareTo(get_default_configuration_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_default_configuration_args typedOther = (get_default_configuration_args)other;

      lastComparison = Boolean.valueOf(isSetInclude_hadoop()).compareTo(typedOther.isSetInclude_hadoop());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetInclude_hadoop()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.include_hadoop, typedOther.include_hadoop);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // INCLUDE_HADOOP
            if (field.type == org.apache.thrift.protocol.TType.BOOL) {
              this.include_hadoop = iprot.readBool();
              setInclude_hadoopIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldBegin(INCLUDE_HADOOP_FIELD_DESC);
      oprot.writeBool(this.include_hadoop);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_default_configuration_args(");
      boolean first = true;

      sb.append("include_hadoop:");
      sb.append(this.include_hadoop);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bit_vector = new BitSet(1);
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class get_default_configuration_result implements org.apache.thrift.TBase<get_default_configuration_result, get_default_configuration_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_default_configuration_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);

    public List<ConfigVariable> success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ConfigVariable.class))));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_default_configuration_result.class, metaDataMap);
    }

    public get_default_configuration_result() {
    }

    public get_default_configuration_result(
      List<ConfigVariable> success)
    {
      this();
      this.success = success;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_default_configuration_result(get_default_configuration_result other) {
      if (other.isSetSuccess()) {
        List<ConfigVariable> __this__success = new ArrayList<ConfigVariable>();
        for (ConfigVariable other_element : other.success) {
          __this__success.add(new ConfigVariable(other_element));
        }
        this.success = __this__success;
      }
    }

    public get_default_configuration_result deepCopy() {
      return new get_default_configuration_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public java.util.Iterator<ConfigVariable> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(ConfigVariable elem) {
      if (this.success == null) {
        this.success = new ArrayList<ConfigVariable>();
      }
      this.success.add(elem);
    }

    public List<ConfigVariable> getSuccess() {
      return this.success;
    }

    public get_default_configuration_result setSuccess(List<ConfigVariable> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((List<ConfigVariable>)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_default_configuration_result)
        return this.equals((get_default_configuration_result)that);
      return false;
    }

    public boolean equals(get_default_configuration_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_success = true && (isSetSuccess());
      builder.append(present_success);
      if (present_success)
        builder.append(success);

      return builder.toHashCode();
    }

    public int compareTo(get_default_configuration_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      get_default_configuration_result typedOther = (get_default_configuration_result)other;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(typedOther.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, typedOther.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 0: // SUCCESS
            if (field.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list12 = iprot.readListBegin();
                this.success = new ArrayList<ConfigVariable>(_list12.size);
                for (int _i13 = 0; _i13 < _list12.size; ++_i13)
                {
                  ConfigVariable _elem14; // required
                  _elem14 = new ConfigVariable();
                  _elem14.read(iprot);
                  this.success.add(_elem14);
                }
                iprot.readListEnd();
              }
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetSuccess()) {
        oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
        {
          oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, this.success.size()));
          for (ConfigVariable _iter15 : this.success)
          {
            _iter15.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("get_default_configuration_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class close_args implements org.apache.thrift.TBase<close_args, close_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("close_args");

    private static final org.apache.thrift.protocol.TField HANDLE_FIELD_DESC = new org.apache.thrift.protocol.TField("handle", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    public QueryHandle handle; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      HANDLE((short)1, "handle");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // HANDLE
            return HANDLE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.HANDLE, new org.apache.thrift.meta_data.FieldMetaData("handle", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, QueryHandle.class)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(close_args.class, metaDataMap);
    }

    public close_args() {
    }

    public close_args(
      QueryHandle handle)
    {
      this();
      this.handle = handle;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public close_args(close_args other) {
      if (other.isSetHandle()) {
        this.handle = new QueryHandle(other.handle);
      }
    }

    public close_args deepCopy() {
      return new close_args(this);
    }

    @Override
    public void clear() {
      this.handle = null;
    }

    public QueryHandle getHandle() {
      return this.handle;
    }

    public close_args setHandle(QueryHandle handle) {
      this.handle = handle;
      return this;
    }

    public void unsetHandle() {
      this.handle = null;
    }

    /** Returns true if field handle is set (has been assigned a value) and false otherwise */
    public boolean isSetHandle() {
      return this.handle != null;
    }

    public void setHandleIsSet(boolean value) {
      if (!value) {
        this.handle = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case HANDLE:
        if (value == null) {
          unsetHandle();
        } else {
          setHandle((QueryHandle)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case HANDLE:
        return getHandle();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case HANDLE:
        return isSetHandle();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof close_args)
        return this.equals((close_args)that);
      return false;
    }

    public boolean equals(close_args that) {
      if (that == null)
        return false;

      boolean this_present_handle = true && this.isSetHandle();
      boolean that_present_handle = true && that.isSetHandle();
      if (this_present_handle || that_present_handle) {
        if (!(this_present_handle && that_present_handle))
          return false;
        if (!this.handle.equals(that.handle))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_handle = true && (isSetHandle());
      builder.append(present_handle);
      if (present_handle)
        builder.append(handle);

      return builder.toHashCode();
    }

    public int compareTo(close_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      close_args typedOther = (close_args)other;

      lastComparison = Boolean.valueOf(isSetHandle()).compareTo(typedOther.isSetHandle());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetHandle()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.handle, typedOther.handle);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // HANDLE
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.handle = new QueryHandle();
              this.handle.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.handle != null) {
        oprot.writeFieldBegin(HANDLE_FIELD_DESC);
        this.handle.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("close_args(");
      boolean first = true;

      sb.append("handle:");
      if (this.handle == null) {
        sb.append("null");
      } else {
        sb.append(this.handle);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class close_result implements org.apache.thrift.TBase<close_result, close_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("close_result");

    private static final org.apache.thrift.protocol.TField ERROR_FIELD_DESC = new org.apache.thrift.protocol.TField("error", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField ERROR2_FIELD_DESC = new org.apache.thrift.protocol.TField("error2", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    public QueryNotFoundException error; // required
    public BeeswaxException error2; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      ERROR((short)1, "error"),
      ERROR2((short)2, "error2");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // ERROR
            return ERROR;
          case 2: // ERROR2
            return ERROR2;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.ERROR, new org.apache.thrift.meta_data.FieldMetaData("error", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      tmpMap.put(_Fields.ERROR2, new org.apache.thrift.meta_data.FieldMetaData("error2", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(close_result.class, metaDataMap);
    }

    public close_result() {
    }

    public close_result(
      QueryNotFoundException error,
      BeeswaxException error2)
    {
      this();
      this.error = error;
      this.error2 = error2;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public close_result(close_result other) {
      if (other.isSetError()) {
        this.error = new QueryNotFoundException(other.error);
      }
      if (other.isSetError2()) {
        this.error2 = new BeeswaxException(other.error2);
      }
    }

    public close_result deepCopy() {
      return new close_result(this);
    }

    @Override
    public void clear() {
      this.error = null;
      this.error2 = null;
    }

    public QueryNotFoundException getError() {
      return this.error;
    }

    public close_result setError(QueryNotFoundException error) {
      this.error = error;
      return this;
    }

    public void unsetError() {
      this.error = null;
    }

    /** Returns true if field error is set (has been assigned a value) and false otherwise */
    public boolean isSetError() {
      return this.error != null;
    }

    public void setErrorIsSet(boolean value) {
      if (!value) {
        this.error = null;
      }
    }

    public BeeswaxException getError2() {
      return this.error2;
    }

    public close_result setError2(BeeswaxException error2) {
      this.error2 = error2;
      return this;
    }

    public void unsetError2() {
      this.error2 = null;
    }

    /** Returns true if field error2 is set (has been assigned a value) and false otherwise */
    public boolean isSetError2() {
      return this.error2 != null;
    }

    public void setError2IsSet(boolean value) {
      if (!value) {
        this.error2 = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case ERROR:
        if (value == null) {
          unsetError();
        } else {
          setError((QueryNotFoundException)value);
        }
        break;

      case ERROR2:
        if (value == null) {
          unsetError2();
        } else {
          setError2((BeeswaxException)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case ERROR:
        return getError();

      case ERROR2:
        return getError2();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case ERROR:
        return isSetError();
      case ERROR2:
        return isSetError2();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof close_result)
        return this.equals((close_result)that);
      return false;
    }

    public boolean equals(close_result that) {
      if (that == null)
        return false;

      boolean this_present_error = true && this.isSetError();
      boolean that_present_error = true && that.isSetError();
      if (this_present_error || that_present_error) {
        if (!(this_present_error && that_present_error))
          return false;
        if (!this.error.equals(that.error))
          return false;
      }

      boolean this_present_error2 = true && this.isSetError2();
      boolean that_present_error2 = true && that.isSetError2();
      if (this_present_error2 || that_present_error2) {
        if (!(this_present_error2 && that_present_error2))
          return false;
        if (!this.error2.equals(that.error2))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_error = true && (isSetError());
      builder.append(present_error);
      if (present_error)
        builder.append(error);

      boolean present_error2 = true && (isSetError2());
      builder.append(present_error2);
      if (present_error2)
        builder.append(error2);

      return builder.toHashCode();
    }

    public int compareTo(close_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      close_result typedOther = (close_result)other;

      lastComparison = Boolean.valueOf(isSetError()).compareTo(typedOther.isSetError());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error, typedOther.error);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetError2()).compareTo(typedOther.isSetError2());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetError2()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.error2, typedOther.error2);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // ERROR
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error = new QueryNotFoundException();
              this.error.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2: // ERROR2
            if (field.type == org.apache.thrift.protocol.TType.STRUCT) {
              this.error2 = new BeeswaxException();
              this.error2.read(iprot);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      if (this.isSetError()) {
        oprot.writeFieldBegin(ERROR_FIELD_DESC);
        this.error.write(oprot);
        oprot.writeFieldEnd();
      } else if (this.isSetError2()) {
        oprot.writeFieldBegin(ERROR2_FIELD_DESC);
        this.error2.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("close_result(");
      boolean first = true;

      sb.append("error:");
      if (this.error == null) {
        sb.append("null");
      } else {
        sb.append(this.error);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("error2:");
      if (this.error2 == null) {
        sb.append("null");
      } else {
        sb.append(this.error2);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class clean_args implements org.apache.thrift.TBase<clean_args, clean_args._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("clean_args");

    private static final org.apache.thrift.protocol.TField LOG_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("log_context", org.apache.thrift.protocol.TType.STRING, (short)1);

    public String log_context; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      LOG_CONTEXT((short)1, "log_context");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // LOG_CONTEXT
            return LOG_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments

    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.LOG_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("log_context", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "LogContextId")));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(clean_args.class, metaDataMap);
    }

    public clean_args() {
    }

    public clean_args(
      String log_context)
    {
      this();
      this.log_context = log_context;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public clean_args(clean_args other) {
      if (other.isSetLog_context()) {
        this.log_context = other.log_context;
      }
    }

    public clean_args deepCopy() {
      return new clean_args(this);
    }

    @Override
    public void clear() {
      this.log_context = null;
    }

    public String getLog_context() {
      return this.log_context;
    }

    public clean_args setLog_context(String log_context) {
      this.log_context = log_context;
      return this;
    }

    public void unsetLog_context() {
      this.log_context = null;
    }

    /** Returns true if field log_context is set (has been assigned a value) and false otherwise */
    public boolean isSetLog_context() {
      return this.log_context != null;
    }

    public void setLog_contextIsSet(boolean value) {
      if (!value) {
        this.log_context = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case LOG_CONTEXT:
        if (value == null) {
          unsetLog_context();
        } else {
          setLog_context((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case LOG_CONTEXT:
        return getLog_context();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case LOG_CONTEXT:
        return isSetLog_context();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof clean_args)
        return this.equals((clean_args)that);
      return false;
    }

    public boolean equals(clean_args that) {
      if (that == null)
        return false;

      boolean this_present_log_context = true && this.isSetLog_context();
      boolean that_present_log_context = true && that.isSetLog_context();
      if (this_present_log_context || that_present_log_context) {
        if (!(this_present_log_context && that_present_log_context))
          return false;
        if (!this.log_context.equals(that.log_context))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      boolean present_log_context = true && (isSetLog_context());
      builder.append(present_log_context);
      if (present_log_context)
        builder.append(log_context);

      return builder.toHashCode();
    }

    public int compareTo(clean_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      clean_args typedOther = (clean_args)other;

      lastComparison = Boolean.valueOf(isSetLog_context()).compareTo(typedOther.isSetLog_context());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLog_context()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.log_context, typedOther.log_context);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          case 1: // LOG_CONTEXT
            if (field.type == org.apache.thrift.protocol.TType.STRING) {
              this.log_context = iprot.readString();
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (this.log_context != null) {
        oprot.writeFieldBegin(LOG_CONTEXT_FIELD_DESC);
        oprot.writeString(this.log_context);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("clean_args(");
      boolean first = true;

      sb.append("log_context:");
      if (this.log_context == null) {
        sb.append("null");
      } else {
        sb.append(this.log_context);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

  public static class clean_result implements org.apache.thrift.TBase<clean_result, clean_result._Fields>, java.io.Serializable, Cloneable   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("clean_result");



    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(clean_result.class, metaDataMap);
    }

    public clean_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public clean_result(clean_result other) {
    }

    public clean_result deepCopy() {
      return new clean_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof clean_result)
        return this.equals((clean_result)that);
      return false;
    }

    public boolean equals(clean_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      HashCodeBuilder builder = new HashCodeBuilder();

      return builder.toHashCode();
    }

    public int compareTo(clean_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;
      clean_result typedOther = (clean_result)other;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (field.id) {
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, field.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      oprot.writeStructBegin(STRUCT_DESC);

      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("clean_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

  }

}
