/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;

public class TestJMXGet
extends TestCase {
    private Configuration config;
    private MiniDFSCluster cluster;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(0xAAAAEEFL);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    protected void setUp() throws Exception {
        this.config = new HdfsConfiguration();
    }

    public void tearDown() throws Exception {
        File data_dir;
        if (this.cluster.isClusterUp()) {
            this.cluster.shutdown();
        }
        if ((data_dir = new File(this.cluster.getDataDirectory())).exists() && !FileUtil.fullyDelete((File)data_dir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + data_dir + "'");
        }
    }

    public void testNameNode() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).build();
        this.cluster.waitActive();
        this.writeFile(this.cluster.getFileSystem(), new Path("/test1"), 2);
        JMXGet jmx = new JMXGet();
        jmx.init();
        TestJMXGet.assertEquals((int)numDatanodes, (int)Integer.parseInt(jmx.getValue("NumLiveDataNodes")));
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)Long.parseLong(jmx.getValue("CorruptBlocks")), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"FSNamesystem"));
        TestJMXGet.assertEquals((int)numDatanodes, (int)Integer.parseInt(jmx.getValue("NumOpenConnections")));
        this.cluster.shutdown();
    }

    public void testDataNode() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).build();
        this.cluster.waitActive();
        this.writeFile(this.cluster.getFileSystem(), new Path("/test"), 2);
        JMXGet jmx = new JMXGet();
        jmx.setService("DataNode");
        jmx.init();
        TestJMXGet.assertEquals((int)8192, (int)Integer.parseInt(jmx.getValue("BytesWritten")));
        this.cluster.shutdown();
    }
}

