/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class TestPermission
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestPermission.class);
    private static final Path ROOT_PATH = new Path("/data");
    private static final Path CHILD_DIR1 = new Path(ROOT_PATH, "child1");
    private static final Path CHILD_DIR2 = new Path(ROOT_PATH, "child2");
    private static final Path CHILD_FILE1 = new Path(ROOT_PATH, "file1");
    private static final Path CHILD_FILE2 = new Path(ROOT_PATH, "file2");
    private static final int FILE_LEN = 100;
    private static final Random RAN = new Random();
    private static final String USER_NAME = "user" + RAN.nextInt();
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};

    static FsPermission checkPermission(FileSystem fs, String path, FsPermission expected) throws IOException {
        FileStatus s = fs.getFileStatus(new Path(path));
        LOG.info((Object)(s.getPath() + ": " + s.isDirectory() + " " + s.getPermission() + ":" + s.getOwner() + ":" + s.getGroup()));
        if (expected != null) {
            TestPermission.assertEquals((Object)expected, (Object)s.getPermission());
            TestPermission.assertEquals((short)expected.toShort(), (short)s.getPermission().toShort());
        }
        return s.getPermission();
    }

    public void testBackwardCompatibility() {
        FsPermission perm = new FsPermission(18);
        Configuration conf = new Configuration();
        FsPermission.setUMask((Configuration)conf, (FsPermission)perm);
        TestPermission.assertEquals((int)18, (int)FsPermission.getUMask((Configuration)conf).toShort());
        perm = new FsPermission(18);
        conf = new Configuration();
        conf.set("dfs.umask", "18");
        TestPermission.assertEquals((int)18, (int)FsPermission.getUMask((Configuration)conf).toShort());
        conf = new Configuration();
        conf.set("dfs.umask", "18");
        conf.set("fs.permissions.umask-mode", "000");
        TestPermission.assertEquals((int)18, (int)FsPermission.getUMask((Configuration)conf).toShort());
        conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "022");
        TestPermission.assertEquals((int)18, (int)FsPermission.getUMask((Configuration)conf).toShort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.set("fs.permissions.umask-mode", "000");
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fs = FileSystem.get((Configuration)conf);
            FsPermission rootPerm = TestPermission.checkPermission(fs, "/", null);
            FsPermission inheritPerm = FsPermission.createImmutable((short)((short)(rootPerm.toShort() | 0xC0)));
            FsPermission dirPerm = new FsPermission(511);
            fs.mkdirs(new Path("/a1/a2/a3"), dirPerm);
            TestPermission.checkPermission(fs, "/a1", dirPerm);
            TestPermission.checkPermission(fs, "/a1/a2", dirPerm);
            TestPermission.checkPermission(fs, "/a1/a2/a3", dirPerm);
            dirPerm = new FsPermission(83);
            FsPermission permission = FsPermission.createImmutable((short)((short)(dirPerm.toShort() | 0xC0)));
            fs.mkdirs(new Path("/aa/1/aa/2/aa/3"), dirPerm);
            TestPermission.checkPermission(fs, "/aa/1", permission);
            TestPermission.checkPermission(fs, "/aa/1/aa/2", permission);
            TestPermission.checkPermission(fs, "/aa/1/aa/2/aa/3", dirPerm);
            FsPermission filePerm = new FsPermission(292);
            FSDataOutputStream out = fs.create(new Path("/b1/b2/b3.txt"), filePerm, true, conf.getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), fs.getDefaultBlockSize(), null);
            out.write(123);
            out.close();
            TestPermission.checkPermission(fs, "/b1", inheritPerm);
            TestPermission.checkPermission(fs, "/b1/b2", inheritPerm);
            TestPermission.checkPermission(fs, "/b1/b2/b3.txt", filePerm);
            conf.set("fs.permissions.umask-mode", "022");
            permission = FsPermission.createImmutable((short)438);
            FileSystem.mkdirs((FileSystem)fs, (Path)new Path("/c1"), (FsPermission)new FsPermission(permission));
            FileSystem.create((FileSystem)fs, (Path)new Path("/c1/c2.txt"), (FsPermission)new FsPermission(permission));
            TestPermission.checkPermission(fs, "/c1", permission);
            TestPermission.checkPermission(fs, "/c1/c2.txt", permission);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
            try {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFilePermision() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        try {
            FileSystem nnfs = FileSystem.get((Configuration)conf);
            TestPermission.assertFalse((boolean)nnfs.exists(CHILD_FILE1));
            try {
                nnfs.setOwner(CHILD_FILE1, "foo", "bar");
                TestPermission.assertTrue((boolean)false);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)("GOOD: got " + e));
            }
            try {
                nnfs.setPermission(CHILD_FILE1, new FsPermission(511));
                TestPermission.assertTrue((boolean)false);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)("GOOD: got " + e));
            }
            nnfs.mkdirs(CHILD_DIR1);
            FSDataOutputStream out = nnfs.create(CHILD_FILE1);
            byte[] data = new byte[100];
            RAN.nextBytes(data);
            out.write(data);
            out.close();
            nnfs.setPermission(CHILD_FILE1, new FsPermission("700"));
            byte[] dataIn = new byte[100];
            FSDataInputStream fin = nnfs.open(CHILD_FILE1);
            int bytesRead = fin.read(dataIn);
            TestPermission.assertTrue((bytesRead == 100 ? 1 : 0) != 0);
            for (int i = 0; i < 100; ++i) {
                TestPermission.assertEquals((byte)data[i], (byte)dataIn[i]);
            }
            UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
            FileSystem userfs = DFSTestUtil.getFileSystemAs(userGroupInfo, (Configuration)conf);
            userfs.mkdirs(CHILD_DIR1);
            TestPermission.assertTrue((!TestPermission.canMkdirs(userfs, CHILD_DIR2) ? 1 : 0) != 0);
            TestPermission.assertTrue((!TestPermission.canCreate(userfs, CHILD_FILE2) ? 1 : 0) != 0);
            TestPermission.assertTrue((!TestPermission.canOpen(userfs, CHILD_FILE1) ? 1 : 0) != 0);
            nnfs.setPermission(ROOT_PATH, new FsPermission(493));
            nnfs.setPermission(CHILD_DIR1, new FsPermission("777"));
            nnfs.setPermission(new Path("/"), new FsPermission(511));
            Path RENAME_PATH = new Path("/foo/bar");
            userfs.mkdirs(RENAME_PATH);
            TestPermission.assertTrue((boolean)TestPermission.canRename(userfs, RENAME_PATH, CHILD_DIR1));
        }
        finally {
            cluster.shutdown();
        }
    }

    static boolean canMkdirs(FileSystem fs, Path p) throws IOException {
        try {
            fs.mkdirs(p);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    static boolean canCreate(FileSystem fs, Path p) throws IOException {
        try {
            fs.create(p);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    static boolean canOpen(FileSystem fs, Path p) throws IOException {
        try {
            fs.open(p);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    static boolean canRename(FileSystem fs, Path src, Path dst) throws IOException {
        try {
            fs.rename(src, dst);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

