/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

public class TestNetworkTopology
extends TestCase {
    private static final NetworkTopology cluster = new NetworkTopology();
    private static final DatanodeDescriptor[] dataNodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("h1:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h2:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h3:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h4:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h5:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h6:5020"), "/d2/r3"), new DatanodeDescriptor(new DatanodeID("h7:5020"), "/d2/r3")};
    private static final DatanodeDescriptor NODE = new DatanodeDescriptor(new DatanodeID("h8:5020"), "/d2/r4");

    public void testContains() throws Exception {
        for (int i = 0; i < dataNodes.length; ++i) {
            TestNetworkTopology.assertTrue((boolean)cluster.contains((Node)dataNodes[i]));
        }
        TestNetworkTopology.assertFalse((boolean)cluster.contains((Node)NODE));
    }

    public void testNumOfChildren() throws Exception {
        TestNetworkTopology.assertEquals((int)cluster.getNumOfLeaves(), (int)dataNodes.length);
    }

    public void testRacks() throws Exception {
        TestNetworkTopology.assertEquals((int)cluster.getNumOfRacks(), (int)3);
        TestNetworkTopology.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)dataNodes[1]));
        TestNetworkTopology.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[1], (Node)dataNodes[2]));
        TestNetworkTopology.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)dataNodes[3]));
        TestNetworkTopology.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[3], (Node)dataNodes[4]));
        TestNetworkTopology.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[4], (Node)dataNodes[5]));
        TestNetworkTopology.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[5], (Node)dataNodes[6]));
    }

    public void testGetDistance() throws Exception {
        TestNetworkTopology.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[0]), (int)0);
        TestNetworkTopology.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[1]), (int)2);
        TestNetworkTopology.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[3]), (int)4);
        TestNetworkTopology.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[6]), (int)6);
    }

    public void testPseudoSortByDistance() throws Exception {
        DatanodeDescriptor[] testNodes = new DatanodeDescriptor[]{dataNodes[1], dataNodes[2], dataNodes[0]};
        cluster.pseudoSortByDistance((Node)dataNodes[0], (Node[])testNodes);
        TestNetworkTopology.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        TestNetworkTopology.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        TestNetworkTopology.assertTrue((testNodes[2] == dataNodes[2] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[1];
        testNodes[1] = dataNodes[3];
        testNodes[2] = dataNodes[0];
        cluster.pseudoSortByDistance((Node)dataNodes[0], (Node[])testNodes);
        TestNetworkTopology.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        TestNetworkTopology.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        TestNetworkTopology.assertTrue((testNodes[2] == dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[5];
        testNodes[1] = dataNodes[3];
        testNodes[2] = dataNodes[1];
        cluster.pseudoSortByDistance((Node)dataNodes[0], (Node[])testNodes);
        TestNetworkTopology.assertTrue((testNodes[0] == dataNodes[1] ? 1 : 0) != 0);
        TestNetworkTopology.assertTrue((testNodes[1] == dataNodes[3] ? 1 : 0) != 0);
        TestNetworkTopology.assertTrue((testNodes[2] == dataNodes[5] ? 1 : 0) != 0);
    }

    public void testRemove() throws Exception {
        int i;
        for (i = 0; i < dataNodes.length; ++i) {
            cluster.remove((Node)dataNodes[i]);
        }
        for (i = 0; i < dataNodes.length; ++i) {
            TestNetworkTopology.assertFalse((boolean)cluster.contains((Node)dataNodes[i]));
        }
        TestNetworkTopology.assertEquals((int)0, (int)cluster.getNumOfLeaves());
        for (i = 0; i < dataNodes.length; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (DatanodeDescriptor dnd : dataNodes) {
            frequency.put((Node)dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope);
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        return frequency;
    }

    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath((Node)dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope);
        for (DatanodeDescriptor key : dataNodes) {
            TestNetworkTopology.assertTrue((frequency.get(key) > 0 || key == dataNodes[0] ? 1 : 0) != 0);
        }
    }

    public void testChooseRandomExcludedRack() {
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, "~/d2");
        for (int j = 0; j < dataNodes.length; ++j) {
            int freq = frequency.get(dataNodes[j]);
            if (dataNodes[j].getNetworkLocation().startsWith("/d2")) {
                TestNetworkTopology.assertEquals((int)0, (int)freq);
                continue;
            }
            TestNetworkTopology.assertTrue((freq > 0 ? 1 : 0) != 0);
        }
    }

    static {
        for (int i = 0; i < dataNodes.length; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
    }
}

