/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;

public class WebHdfsTestUtil {
    public static final Log LOG = LogFactory.getLog(WebHdfsTestUtil.class);

    public static WebHdfsFileSystem getWebHdfsFileSystem(Configuration conf) throws IOException, URISyntaxException {
        String uri = "webhdfs://" + conf.get("dfs.namenode.http-address");
        return (WebHdfsFileSystem)FileSystem.get((URI)new URI(uri), (Configuration)conf);
    }

    public static WebHdfsFileSystem getWebHdfsFileSystemAs(UserGroupInformation ugi, final Configuration conf) throws IOException, URISyntaxException, InterruptedException {
        return (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws Exception {
                return WebHdfsTestUtil.getWebHdfsFileSystem(conf);
            }
        });
    }

    public static URL toUrl(WebHdfsFileSystem webhdfs, HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        URL url = webhdfs.toUrl(op, fspath, parameters);
        LOG.info((Object)("url=" + url));
        return url;
    }

    public static Map<?, ?> connectAndGetJson(HttpURLConnection conn, int expectedResponseCode) throws IOException {
        conn.connect();
        Assert.assertEquals((long)expectedResponseCode, (long)conn.getResponseCode());
        return WebHdfsFileSystem.jsonParse((InputStream)conn.getInputStream());
    }

    public static HttpURLConnection twoStepWrite(HttpURLConnection conn, HttpOpParam.Op op) throws IOException {
        conn.setRequestMethod(op.getType().toString());
        conn = WebHdfsFileSystem.twoStepWrite((HttpURLConnection)conn, (HttpOpParam.Op)op);
        conn.setDoOutput(true);
        conn.connect();
        return conn;
    }

    public static FSDataOutputStream write(WebHdfsFileSystem webhdfs, HttpOpParam.Op op, HttpURLConnection conn, int bufferSize) throws IOException {
        return webhdfs.write(op, conn, bufferSize);
    }
}

