/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;

public class TestWebHdfsFileSystemContract
extends FileSystemContractBaseTest {
    private static final Configuration conf = new Configuration();
    private static final MiniDFSCluster cluster;
    private String defaultWorkingDirectory;
    private UserGroupInformation ugi;

    protected void setUp() throws Exception {
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        this.ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        this.fs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.ugi, conf);
        this.defaultWorkingDirectory = this.fs.getWorkingDirectory().toUri().getPath();
    }

    protected String getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.path("/test/hadoop");
        TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.exists(testDir));
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.mkdirs(testDir));
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.exists(testDir));
        this.createFile(this.path("/test/hadoop/file"));
        Path testSubDir = this.path("/test/hadoop/file/subdir");
        try {
            this.fs.mkdirs(testSubDir);
            TestWebHdfsFileSystemContract.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.exists(testSubDir));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        Path testDeepSubDir = this.path("/test/hadoop/file/deep/sub/dir");
        try {
            this.fs.mkdirs(testDeepSubDir);
            TestWebHdfsFileSystemContract.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.exists(testDeepSubDir));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
    }

    public void testGetFileBlockLocations() throws IOException {
        String f = "/test/testGetFileBlockLocations";
        this.createFile(this.path("/test/testGetFileBlockLocations"));
        BlockLocation[] computed = this.fs.getFileBlockLocations(new Path("/test/testGetFileBlockLocations"), 0L, 1L);
        BlockLocation[] expected = cluster.getFileSystem().getFileBlockLocations(new Path("/test/testGetFileBlockLocations"), 0L, 1L);
        TestWebHdfsFileSystemContract.assertEquals((int)expected.length, (int)computed.length);
        for (int i = 0; i < computed.length; ++i) {
            TestWebHdfsFileSystemContract.assertEquals((String)expected[i].toString(), (String)computed[i].toString());
        }
    }

    public void testCaseInsensitive() throws IOException {
        String line;
        Path p = new Path("/test/testCaseInsensitive");
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, p, new Param[0]);
        WebHdfsFileSystem.LOG.info((Object)("url      = " + url));
        URL replaced = new URL(url.toString().replace(op.toQueryString(), "Op=mkDIrs"));
        WebHdfsFileSystem.LOG.info((Object)("replaced = " + replaced));
        HttpURLConnection conn = (HttpURLConnection)replaced.openConnection();
        conn.setRequestMethod(op.getType().toString());
        conn.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = in.readLine()) != null) {
            WebHdfsFileSystem.LOG.info((Object)("> " + line));
        }
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.getFileStatus(p).isDirectory());
    }

    public void testOpenNonExistFile() throws IOException {
        Path p = new Path("/test/testOpenNonExistFile");
        try {
            FSDataInputStream in = this.fs.open(p);
            in.read();
            TestWebHdfsFileSystemContract.fail();
        }
        catch (FileNotFoundException fnfe) {
            WebHdfsFileSystem.LOG.info((Object)"This is expected.", (Throwable)fnfe);
        }
    }

    public void testSeek() throws IOException {
        int i;
        Path p = new Path("/test/testSeek");
        this.createFile(p);
        int one_third = this.data.length / 3;
        int two_third = one_third * 2;
        int offset = one_third;
        int len = this.data.length - offset;
        byte[] buf = new byte[len];
        FSDataInputStream in = this.fs.open(p);
        in.seek((long)offset);
        in.readFully(buf);
        in.close();
        for (i = 0; i < buf.length; ++i) {
            TestWebHdfsFileSystemContract.assertEquals((String)("Position " + i + ", offset=" + offset + ", length=" + len), (byte)this.data[i + offset], (byte)buf[i]);
        }
        offset = two_third;
        len = this.data.length - offset;
        buf = new byte[len];
        in = this.fs.open(p);
        in.readFully((long)offset, buf);
        in.close();
        for (i = 0; i < buf.length; ++i) {
            TestWebHdfsFileSystemContract.assertEquals((String)("Position " + i + ", offset=" + offset + ", length=" + len), (byte)this.data[i + offset], (byte)buf[i]);
        }
    }

    public void testRootDir() throws IOException {
        Path root = new Path("/");
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.NULL, root, new Param[0]);
        WebHdfsFileSystem.LOG.info((Object)("null url=" + url));
        Assert.assertTrue((boolean)url.toString().contains("v1"));
        FileStatus status = this.fs.getFileStatus(root);
        TestWebHdfsFileSystemContract.assertTrue((status != null ? 1 : 0) != 0);
        TestWebHdfsFileSystemContract.assertEquals((int)511, (int)status.getPermission().toShort());
        try {
            FSDataOutputStream out = this.fs.create(root);
            out.write(1);
            out.close();
            TestWebHdfsFileSystemContract.fail();
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info((Object)"This is expected.", (Throwable)e);
        }
        try {
            FSDataInputStream in = this.fs.open(root);
            in.read();
            TestWebHdfsFileSystemContract.fail();
            TestWebHdfsFileSystemContract.fail();
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info((Object)"This is expected.", (Throwable)e);
        }
    }

    public void testResponseCode() throws IOException {
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        Path root = new Path("/");
        Path dir = new Path("/test/testUrl");
        TestWebHdfsFileSystemContract.assertTrue((boolean)webhdfs.mkdirs(dir));
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[0]);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Map<?, ?> m = WebHdfsTestUtil.connectAndGetJson(conn, 200);
        TestWebHdfsFileSystemContract.assertEquals((Object)WebHdfsFileSystem.getHomeDirectoryString((UserGroupInformation)this.ugi), m.get(Path.class.getSimpleName()));
        conn.disconnect();
        url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(this.ugi.getShortUserName() + "proxy")});
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)401, (int)conn.getResponseCode());
        conn.disconnect();
        url = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.SETOWNER, dir, new Param[0]);
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)400, (int)conn.getResponseCode());
        conn.disconnect();
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        URL url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)200, (int)conn2.getResponseCode());
        TestWebHdfsFileSystemContract.assertFalse((boolean)webhdfs.setReplication(dir, (short)1));
        conn2.disconnect();
        Path p = new Path(dir, "non-exist");
        url2 = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, p, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)404, (int)conn2.getResponseCode());
        conn2.disconnect();
        op = PutOpParam.Op.SETPERMISSION;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)200, (int)conn2.getResponseCode());
        TestWebHdfsFileSystemContract.assertEquals((short)493, (short)webhdfs.getFileStatus(dir).getPermission().toShort());
        conn2.disconnect();
    }

    static {
        conf.setBoolean("dfs.webhdfs.enabled", true);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            cluster.getFileSystem().setPermission(new Path("/"), new FsPermission(511));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

