/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthFilter {
    @Test
    public void testGetConfiguration() throws ServletException {
        AuthFilter filter = new AuthFilter();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("dfs.web.authentication.kerberos.principal", "xyz/thehost@REALM");
        m.put("dfs.web.authentication.kerberos.keytab", "thekeytab");
        DummyFilterConfig config = new DummyFilterConfig(m);
        Properties p = filter.getConfiguration("random", (FilterConfig)config);
        Assert.assertEquals((Object)"xyz/thehost@REALM", (Object)p.getProperty("kerberos.principal"));
        Assert.assertEquals((Object)"thekeytab", (Object)p.getProperty("kerberos.keytab"));
        Assert.assertEquals((Object)"true", (Object)p.getProperty("simple.anonymous.allowed"));
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String arg0) {
            return this.map.get(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            return null;
        }
    }
}

