/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDFSHAAdmin {
    private static final Log LOG = LogFactory.getLog(TestDFSHAAdmin.class);
    private DFSHAAdmin tool;
    private ByteArrayOutputStream errOutBytes = new ByteArrayOutputStream();
    private String errOutput;
    private HAServiceProtocol mockProtocol;
    private static final String NSID = "ns1";
    private static String HOST_A = "1.2.3.1";
    private static String HOST_B = "1.2.3.2";

    private HdfsConfiguration getHAConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservices", NSID);
        conf.set("dfs.federation.nameservice.id", NSID);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NSID}), "nn1,nn2");
        conf.set("dfs.ha.namenode.id", "nn1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn1"}), HOST_A + ":12345");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn2"}), HOST_B + ":12345");
        return conf;
    }

    @Before
    public void setup() throws IOException {
        this.mockProtocol = (HAServiceProtocol)Mockito.mock(HAServiceProtocol.class);
        Mockito.when((Object)this.mockProtocol.readyToBecomeActive()).thenReturn((Object)true);
        this.tool = new DFSHAAdmin(){

            protected HAServiceProtocol getProtocol(String serviceId) throws IOException {
                this.getServiceAddr(serviceId);
                return TestDFSHAAdmin.this.mockProtocol;
            }
        };
        this.tool.setConf((Configuration)this.getHAConf());
        this.tool.setErrOut(new PrintStream(this.errOutBytes));
    }

    private void assertOutputContains(String string) {
        if (!this.errOutput.contains(string)) {
            Assert.fail((String)("Expected output to contain '" + string + "' but was:\n" + this.errOutput));
        }
    }

    @Test
    public void testNameserviceOption() throws Exception {
        Assert.assertEquals((Object)-1, (Object)this.runTool("-ns"));
        this.assertOutputContains("Missing nameservice ID");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-ns", NSID));
        this.assertOutputContains("Missing command");
        Assert.assertEquals((Object)0, (Object)this.runTool("-ns", NSID, "-help", "transitionToActive"));
        this.assertOutputContains("Transitions the service into Active");
    }

    @Test
    public void testNamenodeResolution() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-getServiceState", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).getServiceState();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-getServiceState", "undefined"));
        this.assertOutputContains("Unable to determine service address for namenode 'undefined'");
    }

    @Test
    public void testHelp() throws Exception {
        Assert.assertEquals((Object)-1, (Object)this.runTool("-help"));
        Assert.assertEquals((Object)0, (Object)this.runTool("-help", "transitionToActive"));
        this.assertOutputContains("Transitions the service into Active");
    }

    @Test
    public void testTransitionToActive() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToActive", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).transitionToActive();
    }

    @Test
    public void testTransitionToStandby() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToStandby", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).transitionToStandby();
    }

    @Test
    public void testFailoverWithNoFencerConfigured() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2"));
    }

    @Test
    public void testFailoverWithFencerConfigured() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "shell(true)");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2"));
    }

    @Test
    public void testFailoverWithFencerAndNameservice() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "shell(true)");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-ns", NSID, "-failover", "nn1", "nn2"));
    }

    @Test
    public void testFailoverWithFencerConfiguredAndForce() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "shell(true)");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    @Test
    public void testFailoverWithForceActive() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "shell(true)");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2", "--forceactive"));
    }

    @Test
    public void testFailoverWithInvalidFenceArg() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "shell(true)");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "notforcefence"));
    }

    @Test
    public void testFailoverWithFenceButNoFencer() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    @Test
    public void testFailoverWithFenceAndBadFencer() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "foobar!");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    @Test
    public void testForceFenceOptionListedBeforeArgs() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)HAServiceProtocol.HAServiceState.STANDBY).when((Object)this.mockProtocol)).getServiceState();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "shell(true)");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "--forcefence", "nn1", "nn2"));
    }

    @Test
    public void testGetServiceState() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-getServiceState", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).getServiceState();
    }

    @Test
    public void testCheckHealth() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-checkHealth", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).monitorHealth();
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new HealthCheckFailedException("fake health check failure")).when((Object)this.mockProtocol)).monitorHealth();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-checkHealth", "nn1"));
        this.assertOutputContains("Health check failed: fake health check failure");
    }

    private Object runTool(String ... args) throws Exception {
        this.errOutBytes.reset();
        LOG.info((Object)("Running: DFSHAAdmin " + Joiner.on((String)" ").join((Object[])args)));
        int ret = this.tool.run(args);
        this.errOutput = new String(this.errOutBytes.toByteArray(), Charsets.UTF_8);
        LOG.info((Object)("Output:\n" + this.errOutput));
        return ret;
    }
}

