/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;

public class TestNameNodeMetrics
extends TestCase {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int DFS_REPLICATION_INTERVAL = 1;
    private static final Path TEST_ROOT_DIR_PATH = new Path("/testNameNodeMetrics");
    private static final String NN_METRICS = "NameNodeActivity";
    private static final String NS_METRICS = "FSNamesystem";
    private static final int DATANODE_COUNT = 3;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private Random rand = new Random();
    private FSNamesystem namesystem;
    private BlockManager bm;

    private static Path getTestPath(String fileName) {
        return new Path(TEST_ROOT_DIR_PATH, fileName);
    }

    protected void setUp() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(3).build();
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNamesystem();
        this.bm = this.namesystem.getBlockManager();
        this.fs = (DistributedFileSystem)this.cluster.getFileSystem();
    }

    protected void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void createFile(Path file, long fileLen, short replicas) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, file, fileLen, replicas, this.rand.nextLong());
    }

    private void updateMetrics() throws Exception {
        Thread.sleep(1000L);
    }

    private void readFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        stm.read(buffer, 0, 4);
        stm.close();
    }

    public void testFileAdd() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testFileAdd");
        this.createFile(file, 3200L, (short)3);
        long blockCount = 32L;
        int blockCapacity = this.namesystem.getBlockCapacity();
        this.updateMetrics();
        MetricsAsserts.assertGauge((String)"BlockCapacity", (int)blockCapacity, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"CreateFileOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FilesCreated", (long)file.depth(), (MetricsRecordBuilder)rb);
        int threshold = (int)((float)blockCapacity * 0.75f);
        while ((long)threshold < 32L) {
            blockCapacity <<= 1;
        }
        this.updateMetrics();
        long filesTotal = file.depth() + 1;
        rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"FilesTotal", (long)filesTotal, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"BlocksTotal", (long)32L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"BlockCapacity", (int)blockCapacity, (MetricsRecordBuilder)rb);
        this.fs.delete(file, true);
        this.waitForDeletion();
        this.updateMetrics();
        rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"FilesTotal", (long)(--filesTotal), (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"BlocksTotal", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingDeletionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"DeleteFileOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FilesDeleted", (long)1L, (MetricsRecordBuilder)rb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorruptBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testCorruptBlock");
        this.createFile(file, 100L, (short)2);
        LocatedBlock block = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(), file.toString(), 0L, 1L).get(0);
        this.cluster.getNamesystem().writeLock();
        try {
            this.bm.findAndMarkBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        }
        finally {
            this.cluster.getNamesystem().writeUnlock();
        }
        this.updateMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ScheduledReplicationBlocks", (long)1L, (MetricsRecordBuilder)rb);
        this.fs.delete(file, true);
        this.waitForDeletion();
        rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ScheduledReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
    }

    public void testExcessBlocks() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testExcessBlocks");
        this.createFile(file, 100L, (short)2);
        long totalBlocks = 1L;
        NameNodeAdapter.setReplication(this.namesystem, file.toString(), (short)1);
        this.updateMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"ExcessBlocks", (long)totalBlocks, (MetricsRecordBuilder)rb);
        this.fs.delete(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testMissingBlocks");
        this.createFile(file, 100L, (short)1);
        LocatedBlock block = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(), file.toString(), 0L, 1L).get(0);
        this.cluster.getNamesystem().writeLock();
        try {
            this.bm.findAndMarkBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        }
        finally {
            this.cluster.getNamesystem().writeUnlock();
        }
        this.updateMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"UnderReplicatedBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"MissingBlocks", (long)1L, (MetricsRecordBuilder)rb);
        this.fs.delete(file, true);
        this.waitForDeletion();
        MetricsAsserts.assertGauge((String)"UnderReplicatedBlocks", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
    }

    private void waitForDeletion() throws InterruptedException {
        Thread.sleep(4000L);
    }

    public void testRenameMetrics() throws Exception {
        Path src = TestNameNodeMetrics.getTestPath("src");
        this.createFile(src, 100L, (short)1);
        Path target = TestNameNodeMetrics.getTestPath("target");
        this.createFile(target, 100L, (short)1);
        this.fs.rename(src, target, new Options.Rename[]{Options.Rename.OVERWRITE});
        this.updateMetrics();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"FilesRenamed", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FilesDeleted", (long)1L, (MetricsRecordBuilder)rb);
    }

    public void testGetBlockLocationMetric() throws Exception {
        Path file1_Path = new Path(TEST_ROOT_DIR_PATH, "file1.dat");
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.createFile(file1_Path, 100L, (short)2);
        this.updateMetrics();
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.readFile((FileSystem)this.fs, file1_Path);
        this.updateMetrics();
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.readFile((FileSystem)this.fs, file1_Path);
        this.readFile((FileSystem)this.fs, file1_Path);
        this.updateMetrics();
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)3L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
    }

    static {
        CONF.setLong("dfs.blocksize", 100L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.namenode.replication.interval", 1);
        ((Log4JLogger)LogFactory.getLog(MetricsAsserts.class)).getLogger().setLevel(Level.DEBUG);
    }
}

