/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestPipelinesFailover {
    protected static final Log LOG;
    private static final Path TEST_PATH;
    private static final int BLOCK_SIZE = 4096;
    private static final int BLOCK_AND_A_HALF = 6144;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testWriteOverFailover() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 4096);
        conf.setInt("dfs.namenode.replication.interval", 1000);
        FSDataOutputStream stm = null;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            Thread.sleep(500L);
            LOG.info((Object)"Starting with NN 0 active");
            FileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            stm = fs.create(TEST_PATH);
            AppendTestUtil.write((OutputStream)stm, 0, 6144);
            stm.hflush();
            LOG.info((Object)"Failing over to NN 1");
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)fs.exists(TEST_PATH));
            FSNamesystem ns1 = cluster.getNameNode(1).getNamesystem();
            BlockManagerTestUtil.updateState(ns1.getBlockManager());
            Assert.assertEquals((long)0L, (long)ns1.getPendingReplicationBlocks());
            Assert.assertEquals((long)0L, (long)ns1.getCorruptReplicaBlocks());
            Assert.assertEquals((long)0L, (long)ns1.getMissingBlocksCount());
            AppendTestUtil.write((OutputStream)stm, 6144, 6144);
            stm.close();
            stm = null;
            AppendTestUtil.check(fs, TEST_PATH, 12288L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(stm);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)stm);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testWriteOverFailoverWithDnFail() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 4096);
        FSDataOutputStream stm = null;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(5).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            Thread.sleep(500L);
            LOG.info((Object)"Starting with NN 0 active");
            FileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            stm = fs.create(TEST_PATH);
            AppendTestUtil.write((OutputStream)stm, 0, 6144);
            stm.hflush();
            LOG.info((Object)"Failing over to NN 1");
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)fs.exists(TEST_PATH));
            cluster.stopDataNode(0);
            AppendTestUtil.write((OutputStream)stm, 6144, 6144);
            stm.hflush();
            LOG.info((Object)"Failing back to NN 0");
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            cluster.stopDataNode(1);
            AppendTestUtil.write((OutputStream)stm, 12288, 6144);
            stm.hflush();
            stm.close();
            stm = null;
            AppendTestUtil.check(fs, TEST_PATH, 18432L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(stm);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)stm);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testLeaseRecoveryAfterFailover() throws Exception {
        final Configuration conf = new Configuration();
        conf.setBoolean("dfs.permissions.enabled", false);
        conf.setInt("dfs.blocksize", 4096);
        FSDataOutputStream stm = null;
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            Thread.sleep(500L);
            LOG.info((Object)"Starting with NN 0 active");
            FileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            stm = fs.create(TEST_PATH);
            AppendTestUtil.write((OutputStream)stm, 0, 6144);
            stm.hflush();
            LOG.info((Object)"Failing over to NN 1");
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)fs.exists(TEST_PATH));
            FileSystem fsOtherUser = (FileSystem)UserGroupInformation.createUserForTesting((String)"otheruser", (String[])new String[]{"othergroup"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return HATestUtil.configureFailoverFs(cluster, conf);
                }
            });
            ((DistributedFileSystem)fsOtherUser).recoverLease(TEST_PATH);
            AppendTestUtil.check(fs, TEST_PATH, 6144L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(stm);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)stm);
        cluster.shutdown();
    }

    static {
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(BlockManager.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.io.retry.RetryInvocationHandler")).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        LOG = LogFactory.getLog(TestPipelinesFailover.class);
        TEST_PATH = new Path("/test-file");
    }
}

