/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestHAWebUI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkToBrowseFilesystem() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            String pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + NameNode.getHttpAddress((Configuration)cluster.getConfiguration(0)).getPort() + "/dfshealth.jsp"));
            Assert.assertTrue((boolean)pageContents.contains("Browse the filesystem"));
            cluster.transitionToStandby(0);
            pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + NameNode.getHttpAddress((Configuration)cluster.getConfiguration(0)).getPort() + "/dfshealth.jsp"));
            Assert.assertFalse((boolean)pageContents.contains("Browse the filesystem"));
            cluster.transitionToActive(0);
            pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + NameNode.getHttpAddress((Configuration)cluster.getConfiguration(0)).getPort() + "/dfshealth.jsp"));
            Assert.assertTrue((boolean)pageContents.contains("Browse the filesystem"));
        }
        finally {
            cluster.shutdown();
        }
    }
}

