/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHASafeMode {
    private static final Log LOG = LogFactory.getLog(TestHASafeMode.class);
    private static final int BLOCK_SIZE = 1024;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Runtime mockRuntime = (Runtime)Mockito.mock(Runtime.class);

    @Before
    public void setupCluster() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).waitSafeMode(false).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, conf);
        this.nn0.getNamesystem().getEditLogTailer().setRuntime(this.mockRuntime);
        this.cluster.transitionToActive(0);
    }

    @After
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            ((Runtime)Mockito.verify((Object)this.mockRuntime, (VerificationMode)Mockito.times((int)0))).exit(Matchers.anyInt());
            this.cluster.shutdown();
        }
    }

    private void restartStandby() throws IOException {
        this.cluster.shutdownNameNode(1);
        this.cluster.getConfiguration(1).setInt("dfs.namenode.safemode.extension", 30000);
        this.cluster.getConfiguration(1).setInt("dfs.ha.tail-edits.period", 1);
        this.cluster.restartNameNode(1);
        this.nn1 = this.cluster.getNameNode(1);
    }

    @Test
    public void testEnterSafeModeInANNShouldNotThrowNPE() throws Exception {
        TestHASafeMode.banner("Restarting active");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.restartActive();
        this.nn0.getRpcServer().transitionToActive();
        FSNamesystem namesystem = this.nn0.getNamesystem();
        String status = namesystem.getSafemode();
        Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON."));
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        Assert.assertTrue((String)"Failed to enter into safemode in active", (boolean)namesystem.isInSafeMode());
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        Assert.assertTrue((String)"Failed to enter into safemode in active", (boolean)namesystem.isInSafeMode());
    }

    @Test
    public void testEnterSafeModeInSBNShouldNotThrowNPE() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Creating some blocks that won't be in the edit log");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Deleting the original blocks");
        this.fs.delete(new Path("/test"), true);
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        FSNamesystem namesystem = this.nn1.getNamesystem();
        String status = namesystem.getSafemode();
        Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON."));
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        Assert.assertTrue((String)"Failed to enter into safemode in standby", (boolean)namesystem.isInSafeMode());
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        Assert.assertTrue((String)"Failed to enter into safemode in standby", (boolean)namesystem.isInSafeMode());
    }

    private void restartActive() throws IOException {
        this.cluster.shutdownNameNode(0);
        this.cluster.getConfiguration(0).setInt("dfs.namenode.safemode.extension", 30000);
        this.cluster.restartNameNode(0);
        this.nn0 = this.cluster.getNameNode(0);
    }

    @Test
    public void testBlocksAddedBeforeStandbyRestart() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Creating some blocks that won't be in the edit log");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 3, 3);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 8, 8);
    }

    @Test
    public void testBlocksAddedWhileInSafeMode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 3, 3);
        TestHASafeMode.banner("Creating some blocks while SBN is in safe mode");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 8, 8);
    }

    @Test
    public void testBlocksRemovedBeforeStandbyRestart() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 5120L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        this.cluster.triggerHeartbeats();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 0, 5);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 0, 0);
    }

    @Test
    public void testBlocksRemovedWhileInSafeMode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 10240L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 10, 10);
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        TestHASafeMode.banner("Triggering deletions on DNs and Deletion Reports");
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        this.assertSafeMode(this.nn1, 0, 10);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWhileInSafeMode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 4608L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 5, 5);
        FSDataOutputStream stm = this.fs.append(new Path("/test"));
        try {
            this.assertSafeMode(this.nn1, 5, 5);
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            this.assertSafeMode(this.nn1, 4, 4);
        }
        finally {
            IOUtils.closeStream((Closeable)stm);
        }
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        TestHASafeMode.banner("Triggering deletions on DNs and Deletion Reports");
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        this.assertSafeMode(this.nn1, 0, 4);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 0, 0);
    }

    @Test
    public void testBlocksDeletedInEditLog() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 4096L, (short)3, 1L);
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0, false);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 2048L, (short)3, 1L);
        this.fs.delete(new Path("/test"), true);
        this.restartActive();
    }

    private void assertSafeMode(NameNode nn, int safe, int total) {
        String status = this.nn1.getNamesystem().getSafemode();
        if (safe == total) {
            Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON.The reported blocks " + safe + " has reached the threshold " + "0.9990 of total blocks " + total + ". Safe mode will be " + "turned off automatically"));
        } else {
            int additional = total - safe;
            Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON.The reported blocks " + safe + " needs additional " + additional + " blocks"));
        }
    }

    @Test
    public void testComplexFailoverIntoSafemode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Creating some blocks that won't be in the edit log");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Deleting the original blocks");
        this.fs.delete(new Path("/test"), true);
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 3, 3);
        TestHASafeMode.banner("Initiating a failover into NN1 in safemode");
        NameNodeAdapter.abortEditLogs(this.nn0);
        this.cluster.transitionToActive(1);
        this.assertSafeMode(this.nn1, 5, 5);
    }

    @Test
    public void testBlocksRemovedWhileInSafeModeEditsArriveFirst() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 10240L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        String status = this.nn1.getNamesystem().getSafemode();
        Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON.The reported blocks 10 has reached the threshold 0.9990 of total blocks 10. Safe mode will be turned off automatically"));
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 0, 0);
        TestHASafeMode.banner("Triggering sending deletions to DNs and Deletion Reports");
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        this.assertSafeMode(this.nn1, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSafeBlockTracking() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some UC blocks plus some other blocks to force safemode");
        DFSTestUtil.createFile(this.fs, new Path("/other-blocks"), 10240L, (short)3, 1L);
        ArrayList stms = Lists.newArrayList();
        try {
            for (int i = 0; i < 5; ++i) {
                FSDataOutputStream stm = this.fs.create(new Path("/test-uc-" + i));
                stms.add(stm);
                stm.write(1);
                stm.hflush();
            }
            this.nn0.getRpcServer().rollEditLog();
        }
        finally {
            for (FSDataOutputStream stm : stms) {
                IOUtils.closeStream((Closeable)stm);
            }
        }
        TestHASafeMode.banner("Restarting SBN");
        this.restartStandby();
        this.assertSafeMode(this.nn1, 10, 10);
        TestHASafeMode.banner("Allowing SBN to catch up");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.assertSafeMode(this.nn1, 15, 15);
    }

    @Test
    public void testBlocksAddedWhileStandbyIsDown() throws Exception {
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        TestHASafeMode.banner("Stopping standby");
        this.cluster.shutdownNameNode(1);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 3072L, (short)3, 1L);
        TestHASafeMode.banner("Rolling edit log so standby gets all edits on restart");
        this.nn0.getRpcServer().rollEditLog();
        this.restartStandby();
        this.assertSafeMode(this.nn1, 6, 6);
    }

    @Test
    public void testNoPopulatingReplQueuesWhenExitingSafemode() throws Exception {
        DFSTestUtil.createFile(this.fs, new Path("/test"), 15360L, (short)3, 1L);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.nn1.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        NameNodeAdapter.saveNamespace(this.nn1);
        this.nn1.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 15360L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        this.cluster.stopDataNode(1);
        this.cluster.shutdownNameNode(1);
        this.cluster.restartNameNode(1, false);
        this.nn1 = this.cluster.getNameNode(1);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                return !TestHASafeMode.this.nn1.isInSafeMode();
            }
        }, 100, 10000);
        BlockManagerTestUtil.updateState(this.nn1.getNamesystem().getBlockManager());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getUnderReplicatedBlocks());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getPendingReplicationBlocks());
    }

    static void banner(String string) {
        LOG.info((Object)("\n\n\n\n================================================\n" + string + "\n" + "==================================================\n\n"));
    }

    static {
        ((Log4JLogger)LogFactory.getLog(FSImage.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
    }
}

