/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestFailureToReadEdits {
    private static final Log LOG = LogFactory.getLog(TestFailureToReadEdits.class);
    private static final String TEST_DIR1 = "/test1";
    private static final String TEST_DIR2 = "/test2";
    private static final String TEST_DIR3 = "/test3";
    private Configuration conf;
    private Runtime mockRuntime = (Runtime)Mockito.mock(Runtime.class);
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;

    @Before
    public void setUpCluster() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("dfs.namenode.checkpoint.check.period", 1);
        this.conf.setInt("dfs.namenode.checkpoint.txns", 1);
        this.conf.setInt("dfs.namenode.num.checkpoints.retained", 10);
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setHttpPort(10001)).addNN(new MiniDFSNNTopology.NNConf("nn2").setHttpPort(10002)));
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(topology).numDataNodes(0).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.nn1.getNamesystem().getEditLogTailer().setRuntime(this.mockRuntime);
        this.cluster.transitionToActive(0);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    @After
    public void tearDownCluster() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFailuretoReadEdits() throws Exception {
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR1)));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.fs.setOwner(new Path(TEST_DIR1), "foo", "bar");
        Assert.assertTrue((boolean)this.fs.delete(new Path(TEST_DIR1), true));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR2)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR3)));
        LimitedEditLogAnswer answer = this.causeFailureOnEditLogRead();
        try {
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            Assert.fail((String)"Standby fully caught up, but should not have been able to");
        }
        catch (HATestUtil.CouldNotCatchUpException e) {
            ((Runtime)Mockito.verify((Object)this.mockRuntime, (VerificationMode)Mockito.times((int)0))).exit(Matchers.anyInt());
        }
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR1, false));
        Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR2, false).isDir());
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR3, false));
        answer.setThrowExceptionOnRead(false);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR1, false));
        Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR2, false).isDir());
        Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.nn1, TEST_DIR3, false).isDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointStartingMidEditsFile() throws Exception {
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR1)));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        HATestUtil.waitForCheckpoint(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0, (Object)3));
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3));
        this.causeFailureOnEditLogRead();
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR2)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR3)));
        try {
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            Assert.fail((String)"Standby fully caught up, but should not have been able to");
        }
        catch (HATestUtil.CouldNotCatchUpException e) {
            ((Runtime)Mockito.verify((Object)this.mockRuntime, (VerificationMode)Mockito.times((int)0))).exit(Matchers.anyInt());
        }
        HATestUtil.waitForCheckpoint(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0, (Object)3, (Object)5));
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3, (Object)5));
        this.cluster.restartNameNode(0);
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3, (Object)5));
        FileSystem fs0 = null;
        try {
            fs0 = FileSystem.get((URI)NameNode.getUri((InetSocketAddress)this.nn0.getNameNodeAddress()), (Configuration)this.conf);
            Assert.assertTrue((boolean)fs0.exists(new Path(TEST_DIR1)));
            Assert.assertTrue((boolean)fs0.exists(new Path(TEST_DIR2)));
            Assert.assertTrue((boolean)fs0.exists(new Path(TEST_DIR3)));
        }
        finally {
            if (fs0 != null) {
                fs0.close();
            }
        }
    }

    @Test
    public void testFailureToReadEditsOnTransitionToActive() throws Exception {
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR1)));
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        HATestUtil.waitForCheckpoint(this.cluster, 0, (List<Integer>)ImmutableList.of((Object)0, (Object)3));
        this.causeFailureOnEditLogRead();
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR2)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path(TEST_DIR3)));
        try {
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            Assert.fail((String)"Standby fully caught up, but should not have been able to");
        }
        catch (HATestUtil.CouldNotCatchUpException e) {
            ((Runtime)Mockito.verify((Object)this.mockRuntime, (VerificationMode)Mockito.times((int)0))).exit(Matchers.anyInt());
        }
        this.cluster.shutdownNameNode(0);
        try {
            this.cluster.transitionToActive(1);
            Assert.fail((String)"Standby transitioned to active, but should not have been able to");
        }
        catch (ServiceFailedException sfe) {
            LOG.info((Object)("got expected exception: " + sfe.toString()), (Throwable)sfe);
            Assert.assertTrue((String)"Standby failed to catch up for some reason other than failure to read logs", (boolean)sfe.toString().contains(EditLogInputException.class.getName()));
        }
    }

    private LimitedEditLogAnswer causeFailureOnEditLogRead() throws IOException {
        FSEditLog spyEditLog = (FSEditLog)Mockito.spy((Object)this.nn1.getNamesystem().getEditLogTailer().getEditLog());
        LimitedEditLogAnswer answer = new LimitedEditLogAnswer();
        ((FSEditLog)Mockito.doAnswer((Answer)answer).when((Object)spyEditLog)).selectInputStreams(Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean());
        this.nn1.getNamesystem().getEditLogTailer().setEditLog(spyEditLog);
        return answer;
    }

    private static class LimitedEditLogAnswer
    implements Answer<Collection<EditLogInputStream>> {
        private boolean throwExceptionOnRead = true;

        private LimitedEditLogAnswer() {
        }

        public Collection<EditLogInputStream> answer(InvocationOnMock invocation) throws Throwable {
            Collection streams = (Collection)invocation.callRealMethod();
            if (!this.throwExceptionOnRead) {
                return streams;
            }
            LinkedList<EditLogInputStream> ret = new LinkedList<EditLogInputStream>();
            for (EditLogInputStream stream : streams) {
                EditLogInputStream spyStream = (EditLogInputStream)Mockito.spy((Object)stream);
                ((EditLogInputStream)Mockito.doAnswer((Answer)new Answer<FSEditLogOp>(){

                    public FSEditLogOp answer(InvocationOnMock invocation) throws Throwable {
                        FSEditLogOp op = (FSEditLogOp)invocation.callRealMethod();
                        if (LimitedEditLogAnswer.this.throwExceptionOnRead && TestFailureToReadEdits.TEST_DIR3.equals(NameNodeAdapter.getMkdirOpPath(op))) {
                            throw new IOException("failed to read op creating /test3");
                        }
                        return op;
                    }
                }).when((Object)spyStream)).readOp();
                ret.add(spyStream);
            }
            return ret;
        }

        public void setThrowExceptionOnRead(boolean throwExceptionOnRead) {
            this.throwExceptionOnRead = throwExceptionOnRead;
        }
    }
}

