/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestDNFencingWithReplication {
    private static final int NUM_THREADS = 20;
    private static final long RUNTIME = 35000L;
    private static final int BLOCK_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFencingStress() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.blockreport.intervalMsec", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.namenode.replication.max-streams", 1000);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            FileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            MultithreadedTestUtil.TestContext togglers = new MultithreadedTestUtil.TestContext();
            for (int i = 0; i < 20; ++i) {
                Path p = new Path("/test-" + i);
                DFSTestUtil.createFile(fs, p, 10240L, (short)3, i);
                togglers.addThread((MultithreadedTestUtil.TestingThread)new ReplicationToggler(togglers, fs, p));
            }
            MultithreadedTestUtil.TestContext triggerCtx = new MultithreadedTestUtil.TestContext();
            triggerCtx.addThread((MultithreadedTestUtil.TestingThread)new MultithreadedTestUtil.RepeatingTestThread(triggerCtx){

                public void doAnAction() throws Exception {
                    for (DataNode dn : cluster.getDataNodes()) {
                        DataNodeAdapter.triggerDeletionReport(dn);
                        DataNodeAdapter.triggerHeartbeat(dn);
                    }
                    for (int i = 0; i < 2; ++i) {
                        NameNode nn = cluster.getNameNode(i);
                        BlockManagerTestUtil.computeAllPendingWork(nn.getNamesystem().getBlockManager());
                    }
                    Thread.sleep(500L);
                }
            });
            triggerCtx.addThread((MultithreadedTestUtil.TestingThread)new MultithreadedTestUtil.RepeatingTestThread(triggerCtx){

                public void doAnAction() throws Exception {
                    System.err.println("==============================\nFailing over from 0->1\n==================================");
                    cluster.transitionToStandby(0);
                    cluster.transitionToActive(1);
                    Thread.sleep(5000L);
                    System.err.println("==============================\nFailing over from 1->0\n==================================");
                    cluster.transitionToStandby(1);
                    cluster.transitionToActive(0);
                    Thread.sleep(5000L);
                }
            });
            triggerCtx.startThreads();
            togglers.startThreads();
            togglers.waitFor(35000L);
            togglers.stop();
            triggerCtx.stop();
            for (int i = 0; i < 20; ++i) {
                Path p = new Path("/test-" + i);
                DFSTestUtil.readFile(fs, p);
            }
        }
        finally {
            System.err.println("===========================\n\n\n\n");
            cluster.shutdown();
        }
    }

    static {
        ((Log4JLogger)FSNamesystem.auditLog).getLogger().setLevel(Level.WARN);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.FATAL);
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.io.retry.RetryInvocationHandler")).getLogger().setLevel(Level.FATAL);
    }

    private static class ReplicationToggler
    extends MultithreadedTestUtil.RepeatingTestThread {
        private final FileSystem fs;
        private final Path path;

        public ReplicationToggler(MultithreadedTestUtil.TestContext ctx, FileSystem fs, Path p) {
            super(ctx);
            this.fs = fs;
            this.path = p;
        }

        public void doAnAction() throws Exception {
            this.fs.setReplication(this.path, (short)1);
            this.waitForReplicas(1);
            this.fs.setReplication(this.path, (short)2);
            this.waitForReplicas(2);
        }

        private void waitForReplicas(final int replicas) throws Exception {
            try {
                GenericTestUtils.waitFor(new Supplier<Boolean>(){

                    public Boolean get() {
                        try {
                            BlockLocation[] blocks = ReplicationToggler.this.fs.getFileBlockLocations(ReplicationToggler.this.path, 0L, 10L);
                            Assert.assertEquals((long)1L, (long)blocks.length);
                            return blocks[0].getHosts().length == replicas;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, 100, 60000);
            }
            catch (TimeoutException te) {
                throw new IOException("Timed out waiting for " + replicas + " replicas " + "on path " + this.path);
            }
        }

        public String toString() {
            return "Toggler for " + this.path;
        }
    }
}

