/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTransferFsImage {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", "build/test/data"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSideException() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        List<File> localPath = Collections.singletonList(new File("/xxxxx-does-not-exist/blah"));
        try {
            String fsName = NameNode.getHostPortString((InetSocketAddress)cluster.getNameNode().getHttpAddress());
            String id = "getimage=1&txid=0";
            TransferFsImage.getFileClient((String)fsName, (String)id, localPath, (NNStorage)mockStorage, (boolean)false);
            Assert.fail((String)"Didn't get an exception!");
        }
        catch (IOException ioe) {
            ((NNStorage)Mockito.verify((Object)mockStorage)).reportErrorOnFile(localPath.get(0));
            Assert.assertTrue((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)ioe)), (boolean)ioe.getMessage().contains("Unable to download to any storage"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSideExceptionOnJustOneDir() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        ImmutableList localPaths = ImmutableList.of((Object)new File("/xxxxx-does-not-exist/blah"), (Object)new File(TEST_DIR, "testfile"));
        try {
            String fsName = NameNode.getHostPortString((InetSocketAddress)cluster.getNameNode().getHttpAddress());
            String id = "getimage=1&txid=0";
            TransferFsImage.getFileClient((String)fsName, (String)id, (List)localPaths, (NNStorage)mockStorage, (boolean)false);
            ((NNStorage)Mockito.verify((Object)mockStorage)).reportErrorOnFile((File)localPaths.get(0));
            Assert.assertTrue((String)"The valid local file should get saved properly", (((File)localPaths.get(1)).length() > 0L ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }
}

