/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Collections;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestStartupOptionUpgrade {
    private Configuration conf;
    private HdfsServerConstants.StartupOption startOpt;
    private int layoutVersion;
    NNStorage storage;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.startOpt = HdfsServerConstants.StartupOption.UPGRADE;
        this.startOpt.setClusterId(null);
        this.storage = new NNStorage(this.conf, Collections.emptyList(), Collections.emptyList());
    }

    @After
    public void tearDown() throws Exception {
        this.conf = null;
        this.startOpt = null;
    }

    @Test
    public void testStartupOptUpgradeFrom204() throws Exception {
        this.layoutVersion = LayoutVersion.Feature.RESERVED_REL20_204.getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assert.assertTrue((String)"Clusterid should start with CID", (boolean)this.storage.getClusterID().startsWith("CID"));
    }

    @Test
    public void testStartupOptUpgradeFrom22WithCID() throws Exception {
        this.startOpt.setClusterId("cid");
        this.layoutVersion = LayoutVersion.Feature.RESERVED_REL22.getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assert.assertEquals((String)"Clusterid should match with the given clusterid", (String)"cid", (String)this.storage.getClusterID());
    }

    @Test
    public void testStartupOptUpgradeFromFederation() throws Exception {
        this.storage.setClusterID("currentcid");
        this.layoutVersion = LayoutVersion.Feature.FEDERATION.getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assert.assertEquals((String)"Clusterid should match with the existing one", (String)"currentcid", (String)this.storage.getClusterID());
    }

    @Test
    public void testStartupOptUpgradeFromFederationWithWrongCID() throws Exception {
        this.startOpt.setClusterId("wrong-cid");
        this.storage.setClusterID("currentcid");
        this.layoutVersion = LayoutVersion.Feature.FEDERATION.getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assert.assertEquals((String)"Clusterid should match with the existing one", (String)"currentcid", (String)this.storage.getClusterID());
    }

    @Test
    public void testStartupOptUpgradeFromFederationWithCID() throws Exception {
        this.startOpt.setClusterId("currentcid");
        this.storage.setClusterID("currentcid");
        this.layoutVersion = LayoutVersion.Feature.FEDERATION.getLayoutVersion();
        this.storage.processStartupOptionsForUpgrade(this.startOpt, this.layoutVersion);
        Assert.assertEquals((String)"Clusterid should match with the existing one", (String)"currentcid", (String)this.storage.getClusterID());
    }
}

