/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Test;

public class TestNameNodeMXBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeMXBeanInfo() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            Assert.assertEquals((String)fsn.getClusterId(), (String)clusterId);
            String blockpoolId = (String)mbs.getAttribute(mxbeanName, "BlockPoolId");
            Assert.assertEquals((String)fsn.getBlockPoolId(), (String)blockpoolId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assert.assertEquals((String)fsn.getVersion(), (String)version);
            Long used = (Long)mbs.getAttribute(mxbeanName, "Used");
            Assert.assertEquals((long)fsn.getUsed(), (long)used);
            Long total = (Long)mbs.getAttribute(mxbeanName, "Total");
            Assert.assertEquals((long)fsn.getTotal(), (long)total);
            String safemode = (String)mbs.getAttribute(mxbeanName, "Safemode");
            Assert.assertEquals((String)fsn.getSafemode(), (String)safemode);
            Long nondfs = (Long)mbs.getAttribute(mxbeanName, "NonDfsUsedSpace");
            Assert.assertEquals((long)fsn.getNonDfsUsedSpace(), (long)nondfs);
            Float percentremaining = (Float)mbs.getAttribute(mxbeanName, "PercentRemaining");
            Assert.assertEquals((Object)Float.valueOf(fsn.getPercentRemaining()), (Object)Float.valueOf(percentremaining.floatValue()));
            Long totalblocks = (Long)mbs.getAttribute(mxbeanName, "TotalBlocks");
            Assert.assertEquals((long)fsn.getTotalBlocks(), (long)totalblocks);
            String alivenodeinfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Assert.assertEquals((String)fsn.getLiveNodes(), (String)alivenodeinfo);
            String deadnodeinfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assert.assertEquals((String)fsn.getDeadNodes(), (String)deadnodeinfo);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

