/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNStorageRetentionManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestNNStorageRetentionManager {
    Configuration conf = new Configuration();

    @Before
    public void setNoExtraEditRetention() {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 0L);
    }

    @Test
    public void testPurgeEasyCase() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        tc.addLog("/foo1/current/VERSION", false);
        this.runTest(tc);
    }

    @Test
    public void testPurgeMultipleDirs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo2/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testPurgeLessThanRetention() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testNoLogs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        this.runTest(tc);
    }

    @Test
    public void testEmptyDir() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        this.runTest(tc);
    }

    @Test
    public void testOldInProgress() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)101L), true);
        this.runTest(tc);
    }

    @Test
    public void testSeparateEditDirs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testRetainExtraLogs() throws IOException {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 50L);
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    private void runTest(TestCaseDescription tc) throws IOException {
        NNStorageRetentionManager.StoragePurger mockPurger = (NNStorageRetentionManager.StoragePurger)Mockito.mock(NNStorageRetentionManager.StoragePurger.class);
        ArgumentCaptor imagesPurgedCaptor = ArgumentCaptor.forClass(FSImageStorageInspector.FSImageFile.class);
        ArgumentCaptor logsPurgedCaptor = ArgumentCaptor.forClass(FileJournalManager.EditLogFile.class);
        new NNStorageRetentionManager(this.conf, tc.mockStorage(), tc.mockEditLog(mockPurger), mockPurger).purgeOldStorage();
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).purgeImage((FSImageStorageInspector.FSImageFile)imagesPurgedCaptor.capture());
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).purgeLog((FileJournalManager.EditLogFile)logsPurgedCaptor.capture());
        HashSet purgedPaths = Sets.newHashSet();
        for (FSImageStorageInspector.FSImageFile purged : imagesPurgedCaptor.getAllValues()) {
            purgedPaths.add(purged.getFile().toString());
        }
        Assert.assertEquals((Object)Joiner.on((String)",").join((Iterable)tc.expectedPurgedImages), (Object)Joiner.on((String)",").join((Iterable)purgedPaths));
        purgedPaths.clear();
        for (FSImageStorageInspector.FSImageFile purged : logsPurgedCaptor.getAllValues()) {
            purgedPaths.add(purged.getFile().toString());
        }
        Assert.assertEquals((Object)Joiner.on((String)",").join((Iterable)tc.expectedPurgedLogs), (Object)Joiner.on((String)",").join((Iterable)purgedPaths));
    }

    private static NNStorage mockStorageForDirs(final Storage.StorageDirectory ... mockDirs) throws IOException {
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        ((NNStorage)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                FSImageStorageInspector inspector = (FSImageStorageInspector)invocation.getArguments()[0];
                for (Storage.StorageDirectory sd : mockDirs) {
                    inspector.inspectDirectory(sd);
                }
                return null;
            }
        }).when((Object)mockStorage)).inspectStorageDirs((FSImageStorageInspector)Mockito.anyObject());
        return mockStorage;
    }

    private static class TestCaseDescription {
        private Map<String, FakeRoot> dirRoots = Maps.newHashMap();
        private Set<String> expectedPurgedLogs = Sets.newHashSet();
        private Set<String> expectedPurgedImages = Sets.newHashSet();

        private TestCaseDescription() {
        }

        void addRoot(String root, NNStorage.NameNodeDirType dir) {
            this.dirRoots.put(root, new FakeRoot(dir));
        }

        private void addFile(String path) {
            for (Map.Entry<String, FakeRoot> entry : this.dirRoots.entrySet()) {
                if (!path.startsWith(entry.getKey())) continue;
                entry.getValue().files.add(path);
            }
        }

        void addLog(String path, boolean expectPurge) {
            this.addFile(path);
            if (expectPurge) {
                this.expectedPurgedLogs.add(path);
            }
        }

        void addImage(String path, boolean expectPurge) {
            this.addFile(path);
            if (expectPurge) {
                this.expectedPurgedImages.add(path);
            }
        }

        NNStorage mockStorage() throws IOException {
            ArrayList sds = Lists.newArrayList();
            for (FakeRoot root : this.dirRoots.values()) {
                sds.add(root.mockStorageDir());
            }
            return TestNNStorageRetentionManager.mockStorageForDirs(sds.toArray(new Storage.StorageDirectory[0]));
        }

        public FSEditLog mockEditLog(NNStorageRetentionManager.StoragePurger purger) {
            final ArrayList jms = Lists.newArrayList();
            for (FakeRoot root : this.dirRoots.values()) {
                if (!root.type.isOfType((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) continue;
                FileJournalManager fjm = new FileJournalManager(root.mockStorageDir());
                fjm.purger = purger;
                jms.add(fjm);
            }
            FSEditLog mockLog = (FSEditLog)Mockito.mock(FSEditLog.class);
            ((FSEditLog)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Object[] args = invocation.getArguments();
                    assert (args.length == 1);
                    long txId = (Long)args[0];
                    for (JournalManager jm : jms) {
                        jm.purgeLogsOlderThan(txId);
                    }
                    return null;
                }
            }).when((Object)mockLog)).purgeLogsOlderThan(Mockito.anyLong());
            return mockLog;
        }

        private static class FakeRoot {
            NNStorage.NameNodeDirType type;
            List<String> files;

            FakeRoot(NNStorage.NameNodeDirType type) {
                this.type = type;
                this.files = Lists.newArrayList();
            }

            Storage.StorageDirectory mockStorageDir() {
                return FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)this.type, false, this.files.toArray(new String[0]));
            }
        }
    }
}

