/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGenericJournalConf {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testNotConfigured() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.dir", "dummy://test");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testClassDoesntExist() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.journal-plugin.dummy", "org.apache.hadoop.nonexistent");
        conf.set("dfs.namenode.edits.dir", "dummy://test");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadConstructor() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.journal-plugin.dummy", BadConstructorJournalManager.class.getName());
        conf.set("dfs.namenode.edits.dir", "dummy://test");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            Assert.fail((String)"Should have failed before this point");
        }
        catch (IllegalArgumentException iae) {
            if (!iae.getMessage().contains("Unable to construct journal")) {
                Assert.fail((String)"Should have failed with unable to construct exception");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDummyJournalManager() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.journal-plugin.dummy", DummyJournalManager.class.getName());
        conf.set("dfs.namenode.edits.dir", "dummy://test");
        conf.setInt("dfs.namenode.resource.checked.volumes.minimum", 0);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static class BadConstructorJournalManager
    extends DummyJournalManager {
        public BadConstructorJournalManager() {
            super(null, null);
        }
    }

    public static class DummyJournalManager
    implements JournalManager {
        public DummyJournalManager(Configuration conf, URI u) {
        }

        public EditLogOutputStream startLogSegment(long txId) throws IOException {
            return (EditLogOutputStream)Mockito.mock(EditLogOutputStream.class);
        }

        public void finalizeLogSegment(long firstTxId, long lastTxId) throws IOException {
        }

        public EditLogInputStream getInputStream(long fromTxnId, boolean inProgressOk) throws IOException {
            return null;
        }

        public long getNumberOfTransactions(long fromTxnId, boolean inProgressOk) throws IOException {
            return 0L;
        }

        public void setOutputBufferCapacity(int size) {
        }

        public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
        }

        public void recoverUnfinalizedSegments() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

