/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class TestFsck
extends TestCase {
    static final String auditLogFile = System.getProperty("test.build.dir", "build/test") + "/audit.log";
    static final Pattern fsckPattern = Pattern.compile("ugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=fsck\\ssrc=\\/\\sdst=null\\sperm=null");

    static String runFsck(Configuration conf, int expectedErrCode, boolean checkErrorCode, String ... path) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        ((Log4JLogger)FSPermissionChecker.LOG).getLogger().setLevel(Level.ALL);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])path);
        if (checkErrorCode) {
            TestFsck.assertEquals((int)expectedErrCode, (int)errCode);
        }
        ((Log4JLogger)FSPermissionChecker.LOG).getLogger().setLevel(Level.INFO);
        return bStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsck() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 20, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            long precision = 1L;
            conf.setLong("dfs.namenode.accesstime.precision", 1L);
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            fs = cluster.getFileSystem();
            String fileName = "/srcdat";
            util.createFiles(fs, "/srcdat");
            util.waitReplication(fs, "/srcdat", (short)3);
            Path file = new Path("/srcdat");
            long aTime = fs.getFileStatus(file).getAccessTime();
            Thread.sleep(1L);
            this.setupAuditLogs();
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            this.verifyAuditLogs();
            TestFsck.assertEquals((long)aTime, (long)fs.getFileStatus(file).getAccessTime());
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            System.out.println(outStr);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is CORRUPT"));
            System.out.println(outStr);
            cluster.startDataNodes((Configuration)conf, 4, true, null, null);
            cluster.waitActive();
            cluster.waitClusterUp();
            fs = cluster.getFileSystem();
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void setupAuditLogs() throws IOException {
        File file = new File(auditLogFile);
        if (file.exists()) {
            file.delete();
        }
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%m%n");
        RollingFileAppender appender = new RollingFileAppender((Layout)layout, auditLogFile);
        logger.addAppender((Appender)appender);
    }

    private void verifyAuditLogs() throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        BufferedReader reader = new BufferedReader(new FileReader(auditLogFile));
        String line = reader.readLine();
        TestFsck.assertNotNull((Object)line);
        TestFsck.assertTrue((String)"Expected fsck event not found in audit log", (boolean)fsckPattern.matcher(line).matches());
        TestFsck.assertNull((String)"Unexpected event in audit log", (Object)reader.readLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckNonExistent() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 20, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat");
            util.waitReplication(fs, "/srcdat", (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/non-existent");
            TestFsck.assertEquals((int)-1, (int)outStr.indexOf("is HEALTHY"));
            System.out.println(outStr);
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckPermission() throws Exception {
        DFSTestUtil util = new DFSTestUtil(((Object)((Object)this)).getClass().getSimpleName(), 20, 3, 8192);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        MiniDFSCluster cluster = null;
        try {
            MiniDFSCluster c2 = cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String dir = "/dfsck";
            Path dirpath = new Path("/dfsck");
            FileSystem fs = c2.getFileSystem();
            util.createFiles(fs, "/dfsck");
            util.waitReplication(fs, "/dfsck", (short)3);
            fs.setPermission(dirpath, new FsPermission(448));
            UserGroupInformation fakeUGI = UserGroupInformation.createUserForTesting((String)"ProbablyNotARealUserName", (String[])new String[]{"ShangriLa"});
            fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public Object run() throws Exception {
                    System.out.println(TestFsck.runFsck(this.val$conf, -1, true, "/dfsck"));
                    return null;
                }
            });
            fs.setPermission(dirpath, new FsPermission(511));
            fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public Object run() throws Exception {
                    String outStr = TestFsck.runFsck(this.val$conf, 0, true, "/dfsck");
                    System.out.println(outStr);
                    Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
                    return null;
                }
            });
            util.cleanup(fs, "/dfsck");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckMove() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 5, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String topDir = "/srcdat";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles(fs, topDir);
            util.waitReplication(fs, topDir, (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            String[] fileNames = util.getFileNames(topDir);
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            ExtendedBlock block = dfsClient.getNamenode().getBlockLocations(fileNames[0], 0L, Long.MAX_VALUE).get(0).getBlock();
            for (int i = 0; i < 4; ++i) {
                File blockFile = MiniDFSCluster.getBlockFile(i, block);
                if (blockFile == null || !blockFile.exists()) continue;
                TestFsck.assertTrue((boolean)blockFile.delete());
            }
            outStr = TestFsck.runFsck((Configuration)conf, 1, false, "/");
            while (!outStr.contains("is CORRUPT")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                outStr = TestFsck.runFsck((Configuration)conf, 1, false, "/");
            }
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/", "-move");
            TestFsck.assertTrue((boolean)outStr.contains("is CORRUPT"));
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            util.cleanup(fs, topDir);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cluster.shutdown();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckOpenFiles() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 4, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            String topDir = "/srcdat";
            String randomString = "HADOOP  ";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles(fs, topDir);
            util.waitReplication(fs, topDir, (short)3);
            String outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Path openFile = new Path(topDir + "/openFile");
            FSDataOutputStream out = fs.create(openFile);
            for (int writeCount = 0; writeCount != 100; ++writeCount) {
                out.write(randomString.getBytes());
            }
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, topDir);
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            TestFsck.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, topDir, "-openforwrite");
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
            TestFsck.assertTrue((boolean)outStr.contains("openFile"));
            out.close();
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, topDir);
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            TestFsck.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
            util.cleanup(fs, topDir);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cluster.shutdown();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorruptBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        FileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path file1 = new Path("/testCorruptBlock");
            DFSTestUtil.createFile(fs, file1, 1024L, (short)factor, 0L);
            DFSTestUtil.waitReplication(fs, file1, (short)factor);
            ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, file1);
            outStr = TestFsck.runFsck((Configuration)conf, 0, true, "/");
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            File blockFile = MiniDFSCluster.getBlockFile(0, block);
            if (blockFile != null && blockFile.exists()) {
                RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
                FileChannel channel = raFile.getChannel();
                String badString = "BADBAD";
                int rand = random.nextInt((int)channel.size() / 2);
                raFile.seek(rand);
                raFile.write(badString.getBytes());
                raFile.close();
            }
            try {
                IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            }
            catch (IOException ie) {
                // empty catch block
            }
            dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
            while (replicaCount != factor) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
                replicaCount = blocks.get(0).getLocations().length;
            }
            TestFsck.assertTrue((boolean)blocks.get(0).isCorrupt());
            outStr = TestFsck.runFsck((Configuration)conf, 1, true, "/");
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is CORRUPT"));
            TestFsck.assertTrue((boolean)outStr.contains("testCorruptBlock"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckError() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            String fileName = "/test.txt";
            Path filePath = new Path(fileName);
            FileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, filePath, 1L, (short)1, 1L);
            DFSTestUtil.waitReplication(fs, filePath, (short)1);
            INodeFile node = (INodeFile)cluster.getNamesystem().dir.rootDir.getNode(fileName, true);
            TestFsck.assertEquals((int)node.blocks.length, (int)1);
            node.blocks[0].setNumBytes(-1L);
            String outStr = TestFsck.runFsck((Configuration)conf, -1, true, fileName);
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("FAILED"));
            fs.delete(filePath, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckListCorruptFilesBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        FileSystem fs = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil("testGetCorruptFiles", 3, 1, 1024);
            util.createFiles(fs, "/corruptData", (short)1);
            util.waitReplication(fs, "/corruptData", (short)1);
            String outStr = TestFsck.runFsck(conf, 0, false, "/corruptData", "-list-corruptfileblocks");
            System.out.println("1. good fsck out: " + outStr);
            TestFsck.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                    File[] blocks = data_dir.listFiles();
                    if (blocks == null) continue;
                    for (int idx = 0; idx < blocks.length; ++idx) {
                        if (!blocks[idx].getName().startsWith("blk_")) continue;
                        TestFsck.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
                    }
                }
            }
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            CorruptFileBlocks corruptFileBlocks = namenode.listCorruptFileBlocks("/corruptData", null);
            int numCorrupt = corruptFileBlocks.getFiles().length;
            while (numCorrupt == 0) {
                Thread.sleep(1000L);
                corruptFileBlocks = namenode.listCorruptFileBlocks("/corruptData", null);
                numCorrupt = corruptFileBlocks.getFiles().length;
            }
            outStr = TestFsck.runFsck(conf, -1, true, "/corruptData", "-list-corruptfileblocks");
            System.out.println("2. bad fsck out: " + outStr);
            TestFsck.assertTrue((boolean)outStr.contains("has 3 CORRUPT files"));
            util.createFiles(fs, "/goodData");
            outStr = TestFsck.runFsck(conf, 0, true, "/goodData", "-list-corruptfileblocks");
            System.out.println("3. good fsck out: " + outStr);
            TestFsck.assertTrue((boolean)outStr.contains("has 0 CORRUPT files"));
            util.cleanup(fs, "/corruptData");
            util.cleanup(fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToCheckTheFsckCommandOnIllegalArguments() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            String fileName = "/test.txt";
            Path filePath = new Path(fileName);
            FileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, filePath, 1L, (short)1, 1L);
            DFSTestUtil.waitReplication(fs, filePath, (short)1);
            String outStr = TestFsck.runFsck((Configuration)conf, -1, true, fileName, "-thisIsNotAValidFlag");
            System.out.println(outStr);
            TestFsck.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
            outStr = TestFsck.runFsck((Configuration)conf, -1, true, "/", fileName);
            System.out.println(outStr);
            TestFsck.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
            fs.delete(filePath, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

